//  Copyright John Maddock 2015.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef SC_
#  define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
#endif
   static const boost::array<boost::array<T, 3>, 1076> heuman_lambda_data = {{
      { SC_(-1.9808662414550781250000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(-1.2818678750410757913794876393180852564234e+01) }, 
      { SC_(-1.9808662414550781250000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(-1.2818678686920981395211620493819441783972e+01) }, 
      { SC_(-1.9808662414550781250000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(-1.2818678262147483408885272014604717950142e+01) }, 
      { SC_(-1.9808662414550781250000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(-1.2818676273441119272757356679409827579912e+01) }, 
      { SC_(-1.9808662414550781250000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(-1.2818675447220667527889979356907035957101e+01) }, 
      { SC_(-1.9808662414550781250000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(-1.2818655648818352593674411860402038446249e+01) }, 
      { SC_(-1.9808662414550781250000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(-1.2818507987757229791055027194834001281403e+01) }, 
      { SC_(-1.9808662414550781250000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(-1.2818385366872922291755065634301775464772e+01) }, 
      { SC_(-1.9808662414550781250000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(-1.2815702152773898445634354314743836776450e+01) }, 
      { SC_(-1.9808662414550781250000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(-1.2809758423903909514038762578364688862940e+01) }, 
      { SC_(-1.9808662414550781250000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(-1.2784224180229554914713033823346029800626e+01) }, 
      { SC_(-1.9808662414550781250000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(-1.2726524319280258411531927893277706975739e+01) }, 
      { SC_(-1.8571533203125000000000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(-1.1725545183347730963643632803055191857441e+01) }, 
      { SC_(-1.8571533203125000000000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(-1.1725545204632125473212641684977724911088e+01) }, 
      { SC_(-1.8571533203125000000000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(-1.1725545347033906108186204087779810914740e+01) }, 
      { SC_(-1.8571533203125000000000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(-1.1725546013735001094038616590776247649051e+01) }, 
      { SC_(-1.8571533203125000000000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(-1.1725546290721983670733641977420160184252e+01) }, 
      { SC_(-1.8571533203125000000000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(-1.1725552928380532291558721280705499925653e+01) }, 
      { SC_(-1.8571533203125000000000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(-1.1725602453324205931917369957095612608367e+01) }, 
      { SC_(-1.8571533203125000000000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(-1.1725643606357686857680510944343906534434e+01) }, 
      { SC_(-1.8571533203125000000000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(-1.1726550123018380781158670535111725714355e+01) }, 
      { SC_(-1.8571533203125000000000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(-1.1728598753101845121239173547254956943523e+01) }, 
      { SC_(-1.8571533203125000000000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(-1.1738016878377463689258133408244604487494e+01) }, 
      { SC_(-1.8571533203125000000000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(-1.1762676372364995122369534103573686552922e+01) }, 
      { SC_(-1.6098388671875000000000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(-1.0380581818880663586226249510719943739212e+01) }, 
      { SC_(-1.6098388671875000000000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(-1.0380581789365956800186528563538346882658e+01) }, 
      { SC_(-1.6098388671875000000000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(-1.0380581591899847111594919667164779565114e+01) }, 
      { SC_(-1.6098388671875000000000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(-1.0380580667397099711034905923285101751054e+01) }, 
      { SC_(-1.6098388671875000000000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(-1.0380580283304211750498167868230926253641e+01) }, 
      { SC_(-1.6098388671875000000000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(-1.0380571079002367574282194148299012609182e+01) }, 
      { SC_(-1.6098388671875000000000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(-1.0380502405037287237075379560968826502010e+01) }, 
      { SC_(-1.6098388671875000000000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(-1.0380445341672333231413996191138274610627e+01) }, 
      { SC_(-1.6098388671875000000000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(-1.0379188733380506654751847216832206057503e+01) }, 
      { SC_(-1.6098388671875000000000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(-1.0376351589028790827070800991554558094754e+01) }, 
      { SC_(-1.6098388671875000000000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(-1.0363354046999945327652404053249904619195e+01) }, 
      { SC_(-1.6098388671875000000000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(-1.0329639770791698974496422791739502204924e+01) }, 
      { SC_(-1.5605529785156250000000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(-9.8977455616770604112619930577193510413224e+00) }, 
      { SC_(-1.5605529785156250000000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(-9.8977455696070499876503322159402556609795e+00) }, 
      { SC_(-1.5605529785156250000000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(-9.8977456226621032255386018071992710506264e+00) }, 
      { SC_(-1.5605529785156250000000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(-9.8977458710569570206487266478976435258677e+00) }, 
      { SC_(-1.5605529785156250000000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(-9.8977459742548643427154345241996430967004e+00) }, 
      { SC_(-1.5605529785156250000000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(-9.8977484472725088290974549807827380163867e+00) }, 
      { SC_(-1.5605529785156250000000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(-9.8977668992364423141371502412379214146397e+00) }, 
      { SC_(-1.5605529785156250000000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(-9.8977822323597928623841610199888213942547e+00) }, 
      { SC_(-1.5605529785156250000000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(-9.8981200720169898544459999225931641196792e+00) }, 
      { SC_(-1.5605529785156250000000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(-9.8988841313135999471037719455165420970280e+00) }, 
      { SC_(-1.5605529785156250000000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(-9.9024067909041996266776862446676990111391e+00) }, 
      { SC_(-1.5605529785156250000000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(-9.9117028014919887581453755499738190345508e+00) }, 
      { SC_(-1.5501419067382812500000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(-9.7949212286115285312709689710101945653948e+00) }, 
      { SC_(-1.5501419067382812500000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(-9.7949212445157037994844287833624806979544e+00) }, 
      { SC_(-1.5501419067382812500000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(-9.7949213509214992491240248148133816414868e+00) }, 
      { SC_(-1.5501419067382812500000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(-9.7949218490955240223264962943142822508467e+00) }, 
      { SC_(-1.5501419067382812500000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(-9.7949220560664421403948801174606561734143e+00) }, 
      { SC_(-1.5501419067382812500000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(-9.7949270158792502926071457040519624639061e+00) }, 
      { SC_(-1.5501419067382812500000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(-9.7949640223531038550738618675817921468254e+00) }, 
      { SC_(-1.5501419067382812500000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(-9.7949947734743677862708352798850514010983e+00) }, 
      { SC_(-1.5501419067382812500000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(-9.7956722450351009537700690865233290018615e+00) }, 
      { SC_(-1.5501419067382812500000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(-9.7972038713804053589496233872444840471915e+00) }, 
      { SC_(-1.5501419067382812500000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(-9.8042558384657499187687536389696359274650e+00) }, 
      { SC_(-1.5501419067382812500000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(-9.8227962733004568325904812303820525795709e+00) }, 
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(-9.2914545677189798714585281570351464750268e+00) }, 
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(-9.2914546226677616399494564965911694664031e+00) }, 
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(-9.2914549902986115230440527325286199988453e+00) }, 
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(-9.2914567114794806658275972552380735309461e+00) }, 
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(-9.2914574265573167539410521623474818488673e+00) }, 
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(-9.2914745621340771300619203204359956526358e+00) }, 
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(-9.2916023899858341627192955420275332623394e+00) }, 
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(-9.2917085767851088028042722828447989858549e+00) }, 
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(-9.2940402436620011840442128776666323265719e+00) }, 
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(-9.2992587306076744170657954011095996446836e+00) }, 
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(-9.3224336662305203509172590711338105304425e+00) }, 
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(-9.3782803294673577030409102225529523145931e+00) }, 
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(-9.0968538361358288331530288385040328813105e+00) }, 
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(-9.0968539061761489700847945576038584453893e+00) }, 
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(-9.0968543747748897618408613311233200861239e+00) }, 
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(-9.0968565686469870826204108221903767038292e+00) }, 
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(-9.0968574800973231546221117938649442691604e+00) }, 
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(-9.0968793195144167242698309431484721182525e+00) }, 
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(-9.0970421233903706431388070067528825842207e+00) }, 
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(-9.0971772129264838497619324465139774990501e+00) }, 
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(-9.1001099132972912247217279320592165568964e+00) }, 
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(-9.1064614381018214975552120886814110738949e+00) }, 
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(-9.1320891659329379992238338817836689010839e+00) }, 
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(-9.1847255151742572229378819848913387275342e+00) }, 
      { SC_(-1.4324546813964843750000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(-9.0175043580965608507818688445390536555558e+00) }, 
      { SC_(-1.4324546813964843750000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(-9.0175044342902081503898169277964779596737e+00) }, 
      { SC_(-1.4324546813964843750000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(-9.0175049440501440244180113173893352634826e+00) }, 
      { SC_(-1.4324546813964843750000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(-9.0175073304649988771400259531627098620977e+00) }, 
      { SC_(-1.4324546813964843750000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(-9.0175083218280538597691408022377068079859e+00) }, 
      { SC_(-1.4324546813964843750000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(-9.0175320620757954569952740616288122877366e+00) }, 
      { SC_(-1.4324546813964843750000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(-9.0177082001791545419723761570625595481811e+00) }, 
      { SC_(-1.4324546813964843750000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(-9.0178532569518817499180743927989010809172e+00) }, 
      { SC_(-1.4324546813964843750000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(-9.0207965802977956977675794949782951406728e+00) }, 
      { SC_(-1.4324546813964843750000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(-9.0262772935097295542405106224105023662667e+00) }, 
      { SC_(-1.4324546813964843750000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(-9.0435109401376511284350577482961943551732e+00) }, 
      { SC_(-1.4324546813964843750000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(-9.0719641921743659425942170161240714199835e+00) }, 
      { SC_(-1.3695476531982421875000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(-8.9040303072047729457101583947295750970555e+00) }, 
      { SC_(-1.3695476531982421875000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(-8.9040302370958868241716418694548098596924e+00) }, 
      { SC_(-1.3695476531982421875000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(-8.9040297680384244773036246839842458307505e+00) }, 
      { SC_(-1.3695476531982421875000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(-8.9040275720190048786979701587327500413662e+00) }, 
      { SC_(-1.3695476531982421875000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(-8.9040266596767065235536584022625707388259e+00) }, 
      { SC_(-1.3695476531982421875000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(-8.9040047989132672589318924702104663858484e+00) }, 
      { SC_(-1.3695476531982421875000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(-8.9038418374859837320348652334679990440016e+00) }, 
      { SC_(-1.3695476531982421875000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(-8.9037066193227007908047702119885862366271e+00) }, 
      { SC_(-1.3695476531982421875000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(-8.9007715815567319193822005320023945089903e+00) }, 
      { SC_(-1.3695476531982421875000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(-8.8944177098215947724041061724351095683076e+00) }, 
      { SC_(-1.3695476531982421875000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(-8.8688081727498654358974364056567653338812e+00) }, 
      { SC_(-1.3695476531982421875000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(-8.8162838599139148257214889340881099464492e+00) }, 
      { SC_(-1.2464721679687500000000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(-7.8985260287586665714377232267575772392582e+00) }, 
      { SC_(-1.2464721679687500000000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(-7.8985260366281297208242013608396897351937e+00) }, 
      { SC_(-1.2464721679687500000000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(-7.8985260892782350409980910005673319583421e+00) }, 
      { SC_(-1.2464721679687500000000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(-7.8985263357771907751868802349479468715836e+00) }, 
      { SC_(-1.2464721679687500000000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(-7.8985264381874300147908826819133077676048e+00) }, 
      { SC_(-1.2464721679687500000000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(-7.8985288923295364156601838658093458575583e+00) }, 
      { SC_(-1.2464721679687500000000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(-7.8985472034577405450437311227709527757332e+00) }, 
      { SC_(-1.2464721679687500000000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(-7.8985624195509168637120904334076178751037e+00) }, 
      { SC_(-1.2464721679687500000000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(-7.8988976808320851853026759189109173372597e+00) }, 
      { SC_(-1.2464721679687500000000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(-7.8996559101809348237926556208859801049036e+00) }, 
      { SC_(-1.2464721679687500000000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(-7.9031517141123408917110276046363247726631e+00) }, 
      { SC_(-1.2464721679687500000000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(-7.9123770233876935780368523623808118779600e+00) }, 
      { SC_(-1.1523029327392578125000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(-7.1359092122163740058955682596578151138307e+00) }, 
      { SC_(-1.1523029327392578125000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(-7.1359092792279110060484389130176980271438e+00) }, 
      { SC_(-1.1523029327392578125000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(-7.1359097275632337880584865009661321346977e+00) }, 
      { SC_(-1.1523029327392578125000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(-7.1359118265757892356062411981067171732483e+00) }, 
      { SC_(-1.1523029327392578125000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(-7.1359126986208930273580592737207102090918e+00) }, 
      { SC_(-1.1523029327392578125000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(-7.1359335946202658878707860291780615247226e+00) }, 
      { SC_(-1.1523029327392578125000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(-7.1360894126991284844926032284799165028290e+00) }, 
      { SC_(-1.1523029327392578125000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(-7.1362187684096057386863752546476947690012e+00) }, 
      { SC_(-1.1523029327392578125000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(-7.1390407098446862317809354824957388974720e+00) }, 
      { SC_(-1.1523029327392578125000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(-7.1452366000171920550923820001514473784417e+00) }, 
      { SC_(-1.1523029327392578125000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(-7.1711688405540648302030016966714656597404e+00) }, 
      { SC_(-1.1523029327392578125000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(-7.2272934267049207665164247399772223606791e+00) }, 
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(-7.0132655107852737906491266599048278681584e+00) }, 
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(-7.0132655873075144089485663581199216370155e+00) }, 
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(-7.0132660992630584215891690930425082246381e+00) }, 
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(-7.0132684958920766434760485518612987751698e+00) }, 
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(-7.0132694914670703173778497617030405224986e+00) }, 
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(-7.0132933271150897746655205973432806028379e+00) }, 
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(-7.0134698503342569373332286547717309078940e+00) }, 
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(-7.0136148080507344563324230110888383772605e+00) }, 
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(-7.0164907910995465327304009514716524507049e+00) }, 
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(-7.0216405347115857099020183099475145383164e+00) }, 
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(-7.0371985506004941656539846248303294821246e+00) }, 
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(-7.0623276814815148998571031272380976817155e+00) }, 
      { SC_(-8.8600730895996093750000000000000000000000e+00), SC_(4.7839165199548006057739257812500000000000e-04), SC_(-5.4648335003678624739398687822700731419125e+00) }, 
      { SC_(-8.8600730895996093750000000000000000000000e+00), SC_(7.3421024717390537261962890625000000000000e-04), SC_(-5.4648335418708477225960096373990405087552e+00) }, 
      { SC_(-8.8600730895996093750000000000000000000000e+00), SC_(1.6169343143701553344726562500000000000000e-03), SC_(-5.4648338195436690409489211817825025123514e+00) }, 
      { SC_(-8.8600730895996093750000000000000000000000e+00), SC_(3.5115787759423255920410156250000000000000e-03), SC_(-5.4648351195597124827388371032176523727151e+00) }, 
      { SC_(-8.8600730895996093750000000000000000000000e+00), SC_(4.0457472205162048339843750000000000000000e-03), SC_(-5.4648356596625079049508858220484521123108e+00) }, 
      { SC_(-8.8600730895996093750000000000000000000000e+00), SC_(1.0635107755661010742187500000000000000000e-02), SC_(-5.4648486024694665257784668262586548922581e+00) }, 
      { SC_(-8.8600730895996093750000000000000000000000e+00), SC_(2.8892643749713897705078125000000000000000e-02), SC_(-5.4649451651103779931196450146251300589618e+00) }, 
      { SC_(-8.8600730895996093750000000000000000000000e+00), SC_(3.7872627377510070800781250000000000000000e-02), SC_(-5.4650253959112647658629517473020781638484e+00) }, 
      { SC_(-8.8600730895996093750000000000000000000000e+00), SC_(1.2087455391883850097656250000000000000000e-01), SC_(-5.4667907736450666110472872978184706068342e+00) }, 
      { SC_(-8.8600730895996093750000000000000000000000e+00), SC_(2.1016991138458251953125000000000000000000e-01), SC_(-5.4707668457314521504532666219635851415079e+00) }, 
      { SC_(-8.8600730895996093750000000000000000000000e+00), SC_(4.1968369483947753906250000000000000000000e-01), SC_(-5.4888187086629051774686057069116223592583e+00) }, 
      { SC_(-8.8600730895996093750000000000000000000000e+00), SC_(6.9936919212341308593750000000000000000000e-01), SC_(-5.5345794822398722772462338426948068932073e+00) }, 
      { SC_(-8.1188240051269531250000000000000000000000e+00), SC_(4.7839165199548006057739257812500000000000e-04), SC_(-5.0348662818722447257325840481435604422937e+00) }, 
      { SC_(-8.1188240051269531250000000000000000000000e+00), SC_(7.3421024717390537261962890625000000000000e-04), SC_(-5.0348663567196595693942521992192754936534e+00) }, 
      { SC_(-8.1188240051269531250000000000000000000000e+00), SC_(1.6169343143701553344726562500000000000000e-03), SC_(-5.0348668574771156988869305668926054052034e+00) }, 
      { SC_(-8.1188240051269531250000000000000000000000e+00), SC_(3.5115787759423255920410156250000000000000e-03), SC_(-5.0348692018455911864525617415731639847522e+00) }, 
      { SC_(-8.1188240051269531250000000000000000000000e+00), SC_(4.0457472205162048339843750000000000000000e-03), SC_(-5.0348701757893682682355809510397982445341e+00) }, 
      { SC_(-8.1188240051269531250000000000000000000000e+00), SC_(1.0635107755661010742187500000000000000000e-02), SC_(-5.0348935072367351722980408601449000457569e+00) }, 
      { SC_(-8.1188240051269531250000000000000000000000e+00), SC_(2.8892643749713897705078125000000000000000e-02), SC_(-5.0350671095861284652257221751612896150720e+00) }, 
      { SC_(-8.1188240051269531250000000000000000000000e+00), SC_(3.7872627377510070800781250000000000000000e-02), SC_(-5.0352107298163362415487301965407091931540e+00) }, 
      { SC_(-8.1188240051269531250000000000000000000000e+00), SC_(1.2087455391883850097656250000000000000000e-01), SC_(-5.0382411030114652467534494635649068206550e+00) }, 
      { SC_(-8.1188240051269531250000000000000000000000e+00), SC_(2.1016991138458251953125000000000000000000e-01), SC_(-5.0443529281838707613282819136197840817663e+00) }, 
      { SC_(-8.1188240051269531250000000000000000000000e+00), SC_(4.1968369483947753906250000000000000000000e-01), SC_(-5.0657279965872194263131590459256970997196e+00) }, 
      { SC_(-8.1188240051269531250000000000000000000000e+00), SC_(6.9936919212341308593750000000000000000000e-01), SC_(-5.1036636986351335842700948962610269907889e+00) }, 
      { SC_(-7.6733188629150390625000000000000000000000e+00), SC_(4.7839165199548006057739257812500000000000e-04), SC_(-4.9837247648091098301876487159092095998938e+00) }, 
      { SC_(-7.6733188629150390625000000000000000000000e+00), SC_(7.3421024717390537261962890625000000000000e-04), SC_(-4.9837246885201742523077156917060137291334e+00) }, 
      { SC_(-7.6733188629150390625000000000000000000000e+00), SC_(1.6169343143701553344726562500000000000000e-03), SC_(-4.9837241781233858094974460987280210113382e+00) }, 
      { SC_(-7.6733188629150390625000000000000000000000e+00), SC_(3.5115787759423255920410156250000000000000e-03), SC_(-4.9837217887423280380890747281468717215961e+00) }, 
      { SC_(-7.6733188629150390625000000000000000000000e+00), SC_(4.0457472205162048339843750000000000000000e-03), SC_(-4.9837207961544123469422478105132048694958e+00) }, 
      { SC_(-7.6733188629150390625000000000000000000000e+00), SC_(1.0635107755661010742187500000000000000000e-02), SC_(-4.9836970278627418050080486617342768250421e+00) }, 
      { SC_(-7.6733188629150390625000000000000000000000e+00), SC_(2.8892643749713897705078125000000000000000e-02), SC_(-4.9835207579745870743059445887443499791776e+00) }, 
      { SC_(-7.6733188629150390625000000000000000000000e+00), SC_(3.7872627377510070800781250000000000000000e-02), SC_(-4.9833756915291019311166051568100215860913e+00) }, 
      { SC_(-7.6733188629150390625000000000000000000000e+00), SC_(1.2087455391883850097656250000000000000000e-01), SC_(-4.9804482475642790009799077868740993446167e+00) }, 
      { SC_(-7.6733188629150390625000000000000000000000e+00), SC_(2.1016991138458251953125000000000000000000e-01), SC_(-4.9750509746811777941981495916062405014978e+00) }, 
      { SC_(-7.6733188629150390625000000000000000000000e+00), SC_(4.1968369483947753906250000000000000000000e-01), SC_(-4.9582613266030522301581157754279129210926e+00) }, 
      { SC_(-7.6733188629150390625000000000000000000000e+00), SC_(6.9936919212341308593750000000000000000000e-01), SC_(-4.9307109912893552997637812352171842791073e+00) }, 
      { SC_(-5.5482406616210937500000000000000000000000e+00), SC_(4.7839165199548006057739257812500000000000e-04), SC_(-3.3294539473815557748348476270732356540596e+00) }, 
      { SC_(-5.5482406616210937500000000000000000000000e+00), SC_(7.3421024717390537261962890625000000000000e-04), SC_(-3.3294539993834294514717187537331897646215e+00) }, 
      { SC_(-5.5482406616210937500000000000000000000000e+00), SC_(1.6169343143701553344726562500000000000000e-03), SC_(-3.3294543472982435772813078562495539820500e+00) }, 
      { SC_(-5.5482406616210937500000000000000000000000e+00), SC_(3.5115787759423255920410156250000000000000e-03), SC_(-3.3294559761731323730889942142250574100663e+00) }, 
      { SC_(-5.5482406616210937500000000000000000000000e+00), SC_(4.0457472205162048339843750000000000000000e-03), SC_(-3.3294566529021835773647646275352278263092e+00) }, 
      { SC_(-5.5482406616210937500000000000000000000000e+00), SC_(1.0635107755661010742187500000000000000000e-02), SC_(-3.3294728695961932295443625733056012638608e+00) }, 
      { SC_(-5.5482406616210937500000000000000000000000e+00), SC_(2.8892643749713897705078125000000000000000e-02), SC_(-3.3295938475031712003352070755702075859107e+00) }, 
      { SC_(-5.5482406616210937500000000000000000000000e+00), SC_(3.7872627377510070800781250000000000000000e-02), SC_(-3.3296943503807689162898410589105459489754e+00) }, 
      { SC_(-5.5482406616210937500000000000000000000000e+00), SC_(1.2087455391883850097656250000000000000000e-01), SC_(-3.3319026475487110899792970710766551674539e+00) }, 
      { SC_(-5.5482406616210937500000000000000000000000e+00), SC_(2.1016991138458251953125000000000000000000e-01), SC_(-3.3368547688867036280447337984486410912215e+00) }, 
      { SC_(-5.5482406616210937500000000000000000000000e+00), SC_(4.1968369483947753906250000000000000000000e-01), SC_(-3.3589956175903325901885526448956493844618e+00) }, 
      { SC_(-5.5482406616210937500000000000000000000000e+00), SC_(6.9936919212341308593750000000000000000000e-01), SC_(-3.4131398456078824438154386987427128125026e+00) }, 
      { SC_(-4.0504589080810546875000000000000000000000e+00), SC_(4.7839165199548006057739257812500000000000e-04), SC_(-2.7888073558150348434415788696958679854506e+00) }, 
      { SC_(-4.0504589080810546875000000000000000000000e+00), SC_(7.3421024717390537261962890625000000000000e-04), SC_(-2.7888072946418256724001959307782537321833e+00) }, 
      { SC_(-4.0504589080810546875000000000000000000000e+00), SC_(1.6169343143701553344726562500000000000000e-03), SC_(-2.7888068853670504128306658410329979686212e+00) }, 
      { SC_(-4.0504589080810546875000000000000000000000e+00), SC_(3.5115787759423255920410156250000000000000e-03), SC_(-2.7888049692204948143026258236474656077245e+00) }, 
      { SC_(-4.0504589080810546875000000000000000000000e+00), SC_(4.0457472205162048339843750000000000000000e-03), SC_(-2.7888041731444126940742006533106463420896e+00) }, 
      { SC_(-4.0504589080810546875000000000000000000000e+00), SC_(1.0635107755661010742187500000000000000000e-02), SC_(-2.7887850968948043841753788646935397025543e+00) }, 
      { SC_(-4.0504589080810546875000000000000000000000e+00), SC_(2.8892643749713897705078125000000000000000e-02), SC_(-2.7886428106087837924328607374426400359436e+00) }, 
      { SC_(-4.0504589080810546875000000000000000000000e+00), SC_(3.7872627377510070800781250000000000000000e-02), SC_(-2.7885246380516568951954039923075685606611e+00) }, 
      { SC_(-4.0504589080810546875000000000000000000000e+00), SC_(1.2087455391883850097656250000000000000000e-01), SC_(-2.7859354016669384221137931772408850910830e+00) }, 
      { SC_(-4.0504589080810546875000000000000000000000e+00), SC_(2.1016991138458251953125000000000000000000e-01), SC_(-2.7801778485963638302784597086331241002700e+00) }, 
      { SC_(-4.0504589080810546875000000000000000000000e+00), SC_(4.1968369483947753906250000000000000000000e-01), SC_(-2.7551462625316413252360765189691448424286e+00) }, 
      { SC_(-4.0504589080810546875000000000000000000000e+00), SC_(6.9936919212341308593750000000000000000000e-01), SC_(-2.6973372328232727861834620879815223488323e+00) }, 
      { SC_(-3.1295490264892578125000000000000000000000e+00), SC_(4.7839165199548006057739257812500000000000e-04), SC_(-1.9879566647389932323912696012628346784646e+00) }, 
      { SC_(-3.1295490264892578125000000000000000000000e+00), SC_(7.3421024717390537261962890625000000000000e-04), SC_(-1.9879566656729724790836186844508713865279e+00) }, 
      { SC_(-3.1295490264892578125000000000000000000000e+00), SC_(1.6169343143701553344726562500000000000000e-03), SC_(-1.9879566719216968294754367019790708240994e+00) }, 
      { SC_(-3.1295490264892578125000000000000000000000e+00), SC_(3.5115787759423255920410156250000000000000e-03), SC_(-1.9879567011771762679387314781065605892254e+00) }, 
      { SC_(-3.1295490264892578125000000000000000000000e+00), SC_(4.0457472205162048339843750000000000000000e-03), SC_(-1.9879567133316324404755641949805503112424e+00) }, 
      { SC_(-3.1295490264892578125000000000000000000000e+00), SC_(1.0635107755661010742187500000000000000000e-02), SC_(-1.9879570045990936293603790483606885135491e+00) }, 
      { SC_(-3.1295490264892578125000000000000000000000e+00), SC_(2.8892643749713897705078125000000000000000e-02), SC_(-1.9879591778420387396146661405066665418220e+00) }, 
      { SC_(-3.1295490264892578125000000000000000000000e+00), SC_(3.7872627377510070800781250000000000000000e-02), SC_(-1.9879609837591200742289362041811361407965e+00) }, 
      { SC_(-3.1295490264892578125000000000000000000000e+00), SC_(1.2087455391883850097656250000000000000000e-01), SC_(-1.9880007755424022493483626055707573722798e+00) }, 
      { SC_(-3.1295490264892578125000000000000000000000e+00), SC_(2.1016991138458251953125000000000000000000e-01), SC_(-1.9880907788015162157472013631382154971378e+00) }, 
      { SC_(-3.1295490264892578125000000000000000000000e+00), SC_(4.1968369483947753906250000000000000000000e-01), SC_(-1.9885059103600525164880479442279299729262e+00) }, 
      { SC_(-3.1295490264892578125000000000000000000000e+00), SC_(6.9936919212341308593750000000000000000000e-01), SC_(-1.9896026975554872185733427595902226641083e+00) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(1.6117982430230003848548037126420240383595e-15), SC_(-5.5217794652660717318168150629790446804859e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(2.0170124522423532598125461845484096556902e-15), SC_(-5.5217794652660717318168150629770148113285e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(6.7707324528888321313324638595076976343989e-15), SC_(-5.5217794652660717318168150629193474466418e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(1.3038520458620583841735651731141842901707e-14), SC_(-5.5217794652660717318168150627479511389862e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(1.6015441468668345503800765072810463607311e-14), SC_(-5.5217794652660717318168150626285545993307e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(5.5958587915315438632291034082300029695034e-14), SC_(-5.5217794652660717318168150586599561763262e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(1.0876282513505586280189163517206907272339e-13), SC_(-5.5217794652660717318168150466528625077519e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(1.3881549989352981455681401712354272603989e-13), SC_(-5.5217794652660717318168150363818131149900e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(3.7115547180804897564598832104820758104324e-13), SC_(-5.5217794652660717318168148728175374848805e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(5.9488546901020900037337924004532396793365e-13), SC_(-5.5217794652660717318168145744587624469565e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(9.9820715929177517011794407153502106666565e-13), SC_(-5.5217794652660717318168136874831629831081e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(2.8143772035083003402178292162716388702393e-12), SC_(-5.5217794652660717318168041288666896186872e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(4.6511492574063950655727239791303873062134e-12), SC_(-5.5217794652660717318167851995573613924534e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(8.6466146742569804928280063904821872711182e-12), SC_(-5.5217794652660717318167118554781213591362e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(2.2510084074500724682366126216948032379150e-11), SC_(-5.5217794652660717318161155862057833199974e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(5.8000479419284545201662695035338401794434e-11), SC_(-5.5217794652660717318121711696818456186540e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(1.1394188370594804382562870159745216369629e-10), SC_(-5.5217794652660717317988930884429922363107e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(2.3241869540058246457192581146955490112305e-10), SC_(-5.5217794652660717317422455710328099562216e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(4.5748627108821438014274463057518005371094e-10), SC_(-5.5217794652660717315278966655072808647264e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(9.1627927467641256953356787562370300292969e-10), SC_(-5.5217794652660717306578381288902559007487e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(1.0781109338608985126484185457229614257812e-09), SC_(-5.5217794652660717302122919882680227576795e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(3.2146250106279694591648876667022705078125e-09), SC_(-5.5217794652660717175515546338734046591760e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(7.3410291179243358783423900604248046875000e-09), SC_(-5.5217794652660716574236631578992755795185e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(1.4760416888748295605182647705078125000000e-08), SC_(-5.5217794652660714310594207931843403241048e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(2.9164056059016729705035686492919921875000e-08), SC_(-5.5217794652660705576902486800447450914813e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(3.3076446470658993348479270935058593750000e-08), SC_(-5.5217794652660702215392991317298064367869e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(8.8535273334855446591973304748535156250000e-08), SC_(-5.5217794652660609112071510532981736673435e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(2.1435090502563980408012866973876953125000e-07), SC_(-5.5217794652660083054683794305857938835945e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(4.2922022203129017725586891174316406250000e-07), SC_(-5.5217794652658174124604731975886811890321e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(6.1847185861552134156227111816406250000000e-07), SC_(-5.5217794652655437013850781328986974598765e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(1.0889875738939736038446426391601562500000e-06), SC_(-5.5217794652644346706207360141008196750403e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(1.9164717741659842431545257568359375000000e-06), SC_(-5.5217794652610015454788862643433850117053e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(5.4235879360930994153022766113281250000000e-06), SC_(-5.5217794652254655235191101399776051471728e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(8.4874300227966159582138061523437500000000e-06), SC_(-5.5217794651666293588371292881737594086428e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(2.9231799999251961708068847656250000000000e-05), SC_(-5.5217794640864841732514113695809261759700e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(5.0041606300510466098785400390625000000000e-05), SC_(-5.5217794618092136552907371761718949407903e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(1.0938764899037778377532958984375000000000e-04), SC_(-5.5217794487481409010772641407263630977292e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(2.2930058185011148452758789062500000000000e-04), SC_(-5.5217793926839964820960912540171842019423e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(-5.5217791493394243090291168270482594131576e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(-5.5217787211169606491809322593385777669090e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(-5.5217758561245684301113891560478277852619e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(-5.5217624427280138763710098417911970668029e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(-5.5217568700182901351150103437799539024401e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(-5.5216233279610341917886472575209809584732e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(-5.5206270158474267207731541337575255049389e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(-5.5197992222606699663021451988617405418442e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(-5.5015869958407268082976755393969937457675e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(-5.4605845842214874985695084542077037285715e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(-5.2746921994250884396906129309194304824247e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(-4.8050999820662466075410658422405895848171e-01) }, 
      { SC_(1.6504814008555523940913190017454326152802e-12), SC_(1.7721909098327159881591796875000000000000e-03), SC_(1.6504801049543039750336866220629763956064e-12) }, 
      { SC_(1.6504814008555523940913190017454326152802e-12), SC_(2.2177286446094512939453125000000000000000e-03), SC_(1.6504793714546192912030190820289743855429e-12) }, 
      { SC_(1.6504814008555523940913190017454326152802e-12), SC_(7.4444990605115890502929687500000000000000e-03), SC_(1.6504585329644609136472226650751853046839e-12) }, 
      { SC_(1.6504814008555523940913190017454326152802e-12), SC_(1.4336004853248596191406250000000000000000e-02), SC_(1.6503965954259038794340850632122813341090e-12) }, 
      { SC_(1.6504814008555523940913190017454326152802e-12), SC_(1.7609164118766784667968750000000000000000e-02), SC_(1.6503534469995613931041155311255169794802e-12) }, 
      { SC_(1.6504814008555523940913190017454326152802e-12), SC_(6.1527118086814880371093750000000000000000e-02), SC_(1.6489182804641058583138139589713161736263e-12) }, 
      { SC_(1.6504814008555523940913190017454326152802e-12), SC_(1.1958599090576171875000000000000000000000e-01), SC_(1.6445646784932991894854677464084298047840e-12) }, 
      { SC_(1.6504814008555523940913190017454326152802e-12), SC_(1.5262925624847412109375000000000000000000e-01), SC_(1.6408267264777513210078860083022150109086e-12) }, 
      { SC_(1.6504814008555523940913190017454326152802e-12), SC_(4.0808975696563720703125000000000000000000e-01), SC_(1.5794549524584490824595378972988728091007e-12) }, 
      { SC_(1.6504814008555523940913190017454326152802e-12), SC_(6.5408349037170410156250000000000000000000e-01), SC_(1.4564485729888788756837840924748698676839e-12) }, 
      { SC_(2.0654207510961697380480472929775714874268e-12), SC_(1.7721909098327159881591796875000000000000e-03), SC_(2.0654191293988101260542352167331313751108e-12) }, 
      { SC_(2.0654207510961697380480472929775714874268e-12), SC_(2.2177286446094512939453125000000000000000e-03), SC_(2.0654182114936044792864429824428485697987e-12) }, 
      { SC_(2.0654207510961697380480472929775714874268e-12), SC_(7.4444990605115890502929687500000000000000e-03), SC_(2.0653921341018978440359832323467637533953e-12) }, 
      { SC_(2.0654207510961697380480472929775714874268e-12), SC_(1.4336004853248596191406250000000000000000e-02), SC_(2.0653146251536956985216551794210957447516e-12) }, 
      { SC_(2.0654207510961697380480472929775714874268e-12), SC_(1.7609164118766784667968750000000000000000e-02), SC_(2.0652606289953029294003995388356971256977e-12) }, 
      { SC_(2.0654207510961697380480472929775714874268e-12), SC_(6.1527118086814880371093750000000000000000e-02), SC_(2.0634646543529518505100402677026865086627e-12) }, 
      { SC_(2.0654207510961697380480472929775714874268e-12), SC_(1.1958599090576171875000000000000000000000e-01), SC_(2.0580165348843797580806940881124980924477e-12) }, 
      { SC_(2.0654207510961697380480472929775714874268e-12), SC_(1.5262925624847412109375000000000000000000e-01), SC_(2.0533388428755438454453828930709366847901e-12) }, 
      { SC_(2.0654207510961697380480472929775714874268e-12), SC_(4.0808975696563720703125000000000000000000e-01), SC_(1.9765378952699880416192535633989366199115e-12) }, 
      { SC_(2.0654207510961697380480472929775714874268e-12), SC_(6.5408349037170410156250000000000000000000e-01), SC_(1.8226070914802789896353031850025237824869e-12) }, 
      { SC_(6.9332300317581641024844429921358823776245e-12), SC_(1.7721909098327159881591796875000000000000e-03), SC_(6.9332245880243243424556274412013043836482e-12) }, 
      { SC_(6.9332300317581641024844429921358823776245e-12), SC_(2.2177286446094512939453125000000000000000e-03), SC_(6.9332215067887287768708447997771640534105e-12) }, 
      { SC_(6.9332300317581641024844429921358823776245e-12), SC_(7.4444990605115890502929687500000000000000e-03), SC_(6.9331339698763420830272738547686191620887e-12) }, 
      { SC_(6.9332300317581641024844429921358823776245e-12), SC_(1.4336004853248596191406250000000000000000e-02), SC_(6.9328737868762827011750775221026792052337e-12) }, 
      { SC_(6.9332300317581641024844429921358823776245e-12), SC_(1.7609164118766784667968750000000000000000e-02), SC_(6.9326925319011065142915838027075249282159e-12) }, 
      { SC_(6.9332300317581641024844429921358823776245e-12), SC_(6.1527118086814880371093750000000000000000e-02), SC_(6.9266637819139592975239961067525209289391e-12) }, 
      { SC_(6.9332300317581641024844429921358823776245e-12), SC_(1.1958599090576171875000000000000000000000e-01), SC_(6.9083754668110616128991636731068719360828e-12) }, 
      { SC_(6.9332300317581641024844429921358823776245e-12), SC_(1.5262925624847412109375000000000000000000e-01), SC_(6.8926733321744438098744807353380509536385e-12) }, 
      { SC_(6.9332300317581641024844429921358823776245e-12), SC_(4.0808975696563720703125000000000000000000e-01), SC_(6.6348669573117311075620806840525430946423e-12) }, 
      { SC_(6.9332300317581641024844429921358823776245e-12), SC_(6.5408349037170410156250000000000000000000e-01), SC_(6.1181501231843142793167379671297436052409e-12) }, 
      { SC_(1.3351444949627477853937307372689247131348e-11), SC_(1.7721909098327159881591796875000000000000e-03), SC_(1.3351434466531958297198424461919294477702e-11) }, 
      { SC_(1.3351444949627477853937307372689247131348e-11), SC_(2.2177286446094512939453125000000000000000e-03), SC_(1.3351428532941518835850401958313679348342e-11) }, 
      { SC_(1.3351444949627477853937307372689247131348e-11), SC_(7.4444990605115890502929687500000000000000e-03), SC_(1.3351259961545295461108437173658896185874e-11) }, 
      { SC_(1.3351444949627477853937307372689247131348e-11), SC_(1.4336004853248596191406250000000000000000e-02), SC_(1.3350758922493337040694398060386056883727e-11) }, 
      { SC_(1.3351444949627477853937307372689247131348e-11), SC_(1.7609164118766784667968750000000000000000e-02), SC_(1.3350409876549119714014368587703138559402e-11) }, 
      { SC_(1.3351444949627477853937307372689247131348e-11), SC_(6.1527118086814880371093750000000000000000e-02), SC_(1.3338800204981933629818657296795165140326e-11) }, 
      { SC_(1.3351444949627477853937307372689247131348e-11), SC_(1.1958599090576171875000000000000000000000e-01), SC_(1.3303582069827133355814869661550697650128e-11) }, 
      { SC_(1.3351444949627477853937307372689247131348e-11), SC_(1.5262925624847412109375000000000000000000e-01), SC_(1.3273344188604075435568737873061862959617e-11) }, 
      { SC_(1.3351444949627477853937307372689247131348e-11), SC_(4.0808975696563720703125000000000000000000e-01), SC_(1.2776881846250540167102270661430150801702e-11) }, 
      { SC_(1.3351444949627477853937307372689247131348e-11), SC_(6.5408349037170410156250000000000000000000e-01), SC_(1.1781831006483647860856375238109438031584e-11) }, 
      { SC_(1.6399812063916385795891983434557914733887e-11), SC_(1.7721909098327159881591796875000000000000e-03), SC_(1.6399799187347818315768504935758688612620e-11) }, 
      { SC_(1.6399812063916385795891983434557914733887e-11), SC_(2.2177286446094512939453125000000000000000e-03), SC_(1.6399791899015473872988944568611520271462e-11) }, 
      { SC_(1.6399812063916385795891983434557914733887e-11), SC_(7.4444990605115890502929687500000000000000e-03), SC_(1.6399584839837396487117813392574443824398e-11) }, 
      { SC_(1.6399812063916385795891983434557914733887e-11), SC_(1.4336004853248596191406250000000000000000e-02), SC_(1.6398969404854905682247182113644716624481e-11) }, 
      { SC_(1.6399812063916385795891983434557914733887e-11), SC_(1.7609164118766784667968750000000000000000e-02), SC_(1.6398540665650390135428055184042248601622e-11) }, 
      { SC_(1.6399812063916385795891983434557914733887e-11), SC_(6.1527118086814880371093750000000000000000e-02), SC_(1.6384280304128174691836267564116271739957e-11) }, 
      { SC_(1.6399812063916385795891983434557914733887e-11), SC_(1.1958599090576171875000000000000000000000e-01), SC_(1.6341021256140530009365426661366519096164e-11) }, 
      { SC_(1.6399812063916385795891983434557914733887e-11), SC_(1.5262925624847412109375000000000000000000e-01), SC_(1.6303879540682757616677573459003283679213e-11) }, 
      { SC_(1.6399812063916385795891983434557914733887e-11), SC_(4.0808975696563720703125000000000000000000e-01), SC_(1.5694066210205979257509261540196795167023e-11) }, 
      { SC_(1.6399812063916385795891983434557914733887e-11), SC_(6.5408349037170410156250000000000000000000e-01), SC_(1.4471827956010539398005632950092745350516e-11) }, 
      { SC_(5.7301594025283009159466018900275230407715e-11), SC_(1.7721909098327159881591796875000000000000e-03), SC_(5.7301549034041547562896185376898848367526e-11) }, 
      { SC_(5.7301594025283009159466018900275230407715e-11), SC_(2.2177286446094512939453125000000000000000e-03), SC_(5.7301523568319166420822865446867102613592e-11) }, 
      { SC_(5.7301594025283009159466018900275230407715e-11), SC_(7.4444990605115890502929687500000000000000e-03), SC_(5.7300800095335747015372142513101456623955e-11) }, 
      { SC_(5.7301594025283009159466018900275230407715e-11), SC_(1.4336004853248596191406250000000000000000e-02), SC_(5.7298649741089112823095805230800243452168e-11) }, 
      { SC_(5.7301594025283009159466018900275230407715e-11), SC_(1.7609164118766784667968750000000000000000e-02), SC_(5.7297151709298009128135296884039740859191e-11) }, 
      { SC_(5.7301594025283009159466018900275230407715e-11), SC_(6.1527118086814880371093750000000000000000e-02), SC_(5.7247325440349618673943847904020917068728e-11) }, 
      { SC_(5.7301594025283009159466018900275230407715e-11), SC_(1.1958599090576171875000000000000000000000e-01), SC_(5.7096176610347947643402847478671512594782e-11) }, 
      { SC_(5.7301594025283009159466018900275230407715e-11), SC_(1.5262925624847412109375000000000000000000e-01), SC_(5.6966401982915076646539809448804859852820e-11) }, 
      { SC_(5.7301594025283009159466018900275230407715e-11), SC_(4.0808975696563720703125000000000000000000e-01), SC_(5.4835690011460849756765639609873932210995e-11) }, 
      { SC_(5.7301594025283009159466018900275230407715e-11), SC_(6.5408349037170410156250000000000000000000e-01), SC_(5.0565141058148476541978554619510104918454e-11) }, 
      { SC_(1.1137313293829720350913703441619873046875e-10), SC_(1.7721909098327159881591796875000000000000e-03), SC_(1.1137304549194249738130291883633940722255e-10) }, 
      { SC_(1.1137313293829720350913703441619873046875e-10), SC_(2.2177286446094512939453125000000000000000e-03), SC_(1.1137299599598462100355709503637195922252e-10) }, 
      { SC_(1.1137313293829720350913703441619873046875e-10), SC_(7.4444990605115890502929687500000000000000e-03), SC_(1.1137158983173857779805273893222247971294e-10) }, 
      { SC_(1.1137313293829720350913703441619873046875e-10), SC_(1.4336004853248596191406250000000000000000e-02), SC_(1.1136741033737286867600028384977346408986e-10) }, 
      { SC_(1.1137313293829720350913703441619873046875e-10), SC_(1.7609164118766784667968750000000000000000e-02), SC_(1.1136449871690830057414241941084043129765e-10) }, 
      { SC_(1.1137313293829720350913703441619873046875e-10), SC_(6.1527118086814880371093750000000000000000e-02), SC_(1.1126765485471207727531377865755136561355e-10) }, 
      { SC_(1.1137313293829720350913703441619873046875e-10), SC_(1.1958599090576171875000000000000000000000e-01), SC_(1.1097387735997403188483246871526995423128e-10) }, 
      { SC_(1.1137313293829720350913703441619873046875e-10), SC_(1.5262925624847412109375000000000000000000e-01), SC_(1.1072164341990734020323205568348635916059e-10) }, 
      { SC_(1.1137313293829720350913703441619873046875e-10), SC_(4.0808975696563720703125000000000000000000e-01), SC_(1.0658032638175848921239443438087063345024e-10) }, 
      { SC_(1.1137313293829720350913703441619873046875e-10), SC_(6.5408349037170410156250000000000000000000e-01), SC_(9.8279956655797522126281282012423569071061e-11) }, 
      { SC_(1.4214707189097453010617755353450775146484e-10), SC_(1.7721909098327159881591796875000000000000e-03), SC_(1.4214696028198104060615817027458176706922e-10) }, 
      { SC_(1.4214707189097453010617755353450775146484e-10), SC_(2.2177286446094512939453125000000000000000e-03), SC_(1.4214689710960457110316988108600451995170e-10) }, 
      { SC_(1.4214707189097453010617755353450775146484e-10), SC_(7.4444990605115890502929687500000000000000e-03), SC_(1.4214510240270444681587983415068886017352e-10) }, 
      { SC_(1.4214707189097453010617755353450775146484e-10), SC_(1.4336004853248596191406250000000000000000e-02), SC_(1.4213976805616685303493513166400497217875e-10) }, 
      { SC_(1.4214707189097453010617755353450775146484e-10), SC_(1.7609164118766784667968750000000000000000e-02), SC_(1.4213605191464710705671689498225147594560e-10) }, 
      { SC_(1.4214707189097453010617755353450775146484e-10), SC_(6.1527118086814880371093750000000000000000e-02), SC_(1.4201244875220906336280446677292515294369e-10) }, 
      { SC_(1.4214707189097453010617755353450775146484e-10), SC_(1.1958599090576171875000000000000000000000e-01), SC_(1.4163749646737377068609679165169246870007e-10) }, 
      { SC_(1.4214707189097453010617755353450775146484e-10), SC_(1.5262925624847412109375000000000000000000e-01), SC_(1.4131556679667062413473748664529042341370e-10) }, 
      { SC_(1.4214707189097453010617755353450775146484e-10), SC_(4.0808975696563720703125000000000000000000e-01), SC_(1.3602994651093079507500912469814012749628e-10) }, 
      { SC_(1.4214707189097453010617755353450775146484e-10), SC_(6.5408349037170410156250000000000000000000e-01), SC_(1.2543606968417838636076866805736058864413e-10) }, 
      { SC_(3.8006320313144215106149204075336456298828e-10), SC_(1.7721909098327159881591796875000000000000e-03), SC_(3.8006290471888254215629668518607369849024e-10) }, 
      { SC_(3.8006320313144215106149204075336456298828e-10), SC_(2.2177286446094512939453125000000000000000e-03), SC_(3.8006273581286547808544142419621823110350e-10) }, 
      { SC_(3.8006320313144215106149204075336456298828e-10), SC_(7.4444990605115890502929687500000000000000e-03), SC_(3.8005793724723855821660795413547479562898e-10) }, 
      { SC_(3.8006320313144215106149204075336456298828e-10), SC_(1.4336004853248596191406250000000000000000e-02), SC_(3.8004367463313950735127494170609667423708e-10) }, 
      { SC_(3.8006320313144215106149204075336456298828e-10), SC_(1.7609164118766784667968750000000000000000e-02), SC_(3.8003373866590152108195567349539900487293e-10) }, 
      { SC_(3.8006320313144215106149204075336456298828e-10), SC_(6.1527118086814880371093750000000000000000e-02), SC_(3.7970325691057271790002134677364701890121e-10) }, 
      { SC_(3.8006320313144215106149204075336456298828e-10), SC_(1.1958599090576171875000000000000000000000e-01), SC_(3.7870073491345937159889402163286339851381e-10) }, 
      { SC_(3.8006320313144215106149204075336456298828e-10), SC_(1.5262925624847412109375000000000000000000e-01), SC_(3.7783998118703486706615644500669781731065e-10) }, 
      { SC_(3.8006320313144215106149204075336456298828e-10), SC_(4.0808975696563720703125000000000000000000e-01), SC_(3.6370764803651037212936880547478241219654e-10) }, 
      { SC_(3.8006320313144215106149204075336456298828e-10), SC_(6.5408349037170410156250000000000000000000e-01), SC_(3.3538245845087018668583211449925016903393e-10) }, 
      { SC_(6.0916272026645401638234034180641174316406e-10), SC_(1.7721909098327159881591796875000000000000e-03), SC_(6.0916224197283054719094821564361472263106e-10) }, 
      { SC_(6.0916272026645401638234034180641174316406e-10), SC_(2.2177286446094512939453125000000000000000e-03), SC_(6.0916197125141375026599640627920277198207e-10) }, 
      { SC_(6.0916272026645401638234034180641174316406e-10), SC_(7.4444990605115890502929687500000000000000e-03), SC_(6.0915428014302286330666677289362556161504e-10) }, 
      { SC_(6.0916272026645401638234034180641174316406e-10), SC_(1.4336004853248596191406250000000000000000e-02), SC_(6.0913142012202871372301895822766291109230e-10) }, 
      { SC_(6.0916272026645401638234034180641174316406e-10), SC_(1.7609164118766784667968750000000000000000e-02), SC_(6.0911549482123321201872665416055311189573e-10) }, 
      { SC_(6.0916272026645401638234034180641174316406e-10), SC_(6.1527118086814880371093750000000000000000e-02), SC_(6.0858580090870545193345016028954769551241e-10) }, 
      { SC_(6.0916272026645401638234034180641174316406e-10), SC_(1.1958599090576171875000000000000000000000e-01), SC_(6.0697896546171449899407518382704219594631e-10) }, 
      { SC_(6.0916272026645401638234034180641174316406e-10), SC_(1.5262925624847412109375000000000000000000e-01), SC_(6.0559935523597291514593348429482928750533e-10) }, 
      { SC_(6.0916272026645401638234034180641174316406e-10), SC_(4.0808975696563720703125000000000000000000e-01), SC_(5.8294814766114235665344035380844982172573e-10) }, 
      { SC_(6.0916272026645401638234034180641174316406e-10), SC_(6.5408349037170410156250000000000000000000e-01), SC_(5.3754872620206411165636476139266908327010e-10) }, 
      { SC_(1.0221641311147777742007747292518615722656e-09), SC_(1.7721909098327159881591796875000000000000e-03), SC_(1.0221633285466464917297806597643763722599e-09) }, 
      { SC_(1.0221641311147777742007747292518615722656e-09), SC_(2.2177286446094512939453125000000000000000e-03), SC_(1.0221628742809592327499770681158971007385e-09) }, 
      { SC_(1.0221641311147777742007747292518615722656e-09), SC_(7.4444990605115890502929687500000000000000e-03), SC_(1.0221499687388698517519401885846061309850e-09) }, 
      { SC_(1.0221641311147777742007747292518615722656e-09), SC_(1.4336004853248596191406250000000000000000e-02), SC_(1.0221116100331917865276147434524541665099e-09) }, 
      { SC_(1.0221641311147777742007747292518615722656e-09), SC_(1.7609164118766784667968750000000000000000e-02), SC_(1.0220848876637676444918158310119313777016e-09) }, 
      { SC_(1.0221641311147777742007747292518615722656e-09), SC_(6.1527118086814880371093750000000000000000e-02), SC_(1.0211960707683100627186790198814897082213e-09) }, 
      { SC_(1.0221641311147777742007747292518615722656e-09), SC_(1.1958599090576171875000000000000000000000e-01), SC_(1.0184998296756189198598735010124275785526e-09) }, 
      { SC_(1.0221641311147777742007747292518615722656e-09), SC_(1.5262925624847412109375000000000000000000e-01), SC_(1.0161848684333167353881670036156346328739e-09) }, 
      { SC_(1.0221641311147777742007747292518615722656e-09), SC_(4.0808975696563720703125000000000000000000e-01), SC_(9.7817654793185912677873600309170162596754e-10) }, 
      { SC_(1.0221641311147777742007747292518615722656e-09), SC_(6.5408349037170410156250000000000000000000e-01), SC_(9.0199713207966449547540096808543065094706e-10) }, 
      { SC_(2.8819222563924995483830571174621582031250e-09), SC_(1.7721909098327159881591796875000000000000e-03), SC_(2.8819199936062312654689380137666202180969e-09) }, 
      { SC_(2.8819222563924995483830571174621582031250e-09), SC_(2.2177286446094512939453125000000000000000e-03), SC_(2.8819187128350179385902841099736108974388e-09) }, 
      { SC_(2.8819222563924995483830571174621582031250e-09), SC_(7.4444990605115890502929687500000000000000e-03), SC_(2.8818823265367258681942301563613229414139e-09) }, 
      { SC_(2.8819222563924995483830571174621582031250e-09), SC_(1.4336004853248596191406250000000000000000e-02), SC_(2.8817741767746133368491551192814169967880e-09) }, 
      { SC_(2.8819222563924995483830571174621582031250e-09), SC_(1.7609164118766784667968750000000000000000e-02), SC_(2.8816988348712509209960601110581939828104e-09) }, 
      { SC_(2.8819222563924995483830571174621582031250e-09), SC_(6.1527118086814880371093750000000000000000e-02), SC_(2.8791928760776437697876624256131062824752e-09) }, 
      { SC_(2.8819222563924995483830571174621582031250e-09), SC_(1.1958599090576171875000000000000000000000e-01), SC_(2.8715910076720754360607732170679484307595e-09) }, 
      { SC_(2.8819222563924995483830571174621582031250e-09), SC_(1.5262925624847412109375000000000000000000e-01), SC_(2.8650641318761103797760090810447891123277e-09) }, 
      { SC_(2.8819222563924995483830571174621582031250e-09), SC_(4.0808975696563720703125000000000000000000e-01), SC_(2.7579022569414183017687081945241625265055e-09) }, 
      { SC_(2.8819222563924995483830571174621582031250e-09), SC_(6.5408349037170410156250000000000000000000e-01), SC_(2.5431195744538374281475266651107298956808e-09) }, 
      { SC_(4.7627768395841485471464693546295166015625e-09), SC_(1.7721909098327159881591796875000000000000e-03), SC_(4.7627731000155298466907230039328439655368e-09) }, 
      { SC_(4.7627768395841485471464693546295166015625e-09), SC_(2.2177286446094512939453125000000000000000e-03), SC_(4.7627709833631954165556539813856400853618e-09) }, 
      { SC_(4.7627768395841485471464693546295166015625e-09), SC_(7.4444990605115890502929687500000000000000e-03), SC_(4.7627108499510607656875960897432499048827e-09) }, 
      { SC_(4.7627768395841485471464693546295166015625e-09), SC_(1.4336004853248596191406250000000000000000e-02), SC_(4.7625321174467214997431757718065638717041e-09) }, 
      { SC_(4.7627768395841485471464693546295166015625e-09), SC_(1.7609164118766784667968750000000000000000e-02), SC_(4.7624076044861137830477366499119295155206e-09) }, 
      { SC_(4.7627768395841485471464693546295166015625e-09), SC_(6.1527118086814880371093750000000000000000e-02), SC_(4.7582661594916590617438781134596316921880e-09) }, 
      { SC_(4.7627768395841485471464693546295166015625e-09), SC_(1.1958599090576171875000000000000000000000e-01), SC_(4.7457030160205617933021007060619994983624e-09) }, 
      { SC_(4.7627768395841485471464693546295166015625e-09), SC_(1.5262925624847412109375000000000000000000e-01), SC_(4.7349164471577440722212623113616982546559e-09) }, 
      { SC_(4.7627768395841485471464693546295166015625e-09), SC_(4.0808975696563720703125000000000000000000e-01), SC_(4.5578165636014636787941412575257960915739e-09) }, 
      { SC_(4.7627768395841485471464693546295166015625e-09), SC_(6.5408349037170410156250000000000000000000e-01), SC_(4.2028583465896980645938878614303669714524e-09) }, 
      { SC_(8.8541334264391480246558785438537597656250e-09), SC_(1.7721909098327159881591796875000000000000e-03), SC_(8.8541264744780079387552164190082876057572e-09) }, 
      { SC_(8.8541334264391480246558785438537597656250e-09), SC_(2.2177286446094512939453125000000000000000e-03), SC_(8.8541225395629746186861561775844621512011e-09) }, 
      { SC_(8.8541334264391480246558785438537597656250e-09), SC_(7.4444990605115890502929687500000000000000e-03), SC_(8.8540107498922929787660105964305179099815e-09) }, 
      { SC_(8.8541334264391480246558785438537597656250e-09), SC_(1.4336004853248596191406250000000000000000e-02), SC_(8.8536784812401258432056429863010951523855e-09) }, 
      { SC_(8.8541334264391480246558785438537597656250e-09), SC_(1.7609164118766784667968750000000000000000e-02), SC_(8.8534470082142685276503806099708506269157e-09) }, 
      { SC_(8.8541334264391480246558785438537597656250e-09), SC_(6.1527118086814880371093750000000000000000e-02), SC_(8.8457479478143774622023356418688157879778e-09) }, 
      { SC_(8.8541334264391480246558785438537597656250e-09), SC_(1.1958599090576171875000000000000000000000e-01), SC_(8.8223927178098775296976981257255209168366e-09) }, 
      { SC_(8.8541334264391480246558785438537597656250e-09), SC_(1.5262925624847412109375000000000000000000e-01), SC_(8.8023401889718476199256112626523316442491e-09) }, 
      { SC_(8.8541334264391480246558785438537597656250e-09), SC_(4.0808975696563720703125000000000000000000e-01), SC_(8.4731066238420030552676163013483854411928e-09) }, 
      { SC_(8.8541334264391480246558785438537597656250e-09), SC_(6.5408349037170410156250000000000000000000e-01), SC_(7.8132295143137040642422058495236334660012e-09) }, 
      { SC_(2.3050326092288742074742913246154785156250e-08), SC_(1.7721909098327159881591796875000000000000e-03), SC_(2.3050307993965218193642703682337401626415e-08) }, 
      { SC_(2.3050326092288742074742913246154785156250e-08), SC_(2.2177286446094512939453125000000000000000e-03), SC_(2.3050297750040680910731567994820322473749e-08) }, 
      { SC_(2.3050326092288742074742913246154785156250e-08), SC_(7.4444990605115890502929687500000000000000e-03), SC_(2.3050006723438883057216107031471035265055e-08) }, 
      { SC_(2.3050326092288742074742913246154785156250e-08), SC_(1.4336004853248596191406250000000000000000e-02), SC_(2.3049141714926607011271846236614651425920e-08) }, 
      { SC_(2.3050326092288742074742913246154785156250e-08), SC_(1.7609164118766784667968750000000000000000e-02), SC_(2.3048539111772734539345249593419701834447e-08) }, 
      { SC_(2.3050326092288742074742913246154785156250e-08), SC_(6.1527118086814880371093750000000000000000e-02), SC_(2.3028495834325413852972876730893860924104e-08) }, 
      { SC_(2.3050326092288742074742913246154785156250e-08), SC_(1.1958599090576171875000000000000000000000e-01), SC_(2.2967694213022013725562235917372244775177e-08) }, 
      { SC_(2.3050326092288742074742913246154785156250e-08), SC_(1.5262925624847412109375000000000000000000e-01), SC_(2.2915490648152368158214691615221267068656e-08) }, 
      { SC_(2.3050326092288742074742913246154785156250e-08), SC_(4.0808975696563720703125000000000000000000e-01), SC_(2.2058383501550249235981819118079572038889e-08) }, 
      { SC_(2.3050326092288742074742913246154785156250e-08), SC_(6.5408349037170410156250000000000000000000e-01), SC_(2.0340498551901217555942453176392781304805e-08) }, 
      { SC_(5.9392490925347374286502599716186523437500e-08), SC_(1.7721909098327159881591796875000000000000e-03), SC_(5.9392444292405521922120908759217157404417e-08) }, 
      { SC_(5.9392490925347374286502599716186523437500e-08), SC_(2.2177286446094512939453125000000000000000e-03), SC_(5.9392417897455937063251596944402021911471e-08) }, 
      { SC_(5.9392490925347374286502599716186523437500e-08), SC_(7.4444990605115890502929687500000000000000e-03), SC_(5.9391668025426486853141225223891635139987e-08) }, 
      { SC_(5.9392490925347374286502599716186523437500e-08), SC_(1.4336004853248596191406250000000000000000e-02), SC_(5.9389439206189396308643654842624918564289e-08) }, 
      { SC_(5.9392490925347374286502599716186523437500e-08), SC_(1.7609164118766784667968750000000000000000e-02), SC_(5.9387886512218618615301169916085919933223e-08) }, 
      { SC_(5.9392490925347374286502599716186523437500e-08), SC_(6.1527118086814880371093750000000000000000e-02), SC_(5.9336242115990208805005651984120237846037e-08) }, 
      { SC_(5.9392490925347374286502599716186523437500e-08), SC_(1.1958599090576171875000000000000000000000e-01), SC_(5.9179577966118737985606041375568687827759e-08) }, 
      { SC_(5.9392490925347374286502599716186523437500e-08), SC_(1.5262925624847412109375000000000000000000e-01), SC_(5.9045067949194142409441723633581886679406e-08) }, 
      { SC_(5.9392490925347374286502599716186523437500e-08), SC_(4.0808975696563720703125000000000000000000e-01), SC_(5.6836607720787798805265865358051430278893e-08) }, 
      { SC_(5.9392490925347374286502599716186523437500e-08), SC_(6.5408349037170410156250000000000000000000e-01), SC_(5.2410229288035222953363923193453702152131e-08) }, 
      { SC_(1.1667648891489079687744379043579101562500e-07), SC_(1.7721909098327159881591796875000000000000e-03), SC_(1.1667639730452305537543728755421643664424e-07) }, 
      { SC_(1.1667648891489079687744379043579101562500e-07), SC_(2.2177286446094512939453125000000000000000e-03), SC_(1.1667634545167104218350562150239155677469e-07) }, 
      { SC_(1.1667648891489079687744379043579101562500e-07), SC_(7.4444990605115890502929687500000000000000e-03), SC_(1.1667487232882051708182528997302952383924e-07) }, 
      { SC_(1.1667648891489079687744379043579101562500e-07), SC_(1.4336004853248596191406250000000000000000e-02), SC_(1.1667049381566240493353094986034427205432e-07) }, 
      { SC_(1.1667648891489079687744379043579101562500e-07), SC_(1.7609164118766784667968750000000000000000e-02), SC_(1.1666744354991252467754441665607521893005e-07) }, 
      { SC_(1.1667648891489079687744379043579101562500e-07), SC_(6.1527118086814880371093750000000000000000e-02), SC_(1.1656598818526661035679509302493915884693e-07) }, 
      { SC_(1.1667648891489079687744379043579101562500e-07), SC_(1.1958599090576171875000000000000000000000e-01), SC_(1.1625822161981282250039336803138305715485e-07) }, 
      { SC_(1.1667648891489079687744379043579101562500e-07), SC_(1.5262925624847412109375000000000000000000e-01), SC_(1.1599397682633596885211317910410660694467e-07) }, 
      { SC_(1.1667648891489079687744379043579101562500e-07), SC_(4.0808975696563720703125000000000000000000e-01), SC_(1.1165545892038534720061829314537376332665e-07) }, 
      { SC_(1.1667648891489079687744379043579101562500e-07), SC_(6.5408349037170410156250000000000000000000e-01), SC_(1.0295984292422656457719898855128100132839e-07) }, 
      { SC_(2.3799674409019644372165203094482421875000e-07), SC_(1.7721909098327159881591796875000000000000e-03), SC_(2.3799655722333363959765613033805841970131e-07) }, 
      { SC_(2.3799674409019644372165203094482421875000e-07), SC_(2.2177286446094512939453125000000000000000e-03), SC_(2.3799645145386743692220442105380749232735e-07) }, 
      { SC_(2.3799674409019644372165203094482421875000e-07), SC_(7.4444990605115890502929687500000000000000e-03), SC_(2.3799344657734663603091182915893011042462e-07) }, 
      { SC_(2.3799674409019644372165203094482421875000e-07), SC_(1.4336004853248596191406250000000000000000e-02), SC_(2.3798451528463052676809094624088206180624e-07) }, 
      { SC_(2.3799674409019644372165203094482421875000e-07), SC_(1.7609164118766784667968750000000000000000e-02), SC_(2.3797829335145587595217638366616295965801e-07) }, 
      { SC_(2.3799674409019644372165203094482421875000e-07), SC_(6.1527118086814880371093750000000000000000e-02), SC_(2.3777134466212889167741693803293051879931e-07) }, 
      { SC_(2.3799674409019644372165203094482421875000e-07), SC_(1.1958599090576171875000000000000000000000e-01), SC_(2.3714356231112539723675110074209565894063e-07) }, 
      { SC_(2.3799674409019644372165203094482421875000e-07), SC_(1.5262925624847412109375000000000000000000e-01), SC_(2.3660455568626756922850341980733350639260e-07) }, 
      { SC_(2.3799674409019644372165203094482421875000e-07), SC_(4.0808975696563720703125000000000000000000e-01), SC_(2.2775484529991503393977083365864507863626e-07) }, 
      { SC_(2.3799674409019644372165203094482421875000e-07), SC_(6.5408349037170410156250000000000000000000e-01), SC_(2.1001752466067295465697352028978592169732e-07) }, 
      { SC_(4.6846594159433152526617050170898437500000e-07), SC_(1.7721909098327159881591796875000000000000e-03), SC_(4.6846557377096403981383738885731218412673e-07) }, 
      { SC_(4.6846594159433152526617050170898437500000e-07), SC_(2.2177286446094512939453125000000000000000e-03), SC_(4.6846536557739077905311093359803879044387e-07) }, 
      { SC_(4.6846594159433152526617050170898437500000e-07), SC_(7.4444990605115890502929687500000000000000e-03), SC_(4.6845945086492665322361555576669809980366e-07) }, 
      { SC_(4.6846594159433152526617050170898437500000e-07), SC_(1.4336004853248596191406250000000000000000e-02), SC_(4.6844187076538411097586615503986218869255e-07) }, 
      { SC_(4.6846594159433152526617050170898437500000e-07), SC_(1.7609164118766784667968750000000000000000e-02), SC_(4.6842962369118844432774569691131392698780e-07) }, 
      { SC_(4.6846594159433152526617050170898437500000e-07), SC_(6.1527118086814880371093750000000000000000e-02), SC_(4.6802227184703660105516341438588081785989e-07) }, 
      { SC_(4.6846594159433152526617050170898437500000e-07), SC_(1.1958599090576171875000000000000000000000e-01), SC_(4.6678656313470358514182991311489094125318e-07) }, 
      { SC_(4.6846594159433152526617050170898437500000e-07), SC_(1.5262925624847412109375000000000000000000e-01), SC_(4.6572559800677770688458370835015042114929e-07) }, 
      { SC_(4.6846594159433152526617050170898437500000e-07), SC_(4.0808975696563720703125000000000000000000e-01), SC_(4.4830608277421447158241716202496887900639e-07) }, 
      { SC_(4.6846594159433152526617050170898437500000e-07), SC_(6.5408349037170410156250000000000000000000e-01), SC_(4.1339245130254359383625249250344433363579e-07) }, 
      { SC_(9.3826997726864647120237350463867187500000e-07), SC_(1.7721909098327159881591796875000000000000e-03), SC_(9.3826924057118263782840353646390998382659e-07) }, 
      { SC_(9.3826997726864647120237350463867187500000e-07), SC_(2.2177286446094512939453125000000000000000e-03), SC_(9.3826882358936623080534781908353099141694e-07) }, 
      { SC_(9.3826997726864647120237350463867187500000e-07), SC_(7.4444990605115890502929687500000000000000e-03), SC_(9.3825697727005776976689718371563437735476e-07) }, 
      { SC_(9.3826997726864647120237350463867187500000e-07), SC_(1.4336004853248596191406250000000000000000e-02), SC_(9.3822176685637855379896325374526729009465e-07) }, 
      { SC_(9.3826997726864647120237350463867187500000e-07), SC_(1.7609164118766784667968750000000000000000e-02), SC_(9.3819723772628199493153328407942425177945e-07) }, 
      { SC_(9.3826997726864647120237350463867187500000e-07), SC_(6.1527118086814880371093750000000000000000e-02), SC_(9.3738137050602712214482531251140137550717e-07) }, 
      { SC_(9.3826997726864647120237350463867187500000e-07), SC_(1.1958599090576171875000000000000000000000e-01), SC_(9.3490642348749819768947342113526169398015e-07) }, 
      { SC_(9.3826997726864647120237350463867187500000e-07), SC_(1.5262925624847412109375000000000000000000e-01), SC_(9.3278146276340834671470419692174633841739e-07) }, 
      { SC_(9.3826997726864647120237350463867187500000e-07), SC_(4.0808975696563720703125000000000000000000e-01), SC_(8.9789267638619309167551173054530736097018e-07) }, 
      { SC_(9.3826997726864647120237350463867187500000e-07), SC_(6.5408349037170410156250000000000000000000e-01), SC_(8.2796568853346493713341896710018062483330e-07) }, 
      { SC_(1.1039855962735600769519805908203125000000e-06), SC_(1.7721909098327159881591796875000000000000e-03), SC_(1.1039847294618033181778269337056158447215e-06) }, 
      { SC_(1.1039855962735600769519805908203125000000e-06), SC_(2.2177286446094512939453125000000000000000e-03), SC_(1.1039842388333803973110497301099514111020e-06) }, 
      { SC_(1.1039855962735600769519805908203125000000e-06), SC_(7.4444990605115890502929687500000000000000e-03), SC_(1.1039703002376646217277315582715699181372e-06) }, 
      { SC_(1.1039855962735600769519805908203125000000e-06), SC_(1.4336004853248596191406250000000000000000e-02), SC_(1.1039288710216794277876257387134581282322e-06) }, 
      { SC_(1.1039855962735600769519805908203125000000e-06), SC_(1.7609164118766784667968750000000000000000e-02), SC_(1.1039000095990912826470090536226676858604e-06) }, 
      { SC_(1.1039855962735600769519805908203125000000e-06), SC_(6.1527118086814880371093750000000000000000e-02), SC_(1.1029400453228655012346538328320129512672e-06) }, 
      { SC_(1.1039855962735600769519805908203125000000e-06), SC_(1.1958599090576171875000000000000000000000e-01), SC_(1.1000279774466771860393599541377301257620e-06) }, 
      { SC_(1.1039855962735600769519805908203125000000e-06), SC_(1.5262925624847412109375000000000000000000e-01), SC_(1.0975277098383378410319008254928864598727e-06) }, 
      { SC_(1.1039855962735600769519805908203125000000e-06), SC_(4.0808975696563720703125000000000000000000e-01), SC_(1.0564769264124072259945789925527939912552e-06) }, 
      { SC_(1.1039855962735600769519805908203125000000e-06), SC_(6.5408349037170410156250000000000000000000e-01), SC_(9.7419955502626483010789073885026155920997e-07) }, 
      { SC_(3.2917760108830407261848449707031250000000e-06), SC_(1.7721909098327159881591796875000000000000e-03), SC_(3.2917734262877513550166511411129542587572e-06) }, 
      { SC_(3.2917760108830407261848449707031250000000e-06), SC_(2.2177286446094512939453125000000000000000e-03), SC_(3.2917719633711351625858111648861607481121e-06) }, 
      { SC_(3.2917760108830407261848449707031250000000e-06), SC_(7.4444990605115890502929687500000000000000e-03), SC_(3.2917304023805231580660248630438168001995e-06) }, 
      { SC_(3.2917760108830407261848449707031250000000e-06), SC_(1.4336004853248596191406250000000000000000e-02), SC_(3.2916068720556802767157455547744643033380e-06) }, 
      { SC_(3.2917760108830407261848449707031250000000e-06), SC_(1.7609164118766784667968750000000000000000e-02), SC_(3.2915208153726618145550895095203453122161e-06) }, 
      { SC_(3.2917760108830407261848449707031250000000e-06), SC_(6.1527118086814880371093750000000000000000e-02), SC_(3.2886584706224712433728782886179077407189e-06) }, 
      { SC_(3.2917760108830407261848449707031250000000e-06), SC_(1.1958599090576171875000000000000000000000e-01), SC_(3.2799754993869400826099296050593339323329e-06) }, 
      { SC_(3.2917760108830407261848449707031250000000e-06), SC_(1.5262925624847412109375000000000000000000e-01), SC_(3.2725204012754371705246925162855400879480e-06) }, 
      { SC_(3.2917760108830407261848449707031250000000e-06), SC_(4.0808975696563720703125000000000000000000e-01), SC_(3.1501184563902155716353035797614544914395e-06) }, 
      { SC_(3.2917760108830407261848449707031250000000e-06), SC_(6.5408349037170410156250000000000000000000e-01), SC_(2.9047903667115153199729273343362240064617e-06) }, 
      { SC_(7.5172138167545199394226074218750000000000e-06), SC_(1.7721909098327159881591796875000000000000e-03), SC_(7.5172079144258932767357460186563397138589e-06) }, 
      { SC_(7.5172138167545199394226074218750000000000e-06), SC_(2.2177286446094512939453125000000000000000e-03), SC_(7.5172045736587926112913630065114792106059e-06) }, 
      { SC_(7.5172138167545199394226074218750000000000e-06), SC_(7.4444990605115890502929687500000000000000e-03), SC_(7.5171096635398078212685069470554274300068e-06) }, 
      { SC_(7.5172138167545199394226074218750000000000e-06), SC_(1.4336004853248596191406250000000000000000e-02), SC_(7.5168275654074865682622206951062044723737e-06) }, 
      { SC_(7.5172138167545199394226074218750000000000e-06), SC_(1.7609164118766784667968750000000000000000e-02), SC_(7.5166310433827598667843475911640138263921e-06) }, 
      { SC_(7.5172138167545199394226074218750000000000e-06), SC_(6.1527118086814880371093750000000000000000e-02), SC_(7.5100944936803666922222344008256370769332e-06) }, 
      { SC_(7.5172138167545199394226074218750000000000e-06), SC_(1.1958599090576171875000000000000000000000e-01), SC_(7.4902657595484240434616732190274516995503e-06) }, 
      { SC_(7.5172138167545199394226074218750000000000e-06), SC_(1.5262925624847412109375000000000000000000e-01), SC_(7.4732410390500308244810630673158945941457e-06) }, 
      { SC_(7.5172138167545199394226074218750000000000e-06), SC_(4.0808975696563720703125000000000000000000e-01), SC_(7.1937197143190169625981711449236549679425e-06) }, 
      { SC_(7.5172138167545199394226074218750000000000e-06), SC_(6.5408349037170410156250000000000000000000e-01), SC_(6.6334799837763163105181507463717960615237e-06) }, 
      { SC_(1.5114666894078254699707031250000000000000e-05), SC_(1.7721909098327159881591796875000000000000e-03), SC_(1.5114655025985989746121088946253678937005e-05) }, 
      { SC_(1.5114666894078254699707031250000000000000e-05), SC_(2.2177286446094512939453125000000000000000e-03), SC_(1.5114648308792209350601656087732062254793e-05) }, 
      { SC_(1.5114666894078254699707031250000000000000e-05), SC_(7.4444990605115890502929687500000000000000e-03), SC_(1.5114457475477066178884543032258929792588e-05) }, 
      { SC_(1.5114666894078254699707031250000000000000e-05), SC_(1.4336004853248596191406250000000000000000e-02), SC_(1.5113890268077450669209462927900214558278e-05) }, 
      { SC_(1.5114666894078254699707031250000000000000e-05), SC_(1.7609164118766784667968750000000000000000e-02), SC_(1.5113495126338314780330716353144656216561e-05) }, 
      { SC_(1.5114666894078254699707031250000000000000e-05), SC_(6.1527118086814880371093750000000000000000e-02), SC_(1.5100352255349969603669027750733957877948e-05) }, 
      { SC_(1.5114666894078254699707031250000000000000e-05), SC_(1.1958599090576171875000000000000000000000e-01), SC_(1.5060483133806726652279013424002858170401e-05) }, 
      { SC_(1.5114666894078254699707031250000000000000e-05), SC_(1.5262925624847412109375000000000000000000e-01), SC_(1.5026251969766044109947065774494391380292e-05) }, 
      { SC_(1.5114666894078254699707031250000000000000e-05), SC_(4.0808975696563720703125000000000000000000e-01), SC_(1.4464225690358044851775125826392290679108e-05) }, 
      { SC_(1.5114666894078254699707031250000000000000e-05), SC_(6.5408349037170410156250000000000000000000e-01), SC_(1.3337766191674283544910400418505211108629e-05) }, 
      { SC_(2.9863993404433131217956542968750000000000e-05), SC_(1.7721909098327159881591796875000000000000e-03), SC_(2.9863969951813235609984205580295077931216e-05) }, 
      { SC_(2.9863993404433131217956542968750000000000e-05), SC_(2.2177286446094512939453125000000000000000e-03), SC_(2.9863956679788642699885806743540504775357e-05) }, 
      { SC_(2.9863993404433131217956542968750000000000e-05), SC_(7.4444990605115890502929687500000000000000e-03), SC_(2.9863579625838060142179757198242638867248e-05) }, 
      { SC_(2.9863993404433131217956542968750000000000e-05), SC_(1.4336004853248596191406250000000000000000e-02), SC_(2.9862458921150494309579402285760846729374e-05) }, 
      { SC_(2.9863993404433131217956542968750000000000e-05), SC_(1.7609164118766784667968750000000000000000e-02), SC_(2.9861678188741850361302400924990844548573e-05) }, 
      { SC_(2.9863993404433131217956542968750000000000e-05), SC_(6.1527118086814880371093750000000000000000e-02), SC_(2.9835710126381086863011029373646420115014e-05) }, 
      { SC_(2.9863993404433131217956542968750000000000e-05), SC_(1.1958599090576171875000000000000000000000e-01), SC_(2.9756935569785386232992654590698965045719e-05) }, 
      { SC_(2.9863993404433131217956542968750000000000e-05), SC_(1.5262925624847412109375000000000000000000e-01), SC_(2.9689300651716624644543732886170869126785e-05) }, 
      { SC_(2.9863993404433131217956542968750000000000e-05), SC_(4.0808975696563720703125000000000000000000e-01), SC_(2.8578832970450929860255484078344901642554e-05) }, 
      { SC_(2.9863993404433131217956542968750000000000e-05), SC_(6.5408349037170410156250000000000000000000e-01), SC_(2.6353141907079589067499251535992816587062e-05) }, 
      { SC_(3.3870281185954809188842773437500000000000e-05), SC_(1.7721909098327159881591796875000000000000e-03), SC_(3.3870254585698594162287845982042878050735e-05) }, 
      { SC_(3.3870281185954809188842773437500000000000e-05), SC_(2.2177286446094512939453125000000000000000e-03), SC_(3.3870239533217207566737405289182302459983e-05) }, 
      { SC_(3.3870281185954809188842773437500000000000e-05), SC_(7.4444990605115890502929687500000000000000e-03), SC_(3.3869811897061687018071773957930773073011e-05) }, 
      { SC_(3.3870281185954809188842773437500000000000e-05), SC_(1.4336004853248596191406250000000000000000e-02), SC_(3.3868540848599460206553749207767973158842e-05) }, 
      { SC_(3.3870281185954809188842773437500000000000e-05), SC_(1.7609164118766784667968750000000000000000e-02), SC_(3.3867655380073783841665253931419057432564e-05) }, 
      { SC_(3.3870281185954809188842773437500000000000e-05), SC_(6.1527118086814880371093750000000000000000e-02), SC_(3.3838203673395960719202743933800292925233e-05) }, 
      { SC_(3.3870281185954809188842773437500000000000e-05), SC_(1.1958599090576171875000000000000000000000e-01), SC_(3.3748861422815279883373549428635395897230e-05) }, 
      { SC_(3.3870281185954809188842773437500000000000e-05), SC_(1.5262925624847412109375000000000000000000e-01), SC_(3.3672153205603615021204579335498031554690e-05) }, 
      { SC_(3.3870281185954809188842773437500000000000e-05), SC_(4.0808975696563720703125000000000000000000e-01), SC_(3.2412715055421686962233347679592955726951e-05) }, 
      { SC_(3.3870281185954809188842773437500000000000e-05), SC_(6.5408349037170410156250000000000000000000e-01), SC_(2.9888445071750738596642978399044436844062e-05) }, 
      { SC_(9.0660119894891977310180664062500000000000e-05), SC_(1.7721909098327159881591796875000000000000e-03), SC_(9.0660048587489904425936476229202038468911e-05) }, 
      { SC_(9.0660119894891977310180664062500000000000e-05), SC_(2.2177286446094512939453125000000000000000e-03), SC_(9.0660008296718235787955713622851540668183e-05) }, 
      { SC_(9.0660119894891977310180664062500000000000e-05), SC_(7.4444990605115890502929687500000000000000e-03), SC_(9.0658863648852092311464770672873834119246e-05) }, 
      { SC_(9.0660119894891977310180664062500000000000e-05), SC_(1.4336004853248596191406250000000000000000e-02), SC_(9.0655461450765540576148111916528690201884e-05) }, 
      { SC_(9.0660119894891977310180664062500000000000e-05), SC_(1.7609164118766784667968750000000000000000e-02), SC_(9.0653091329237303372322795717199036330948e-05) }, 
      { SC_(9.0660119894891977310180664062500000000000e-05), SC_(6.1527118086814880371093750000000000000000e-02), SC_(9.0574258347583128580274443517291336282678e-05) }, 
      { SC_(9.0660119894891977310180664062500000000000e-05), SC_(1.1958599090576171875000000000000000000000e-01), SC_(9.0335117163751544053721790441369827535507e-05) }, 
      { SC_(9.0660119894891977310180664062500000000000e-05), SC_(1.5262925624847412109375000000000000000000e-01), SC_(9.0129793324764418258236553979117520640485e-05) }, 
      { SC_(9.0660119894891977310180664062500000000000e-05), SC_(4.0808975696563720703125000000000000000000e-01), SC_(8.6758672403280740019276035920871002936978e-05) }, 
      { SC_(9.0660119894891977310180664062500000000000e-05), SC_(6.5408349037170410156250000000000000000000e-01), SC_(8.0001993366645063890023951807231366000334e-05) }, 
      { SC_(2.1949532674625515937805175781250000000000e-04), SC_(1.7721909098327159881591796875000000000000e-03), SC_(2.1949515264359119626308747449835952569849e-04) }, 
      { SC_(2.1949532674625515937805175781250000000000e-04), SC_(2.2177286446094512939453125000000000000000e-03), SC_(2.1949505509644429615227821702482612461281e-04) }, 
      { SC_(2.1949532674625515937805175781250000000000e-04), SC_(7.4444990605115890502929687500000000000000e-03), SC_(2.1949228381337069717244331406091659582110e-04) }, 
      { SC_(2.1949532674625515937805175781250000000000e-04), SC_(1.4336004853248596191406250000000000000000e-02), SC_(2.1948404682254657681183968327602171655530e-04) }, 
      { SC_(2.1949532674625515937805175781250000000000e-04), SC_(1.7609164118766784667968750000000000000000e-02), SC_(2.1947830857075069818932005460860171499478e-04) }, 
      { SC_(2.1949532674625515937805175781250000000000e-04), SC_(6.1527118086814880371093750000000000000000e-02), SC_(2.1928744768317764528123703601810422723528e-04) }, 
      { SC_(2.1949532674625515937805175781250000000000e-04), SC_(1.1958599090576171875000000000000000000000e-01), SC_(2.1870846795112576632848173010865168234412e-04) }, 
      { SC_(2.1949532674625515937805175781250000000000e-04), SC_(1.5262925624847412109375000000000000000000e-01), SC_(2.1821136268739510697850430121144978303549e-04) }, 
      { SC_(2.1949532674625515937805175781250000000000e-04), SC_(4.0808975696563720703125000000000000000000e-01), SC_(2.1004961215498256941999770200377320433692e-04) }, 
      { SC_(2.1949532674625515937805175781250000000000e-04), SC_(6.5408349037170410156250000000000000000000e-01), SC_(1.9369115756859740980967481597908761829198e-04) }, 
      { SC_(4.3952150736004114151000976562500000000000e-04), SC_(1.7721909098327159881591796875000000000000e-03), SC_(4.3952114811181102226915208915278468357685e-04) }, 
      { SC_(4.3952150736004114151000976562500000000000e-04), SC_(2.2177286446094512939453125000000000000000e-03), SC_(4.3952095278160220361213482370419379377260e-04) }, 
      { SC_(4.3952150736004114151000976562500000000000e-04), SC_(7.4444990605115890502929687500000000000000e-03), SC_(4.3951540351318520947468193632534443602910e-04) }, 
      { SC_(4.3952150736004114151000976562500000000000e-04), SC_(1.4336004853248596191406250000000000000000e-02), SC_(4.3949890961060756048296030085305744720986e-04) }, 
      { SC_(4.3952150736004114151000976562500000000000e-04), SC_(1.7609164118766784667968750000000000000000e-02), SC_(4.3948741922921618931672758844751092914610e-04) }, 
      { SC_(4.3952150736004114151000976562500000000000e-04), SC_(6.1527118086814880371093750000000000000000e-02), SC_(4.3910523586246319300969421694022657860167e-04) }, 
      { SC_(4.3952150736004114151000976562500000000000e-04), SC_(1.1958599090576171875000000000000000000000e-01), SC_(4.3794587615299749003985929162016992004752e-04) }, 
      { SC_(4.3952150736004114151000976562500000000000e-04), SC_(1.5262925624847412109375000000000000000000e-01), SC_(4.3695046339185882674834769865209614559570e-04) }, 
      { SC_(4.3952150736004114151000976562500000000000e-04), SC_(4.0808975696563720703125000000000000000000e-01), SC_(4.2060722347728472363531213971251655221390e-04) }, 
      { SC_(4.3952150736004114151000976562500000000000e-04), SC_(6.5408349037170410156250000000000000000000e-01), SC_(3.8785075255701577147007553188375460410575e-04) }, 
      { SC_(6.3331518322229385375976562500000000000000e-04), SC_(1.7721909098327159881591796875000000000000e-03), SC_(6.3331464362915480991941258948130629476613e-04) }, 
      { SC_(6.3331518322229385375976562500000000000000e-04), SC_(2.2177286446094512939453125000000000000000e-03), SC_(6.3331436217402547340212386810116264938872e-04) }, 
      { SC_(6.3331518322229385375976562500000000000000e-04), SC_(7.4444990605115890502929687500000000000000e-03), SC_(6.3330636612431319403406175628111732260131e-04) }, 
      { SC_(6.3331518322229385375976562500000000000000e-04), SC_(1.4336004853248596191406250000000000000000e-02), SC_(6.3328259973655744775736634587748613936165e-04) }, 
      { SC_(6.3331518322229385375976562500000000000000e-04), SC_(1.7609164118766784667968750000000000000000e-02), SC_(6.3326604302062442271747741693757486898501e-04) }, 
      { SC_(6.3331518322229385375976562500000000000000e-04), SC_(6.1527118086814880371093750000000000000000e-02), SC_(6.3271534751096704733338804472910533434602e-04) }, 
      { SC_(6.3331518322229385375976562500000000000000e-04), SC_(1.1958599090576171875000000000000000000000e-01), SC_(6.3104480336604463684565118579603885428279e-04) }, 
      { SC_(6.3331518322229385375976562500000000000000e-04), SC_(1.5262925624847412109375000000000000000000e-01), SC_(6.2961049359605836417108642599748680922174e-04) }, 
      { SC_(6.3331518322229385375976562500000000000000e-04), SC_(4.0808975696563720703125000000000000000000e-01), SC_(6.0606119886057476648946427277272921595340e-04) }, 
      { SC_(6.3331518322229385375976562500000000000000e-04), SC_(6.5408349037170410156250000000000000000000e-01), SC_(5.5886175885783688023592945249859664492110e-04) }, 
      { SC_(1.1151232756674289703369140625000000000000e-03), SC_(1.7721909098327159881591796875000000000000e-03), SC_(1.1151221690018853723710575682241977125131e-03) }, 
      { SC_(1.1151232756674289703369140625000000000000e-03), SC_(2.2177286446094512939453125000000000000000e-03), SC_(1.1151216734238066730043780934935283200305e-03) }, 
      { SC_(1.1151232756674289703369140625000000000000e-03), SC_(7.4444990605115890502929687500000000000000e-03), SC_(1.1151075942099622008229978852319209281680e-03) }, 
      { SC_(1.1151232756674289703369140625000000000000e-03), SC_(1.4336004853248596191406250000000000000000e-02), SC_(1.1150657470394780299114197250194200821078e-03) }, 
      { SC_(1.1151232756674289703369140625000000000000e-03), SC_(1.7609164118766784667968750000000000000000e-02), SC_(1.1150365944513190401423137946232581841542e-03) }, 
      { SC_(1.1151232756674289703369140625000000000000e-03), SC_(6.1527118086814880371093750000000000000000e-02), SC_(1.1140669456727278245704087126925843305640e-03) }, 
      { SC_(1.1151232756674289703369140625000000000000e-03), SC_(1.1958599090576171875000000000000000000000e-01), SC_(1.1111254997075345230208678883542694723817e-03) }, 
      { SC_(1.1151232756674289703369140625000000000000e-03), SC_(1.5262925624847412109375000000000000000000e-01), SC_(1.1086000084289871679269054574316822946900e-03) }, 
      { SC_(1.1151232756674289703369140625000000000000e-03), SC_(4.0808975696563720703125000000000000000000e-01), SC_(1.0671350907447942030090091263713286933819e-03) }, 
      { SC_(1.1151232756674289703369140625000000000000e-03), SC_(6.5408349037170410156250000000000000000000e-01), SC_(9.8402768783226705372333856309813172918936e-04) }, 
      { SC_(1.9624670967459678649902343750000000000000e-03), SC_(1.7721909098327159881591796875000000000000e-03), SC_(1.9624642962180760381217651198566284767129e-03) }, 
      { SC_(1.9624670967459678649902343750000000000000e-03), SC_(2.2177286446094512939453125000000000000000e-03), SC_(1.9624634240676404484004955941186884397684e-03) }, 
      { SC_(1.9624670967459678649902343750000000000000e-03), SC_(7.4444990605115890502929687500000000000000e-03), SC_(1.9624386465542382713205161880131820862630e-03) }, 
      { SC_(1.9624670967459678649902343750000000000000e-03), SC_(1.4336004853248596191406250000000000000000e-02), SC_(1.9623650011903114901935594515322236292363e-03) }, 
      { SC_(1.9624670967459678649902343750000000000000e-03), SC_(1.7609164118766784667968750000000000000000e-02), SC_(1.9623136965754670521946730756304200122468e-03) }, 
      { SC_(1.9624670967459678649902343750000000000000e-03), SC_(6.1527118086814880371093750000000000000000e-02), SC_(1.9606072457885743681914102123662943689686e-03) }, 
      { SC_(1.9624670967459678649902343750000000000000e-03), SC_(1.1958599090576171875000000000000000000000e-01), SC_(1.9554306985201959523136715293021570146494e-03) }, 
      { SC_(1.9624670967459678649902343750000000000000e-03), SC_(1.5262925624847412109375000000000000000000e-01), SC_(1.9509861753272813678319473194129790050407e-03) }, 
      { SC_(1.9624670967459678649902343750000000000000e-03), SC_(4.0808975696563720703125000000000000000000e-01), SC_(1.8780135337479957060901310403649491644208e-03) }, 
      { SC_(1.9624670967459678649902343750000000000000e-03), SC_(6.5408349037170410156250000000000000000000e-01), SC_(1.7317557947467106268106436965469735453030e-03) }, 
      { SC_(5.5537540465593338012695312500000000000000e-03), SC_(1.7721909098327159881591796875000000000000e-03), SC_(5.5537211358404287974633126359637782309969e-03) }, 
      { SC_(5.5537540465593338012695312500000000000000e-03), SC_(2.2177286446094512939453125000000000000000e-03), SC_(5.5537186676781713550989045906455775173266e-03) }, 
      { SC_(5.5537540465593338012695312500000000000000e-03), SC_(7.4444990605115890502929687500000000000000e-03), SC_(5.5536485479821929899363504758751549593160e-03) }, 
      { SC_(5.5537540465593338012695312500000000000000e-03), SC_(1.4336004853248596191406250000000000000000e-02), SC_(5.5534401335849146313118633479058887839333e-03) }, 
      { SC_(5.5537540465593338012695312500000000000000e-03), SC_(1.7609164118766784667968750000000000000000e-02), SC_(5.5532949429063451459902368125114389108844e-03) }, 
      { SC_(5.5537540465593338012695312500000000000000e-03), SC_(6.1527118086814880371093750000000000000000e-02), SC_(5.5484657332444356587542832079837480048173e-03) }, 
      { SC_(5.5537540465593338012695312500000000000000e-03), SC_(1.1958599090576171875000000000000000000000e-01), SC_(5.5338162455976119411134414069703831330209e-03) }, 
      { SC_(5.5537540465593338012695312500000000000000e-03), SC_(1.5262925624847412109375000000000000000000e-01), SC_(5.5212383677838278125088435203554885077042e-03) }, 
      { SC_(5.5537540465593338012695312500000000000000e-03), SC_(4.0808975696563720703125000000000000000000e-01), SC_(5.3147280227796457746566410793785923561514e-03) }, 
      { SC_(5.5537540465593338012695312500000000000000e-03), SC_(6.5408349037170410156250000000000000000000e-01), SC_(4.9008242345969095380198292952533091881293e-03) }, 
      { SC_(8.6911283433437347412109375000000000000000e-03), SC_(1.7721909098327159881591796875000000000000e-03), SC_(8.6910121047733173318419609310628635651555e-03) }, 
      { SC_(8.6911283433437347412109375000000000000000e-03), SC_(2.2177286446094512939453125000000000000000e-03), SC_(8.6910082423489122579780752800548271710969e-03) }, 
      { SC_(8.6911283433437347412109375000000000000000e-03), SC_(7.4444990605115890502929687500000000000000e-03), SC_(8.6908985121137754327863259571005137091898e-03) }, 
      { SC_(8.6911283433437347412109375000000000000000e-03), SC_(1.4336004853248596191406250000000000000000e-02), SC_(8.6905723646533664651258683527150541841727e-03) }, 
      { SC_(8.6911283433437347412109375000000000000000e-03), SC_(1.7609164118766784667968750000000000000000e-02), SC_(8.6903451559212724816341087170390735259959e-03) }, 
      { SC_(8.6911283433437347412109375000000000000000e-03), SC_(6.1527118086814880371093750000000000000000e-02), SC_(8.6827879313720957340956031965548156105003e-03) }, 
      { SC_(8.6911283433437347412109375000000000000000e-03), SC_(1.1958599090576171875000000000000000000000e-01), SC_(8.6598629688806091750049111211454812793761e-03) }, 
      { SC_(8.6911283433437347412109375000000000000000e-03), SC_(1.5262925624847412109375000000000000000000e-01), SC_(8.6401798699763003327332769215044247193487e-03) }, 
      { SC_(8.6911283433437347412109375000000000000000e-03), SC_(4.0808975696563720703125000000000000000000e-01), SC_(8.3170127484631042682440867620621415687922e-03) }, 
      { SC_(8.6911283433437347412109375000000000000000e-03), SC_(6.5408349037170410156250000000000000000000e-01), SC_(7.6692995087909210951253509408378402019427e-03) }, 
      { SC_(2.9933363199234008789062500000000000000000e-02), SC_(1.7721909098327159881591796875000000000000e-03), SC_(2.9928869820355435893405837970974629418219e-02) }, 
      { SC_(2.9933363199234008789062500000000000000000e-02), SC_(2.2177286446094512939453125000000000000000e-03), SC_(2.9928856519488330240854120725575199147588e-02) }, 
      { SC_(2.9933363199234008789062500000000000000000e-02), SC_(7.4444990605115890502929687500000000000000e-03), SC_(2.9928478646135663874115527028639121943987e-02) }, 
      { SC_(2.9933363199234008789062500000000000000000e-02), SC_(1.4336004853248596191406250000000000000000e-02), SC_(2.9927355506017534251198514595955500066374e-02) }, 
      { SC_(2.9933363199234008789062500000000000000000e-02), SC_(1.7609164118766784667968750000000000000000e-02), SC_(2.9926573077024999241204206348776354028993e-02) }, 
      { SC_(2.9933363199234008789062500000000000000000e-02), SC_(6.1527118086814880371093750000000000000000e-02), SC_(2.9900548605209844531275137957692756242551e-02) }, 
      { SC_(2.9933363199234008789062500000000000000000e-02), SC_(1.1958599090576171875000000000000000000000e-01), SC_(2.9821603177246748150099250131745711442858e-02) }, 
      { SC_(2.9933363199234008789062500000000000000000e-02), SC_(1.5262925624847412109375000000000000000000e-01), SC_(2.9753821847379675545719662746799560987652e-02) }, 
      { SC_(2.9933363199234008789062500000000000000000e-02), SC_(4.0808975696563720703125000000000000000000e-01), SC_(2.8640988613649963688149189090030163969010e-02) }, 
      { SC_(2.9933363199234008789062500000000000000000e-02), SC_(6.5408349037170410156250000000000000000000e-01), SC_(2.6410760715920237854667135053299829021626e-02) }, 
      { SC_(5.1242604851722717285156250000000000000000e-02), SC_(1.7721909098327159881591796875000000000000e-03), SC_(5.1220142068617189985665798072377811901816e-02) }, 
      { SC_(5.1242604851722717285156250000000000000000e-02), SC_(2.2177286446094512939453125000000000000000e-03), SC_(5.1220119305569186613329839958400183096955e-02) }, 
      { SC_(5.1242604851722717285156250000000000000000e-02), SC_(7.4444990605115890502929687500000000000000e-03), SC_(5.1219472614717929334751638997715248448788e-02) }, 
      { SC_(5.1242604851722717285156250000000000000000e-02), SC_(1.4336004853248596191406250000000000000000e-02), SC_(5.1217550477655890623558363018556933979914e-02) }, 
      { SC_(5.1242604851722717285156250000000000000000e-02), SC_(1.7609164118766784667968750000000000000000e-02), SC_(5.1216211432264604492954308198443811166652e-02) }, 
      { SC_(5.1242604851722717285156250000000000000000e-02), SC_(6.1527118086814880371093750000000000000000e-02), SC_(5.1171673339622649267651574123456341378158e-02) }, 
      { SC_(5.1242604851722717285156250000000000000000e-02), SC_(1.1958599090576171875000000000000000000000e-01), SC_(5.1036567525486063567878182899083519188796e-02) }, 
      { SC_(5.1242604851722717285156250000000000000000e-02), SC_(1.5262925624847412109375000000000000000000e-01), SC_(5.0920568732946775546419591943813202598924e-02) }, 
      { SC_(5.1242604851722717285156250000000000000000e-02), SC_(4.0808975696563720703125000000000000000000e-01), SC_(4.9016228441922350116337304731971863929653e-02) }, 
      { SC_(5.1242604851722717285156250000000000000000e-02), SC_(6.5408349037170410156250000000000000000000e-01), SC_(4.5200418087965584659864734738099343587625e-02) }, 
      { SC_(1.1201295256614685058593750000000000000000e-01), SC_(1.7721909098327159881591796875000000000000e-03), SC_(1.1177877578952760839824768128856280639933e-01) }, 
      { SC_(1.1201295256614685058593750000000000000000e-01), SC_(2.2177286446094512939453125000000000000000e-03), SC_(1.1177872611325798249447864971180309427315e-01) }, 
      { SC_(1.1201295256614685058593750000000000000000e-01), SC_(7.4444990605115890502929687500000000000000e-03), SC_(1.1177731482664650507457352121778878117539e-01) }, 
      { SC_(1.1201295256614685058593750000000000000000e-01), SC_(1.4336004853248596191406250000000000000000e-02), SC_(1.1177312010990921145423416613241509906367e-01) }, 
      { SC_(1.1201295256614685058593750000000000000000e-01), SC_(1.7609164118766784667968750000000000000000e-02), SC_(1.1177019788722186988742356858799212100671e-01) }, 
      { SC_(1.1201295256614685058593750000000000000000e-01), SC_(6.1527118086814880371093750000000000000000e-02), SC_(1.1167300248372619901006941070691965649741e-01) }, 
      { SC_(1.1201295256614685058593750000000000000000e-01), SC_(1.1958599090576171875000000000000000000000e-01), SC_(1.1137817163519903987073963584111402717027e-01) }, 
      { SC_(1.1201295256614685058593750000000000000000e-01), SC_(1.5262925624847412109375000000000000000000e-01), SC_(1.1112504891519063234453386619205681536126e-01) }, 
      { SC_(1.1201295256614685058593750000000000000000e-01), SC_(4.0808975696563720703125000000000000000000e-01), SC_(1.0697115663153432357036535623271503016581e-01) }, 
      { SC_(1.1201295256614685058593750000000000000000e-01), SC_(6.5408349037170410156250000000000000000000e-01), SC_(9.8656316910569964029888070987549916356626e-02) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(1.6117982430230003848548037126420240383595e-15), SC_(1.4598371083569871804104340419516466398160e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(2.0170124522423532598125461845484096556902e-15), SC_(1.4598371083569871804104340419511099870323e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(6.7707324528888321313324638595076976343989e-15), SC_(1.4598371083569871804104340419358640034793e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(1.3038520458620583841735651731141842901707e-14), SC_(1.4598371083569871804104340418905505874465e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(1.6015441468668345503800765072810463607311e-14), SC_(1.4598371083569871804104340418589847669904e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(5.5958587915315438632291034082300029695034e-14), SC_(1.4598371083569871804104340408097745834776e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(1.0876282513505586280189163517206907272339e-13), SC_(1.4598371083569871804104340376353629628827e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(1.3881549989352981455681401712354272603989e-13), SC_(1.4598371083569871804104340349199232863003e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(3.7115547180804897564598832104820758104324e-13), SC_(1.4598371083569871804104339916771243537539e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(5.9488546901020900037337924004532396793365e-13), SC_(1.4598371083569871804104339127976228915730e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(9.9820715929177517011794407153502106666565e-13), SC_(1.4598371083569871804104336783007722930464e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(2.8143772035083003402178292162716388702393e-12), SC_(1.4598371083569871804104311512126985759640e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(4.6511492574063950655727239791303873062134e-12), SC_(1.4598371083569871804104261467194248517164e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(8.6466146742569804928280063904821872711182e-12), SC_(1.4598371083569871804104067561571565854137e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(2.2510084074500724682366126216948032379150e-11), SC_(1.4598371083569871804102491156690118557395e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(5.8000479419284545201662695035338401794434e-11), SC_(1.4598371083569871804092062986480348564880e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(1.1394188370594804382562870159745216369629e-10), SC_(1.4598371083569871804056958658532830913040e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(2.3241869540058246457192581146955490112305e-10), SC_(1.4598371083569871803907195075014383021834e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(4.5748627108821438014274463057518005371094e-10), SC_(1.4598371083569871803340503687952992360811e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(9.1627927467641256953356787562370300292969e-10), SC_(1.4598371083569871801040260177349284116827e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(1.0781109338608985126484185457229614257812e-09), SC_(1.4598371083569871799862334123516500104708e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(3.2146250106279694591648876667022705078125e-09), SC_(1.4598371083569871766390127699176569435665e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(7.3410291179243358783423900604248046875000e-09), SC_(1.4598371083569871607425200222379551514875e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(1.4760416888748295605182647705078125000000e-08), SC_(1.4598371083569871008967903823993931839928e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(2.9164056059016729705035686492919921875000e-08), SC_(1.4598371083569868699971800727461016452741e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(3.3076446470658993348479270935058593750000e-08), SC_(1.4598371083569867811262584347299724711902e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(8.8535273334855446591973304748535156250000e-08), SC_(1.4598371083569843196791024246690456167230e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(2.1435090502563980408012866973876953125000e-07), SC_(1.4598371083569704118781744046824580321450e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(4.2922022203129017725586891174316406250000e-07), SC_(1.4598371083569199439631806316977808969623e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(6.1847185861552134156227111816406250000000e-07), SC_(1.4598371083568475807716871115305219300097e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(1.0889875738939736038446426391601562500000e-06), SC_(1.4598371083565543774168120197375805003449e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(1.9164717741659842431545257568359375000000e-06), SC_(1.4598371083556467345978196734315938758328e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(5.4235879360930994153022766113281250000000e-06), SC_(1.4598371083462517915605665305365783152784e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(8.4874300227966159582138061523437500000000e-06), SC_(1.4598371083306968029817302319432973752000e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(2.9231799999251961708068847656250000000000e-05), SC_(1.4598371080451301601264175218066172337474e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(5.0041606300510466098785400390625000000000e-05), SC_(1.4598371074430698949597444221549528871870e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(1.0938764899037778377532958984375000000000e-04), SC_(1.4598371039900093679606718520768731625308e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(2.2930058185011148452758789062500000000000e-04), SC_(1.4598370891678819113171002292019519698154e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(1.4598370248329244524795456658421844143825e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(1.4598369116203093806647416576586993772511e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(1.4598361541790515047879139509909546146116e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(1.4598326079663383103117639461197937973346e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(1.4598311346599826234510354923483080764134e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(1.4597958285992397720601114936373264863953e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(1.4595323995586846991765450668926022184452e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(1.4593134973847229535632832691136885016061e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(1.4544905414057031428066956210379156195896e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(1.4435842347625269442537531381562476382027e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(1.3933240739113958174330043072478416075801e-01) }, 
      { SC_(1.4650726318359375000000000000000000000000e-01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(1.2608583756074806004745245796331301319433e-01) }, 
      { SC_(2.3480379581451416015625000000000000000000e-01), SC_(1.7721909098327159881591796875000000000000e-03), SC_(2.3265198697717894087067310190140405066247e-01) }, 
      { SC_(2.3480379581451416015625000000000000000000e-01), SC_(2.2177286446094512939453125000000000000000e-03), SC_(2.3265188358293692494295576436126826218851e-01) }, 
      { SC_(2.3480379581451416015625000000000000000000e-01), SC_(7.4444990605115890502929687500000000000000e-03), SC_(2.3264894618796837625438422063367342433185e-01) }, 
      { SC_(2.3480379581451416015625000000000000000000e-01), SC_(1.4336004853248596191406250000000000000000e-02), SC_(2.3264021549344040284610882319437406319547e-01) }, 
      { SC_(2.3480379581451416015625000000000000000000e-01), SC_(1.7609164118766784667968750000000000000000e-02), SC_(2.3263413332798634566100237079958315949639e-01) }, 
      { SC_(2.3480379581451416015625000000000000000000e-01), SC_(6.1527118086814880371093750000000000000000e-02), SC_(2.3243184383674082019645069589568902362796e-01) }, 
      { SC_(2.3480379581451416015625000000000000000000e-01), SC_(1.1958599090576171875000000000000000000000e-01), SC_(2.3181831806249422396427370876751487069456e-01) }, 
      { SC_(2.3480379581451416015625000000000000000000e-01), SC_(1.5262925624847412109375000000000000000000e-01), SC_(2.3129169884653061530591168504131149654438e-01) }, 
      { SC_(2.3480379581451416015625000000000000000000e-01), SC_(4.0808975696563720703125000000000000000000e-01), SC_(2.2266427482702586341207716409175163169326e-01) }, 
      { SC_(2.3480379581451416015625000000000000000000e-01), SC_(6.5408349037170410156250000000000000000000e-01), SC_(2.0547214736060172756491292718544332415967e-01) }, 
      { SC_(4.8987305164337158203125000000000000000000e-01), SC_(1.7721909098327159881591796875000000000000e-03), SC_(4.7051350424154895390557586631339625346495e-01) }, 
      { SC_(4.8987305164337158203125000000000000000000e-01), SC_(2.2177286446094512939453125000000000000000e-03), SC_(4.7051329513796251152553719929317401777702e-01) }, 
      { SC_(4.8987305164337158203125000000000000000000e-01), SC_(7.4444990605115890502929687500000000000000e-03), SC_(4.7050735459439259585324252463086028300847e-01) }, 
      { SC_(4.8987305164337158203125000000000000000000e-01), SC_(1.4336004853248596191406250000000000000000e-02), SC_(4.7048969796969683452810382493382050295370e-01) }, 
      { SC_(4.8987305164337158203125000000000000000000e-01), SC_(1.7609164118766784667968750000000000000000e-02), SC_(4.7047739780734426629135373920428856788219e-01) }, 
      { SC_(4.8987305164337158203125000000000000000000e-01), SC_(6.1527118086814880371093750000000000000000e-02), SC_(4.7006838426375881434805362203760967921725e-01) }, 
      { SC_(4.8987305164337158203125000000000000000000e-01), SC_(1.1958599090576171875000000000000000000000e-01), SC_(4.6882886635927051714408967903264722483763e-01) }, 
      { SC_(4.8987305164337158203125000000000000000000e-01), SC_(1.5262925624847412109375000000000000000000e-01), SC_(4.6776609971797738374107832097197811226814e-01) }, 
      { SC_(4.8987305164337158203125000000000000000000e-01), SC_(4.0808975696563720703125000000000000000000e-01), SC_(4.5050266770906465376490102495131580074721e-01) }, 
      { SC_(4.8987305164337158203125000000000000000000e-01), SC_(6.5408349037170410156250000000000000000000e-01), SC_(4.1683811756428840052258975001908892812800e-01) }, 
      { SC_(7.5183129310607910156250000000000000000000e-01), SC_(1.7721909098327159881591796875000000000000e-03), SC_(6.8297701682233923813405011789174779021923e-01) }, 
      { SC_(7.5183129310607910156250000000000000000000e-01), SC_(2.2177286446094512939453125000000000000000e-03), SC_(6.8297671329699375030970121423666511666336e-01) }, 
      { SC_(7.5183129310607910156250000000000000000000e-01), SC_(7.4444990605115890502929687500000000000000e-03), SC_(6.8296809033806854092327004679635002007381e-01) }, 
      { SC_(7.5183129310607910156250000000000000000000e-01), SC_(1.4336004853248596191406250000000000000000e-02), SC_(6.8294246173292032589769204394520889618070e-01) }, 
      { SC_(7.5183129310607910156250000000000000000000e-01), SC_(1.7609164118766784667968750000000000000000e-02), SC_(6.8292460870763440386646101225430008950869e-01) }, 
      { SC_(7.5183129310607910156250000000000000000000e-01), SC_(6.1527118086814880371093750000000000000000e-02), SC_(6.8233126037716722060297550007840934298668e-01) }, 
      { SC_(7.5183129310607910156250000000000000000000e-01), SC_(1.1958599090576171875000000000000000000000e-01), SC_(6.8053679560799724422769401964950062977495e-01) }, 
      { SC_(7.5183129310607910156250000000000000000000e-01), SC_(1.5262925624847412109375000000000000000000e-01), SC_(6.7900256689205573919184687093043844653995e-01) }, 
      { SC_(7.5183129310607910156250000000000000000000e-01), SC_(4.0808975696563720703125000000000000000000e-01), SC_(6.5459566566699534277187571139945923572781e-01) }, 
      { SC_(7.5183129310607910156250000000000000000000e-01), SC_(6.5408349037170410156250000000000000000000e-01), SC_(6.0924565005163880446036129308640959914987e-01) }, 
      { SC_(1.8752593994140625000000000000000000000000e+00), SC_(4.7839165199548006057739257812500000000000e-04), SC_(1.0459920038879219791845595351493465327166e+00) }, 
      { SC_(1.8752593994140625000000000000000000000000e+00), SC_(7.3421024717390537261962890625000000000000e-04), SC_(1.0459920778725714045755522003237790898529e+00) }, 
      { SC_(1.8752593994140625000000000000000000000000e+00), SC_(1.6169343143701553344726562500000000000000e-03), SC_(1.0459925728588248884974253812392112662655e+00) }, 
      { SC_(1.8752593994140625000000000000000000000000e+00), SC_(3.5115787759423255920410156250000000000000e-03), SC_(1.0459948902322666974841487552152629706611e+00) }, 
      { SC_(1.8752593994140625000000000000000000000000e+00), SC_(4.0457472205162048339843750000000000000000e-03), SC_(1.0459958529727105388371199039929714034338e+00) }, 
      { SC_(1.8752593994140625000000000000000000000000e+00), SC_(1.0635107755661010742187500000000000000000e-02), SC_(1.0460189180495315200448703125915348517237e+00) }, 
      { SC_(1.8752593994140625000000000000000000000000e+00), SC_(2.8892643749713897705078125000000000000000e-02), SC_(1.0461906592293845013393264813494452848995e+00) }, 
      { SC_(1.8752593994140625000000000000000000000000e+00), SC_(3.7872627377510070800781250000000000000000e-02), SC_(1.0463328995517725494073962089758083026907e+00) }, 
      { SC_(1.8752593994140625000000000000000000000000e+00), SC_(1.2087455391883850097656250000000000000000e-01), SC_(1.0493656200778302783596985966746800558716e+00) }, 
      { SC_(1.8752593994140625000000000000000000000000e+00), SC_(2.1016991138458251953125000000000000000000e-01), SC_(1.0556341165112979461298579285449387116488e+00) }, 
      { SC_(1.8752593994140625000000000000000000000000e+00), SC_(4.1968369483947753906250000000000000000000e-01), SC_(1.0785043549737586306906947156899040511151e+00) }, 
      { SC_(1.8752593994140625000000000000000000000000e+00), SC_(6.9936919212341308593750000000000000000000e-01), SC_(1.1205788527294401270482318555704193446452e+00) }, 
      { SC_(1.8888244628906250000000000000000000000000e+00), SC_(4.7839165199548006057739257812500000000000e-04), SC_(1.0501461996490881847858819956117300260176e+00) }, 
      { SC_(1.8888244628906250000000000000000000000000e+00), SC_(7.3421024717390537261962890625000000000000e-04), SC_(1.0501462733115866688868502012010816247387e+00) }, 
      { SC_(1.8888244628906250000000000000000000000000e+00), SC_(1.6169343143701553344726562500000000000000e-03), SC_(1.0501467661427888513162674539940621587513e+00) }, 
      { SC_(1.8888244628906250000000000000000000000000e+00), SC_(3.5115787759423255920410156250000000000000e-03), SC_(1.0501490734330646597326207524364390734509e+00) }, 
      { SC_(1.8888244628906250000000000000000000000000e+00), SC_(4.0457472205162048339843750000000000000000e-03), SC_(1.0501500319874768646788525869218294359778e+00) }, 
      { SC_(1.8888244628906250000000000000000000000000e+00), SC_(1.0635107755661010742187500000000000000000e-02), SC_(1.0501729972967182395289944488849154102128e+00) }, 
      { SC_(1.8888244628906250000000000000000000000000e+00), SC_(2.8892643749713897705078125000000000000000e-02), SC_(1.0503440268974880360300035322124348868900e+00) }, 
      { SC_(1.8888244628906250000000000000000000000000e+00), SC_(3.7872627377510070800781250000000000000000e-02), SC_(1.0504857193560328341864330238744660144934e+00) }, 
      { SC_(1.8888244628906250000000000000000000000000e+00), SC_(1.2087455391883850097656250000000000000000e-01), SC_(1.0535151443037171598936889638059983950382e+00) }, 
      { SC_(1.8888244628906250000000000000000000000000e+00), SC_(2.1016991138458251953125000000000000000000e-01), SC_(1.0598195708669024322954614758591552250932e+00) }, 
      { SC_(1.8888244628906250000000000000000000000000e+00), SC_(4.1968369483947753906250000000000000000000e-01), SC_(1.0831178893298234139097426093126305691472e+00) }, 
      { SC_(1.8888244628906250000000000000000000000000e+00), SC_(6.9936919212341308593750000000000000000000e-01), SC_(1.1264939477047037630195451826220918376348e+00) }, 
      { SC_(5.2943706512451171875000000000000000000000e+00), SC_(4.7839165199548006057739257812500000000000e-04), SC_(3.1646250426380453106842622038010461809591e+00) }, 
      { SC_(5.2943706512451171875000000000000000000000e+00), SC_(7.3421024717390537261962890625000000000000e-04), SC_(3.1646251074226345080207793825736671149043e+00) }, 
      { SC_(5.2943706512451171875000000000000000000000e+00), SC_(1.6169343143701553344726562500000000000000e-03), SC_(3.1646255408589061251769499689498561157551e+00) }, 
      { SC_(5.2943706512451171875000000000000000000000e+00), SC_(3.5115787759423255920410156250000000000000e-03), SC_(3.1646275701210225125352855230985655169517e+00) }, 
      { SC_(5.2943706512451171875000000000000000000000e+00), SC_(4.0457472205162048339843750000000000000000e-03), SC_(3.1646284131898108367893518585978324542322e+00) }, 
      { SC_(5.2943706512451171875000000000000000000000e+00), SC_(1.0635107755661010742187500000000000000000e-02), SC_(3.1646486151812856825073843792504506263668e+00) }, 
      { SC_(5.2943706512451171875000000000000000000000e+00), SC_(2.8892643749713897705078125000000000000000e-02), SC_(3.1647992777719339024142305467413026375446e+00) }, 
      { SC_(5.2943706512451171875000000000000000000000e+00), SC_(3.7872627377510070800781250000000000000000e-02), SC_(3.1649243797757031931615834019662374356452e+00) }, 
      { SC_(5.2943706512451171875000000000000000000000e+00), SC_(1.2087455391883850097656250000000000000000e-01), SC_(3.1676593402776430457719432975371140231660e+00) }, 
      { SC_(5.2943706512451171875000000000000000000000e+00), SC_(2.1016991138458251953125000000000000000000e-01), SC_(3.1737012531269594058536646785314241875128e+00) }, 
      { SC_(5.2943706512451171875000000000000000000000e+00), SC_(4.1968369483947753906250000000000000000000e-01), SC_(3.1994447506948615789883722744547627308317e+00) }, 
      { SC_(5.2943706512451171875000000000000000000000e+00), SC_(6.9936919212341308593750000000000000000000e-01), SC_(3.2567964954746986587501299236591467549045e+00) }, 
      { SC_(5.5905342102050781250000000000000000000000e+00), SC_(4.7839165199548006057739257812500000000000e-04), SC_(3.3614204456229024091808036398711465989897e+00) }, 
      { SC_(5.5905342102050781250000000000000000000000e+00), SC_(7.3421024717390537261962890625000000000000e-04), SC_(3.3614204951457263942874517725087434911964e+00) }, 
      { SC_(5.5905342102050781250000000000000000000000e+00), SC_(1.6169343143701553344726562500000000000000e-03), SC_(3.3614208264746613526302251247109855855860e+00) }, 
      { SC_(5.5905342102050781250000000000000000000000e+00), SC_(3.5115787759423255920410156250000000000000e-03), SC_(3.3614223776980196274460769529308539151237e+00) }, 
      { SC_(5.5905342102050781250000000000000000000000e+00), SC_(4.0457472205162048339843750000000000000000e-03), SC_(3.3614230221664082676015713106583219812863e+00) }, 
      { SC_(5.5905342102050781250000000000000000000000e+00), SC_(1.0635107755661010742187500000000000000000e-02), SC_(3.3614384658368739708129264194896137060236e+00) }, 
      { SC_(5.5905342102050781250000000000000000000000e+00), SC_(2.8892643749713897705078125000000000000000e-02), SC_(3.3615536799480780200078825558200398053593e+00) }, 
      { SC_(5.5905342102050781250000000000000000000000e+00), SC_(3.7872627377510070800781250000000000000000e-02), SC_(3.3616493985838337859988772608437412396312e+00) }, 
      { SC_(5.5905342102050781250000000000000000000000e+00), SC_(1.2087455391883850097656250000000000000000e-01), SC_(3.3637534964933886392918892487732039428318e+00) }, 
      { SC_(5.5905342102050781250000000000000000000000e+00), SC_(2.1016991138458251953125000000000000000000e-01), SC_(3.3684782371211313236567038219438026173427e+00) }, 
      { SC_(5.5905342102050781250000000000000000000000e+00), SC_(4.1968369483947753906250000000000000000000e-01), SC_(3.3897006610370969970222260460705503095152e+00) }, 
      { SC_(5.5905342102050781250000000000000000000000e+00), SC_(6.9936919212341308593750000000000000000000e-01), SC_(3.4421454495863867459962674235333290690240e+00) }, 
      { SC_(6.2296276092529296875000000000000000000000e+00), SC_(4.7839165199548006057739257812500000000000e-04), SC_(3.9464679058553936822818993575391933376740e+00) }, 
      { SC_(6.2296276092529296875000000000000000000000e+00), SC_(7.3421024717390537261962890625000000000000e-04), SC_(3.9464679100068902447607574292683810991299e+00) }, 
      { SC_(6.2296276092529296875000000000000000000000e+00), SC_(1.6169343143701553344726562500000000000000e-03), SC_(3.9464679377821943643978933703122645301054e+00) }, 
      { SC_(6.2296276092529296875000000000000000000000e+00), SC_(3.5115787759423255920410156250000000000000e-03), SC_(3.9464680678215090256611125421996368001329e+00) }, 
      { SC_(6.2296276092529296875000000000000000000000e+00), SC_(4.0457472205162048339843750000000000000000e-03), SC_(3.9464681218475296639974796350286275443673e+00) }, 
      { SC_(6.2296276092529296875000000000000000000000e+00), SC_(1.0635107755661010742187500000000000000000e-02), SC_(3.9464694165184358925462870376547438451829e+00) }, 
      { SC_(6.2296276092529296875000000000000000000000e+00), SC_(2.8892643749713897705078125000000000000000e-02), SC_(3.9464790764812436289986551819457192238559e+00) }, 
      { SC_(6.2296276092529296875000000000000000000000e+00), SC_(3.7872627377510070800781250000000000000000e-02), SC_(3.9464871036906058452890515205691780085124e+00) }, 
      { SC_(6.2296276092529296875000000000000000000000e+00), SC_(1.2087455391883850097656250000000000000000e-01), SC_(3.9466639744751971626236673493550633238829e+00) }, 
      { SC_(6.2296276092529296875000000000000000000000e+00), SC_(2.1016991138458251953125000000000000000000e-01), SC_(3.9470640189355784526985836144314026244968e+00) }, 
      { SC_(6.2296276092529296875000000000000000000000e+00), SC_(4.1968369483947753906250000000000000000000e-01), SC_(3.9489089816318107365492000564041518275500e+00) }, 
      { SC_(6.2296276092529296875000000000000000000000e+00), SC_(6.9936919212341308593750000000000000000000e-01), SC_(3.9537819123118262737828179504697861512675e+00) }, 
      { SC_(7.1494064331054687500000000000000000000000e+00), SC_(4.7839165199548006057739257812500000000000e-04), SC_(4.7618867236523010875916089447455123201161e+00) }, 
      { SC_(7.1494064331054687500000000000000000000000e+00), SC_(7.3421024717390537261962890625000000000000e-04), SC_(4.7618866645668248635100706292235593395354e+00) }, 
      { SC_(7.1494064331054687500000000000000000000000e+00), SC_(1.6169343143701553344726562500000000000000e-03), SC_(4.7618862692598084558915991925331010778476e+00) }, 
      { SC_(7.1494064331054687500000000000000000000000e+00), SC_(3.5115787759423255920410156250000000000000e-03), SC_(4.7618844185062027062040142058513010069664e+00) }, 
      { SC_(7.1494064331054687500000000000000000000000e+00), SC_(4.0457472205162048339843750000000000000000e-03), SC_(4.7618836495973687598686189038428225577915e+00) }, 
      { SC_(7.1494064331054687500000000000000000000000e+00), SC_(1.0635107755661010742187500000000000000000e-02), SC_(4.7618652242301308408377642258816603111917e+00) }, 
      { SC_(7.1494064331054687500000000000000000000000e+00), SC_(2.8892643749713897705078125000000000000000e-02), SC_(4.7617277853585443871905297267760025064046e+00) }, 
      { SC_(7.1494064331054687500000000000000000000000e+00), SC_(3.7872627377510070800781250000000000000000e-02), SC_(4.7616136288008734864457615603027304227262e+00) }, 
      { SC_(7.1494064331054687500000000000000000000000e+00), SC_(1.2087455391883850097656250000000000000000e-01), SC_(4.7591101553726350645547921849636978257316e+00) }, 
      { SC_(7.1494064331054687500000000000000000000000e+00), SC_(2.1016991138458251953125000000000000000000e-01), SC_(4.7535285396621865138028938581276844406478e+00) }, 
      { SC_(7.1494064331054687500000000000000000000000e+00), SC_(4.1968369483947753906250000000000000000000e-01), SC_(4.7290540689833582996324183695499350483530e+00) }, 
      { SC_(7.1494064331054687500000000000000000000000e+00), SC_(6.9936919212341308593750000000000000000000e-01), SC_(4.6715944409953163323363883976047067078144e+00) }, 
      { SC_(7.2543811798095703125000000000000000000000e+00), SC_(4.7839165199548006057739257812500000000000e-04), SC_(4.8255611023410533875129017074424494648115e+00) }, 
      { SC_(7.2543811798095703125000000000000000000000e+00), SC_(7.3421024717390537261962890625000000000000e-04), SC_(4.8255610383175413818289811922045249611733e+00) }, 
      { SC_(7.2543811798095703125000000000000000000000e+00), SC_(1.6169343143701553344726562500000000000000e-03), SC_(4.8255606099731544354287001454649488011376e+00) }, 
      { SC_(7.2543811798095703125000000000000000000000e+00), SC_(3.5115787759423255920410156250000000000000e-03), SC_(4.8255586045492242924205272015324220304434e+00) }, 
      { SC_(7.2543811798095703125000000000000000000000e+00), SC_(4.0457472205162048339843750000000000000000e-03), SC_(4.8255577713836642663537890444364849079840e+00) }, 
      { SC_(7.2543811798095703125000000000000000000000e+00), SC_(1.0635107755661010742187500000000000000000e-02), SC_(4.8255378066125862047278017608209246210032e+00) }, 
      { SC_(7.2543811798095703125000000000000000000000e+00), SC_(2.8892643749713897705078125000000000000000e-02), SC_(4.8253889080131218306270896617775008130787e+00) }, 
      { SC_(7.2543811798095703125000000000000000000000e+00), SC_(3.7872627377510070800781250000000000000000e-02), SC_(4.8252652638372499990494083425102254766038e+00) }, 
      { SC_(7.2543811798095703125000000000000000000000e+00), SC_(1.2087455391883850097656250000000000000000e-01), SC_(4.8225606374459863129497861709337561434763e+00) }, 
      { SC_(7.2543811798095703125000000000000000000000e+00), SC_(2.1016991138458251953125000000000000000000e-01), SC_(4.8165758247041929496139865491259954028737e+00) }, 
      { SC_(7.2543811798095703125000000000000000000000e+00), SC_(4.1968369483947753906250000000000000000000e-01), SC_(4.7909480401223543474637051840843055031736e+00) }, 
      { SC_(7.2543811798095703125000000000000000000000e+00), SC_(6.9936919212341308593750000000000000000000e-01), SC_(4.7333635562080893238534741009623854273306e+00) }, 
      { SC_(9.0335578918457031250000000000000000000000e+00), SC_(4.7839165199548006057739257812500000000000e-04), SC_(5.6186834371406891156408168412533564947801e+00) }, 
      { SC_(9.0335578918457031250000000000000000000000e+00), SC_(7.3421024717390537261962890625000000000000e-04), SC_(5.6186834667123764256092114232221352929953e+00) }, 
      { SC_(9.0335578918457031250000000000000000000000e+00), SC_(1.6169343143701553344726562500000000000000e-03), SC_(5.6186836645597102883758556220776180253060e+00) }, 
      { SC_(9.0335578918457031250000000000000000000000e+00), SC_(3.5115787759423255920410156250000000000000e-03), SC_(5.6186845908472823553726295886090247304980e+00) }, 
      { SC_(9.0335578918457031250000000000000000000000e+00), SC_(4.0457472205162048339843750000000000000000e-03), SC_(5.6186849756816905823597250487115539042131e+00) }, 
      { SC_(9.0335578918457031250000000000000000000000e+00), SC_(1.0635107755661010742187500000000000000000e-02), SC_(5.6186941977529551622734117505733235637729e+00) }, 
      { SC_(9.0335578918457031250000000000000000000000e+00), SC_(2.8892643749713897705078125000000000000000e-02), SC_(5.6187630042861898198606631951662166843743e+00) }, 
      { SC_(9.0335578918457031250000000000000000000000e+00), SC_(3.7872627377510070800781250000000000000000e-02), SC_(5.6188201777917454435662041592620522274194e+00) }, 
      { SC_(9.0335578918457031250000000000000000000000e+00), SC_(1.2087455391883850097656250000000000000000e-01), SC_(5.6200792082034103089427696555236034891742e+00) }, 
      { SC_(9.0335578918457031250000000000000000000000e+00), SC_(2.1016991138458251953125000000000000000000e-01), SC_(5.6229217980419811612239604956491557693426e+00) }, 
      { SC_(9.0335578918457031250000000000000000000000e+00), SC_(4.1968369483947753906250000000000000000000e-01), SC_(5.6359438924155941507167336104763451690914e+00) }, 
      { SC_(9.0335578918457031250000000000000000000000e+00), SC_(6.9936919212341308593750000000000000000000e-01), SC_(5.6697191555871753358987124694375128001969e+00) }, 
      { SC_(1.1688289642333984375000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(7.2304852944353771316352369999749906224995e+00) }, 
      { SC_(1.1688289642333984375000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(7.2304853541124141927763736004739896952359e+00) }, 
      { SC_(1.1688289642333984375000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(7.2304857533772084489165934129152760402197e+00) }, 
      { SC_(1.1688289642333984375000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(7.2304876226600145365886104705457750693916e+00) }, 
      { SC_(1.1688289642333984375000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(7.2304883992667551036656585996335297583962e+00) }, 
      { SC_(1.1688289642333984375000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(7.2305070090669734001762941974731474797685e+00) }, 
      { SC_(1.1688289642333984375000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(7.2306458217275673750298148948690372172512e+00) }, 
      { SC_(1.1688289642333984375000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(7.2307611167585198530717481275541371921145e+00) }, 
      { SC_(1.1688289642333984375000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(7.2332889724056127505840690037844129360031e+00) }, 
      { SC_(1.1688289642333984375000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(7.2389210652746751577791894335072896945143e+00) }, 
      { SC_(1.1688289642333984375000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(7.2635616165263707599675626007867782402025e+00) }, 
      { SC_(1.1688289642333984375000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(7.3211573178376628269775855784868241708903e+00) }, 
      { SC_(1.1917144775390625000000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(7.3954301071990138743482203511893520228873e+00) }, 
      { SC_(1.1917144775390625000000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(7.3954301540843374481958843126893352382364e+00) }, 
      { SC_(1.1917144775390625000000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(7.3954304677672843661348927757603193715300e+00) }, 
      { SC_(1.1917144775390625000000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(7.3954319363757408408420515665979077388170e+00) }, 
      { SC_(1.1917144775390625000000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(7.3954325465213311598948061030965067382396e+00) }, 
      { SC_(1.1917144775390625000000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(7.3954471677414074385398261677481711424483e+00) }, 
      { SC_(1.1917144775390625000000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(7.3955562486522991543428030768492132083306e+00) }, 
      { SC_(1.1917144775390625000000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(7.3956468752563653444890784840075572989481e+00) }, 
      { SC_(1.1917144775390625000000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(7.3976398063135667130287044324870310641730e+00) }, 
      { SC_(1.1917144775390625000000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(7.4021201728275330096860209909907854974746e+00) }, 
      { SC_(1.1917144775390625000000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(7.4223283897851352853264098238592643844898e+00) }, 
      { SC_(1.1917144775390625000000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(7.4727498457978845091566057968521487042683e+00) }, 
      { SC_(1.1924232482910156250000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(7.4010909731162670810209628093070642663841e+00) }, 
      { SC_(1.1924232482910156250000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(7.4010910195625819593616394302596925141095e+00) }, 
      { SC_(1.1924232482910156250000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(7.4010913303083753002239855438177172070118e+00) }, 
      { SC_(1.1924232482910156250000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(7.4010927851656664708608266625358202981745e+00) }, 
      { SC_(1.1924232482910156250000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(7.4010933895982556603024155059544647074018e+00) }, 
      { SC_(1.1924232482910156250000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(7.4011078739209740426940519836635346066631e+00) }, 
      { SC_(1.1924232482910156250000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(7.4012159338857369084642980323021903530174e+00) }, 
      { SC_(1.1924232482910156250000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(7.4013057127633749515588037345000528730868e+00) }, 
      { SC_(1.1924232482910156250000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(7.4032801149731262596644969792036607203432e+00) }, 
      { SC_(1.1924232482910156250000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(7.4077196028197857905555498500629975041225e+00) }, 
      { SC_(1.1924232482910156250000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(7.4277558989224178424894727760369047358459e+00) }, 
      { SC_(1.1924232482910156250000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(7.4778219308379492988267835073594926170762e+00) }, 
      { SC_(1.2011219024658203125000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(7.4729278998542722260756627837506506262535e+00) }, 
      { SC_(1.2011219024658203125000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(7.4729279407295244745416994400221975468990e+00) }, 
      { SC_(1.2011219024658203125000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(7.4729282142025447613121143174750150692493e+00) }, 
      { SC_(1.2011219024658203125000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(7.4729294945559103497175285541307718393733e+00) }, 
      { SC_(1.2011219024658203125000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(7.4729300264897084291415183311488436315234e+00) }, 
      { SC_(1.2011219024658203125000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(7.4729427735434459923266378980703375176192e+00) }, 
      { SC_(1.2011219024658203125000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(7.4730378760492219776883550534232612388197e+00) }, 
      { SC_(1.2011219024658203125000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(7.4731168941058431524710651041829908641849e+00) }, 
      { SC_(1.2011219024658203125000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(7.4748556864337931330611525307583978731600e+00) }, 
      { SC_(1.2011219024658203125000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(7.4787725691821328141474267492607995894909e+00) }, 
      { SC_(1.2011219024658203125000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(7.4965670337384018110317199320327771782113e+00) }, 
      { SC_(1.2011219024658203125000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(7.5417464465225119219388520267202800737737e+00) }, 
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(8.0225747626268734698498653592804855090848e+00) }, 
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(8.0225747608761657685293741602543305534481e+00) }, 
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(8.0225747491631754852633573697568125204719e+00) }, 
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(8.0225746943249194170492215723005018681375e+00) }, 
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(8.0225746715418650314470133274312301020181e+00) }, 
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(8.0225741255723659579362055762298053187069e+00) }, 
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(8.0225700519135072081969897721671103042510e+00) }, 
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(8.0225666667930140706523825922735916749232e+00) }, 
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(8.0224920787551320519913522590484035158004e+00) }, 
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(8.0223233720586040037619136203112699545482e+00) }, 
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(8.0215452398494721195680963056169223026513e+00) }, 
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(8.0194894813603228682606820240088356048676e+00) }, 
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(8.7406050451728896176632700157985024596505e+00) }, 
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(8.7406049877378381229084624031005136193668e+00) }, 
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(8.7406046034728278292877498408140704136512e+00) }, 
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(8.7406028044149367163218332062790807116965e+00) }, 
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(8.7406020569830236532172005645445358781406e+00) }, 
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(8.7405841461912134391207608042043760436794e+00) }, 
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(8.7404505410405324551539070410377674822303e+00) }, 
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(8.7403395625915883614462156794476357266507e+00) }, 
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(8.7379043914816426227749789621007506310104e+00) }, 
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(8.7324657523939061931971140343947019171133e+00) }, 
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(8.7084835403723798358148177457219587141126e+00) }, 
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(8.6515390594888706088013910589676042697099e+00) }, 
      { SC_(1.3965171813964843750000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(8.9852452088831318665210965885405127358087e+00) }, 
      { SC_(1.3965171813964843750000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(8.9852451324763306158873570105493987191189e+00) }, 
      { SC_(1.3965171813964843750000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(8.9852446212919490715354735593767310763664e+00) }, 
      { SC_(1.3965171813964843750000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(8.9852422282461632627475730858310488239047e+00) }, 
      { SC_(1.3965171813964843750000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(8.9852412341466731724044619483982870872157e+00) }, 
      { SC_(1.3965171813964843750000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(8.9852174315514808589278052650462556906085e+00) }, 
      { SC_(1.3965171813964843750000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(8.9850410191120829020795832756930004989670e+00) }, 
      { SC_(1.3965171813964843750000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(8.9848959798359723565188251800162312603713e+00) }, 
      { SC_(1.3965171813964843750000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(8.9819919551675350619374718848023828184236e+00) }, 
      { SC_(1.3965171813964843750000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(8.9767111279178129391180576095020259493259e+00) }, 
      { SC_(1.3965171813964843750000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(8.9605156375540821988593525210661774361205e+00) }, 
      { SC_(1.3965171813964843750000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(8.9341478990996199402662725506339655284502e+00) }, 
      { SC_(1.5137226104736328125000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(9.4597475104256329273810447472684581737673e+00) }, 
      { SC_(1.5137226104736328125000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(9.4597475523230444323499704104206381902789e+00) }, 
      { SC_(1.5137226104736328125000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(9.4597478326347452345391002468755510421816e+00) }, 
      { SC_(1.5137226104736328125000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(9.4597491450055233647889581252816481118026e+00) }, 
      { SC_(1.5137226104736328125000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(9.4597496902411787971657008022683912018896e+00) }, 
      { SC_(1.5137226104736328125000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(9.4597627560463749857599304060850731841694e+00) }, 
      { SC_(1.5137226104736328125000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(9.4598602361266968960015569296454279203623e+00) }, 
      { SC_(1.5137226104736328125000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(9.4599412289091782305503698902283511578920e+00) }, 
      { SC_(1.5137226104736328125000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(9.4617233069340066996351047973921118563679e+00) }, 
      { SC_(1.5137226104736328125000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(9.4657365353481540473400209343857071558973e+00) }, 
      { SC_(1.5137226104736328125000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(9.4839495824079500716030487261509235519209e+00) }, 
      { SC_(1.5137226104736328125000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(9.5300720550529124566942543973511776805660e+00) }, 
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(1.0500097093674512251510766184595455239894e+01) }, 
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(1.0500097054891212874069069027298108032924e+01) }, 
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(1.0500096795414249243601473714783392556890e+01) }, 
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(1.0500095580587816142044734944727498323258e+01) }, 
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(1.0500095075877655954327122578601018362164e+01) }, 
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(1.0500082981184953040941286082464386849177e+01) }, 
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(1.0499992744833528279388407604046026709154e+01) }, 
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(1.0499917768664443482881697677588063730054e+01) }, 
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(1.0498267628393654690237730040095035593569e+01) }, 
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(1.0494548442645421214069962858544883190657e+01) }, 
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(1.0477618913021581560243019209398404186895e+01) }, 
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(1.0434424248971823431441495090761636115843e+01) }, 
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(1.0735951395602375262661972298451228733901e+01) }, 
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(1.0735951338528221030265885972750935721970e+01) }, 
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(1.0735950956677759907319633120730295812278e+01) }, 
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(1.0735949168924167606226802160122747248076e+01) }, 
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(1.0735948426188624341965273998458096597050e+01) }, 
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(1.0735930627921545816905881598796045836554e+01) }, 
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(1.0735797861245388561299697377971152059991e+01) }, 
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(1.0735687578063953345769728587941043957451e+01) }, 
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(1.0733267390109768882324930820930101884635e+01) }, 
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(1.0727860385555872828902266503167965280966e+01) }, 
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(1.0703990866703817448190259277927299142318e+01) }, 
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(1.0647183330020695898700367825418068151042e+01) }, 
      { SC_(1.6629417419433593750000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(1.0796481687263523297828515534984667491672e+01) }, 
      { SC_(1.6629417419433593750000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(1.0796481625495159104988504734268266465456e+01) }, 
      { SC_(1.6629417419433593750000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(1.0796481212238565446751744938896401080503e+01) }, 
      { SC_(1.6629417419433593750000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(1.0796479277450396788693113593262904111883e+01) }, 
      { SC_(1.6629417419433593750000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(1.0796478473629773526423182811249167922203e+01) }, 
      { SC_(1.6629417419433593750000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(1.0796459211841644404806850020859229627995e+01) }, 
      { SC_(1.6629417419433593750000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(1.0796315544243663517177531809643598938617e+01) }, 
      { SC_(1.6629417419433593750000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(1.0796196227932232604763056633460078812302e+01) }, 
      { SC_(1.6629417419433593750000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(1.0793582708530417951766779837024048705106e+01) }, 
      { SC_(1.6629417419433593750000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(1.0787776270012054846956694433752076359261e+01) }, 
      { SC_(1.6629417419433593750000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(1.0762602317814272487597367393118109505246e+01) }, 
      { SC_(1.6629417419433593750000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(1.0704766099883936382803351142568455654637e+01) }, 
      { SC_(1.7359725952148437500000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(1.1003276042298250810239033502674593721227e+01) }, 
      { SC_(1.7359725952148437500000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(1.1003276119593479179596396810401616963877e+01) }, 
      { SC_(1.7359725952148437500000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(1.1003276636685093059140116650675085597510e+01) }, 
      { SC_(1.7359725952148437500000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(1.1003279056538512280688085677771046665234e+01) }, 
      { SC_(1.7359725952148437500000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(1.1003280061364664253830560808456888402182e+01) }, 
      { SC_(1.7359725952148437500000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(1.1003304049605270796309000251431957706741e+01) }, 
      { SC_(1.7359725952148437500000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(1.1003477823440882392518948123190469990402e+01) }, 
      { SC_(1.7359725952148437500000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(1.1003615889148720519048569920228016993308e+01) }, 
      { SC_(1.7359725952148437500000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(1.1005888419410188041719649305544637952955e+01) }, 
      { SC_(1.7359725952148437500000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(1.1009146544068634033495596286826059596706e+01) }, 
      { SC_(1.7359725952148437500000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(1.1017664463150651791139896317581403832570e+01) }, 
      { SC_(1.7359725952148437500000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(1.1030595514550023528802204421252577038862e+01) }, 
      { SC_(1.8286674499511718750000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(1.1466374741558936973905331433171576638210e+01) }, 
      { SC_(1.8286674499511718750000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(1.1466374782942396623071679053707672896165e+01) }, 
      { SC_(1.8286674499511718750000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(1.1466375059815540807052942969388491675009e+01) }, 
      { SC_(1.8286674499511718750000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(1.1466376356087646780749004246245563398975e+01) }, 
      { SC_(1.8286674499511718750000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(1.1466376894634997304179016066907342035785e+01) }, 
      { SC_(1.8286674499511718750000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(1.1466389800168946989383336963272377073643e+01) }, 
      { SC_(1.8286674499511718750000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(1.1466486084789992463311554164205444276570e+01) }, 
      { SC_(1.8286674499511718750000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(1.1466566084678319592955965889439725824254e+01) }, 
      { SC_(1.8286674499511718750000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(1.1468326400957785945259950181061631336742e+01) }, 
      { SC_(1.8286674499511718750000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(1.1472291208004485048814659284171638345302e+01) }, 
      { SC_(1.8286674499511718750000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(1.1490294141610212956164341768315140159917e+01) }, 
      { SC_(1.8286674499511718750000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(1.1535944753951673108755147249996458583393e+01) }, 
      { SC_(1.8300270080566406250000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(1.1477921772263107328566562077176894942061e+01) }, 
      { SC_(1.8300270080566406250000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(1.1477921812751077166347219083509178390444e+01) }, 
      { SC_(1.8300270080566406250000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(1.1477922083633013144882621634117361084633e+01) }, 
      { SC_(1.8300270080566406250000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(1.1477923351855407589533121713740219581368e+01) }, 
      { SC_(1.8300270080566406250000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(1.1477923878749307625743635123069245430303e+01) }, 
      { SC_(1.8300270080566406250000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(1.1477936505032069642029238211279259277895e+01) }, 
      { SC_(1.8300270080566406250000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(1.1478030706688681423098196736757069741580e+01) }, 
      { SC_(1.8300270080566406250000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(1.1478108976512183488959560680019068654046e+01) }, 
      { SC_(1.8300270080566406250000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(1.1479831362899375892740535798460545492716e+01) }, 
      { SC_(1.8300270080566406250000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(1.1483711696326555477525648714990752331489e+01) }, 
      { SC_(1.8300270080566406250000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(1.1501346842803292945606351067594830494179e+01) }, 
      { SC_(1.8300270080566406250000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(1.1546164190028580762603933907208558200575e+01) }, 
      { SC_(1.8379699707031250000000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(1.1547241939791836374591787527819051763778e+01) }, 
      { SC_(1.8379699707031250000000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(1.1547241974903921351211586940524905440085e+01) }, 
      { SC_(1.8379699707031250000000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(1.1547242209818891295307937386389225577648e+01) }, 
      { SC_(1.8379699707031250000000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(1.1547243309650547563541035208458779704606e+01) }, 
      { SC_(1.8379699707031250000000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(1.1547243766585250906448182933376306897282e+01) }, 
      { SC_(1.8379699707031250000000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(1.1547254716424965391768236370998924469903e+01) }, 
      { SC_(1.8379699707031250000000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(1.1547336412496306410856008794113652703533e+01) }, 
      { SC_(1.8379699707031250000000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(1.1547404294357315412478277700660524697103e+01) }, 
      { SC_(1.8379699707031250000000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(1.1548898685211706582668509212018105335927e+01) }, 
      { SC_(1.8379699707031250000000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(1.1552269527106233474486578948127903581171e+01) }, 
      { SC_(1.8379699707031250000000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(1.1567658481810224917007506982032159077524e+01) }, 
      { SC_(1.8379699707031250000000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(1.1607216329544212439948925243812095272289e+01) }, 
      { SC_(1.8595535278320312500000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(1.1748702414172207316829963930036352760574e+01) }, 
      { SC_(1.8595535278320312500000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(1.1748702433660722897408932437069276332768e+01) }, 
      { SC_(1.8595535278320312500000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(1.1748702564047299909080615699422208209471e+01) }, 
      { SC_(1.8595535278320312500000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(1.1748703174495265371307997411249887889508e+01) }, 
      { SC_(1.8595535278320312500000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(1.1748703428111390222586590502566692159614e+01) }, 
      { SC_(1.8595535278320312500000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(1.1748709505717707990059934957703209223193e+01) }, 
      { SC_(1.8595535278320312500000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(1.1748754852126214824987319217199205010853e+01) }, 
      { SC_(1.8595535278320312500000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(1.1748792533157047276521665841945135457892e+01) }, 
      { SC_(1.8595535278320312500000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(1.1749622608914411872012283767496354947336e+01) }, 
      { SC_(1.8595535278320312500000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(1.1751498771915094997447799688333989849954e+01) }, 
      { SC_(1.8595535278320312500000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(1.1760128888991899559841414192415977433413e+01) }, 
      { SC_(1.8595535278320312500000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(1.1782759819367261782929660142039060115427e+01) }, 
      { SC_(1.8707794189453125000000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(1.1858712615599555893579474858993411296599e+01) }, 
      { SC_(1.8707794189453125000000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(1.1858712626556610685898509813016517381940e+01) }, 
      { SC_(1.8707794189453125000000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(1.1858712699864036419388224776734221531959e+01) }, 
      { SC_(1.8707794189453125000000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(1.1858713043077088893791634268454563437033e+01) }, 
      { SC_(1.8707794189453125000000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(1.1858713185668076774849368325394446244786e+01) }, 
      { SC_(1.8707794189453125000000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(1.1858716602694168109941305471792312696951e+01) }, 
      { SC_(1.8707794189453125000000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(1.1858742098151461050831955640011410610125e+01) }, 
      { SC_(1.8707794189453125000000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(1.1858763284174113125683469608927871429715e+01) }, 
      { SC_(1.8707794189453125000000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(1.1859230066883542331568623518082030304127e+01) }, 
      { SC_(1.8707794189453125000000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(1.1860285633616461667246609771196445094583e+01) }, 
      { SC_(1.8707794189453125000000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(1.1865150339868686488428256164293543590784e+01) }, 
      { SC_(1.8707794189453125000000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(1.1877973780902637046740025890089938621313e+01) }, 
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(1.1905293570011889586865813345593896612021e+01) }, 
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(1.1905293577356519464635721304300340994293e+01) }, 
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(1.1905293626495263693282239364519133199857e+01) }, 
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(1.1905293856554617100596791749536432570868e+01) }, 
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(1.1905293952134874068558765042937498183472e+01) }, 
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(1.1905296242604488305385597011779918040193e+01) }, 
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(1.1905313332525345263901736957548784155760e+01) }, 
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(1.1905327533831867768220468167493772858356e+01) }, 
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(1.1905640437438221688849062558333532715271e+01) }, 
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(1.1906348112748555077782924540453417186124e+01) }, 
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(1.1909611017444873246999023619412659571293e+01) }, 
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(1.1918223025895177583025008594495692873669e+01) }, 
      { SC_(1.8823707580566406250000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(1.1974154538781236674578004106725983093760e+01) }, 
      { SC_(1.8823707580566406250000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(1.1974154540785592102201758504190137459256e+01) }, 
      { SC_(1.8823707580566406250000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(1.1974154554195595170127202530355835319148e+01) }, 
      { SC_(1.8823707580566406250000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(1.1974154616978980453158974666980425066356e+01) }, 
      { SC_(1.8823707580566406250000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(1.1974154643062911329013637006045049199419e+01) }, 
      { SC_(1.8823707580566406250000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(1.1974155268134088188913850140746389309934e+01) }, 
      { SC_(1.8823707580566406250000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(1.1974159931996554273628973628347774674744e+01) }, 
      { SC_(1.8823707580566406250000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(1.1974163807562999996761411828248122659602e+01) }, 
      { SC_(1.8823707580566406250000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(1.1974249202082775850908192886429428450216e+01) }, 
      { SC_(1.8823707580566406250000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(1.1974442351055607382019054413198208879590e+01) }, 
      { SC_(1.8823707580566406250000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(1.1975333213546421266285140740833697348871e+01) }, 
      { SC_(1.8823707580566406250000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(1.1977686753555748069425218606682657972967e+01) }, 
      { SC_(1.9244384765625000000000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(1.2384650184844668628199906444330895023961e+01) }, 
      { SC_(1.9244384765625000000000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(1.2384650155014453814040101279712900002943e+01) }, 
      { SC_(1.9244384765625000000000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(1.2384649955437459937116444959202694282535e+01) }, 
      { SC_(1.9244384765625000000000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(1.2384649021051923482099707739480082703416e+01) }, 
      { SC_(1.9244384765625000000000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(1.2384648632853148624915035764814947712296e+01) }, 
      { SC_(1.9244384765625000000000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(1.2384639330159902533207498464536297030480e+01) }, 
      { SC_(1.9244384765625000000000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(1.2384569922150093722469831229426930144283e+01) }, 
      { SC_(1.9244384765625000000000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(1.2384512248925580598337285435249893817587e+01) }, 
      { SC_(1.9244384765625000000000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(1.2383242229410175264006671845579463143249e+01) }, 
      { SC_(1.9244384765625000000000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(1.2380374935582109218860836700077338254592e+01) }, 
      { SC_(1.9244384765625000000000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(1.2367241491752546630991260864362645324306e+01) }, 
      { SC_(1.9244384765625000000000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(1.2333189870611544054532127613133079829834e+01) }, 
      { SC_(1.9715248107910156250000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(1.2761544017543338121503905725452833472475e+01) }, 
      { SC_(1.9715248107910156250000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(1.2761543958484439244725768050241464020341e+01) }, 
      { SC_(1.9715248107910156250000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(1.2761543563355235918871920764465278221687e+01) }, 
      { SC_(1.9715248107910156250000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(1.2761541713434101644768391701312195895228e+01) }, 
      { SC_(1.9715248107910156250000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(1.2761540944871116103158240852982330242039e+01) }, 
      { SC_(1.9715248107910156250000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(1.2761522527790071224337553547594725311629e+01) }, 
      { SC_(1.9715248107910156250000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(1.2761385150643825801860642506375723551021e+01) }, 
      { SC_(1.9715248107910156250000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(1.2761271045243729014493602601631136887758e+01) }, 
      { SC_(1.9715248107910156250000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(1.2758768668584857271933341972164117030836e+01) }, 
      { SC_(1.9715248107910156250000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(1.2753189331023531831253705523258288612240e+01) }, 
      { SC_(1.9715248107910156250000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(1.2728722459777125739106447444886522947863e+01) }, 
      { SC_(1.9715248107910156250000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(1.2671269581485092000197011722839561311439e+01) }, 
      { SC_(1.9858451843261718750000000000000000000000e+01), SC_(4.7839165199548006057739257812500000000000e-04), SC_(1.2846244064311653813320725358046862937430e+01) }, 
      { SC_(1.9858451843261718750000000000000000000000e+01), SC_(7.3421024717390537261962890625000000000000e-04), SC_(1.2846243998684151646665365089814021495030e+01) }, 
      { SC_(1.9858451843261718750000000000000000000000e+01), SC_(1.6169343143701553344726562500000000000000e-03), SC_(1.2846243559608491957923530826832797958635e+01) }, 
      { SC_(1.9858451843261718750000000000000000000000e+01), SC_(3.5115787759423255920410156250000000000000e-03), SC_(1.2846241503945177532277915015517391431480e+01) }, 
      { SC_(1.9858451843261718750000000000000000000000e+01), SC_(4.0457472205162048339843750000000000000000e-03), SC_(1.2846240649908483151130284385718120341657e+01) }, 
      { SC_(1.9858451843261718750000000000000000000000e+01), SC_(1.0635107755661010742187500000000000000000e-02), SC_(1.2846220185208979428257313895157755096596e+01) }, 
      { SC_(1.9858451843261718750000000000000000000000e+01), SC_(2.8892643749713897705078125000000000000000e-02), SC_(1.2846067570035466600746368160228287130478e+01) }, 
      { SC_(1.9858451843261718750000000000000000000000e+01), SC_(3.7872627377510070800781250000000000000000e-02), SC_(1.2845940855598831612881687549208528129993e+01) }, 
      { SC_(1.9858451843261718750000000000000000000000e+01), SC_(1.2087455391883850097656250000000000000000e-01), SC_(1.2843172619561956674050373200317977103446e+01) }, 
      { SC_(1.9858451843261718750000000000000000000000e+01), SC_(2.1016991138458251953125000000000000000000e-01), SC_(1.2837069841192149963858043614818354578765e+01) }, 
      { SC_(1.9858451843261718750000000000000000000000e+01), SC_(4.1968369483947753906250000000000000000000e-01), SC_(1.2811225848626158110286641796510837599690e+01) }, 
      { SC_(1.9858451843261718750000000000000000000000e+01), SC_(6.9936919212341308593750000000000000000000e-01), SC_(1.2754235235945252672131774219770120143321e+01) }
   }};
//#undef SC_

