/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class IndexerExpression
extends Expression {
    public IndexerExpression(int offset, Expression target, Expression argument) {
        super(offset);
        this.setTarget(target);
        this.setArgument(argument);
    }

    public final Expression getTarget() {
        return this.getChildByRole(Roles.TARGET_EXPRESSION);
    }

    public final void setTarget(Expression value) {
        this.setChildByRole(Roles.TARGET_EXPRESSION, value);
    }

    public final Expression getArgument() {
        return this.getChildByRole(Roles.ARGUMENT);
    }

    public final void setArgument(Expression value) {
        this.setChildByRole(Roles.ARGUMENT, value);
    }

    public final JavaTokenNode getLeftBracketToken() {
        return this.getChildByRole(Roles.LEFT_BRACKET);
    }

    public final JavaTokenNode getRightBracketToken() {
        return this.getChildByRole(Roles.RIGHT_BRACKET);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitIndexerExpression(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof IndexerExpression) {
            IndexerExpression otherIndexer = (IndexerExpression)other;
            return !otherIndexer.isNull() && this.getTarget().matches(otherIndexer.getTarget(), match) && this.getArgument().matches(otherIndexer.getArgument(), match);
        }
        return false;
    }
}

