/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.tasks;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.json.UnionDeserializer;
import org.opensearch.client.opensearch.tasks.TaskGroup;
import org.opensearch.client.opensearch.tasks.TaskInfo;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class TaskInfos
implements TaggedUnion<Kind, Object>,
PlainJsonSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<TaskInfos> _DESERIALIZER = JsonpDeserializer.lazy(TaskInfos::buildTaskInfosDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private TaskInfos(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private TaskInfos(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static TaskInfos of(Function<Builder, ObjectBuilder<TaskInfos>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isGroupedByNone() {
        return this._kind == Kind.GroupedByNone;
    }

    public List<TaskInfo> groupedByNone() {
        return (List)TaggedUnionUtils.get(this, Kind.GroupedByNone);
    }

    public boolean isGroupedByParents() {
        return this._kind == Kind.GroupedByParents;
    }

    public Map<String, TaskGroup> groupedByParents() {
        return (Map)TaggedUnionUtils.get(this, Kind.GroupedByParents);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind.ordinal()) {
                case 0: {
                    generator.writeStartArray();
                    for (TaskInfo item0 : (List)this._value) {
                        item0.serialize(generator, mapper);
                    }
                    generator.writeEnd();
                    break;
                }
                case 1: {
                    generator.writeStartObject();
                    for (Map.Entry item0 : ((Map)this._value).entrySet()) {
                        generator.writeKey((String)item0.getKey());
                        ((TaskGroup)item0.getValue()).serialize(generator, mapper);
                    }
                    generator.writeEnd();
                }
            }
        }
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    private static JsonpDeserializer<TaskInfos> buildTaskInfosDeserializer() {
        return new UnionDeserializer.Builder<TaskInfos, Kind, Object>(TaskInfos::new, false).addMember(Kind.GroupedByNone, JsonpDeserializer.arrayDeserializer(TaskInfo._DESERIALIZER)).addMember(Kind.GroupedByParents, JsonpDeserializer.stringMapDeserializer(TaskGroup._DESERIALIZER)).build();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode((Object)this._kind);
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskInfos other = (TaskInfos)o;
        return Objects.equals((Object)this._kind, (Object)other._kind) && Objects.equals(this._value, other._value);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<TaskInfos> {
        private Kind _kind;
        private Object _value;

        public Builder() {
        }

        private Builder(TaskInfos o) {
            this._kind = o._kind;
            this._value = o._value;
        }

        public ObjectBuilder<TaskInfos> groupedByNone(List<TaskInfo> v) {
            this._kind = Kind.GroupedByNone;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TaskInfos> groupedByParents(Map<String, TaskGroup> v) {
            this._kind = Kind.GroupedByParents;
            this._value = v;
            return this;
        }

        @Override
        public TaskInfos build() {
            this._checkSingleUse();
            return new TaskInfos(this);
        }
    }

    public static enum Kind {
        GroupedByNone,
        GroupedByParents;

    }
}

