/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.ValueTailIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;

public class TailIterator
implements SequenceIterator,
LastPositionFinder,
LookaheadIterator {
    private final SequenceIterator base;
    private final int start;

    private TailIterator(SequenceIterator base, int start) {
        this.base = base;
        this.start = start;
    }

    public static SequenceIterator make(SequenceIterator base, int start) throws XPathException {
        if (start <= 1) {
            return base;
        }
        if (base instanceof ArrayIterator) {
            return ((ArrayIterator)base).makeSliceIterator(start, Integer.MAX_VALUE);
        }
        if (base instanceof GroundedIterator && ((GroundedIterator)base).isActuallyGrounded()) {
            GroundedValue value = SequenceTool.toGroundedValue(base);
            if (start > value.getLength()) {
                return EmptyIterator.emptyIterator();
            }
            return new ValueTailIterator(value, start - 1);
        }
        for (int i = 0; i < start - 1; ++i) {
            Item b = base.next();
            if (b != null) continue;
            return EmptyIterator.emptyIterator();
        }
        return new TailIterator(base, start);
    }

    @Override
    public Item next() {
        return this.base.next();
    }

    @Override
    public boolean supportsHasNext() {
        return this.base instanceof LookaheadIterator && ((LookaheadIterator)this.base).supportsHasNext();
    }

    @Override
    public boolean hasNext() {
        return ((LookaheadIterator)this.base).hasNext();
    }

    @Override
    public boolean supportsGetLength() {
        return SequenceTool.supportsGetLength(this.base);
    }

    @Override
    public int getLength() {
        int bl = SequenceTool.getLength(this.base) - this.start + 1;
        return Math.max(bl, 0);
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public void discharge() {
        this.base.discharge();
    }
}

