/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.UserException;
import com.zeroc.IceGrid.AccessDeniedException;
import com.zeroc.IceGrid.ApplicationDescriptor;
import com.zeroc.IceGrid.ApplicationUpdateDescriptor;
import com.zeroc.IceGrid.BoxedDistributionDescriptor;
import com.zeroc.IceGrid.BoxedString;
import com.zeroc.IceGrid.DistributionDescriptor;
import com.zeroc.IceGrid.IceBoxDescriptor;
import com.zeroc.IceGrid.ServiceInstanceDescriptor;
import com.zeroc.IceGrid.TemplateDescriptor;
import com.zeroc.IceGridGUI.Application.ApplicationEditor;
import com.zeroc.IceGridGUI.Application.Editor;
import com.zeroc.IceGridGUI.Application.ListTreeNode;
import com.zeroc.IceGridGUI.Application.Node;
import com.zeroc.IceGridGUI.Application.Nodes;
import com.zeroc.IceGridGUI.Application.PropertySet;
import com.zeroc.IceGridGUI.Application.PropertySets;
import com.zeroc.IceGridGUI.Application.ReplicaGroup;
import com.zeroc.IceGridGUI.Application.ReplicaGroups;
import com.zeroc.IceGridGUI.Application.Server;
import com.zeroc.IceGridGUI.Application.ServerInstance;
import com.zeroc.IceGridGUI.Application.ServerTemplate;
import com.zeroc.IceGridGUI.Application.ServerTemplates;
import com.zeroc.IceGridGUI.Application.ServiceInstance;
import com.zeroc.IceGridGUI.Application.ServiceTemplate;
import com.zeroc.IceGridGUI.Application.ServiceTemplates;
import com.zeroc.IceGridGUI.Application.TreeNode;
import com.zeroc.IceGridGUI.Application.UpdateFailedException;
import com.zeroc.IceGridGUI.ApplicationActions;
import com.zeroc.IceGridGUI.ApplicationPane;
import com.zeroc.IceGridGUI.Coordinator;
import com.zeroc.IceGridGUI.Utils;
import com.zeroc.IceGridGUI.XMLWriter;
import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import javax.swing.ActionMap;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class Root
extends ListTreeNode {
    private final Coordinator _coordinator;
    private final boolean _traceSaveToRegistry;
    private JTree _tree;
    private DefaultTreeModel _treeModel;
    private Utils.Resolver _resolver;
    private boolean _live;
    private File _file;
    private ApplicationDescriptor _descriptor;
    private Map<String, String> _origVariables;
    private String _origDescription;
    private DistributionDescriptor _origDistrib;
    private boolean _registryUpdatesEnabled;
    private boolean _discardMe;
    private boolean _updated;
    private List<ApplicationUpdateDescriptor> _concurrentUpdates;
    private boolean _canUseUpdateDescriptor;
    private int _skipUpdates;
    private Nodes _nodes;
    private PropertySets _propertySets;
    private ReplicaGroups _replicaGroups;
    private ServerTemplates _serverTemplates;
    private ServiceTemplates _serviceTemplates;
    private boolean _selectionListenerEnabled;
    private ApplicationEditor _editor;
    private Map<Class, Editor> _editorMap;
    private ApplicationPane _applicationPane;
    private static DefaultTreeCellRenderer _cellRenderer;
    private static JPopupMenu _popup;

    public Root(Coordinator coordinator, ApplicationDescriptor desc, boolean live, File file) throws UpdateFailedException {
        super(false, null, desc.name);
        this._registryUpdatesEnabled = true;
        this._discardMe = false;
        this._updated = false;
        this._concurrentUpdates = new LinkedList<ApplicationUpdateDescriptor>();
        this._canUseUpdateDescriptor = true;
        this._skipUpdates = 0;
        this._selectionListenerEnabled = true;
        this._editorMap = new HashMap<Class, Editor>();
        this._coordinator = coordinator;
        this._traceSaveToRegistry = coordinator.traceSaveToRegistry();
        this._descriptor = desc;
        this._file = file;
        this._live = live;
        this.init();
    }

    public Root(Coordinator coordinator, ApplicationDescriptor desc) {
        block2: {
            super(true, null, desc.name);
            this._registryUpdatesEnabled = true;
            this._discardMe = false;
            this._updated = false;
            this._concurrentUpdates = new LinkedList<ApplicationUpdateDescriptor>();
            this._canUseUpdateDescriptor = true;
            this._skipUpdates = 0;
            this._selectionListenerEnabled = true;
            this._editorMap = new HashMap<Class, Editor>();
            this._coordinator = coordinator;
            this._traceSaveToRegistry = coordinator.traceSaveToRegistry();
            this._descriptor = desc;
            this._file = null;
            this._live = false;
            try {
                this.init();
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    private void init() throws UpdateFailedException {
        this._resolver = new Utils.Resolver(this._descriptor.variables);
        this._resolver.put("application", this._descriptor.name);
        this._origVariables = this._descriptor.variables;
        this._origDescription = this._descriptor.description;
        this._origDistrib = this._descriptor.distrib.clone();
        this._propertySets = new PropertySets((TreeNode)this, this._descriptor.propertySets);
        this._replicaGroups = new ReplicaGroups((TreeNode)this, this._descriptor.replicaGroups);
        this._serviceTemplates = new ServiceTemplates(this, this._descriptor.serviceTemplates);
        this._serverTemplates = new ServerTemplates(this, this._descriptor.serverTemplates);
        this._nodes = new Nodes((TreeNode)this, this._descriptor.nodes);
        this._children.add(this._nodes);
        this._children.add(this._propertySets);
        this._children.add(this._replicaGroups);
        this._children.add(this._serverTemplates);
        this._children.add(this._serviceTemplates);
        this._tree = new JTree(this, true);
        this._treeModel = (DefaultTreeModel)this._tree.getModel();
        ActionMap am = this._tree.getActionMap();
        am.put("copy", this._coordinator.getActionsForMenu().get(13));
        am.put("paste", this._coordinator.getActionsForMenu().get(14));
    }

    public static ApplicationDescriptor copyDescriptor(ApplicationDescriptor ad) {
        ApplicationDescriptor copy = ad.clone();
        copy.propertySets = PropertySets.copyDescriptors(copy.propertySets);
        copy.replicaGroups = ReplicaGroups.copyDescriptors(copy.replicaGroups);
        copy.serverTemplates = ServerTemplates.copyDescriptors(copy.serverTemplates);
        copy.serviceTemplates = ServiceTemplates.copyDescriptors(copy.serviceTemplates);
        copy.nodes = Nodes.copyDescriptors(copy.nodes);
        copy.distrib = copy.distrib.clone();
        return copy;
    }

    @Override
    public void delete() {
        if (this._file == null && !this._live) {
            int confirm = JOptionPane.showConfirmDialog(this._coordinator.getMainFrame(), "You are about to remove application '" + this._id + "'. Do you want to proceed?", "Remove Confirmation", 0);
            if (confirm == 0) {
                super.delete();
            }
        } else {
            super.delete();
        }
    }

    @Override
    public Editor getEditor() {
        if (this._editor == null) {
            this._editor = (ApplicationEditor)this.getEditor(ApplicationEditor.class, this);
        }
        this._editor.show(this);
        return this._editor;
    }

    @Override
    protected Editor createEditor() {
        return new ApplicationEditor();
    }

    public TreeNode findNodeLike(TreePath path, boolean exactMatch) {
        TreeNode result = null;
        if (path == null) {
            return null;
        }
        for (int i = 0; i < path.getPathCount(); ++i) {
            TreeNode node = (TreeNode)path.getPathComponent(i);
            if (result == null) {
                if (node.getId().equals(this._id)) {
                    result = this;
                    continue;
                }
                return null;
            }
            TreeNode newNode = result.findChildLike(node);
            if (newNode == null) {
                if (exactMatch) {
                    return null;
                }
                return result;
            }
            result = newNode;
        }
        return result;
    }

    public boolean hasNode(TreeNode node) {
        while (node != this) {
            TreeNode parent = (TreeNode)node.getParent();
            if (parent == null || parent.getIndex(node) == -1) {
                return false;
            }
            node = parent;
        }
        return true;
    }

    public void setSelectedNode(TreeNode node) {
        this._tree.setSelectionPath(node.getPath());
    }

    public TreeNode getSelectedNode() {
        TreePath path = this._tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        return (TreeNode)path.getLastPathComponent();
    }

    public void selectServer(String nodeName, String serverId) {
        TreeNode target = this._nodes;
        if (target != null) {
            Node node = (Node)target.findChild(nodeName);
            if (node != null) {
                target = node;
                Server server = node.findServer(serverId);
                if (server != null) {
                    target = (TreeNode)((Object)server);
                }
            }
            this.setSelectedNode(target);
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _cellRenderer.setOpenIcon(Utils.getIcon("/icons/16x16/application_open.png"));
            _cellRenderer.setClosedIcon(Utils.getIcon("/icons/16x16/application_closed.png"));
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    @Override
    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        actions[13] = true;
        actions[15] = true;
        Object descriptor = this._coordinator.getClipboard();
        if (descriptor != null) {
            actions[14] = descriptor instanceof ApplicationDescriptor;
        }
        actions[16] = true;
        actions[17] = true;
        actions[2] = true;
        actions[3] = true;
        actions[4] = true;
        actions[10] = true;
        actions[11] = true;
        actions[12] = true;
        return actions;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        ApplicationActions actions = this._coordinator.getActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(actions.get(2));
            _popup.add(actions.get(3));
            _popup.add(actions.get(4));
            _popup.addSeparator();
            _popup.add(actions.get(10));
            _popup.add(actions.get(11));
            _popup.addSeparator();
            _popup.add(actions.get(12));
        }
        actions.setTarget(this);
        return _popup;
    }

    @Override
    public void copy() {
        this._coordinator.setClipboard(Root.copyDescriptor(this._descriptor));
        this._coordinator.getActionsForMenu().get(14).setEnabled(true);
    }

    @Override
    public void paste() {
        this._coordinator.pasteApplication();
    }

    @Override
    public void newNode() {
        this._nodes.newNode();
    }

    @Override
    public void newPropertySet() {
        this._propertySets.newPropertySet();
    }

    @Override
    public void newReplicaGroup() {
        this._replicaGroups.newReplicaGroup();
    }

    @Override
    public void newTemplateServer() {
        this._serverTemplates.newTemplateServer();
    }

    @Override
    public void newTemplateServerIceBox() {
        this._serverTemplates.newTemplateServerIceBox();
    }

    @Override
    public void newTemplateService() {
        this._serviceTemplates.newTemplateService();
    }

    public void save() {
        if (this._live) {
            this.saveToRegistry(true);
        } else if (this._file != null) {
            File file = this._coordinator.saveToFile(false, this, this._file);
            if (file != null) {
                this._file = file;
                this.commit();
                this._coordinator.getSaveAction().setEnabled(false);
                this._coordinator.getDiscardUpdatesAction().setEnabled(false);
            }
        } else assert (false);
    }

    public void saveToRegistry(final boolean restart) {
        Runnable runnable = new Runnable(){

            private void release() {
                Root.this._coordinator.releaseExclusiveWriteAccess();
                Root.this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            }

            private void handleFailure(String prefix, String title, String message) {
                this.release();
                if (Root.this.isSelected()) {
                    Root.this._coordinator.getSaveAction().setEnabled(Root.this.isLive() && Root.this._coordinator.connectedToMaster() || Root.this.hasFile());
                    Root.this._coordinator.getSaveToRegistryAction().setEnabled(true);
                    Root.this._coordinator.getSaveToRegistryWithoutRestartAction().setEnabled(true);
                    Root.this._coordinator.getDiscardUpdatesAction().setEnabled(true);
                }
                Root.this._coordinator.getStatusBar().setText(prefix + "failed!");
                JOptionPane.showMessageDialog(Root.this._coordinator.getMainFrame(), message, title, 0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Root.this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
                boolean asyncRelease = false;
                try {
                    if (Root.this._live && Root.this._canUseUpdateDescriptor) {
                        ApplicationUpdateDescriptor updateDescriptor = Root.this.createUpdateDescriptor();
                        if (updateDescriptor != null) {
                            String prefix = "Updating application '" + Root.this._id + "'...";
                            Root.this._coordinator.getStatusBar().setText(prefix);
                            if (Root.this._traceSaveToRegistry) {
                                Root.this._coordinator.traceSaveToRegistry("sending updateApplication for application " + Root.this._id);
                            }
                            CompletableFuture<Void> r = restart ? Root.this._coordinator.getAdmin().updateApplicationAsync(updateDescriptor) : Root.this._coordinator.getAdmin().updateApplicationWithoutRestartAsync(updateDescriptor);
                            r.whenComplete((result, ex) -> {
                                if (Root.this._traceSaveToRegistry) {
                                    Root.this._coordinator.traceSaveToRegistry("updateApplication for application " + Root.this._id + (ex == null ? ": success" : ": failed"));
                                }
                                if (ex == null) {
                                    SwingUtilities.invokeLater(() -> {
                                        Root.this.commit();
                                        this.release();
                                        Root.this._coordinator.getStatusBar().setText(prefix + "done.");
                                    });
                                } else {
                                    SwingUtilities.invokeLater(() -> {
                                        Root.this._skipUpdates--;
                                        if (ex instanceof UserException) {
                                            this.handleFailure(prefix, "Update failed", "IceGrid exception: " + ex.toString());
                                        } else {
                                            this.handleFailure(prefix, "Update failed", "Communication exception: " + ex.toString());
                                        }
                                    });
                                }
                            });
                            asyncRelease = true;
                            Root.this._skipUpdates++;
                        } else {
                            String prefix = "Application '" + Root.this._id + "' is already up-to-date";
                            Root.this._coordinator.getStatusBar().setText(prefix);
                            Root.this.commit();
                        }
                    } else if (Root.this._coordinator.getLiveDeploymentRoot().getApplicationDescriptor(Root.this._id) == null) {
                        assert (!Root.this._live);
                        String prefix = "Adding application '" + Root.this._id + "'...";
                        Root.this._coordinator.getStatusBar().setText(prefix);
                        if (Root.this._traceSaveToRegistry) {
                            Root.this._coordinator.traceSaveToRegistry("sending addApplication for application " + Root.this._id);
                        }
                        Root.this._coordinator.getAdmin().addApplicationAsync(Root.this._descriptor).whenComplete((result, ex) -> {
                            if (Root.this._traceSaveToRegistry) {
                                Root.this._coordinator.traceSaveToRegistry("addApplication for application " + Root.this._id + (ex == null ? ": success" : ": failed"));
                            }
                            if (ex == null) {
                                SwingUtilities.invokeLater(() -> {
                                    Root.this.commit();
                                    Root.this.liveReset();
                                    Root.this._coordinator.addLiveApplication(Root.this);
                                    this.release();
                                    Root.this._coordinator.getStatusBar().setText(prefix + "done.");
                                });
                            } else if (ex instanceof UserException) {
                                SwingUtilities.invokeLater(() -> this.handleFailure(prefix, "Add failed", "IceGrid exception: " + ex.toString()));
                            } else {
                                SwingUtilities.invokeLater(() -> this.handleFailure(prefix, "Add failed", "Communication exception: " + ex.toString()));
                            }
                        });
                        asyncRelease = true;
                    } else {
                        String prefix = "Synchronizing application '" + Root.this._id + "'...";
                        Root.this._coordinator.getStatusBar().setText(prefix);
                        if (Root.this._traceSaveToRegistry) {
                            Root.this._coordinator.traceSaveToRegistry("sending syncApplication for application " + Root.this._id);
                        }
                        CompletableFuture<Void> r = restart ? Root.this._coordinator.getAdmin().syncApplicationAsync(Root.this._descriptor) : Root.this._coordinator.getAdmin().syncApplicationWithoutRestartAsync(Root.this._descriptor);
                        r.whenComplete((result, ex) -> {
                            if (Root.this._traceSaveToRegistry) {
                                Root.this._coordinator.traceSaveToRegistry("syncApplication for application " + Root.this._id + (ex == null ? ": success" : ": failed"));
                            }
                            if (ex == null) {
                                SwingUtilities.invokeLater(() -> {
                                    Root.this.commit();
                                    if (!Root.this._live) {
                                        ApplicationPane app = Root.this._coordinator.getLiveApplication(Root.this._id);
                                        if (app == null) {
                                            Root.this.liveReset();
                                            Root.this._coordinator.addLiveApplication(Root.this);
                                        } else {
                                            boolean selected = Root.this.isSelected();
                                            Root.this._coordinator.getMainPane().removeApplication(Root.this);
                                            if (selected) {
                                                Root.this._coordinator.getMainPane().setSelectedComponent(app);
                                            }
                                        }
                                    }
                                    this.release();
                                    Root.this._coordinator.getStatusBar().setText(prefix + "done.");
                                });
                            } else {
                                SwingUtilities.invokeLater(() -> {
                                    if (Root.this._live) {
                                        Root.this._skipUpdates--;
                                    }
                                    if (ex instanceof UserException) {
                                        this.handleFailure(prefix, "Sync failed", "IceGrid exception: " + ex.toString());
                                    } else {
                                        this.handleFailure(prefix, "Sync failed", "Communication exception: " + ex.toString());
                                    }
                                });
                            }
                        });
                        asyncRelease = true;
                        if (Root.this._live) {
                            Root.this._skipUpdates++;
                        }
                    }
                    if (Root.this.isSelected()) {
                        Root.this._coordinator.getSaveAction().setEnabled(false);
                        Root.this._coordinator.getSaveToRegistryAction().setEnabled(false);
                        Root.this._coordinator.getSaveToRegistryWithoutRestartAction().setEnabled(false);
                        Root.this._coordinator.getDiscardUpdatesAction().setEnabled(false);
                    }
                }
                catch (LocalException e) {
                    if (Root.this._traceSaveToRegistry) {
                        Root.this._coordinator.traceSaveToRegistry("Ice communications exception while saving application " + Root.this._id);
                    }
                    JOptionPane.showMessageDialog(Root.this._coordinator.getMainFrame(), e.toString(), "Communication Exception", 0);
                }
                finally {
                    if (!asyncRelease) {
                        Root.this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
                        Root.this._coordinator.releaseExclusiveWriteAccess();
                    }
                }
            }
        };
        try {
            this._coordinator.acquireExclusiveWriteAccess(runnable);
        }
        catch (AccessDeniedException e) {
            this._coordinator.accessDenied(e);
        }
        catch (LocalException e) {
            JOptionPane.showMessageDialog(this._coordinator.getMainFrame(), e.toString(), "Communication Exception", 0);
        }
    }

    public void saveToFile() {
        File file = this._coordinator.saveToFile(true, this, this._file);
        if (file != null) {
            this._file = file;
            this._live = false;
            this._coordinator.removeLiveApplication(this._id);
            this._coordinator.getMainPane().resetIcon(this);
            this.commit();
            this._coordinator.getSaveAction().setEnabled(false);
            this._coordinator.getDiscardUpdatesAction().setEnabled(false);
            this._coordinator.getSaveToRegistryAction().setEnabled(this._coordinator.connectedToMaster());
            this._coordinator.getSaveToRegistryWithoutRestartAction().setEnabled(this._coordinator.connectedToMaster());
        }
    }

    public void discardUpdates() {
        Root newRoot;
        ApplicationDescriptor desc = null;
        if (this._live) {
            desc = this._coordinator.getLiveDeploymentRoot().getApplicationDescriptor(this._id);
            assert (desc != null);
            desc = Root.copyDescriptor(desc);
        } else if (this._file != null) {
            desc = this._coordinator.parseFile(this._file);
            if (desc == null) {
                return;
            }
        } else assert (false);
        try {
            newRoot = new Root(this._coordinator, desc, this._live, this._file);
        }
        catch (UpdateFailedException e) {
            JOptionPane.showMessageDialog(this._coordinator.getMainFrame(), e.toString(), "Bad Application Descriptor: Unable reload Application", 0);
            return;
        }
        ApplicationPane app = this._coordinator.getMainPane().findApplication(this);
        assert (app != null);
        app.setRoot(newRoot);
        TreeNode node = newRoot.findNodeLike(this._tree.getSelectionPath(), false);
        if (node == null) {
            newRoot.setSelectedNode(newRoot);
        } else {
            newRoot.setSelectedNode(node);
        }
        this._coordinator.getCurrentTab().selected();
    }

    private void liveReset() {
        this._live = true;
        this._skipUpdates = 0;
        this._file = null;
        this._coordinator.getMainPane().resetIcon(this);
    }

    private ApplicationUpdateDescriptor createUpdateDescriptor() {
        ApplicationUpdateDescriptor update = new ApplicationUpdateDescriptor();
        update.name = this._descriptor.name;
        if (this._editable.isModified()) {
            if (!this._descriptor.description.equals(this._origDescription)) {
                update.description = new BoxedString(this._descriptor.description);
            }
            update.variables = new TreeMap<String, String>(this._descriptor.variables);
            LinkedList<String> removeVariables = new LinkedList<String>();
            for (Map.Entry<String, String> p : this._origVariables.entrySet()) {
                String key = p.getKey();
                String newValue = update.variables.get(key);
                if (newValue == null) {
                    removeVariables.add(key);
                    continue;
                }
                String value = p.getValue();
                if (!newValue.equals(value)) continue;
                update.variables.remove(key);
            }
            update.removeVariables = removeVariables.toArray(new String[0]);
            if (!this._descriptor.distrib.equals(this._origDistrib)) {
                update.distrib = new BoxedDistributionDescriptor(this._descriptor.distrib);
            }
        } else {
            update.variables = new TreeMap<String, String>();
            update.removeVariables = new String[0];
        }
        update.removePropertySets = this._propertySets.getEditable().removedElements(PropertySet.class);
        update.propertySets = this._propertySets.getUpdates();
        update.removeReplicaGroups = this._replicaGroups.getEditable().removedElements(ReplicaGroup.class);
        update.replicaGroups = this._replicaGroups.getUpdates();
        update.removeServerTemplates = this._serverTemplates.getEditable().removedElements(ServerTemplate.class);
        update.serverTemplates = this._serverTemplates.getUpdates();
        update.removeServiceTemplates = this._serviceTemplates.getEditable().removedElements(ServiceTemplate.class);
        update.serviceTemplates = this._serviceTemplates.getUpdates();
        update.removeNodes = this._nodes.getEditable().removedElements(Node.class);
        update.nodes = this._nodes.getUpdates();
        if (!this._editable.isModified() && update.removePropertySets.length == 0 && update.propertySets.size() == 0 && update.removeReplicaGroups.length == 0 && update.replicaGroups.size() == 0 && update.removeServerTemplates.length == 0 && update.serverTemplates.size() == 0 && update.removeServiceTemplates.length == 0 && update.serviceTemplates.size() == 0 && update.removeNodes.length == 0 && update.nodes.size() == 0) {
            return null;
        }
        return update;
    }

    private void commit() {
        this._updated = false;
        this._registryUpdatesEnabled = true;
        this._canUseUpdateDescriptor = true;
        assert (this._concurrentUpdates.size() == 0);
        this._editable.commit();
        this._origVariables = this._descriptor.variables;
        this._origDescription = this._descriptor.description;
        this._origDistrib = this._descriptor.distrib.clone();
        this._nodes.commit();
        this._propertySets.commit();
        this._replicaGroups.commit();
        this._serverTemplates.commit();
        this._serviceTemplates.commit();
    }

    @Override
    public boolean isEphemeral() {
        return false;
    }

    @Override
    public void destroy() {
        if (!this._live && this._file == null) {
            this._coordinator.getMainPane().removeApplication(this);
        } else if (this._live) {
            int confirm = JOptionPane.showConfirmDialog(this._coordinator.getMainFrame(), "You are about to remove application '" + this._id + "' from the IceGrid registry. Do you want to proceed?", "Remove Confirmation", 0);
            if (confirm == 0) {
                this._coordinator.removeApplicationFromRegistry(this._id);
                this._discardMe = true;
            }
        } else {
            assert (this._file != null);
            int confirm = JOptionPane.showConfirmDialog(this._coordinator.getMainFrame(), "You are about to remove application '" + this._id + "' and its associated file. Do you want to proceed?", "Remove Confirmation", 0);
            if (confirm == 0 && this._file.delete()) {
                this._coordinator.getMainPane().removeApplication(this);
            }
        }
    }

    public boolean update(ApplicationUpdateDescriptor desc) {
        block15: {
            assert (this._live);
            if (this._skipUpdates > 0) {
                --this._skipUpdates;
                return false;
            }
            if (!this._registryUpdatesEnabled) {
                if (this._updated) {
                    this._canUseUpdateDescriptor = false;
                } else {
                    this._concurrentUpdates.add(desc);
                }
                return false;
            }
            try {
                if (desc.description != null) {
                    this._origDescription = this._descriptor.description = desc.description.value;
                }
                for (String name : desc.removeVariables) {
                    this._descriptor.variables.remove(name);
                }
                this._descriptor.variables.putAll(desc.variables);
                if (desc.distrib != null) {
                    this._descriptor.distrib = desc.distrib.value;
                    this._origDistrib = this._descriptor.distrib.clone();
                }
                for (String id : desc.removePropertySets) {
                    this._descriptor.propertySets.remove(id);
                }
                this._descriptor.propertySets.putAll(desc.propertySets);
                this._propertySets.update(desc.propertySets, desc.removePropertySets);
                for (String id : desc.removeReplicaGroups) {
                    this._descriptor.replicaGroups.remove(id);
                }
                this._descriptor.replicaGroups.addAll(desc.replicaGroups);
                this._replicaGroups.update(desc.replicaGroups, desc.removeReplicaGroups);
                for (String id : desc.removeServiceTemplates) {
                    this._descriptor.serviceTemplates.remove(id);
                }
                this._descriptor.serviceTemplates.putAll(desc.serviceTemplates);
                this._serviceTemplates.update(desc.serviceTemplates, desc.removeServiceTemplates);
                for (String id : desc.removeServerTemplates) {
                    this._descriptor.serverTemplates.remove(id);
                }
                this._descriptor.serverTemplates.putAll(desc.serverTemplates);
                this._serverTemplates.update(desc.serverTemplates, desc.removeServerTemplates, desc.serviceTemplates.keySet());
                for (String id : desc.removeNodes) {
                    this._descriptor.nodes.remove(id);
                }
                this._nodes.update(desc.nodes, desc.removeNodes, desc.serverTemplates.keySet(), desc.serviceTemplates.keySet());
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block15;
                throw new AssertionError();
            }
        }
        return true;
    }

    public JTree getTree() {
        return this._tree;
    }

    public DefaultTreeModel getTreeModel() {
        return this._treeModel;
    }

    @Override
    public Coordinator getCoordinator() {
        return this._coordinator;
    }

    public boolean isSelectionListenerEnabled() {
        return this._selectionListenerEnabled;
    }

    public void enableSelectionListener() {
        this._selectionListenerEnabled = true;
    }

    public void disableSelectionListener() {
        this._selectionListenerEnabled = false;
    }

    public void cancelEdit() {
        if (!this._updated) {
            this._registryUpdatesEnabled = true;
            for (ApplicationUpdateDescriptor p : this._concurrentUpdates) {
                boolean ok = this.update(p);
                assert (ok);
            }
            if (!this._concurrentUpdates.isEmpty()) {
                this._applicationPane.refresh();
                this._concurrentUpdates.clear();
            }
            this._coordinator.getSaveAction().setEnabled(false);
            this._coordinator.getDiscardUpdatesAction().setEnabled(false);
            this._coordinator.getSaveToRegistryAction().setEnabled(this.hasFile() && this._coordinator.connectedToMaster());
            this._coordinator.getSaveToRegistryWithoutRestartAction().setEnabled(this.hasFile() && this._coordinator.connectedToMaster());
        }
    }

    public boolean kill() {
        this._live = false;
        if (this._registryUpdatesEnabled || this._discardMe) {
            return true;
        }
        this._coordinator.getMainPane().resetIcon(this);
        this._coordinator.getCurrentTab().selected();
        return false;
    }

    public boolean isLive() {
        return this._live;
    }

    public boolean hasFile() {
        return this._file != null;
    }

    public boolean needsSaving() {
        return this._updated || !this._registryUpdatesEnabled;
    }

    public void setPane(ApplicationPane app) {
        this._applicationPane = app;
    }

    public ApplicationPane getPane() {
        return this._applicationPane;
    }

    Editor getEditor(Class c, TreeNode node) {
        Editor result = this._editorMap.get(c);
        if (result == null) {
            result = node.createEditor();
            this._editorMap.put(c, result);
        }
        return result;
    }

    @Override
    Object getDescriptor() {
        return this._descriptor;
    }

    ApplicationDescriptor saveDescriptor() {
        ApplicationDescriptor clone = this._descriptor.clone();
        clone.distrib = clone.distrib.clone();
        return clone;
    }

    void restoreDescriptor(ApplicationDescriptor clone) {
        this._descriptor.name = clone.name;
        this._descriptor.variables = clone.variables;
        this._descriptor.distrib.icepatch = clone.distrib.icepatch;
        this._descriptor.distrib.directories = clone.distrib.directories;
        this._descriptor.description = clone.description;
    }

    @Override
    public void write(XMLWriter writer) throws IOException {
        writer.writeStartTag("icegrid");
        LinkedList<String[]> attributes = new LinkedList<String[]>();
        attributes.add(Root.createAttribute("name", this._id));
        writer.writeStartTag("application", attributes);
        if (this._descriptor.description.length() > 0) {
            writer.writeElement("description", this._descriptor.description);
        }
        Root.writeVariables(writer, this._descriptor.variables);
        Root.writeDistribution(writer, this._descriptor.distrib);
        this._serviceTemplates.write(writer);
        this._serverTemplates.write(writer);
        this._replicaGroups.write(writer);
        this._propertySets.write(writer);
        this._nodes.write(writer);
        writer.writeEndTag("application");
        writer.writeEndTag("icegrid");
    }

    void disableRegistryUpdates() {
        if (this._registryUpdatesEnabled) {
            this._registryUpdatesEnabled = false;
            this._coordinator.getSaveAction().setEnabled(this._live && this._coordinator.connectedToMaster() || this._file != null);
            this._coordinator.getDiscardUpdatesAction().setEnabled(this._live || this._file != null);
            this._coordinator.getSaveToRegistryAction().setEnabled(this._coordinator.connectedToMaster());
            this._coordinator.getSaveToRegistryWithoutRestartAction().setEnabled(this._coordinator.connectedToMaster());
        }
    }

    void updated() {
        this._updated = true;
        this.disableRegistryUpdates();
        this._concurrentUpdates.clear();
    }

    void rebuild() throws UpdateFailedException {
        Utils.Resolver oldResolver = this._resolver;
        String oldId = this._id;
        this._id = this._descriptor.name;
        this._resolver = new Utils.Resolver(this._descriptor.variables);
        this._resolver.put("application", this._id);
        try {
            this._nodes.rebuild();
        }
        catch (UpdateFailedException e) {
            this._id = oldId;
            this._resolver = oldResolver;
            throw e;
        }
    }

    void removeServerInstances(String templateId) {
        this._nodes.removeServerInstances(templateId);
    }

    void removeServiceInstances(String templateId) {
        this._nodes.removeServiceInstances(templateId);
        this._serverTemplates.removeServiceInstances(templateId);
    }

    ServerTemplate findServerTemplate(String id) {
        return (ServerTemplate)this._serverTemplates.findChild(id);
    }

    ServiceTemplate findServiceTemplate(String id) {
        return (ServiceTemplate)this._serviceTemplates.findChild(id);
    }

    ReplicaGroup findReplicaGroup(String id) {
        return (ReplicaGroup)this._replicaGroups.findChild(id);
    }

    List<ServerInstance> findServerInstances(String template) {
        return this._nodes.findServerInstances(template);
    }

    List<ServiceInstance> findServiceInstances(String template) {
        List<ServiceInstance> result = this._serverTemplates.findServiceInstances(template);
        result.addAll(this._nodes.findServiceInstances(template));
        return result;
    }

    TemplateDescriptor findServerTemplateDescriptor(String templateName) {
        return this._descriptor.serverTemplates.get(templateName);
    }

    TemplateDescriptor findServiceTemplateDescriptor(String templateName) {
        return this._descriptor.serviceTemplates.get(templateName);
    }

    ServerTemplates getServerTemplates() {
        return this._serverTemplates;
    }

    ServiceTemplates getServiceTemplates() {
        return this._serviceTemplates;
    }

    ReplicaGroups getReplicaGroups() {
        return this._replicaGroups;
    }

    boolean pasteIceBox(IceBoxDescriptor ibd) {
        for (ServiceInstanceDescriptor p : ibd.services) {
            if (p.template.length() <= 0) continue;
            TemplateDescriptor td = this.findServiceTemplateDescriptor(p.template);
            if (td == null) {
                JOptionPane.showMessageDialog(this._coordinator.getMainFrame(), "Descriptor refers to undefined service template '" + p.template + "'", "Cannot paste", 0);
                return false;
            }
            p.parameterValues.keySet().retainAll(td.parameters);
        }
        return true;
    }

    @Override
    public Root getRoot() {
        return this;
    }

    @Override
    Utils.Resolver getResolver() {
        return this._resolver;
    }

    Map<String, String> getVariables() {
        return this._descriptor.variables;
    }

    private boolean isSelected() {
        if (this._coordinator.getCurrentTab() instanceof ApplicationPane) {
            return ((ApplicationPane)this._coordinator.getCurrentTab()).getRoot() == this;
        }
        return false;
    }
}

