/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.OpenSearchException;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;

@PublicApi(since="1.0.0")
public abstract class RestResponse {
    private Map<String, List<String>> customHeaders;

    public abstract String contentType();

    public abstract BytesReference content();

    public abstract RestStatus status();

    public void copyHeaders(OpenSearchException ex) {
        Set headerKeySet = ex.getHeaderKeys();
        if (this.customHeaders == null) {
            this.customHeaders = new HashMap<String, List<String>>(headerKeySet.size());
        }
        for (String key : headerKeySet) {
            List<String> values = this.customHeaders.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                this.customHeaders.put(key, values);
            }
            values.addAll(ex.getHeader(key));
        }
    }

    public void addHeader(String name, String value) {
        List<String> header;
        if (this.customHeaders == null) {
            this.customHeaders = new HashMap<String, List<String>>(2);
        }
        if ((header = this.customHeaders.get(name)) == null) {
            header = new ArrayList<String>();
            this.customHeaders.put(name, header);
        }
        header.add(value);
    }

    public Map<String, List<String>> getHeaders() {
        if (this.customHeaders == null) {
            return Collections.emptyMap();
        }
        return this.customHeaders;
    }
}

