/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.coordination;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.opensearch.cli.Terminal;
import org.opensearch.cli.UserException;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.coordination.OpenSearchNodeCommand;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.regex.Regex;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.gateway.PersistedClusterStateService;

public class RemoveSettingsCommand
extends OpenSearchNodeCommand {
    static final String SETTINGS_REMOVED_MSG = "Settings were successfully removed from the cluster state";
    static final String CONFIRMATION_MSG = "------------------------------------------------------------------------\n\nYou should only run this tool if you have incompatible settings in the\ncluster state that prevent the cluster from forming.\nThis tool can cause data loss and its use should be your last resort.\n\nDo you want to proceed?\n";
    private final OptionSpec<String> arguments;

    public RemoveSettingsCommand() {
        super("Removes persistent settings from the cluster state");
        this.arguments = this.parser.nonOptions("setting names");
    }

    @Override
    protected void processNodePaths(Terminal terminal, Path[] dataPaths, int nodeLockId, OptionSet options, Environment env) throws IOException, UserException {
        List settingsToRemove = this.arguments.values(options);
        if (settingsToRemove.isEmpty()) {
            throw new UserException(64, "Must supply at least one setting to remove");
        }
        PersistedClusterStateService persistedClusterStateService = RemoveSettingsCommand.createPersistedClusterStateService(env.settings(), dataPaths);
        terminal.println(Terminal.Verbosity.VERBOSE, "Loading cluster state");
        Tuple<Long, ClusterState> termAndClusterState = RemoveSettingsCommand.loadTermAndClusterState(persistedClusterStateService, env);
        ClusterState oldClusterState = (ClusterState)termAndClusterState.v2();
        Settings oldPersistentSettings = oldClusterState.metadata().persistentSettings();
        terminal.println(Terminal.Verbosity.VERBOSE, "persistent settings: " + String.valueOf(oldPersistentSettings));
        Settings.Builder newPersistentSettingsBuilder = Settings.builder().put(oldPersistentSettings);
        for (String settingToRemove : settingsToRemove) {
            boolean matched = false;
            for (String settingKey : oldPersistentSettings.keySet()) {
                if (!Regex.simpleMatch(settingToRemove, settingKey)) continue;
                newPersistentSettingsBuilder.remove(settingKey);
                if (!matched) {
                    terminal.println("The following settings will be removed:");
                }
                matched = true;
                terminal.println(settingKey + ": " + oldPersistentSettings.get(settingKey));
            }
            if (matched) continue;
            throw new UserException(64, "No persistent cluster settings matching [" + settingToRemove + "] were found on this node");
        }
        ClusterState newClusterState = ClusterState.builder(oldClusterState).metadata(Metadata.builder(oldClusterState.metadata()).persistentSettings(newPersistentSettingsBuilder.build()).build()).build();
        terminal.println(Terminal.Verbosity.VERBOSE, "[old cluster state = " + String.valueOf(oldClusterState) + ", new cluster state = " + String.valueOf(newClusterState) + "]");
        this.confirm(terminal, CONFIRMATION_MSG);
        try (PersistedClusterStateService.Writer writer = persistedClusterStateService.createWriter();){
            writer.writeFullStateAndCommit((Long)termAndClusterState.v1(), newClusterState);
        }
        terminal.println(SETTINGS_REMOVED_MSG);
    }
}

