/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.internal.OracleConnection;

class ServiceMember
implements Diagnosable {
    private static final String CLASS_NAME = ServiceMember.class.getName();
    private String name;
    private String svc;
    private String db;
    private String hst;
    private boolean restarted;
    int connCount;
    private MemberStatus status;
    private ConcurrentHashMap<OracleConnection, OracleConnection> connections;

    ServiceMember(String svcname, String iname, String dbuniq, String hstname) {
        this.name = iname;
        this.svc = svcname;
        this.db = dbuniq;
        this.hst = hstname;
        this.restarted = false;
        this.connCount = 0;
        this.status = MemberStatus.UNKNOWN;
        this.connections = new ConcurrentHashMap();
    }

    void up() {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "up", "Marked service member UP: {0}", (String)null, (Throwable)null, (Object)this.name);
        this.status = MemberStatus.UP;
    }

    void down() {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "down", "Marked service member DOWN: {0}", (String)null, (Throwable)null, (Object)this.name);
        this.status = MemberStatus.DOWN;
    }

    boolean isDown() {
        return this.status == MemberStatus.DOWN;
    }

    boolean isUp() {
        return this.status == MemberStatus.UP;
    }

    void addConnection(OracleConnection oconn) {
        this.connections.put(oconn, oconn);
        ++this.connCount;
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "addConnection", "Added connection to service member: {0}", (String)null, (Throwable)null, (Object)this.getNetConnectionId(oconn));
    }

    void dropConnection(OracleConnection oconn) {
        this.connections.remove(oconn);
        if (this.connCount > 0) {
            --this.connCount;
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "dropConnection", "Removed connection to service member: {0}", (String)null, (Throwable)null, (Object)this.getNetConnectionId(oconn));
    }

    void cleanupConnections() throws SQLException {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "cleanupConnections", "Cleaning up connections to service member: {0}", (String)null, (Throwable)null, (Object)this.name);
        ConcurrentHashMap<OracleConnection, OracleConnection> _conns = this.connections;
        this.connections = new ConcurrentHashMap();
        for (OracleConnection oconn : _conns.keySet()) {
            oconn.abort();
            oconn.close();
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "cleanupConnections", "Cleaned up connection to service member: {0}", (String)null, (Throwable)null, (Object)this.getNetConnectionId(oconn));
        }
        this.connCount = 0;
        _conns.clear();
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "cleanupConnections", "Cleaned up all connections to service member: {0}", (String)null, (Throwable)null, (Object)this.name);
    }

    public String getName() {
        return this.name;
    }

    String getDatabase() {
        return this.db;
    }

    public String toString() {
        return "Service name: " + this.svc + ", Instance name: " + this.name + ", Database name: " + this.db + ", Host name: " + this.hst;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }

    private String getNetConnectionId(OracleConnection conn) {
        try {
            return conn.getNetConnectionId();
        }
        catch (SQLException e) {
            return e.getMessage();
        }
    }

    private static enum MemberStatus {
        UNKNOWN,
        UP,
        DOWN;

    }
}

