/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.i18n;

import java.util.List;

public class Relation {
    int low;
    int high;
    int mod = 1;
    boolean negated = false;
    boolean integer = true;

    public Relation(List<String> tokens) {
        this.parse(tokens);
    }

    public Relation(int low, int high) {
        this.low = low;
        this.high = high;
    }

    public void setMod(int mod) {
        this.mod = mod;
    }

    public void setNegated(boolean value) {
        this.negated = value;
    }

    public void setInteger(boolean value) {
        this.integer = value;
    }

    public boolean matches(double number) {
        double value;
        double d = value = this.mod == 1 ? number : number % (double)this.mod;
        if (this.integer && Double.compare(value, Math.rint(value)) != 0) {
            return false;
        }
        return ((double)this.low <= value && value <= (double)this.high) != this.negated;
    }

    private void parse(List<String> input) {
        String token = input.remove(0);
        if (!"n".equals(token)) {
            throw new RuntimeException("Relation must start with 'n': " + token);
        }
        token = input.remove(0);
        if ("mod".equals(token)) {
            this.mod = Integer.parseInt(input.remove(0));
            token = input.remove(0);
        }
        if ("not".equals(token)) {
            this.negated = true;
            token = input.remove(0);
        }
        if ("is".equals(token)) {
            token = input.remove(0);
            if ("not".equals(token)) {
                this.negated = true;
                token = input.remove(0);
            }
            this.low = this.high = Integer.parseInt(token);
        } else {
            if ("within".equals(token)) {
                this.integer = false;
            }
            this.low = Integer.parseInt(input.remove(0));
            this.high = Integer.parseInt(input.remove(0));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Relation) {
            Relation other = (Relation)o;
            return this.low == other.low && this.high == other.high && this.mod == other.mod && this.negated == other.negated && this.integer == other.integer;
        }
        return false;
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + this.low;
        hash = 31 * hash + this.high;
        hash = 31 * hash + this.mod;
        hash = 31 * hash + (this.negated ? 1 : 0) + (this.integer ? 2 : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("n ");
        if (this.mod != 1) {
            sb.append("mod ").append(this.mod).append(' ');
        }
        if (this.low == this.high) {
            sb.append("is ");
            if (this.negated) {
                sb.append("not ");
            }
            sb.append(this.low);
        } else {
            if (this.negated) {
                sb.append("not ");
            }
            if (!this.integer) {
                sb.append("with");
            }
            sb.append("in ").append(this.low).append("..").append(this.high);
        }
        return sb.toString();
    }
}

