/* tracker-cursor.c generated by valac 0.56.3, the Vala compiler
 * generated from tracker-cursor.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */
/**
 * SECTION: tracker-sparql-cursor
 * @short_description: Iteration of the query results
 * @title: TrackerSparqlCursor
 * @stability: Stable
 * @include: tracker-sparql.h
 *
 * <para>
 * #TrackerSparqlCursor is an object which provides methods to iterate the
 * results of a query to the Tracker Store.
 * </para>
 */
/**
 * tracker_sparql_cursor_next_finish:
 * @self: a #TrackerSparqlCursor
 * @_res_: a #GAsyncResult with the result of the operation
 * @error: #GError for error reporting.
 *
 * Finishes the asynchronous iteration to the next result.
 *
 * Returns: %FALSE if no more results found, otherwise %TRUE.
 *
 * Since: 0.10
 */

#include "libtracker-sparql/tracker-generated-no-checks.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>

enum  {
	TRACKER_SPARQL_CURSOR_0_PROPERTY,
	TRACKER_SPARQL_CURSOR_CONNECTION_PROPERTY,
	TRACKER_SPARQL_CURSOR_N_COLUMNS_PROPERTY,
	TRACKER_SPARQL_CURSOR_NUM_PROPERTIES
};
static GParamSpec* tracker_sparql_cursor_properties[TRACKER_SPARQL_CURSOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _TrackerSparqlCursorPrivate {
	TrackerSparqlConnection* _connection;
};

static gint TrackerSparqlCursor_private_offset;
static gpointer tracker_sparql_cursor_parent_class = NULL;

static TrackerSparqlValueType tracker_sparql_cursor_real_get_value_type (TrackerSparqlCursor* self,
                                                                  gint column);
static const gchar* tracker_sparql_cursor_real_get_variable_name (TrackerSparqlCursor* self,
                                                           gint column);
static const gchar* tracker_sparql_cursor_real_get_string (TrackerSparqlCursor* self,
                                                    gint column,
                                                    glong* length);
static gboolean tracker_sparql_cursor_real_next (TrackerSparqlCursor* self,
                                          GCancellable* cancellable,
                                          GError** error);
static void tracker_sparql_cursor_real_rewind (TrackerSparqlCursor* self);
static void tracker_sparql_cursor_real_close (TrackerSparqlCursor* self);
static gint64 tracker_sparql_cursor_real_get_integer (TrackerSparqlCursor* self,
                                               gint column);
static gdouble tracker_sparql_cursor_real_get_double (TrackerSparqlCursor* self,
                                               gint column);
static gboolean tracker_sparql_cursor_real_get_boolean (TrackerSparqlCursor* self,
                                                 gint column);
static gboolean tracker_sparql_cursor_real_is_bound (TrackerSparqlCursor* self,
                                              gint column);
static void tracker_sparql_cursor_finalize (GObject * obj);
static GType tracker_sparql_cursor_get_type_once (void);
static void _vala_tracker_sparql_cursor_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_tracker_sparql_cursor_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

/**
 * TrackerSparqlValueType:
 * @TRACKER_SPARQL_VALUE_TYPE_UNBOUND: Unbound value type
 * @TRACKER_SPARQL_VALUE_TYPE_URI: Uri value type, rdfs:Resource
 * @TRACKER_SPARQL_VALUE_TYPE_STRING: String value type, xsd:string
 * @TRACKER_SPARQL_VALUE_TYPE_INTEGER: Integer value type, xsd:integer
 * @TRACKER_SPARQL_VALUE_TYPE_DOUBLE: Double value type, xsd:double
 * @TRACKER_SPARQL_VALUE_TYPE_DATETIME: Datetime value type, xsd:dateTime
 * @TRACKER_SPARQL_VALUE_TYPE_BLANK_NODE: Blank node value type
 * @TRACKER_SPARQL_VALUE_TYPE_BOOLEAN: Boolean value type, xsd:boolean
 *
 * Enumeration with the possible types of the cursor's cells
 *
 * Since: 0.10
 */
static GType
tracker_sparql_value_type_get_type_once (void)
{
	static const GEnumValue values[] = {{TRACKER_SPARQL_VALUE_TYPE_UNBOUND, "TRACKER_SPARQL_VALUE_TYPE_UNBOUND", "unbound"}, {TRACKER_SPARQL_VALUE_TYPE_URI, "TRACKER_SPARQL_VALUE_TYPE_URI", "uri"}, {TRACKER_SPARQL_VALUE_TYPE_STRING, "TRACKER_SPARQL_VALUE_TYPE_STRING", "string"}, {TRACKER_SPARQL_VALUE_TYPE_INTEGER, "TRACKER_SPARQL_VALUE_TYPE_INTEGER", "integer"}, {TRACKER_SPARQL_VALUE_TYPE_DOUBLE, "TRACKER_SPARQL_VALUE_TYPE_DOUBLE", "double"}, {TRACKER_SPARQL_VALUE_TYPE_DATETIME, "TRACKER_SPARQL_VALUE_TYPE_DATETIME", "datetime"}, {TRACKER_SPARQL_VALUE_TYPE_BLANK_NODE, "TRACKER_SPARQL_VALUE_TYPE_BLANK_NODE", "blank-node"}, {TRACKER_SPARQL_VALUE_TYPE_BOOLEAN, "TRACKER_SPARQL_VALUE_TYPE_BOOLEAN", "boolean"}, {0, NULL, NULL}};
	GType tracker_sparql_value_type_type_id;
	tracker_sparql_value_type_type_id = g_enum_register_static ("TrackerSparqlValueType", values);
	return tracker_sparql_value_type_type_id;
}

GType
tracker_sparql_value_type_get_type (void)
{
	static volatile gsize tracker_sparql_value_type_type_id__once = 0;
	if (g_once_init_enter (&tracker_sparql_value_type_type_id__once)) {
		GType tracker_sparql_value_type_type_id;
		tracker_sparql_value_type_type_id = tracker_sparql_value_type_get_type_once ();
		g_once_init_leave (&tracker_sparql_value_type_type_id__once, tracker_sparql_value_type_type_id);
	}
	return tracker_sparql_value_type_type_id__once;
}

static inline gpointer
tracker_sparql_cursor_get_instance_private (TrackerSparqlCursor* self)
{
	return G_STRUCT_MEMBER_P (self, TrackerSparqlCursor_private_offset);
}

/**
 * tracker_sparql_cursor_get_value_type:
 * @self: a #TrackerSparqlCursor
 * @column: column number to retrieve (first one is 0)
 *
 * The data type bound to the current row in @column is returned.
 *
 * Returns: a #TrackerSparqlValueType.
 *
 * Since: 0.10
 */
static TrackerSparqlValueType
tracker_sparql_cursor_real_get_value_type (TrackerSparqlCursor* self,
                                           gint column)
{
#line 126 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	g_critical ("Type `%s' does not implement abstract method `tracker_sparql_cursor_get_value_type'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 126 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	return 0;
#line 165 "tracker-cursor.c"
}

TrackerSparqlValueType
tracker_sparql_cursor_get_value_type (TrackerSparqlCursor* self,
                                      gint column)
{
	TrackerSparqlCursorClass* _klass_;
#line 126 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 126 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	_klass_ = TRACKER_SPARQL_CURSOR_GET_CLASS (self);
#line 126 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	if (_klass_->get_value_type) {
#line 126 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		return _klass_->get_value_type (self, column);
#line 181 "tracker-cursor.c"
	}
#line 126 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	return 0;
#line 185 "tracker-cursor.c"
}

/**
 * tracker_sparql_cursor_get_variable_name:
 * @self: a #TrackerSparqlCursor
 * @column: column number to retrieve (first one is 0)
 *
 * Retrieves the variable name for the current row in @column.
 *
 * Returns: a string which must not be freed.
 *
 * Since: 0.10
 */
static const gchar*
tracker_sparql_cursor_real_get_variable_name (TrackerSparqlCursor* self,
                                              gint column)
{
#line 139 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	g_critical ("Type `%s' does not implement abstract method `tracker_sparql_cursor_get_variable_name'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 139 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	return NULL;
#line 207 "tracker-cursor.c"
}

const gchar*
tracker_sparql_cursor_get_variable_name (TrackerSparqlCursor* self,
                                         gint column)
{
	TrackerSparqlCursorClass* _klass_;
#line 139 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 139 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	_klass_ = TRACKER_SPARQL_CURSOR_GET_CLASS (self);
#line 139 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	if (_klass_->get_variable_name) {
#line 139 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		return _klass_->get_variable_name (self, column);
#line 223 "tracker-cursor.c"
	}
#line 139 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	return NULL;
#line 227 "tracker-cursor.c"
}

/**
 * tracker_sparql_cursor_get_string:
 * @self: a #TrackerSparqlCursor
 * @column: column number to retrieve (first one is 0)
 * @length: length of the returned string
 *
 * Retrieves a string representation of the data in the current
 * row in @column.
 *
 * Returns: a string which must not be freed. %NULL is returned if
 * the column is not in the [0,#n_columns] range.
 *
 * Since: 0.10
 */
static const gchar*
tracker_sparql_cursor_real_get_string (TrackerSparqlCursor* self,
                                       gint column,
                                       glong* length)
{
#line 155 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	g_critical ("Type `%s' does not implement abstract method `tracker_sparql_cursor_get_string'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 155 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	return NULL;
#line 253 "tracker-cursor.c"
}

const gchar*
tracker_sparql_cursor_get_string (TrackerSparqlCursor* self,
                                  gint column,
                                  glong* length)
{
	TrackerSparqlCursorClass* _klass_;
#line 155 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 155 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	_klass_ = TRACKER_SPARQL_CURSOR_GET_CLASS (self);
#line 155 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	if (_klass_->get_string) {
#line 155 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		return _klass_->get_string (self, column, length);
#line 270 "tracker-cursor.c"
	}
#line 155 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	return NULL;
#line 274 "tracker-cursor.c"
}

/**
 * tracker_sparql_cursor_next:
 * @self: a #TrackerSparqlCursor
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * Iterates to the next result. This is completely synchronous and
 * it may block.
 *
 * Returns: %FALSE if no more results found, otherwise %TRUE.
 *
 * Since: 0.10
 */
static gboolean
tracker_sparql_cursor_real_next (TrackerSparqlCursor* self,
                                 GCancellable* cancellable,
                                 GError** error)
{
	gboolean _tmp0_ = FALSE;
#line 170 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	g_critical ("Type `%s' does not implement abstract method `tracker_sparql_cursor_next'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 170 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	return _tmp0_;
#line 300 "tracker-cursor.c"
}

gboolean
tracker_sparql_cursor_next (TrackerSparqlCursor* self,
                            GCancellable* cancellable,
                            GError** error)
{
	TrackerSparqlCursorClass* _klass_;
#line 170 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 170 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	_klass_ = TRACKER_SPARQL_CURSOR_GET_CLASS (self);
#line 170 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	if (_klass_->next) {
#line 170 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		return _klass_->next (self, cancellable, error);
#line 317 "tracker-cursor.c"
	}
#line 170 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	return FALSE;
#line 321 "tracker-cursor.c"
}

void
tracker_sparql_cursor_next_async (TrackerSparqlCursor* self,
                                  GCancellable* cancellable,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	TrackerSparqlCursorClass* _klass_;
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	_klass_ = TRACKER_SPARQL_CURSOR_GET_CLASS (self);
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	if (_klass_->next_async) {
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		_klass_->next_async (self, cancellable, _callback_, _user_data_);
#line 337 "tracker-cursor.c"
	}
}

gboolean
tracker_sparql_cursor_next_finish (TrackerSparqlCursor* self,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	TrackerSparqlCursorClass* _klass_;
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	_klass_ = TRACKER_SPARQL_CURSOR_GET_CLASS (self);
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	if (_klass_->next_finish) {
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		return _klass_->next_finish (self, _res_, error);
#line 353 "tracker-cursor.c"
	}
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	return FALSE;
#line 357 "tracker-cursor.c"
}

/**
 * tracker_sparql_cursor_rewind:
 * @self: a #TrackerSparqlCursor
 *
 * Resets the iterator to point back to the first result.
 *
 * Since: 0.10
 */
static void
tracker_sparql_cursor_real_rewind (TrackerSparqlCursor* self)
{
#line 207 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	g_critical ("Type `%s' does not implement abstract method `tracker_sparql_cursor_rewind'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 207 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	return;
#line 375 "tracker-cursor.c"
}

void
tracker_sparql_cursor_rewind (TrackerSparqlCursor* self)
{
	TrackerSparqlCursorClass* _klass_;
#line 207 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	g_return_if_fail (self != NULL);
#line 207 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	_klass_ = TRACKER_SPARQL_CURSOR_GET_CLASS (self);
#line 207 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	if (_klass_->rewind) {
#line 207 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		_klass_->rewind (self);
#line 390 "tracker-cursor.c"
	}
}

/**
 * tracker_sparql_cursor_close:
 * @self: a #TrackerSparqlCursor
 *
 * Closes the iterator, making it invalid.
 *
 * Since: 0.12
 */
static void
tracker_sparql_cursor_real_close (TrackerSparqlCursor* self)
{
}

void
tracker_sparql_cursor_close (TrackerSparqlCursor* self)
{
	TrackerSparqlCursorClass* _klass_;
#line 217 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	g_return_if_fail (self != NULL);
#line 217 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	_klass_ = TRACKER_SPARQL_CURSOR_GET_CLASS (self);
#line 217 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	if (_klass_->close) {
#line 217 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		_klass_->close (self);
#line 419 "tracker-cursor.c"
	}
}

/**
 * tracker_sparql_cursor_get_integer:
 * @self: a #TrackerSparqlCursor
 * @column: column number to retrieve (first one is 0)
 *
 * Retrieve an integer for the current row in @column.
 *
 * Returns: a #gint64.
 *
 * Since: 0.10
 */
static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
#line 778 "glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0LL);
#line 779 "glib-2.0.vapi"
	result = g_ascii_strtoll (str, NULL, _base);
#line 779 "glib-2.0.vapi"
	return result;
#line 445 "tracker-cursor.c"
}

static gint64
tracker_sparql_cursor_real_get_integer (TrackerSparqlCursor* self,
                                        gint column)
{
	const gchar* as_str = NULL;
	const gchar* _tmp0_;
	gint64 result;
#line 232 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	g_return_val_if_fail (tracker_sparql_cursor_get_value_type (self, column) == TRACKER_SPARQL_VALUE_TYPE_INTEGER, 0);
#line 233 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	_tmp0_ = tracker_sparql_cursor_get_string (self, column, NULL);
#line 233 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	as_str = _tmp0_;
#line 234 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	result = int64_parse (as_str, (guint) 0);
#line 234 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	return result;
#line 465 "tracker-cursor.c"
}

gint64
tracker_sparql_cursor_get_integer (TrackerSparqlCursor* self,
                                   gint column)
{
	TrackerSparqlCursorClass* _klass_;
#line 231 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 231 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	_klass_ = TRACKER_SPARQL_CURSOR_GET_CLASS (self);
#line 231 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	if (_klass_->get_integer) {
#line 231 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		return _klass_->get_integer (self, column);
#line 481 "tracker-cursor.c"
	}
#line 231 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	return -1LL;
#line 485 "tracker-cursor.c"
}

/**
 * tracker_sparql_cursor_get_double:
 * @self: a #TrackerSparqlCursor
 * @column: column number to retrieve (first one is 0)
 *
 * Retrieve a double for the current row in @column.
 *
 * Returns: a double.
 *
 * Since: 0.10
 */
static gdouble
double_parse (const gchar* str)
{
	gdouble result;
#line 1003 "glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0.0);
#line 1004 "glib-2.0.vapi"
	result = g_ascii_strtod (str, NULL);
#line 1004 "glib-2.0.vapi"
	return result;
#line 509 "tracker-cursor.c"
}

static gdouble
tracker_sparql_cursor_real_get_double (TrackerSparqlCursor* self,
                                       gint column)
{
	const gchar* as_str = NULL;
	const gchar* _tmp0_;
	gdouble result;
#line 249 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	g_return_val_if_fail (tracker_sparql_cursor_get_value_type (self, column) == TRACKER_SPARQL_VALUE_TYPE_DOUBLE, 0);
#line 250 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	_tmp0_ = tracker_sparql_cursor_get_string (self, column, NULL);
#line 250 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	as_str = _tmp0_;
#line 251 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	result = double_parse (as_str);
#line 251 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	return result;
#line 529 "tracker-cursor.c"
}

gdouble
tracker_sparql_cursor_get_double (TrackerSparqlCursor* self,
                                  gint column)
{
	TrackerSparqlCursorClass* _klass_;
#line 248 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 248 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	_klass_ = TRACKER_SPARQL_CURSOR_GET_CLASS (self);
#line 248 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	if (_klass_->get_double) {
#line 248 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		return _klass_->get_double (self, column);
#line 545 "tracker-cursor.c"
	}
#line 248 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	return -1.0;
#line 549 "tracker-cursor.c"
}

/**
 * tracker_sparql_cursor_get_boolean:
 * @self: a #TrackerSparqlCursor
 * @column: column number to retrieve (first one is 0)
 *
 * Retrieve a boolean for the current row in @column.
 *
 * Returns: a #gboolean.
 *
 * Since: 0.10
 */
static gboolean
tracker_sparql_cursor_real_get_boolean (TrackerSparqlCursor* self,
                                        gint column)
{
	TrackerSparqlValueType type = 0;
	const gchar* as_str = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean result;
#line 266 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	type = tracker_sparql_cursor_get_value_type (self, column);
#line 267 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	g_return_val_if_fail (type == TRACKER_SPARQL_VALUE_TYPE_BOOLEAN, 0);
#line 268 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	_tmp0_ = tracker_sparql_cursor_get_string (self, column, NULL);
#line 268 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	as_str = _tmp0_;
#line 270 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	_tmp2_ = as_str;
#line 270 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	if (_tmp2_ != NULL) {
#line 585 "tracker-cursor.c"
		const gchar* _tmp3_;
#line 270 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		_tmp3_ = as_str;
#line 270 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		_tmp1_ = g_ascii_strcasecmp (_tmp3_, "true") == 0;
#line 591 "tracker-cursor.c"
	} else {
#line 270 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		_tmp1_ = FALSE;
#line 595 "tracker-cursor.c"
	}
#line 270 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	if (_tmp1_) {
#line 271 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		result = TRUE;
#line 271 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		return result;
#line 603 "tracker-cursor.c"
	}
#line 274 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	result = FALSE;
#line 274 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	return result;
#line 609 "tracker-cursor.c"
}

gboolean
tracker_sparql_cursor_get_boolean (TrackerSparqlCursor* self,
                                   gint column)
{
	TrackerSparqlCursorClass* _klass_;
#line 265 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 265 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	_klass_ = TRACKER_SPARQL_CURSOR_GET_CLASS (self);
#line 265 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	if (_klass_->get_boolean) {
#line 265 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		return _klass_->get_boolean (self, column);
#line 625 "tracker-cursor.c"
	}
#line 265 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	return FALSE;
#line 629 "tracker-cursor.c"
}

/**
 * tracker_sparql_cursor_is_bound:
 * @self: a #TrackerSparqlCursor
 * @column: column number to retrieve (first one is 0)
 *
 * If the current row and @column are bound to a value, %TRUE is returned.
 *
 * Returns: a %TRUE or %FALSE.
 *
 * Since: 0.10
 */
static gboolean
tracker_sparql_cursor_real_is_bound (TrackerSparqlCursor* self,
                                     gint column)
{
	gboolean result;
#line 289 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	if (tracker_sparql_cursor_get_value_type (self, column) != TRACKER_SPARQL_VALUE_TYPE_UNBOUND) {
#line 290 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		result = TRUE;
#line 290 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		return result;
#line 654 "tracker-cursor.c"
	}
#line 292 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	result = FALSE;
#line 292 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	return result;
#line 660 "tracker-cursor.c"
}

gboolean
tracker_sparql_cursor_is_bound (TrackerSparqlCursor* self,
                                gint column)
{
	TrackerSparqlCursorClass* _klass_;
#line 288 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 288 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	_klass_ = TRACKER_SPARQL_CURSOR_GET_CLASS (self);
#line 288 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	if (_klass_->is_bound) {
#line 288 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		return _klass_->is_bound (self, column);
#line 676 "tracker-cursor.c"
	}
#line 288 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	return FALSE;
#line 680 "tracker-cursor.c"
}

TrackerSparqlCursor*
tracker_sparql_cursor_construct (GType object_type)
{
	TrackerSparqlCursor * self = NULL;
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	self = (TrackerSparqlCursor*) g_object_new (object_type, NULL);
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	return self;
#line 691 "tracker-cursor.c"
}

/**
 * tracker_sparql_cursor_get_connection:
 * @self: a #TrackerSparqlCursor
 *
 * Returns: the #TrackerSparqlConnection associated with this
 * #TrackerSparqlCursor. The returned object must not be unreferenced
 * by the caller.
 *
 * Since: 0.10
 */
TrackerSparqlConnection*
tracker_sparql_cursor_get_connection (TrackerSparqlCursor* self)
{
	TrackerSparqlConnection* result;
	TrackerSparqlConnection* _tmp0_;
#line 85 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 85 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	_tmp0_ = self->priv->_connection;
#line 85 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	result = _tmp0_;
#line 85 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	return result;
#line 717 "tracker-cursor.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 88 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	return self ? g_object_ref (self) : NULL;
#line 725 "tracker-cursor.c"
}

void
tracker_sparql_cursor_set_connection (TrackerSparqlCursor* self,
                                      TrackerSparqlConnection* value)
{
	TrackerSparqlConnection* old_value;
#line 88 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	g_return_if_fail (self != NULL);
#line 88 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	old_value = tracker_sparql_cursor_get_connection (self);
#line 88 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	if (old_value != value) {
#line 739 "tracker-cursor.c"
		TrackerSparqlConnection* _tmp0_;
#line 88 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 88 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		_g_object_unref0 (self->priv->_connection);
#line 88 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		self->priv->_connection = _tmp0_;
#line 88 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		g_object_notify_by_pspec ((GObject *) self, tracker_sparql_cursor_properties[TRACKER_SPARQL_CURSOR_CONNECTION_PROPERTY]);
#line 749 "tracker-cursor.c"
	}
}

/**
 * tracker_sparql_cursor_get_n_columns:
 * @self: a #TrackerSparqlCursor
 *
 * This method should only be called after a successful
 * tracker_sparql_cursor_next(); otherwise its return value
 * will be undefined.
 *
 * Returns: a #gint representing the number of columns available in the
 * results to iterate.
 *
 * Since: 0.10
 */
gint
tracker_sparql_cursor_get_n_columns (TrackerSparqlCursor* self)
{
	TrackerSparqlCursorClass* _klass_;
#line 112 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 112 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	_klass_ = TRACKER_SPARQL_CURSOR_GET_CLASS (self);
#line 112 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	if (_klass_->get_n_columns) {
#line 112 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		return _klass_->get_n_columns (self);
#line 778 "tracker-cursor.c"
	}
#line 112 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	return -1;
#line 782 "tracker-cursor.c"
}

static void
tracker_sparql_cursor_class_init (TrackerSparqlCursorClass * klass,
                                  gpointer klass_data)
{
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	tracker_sparql_cursor_parent_class = g_type_class_peek_parent (klass);
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	g_type_class_adjust_private_offset (klass, &TrackerSparqlCursor_private_offset);
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->get_value_type = (TrackerSparqlValueType (*) (TrackerSparqlCursor*, gint)) tracker_sparql_cursor_real_get_value_type;
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->get_variable_name = (const gchar* (*) (TrackerSparqlCursor*, gint)) tracker_sparql_cursor_real_get_variable_name;
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->get_string = (const gchar* (*) (TrackerSparqlCursor*, gint, glong*)) tracker_sparql_cursor_real_get_string;
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->next = (gboolean (*) (TrackerSparqlCursor*, GCancellable*, GError**)) tracker_sparql_cursor_real_next;
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->rewind = (void (*) (TrackerSparqlCursor*)) tracker_sparql_cursor_real_rewind;
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->close = (void (*) (TrackerSparqlCursor*)) tracker_sparql_cursor_real_close;
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->get_integer = (gint64 (*) (TrackerSparqlCursor*, gint)) tracker_sparql_cursor_real_get_integer;
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->get_double = (gdouble (*) (TrackerSparqlCursor*, gint)) tracker_sparql_cursor_real_get_double;
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->get_boolean = (gboolean (*) (TrackerSparqlCursor*, gint)) tracker_sparql_cursor_real_get_boolean;
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->is_bound = (gboolean (*) (TrackerSparqlCursor*, gint)) tracker_sparql_cursor_real_is_bound;
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_cursor_get_property;
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_sparql_cursor_set_property;
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_cursor_finalize;
#line 819 "tracker-cursor.c"
	/**
	 * TrackerSparqlCursor:connection:
	 *
	 * The #TrackerSparqlConnection used to retrieve the results.
	 *
	 * Since: 0.10
	 */
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_CURSOR_CONNECTION_PROPERTY, tracker_sparql_cursor_properties[TRACKER_SPARQL_CURSOR_CONNECTION_PROPERTY] = g_param_spec_object ("connection", "connection", "connection", TRACKER_SPARQL_TYPE_CONNECTION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 829 "tracker-cursor.c"
	/**
	 * TrackerSparqlCursor:n_columns:
	 *
	 * Number of columns available in the results to iterate.
	 *
	 * Since: 0.10
	 */
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_CURSOR_N_COLUMNS_PROPERTY, tracker_sparql_cursor_properties[TRACKER_SPARQL_CURSOR_N_COLUMNS_PROPERTY] = g_param_spec_int ("n-columns", "n-columns", "n-columns", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 839 "tracker-cursor.c"
}

static void
tracker_sparql_cursor_instance_init (TrackerSparqlCursor * self,
                                     gpointer klass)
{
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	self->priv = tracker_sparql_cursor_get_instance_private (self);
#line 848 "tracker-cursor.c"
}

static void
tracker_sparql_cursor_finalize (GObject * obj)
{
	TrackerSparqlCursor * self;
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_CURSOR, TrackerSparqlCursor);
#line 74 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	_g_object_unref0 (self->priv->_connection);
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	G_OBJECT_CLASS (tracker_sparql_cursor_parent_class)->finalize (obj);
#line 861 "tracker-cursor.c"
}

/**
 * TrackerSparqlCursor:
 *
 * The <structname>TrackerSparqlCursor</structname> object represents an
 * iterator of results.
 */
static GType
tracker_sparql_cursor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlCursorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_cursor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlCursor), 0, (GInstanceInitFunc) tracker_sparql_cursor_instance_init, NULL };
	GType tracker_sparql_cursor_type_id;
	tracker_sparql_cursor_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlCursor", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	TrackerSparqlCursor_private_offset = g_type_add_instance_private (tracker_sparql_cursor_type_id, sizeof (TrackerSparqlCursorPrivate));
	return tracker_sparql_cursor_type_id;
}

GType
tracker_sparql_cursor_get_type (void)
{
	static volatile gsize tracker_sparql_cursor_type_id__once = 0;
	if (g_once_init_enter (&tracker_sparql_cursor_type_id__once)) {
		GType tracker_sparql_cursor_type_id;
		tracker_sparql_cursor_type_id = tracker_sparql_cursor_get_type_once ();
		g_once_init_leave (&tracker_sparql_cursor_type_id__once, tracker_sparql_cursor_type_id);
	}
	return tracker_sparql_cursor_type_id__once;
}

static void
_vala_tracker_sparql_cursor_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	TrackerSparqlCursor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_CURSOR, TrackerSparqlCursor);
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	switch (property_id) {
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		case TRACKER_SPARQL_CURSOR_CONNECTION_PROPERTY:
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		g_value_set_object (value, tracker_sparql_cursor_get_connection (self));
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		break;
#line 908 "tracker-cursor.c"
		default:
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		break;
#line 914 "tracker-cursor.c"
	}
}

static void
_vala_tracker_sparql_cursor_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	TrackerSparqlCursor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_CURSOR, TrackerSparqlCursor);
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
	switch (property_id) {
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		case TRACKER_SPARQL_CURSOR_CONNECTION_PROPERTY:
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		tracker_sparql_cursor_set_connection (self, g_value_get_object (value));
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		break;
#line 934 "tracker-cursor.c"
		default:
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 65 "../tracker/src/libtracker-sparql/tracker-cursor.vala"
		break;
#line 940 "tracker-cursor.c"
	}
}

