// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from esp32.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Espressif

//go:build esp && esp32

// 32-bit MCU & 2.4 GHz Wi-Fi & Bluetooth/Bluetooth LE
//
//	Copyright 2023 Espressif Systems (Shanghai) PTE LTD Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
package esp

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "ESP32"
	CPU          = "Xtensa LX6"
	FPUPresent   = true
	NVICPrioBits = 0
)

// Interrupt numbers.
const (
	// DPORT Peripheral
	IRQ_WIFI_MAC = 0

	// DPORT Peripheral
	IRQ_WIFI_NMI = 1

	// DPORT Peripheral
	IRQ_WIFI_BB = 2

	// DPORT Peripheral
	IRQ_BT_MAC = 3

	// DPORT Peripheral
	IRQ_BT_BB = 4

	// DPORT Peripheral
	IRQ_BT_BB_NMI = 5

	// DPORT Peripheral
	IRQ_RWBT = 6

	// DPORT Peripheral
	IRQ_RWBLE = 7

	// DPORT Peripheral
	IRQ_RWBT_NMI = 8

	// DPORT Peripheral
	IRQ_RWBLE_NMI = 9

	// Universal Host Controller Interface 0
	IRQ_UHCI0 = 12

	// Universal Host Controller Interface 1
	IRQ_UHCI1 = 13

	// Timer Group 0
	IRQ_TG0_T0_LEVEL = 14

	// Timer Group 0
	IRQ_TG0_T1_LEVEL = 15

	// Timer Group 0
	IRQ_TG0_WDT_LEVEL = 16

	// Timer Group 0
	IRQ_TG0_LACT_LEVEL = 17

	// Timer Group 1
	IRQ_TG1_T0_LEVEL = 18

	// Timer Group 1
	IRQ_TG1_T1_LEVEL = 19

	// Timer Group 1
	IRQ_TG1_WDT_LEVEL = 20

	// Timer Group 1
	IRQ_TG1_LACT_LEVEL = 21

	// General Purpose Input/Output
	IRQ_GPIO = 22

	// General Purpose Input/Output
	IRQ_GPIO_NMI = 23

	// DPORT Peripheral
	IRQ_FROM_CPU_INTR0 = 24

	// DPORT Peripheral
	IRQ_FROM_CPU_INTR1 = 25

	// DPORT Peripheral
	IRQ_FROM_CPU_INTR2 = 26

	// DPORT Peripheral
	IRQ_FROM_CPU_INTR3 = 27

	// SPI (Serial Peripheral Interface) Controller 0
	IRQ_SPI0 = 28

	// SPI (Serial Peripheral Interface) Controller 1
	IRQ_SPI1 = 29

	// SPI (Serial Peripheral Interface) Controller 2
	IRQ_SPI2 = 30

	// SPI (Serial Peripheral Interface) Controller 3
	IRQ_SPI3 = 31

	// I2S (Inter-IC Sound) Controller 0
	IRQ_I2S0 = 32

	// I2S (Inter-IC Sound) Controller 1
	IRQ_I2S1 = 33

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 0
	IRQ_UART0 = 34

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 1
	IRQ_UART1 = 35

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 2
	IRQ_UART2 = 36

	// DPORT Peripheral
	IRQ_SDIO_HOST = 37

	// DPORT Peripheral
	IRQ_ETH_MAC = 38

	// Motor Control Pulse-Width Modulation 0
	IRQ_MCPWM0 = 39

	// Motor Control Pulse-Width Modulation 0
	IRQ_MCPWM1 = 40

	// Motor Control Pulse-Width Modulation 0
	IRQ_MCPWM2 = 41

	// Motor Control Pulse-Width Modulation 0
	IRQ_MCPWM3 = 42

	// LED Control PWM (Pulse Width Modulation)
	IRQ_LEDC = 43

	// eFuse Controller
	IRQ_EFUSE = 44

	// Two-Wire Automotive Interface
	IRQ_TWAI0 = 45

	// Real-Time Clock Control
	IRQ_RTC_CORE = 46

	// Remote Control
	IRQ_RMT = 47

	// Pulse Count Controller
	IRQ_PCNT = 48

	// I2C (Inter-Integrated Circuit) Controller 0
	IRQ_I2C_EXT0 = 49

	// I2C (Inter-Integrated Circuit) Controller 1
	IRQ_I2C_EXT1 = 50

	// RSA (Rivest Shamir Adleman) Accelerator
	IRQ_RSA = 51

	// SPI (Serial Peripheral Interface) Controller 1
	IRQ_SPI1_DMA = 52

	// SPI (Serial Peripheral Interface) Controller 2
	IRQ_SPI2_DMA = 53

	// SPI (Serial Peripheral Interface) Controller 3
	IRQ_SPI3_DMA = 54

	// DPORT Peripheral
	IRQ_WDT = 55

	// LED Control PWM (Pulse Width Modulation)
	IRQ_TIMER1 = 56

	// LED Control PWM (Pulse Width Modulation)
	IRQ_TIMER2 = 57

	// Timer Group 0
	IRQ_TG0_T0_EDGE = 58

	// Timer Group 0
	IRQ_TG0_T1_EDGE = 59

	// Timer Group 0
	IRQ_TG0_WDT_EDGE = 60

	// Timer Group 0
	IRQ_TG0_LACT_EDGE = 61

	// Timer Group 1
	IRQ_TG1_T0_EDGE = 62

	// Timer Group 1
	IRQ_TG1_T1_EDGE = 63

	// Timer Group 1
	IRQ_TG1_WDT_EDGE = 64

	// Timer Group 1
	IRQ_TG1_LACT_EDGE = 65

	// DPORT Peripheral
	IRQ_MMU_IA = 66

	// DPORT Peripheral
	IRQ_MPU_IA = 67

	// DPORT Peripheral
	IRQ_CACHE_IA = 68

	// Highest interrupt number on this device.
	IRQ_max = 68
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)
func HandleInterrupt(num int) {
	switch num {
	case IRQ_WIFI_MAC:
		callHandlers(IRQ_WIFI_MAC)
	case IRQ_WIFI_NMI:
		callHandlers(IRQ_WIFI_NMI)
	case IRQ_WIFI_BB:
		callHandlers(IRQ_WIFI_BB)
	case IRQ_BT_MAC:
		callHandlers(IRQ_BT_MAC)
	case IRQ_BT_BB:
		callHandlers(IRQ_BT_BB)
	case IRQ_BT_BB_NMI:
		callHandlers(IRQ_BT_BB_NMI)
	case IRQ_RWBT:
		callHandlers(IRQ_RWBT)
	case IRQ_RWBLE:
		callHandlers(IRQ_RWBLE)
	case IRQ_RWBT_NMI:
		callHandlers(IRQ_RWBT_NMI)
	case IRQ_RWBLE_NMI:
		callHandlers(IRQ_RWBLE_NMI)
	case IRQ_UHCI0:
		callHandlers(IRQ_UHCI0)
	case IRQ_UHCI1:
		callHandlers(IRQ_UHCI1)
	case IRQ_TG0_T0_LEVEL:
		callHandlers(IRQ_TG0_T0_LEVEL)
	case IRQ_TG0_T1_LEVEL:
		callHandlers(IRQ_TG0_T1_LEVEL)
	case IRQ_TG0_WDT_LEVEL:
		callHandlers(IRQ_TG0_WDT_LEVEL)
	case IRQ_TG0_LACT_LEVEL:
		callHandlers(IRQ_TG0_LACT_LEVEL)
	case IRQ_TG1_T0_LEVEL:
		callHandlers(IRQ_TG1_T0_LEVEL)
	case IRQ_TG1_T1_LEVEL:
		callHandlers(IRQ_TG1_T1_LEVEL)
	case IRQ_TG1_WDT_LEVEL:
		callHandlers(IRQ_TG1_WDT_LEVEL)
	case IRQ_TG1_LACT_LEVEL:
		callHandlers(IRQ_TG1_LACT_LEVEL)
	case IRQ_GPIO:
		callHandlers(IRQ_GPIO)
	case IRQ_GPIO_NMI:
		callHandlers(IRQ_GPIO_NMI)
	case IRQ_FROM_CPU_INTR0:
		callHandlers(IRQ_FROM_CPU_INTR0)
	case IRQ_FROM_CPU_INTR1:
		callHandlers(IRQ_FROM_CPU_INTR1)
	case IRQ_FROM_CPU_INTR2:
		callHandlers(IRQ_FROM_CPU_INTR2)
	case IRQ_FROM_CPU_INTR3:
		callHandlers(IRQ_FROM_CPU_INTR3)
	case IRQ_SPI0:
		callHandlers(IRQ_SPI0)
	case IRQ_SPI1:
		callHandlers(IRQ_SPI1)
	case IRQ_SPI2:
		callHandlers(IRQ_SPI2)
	case IRQ_SPI3:
		callHandlers(IRQ_SPI3)
	case IRQ_I2S0:
		callHandlers(IRQ_I2S0)
	case IRQ_I2S1:
		callHandlers(IRQ_I2S1)
	case IRQ_UART0:
		callHandlers(IRQ_UART0)
	case IRQ_UART1:
		callHandlers(IRQ_UART1)
	case IRQ_UART2:
		callHandlers(IRQ_UART2)
	case IRQ_SDIO_HOST:
		callHandlers(IRQ_SDIO_HOST)
	case IRQ_ETH_MAC:
		callHandlers(IRQ_ETH_MAC)
	case IRQ_MCPWM0:
		callHandlers(IRQ_MCPWM0)
	case IRQ_MCPWM1:
		callHandlers(IRQ_MCPWM1)
	case IRQ_MCPWM2:
		callHandlers(IRQ_MCPWM2)
	case IRQ_MCPWM3:
		callHandlers(IRQ_MCPWM3)
	case IRQ_LEDC:
		callHandlers(IRQ_LEDC)
	case IRQ_EFUSE:
		callHandlers(IRQ_EFUSE)
	case IRQ_TWAI0:
		callHandlers(IRQ_TWAI0)
	case IRQ_RTC_CORE:
		callHandlers(IRQ_RTC_CORE)
	case IRQ_RMT:
		callHandlers(IRQ_RMT)
	case IRQ_PCNT:
		callHandlers(IRQ_PCNT)
	case IRQ_I2C_EXT0:
		callHandlers(IRQ_I2C_EXT0)
	case IRQ_I2C_EXT1:
		callHandlers(IRQ_I2C_EXT1)
	case IRQ_RSA:
		callHandlers(IRQ_RSA)
	case IRQ_SPI1_DMA:
		callHandlers(IRQ_SPI1_DMA)
	case IRQ_SPI2_DMA:
		callHandlers(IRQ_SPI2_DMA)
	case IRQ_SPI3_DMA:
		callHandlers(IRQ_SPI3_DMA)
	case IRQ_WDT:
		callHandlers(IRQ_WDT)
	case IRQ_TIMER1:
		callHandlers(IRQ_TIMER1)
	case IRQ_TIMER2:
		callHandlers(IRQ_TIMER2)
	case IRQ_TG0_T0_EDGE:
		callHandlers(IRQ_TG0_T0_EDGE)
	case IRQ_TG0_T1_EDGE:
		callHandlers(IRQ_TG0_T1_EDGE)
	case IRQ_TG0_WDT_EDGE:
		callHandlers(IRQ_TG0_WDT_EDGE)
	case IRQ_TG0_LACT_EDGE:
		callHandlers(IRQ_TG0_LACT_EDGE)
	case IRQ_TG1_T0_EDGE:
		callHandlers(IRQ_TG1_T0_EDGE)
	case IRQ_TG1_T1_EDGE:
		callHandlers(IRQ_TG1_T1_EDGE)
	case IRQ_TG1_WDT_EDGE:
		callHandlers(IRQ_TG1_WDT_EDGE)
	case IRQ_TG1_LACT_EDGE:
		callHandlers(IRQ_TG1_LACT_EDGE)
	case IRQ_MMU_IA:
		callHandlers(IRQ_MMU_IA)
	case IRQ_MPU_IA:
		callHandlers(IRQ_MPU_IA)
	case IRQ_CACHE_IA:
		callHandlers(IRQ_CACHE_IA)
	}
}

// Peripherals.
var (
	// AES (Advanced Encryption Standard) Accelerator
	AES = (*AES_Type)(unsafe.Pointer(uintptr(0x3ff01000)))

	// APB (Advanced Peripheral Bus) Controller
	APB_CTRL = (*APB_CTRL_Type)(unsafe.Pointer(uintptr(0x3ff66000)))

	// BB Peripheral
	BB = (*BB_Type)(unsafe.Pointer(uintptr(0x3ff5d000)))

	// DPORT Peripheral
	DPORT = (*DPORT_Type)(unsafe.Pointer(uintptr(0x3ff00000)))

	// eFuse Controller
	EFUSE = (*EFUSE_Type)(unsafe.Pointer(uintptr(0x3ff5a000)))

	// Ethernet DMA configuration and control registers
	EMAC_DMA = (*EMAC_DMA_Type)(unsafe.Pointer(uintptr(0x3ff69000)))

	// Ethernet Clock, PHY type, and SRAM configuration registers
	EMAC_EXT = (*EMAC_EXT_Type)(unsafe.Pointer(uintptr(0x3ff69800)))

	// Ethernet MAC configuration and control registers
	EMAC_MAC = (*EMAC_MAC_Type)(unsafe.Pointer(uintptr(0x3ff6a000)))

	// FLASH_ENCRYPTION Peripheral
	FLASH_ENCRYPTION = (*FLASH_ENCRYPTION_Type)(unsafe.Pointer(uintptr(0x3ff46000)))

	// FRC_TIMER Peripheral
	FRC_TIMER = (*FRC_Type)(unsafe.Pointer(uintptr(0x3ff47000)))

	// General Purpose Input/Output
	GPIO = (*GPIO_Type)(unsafe.Pointer(uintptr(0x3ff44000)))

	// Sigma-Delta Modulation
	GPIO_SD = (*GPIO_SIGMADELTA_Type)(unsafe.Pointer(uintptr(0x3ff44f00)))

	// HINF Peripheral
	HINF = (*HINF_Type)(unsafe.Pointer(uintptr(0x3ff4b000)))

	// I2C (Inter-Integrated Circuit) Controller 0
	I2C0 = (*I2C_Type)(unsafe.Pointer(uintptr(0x3ff53000)))

	// I2S (Inter-IC Sound) Controller 0
	I2S0 = (*I2S_Type)(unsafe.Pointer(uintptr(0x3ff4f000)))

	// Input/Output Multiplexer
	IO_MUX = (*IO_MUX_Type)(unsafe.Pointer(uintptr(0x3ff49000)))

	// LED Control PWM (Pulse Width Modulation)
	LEDC = (*LEDC_Type)(unsafe.Pointer(uintptr(0x3ff59000)))

	// Motor Control Pulse-Width Modulation 0
	MCPWM0 = (*MCPWM_Type)(unsafe.Pointer(uintptr(0x3ff5e000)))

	// NRX Peripheral
	NRX = (*NRX_Type)(unsafe.Pointer(uintptr(0x3ff5cc00)))

	// Pulse Count Controller
	PCNT = (*PCNT_Type)(unsafe.Pointer(uintptr(0x3ff57000)))

	// Remote Control
	RMT = (*RMT_Type)(unsafe.Pointer(uintptr(0x3ff56000)))

	// Hardware Random Number Generator
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x60035000)))

	// RSA (Rivest Shamir Adleman) Accelerator
	RSA = (*RSA_Type)(unsafe.Pointer(uintptr(0x3ff02000)))

	// Real-Time Clock Control
	RTC_CNTL = (*RTC_CNTL_Type)(unsafe.Pointer(uintptr(0x3ff48000)))

	// Low-power Input/Output
	RTC_IO = (*RTC_GPIO_Type)(unsafe.Pointer(uintptr(0x3ff48400)))

	// Low-power I2C (Inter-Integrated Circuit) Controller
	RTC_I2C = (*RTC_I2C_Type)(unsafe.Pointer(uintptr(0x3ff48c00)))

	// SD/MMC Host Controller
	SDHOST = (*SDHOST_Type)(unsafe.Pointer(uintptr(0x3ff68000)))

	// SENS Peripheral
	SENS = (*SENS_Type)(unsafe.Pointer(uintptr(0x3ff48800)))

	// SHA (Secure Hash Algorithm) Accelerator
	SHA = (*SHA_Type)(unsafe.Pointer(uintptr(0x3ff03000)))

	// SLC Peripheral
	SLC = (*SLC_Type)(unsafe.Pointer(uintptr(0x3ff58000)))

	// SLCHOST Peripheral
	SLCHOST = (*SLCHOST_Type)(unsafe.Pointer(uintptr(0x3ff55000)))

	// SPI (Serial Peripheral Interface) Controller 0
	SPI0 = (*SPI_Type)(unsafe.Pointer(uintptr(0x3ff43000)))

	// Timer Group 0
	TIMG0 = (*TIMG_Type)(unsafe.Pointer(uintptr(0x3ff5f000)))

	// Two-Wire Automotive Interface
	TWAI0 = (*TWAI_Type)(unsafe.Pointer(uintptr(0x3ff6b000)))

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 0
	UART0 = (*UART_Type)(unsafe.Pointer(uintptr(0x3ff40000)))

	// Universal Host Controller Interface 0
	UHCI0 = (*UHCI_Type)(unsafe.Pointer(uintptr(0x3ff54000)))

	// I2C (Inter-Integrated Circuit) Controller 1
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x3ff67000)))

	// I2S (Inter-IC Sound) Controller 1
	I2S1 = (*I2S_Type)(unsafe.Pointer(uintptr(0x3ff6d000)))

	// Motor Control Pulse-Width Modulation 1
	MCPWM1 = (*MCPWM_Type)(unsafe.Pointer(uintptr(0x3ff6c000)))

	// SPI (Serial Peripheral Interface) Controller 1
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x3ff42000)))

	// SPI (Serial Peripheral Interface) Controller 2
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x3ff64000)))

	// SPI (Serial Peripheral Interface) Controller 3
	SPI3 = (*SPI_Type)(unsafe.Pointer(uintptr(0x3ff65000)))

	// Timer Group 1
	TIMG1 = (*TIMG_Type)(unsafe.Pointer(uintptr(0x3ff60000)))

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 1
	UART1 = (*UART_Type)(unsafe.Pointer(uintptr(0x3ff50000)))

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 2
	UART2 = (*UART_Type)(unsafe.Pointer(uintptr(0x3ff6e000)))

	// Universal Host Controller Interface 1
	UHCI1 = (*UHCI_Type)(unsafe.Pointer(uintptr(0x3ff4c000)))
)

// AES (Advanced Encryption Standard) Accelerator
type AES_Type struct {
	START  volatile.Register32 // 0x0
	IDLE   volatile.Register32 // 0x4
	MODE   volatile.Register32 // 0x8
	_      [4]byte
	KEY_0  volatile.Register32 // 0x10
	KEY_1  volatile.Register32 // 0x14
	KEY_2  volatile.Register32 // 0x18
	KEY_3  volatile.Register32 // 0x1C
	KEY_4  volatile.Register32 // 0x20
	KEY_5  volatile.Register32 // 0x24
	KEY_6  volatile.Register32 // 0x28
	KEY_7  volatile.Register32 // 0x2C
	TEXT_0 volatile.Register32 // 0x30
	TEXT_1 volatile.Register32 // 0x34
	TEXT_2 volatile.Register32 // 0x38
	TEXT_3 volatile.Register32 // 0x3C
	ENDIAN volatile.Register32 // 0x40
}

// AES.START
func (o *AES_Type) SetSTART(value uint32) {
	volatile.StoreUint32(&o.START.Reg, volatile.LoadUint32(&o.START.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetSTART() uint32 {
	return volatile.LoadUint32(&o.START.Reg) & 0x1
}

// AES.IDLE
func (o *AES_Type) SetIDLE(value uint32) {
	volatile.StoreUint32(&o.IDLE.Reg, volatile.LoadUint32(&o.IDLE.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetIDLE() uint32 {
	return volatile.LoadUint32(&o.IDLE.Reg) & 0x1
}

// AES.MODE
func (o *AES_Type) SetMODE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0xff)|value)
}
func (o *AES_Type) GetMODE() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0xff
}

// AES.KEY_0
func (o *AES_Type) SetKEY_0_KEY(value uint32) {
	volatile.StoreUint32(&o.KEY_0.Reg, volatile.LoadUint32(&o.KEY_0.Reg)&^(0xff)|value)
}
func (o *AES_Type) GetKEY_0_KEY() uint32 {
	return volatile.LoadUint32(&o.KEY_0.Reg) & 0xff
}

// AES.KEY_1
func (o *AES_Type) SetKEY_1_KEY(value uint32) {
	volatile.StoreUint32(&o.KEY_1.Reg, volatile.LoadUint32(&o.KEY_1.Reg)&^(0xff)|value)
}
func (o *AES_Type) GetKEY_1_KEY() uint32 {
	return volatile.LoadUint32(&o.KEY_1.Reg) & 0xff
}

// AES.KEY_2
func (o *AES_Type) SetKEY_2_KEY(value uint32) {
	volatile.StoreUint32(&o.KEY_2.Reg, volatile.LoadUint32(&o.KEY_2.Reg)&^(0xff)|value)
}
func (o *AES_Type) GetKEY_2_KEY() uint32 {
	return volatile.LoadUint32(&o.KEY_2.Reg) & 0xff
}

// AES.KEY_3
func (o *AES_Type) SetKEY_3_KEY(value uint32) {
	volatile.StoreUint32(&o.KEY_3.Reg, volatile.LoadUint32(&o.KEY_3.Reg)&^(0xff)|value)
}
func (o *AES_Type) GetKEY_3_KEY() uint32 {
	return volatile.LoadUint32(&o.KEY_3.Reg) & 0xff
}

// AES.KEY_4
func (o *AES_Type) SetKEY_4_KEY(value uint32) {
	volatile.StoreUint32(&o.KEY_4.Reg, volatile.LoadUint32(&o.KEY_4.Reg)&^(0xff)|value)
}
func (o *AES_Type) GetKEY_4_KEY() uint32 {
	return volatile.LoadUint32(&o.KEY_4.Reg) & 0xff
}

// AES.KEY_5
func (o *AES_Type) SetKEY_5_KEY(value uint32) {
	volatile.StoreUint32(&o.KEY_5.Reg, volatile.LoadUint32(&o.KEY_5.Reg)&^(0xff)|value)
}
func (o *AES_Type) GetKEY_5_KEY() uint32 {
	return volatile.LoadUint32(&o.KEY_5.Reg) & 0xff
}

// AES.KEY_6
func (o *AES_Type) SetKEY_6_KEY(value uint32) {
	volatile.StoreUint32(&o.KEY_6.Reg, volatile.LoadUint32(&o.KEY_6.Reg)&^(0xff)|value)
}
func (o *AES_Type) GetKEY_6_KEY() uint32 {
	return volatile.LoadUint32(&o.KEY_6.Reg) & 0xff
}

// AES.KEY_7
func (o *AES_Type) SetKEY_7_KEY(value uint32) {
	volatile.StoreUint32(&o.KEY_7.Reg, volatile.LoadUint32(&o.KEY_7.Reg)&^(0xff)|value)
}
func (o *AES_Type) GetKEY_7_KEY() uint32 {
	return volatile.LoadUint32(&o.KEY_7.Reg) & 0xff
}

// AES.TEXT_0
func (o *AES_Type) SetTEXT_0_TEXT(value uint32) {
	volatile.StoreUint32(&o.TEXT_0.Reg, volatile.LoadUint32(&o.TEXT_0.Reg)&^(0xff)|value)
}
func (o *AES_Type) GetTEXT_0_TEXT() uint32 {
	return volatile.LoadUint32(&o.TEXT_0.Reg) & 0xff
}

// AES.TEXT_1
func (o *AES_Type) SetTEXT_1_TEXT(value uint32) {
	volatile.StoreUint32(&o.TEXT_1.Reg, volatile.LoadUint32(&o.TEXT_1.Reg)&^(0xff)|value)
}
func (o *AES_Type) GetTEXT_1_TEXT() uint32 {
	return volatile.LoadUint32(&o.TEXT_1.Reg) & 0xff
}

// AES.TEXT_2
func (o *AES_Type) SetTEXT_2_TEXT(value uint32) {
	volatile.StoreUint32(&o.TEXT_2.Reg, volatile.LoadUint32(&o.TEXT_2.Reg)&^(0xff)|value)
}
func (o *AES_Type) GetTEXT_2_TEXT() uint32 {
	return volatile.LoadUint32(&o.TEXT_2.Reg) & 0xff
}

// AES.TEXT_3
func (o *AES_Type) SetTEXT_3_TEXT(value uint32) {
	volatile.StoreUint32(&o.TEXT_3.Reg, volatile.LoadUint32(&o.TEXT_3.Reg)&^(0xff)|value)
}
func (o *AES_Type) GetTEXT_3_TEXT() uint32 {
	return volatile.LoadUint32(&o.TEXT_3.Reg) & 0xff
}

// AES.ENDIAN
func (o *AES_Type) SetENDIAN(value uint32) {
	volatile.StoreUint32(&o.ENDIAN.Reg, volatile.LoadUint32(&o.ENDIAN.Reg)&^(0x3)|value)
}
func (o *AES_Type) GetENDIAN() uint32 {
	return volatile.LoadUint32(&o.ENDIAN.Reg) & 0x3
}

// APB (Advanced Peripheral Bus) Controller
type APB_CTRL_Type struct {
	SYSCLK_CONF               volatile.Register32 // 0x0
	XTAL_TICK_CONF            volatile.Register32 // 0x4
	PLL_TICK_CONF             volatile.Register32 // 0x8
	CK8M_TICK_CONF            volatile.Register32 // 0xC
	APB_SARADC_CTRL           volatile.Register32 // 0x10
	APB_SARADC_CTRL2          volatile.Register32 // 0x14
	APB_SARADC_FSM            volatile.Register32 // 0x18
	APB_SARADC_SAR1_PATT_TAB1 volatile.Register32 // 0x1C
	APB_SARADC_SAR1_PATT_TAB2 volatile.Register32 // 0x20
	APB_SARADC_SAR1_PATT_TAB3 volatile.Register32 // 0x24
	APB_SARADC_SAR1_PATT_TAB4 volatile.Register32 // 0x28
	APB_SARADC_SAR2_PATT_TAB1 volatile.Register32 // 0x2C
	APB_SARADC_SAR2_PATT_TAB2 volatile.Register32 // 0x30
	APB_SARADC_SAR2_PATT_TAB3 volatile.Register32 // 0x34
	APB_SARADC_SAR2_PATT_TAB4 volatile.Register32 // 0x38
	APLL_TICK_CONF            volatile.Register32 // 0x3C
	_                         [60]byte
	DATE                      volatile.Register32 // 0x7C
}

// APB_CTRL.SYSCLK_CONF
func (o *APB_CTRL_Type) SetSYSCLK_CONF_PRE_DIV_CNT(value uint32) {
	volatile.StoreUint32(&o.SYSCLK_CONF.Reg, volatile.LoadUint32(&o.SYSCLK_CONF.Reg)&^(0x3ff)|value)
}
func (o *APB_CTRL_Type) GetSYSCLK_CONF_PRE_DIV_CNT() uint32 {
	return volatile.LoadUint32(&o.SYSCLK_CONF.Reg) & 0x3ff
}
func (o *APB_CTRL_Type) SetSYSCLK_CONF_CLK_320M_EN(value uint32) {
	volatile.StoreUint32(&o.SYSCLK_CONF.Reg, volatile.LoadUint32(&o.SYSCLK_CONF.Reg)&^(0x400)|value<<10)
}
func (o *APB_CTRL_Type) GetSYSCLK_CONF_CLK_320M_EN() uint32 {
	return (volatile.LoadUint32(&o.SYSCLK_CONF.Reg) & 0x400) >> 10
}
func (o *APB_CTRL_Type) SetSYSCLK_CONF_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.SYSCLK_CONF.Reg, volatile.LoadUint32(&o.SYSCLK_CONF.Reg)&^(0x800)|value<<11)
}
func (o *APB_CTRL_Type) GetSYSCLK_CONF_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.SYSCLK_CONF.Reg) & 0x800) >> 11
}
func (o *APB_CTRL_Type) SetSYSCLK_CONF_RST_TICK_CNT(value uint32) {
	volatile.StoreUint32(&o.SYSCLK_CONF.Reg, volatile.LoadUint32(&o.SYSCLK_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *APB_CTRL_Type) GetSYSCLK_CONF_RST_TICK_CNT() uint32 {
	return (volatile.LoadUint32(&o.SYSCLK_CONF.Reg) & 0x1000) >> 12
}
func (o *APB_CTRL_Type) SetSYSCLK_CONF_QUICK_CLK_CHNG(value uint32) {
	volatile.StoreUint32(&o.SYSCLK_CONF.Reg, volatile.LoadUint32(&o.SYSCLK_CONF.Reg)&^(0x2000)|value<<13)
}
func (o *APB_CTRL_Type) GetSYSCLK_CONF_QUICK_CLK_CHNG() uint32 {
	return (volatile.LoadUint32(&o.SYSCLK_CONF.Reg) & 0x2000) >> 13
}

// APB_CTRL.XTAL_TICK_CONF
func (o *APB_CTRL_Type) SetXTAL_TICK_CONF_XTAL_TICK_NUM(value uint32) {
	volatile.StoreUint32(&o.XTAL_TICK_CONF.Reg, volatile.LoadUint32(&o.XTAL_TICK_CONF.Reg)&^(0xff)|value)
}
func (o *APB_CTRL_Type) GetXTAL_TICK_CONF_XTAL_TICK_NUM() uint32 {
	return volatile.LoadUint32(&o.XTAL_TICK_CONF.Reg) & 0xff
}

// APB_CTRL.PLL_TICK_CONF
func (o *APB_CTRL_Type) SetPLL_TICK_CONF_PLL_TICK_NUM(value uint32) {
	volatile.StoreUint32(&o.PLL_TICK_CONF.Reg, volatile.LoadUint32(&o.PLL_TICK_CONF.Reg)&^(0xff)|value)
}
func (o *APB_CTRL_Type) GetPLL_TICK_CONF_PLL_TICK_NUM() uint32 {
	return volatile.LoadUint32(&o.PLL_TICK_CONF.Reg) & 0xff
}

// APB_CTRL.CK8M_TICK_CONF
func (o *APB_CTRL_Type) SetCK8M_TICK_CONF_CK8M_TICK_NUM(value uint32) {
	volatile.StoreUint32(&o.CK8M_TICK_CONF.Reg, volatile.LoadUint32(&o.CK8M_TICK_CONF.Reg)&^(0xff)|value)
}
func (o *APB_CTRL_Type) GetCK8M_TICK_CONF_CK8M_TICK_NUM() uint32 {
	return volatile.LoadUint32(&o.CK8M_TICK_CONF.Reg) & 0xff
}

// APB_CTRL.APB_SARADC_CTRL
func (o *APB_CTRL_Type) SetAPB_SARADC_CTRL_SARADC_START_FORCE(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_CTRL.Reg, volatile.LoadUint32(&o.APB_SARADC_CTRL.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_CTRL_SARADC_START_FORCE() uint32 {
	return volatile.LoadUint32(&o.APB_SARADC_CTRL.Reg) & 0x1
}
func (o *APB_CTRL_Type) SetAPB_SARADC_CTRL_SARADC_START(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_CTRL.Reg, volatile.LoadUint32(&o.APB_SARADC_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_CTRL_SARADC_START() uint32 {
	return (volatile.LoadUint32(&o.APB_SARADC_CTRL.Reg) & 0x2) >> 1
}
func (o *APB_CTRL_Type) SetAPB_SARADC_CTRL_SARADC_SAR2_MUX(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_CTRL.Reg, volatile.LoadUint32(&o.APB_SARADC_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_CTRL_SARADC_SAR2_MUX() uint32 {
	return (volatile.LoadUint32(&o.APB_SARADC_CTRL.Reg) & 0x4) >> 2
}
func (o *APB_CTRL_Type) SetAPB_SARADC_CTRL_SARADC_WORK_MODE(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_CTRL.Reg, volatile.LoadUint32(&o.APB_SARADC_CTRL.Reg)&^(0x18)|value<<3)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_CTRL_SARADC_WORK_MODE() uint32 {
	return (volatile.LoadUint32(&o.APB_SARADC_CTRL.Reg) & 0x18) >> 3
}
func (o *APB_CTRL_Type) SetAPB_SARADC_CTRL_SARADC_SAR_SEL(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_CTRL.Reg, volatile.LoadUint32(&o.APB_SARADC_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_CTRL_SARADC_SAR_SEL() uint32 {
	return (volatile.LoadUint32(&o.APB_SARADC_CTRL.Reg) & 0x20) >> 5
}
func (o *APB_CTRL_Type) SetAPB_SARADC_CTRL_SARADC_SAR_CLK_GATED(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_CTRL.Reg, volatile.LoadUint32(&o.APB_SARADC_CTRL.Reg)&^(0x40)|value<<6)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_CTRL_SARADC_SAR_CLK_GATED() uint32 {
	return (volatile.LoadUint32(&o.APB_SARADC_CTRL.Reg) & 0x40) >> 6
}
func (o *APB_CTRL_Type) SetAPB_SARADC_CTRL_SARADC_SAR_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_CTRL.Reg, volatile.LoadUint32(&o.APB_SARADC_CTRL.Reg)&^(0x7f80)|value<<7)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_CTRL_SARADC_SAR_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.APB_SARADC_CTRL.Reg) & 0x7f80) >> 7
}
func (o *APB_CTRL_Type) SetAPB_SARADC_CTRL_SARADC_SAR1_PATT_LEN(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_CTRL.Reg, volatile.LoadUint32(&o.APB_SARADC_CTRL.Reg)&^(0x78000)|value<<15)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_CTRL_SARADC_SAR1_PATT_LEN() uint32 {
	return (volatile.LoadUint32(&o.APB_SARADC_CTRL.Reg) & 0x78000) >> 15
}
func (o *APB_CTRL_Type) SetAPB_SARADC_CTRL_SARADC_SAR2_PATT_LEN(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_CTRL.Reg, volatile.LoadUint32(&o.APB_SARADC_CTRL.Reg)&^(0x780000)|value<<19)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_CTRL_SARADC_SAR2_PATT_LEN() uint32 {
	return (volatile.LoadUint32(&o.APB_SARADC_CTRL.Reg) & 0x780000) >> 19
}
func (o *APB_CTRL_Type) SetAPB_SARADC_CTRL_SARADC_SAR1_PATT_P_CLEAR(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_CTRL.Reg, volatile.LoadUint32(&o.APB_SARADC_CTRL.Reg)&^(0x800000)|value<<23)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_CTRL_SARADC_SAR1_PATT_P_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.APB_SARADC_CTRL.Reg) & 0x800000) >> 23
}
func (o *APB_CTRL_Type) SetAPB_SARADC_CTRL_SARADC_SAR2_PATT_P_CLEAR(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_CTRL.Reg, volatile.LoadUint32(&o.APB_SARADC_CTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_CTRL_SARADC_SAR2_PATT_P_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.APB_SARADC_CTRL.Reg) & 0x1000000) >> 24
}
func (o *APB_CTRL_Type) SetAPB_SARADC_CTRL_SARADC_DATA_SAR_SEL(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_CTRL.Reg, volatile.LoadUint32(&o.APB_SARADC_CTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_CTRL_SARADC_DATA_SAR_SEL() uint32 {
	return (volatile.LoadUint32(&o.APB_SARADC_CTRL.Reg) & 0x2000000) >> 25
}
func (o *APB_CTRL_Type) SetAPB_SARADC_CTRL_SARADC_DATA_TO_I2S(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_CTRL.Reg, volatile.LoadUint32(&o.APB_SARADC_CTRL.Reg)&^(0x4000000)|value<<26)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_CTRL_SARADC_DATA_TO_I2S() uint32 {
	return (volatile.LoadUint32(&o.APB_SARADC_CTRL.Reg) & 0x4000000) >> 26
}

// APB_CTRL.APB_SARADC_CTRL2
func (o *APB_CTRL_Type) SetAPB_SARADC_CTRL2_SARADC_MEAS_NUM_LIMIT(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_CTRL2.Reg, volatile.LoadUint32(&o.APB_SARADC_CTRL2.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_CTRL2_SARADC_MEAS_NUM_LIMIT() uint32 {
	return volatile.LoadUint32(&o.APB_SARADC_CTRL2.Reg) & 0x1
}
func (o *APB_CTRL_Type) SetAPB_SARADC_CTRL2_SARADC_MAX_MEAS_NUM(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_CTRL2.Reg, volatile.LoadUint32(&o.APB_SARADC_CTRL2.Reg)&^(0x1fe)|value<<1)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_CTRL2_SARADC_MAX_MEAS_NUM() uint32 {
	return (volatile.LoadUint32(&o.APB_SARADC_CTRL2.Reg) & 0x1fe) >> 1
}
func (o *APB_CTRL_Type) SetAPB_SARADC_CTRL2_SARADC_SAR1_INV(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_CTRL2.Reg, volatile.LoadUint32(&o.APB_SARADC_CTRL2.Reg)&^(0x200)|value<<9)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_CTRL2_SARADC_SAR1_INV() uint32 {
	return (volatile.LoadUint32(&o.APB_SARADC_CTRL2.Reg) & 0x200) >> 9
}
func (o *APB_CTRL_Type) SetAPB_SARADC_CTRL2_SARADC_SAR2_INV(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_CTRL2.Reg, volatile.LoadUint32(&o.APB_SARADC_CTRL2.Reg)&^(0x400)|value<<10)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_CTRL2_SARADC_SAR2_INV() uint32 {
	return (volatile.LoadUint32(&o.APB_SARADC_CTRL2.Reg) & 0x400) >> 10
}

// APB_CTRL.APB_SARADC_FSM
func (o *APB_CTRL_Type) SetAPB_SARADC_FSM_SARADC_RSTB_WAIT(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_FSM.Reg, volatile.LoadUint32(&o.APB_SARADC_FSM.Reg)&^(0xff)|value)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_FSM_SARADC_RSTB_WAIT() uint32 {
	return volatile.LoadUint32(&o.APB_SARADC_FSM.Reg) & 0xff
}
func (o *APB_CTRL_Type) SetAPB_SARADC_FSM_SARADC_STANDBY_WAIT(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_FSM.Reg, volatile.LoadUint32(&o.APB_SARADC_FSM.Reg)&^(0xff00)|value<<8)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_FSM_SARADC_STANDBY_WAIT() uint32 {
	return (volatile.LoadUint32(&o.APB_SARADC_FSM.Reg) & 0xff00) >> 8
}
func (o *APB_CTRL_Type) SetAPB_SARADC_FSM_SARADC_START_WAIT(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_FSM.Reg, volatile.LoadUint32(&o.APB_SARADC_FSM.Reg)&^(0xff0000)|value<<16)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_FSM_SARADC_START_WAIT() uint32 {
	return (volatile.LoadUint32(&o.APB_SARADC_FSM.Reg) & 0xff0000) >> 16
}
func (o *APB_CTRL_Type) SetAPB_SARADC_FSM_SARADC_SAMPLE_CYCLE(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_FSM.Reg, volatile.LoadUint32(&o.APB_SARADC_FSM.Reg)&^(0xff000000)|value<<24)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_FSM_SARADC_SAMPLE_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.APB_SARADC_FSM.Reg) & 0xff000000) >> 24
}

// APB_CTRL.APB_SARADC_SAR1_PATT_TAB1
func (o *APB_CTRL_Type) SetAPB_SARADC_SAR1_PATT_TAB1(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_SAR1_PATT_TAB1.Reg, value)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_SAR1_PATT_TAB1() uint32 {
	return volatile.LoadUint32(&o.APB_SARADC_SAR1_PATT_TAB1.Reg)
}

// APB_CTRL.APB_SARADC_SAR1_PATT_TAB2
func (o *APB_CTRL_Type) SetAPB_SARADC_SAR1_PATT_TAB2(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_SAR1_PATT_TAB2.Reg, value)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_SAR1_PATT_TAB2() uint32 {
	return volatile.LoadUint32(&o.APB_SARADC_SAR1_PATT_TAB2.Reg)
}

// APB_CTRL.APB_SARADC_SAR1_PATT_TAB3
func (o *APB_CTRL_Type) SetAPB_SARADC_SAR1_PATT_TAB3(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_SAR1_PATT_TAB3.Reg, value)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_SAR1_PATT_TAB3() uint32 {
	return volatile.LoadUint32(&o.APB_SARADC_SAR1_PATT_TAB3.Reg)
}

// APB_CTRL.APB_SARADC_SAR1_PATT_TAB4
func (o *APB_CTRL_Type) SetAPB_SARADC_SAR1_PATT_TAB4(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_SAR1_PATT_TAB4.Reg, value)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_SAR1_PATT_TAB4() uint32 {
	return volatile.LoadUint32(&o.APB_SARADC_SAR1_PATT_TAB4.Reg)
}

// APB_CTRL.APB_SARADC_SAR2_PATT_TAB1
func (o *APB_CTRL_Type) SetAPB_SARADC_SAR2_PATT_TAB1(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_SAR2_PATT_TAB1.Reg, value)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_SAR2_PATT_TAB1() uint32 {
	return volatile.LoadUint32(&o.APB_SARADC_SAR2_PATT_TAB1.Reg)
}

// APB_CTRL.APB_SARADC_SAR2_PATT_TAB2
func (o *APB_CTRL_Type) SetAPB_SARADC_SAR2_PATT_TAB2(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_SAR2_PATT_TAB2.Reg, value)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_SAR2_PATT_TAB2() uint32 {
	return volatile.LoadUint32(&o.APB_SARADC_SAR2_PATT_TAB2.Reg)
}

// APB_CTRL.APB_SARADC_SAR2_PATT_TAB3
func (o *APB_CTRL_Type) SetAPB_SARADC_SAR2_PATT_TAB3(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_SAR2_PATT_TAB3.Reg, value)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_SAR2_PATT_TAB3() uint32 {
	return volatile.LoadUint32(&o.APB_SARADC_SAR2_PATT_TAB3.Reg)
}

// APB_CTRL.APB_SARADC_SAR2_PATT_TAB4
func (o *APB_CTRL_Type) SetAPB_SARADC_SAR2_PATT_TAB4(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC_SAR2_PATT_TAB4.Reg, value)
}
func (o *APB_CTRL_Type) GetAPB_SARADC_SAR2_PATT_TAB4() uint32 {
	return volatile.LoadUint32(&o.APB_SARADC_SAR2_PATT_TAB4.Reg)
}

// APB_CTRL.APLL_TICK_CONF
func (o *APB_CTRL_Type) SetAPLL_TICK_CONF_APLL_TICK_NUM(value uint32) {
	volatile.StoreUint32(&o.APLL_TICK_CONF.Reg, volatile.LoadUint32(&o.APLL_TICK_CONF.Reg)&^(0xff)|value)
}
func (o *APB_CTRL_Type) GetAPLL_TICK_CONF_APLL_TICK_NUM() uint32 {
	return volatile.LoadUint32(&o.APLL_TICK_CONF.Reg) & 0xff
}

// APB_CTRL.DATE
func (o *APB_CTRL_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, value)
}
func (o *APB_CTRL_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg)
}

// BB Peripheral
type BB_Type struct {
	_         [84]byte
	BBPD_CTRL volatile.Register32 // 0x54
}

// BB.BBPD_CTRL: Baseband control register
func (o *BB_Type) SetBBPD_CTRL_DC_EST_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.BBPD_CTRL.Reg, volatile.LoadUint32(&o.BBPD_CTRL.Reg)&^(0x1)|value)
}
func (o *BB_Type) GetBBPD_CTRL_DC_EST_FORCE_PD() uint32 {
	return volatile.LoadUint32(&o.BBPD_CTRL.Reg) & 0x1
}
func (o *BB_Type) SetBBPD_CTRL_DC_EST_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.BBPD_CTRL.Reg, volatile.LoadUint32(&o.BBPD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *BB_Type) GetBBPD_CTRL_DC_EST_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.BBPD_CTRL.Reg) & 0x2) >> 1
}
func (o *BB_Type) SetBBPD_CTRL_FFT_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.BBPD_CTRL.Reg, volatile.LoadUint32(&o.BBPD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *BB_Type) GetBBPD_CTRL_FFT_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.BBPD_CTRL.Reg) & 0x4) >> 2
}
func (o *BB_Type) SetBBPD_CTRL_FFT_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.BBPD_CTRL.Reg, volatile.LoadUint32(&o.BBPD_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *BB_Type) GetBBPD_CTRL_FFT_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.BBPD_CTRL.Reg) & 0x8) >> 3
}

// DPORT Peripheral
type DPORT_Type struct {
	PRO_BOOT_REMAP_CTRL           volatile.Register32 // 0x0
	APP_BOOT_REMAP_CTRL           volatile.Register32 // 0x4
	ACCESS_CHECK                  volatile.Register32 // 0x8
	PRO_DPORT_APB_MASK0           volatile.Register32 // 0xC
	PRO_DPORT_APB_MASK1           volatile.Register32 // 0x10
	APP_DPORT_APB_MASK0           volatile.Register32 // 0x14
	APP_DPORT_APB_MASK1           volatile.Register32 // 0x18
	PERI_CLK_EN                   volatile.Register32 // 0x1C
	PERI_RST_EN                   volatile.Register32 // 0x20
	WIFI_BB_CFG                   volatile.Register32 // 0x24
	WIFI_BB_CFG_2                 volatile.Register32 // 0x28
	APPCPU_CTRL_A                 volatile.Register32 // 0x2C
	APPCPU_CTRL_B                 volatile.Register32 // 0x30
	APPCPU_CTRL_C                 volatile.Register32 // 0x34
	APPCPU_CTRL_D                 volatile.Register32 // 0x38
	CPU_PER_CONF                  volatile.Register32 // 0x3C
	PRO_CACHE_CTRL                volatile.Register32 // 0x40
	PRO_CACHE_CTRL1               volatile.Register32 // 0x44
	PRO_CACHE_LOCK_0_ADDR         volatile.Register32 // 0x48
	PRO_CACHE_LOCK_1_ADDR         volatile.Register32 // 0x4C
	PRO_CACHE_LOCK_2_ADDR         volatile.Register32 // 0x50
	PRO_CACHE_LOCK_3_ADDR         volatile.Register32 // 0x54
	APP_CACHE_CTRL                volatile.Register32 // 0x58
	APP_CACHE_CTRL1               volatile.Register32 // 0x5C
	APP_CACHE_LOCK_0_ADDR         volatile.Register32 // 0x60
	APP_CACHE_LOCK_1_ADDR         volatile.Register32 // 0x64
	APP_CACHE_LOCK_2_ADDR         volatile.Register32 // 0x68
	APP_CACHE_LOCK_3_ADDR         volatile.Register32 // 0x6C
	TRACEMEM_MUX_MODE             volatile.Register32 // 0x70
	PRO_TRACEMEM_ENA              volatile.Register32 // 0x74
	APP_TRACEMEM_ENA              volatile.Register32 // 0x78
	CACHE_MUX_MODE                volatile.Register32 // 0x7C
	IMMU_PAGE_MODE                volatile.Register32 // 0x80
	DMMU_PAGE_MODE                volatile.Register32 // 0x84
	ROM_MPU_ENA                   volatile.Register32 // 0x88
	MEM_PD_MASK                   volatile.Register32 // 0x8C
	ROM_PD_CTRL                   volatile.Register32 // 0x90
	ROM_FO_CTRL                   volatile.Register32 // 0x94
	SRAM_PD_CTRL_0                volatile.Register32 // 0x98
	SRAM_PD_CTRL_1                volatile.Register32 // 0x9C
	SRAM_FO_CTRL_0                volatile.Register32 // 0xA0
	SRAM_FO_CTRL_1                volatile.Register32 // 0xA4
	IRAM_DRAM_AHB_SEL             volatile.Register32 // 0xA8
	TAG_FO_CTRL                   volatile.Register32 // 0xAC
	AHB_LITE_MASK                 volatile.Register32 // 0xB0
	AHB_MPU_TABLE_0               volatile.Register32 // 0xB4
	AHB_MPU_TABLE_1               volatile.Register32 // 0xB8
	HOST_INF_SEL                  volatile.Register32 // 0xBC
	PERIP_CLK_EN                  volatile.Register32 // 0xC0
	PERIP_RST_EN                  volatile.Register32 // 0xC4
	SLAVE_SPI_CONFIG              volatile.Register32 // 0xC8
	WIFI_CLK_EN                   volatile.Register32 // 0xCC
	CORE_RST_EN                   volatile.Register32 // 0xD0
	BT_LPCK_DIV_INT               volatile.Register32 // 0xD4
	BT_LPCK_DIV_FRAC              volatile.Register32 // 0xD8
	CPU_INTR_FROM_CPU_0           volatile.Register32 // 0xDC
	CPU_INTR_FROM_CPU_1           volatile.Register32 // 0xE0
	CPU_INTR_FROM_CPU_2           volatile.Register32 // 0xE4
	CPU_INTR_FROM_CPU_3           volatile.Register32 // 0xE8
	PRO_INTR_STATUS_0             volatile.Register32 // 0xEC
	PRO_INTR_STATUS_1             volatile.Register32 // 0xF0
	PRO_INTR_STATUS_2             volatile.Register32 // 0xF4
	APP_INTR_STATUS_0             volatile.Register32 // 0xF8
	APP_INTR_STATUS_1             volatile.Register32 // 0xFC
	APP_INTR_STATUS_2             volatile.Register32 // 0x100
	PRO_MAC_INTR_MAP              volatile.Register32 // 0x104
	PRO_MAC_NMI_MAP               volatile.Register32 // 0x108
	PRO_BB_INT_MAP                volatile.Register32 // 0x10C
	PRO_BT_MAC_INT_MAP            volatile.Register32 // 0x110
	PRO_BT_BB_INT_MAP             volatile.Register32 // 0x114
	PRO_BT_BB_NMI_MAP             volatile.Register32 // 0x118
	PRO_RWBT_IRQ_MAP              volatile.Register32 // 0x11C
	PRO_RWBLE_IRQ_MAP             volatile.Register32 // 0x120
	PRO_RWBT_NMI_MAP              volatile.Register32 // 0x124
	PRO_RWBLE_NMI_MAP             volatile.Register32 // 0x128
	PRO_SLC0_INTR_MAP             volatile.Register32 // 0x12C
	PRO_SLC1_INTR_MAP             volatile.Register32 // 0x130
	PRO_UHCI0_INTR_MAP            volatile.Register32 // 0x134
	PRO_UHCI1_INTR_MAP            volatile.Register32 // 0x138
	PRO_TG_T0_LEVEL_INT_MAP       volatile.Register32 // 0x13C
	PRO_TG_T1_LEVEL_INT_MAP       volatile.Register32 // 0x140
	PRO_TG_WDT_LEVEL_INT_MAP      volatile.Register32 // 0x144
	PRO_TG_LACT_LEVEL_INT_MAP     volatile.Register32 // 0x148
	PRO_TG1_T0_LEVEL_INT_MAP      volatile.Register32 // 0x14C
	PRO_TG1_T1_LEVEL_INT_MAP      volatile.Register32 // 0x150
	PRO_TG1_WDT_LEVEL_INT_MAP     volatile.Register32 // 0x154
	PRO_TG1_LACT_LEVEL_INT_MAP    volatile.Register32 // 0x158
	PRO_GPIO_INTERRUPT_MAP        volatile.Register32 // 0x15C
	PRO_GPIO_INTERRUPT_NMI_MAP    volatile.Register32 // 0x160
	PRO_CPU_INTR_FROM_CPU_0_MAP   volatile.Register32 // 0x164
	PRO_CPU_INTR_FROM_CPU_1_MAP   volatile.Register32 // 0x168
	PRO_CPU_INTR_FROM_CPU_2_MAP   volatile.Register32 // 0x16C
	PRO_CPU_INTR_FROM_CPU_3_MAP   volatile.Register32 // 0x170
	PRO_SPI_INTR_0_MAP            volatile.Register32 // 0x174
	PRO_SPI_INTR_1_MAP            volatile.Register32 // 0x178
	PRO_SPI_INTR_2_MAP            volatile.Register32 // 0x17C
	PRO_SPI_INTR_3_MAP            volatile.Register32 // 0x180
	PRO_I2S0_INT_MAP              volatile.Register32 // 0x184
	PRO_I2S1_INT_MAP              volatile.Register32 // 0x188
	PRO_UART_INTR_MAP             volatile.Register32 // 0x18C
	PRO_UART1_INTR_MAP            volatile.Register32 // 0x190
	PRO_UART2_INTR_MAP            volatile.Register32 // 0x194
	PRO_SDIO_HOST_INTERRUPT_MAP   volatile.Register32 // 0x198
	PRO_EMAC_INT_MAP              volatile.Register32 // 0x19C
	PRO_PWM0_INTR_MAP             volatile.Register32 // 0x1A0
	PRO_PWM1_INTR_MAP             volatile.Register32 // 0x1A4
	PRO_PWM2_INTR_MAP             volatile.Register32 // 0x1A8
	PRO_PWM3_INTR_MAP             volatile.Register32 // 0x1AC
	PRO_LEDC_INT_MAP              volatile.Register32 // 0x1B0
	PRO_EFUSE_INT_MAP             volatile.Register32 // 0x1B4
	PRO_CAN_INT_MAP               volatile.Register32 // 0x1B8
	PRO_RTC_CORE_INTR_MAP         volatile.Register32 // 0x1BC
	PRO_RMT_INTR_MAP              volatile.Register32 // 0x1C0
	PRO_PCNT_INTR_MAP             volatile.Register32 // 0x1C4
	PRO_I2C_EXT0_INTR_MAP         volatile.Register32 // 0x1C8
	PRO_I2C_EXT1_INTR_MAP         volatile.Register32 // 0x1CC
	PRO_RSA_INTR_MAP              volatile.Register32 // 0x1D0
	PRO_SPI1_DMA_INT_MAP          volatile.Register32 // 0x1D4
	PRO_SPI2_DMA_INT_MAP          volatile.Register32 // 0x1D8
	PRO_SPI3_DMA_INT_MAP          volatile.Register32 // 0x1DC
	PRO_WDG_INT_MAP               volatile.Register32 // 0x1E0
	PRO_TIMER_INT1_MAP            volatile.Register32 // 0x1E4
	PRO_TIMER_INT2_MAP            volatile.Register32 // 0x1E8
	PRO_TG_T0_EDGE_INT_MAP        volatile.Register32 // 0x1EC
	PRO_TG_T1_EDGE_INT_MAP        volatile.Register32 // 0x1F0
	PRO_TG_WDT_EDGE_INT_MAP       volatile.Register32 // 0x1F4
	PRO_TG_LACT_EDGE_INT_MAP      volatile.Register32 // 0x1F8
	PRO_TG1_T0_EDGE_INT_MAP       volatile.Register32 // 0x1FC
	PRO_TG1_T1_EDGE_INT_MAP       volatile.Register32 // 0x200
	PRO_TG1_WDT_EDGE_INT_MAP      volatile.Register32 // 0x204
	PRO_TG1_LACT_EDGE_INT_MAP     volatile.Register32 // 0x208
	PRO_MMU_IA_INT_MAP            volatile.Register32 // 0x20C
	PRO_MPU_IA_INT_MAP            volatile.Register32 // 0x210
	PRO_CACHE_IA_INT_MAP          volatile.Register32 // 0x214
	APP_MAC_INTR_MAP              volatile.Register32 // 0x218
	APP_MAC_NMI_MAP               volatile.Register32 // 0x21C
	APP_BB_INT_MAP                volatile.Register32 // 0x220
	APP_BT_MAC_INT_MAP            volatile.Register32 // 0x224
	APP_BT_BB_INT_MAP             volatile.Register32 // 0x228
	APP_BT_BB_NMI_MAP             volatile.Register32 // 0x22C
	APP_RWBT_IRQ_MAP              volatile.Register32 // 0x230
	APP_RWBLE_IRQ_MAP             volatile.Register32 // 0x234
	APP_RWBT_NMI_MAP              volatile.Register32 // 0x238
	APP_RWBLE_NMI_MAP             volatile.Register32 // 0x23C
	APP_SLC0_INTR_MAP             volatile.Register32 // 0x240
	APP_SLC1_INTR_MAP             volatile.Register32 // 0x244
	APP_UHCI0_INTR_MAP            volatile.Register32 // 0x248
	APP_UHCI1_INTR_MAP            volatile.Register32 // 0x24C
	APP_TG_T0_LEVEL_INT_MAP       volatile.Register32 // 0x250
	APP_TG_T1_LEVEL_INT_MAP       volatile.Register32 // 0x254
	APP_TG_WDT_LEVEL_INT_MAP      volatile.Register32 // 0x258
	APP_TG_LACT_LEVEL_INT_MAP     volatile.Register32 // 0x25C
	APP_TG1_T0_LEVEL_INT_MAP      volatile.Register32 // 0x260
	APP_TG1_T1_LEVEL_INT_MAP      volatile.Register32 // 0x264
	APP_TG1_WDT_LEVEL_INT_MAP     volatile.Register32 // 0x268
	APP_TG1_LACT_LEVEL_INT_MAP    volatile.Register32 // 0x26C
	APP_GPIO_INTERRUPT_MAP        volatile.Register32 // 0x270
	APP_GPIO_INTERRUPT_NMI_MAP    volatile.Register32 // 0x274
	APP_CPU_INTR_FROM_CPU_0_MAP   volatile.Register32 // 0x278
	APP_CPU_INTR_FROM_CPU_1_MAP   volatile.Register32 // 0x27C
	APP_CPU_INTR_FROM_CPU_2_MAP   volatile.Register32 // 0x280
	APP_CPU_INTR_FROM_CPU_3_MAP   volatile.Register32 // 0x284
	APP_SPI_INTR_0_MAP            volatile.Register32 // 0x288
	APP_SPI_INTR_1_MAP            volatile.Register32 // 0x28C
	APP_SPI_INTR_2_MAP            volatile.Register32 // 0x290
	APP_SPI_INTR_3_MAP            volatile.Register32 // 0x294
	APP_I2S0_INT_MAP              volatile.Register32 // 0x298
	APP_I2S1_INT_MAP              volatile.Register32 // 0x29C
	APP_UART_INTR_MAP             volatile.Register32 // 0x2A0
	APP_UART1_INTR_MAP            volatile.Register32 // 0x2A4
	APP_UART2_INTR_MAP            volatile.Register32 // 0x2A8
	APP_SDIO_HOST_INTERRUPT_MAP   volatile.Register32 // 0x2AC
	APP_EMAC_INT_MAP              volatile.Register32 // 0x2B0
	APP_PWM0_INTR_MAP             volatile.Register32 // 0x2B4
	APP_PWM1_INTR_MAP             volatile.Register32 // 0x2B8
	APP_PWM2_INTR_MAP             volatile.Register32 // 0x2BC
	APP_PWM3_INTR_MAP             volatile.Register32 // 0x2C0
	APP_LEDC_INT_MAP              volatile.Register32 // 0x2C4
	APP_EFUSE_INT_MAP             volatile.Register32 // 0x2C8
	APP_CAN_INT_MAP               volatile.Register32 // 0x2CC
	APP_RTC_CORE_INTR_MAP         volatile.Register32 // 0x2D0
	APP_RMT_INTR_MAP              volatile.Register32 // 0x2D4
	APP_PCNT_INTR_MAP             volatile.Register32 // 0x2D8
	APP_I2C_EXT0_INTR_MAP         volatile.Register32 // 0x2DC
	APP_I2C_EXT1_INTR_MAP         volatile.Register32 // 0x2E0
	APP_RSA_INTR_MAP              volatile.Register32 // 0x2E4
	APP_SPI1_DMA_INT_MAP          volatile.Register32 // 0x2E8
	APP_SPI2_DMA_INT_MAP          volatile.Register32 // 0x2EC
	APP_SPI3_DMA_INT_MAP          volatile.Register32 // 0x2F0
	APP_WDG_INT_MAP               volatile.Register32 // 0x2F4
	APP_TIMER_INT1_MAP            volatile.Register32 // 0x2F8
	APP_TIMER_INT2_MAP            volatile.Register32 // 0x2FC
	APP_TG_T0_EDGE_INT_MAP        volatile.Register32 // 0x300
	APP_TG_T1_EDGE_INT_MAP        volatile.Register32 // 0x304
	APP_TG_WDT_EDGE_INT_MAP       volatile.Register32 // 0x308
	APP_TG_LACT_EDGE_INT_MAP      volatile.Register32 // 0x30C
	APP_TG1_T0_EDGE_INT_MAP       volatile.Register32 // 0x310
	APP_TG1_T1_EDGE_INT_MAP       volatile.Register32 // 0x314
	APP_TG1_WDT_EDGE_INT_MAP      volatile.Register32 // 0x318
	APP_TG1_LACT_EDGE_INT_MAP     volatile.Register32 // 0x31C
	APP_MMU_IA_INT_MAP            volatile.Register32 // 0x320
	APP_MPU_IA_INT_MAP            volatile.Register32 // 0x324
	APP_CACHE_IA_INT_MAP          volatile.Register32 // 0x328
	AHBLITE_MPU_TABLE_UART        volatile.Register32 // 0x32C
	AHBLITE_MPU_TABLE_SPI1        volatile.Register32 // 0x330
	AHBLITE_MPU_TABLE_SPI0        volatile.Register32 // 0x334
	AHBLITE_MPU_TABLE_GPIO        volatile.Register32 // 0x338
	AHBLITE_MPU_TABLE_FE2         volatile.Register32 // 0x33C
	AHBLITE_MPU_TABLE_FE          volatile.Register32 // 0x340
	AHBLITE_MPU_TABLE_TIMER       volatile.Register32 // 0x344
	AHBLITE_MPU_TABLE_RTC         volatile.Register32 // 0x348
	AHBLITE_MPU_TABLE_IO_MUX      volatile.Register32 // 0x34C
	AHBLITE_MPU_TABLE_WDG         volatile.Register32 // 0x350
	AHBLITE_MPU_TABLE_HINF        volatile.Register32 // 0x354
	AHBLITE_MPU_TABLE_UHCI1       volatile.Register32 // 0x358
	AHBLITE_MPU_TABLE_MISC        volatile.Register32 // 0x35C
	AHBLITE_MPU_TABLE_I2C         volatile.Register32 // 0x360
	AHBLITE_MPU_TABLE_I2S0        volatile.Register32 // 0x364
	AHBLITE_MPU_TABLE_UART1       volatile.Register32 // 0x368
	AHBLITE_MPU_TABLE_BT          volatile.Register32 // 0x36C
	AHBLITE_MPU_TABLE_BT_BUFFER   volatile.Register32 // 0x370
	AHBLITE_MPU_TABLE_I2C_EXT0    volatile.Register32 // 0x374
	AHBLITE_MPU_TABLE_UHCI0       volatile.Register32 // 0x378
	AHBLITE_MPU_TABLE_SLCHOST     volatile.Register32 // 0x37C
	AHBLITE_MPU_TABLE_RMT         volatile.Register32 // 0x380
	AHBLITE_MPU_TABLE_PCNT        volatile.Register32 // 0x384
	AHBLITE_MPU_TABLE_SLC         volatile.Register32 // 0x388
	AHBLITE_MPU_TABLE_LEDC        volatile.Register32 // 0x38C
	AHBLITE_MPU_TABLE_EFUSE       volatile.Register32 // 0x390
	AHBLITE_MPU_TABLE_SPI_ENCRYPT volatile.Register32 // 0x394
	AHBLITE_MPU_TABLE_BB          volatile.Register32 // 0x398
	AHBLITE_MPU_TABLE_PWM0        volatile.Register32 // 0x39C
	AHBLITE_MPU_TABLE_TIMERGROUP  volatile.Register32 // 0x3A0
	AHBLITE_MPU_TABLE_TIMERGROUP1 volatile.Register32 // 0x3A4
	AHBLITE_MPU_TABLE_SPI2        volatile.Register32 // 0x3A8
	AHBLITE_MPU_TABLE_SPI3        volatile.Register32 // 0x3AC
	AHBLITE_MPU_TABLE_APB_CTRL    volatile.Register32 // 0x3B0
	AHBLITE_MPU_TABLE_I2C_EXT1    volatile.Register32 // 0x3B4
	AHBLITE_MPU_TABLE_SDIO_HOST   volatile.Register32 // 0x3B8
	AHBLITE_MPU_TABLE_EMAC        volatile.Register32 // 0x3BC
	AHBLITE_MPU_TABLE_CAN         volatile.Register32 // 0x3C0
	AHBLITE_MPU_TABLE_PWM1        volatile.Register32 // 0x3C4
	AHBLITE_MPU_TABLE_I2S1        volatile.Register32 // 0x3C8
	AHBLITE_MPU_TABLE_UART2       volatile.Register32 // 0x3CC
	AHBLITE_MPU_TABLE_PWM2        volatile.Register32 // 0x3D0
	AHBLITE_MPU_TABLE_PWM3        volatile.Register32 // 0x3D4
	AHBLITE_MPU_TABLE_RWBT        volatile.Register32 // 0x3D8
	AHBLITE_MPU_TABLE_BTMAC       volatile.Register32 // 0x3DC
	AHBLITE_MPU_TABLE_WIFIMAC     volatile.Register32 // 0x3E0
	AHBLITE_MPU_TABLE_PWR         volatile.Register32 // 0x3E4
	MEM_ACCESS_DBUG0              volatile.Register32 // 0x3E8
	MEM_ACCESS_DBUG1              volatile.Register32 // 0x3EC
	PRO_DCACHE_DBUG0              volatile.Register32 // 0x3F0
	PRO_DCACHE_DBUG1              volatile.Register32 // 0x3F4
	PRO_DCACHE_DBUG2              volatile.Register32 // 0x3F8
	PRO_DCACHE_DBUG3              volatile.Register32 // 0x3FC
	PRO_DCACHE_DBUG4              volatile.Register32 // 0x400
	PRO_DCACHE_DBUG5              volatile.Register32 // 0x404
	PRO_DCACHE_DBUG6              volatile.Register32 // 0x408
	PRO_DCACHE_DBUG7              volatile.Register32 // 0x40C
	PRO_DCACHE_DBUG8              volatile.Register32 // 0x410
	PRO_DCACHE_DBUG9              volatile.Register32 // 0x414
	APP_DCACHE_DBUG0              volatile.Register32 // 0x418
	APP_DCACHE_DBUG1              volatile.Register32 // 0x41C
	APP_DCACHE_DBUG2              volatile.Register32 // 0x420
	APP_DCACHE_DBUG3              volatile.Register32 // 0x424
	APP_DCACHE_DBUG4              volatile.Register32 // 0x428
	APP_DCACHE_DBUG5              volatile.Register32 // 0x42C
	APP_DCACHE_DBUG6              volatile.Register32 // 0x430
	APP_DCACHE_DBUG7              volatile.Register32 // 0x434
	APP_DCACHE_DBUG8              volatile.Register32 // 0x438
	APP_DCACHE_DBUG9              volatile.Register32 // 0x43C
	PRO_CPU_RECORD_CTRL           volatile.Register32 // 0x440
	PRO_CPU_RECORD_STATUS         volatile.Register32 // 0x444
	PRO_CPU_RECORD_PID            volatile.Register32 // 0x448
	PRO_CPU_RECORD_PDEBUGINST     volatile.Register32 // 0x44C
	PRO_CPU_RECORD_PDEBUGSTATUS   volatile.Register32 // 0x450
	PRO_CPU_RECORD_PDEBUGDATA     volatile.Register32 // 0x454
	PRO_CPU_RECORD_PDEBUGPC       volatile.Register32 // 0x458
	PRO_CPU_RECORD_PDEBUGLS0STAT  volatile.Register32 // 0x45C
	PRO_CPU_RECORD_PDEBUGLS0ADDR  volatile.Register32 // 0x460
	PRO_CPU_RECORD_PDEBUGLS0DATA  volatile.Register32 // 0x464
	APP_CPU_RECORD_CTRL           volatile.Register32 // 0x468
	APP_CPU_RECORD_STATUS         volatile.Register32 // 0x46C
	APP_CPU_RECORD_PID            volatile.Register32 // 0x470
	APP_CPU_RECORD_PDEBUGINST     volatile.Register32 // 0x474
	APP_CPU_RECORD_PDEBUGSTATUS   volatile.Register32 // 0x478
	APP_CPU_RECORD_PDEBUGDATA     volatile.Register32 // 0x47C
	APP_CPU_RECORD_PDEBUGPC       volatile.Register32 // 0x480
	APP_CPU_RECORD_PDEBUGLS0STAT  volatile.Register32 // 0x484
	APP_CPU_RECORD_PDEBUGLS0ADDR  volatile.Register32 // 0x488
	APP_CPU_RECORD_PDEBUGLS0DATA  volatile.Register32 // 0x48C
	RSA_PD_CTRL                   volatile.Register32 // 0x490
	ROM_MPU_TABLE0                volatile.Register32 // 0x494
	ROM_MPU_TABLE1                volatile.Register32 // 0x498
	ROM_MPU_TABLE2                volatile.Register32 // 0x49C
	ROM_MPU_TABLE3                volatile.Register32 // 0x4A0
	SHROM_MPU_TABLE0              volatile.Register32 // 0x4A4
	SHROM_MPU_TABLE1              volatile.Register32 // 0x4A8
	SHROM_MPU_TABLE2              volatile.Register32 // 0x4AC
	SHROM_MPU_TABLE3              volatile.Register32 // 0x4B0
	SHROM_MPU_TABLE4              volatile.Register32 // 0x4B4
	SHROM_MPU_TABLE5              volatile.Register32 // 0x4B8
	SHROM_MPU_TABLE6              volatile.Register32 // 0x4BC
	SHROM_MPU_TABLE7              volatile.Register32 // 0x4C0
	SHROM_MPU_TABLE8              volatile.Register32 // 0x4C4
	SHROM_MPU_TABLE9              volatile.Register32 // 0x4C8
	SHROM_MPU_TABLE10             volatile.Register32 // 0x4CC
	SHROM_MPU_TABLE11             volatile.Register32 // 0x4D0
	SHROM_MPU_TABLE12             volatile.Register32 // 0x4D4
	SHROM_MPU_TABLE13             volatile.Register32 // 0x4D8
	SHROM_MPU_TABLE14             volatile.Register32 // 0x4DC
	SHROM_MPU_TABLE15             volatile.Register32 // 0x4E0
	SHROM_MPU_TABLE16             volatile.Register32 // 0x4E4
	SHROM_MPU_TABLE17             volatile.Register32 // 0x4E8
	SHROM_MPU_TABLE18             volatile.Register32 // 0x4EC
	SHROM_MPU_TABLE19             volatile.Register32 // 0x4F0
	SHROM_MPU_TABLE20             volatile.Register32 // 0x4F4
	SHROM_MPU_TABLE21             volatile.Register32 // 0x4F8
	SHROM_MPU_TABLE22             volatile.Register32 // 0x4FC
	SHROM_MPU_TABLE23             volatile.Register32 // 0x500
	IMMU_TABLE0                   volatile.Register32 // 0x504
	IMMU_TABLE1                   volatile.Register32 // 0x508
	IMMU_TABLE2                   volatile.Register32 // 0x50C
	IMMU_TABLE3                   volatile.Register32 // 0x510
	IMMU_TABLE4                   volatile.Register32 // 0x514
	IMMU_TABLE5                   volatile.Register32 // 0x518
	IMMU_TABLE6                   volatile.Register32 // 0x51C
	IMMU_TABLE7                   volatile.Register32 // 0x520
	IMMU_TABLE8                   volatile.Register32 // 0x524
	IMMU_TABLE9                   volatile.Register32 // 0x528
	IMMU_TABLE10                  volatile.Register32 // 0x52C
	IMMU_TABLE11                  volatile.Register32 // 0x530
	IMMU_TABLE12                  volatile.Register32 // 0x534
	IMMU_TABLE13                  volatile.Register32 // 0x538
	IMMU_TABLE14                  volatile.Register32 // 0x53C
	IMMU_TABLE15                  volatile.Register32 // 0x540
	DMMU_TABLE0                   volatile.Register32 // 0x544
	DMMU_TABLE1                   volatile.Register32 // 0x548
	DMMU_TABLE2                   volatile.Register32 // 0x54C
	DMMU_TABLE3                   volatile.Register32 // 0x550
	DMMU_TABLE4                   volatile.Register32 // 0x554
	DMMU_TABLE5                   volatile.Register32 // 0x558
	DMMU_TABLE6                   volatile.Register32 // 0x55C
	DMMU_TABLE7                   volatile.Register32 // 0x560
	DMMU_TABLE8                   volatile.Register32 // 0x564
	DMMU_TABLE9                   volatile.Register32 // 0x568
	DMMU_TABLE10                  volatile.Register32 // 0x56C
	DMMU_TABLE11                  volatile.Register32 // 0x570
	DMMU_TABLE12                  volatile.Register32 // 0x574
	DMMU_TABLE13                  volatile.Register32 // 0x578
	DMMU_TABLE14                  volatile.Register32 // 0x57C
	DMMU_TABLE15                  volatile.Register32 // 0x580
	PRO_INTRUSION_CTRL            volatile.Register32 // 0x584
	PRO_INTRUSION_STATUS          volatile.Register32 // 0x588
	APP_INTRUSION_CTRL            volatile.Register32 // 0x58C
	APP_INTRUSION_STATUS          volatile.Register32 // 0x590
	FRONT_END_MEM_PD              volatile.Register32 // 0x594
	MMU_IA_INT_EN                 volatile.Register32 // 0x598
	MPU_IA_INT_EN                 volatile.Register32 // 0x59C
	CACHE_IA_INT_EN               volatile.Register32 // 0x5A0
	SECURE_BOOT_CTRL              volatile.Register32 // 0x5A4
	SPI_DMA_CHAN_SEL              volatile.Register32 // 0x5A8
	PRO_VECBASE_CTRL              volatile.Register32 // 0x5AC
	PRO_VECBASE_SET               volatile.Register32 // 0x5B0
	APP_VECBASE_CTRL              volatile.Register32 // 0x5B4
	APP_VECBASE_SET               volatile.Register32 // 0x5B8
	_                             [2624]byte
	DATE                          volatile.Register32 // 0xFFC
}

// DPORT.PRO_BOOT_REMAP_CTRL
func (o *DPORT_Type) SetPRO_BOOT_REMAP_CTRL_PRO_BOOT_REMAP(value uint32) {
	volatile.StoreUint32(&o.PRO_BOOT_REMAP_CTRL.Reg, volatile.LoadUint32(&o.PRO_BOOT_REMAP_CTRL.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetPRO_BOOT_REMAP_CTRL_PRO_BOOT_REMAP() uint32 {
	return volatile.LoadUint32(&o.PRO_BOOT_REMAP_CTRL.Reg) & 0x1
}

// DPORT.APP_BOOT_REMAP_CTRL
func (o *DPORT_Type) SetAPP_BOOT_REMAP_CTRL_APP_BOOT_REMAP(value uint32) {
	volatile.StoreUint32(&o.APP_BOOT_REMAP_CTRL.Reg, volatile.LoadUint32(&o.APP_BOOT_REMAP_CTRL.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetAPP_BOOT_REMAP_CTRL_APP_BOOT_REMAP() uint32 {
	return volatile.LoadUint32(&o.APP_BOOT_REMAP_CTRL.Reg) & 0x1
}

// DPORT.ACCESS_CHECK
func (o *DPORT_Type) SetACCESS_CHECK_PRO(value uint32) {
	volatile.StoreUint32(&o.ACCESS_CHECK.Reg, volatile.LoadUint32(&o.ACCESS_CHECK.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetACCESS_CHECK_PRO() uint32 {
	return volatile.LoadUint32(&o.ACCESS_CHECK.Reg) & 0x1
}
func (o *DPORT_Type) SetACCESS_CHECK_APP(value uint32) {
	volatile.StoreUint32(&o.ACCESS_CHECK.Reg, volatile.LoadUint32(&o.ACCESS_CHECK.Reg)&^(0x100)|value<<8)
}
func (o *DPORT_Type) GetACCESS_CHECK_APP() uint32 {
	return (volatile.LoadUint32(&o.ACCESS_CHECK.Reg) & 0x100) >> 8
}

// DPORT.PRO_DPORT_APB_MASK0
func (o *DPORT_Type) SetPRO_DPORT_APB_MASK0(value uint32) {
	volatile.StoreUint32(&o.PRO_DPORT_APB_MASK0.Reg, value)
}
func (o *DPORT_Type) GetPRO_DPORT_APB_MASK0() uint32 {
	return volatile.LoadUint32(&o.PRO_DPORT_APB_MASK0.Reg)
}

// DPORT.PRO_DPORT_APB_MASK1
func (o *DPORT_Type) SetPRO_DPORT_APB_MASK1(value uint32) {
	volatile.StoreUint32(&o.PRO_DPORT_APB_MASK1.Reg, value)
}
func (o *DPORT_Type) GetPRO_DPORT_APB_MASK1() uint32 {
	return volatile.LoadUint32(&o.PRO_DPORT_APB_MASK1.Reg)
}

// DPORT.APP_DPORT_APB_MASK0
func (o *DPORT_Type) SetAPP_DPORT_APB_MASK0(value uint32) {
	volatile.StoreUint32(&o.APP_DPORT_APB_MASK0.Reg, value)
}
func (o *DPORT_Type) GetAPP_DPORT_APB_MASK0() uint32 {
	return volatile.LoadUint32(&o.APP_DPORT_APB_MASK0.Reg)
}

// DPORT.APP_DPORT_APB_MASK1
func (o *DPORT_Type) SetAPP_DPORT_APB_MASK1(value uint32) {
	volatile.StoreUint32(&o.APP_DPORT_APB_MASK1.Reg, value)
}
func (o *DPORT_Type) GetAPP_DPORT_APB_MASK1() uint32 {
	return volatile.LoadUint32(&o.APP_DPORT_APB_MASK1.Reg)
}

// DPORT.PERI_CLK_EN
func (o *DPORT_Type) SetPERI_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERI_CLK_EN.Reg, value)
}
func (o *DPORT_Type) GetPERI_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.PERI_CLK_EN.Reg)
}

// DPORT.PERI_RST_EN
func (o *DPORT_Type) SetPERI_RST_EN(value uint32) {
	volatile.StoreUint32(&o.PERI_RST_EN.Reg, value)
}
func (o *DPORT_Type) GetPERI_RST_EN() uint32 {
	return volatile.LoadUint32(&o.PERI_RST_EN.Reg)
}

// DPORT.WIFI_BB_CFG
func (o *DPORT_Type) SetWIFI_BB_CFG(value uint32) {
	volatile.StoreUint32(&o.WIFI_BB_CFG.Reg, value)
}
func (o *DPORT_Type) GetWIFI_BB_CFG() uint32 {
	return volatile.LoadUint32(&o.WIFI_BB_CFG.Reg)
}

// DPORT.WIFI_BB_CFG_2
func (o *DPORT_Type) SetWIFI_BB_CFG_2(value uint32) {
	volatile.StoreUint32(&o.WIFI_BB_CFG_2.Reg, value)
}
func (o *DPORT_Type) GetWIFI_BB_CFG_2() uint32 {
	return volatile.LoadUint32(&o.WIFI_BB_CFG_2.Reg)
}

// DPORT.APPCPU_CTRL_A
func (o *DPORT_Type) SetAPPCPU_CTRL_A_APPCPU_RESETTING(value uint32) {
	volatile.StoreUint32(&o.APPCPU_CTRL_A.Reg, volatile.LoadUint32(&o.APPCPU_CTRL_A.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetAPPCPU_CTRL_A_APPCPU_RESETTING() uint32 {
	return volatile.LoadUint32(&o.APPCPU_CTRL_A.Reg) & 0x1
}

// DPORT.APPCPU_CTRL_B
func (o *DPORT_Type) SetAPPCPU_CTRL_B_APPCPU_CLKGATE_EN(value uint32) {
	volatile.StoreUint32(&o.APPCPU_CTRL_B.Reg, volatile.LoadUint32(&o.APPCPU_CTRL_B.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetAPPCPU_CTRL_B_APPCPU_CLKGATE_EN() uint32 {
	return volatile.LoadUint32(&o.APPCPU_CTRL_B.Reg) & 0x1
}

// DPORT.APPCPU_CTRL_C
func (o *DPORT_Type) SetAPPCPU_CTRL_C_APPCPU_RUNSTALL(value uint32) {
	volatile.StoreUint32(&o.APPCPU_CTRL_C.Reg, volatile.LoadUint32(&o.APPCPU_CTRL_C.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetAPPCPU_CTRL_C_APPCPU_RUNSTALL() uint32 {
	return volatile.LoadUint32(&o.APPCPU_CTRL_C.Reg) & 0x1
}

// DPORT.APPCPU_CTRL_D
func (o *DPORT_Type) SetAPPCPU_CTRL_D(value uint32) {
	volatile.StoreUint32(&o.APPCPU_CTRL_D.Reg, value)
}
func (o *DPORT_Type) GetAPPCPU_CTRL_D() uint32 {
	return volatile.LoadUint32(&o.APPCPU_CTRL_D.Reg)
}

// DPORT.CPU_PER_CONF
func (o *DPORT_Type) SetCPU_PER_CONF_CPUPERIOD_SEL(value uint32) {
	volatile.StoreUint32(&o.CPU_PER_CONF.Reg, volatile.LoadUint32(&o.CPU_PER_CONF.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetCPU_PER_CONF_CPUPERIOD_SEL() uint32 {
	return volatile.LoadUint32(&o.CPU_PER_CONF.Reg) & 0x3
}
func (o *DPORT_Type) SetCPU_PER_CONF_LOWSPEED_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CPU_PER_CONF.Reg, volatile.LoadUint32(&o.CPU_PER_CONF.Reg)&^(0x4)|value<<2)
}
func (o *DPORT_Type) GetCPU_PER_CONF_LOWSPEED_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.CPU_PER_CONF.Reg) & 0x4) >> 2
}
func (o *DPORT_Type) SetCPU_PER_CONF_FAST_CLK_RTC_SEL(value uint32) {
	volatile.StoreUint32(&o.CPU_PER_CONF.Reg, volatile.LoadUint32(&o.CPU_PER_CONF.Reg)&^(0x8)|value<<3)
}
func (o *DPORT_Type) GetCPU_PER_CONF_FAST_CLK_RTC_SEL() uint32 {
	return (volatile.LoadUint32(&o.CPU_PER_CONF.Reg) & 0x8) >> 3
}

// DPORT.PRO_CACHE_CTRL
func (o *DPORT_Type) SetPRO_CACHE_CTRL_PRO_CACHE_MODE(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *DPORT_Type) GetPRO_CACHE_CTRL_PRO_CACHE_MODE() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg) & 0x4) >> 2
}
func (o *DPORT_Type) SetPRO_CACHE_CTRL_PRO_CACHE_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *DPORT_Type) GetPRO_CACHE_CTRL_PRO_CACHE_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg) & 0x8) >> 3
}
func (o *DPORT_Type) SetPRO_CACHE_CTRL_PRO_CACHE_FLUSH_ENA(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *DPORT_Type) GetPRO_CACHE_CTRL_PRO_CACHE_FLUSH_ENA() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg) & 0x10) >> 4
}
func (o *DPORT_Type) SetPRO_CACHE_CTRL_PRO_CACHE_FLUSH_DONE(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *DPORT_Type) GetPRO_CACHE_CTRL_PRO_CACHE_FLUSH_DONE() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg) & 0x20) >> 5
}
func (o *DPORT_Type) SetPRO_CACHE_CTRL_PRO_CACHE_LOCK_0_EN(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg)&^(0x40)|value<<6)
}
func (o *DPORT_Type) GetPRO_CACHE_CTRL_PRO_CACHE_LOCK_0_EN() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg) & 0x40) >> 6
}
func (o *DPORT_Type) SetPRO_CACHE_CTRL_PRO_CACHE_LOCK_1_EN(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg)&^(0x80)|value<<7)
}
func (o *DPORT_Type) GetPRO_CACHE_CTRL_PRO_CACHE_LOCK_1_EN() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg) & 0x80) >> 7
}
func (o *DPORT_Type) SetPRO_CACHE_CTRL_PRO_CACHE_LOCK_2_EN(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *DPORT_Type) GetPRO_CACHE_CTRL_PRO_CACHE_LOCK_2_EN() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg) & 0x100) >> 8
}
func (o *DPORT_Type) SetPRO_CACHE_CTRL_PRO_CACHE_LOCK_3_EN(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *DPORT_Type) GetPRO_CACHE_CTRL_PRO_CACHE_LOCK_3_EN() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg) & 0x200) >> 9
}
func (o *DPORT_Type) SetPRO_CACHE_CTRL_PRO_SINGLE_IRAM_ENA(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *DPORT_Type) GetPRO_CACHE_CTRL_PRO_SINGLE_IRAM_ENA() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg) & 0x400) >> 10
}
func (o *DPORT_Type) SetPRO_CACHE_CTRL_PRO_DRAM_SPLIT(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *DPORT_Type) GetPRO_CACHE_CTRL_PRO_DRAM_SPLIT() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg) & 0x800) >> 11
}
func (o *DPORT_Type) SetPRO_CACHE_CTRL_PRO_AHB_SPI_REQ(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *DPORT_Type) GetPRO_CACHE_CTRL_PRO_AHB_SPI_REQ() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg) & 0x1000) >> 12
}
func (o *DPORT_Type) SetPRO_CACHE_CTRL_PRO_SLAVE_REQ(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *DPORT_Type) GetPRO_CACHE_CTRL_PRO_SLAVE_REQ() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg) & 0x2000) >> 13
}
func (o *DPORT_Type) SetPRO_CACHE_CTRL_AHB_SPI_REQ(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *DPORT_Type) GetPRO_CACHE_CTRL_AHB_SPI_REQ() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg) & 0x4000) >> 14
}
func (o *DPORT_Type) SetPRO_CACHE_CTRL_SLAVE_REQ(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg)&^(0x8000)|value<<15)
}
func (o *DPORT_Type) GetPRO_CACHE_CTRL_SLAVE_REQ() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg) & 0x8000) >> 15
}
func (o *DPORT_Type) SetPRO_CACHE_CTRL_PRO_DRAM_HL(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *DPORT_Type) GetPRO_CACHE_CTRL_PRO_DRAM_HL() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_CTRL.Reg) & 0x10000) >> 16
}

// DPORT.PRO_CACHE_CTRL1
func (o *DPORT_Type) SetPRO_CACHE_CTRL1_PRO_CACHE_MASK_IRAM0(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_CTRL1.Reg, volatile.LoadUint32(&o.PRO_CACHE_CTRL1.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetPRO_CACHE_CTRL1_PRO_CACHE_MASK_IRAM0() uint32 {
	return volatile.LoadUint32(&o.PRO_CACHE_CTRL1.Reg) & 0x1
}
func (o *DPORT_Type) SetPRO_CACHE_CTRL1_PRO_CACHE_MASK_IRAM1(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_CTRL1.Reg, volatile.LoadUint32(&o.PRO_CACHE_CTRL1.Reg)&^(0x2)|value<<1)
}
func (o *DPORT_Type) GetPRO_CACHE_CTRL1_PRO_CACHE_MASK_IRAM1() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_CTRL1.Reg) & 0x2) >> 1
}
func (o *DPORT_Type) SetPRO_CACHE_CTRL1_PRO_CACHE_MASK_IROM0(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_CTRL1.Reg, volatile.LoadUint32(&o.PRO_CACHE_CTRL1.Reg)&^(0x4)|value<<2)
}
func (o *DPORT_Type) GetPRO_CACHE_CTRL1_PRO_CACHE_MASK_IROM0() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_CTRL1.Reg) & 0x4) >> 2
}
func (o *DPORT_Type) SetPRO_CACHE_CTRL1_PRO_CACHE_MASK_DRAM1(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_CTRL1.Reg, volatile.LoadUint32(&o.PRO_CACHE_CTRL1.Reg)&^(0x8)|value<<3)
}
func (o *DPORT_Type) GetPRO_CACHE_CTRL1_PRO_CACHE_MASK_DRAM1() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_CTRL1.Reg) & 0x8) >> 3
}
func (o *DPORT_Type) SetPRO_CACHE_CTRL1_PRO_CACHE_MASK_DROM0(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_CTRL1.Reg, volatile.LoadUint32(&o.PRO_CACHE_CTRL1.Reg)&^(0x10)|value<<4)
}
func (o *DPORT_Type) GetPRO_CACHE_CTRL1_PRO_CACHE_MASK_DROM0() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_CTRL1.Reg) & 0x10) >> 4
}
func (o *DPORT_Type) SetPRO_CACHE_CTRL1_PRO_CACHE_MASK_OPSDRAM(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_CTRL1.Reg, volatile.LoadUint32(&o.PRO_CACHE_CTRL1.Reg)&^(0x20)|value<<5)
}
func (o *DPORT_Type) GetPRO_CACHE_CTRL1_PRO_CACHE_MASK_OPSDRAM() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_CTRL1.Reg) & 0x20) >> 5
}
func (o *DPORT_Type) SetPRO_CACHE_CTRL1_PRO_CMMU_SRAM_PAGE_MODE(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_CTRL1.Reg, volatile.LoadUint32(&o.PRO_CACHE_CTRL1.Reg)&^(0x1c0)|value<<6)
}
func (o *DPORT_Type) GetPRO_CACHE_CTRL1_PRO_CMMU_SRAM_PAGE_MODE() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_CTRL1.Reg) & 0x1c0) >> 6
}
func (o *DPORT_Type) SetPRO_CACHE_CTRL1_PRO_CMMU_FLASH_PAGE_MODE(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_CTRL1.Reg, volatile.LoadUint32(&o.PRO_CACHE_CTRL1.Reg)&^(0x600)|value<<9)
}
func (o *DPORT_Type) GetPRO_CACHE_CTRL1_PRO_CMMU_FLASH_PAGE_MODE() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_CTRL1.Reg) & 0x600) >> 9
}
func (o *DPORT_Type) SetPRO_CACHE_CTRL1_PRO_CMMU_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_CTRL1.Reg, volatile.LoadUint32(&o.PRO_CACHE_CTRL1.Reg)&^(0x800)|value<<11)
}
func (o *DPORT_Type) GetPRO_CACHE_CTRL1_PRO_CMMU_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_CTRL1.Reg) & 0x800) >> 11
}
func (o *DPORT_Type) SetPRO_CACHE_CTRL1_PRO_CMMU_PD(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_CTRL1.Reg, volatile.LoadUint32(&o.PRO_CACHE_CTRL1.Reg)&^(0x1000)|value<<12)
}
func (o *DPORT_Type) GetPRO_CACHE_CTRL1_PRO_CMMU_PD() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_CTRL1.Reg) & 0x1000) >> 12
}
func (o *DPORT_Type) SetPRO_CACHE_CTRL1_PRO_CACHE_MMU_IA_CLR(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_CTRL1.Reg, volatile.LoadUint32(&o.PRO_CACHE_CTRL1.Reg)&^(0x2000)|value<<13)
}
func (o *DPORT_Type) GetPRO_CACHE_CTRL1_PRO_CACHE_MMU_IA_CLR() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_CTRL1.Reg) & 0x2000) >> 13
}

// DPORT.PRO_CACHE_LOCK_0_ADDR
func (o *DPORT_Type) SetPRO_CACHE_LOCK_0_ADDR_PRE(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_LOCK_0_ADDR.Reg, volatile.LoadUint32(&o.PRO_CACHE_LOCK_0_ADDR.Reg)&^(0x3fff)|value)
}
func (o *DPORT_Type) GetPRO_CACHE_LOCK_0_ADDR_PRE() uint32 {
	return volatile.LoadUint32(&o.PRO_CACHE_LOCK_0_ADDR.Reg) & 0x3fff
}
func (o *DPORT_Type) SetPRO_CACHE_LOCK_0_ADDR_MIN(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_LOCK_0_ADDR.Reg, volatile.LoadUint32(&o.PRO_CACHE_LOCK_0_ADDR.Reg)&^(0x3c000)|value<<14)
}
func (o *DPORT_Type) GetPRO_CACHE_LOCK_0_ADDR_MIN() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_LOCK_0_ADDR.Reg) & 0x3c000) >> 14
}
func (o *DPORT_Type) SetPRO_CACHE_LOCK_0_ADDR_MAX(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_LOCK_0_ADDR.Reg, volatile.LoadUint32(&o.PRO_CACHE_LOCK_0_ADDR.Reg)&^(0x3c0000)|value<<18)
}
func (o *DPORT_Type) GetPRO_CACHE_LOCK_0_ADDR_MAX() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_LOCK_0_ADDR.Reg) & 0x3c0000) >> 18
}

// DPORT.PRO_CACHE_LOCK_1_ADDR
func (o *DPORT_Type) SetPRO_CACHE_LOCK_1_ADDR_PRE(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_LOCK_1_ADDR.Reg, volatile.LoadUint32(&o.PRO_CACHE_LOCK_1_ADDR.Reg)&^(0x3fff)|value)
}
func (o *DPORT_Type) GetPRO_CACHE_LOCK_1_ADDR_PRE() uint32 {
	return volatile.LoadUint32(&o.PRO_CACHE_LOCK_1_ADDR.Reg) & 0x3fff
}
func (o *DPORT_Type) SetPRO_CACHE_LOCK_1_ADDR_MIN(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_LOCK_1_ADDR.Reg, volatile.LoadUint32(&o.PRO_CACHE_LOCK_1_ADDR.Reg)&^(0x3c000)|value<<14)
}
func (o *DPORT_Type) GetPRO_CACHE_LOCK_1_ADDR_MIN() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_LOCK_1_ADDR.Reg) & 0x3c000) >> 14
}
func (o *DPORT_Type) SetPRO_CACHE_LOCK_1_ADDR_MAX(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_LOCK_1_ADDR.Reg, volatile.LoadUint32(&o.PRO_CACHE_LOCK_1_ADDR.Reg)&^(0x3c0000)|value<<18)
}
func (o *DPORT_Type) GetPRO_CACHE_LOCK_1_ADDR_MAX() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_LOCK_1_ADDR.Reg) & 0x3c0000) >> 18
}

// DPORT.PRO_CACHE_LOCK_2_ADDR
func (o *DPORT_Type) SetPRO_CACHE_LOCK_2_ADDR_PRE(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_LOCK_2_ADDR.Reg, volatile.LoadUint32(&o.PRO_CACHE_LOCK_2_ADDR.Reg)&^(0x3fff)|value)
}
func (o *DPORT_Type) GetPRO_CACHE_LOCK_2_ADDR_PRE() uint32 {
	return volatile.LoadUint32(&o.PRO_CACHE_LOCK_2_ADDR.Reg) & 0x3fff
}
func (o *DPORT_Type) SetPRO_CACHE_LOCK_2_ADDR_MIN(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_LOCK_2_ADDR.Reg, volatile.LoadUint32(&o.PRO_CACHE_LOCK_2_ADDR.Reg)&^(0x3c000)|value<<14)
}
func (o *DPORT_Type) GetPRO_CACHE_LOCK_2_ADDR_MIN() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_LOCK_2_ADDR.Reg) & 0x3c000) >> 14
}
func (o *DPORT_Type) SetPRO_CACHE_LOCK_2_ADDR_MAX(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_LOCK_2_ADDR.Reg, volatile.LoadUint32(&o.PRO_CACHE_LOCK_2_ADDR.Reg)&^(0x3c0000)|value<<18)
}
func (o *DPORT_Type) GetPRO_CACHE_LOCK_2_ADDR_MAX() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_LOCK_2_ADDR.Reg) & 0x3c0000) >> 18
}

// DPORT.PRO_CACHE_LOCK_3_ADDR
func (o *DPORT_Type) SetPRO_CACHE_LOCK_3_ADDR_PRE(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_LOCK_3_ADDR.Reg, volatile.LoadUint32(&o.PRO_CACHE_LOCK_3_ADDR.Reg)&^(0x3fff)|value)
}
func (o *DPORT_Type) GetPRO_CACHE_LOCK_3_ADDR_PRE() uint32 {
	return volatile.LoadUint32(&o.PRO_CACHE_LOCK_3_ADDR.Reg) & 0x3fff
}
func (o *DPORT_Type) SetPRO_CACHE_LOCK_3_ADDR_MIN(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_LOCK_3_ADDR.Reg, volatile.LoadUint32(&o.PRO_CACHE_LOCK_3_ADDR.Reg)&^(0x3c000)|value<<14)
}
func (o *DPORT_Type) GetPRO_CACHE_LOCK_3_ADDR_MIN() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_LOCK_3_ADDR.Reg) & 0x3c000) >> 14
}
func (o *DPORT_Type) SetPRO_CACHE_LOCK_3_ADDR_MAX(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_LOCK_3_ADDR.Reg, volatile.LoadUint32(&o.PRO_CACHE_LOCK_3_ADDR.Reg)&^(0x3c0000)|value<<18)
}
func (o *DPORT_Type) GetPRO_CACHE_LOCK_3_ADDR_MAX() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_LOCK_3_ADDR.Reg) & 0x3c0000) >> 18
}

// DPORT.APP_CACHE_CTRL
func (o *DPORT_Type) SetAPP_CACHE_CTRL_APP_CACHE_MODE(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_CTRL.Reg, volatile.LoadUint32(&o.APP_CACHE_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *DPORT_Type) GetAPP_CACHE_CTRL_APP_CACHE_MODE() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_CTRL.Reg) & 0x4) >> 2
}
func (o *DPORT_Type) SetAPP_CACHE_CTRL_APP_CACHE_ENABLE(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_CTRL.Reg, volatile.LoadUint32(&o.APP_CACHE_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *DPORT_Type) GetAPP_CACHE_CTRL_APP_CACHE_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_CTRL.Reg) & 0x8) >> 3
}
func (o *DPORT_Type) SetAPP_CACHE_CTRL_APP_CACHE_FLUSH_ENA(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_CTRL.Reg, volatile.LoadUint32(&o.APP_CACHE_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *DPORT_Type) GetAPP_CACHE_CTRL_APP_CACHE_FLUSH_ENA() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_CTRL.Reg) & 0x10) >> 4
}
func (o *DPORT_Type) SetAPP_CACHE_CTRL_APP_CACHE_FLUSH_DONE(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_CTRL.Reg, volatile.LoadUint32(&o.APP_CACHE_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *DPORT_Type) GetAPP_CACHE_CTRL_APP_CACHE_FLUSH_DONE() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_CTRL.Reg) & 0x20) >> 5
}
func (o *DPORT_Type) SetAPP_CACHE_CTRL_APP_CACHE_LOCK_0_EN(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_CTRL.Reg, volatile.LoadUint32(&o.APP_CACHE_CTRL.Reg)&^(0x40)|value<<6)
}
func (o *DPORT_Type) GetAPP_CACHE_CTRL_APP_CACHE_LOCK_0_EN() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_CTRL.Reg) & 0x40) >> 6
}
func (o *DPORT_Type) SetAPP_CACHE_CTRL_APP_CACHE_LOCK_1_EN(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_CTRL.Reg, volatile.LoadUint32(&o.APP_CACHE_CTRL.Reg)&^(0x80)|value<<7)
}
func (o *DPORT_Type) GetAPP_CACHE_CTRL_APP_CACHE_LOCK_1_EN() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_CTRL.Reg) & 0x80) >> 7
}
func (o *DPORT_Type) SetAPP_CACHE_CTRL_APP_CACHE_LOCK_2_EN(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_CTRL.Reg, volatile.LoadUint32(&o.APP_CACHE_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *DPORT_Type) GetAPP_CACHE_CTRL_APP_CACHE_LOCK_2_EN() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_CTRL.Reg) & 0x100) >> 8
}
func (o *DPORT_Type) SetAPP_CACHE_CTRL_APP_CACHE_LOCK_3_EN(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_CTRL.Reg, volatile.LoadUint32(&o.APP_CACHE_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *DPORT_Type) GetAPP_CACHE_CTRL_APP_CACHE_LOCK_3_EN() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_CTRL.Reg) & 0x200) >> 9
}
func (o *DPORT_Type) SetAPP_CACHE_CTRL_APP_SINGLE_IRAM_ENA(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_CTRL.Reg, volatile.LoadUint32(&o.APP_CACHE_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *DPORT_Type) GetAPP_CACHE_CTRL_APP_SINGLE_IRAM_ENA() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_CTRL.Reg) & 0x400) >> 10
}
func (o *DPORT_Type) SetAPP_CACHE_CTRL_APP_DRAM_SPLIT(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_CTRL.Reg, volatile.LoadUint32(&o.APP_CACHE_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *DPORT_Type) GetAPP_CACHE_CTRL_APP_DRAM_SPLIT() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_CTRL.Reg) & 0x800) >> 11
}
func (o *DPORT_Type) SetAPP_CACHE_CTRL_APP_AHB_SPI_REQ(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_CTRL.Reg, volatile.LoadUint32(&o.APP_CACHE_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *DPORT_Type) GetAPP_CACHE_CTRL_APP_AHB_SPI_REQ() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_CTRL.Reg) & 0x1000) >> 12
}
func (o *DPORT_Type) SetAPP_CACHE_CTRL_APP_SLAVE_REQ(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_CTRL.Reg, volatile.LoadUint32(&o.APP_CACHE_CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *DPORT_Type) GetAPP_CACHE_CTRL_APP_SLAVE_REQ() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_CTRL.Reg) & 0x2000) >> 13
}
func (o *DPORT_Type) SetAPP_CACHE_CTRL_APP_DRAM_HL(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_CTRL.Reg, volatile.LoadUint32(&o.APP_CACHE_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *DPORT_Type) GetAPP_CACHE_CTRL_APP_DRAM_HL() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_CTRL.Reg) & 0x4000) >> 14
}

// DPORT.APP_CACHE_CTRL1
func (o *DPORT_Type) SetAPP_CACHE_CTRL1_APP_CACHE_MASK_IRAM0(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_CTRL1.Reg, volatile.LoadUint32(&o.APP_CACHE_CTRL1.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetAPP_CACHE_CTRL1_APP_CACHE_MASK_IRAM0() uint32 {
	return volatile.LoadUint32(&o.APP_CACHE_CTRL1.Reg) & 0x1
}
func (o *DPORT_Type) SetAPP_CACHE_CTRL1_APP_CACHE_MASK_IRAM1(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_CTRL1.Reg, volatile.LoadUint32(&o.APP_CACHE_CTRL1.Reg)&^(0x2)|value<<1)
}
func (o *DPORT_Type) GetAPP_CACHE_CTRL1_APP_CACHE_MASK_IRAM1() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_CTRL1.Reg) & 0x2) >> 1
}
func (o *DPORT_Type) SetAPP_CACHE_CTRL1_APP_CACHE_MASK_IROM0(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_CTRL1.Reg, volatile.LoadUint32(&o.APP_CACHE_CTRL1.Reg)&^(0x4)|value<<2)
}
func (o *DPORT_Type) GetAPP_CACHE_CTRL1_APP_CACHE_MASK_IROM0() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_CTRL1.Reg) & 0x4) >> 2
}
func (o *DPORT_Type) SetAPP_CACHE_CTRL1_APP_CACHE_MASK_DRAM1(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_CTRL1.Reg, volatile.LoadUint32(&o.APP_CACHE_CTRL1.Reg)&^(0x8)|value<<3)
}
func (o *DPORT_Type) GetAPP_CACHE_CTRL1_APP_CACHE_MASK_DRAM1() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_CTRL1.Reg) & 0x8) >> 3
}
func (o *DPORT_Type) SetAPP_CACHE_CTRL1_APP_CACHE_MASK_DROM0(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_CTRL1.Reg, volatile.LoadUint32(&o.APP_CACHE_CTRL1.Reg)&^(0x10)|value<<4)
}
func (o *DPORT_Type) GetAPP_CACHE_CTRL1_APP_CACHE_MASK_DROM0() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_CTRL1.Reg) & 0x10) >> 4
}
func (o *DPORT_Type) SetAPP_CACHE_CTRL1_APP_CACHE_MASK_OPSDRAM(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_CTRL1.Reg, volatile.LoadUint32(&o.APP_CACHE_CTRL1.Reg)&^(0x20)|value<<5)
}
func (o *DPORT_Type) GetAPP_CACHE_CTRL1_APP_CACHE_MASK_OPSDRAM() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_CTRL1.Reg) & 0x20) >> 5
}
func (o *DPORT_Type) SetAPP_CACHE_CTRL1_APP_CMMU_SRAM_PAGE_MODE(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_CTRL1.Reg, volatile.LoadUint32(&o.APP_CACHE_CTRL1.Reg)&^(0x1c0)|value<<6)
}
func (o *DPORT_Type) GetAPP_CACHE_CTRL1_APP_CMMU_SRAM_PAGE_MODE() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_CTRL1.Reg) & 0x1c0) >> 6
}
func (o *DPORT_Type) SetAPP_CACHE_CTRL1_APP_CMMU_FLASH_PAGE_MODE(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_CTRL1.Reg, volatile.LoadUint32(&o.APP_CACHE_CTRL1.Reg)&^(0x600)|value<<9)
}
func (o *DPORT_Type) GetAPP_CACHE_CTRL1_APP_CMMU_FLASH_PAGE_MODE() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_CTRL1.Reg) & 0x600) >> 9
}
func (o *DPORT_Type) SetAPP_CACHE_CTRL1_APP_CMMU_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_CTRL1.Reg, volatile.LoadUint32(&o.APP_CACHE_CTRL1.Reg)&^(0x800)|value<<11)
}
func (o *DPORT_Type) GetAPP_CACHE_CTRL1_APP_CMMU_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_CTRL1.Reg) & 0x800) >> 11
}
func (o *DPORT_Type) SetAPP_CACHE_CTRL1_APP_CMMU_PD(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_CTRL1.Reg, volatile.LoadUint32(&o.APP_CACHE_CTRL1.Reg)&^(0x1000)|value<<12)
}
func (o *DPORT_Type) GetAPP_CACHE_CTRL1_APP_CMMU_PD() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_CTRL1.Reg) & 0x1000) >> 12
}
func (o *DPORT_Type) SetAPP_CACHE_CTRL1_APP_CACHE_MMU_IA_CLR(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_CTRL1.Reg, volatile.LoadUint32(&o.APP_CACHE_CTRL1.Reg)&^(0x2000)|value<<13)
}
func (o *DPORT_Type) GetAPP_CACHE_CTRL1_APP_CACHE_MMU_IA_CLR() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_CTRL1.Reg) & 0x2000) >> 13
}

// DPORT.APP_CACHE_LOCK_0_ADDR
func (o *DPORT_Type) SetAPP_CACHE_LOCK_0_ADDR_PRE(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_LOCK_0_ADDR.Reg, volatile.LoadUint32(&o.APP_CACHE_LOCK_0_ADDR.Reg)&^(0x3fff)|value)
}
func (o *DPORT_Type) GetAPP_CACHE_LOCK_0_ADDR_PRE() uint32 {
	return volatile.LoadUint32(&o.APP_CACHE_LOCK_0_ADDR.Reg) & 0x3fff
}
func (o *DPORT_Type) SetAPP_CACHE_LOCK_0_ADDR_MIN(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_LOCK_0_ADDR.Reg, volatile.LoadUint32(&o.APP_CACHE_LOCK_0_ADDR.Reg)&^(0x3c000)|value<<14)
}
func (o *DPORT_Type) GetAPP_CACHE_LOCK_0_ADDR_MIN() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_LOCK_0_ADDR.Reg) & 0x3c000) >> 14
}
func (o *DPORT_Type) SetAPP_CACHE_LOCK_0_ADDR_MAX(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_LOCK_0_ADDR.Reg, volatile.LoadUint32(&o.APP_CACHE_LOCK_0_ADDR.Reg)&^(0x3c0000)|value<<18)
}
func (o *DPORT_Type) GetAPP_CACHE_LOCK_0_ADDR_MAX() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_LOCK_0_ADDR.Reg) & 0x3c0000) >> 18
}

// DPORT.APP_CACHE_LOCK_1_ADDR
func (o *DPORT_Type) SetAPP_CACHE_LOCK_1_ADDR_PRE(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_LOCK_1_ADDR.Reg, volatile.LoadUint32(&o.APP_CACHE_LOCK_1_ADDR.Reg)&^(0x3fff)|value)
}
func (o *DPORT_Type) GetAPP_CACHE_LOCK_1_ADDR_PRE() uint32 {
	return volatile.LoadUint32(&o.APP_CACHE_LOCK_1_ADDR.Reg) & 0x3fff
}
func (o *DPORT_Type) SetAPP_CACHE_LOCK_1_ADDR_MIN(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_LOCK_1_ADDR.Reg, volatile.LoadUint32(&o.APP_CACHE_LOCK_1_ADDR.Reg)&^(0x3c000)|value<<14)
}
func (o *DPORT_Type) GetAPP_CACHE_LOCK_1_ADDR_MIN() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_LOCK_1_ADDR.Reg) & 0x3c000) >> 14
}
func (o *DPORT_Type) SetAPP_CACHE_LOCK_1_ADDR_MAX(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_LOCK_1_ADDR.Reg, volatile.LoadUint32(&o.APP_CACHE_LOCK_1_ADDR.Reg)&^(0x3c0000)|value<<18)
}
func (o *DPORT_Type) GetAPP_CACHE_LOCK_1_ADDR_MAX() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_LOCK_1_ADDR.Reg) & 0x3c0000) >> 18
}

// DPORT.APP_CACHE_LOCK_2_ADDR
func (o *DPORT_Type) SetAPP_CACHE_LOCK_2_ADDR_PRE(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_LOCK_2_ADDR.Reg, volatile.LoadUint32(&o.APP_CACHE_LOCK_2_ADDR.Reg)&^(0x3fff)|value)
}
func (o *DPORT_Type) GetAPP_CACHE_LOCK_2_ADDR_PRE() uint32 {
	return volatile.LoadUint32(&o.APP_CACHE_LOCK_2_ADDR.Reg) & 0x3fff
}
func (o *DPORT_Type) SetAPP_CACHE_LOCK_2_ADDR_MIN(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_LOCK_2_ADDR.Reg, volatile.LoadUint32(&o.APP_CACHE_LOCK_2_ADDR.Reg)&^(0x3c000)|value<<14)
}
func (o *DPORT_Type) GetAPP_CACHE_LOCK_2_ADDR_MIN() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_LOCK_2_ADDR.Reg) & 0x3c000) >> 14
}
func (o *DPORT_Type) SetAPP_CACHE_LOCK_2_ADDR_MAX(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_LOCK_2_ADDR.Reg, volatile.LoadUint32(&o.APP_CACHE_LOCK_2_ADDR.Reg)&^(0x3c0000)|value<<18)
}
func (o *DPORT_Type) GetAPP_CACHE_LOCK_2_ADDR_MAX() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_LOCK_2_ADDR.Reg) & 0x3c0000) >> 18
}

// DPORT.APP_CACHE_LOCK_3_ADDR
func (o *DPORT_Type) SetAPP_CACHE_LOCK_3_ADDR_PRE(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_LOCK_3_ADDR.Reg, volatile.LoadUint32(&o.APP_CACHE_LOCK_3_ADDR.Reg)&^(0x3fff)|value)
}
func (o *DPORT_Type) GetAPP_CACHE_LOCK_3_ADDR_PRE() uint32 {
	return volatile.LoadUint32(&o.APP_CACHE_LOCK_3_ADDR.Reg) & 0x3fff
}
func (o *DPORT_Type) SetAPP_CACHE_LOCK_3_ADDR_MIN(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_LOCK_3_ADDR.Reg, volatile.LoadUint32(&o.APP_CACHE_LOCK_3_ADDR.Reg)&^(0x3c000)|value<<14)
}
func (o *DPORT_Type) GetAPP_CACHE_LOCK_3_ADDR_MIN() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_LOCK_3_ADDR.Reg) & 0x3c000) >> 14
}
func (o *DPORT_Type) SetAPP_CACHE_LOCK_3_ADDR_MAX(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_LOCK_3_ADDR.Reg, volatile.LoadUint32(&o.APP_CACHE_LOCK_3_ADDR.Reg)&^(0x3c0000)|value<<18)
}
func (o *DPORT_Type) GetAPP_CACHE_LOCK_3_ADDR_MAX() uint32 {
	return (volatile.LoadUint32(&o.APP_CACHE_LOCK_3_ADDR.Reg) & 0x3c0000) >> 18
}

// DPORT.TRACEMEM_MUX_MODE
func (o *DPORT_Type) SetTRACEMEM_MUX_MODE(value uint32) {
	volatile.StoreUint32(&o.TRACEMEM_MUX_MODE.Reg, volatile.LoadUint32(&o.TRACEMEM_MUX_MODE.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetTRACEMEM_MUX_MODE() uint32 {
	return volatile.LoadUint32(&o.TRACEMEM_MUX_MODE.Reg) & 0x3
}

// DPORT.PRO_TRACEMEM_ENA
func (o *DPORT_Type) SetPRO_TRACEMEM_ENA(value uint32) {
	volatile.StoreUint32(&o.PRO_TRACEMEM_ENA.Reg, volatile.LoadUint32(&o.PRO_TRACEMEM_ENA.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetPRO_TRACEMEM_ENA() uint32 {
	return volatile.LoadUint32(&o.PRO_TRACEMEM_ENA.Reg) & 0x1
}

// DPORT.APP_TRACEMEM_ENA
func (o *DPORT_Type) SetAPP_TRACEMEM_ENA(value uint32) {
	volatile.StoreUint32(&o.APP_TRACEMEM_ENA.Reg, volatile.LoadUint32(&o.APP_TRACEMEM_ENA.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetAPP_TRACEMEM_ENA() uint32 {
	return volatile.LoadUint32(&o.APP_TRACEMEM_ENA.Reg) & 0x1
}

// DPORT.CACHE_MUX_MODE
func (o *DPORT_Type) SetCACHE_MUX_MODE(value uint32) {
	volatile.StoreUint32(&o.CACHE_MUX_MODE.Reg, volatile.LoadUint32(&o.CACHE_MUX_MODE.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetCACHE_MUX_MODE() uint32 {
	return volatile.LoadUint32(&o.CACHE_MUX_MODE.Reg) & 0x3
}

// DPORT.IMMU_PAGE_MODE
func (o *DPORT_Type) SetIMMU_PAGE_MODE_INTERNAL_SRAM_IMMU_ENA(value uint32) {
	volatile.StoreUint32(&o.IMMU_PAGE_MODE.Reg, volatile.LoadUint32(&o.IMMU_PAGE_MODE.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetIMMU_PAGE_MODE_INTERNAL_SRAM_IMMU_ENA() uint32 {
	return volatile.LoadUint32(&o.IMMU_PAGE_MODE.Reg) & 0x1
}
func (o *DPORT_Type) SetIMMU_PAGE_MODE(value uint32) {
	volatile.StoreUint32(&o.IMMU_PAGE_MODE.Reg, volatile.LoadUint32(&o.IMMU_PAGE_MODE.Reg)&^(0x6)|value<<1)
}
func (o *DPORT_Type) GetIMMU_PAGE_MODE() uint32 {
	return (volatile.LoadUint32(&o.IMMU_PAGE_MODE.Reg) & 0x6) >> 1
}

// DPORT.DMMU_PAGE_MODE
func (o *DPORT_Type) SetDMMU_PAGE_MODE_INTERNAL_SRAM_DMMU_ENA(value uint32) {
	volatile.StoreUint32(&o.DMMU_PAGE_MODE.Reg, volatile.LoadUint32(&o.DMMU_PAGE_MODE.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetDMMU_PAGE_MODE_INTERNAL_SRAM_DMMU_ENA() uint32 {
	return volatile.LoadUint32(&o.DMMU_PAGE_MODE.Reg) & 0x1
}
func (o *DPORT_Type) SetDMMU_PAGE_MODE(value uint32) {
	volatile.StoreUint32(&o.DMMU_PAGE_MODE.Reg, volatile.LoadUint32(&o.DMMU_PAGE_MODE.Reg)&^(0x6)|value<<1)
}
func (o *DPORT_Type) GetDMMU_PAGE_MODE() uint32 {
	return (volatile.LoadUint32(&o.DMMU_PAGE_MODE.Reg) & 0x6) >> 1
}

// DPORT.ROM_MPU_ENA
func (o *DPORT_Type) SetROM_MPU_ENA_SHARE_ROM_MPU_ENA(value uint32) {
	volatile.StoreUint32(&o.ROM_MPU_ENA.Reg, volatile.LoadUint32(&o.ROM_MPU_ENA.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetROM_MPU_ENA_SHARE_ROM_MPU_ENA() uint32 {
	return volatile.LoadUint32(&o.ROM_MPU_ENA.Reg) & 0x1
}
func (o *DPORT_Type) SetROM_MPU_ENA_PRO_ROM_MPU_ENA(value uint32) {
	volatile.StoreUint32(&o.ROM_MPU_ENA.Reg, volatile.LoadUint32(&o.ROM_MPU_ENA.Reg)&^(0x2)|value<<1)
}
func (o *DPORT_Type) GetROM_MPU_ENA_PRO_ROM_MPU_ENA() uint32 {
	return (volatile.LoadUint32(&o.ROM_MPU_ENA.Reg) & 0x2) >> 1
}
func (o *DPORT_Type) SetROM_MPU_ENA_APP_ROM_MPU_ENA(value uint32) {
	volatile.StoreUint32(&o.ROM_MPU_ENA.Reg, volatile.LoadUint32(&o.ROM_MPU_ENA.Reg)&^(0x4)|value<<2)
}
func (o *DPORT_Type) GetROM_MPU_ENA_APP_ROM_MPU_ENA() uint32 {
	return (volatile.LoadUint32(&o.ROM_MPU_ENA.Reg) & 0x4) >> 2
}

// DPORT.MEM_PD_MASK
func (o *DPORT_Type) SetMEM_PD_MASK_LSLP_MEM_PD_MASK(value uint32) {
	volatile.StoreUint32(&o.MEM_PD_MASK.Reg, volatile.LoadUint32(&o.MEM_PD_MASK.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetMEM_PD_MASK_LSLP_MEM_PD_MASK() uint32 {
	return volatile.LoadUint32(&o.MEM_PD_MASK.Reg) & 0x1
}

// DPORT.ROM_PD_CTRL
func (o *DPORT_Type) SetROM_PD_CTRL_PRO_ROM_PD(value uint32) {
	volatile.StoreUint32(&o.ROM_PD_CTRL.Reg, volatile.LoadUint32(&o.ROM_PD_CTRL.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetROM_PD_CTRL_PRO_ROM_PD() uint32 {
	return volatile.LoadUint32(&o.ROM_PD_CTRL.Reg) & 0x1
}
func (o *DPORT_Type) SetROM_PD_CTRL_APP_ROM_PD(value uint32) {
	volatile.StoreUint32(&o.ROM_PD_CTRL.Reg, volatile.LoadUint32(&o.ROM_PD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *DPORT_Type) GetROM_PD_CTRL_APP_ROM_PD() uint32 {
	return (volatile.LoadUint32(&o.ROM_PD_CTRL.Reg) & 0x2) >> 1
}
func (o *DPORT_Type) SetROM_PD_CTRL_SHARE_ROM_PD(value uint32) {
	volatile.StoreUint32(&o.ROM_PD_CTRL.Reg, volatile.LoadUint32(&o.ROM_PD_CTRL.Reg)&^(0xfc)|value<<2)
}
func (o *DPORT_Type) GetROM_PD_CTRL_SHARE_ROM_PD() uint32 {
	return (volatile.LoadUint32(&o.ROM_PD_CTRL.Reg) & 0xfc) >> 2
}

// DPORT.ROM_FO_CTRL
func (o *DPORT_Type) SetROM_FO_CTRL_PRO_ROM_FO(value uint32) {
	volatile.StoreUint32(&o.ROM_FO_CTRL.Reg, volatile.LoadUint32(&o.ROM_FO_CTRL.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetROM_FO_CTRL_PRO_ROM_FO() uint32 {
	return volatile.LoadUint32(&o.ROM_FO_CTRL.Reg) & 0x1
}
func (o *DPORT_Type) SetROM_FO_CTRL_APP_ROM_FO(value uint32) {
	volatile.StoreUint32(&o.ROM_FO_CTRL.Reg, volatile.LoadUint32(&o.ROM_FO_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *DPORT_Type) GetROM_FO_CTRL_APP_ROM_FO() uint32 {
	return (volatile.LoadUint32(&o.ROM_FO_CTRL.Reg) & 0x2) >> 1
}
func (o *DPORT_Type) SetROM_FO_CTRL_SHARE_ROM_FO(value uint32) {
	volatile.StoreUint32(&o.ROM_FO_CTRL.Reg, volatile.LoadUint32(&o.ROM_FO_CTRL.Reg)&^(0xfc)|value<<2)
}
func (o *DPORT_Type) GetROM_FO_CTRL_SHARE_ROM_FO() uint32 {
	return (volatile.LoadUint32(&o.ROM_FO_CTRL.Reg) & 0xfc) >> 2
}

// DPORT.SRAM_PD_CTRL_0
func (o *DPORT_Type) SetSRAM_PD_CTRL_0(value uint32) {
	volatile.StoreUint32(&o.SRAM_PD_CTRL_0.Reg, value)
}
func (o *DPORT_Type) GetSRAM_PD_CTRL_0() uint32 {
	return volatile.LoadUint32(&o.SRAM_PD_CTRL_0.Reg)
}

// DPORT.SRAM_PD_CTRL_1
func (o *DPORT_Type) SetSRAM_PD_CTRL_1_SRAM_PD_1(value uint32) {
	volatile.StoreUint32(&o.SRAM_PD_CTRL_1.Reg, volatile.LoadUint32(&o.SRAM_PD_CTRL_1.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetSRAM_PD_CTRL_1_SRAM_PD_1() uint32 {
	return volatile.LoadUint32(&o.SRAM_PD_CTRL_1.Reg) & 0x1
}

// DPORT.SRAM_FO_CTRL_0
func (o *DPORT_Type) SetSRAM_FO_CTRL_0(value uint32) {
	volatile.StoreUint32(&o.SRAM_FO_CTRL_0.Reg, value)
}
func (o *DPORT_Type) GetSRAM_FO_CTRL_0() uint32 {
	return volatile.LoadUint32(&o.SRAM_FO_CTRL_0.Reg)
}

// DPORT.SRAM_FO_CTRL_1
func (o *DPORT_Type) SetSRAM_FO_CTRL_1_SRAM_FO_1(value uint32) {
	volatile.StoreUint32(&o.SRAM_FO_CTRL_1.Reg, volatile.LoadUint32(&o.SRAM_FO_CTRL_1.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetSRAM_FO_CTRL_1_SRAM_FO_1() uint32 {
	return volatile.LoadUint32(&o.SRAM_FO_CTRL_1.Reg) & 0x1
}

// DPORT.IRAM_DRAM_AHB_SEL
func (o *DPORT_Type) SetIRAM_DRAM_AHB_SEL_MASK_PRO_IRAM(value uint32) {
	volatile.StoreUint32(&o.IRAM_DRAM_AHB_SEL.Reg, volatile.LoadUint32(&o.IRAM_DRAM_AHB_SEL.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetIRAM_DRAM_AHB_SEL_MASK_PRO_IRAM() uint32 {
	return volatile.LoadUint32(&o.IRAM_DRAM_AHB_SEL.Reg) & 0x1
}
func (o *DPORT_Type) SetIRAM_DRAM_AHB_SEL_MASK_APP_IRAM(value uint32) {
	volatile.StoreUint32(&o.IRAM_DRAM_AHB_SEL.Reg, volatile.LoadUint32(&o.IRAM_DRAM_AHB_SEL.Reg)&^(0x2)|value<<1)
}
func (o *DPORT_Type) GetIRAM_DRAM_AHB_SEL_MASK_APP_IRAM() uint32 {
	return (volatile.LoadUint32(&o.IRAM_DRAM_AHB_SEL.Reg) & 0x2) >> 1
}
func (o *DPORT_Type) SetIRAM_DRAM_AHB_SEL_MASK_PRO_DRAM(value uint32) {
	volatile.StoreUint32(&o.IRAM_DRAM_AHB_SEL.Reg, volatile.LoadUint32(&o.IRAM_DRAM_AHB_SEL.Reg)&^(0x4)|value<<2)
}
func (o *DPORT_Type) GetIRAM_DRAM_AHB_SEL_MASK_PRO_DRAM() uint32 {
	return (volatile.LoadUint32(&o.IRAM_DRAM_AHB_SEL.Reg) & 0x4) >> 2
}
func (o *DPORT_Type) SetIRAM_DRAM_AHB_SEL_MASK_APP_DRAM(value uint32) {
	volatile.StoreUint32(&o.IRAM_DRAM_AHB_SEL.Reg, volatile.LoadUint32(&o.IRAM_DRAM_AHB_SEL.Reg)&^(0x8)|value<<3)
}
func (o *DPORT_Type) GetIRAM_DRAM_AHB_SEL_MASK_APP_DRAM() uint32 {
	return (volatile.LoadUint32(&o.IRAM_DRAM_AHB_SEL.Reg) & 0x8) >> 3
}
func (o *DPORT_Type) SetIRAM_DRAM_AHB_SEL_MASK_AHB(value uint32) {
	volatile.StoreUint32(&o.IRAM_DRAM_AHB_SEL.Reg, volatile.LoadUint32(&o.IRAM_DRAM_AHB_SEL.Reg)&^(0x10)|value<<4)
}
func (o *DPORT_Type) GetIRAM_DRAM_AHB_SEL_MASK_AHB() uint32 {
	return (volatile.LoadUint32(&o.IRAM_DRAM_AHB_SEL.Reg) & 0x10) >> 4
}
func (o *DPORT_Type) SetIRAM_DRAM_AHB_SEL_MAC_DUMP_MODE(value uint32) {
	volatile.StoreUint32(&o.IRAM_DRAM_AHB_SEL.Reg, volatile.LoadUint32(&o.IRAM_DRAM_AHB_SEL.Reg)&^(0x60)|value<<5)
}
func (o *DPORT_Type) GetIRAM_DRAM_AHB_SEL_MAC_DUMP_MODE() uint32 {
	return (volatile.LoadUint32(&o.IRAM_DRAM_AHB_SEL.Reg) & 0x60) >> 5
}

// DPORT.TAG_FO_CTRL
func (o *DPORT_Type) SetTAG_FO_CTRL_PRO_CACHE_TAG_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.TAG_FO_CTRL.Reg, volatile.LoadUint32(&o.TAG_FO_CTRL.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetTAG_FO_CTRL_PRO_CACHE_TAG_FORCE_ON() uint32 {
	return volatile.LoadUint32(&o.TAG_FO_CTRL.Reg) & 0x1
}
func (o *DPORT_Type) SetTAG_FO_CTRL_PRO_CACHE_TAG_PD(value uint32) {
	volatile.StoreUint32(&o.TAG_FO_CTRL.Reg, volatile.LoadUint32(&o.TAG_FO_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *DPORT_Type) GetTAG_FO_CTRL_PRO_CACHE_TAG_PD() uint32 {
	return (volatile.LoadUint32(&o.TAG_FO_CTRL.Reg) & 0x2) >> 1
}
func (o *DPORT_Type) SetTAG_FO_CTRL_APP_CACHE_TAG_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.TAG_FO_CTRL.Reg, volatile.LoadUint32(&o.TAG_FO_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *DPORT_Type) GetTAG_FO_CTRL_APP_CACHE_TAG_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.TAG_FO_CTRL.Reg) & 0x100) >> 8
}
func (o *DPORT_Type) SetTAG_FO_CTRL_APP_CACHE_TAG_PD(value uint32) {
	volatile.StoreUint32(&o.TAG_FO_CTRL.Reg, volatile.LoadUint32(&o.TAG_FO_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *DPORT_Type) GetTAG_FO_CTRL_APP_CACHE_TAG_PD() uint32 {
	return (volatile.LoadUint32(&o.TAG_FO_CTRL.Reg) & 0x200) >> 9
}

// DPORT.AHB_LITE_MASK
func (o *DPORT_Type) SetAHB_LITE_MASK_PRO(value uint32) {
	volatile.StoreUint32(&o.AHB_LITE_MASK.Reg, volatile.LoadUint32(&o.AHB_LITE_MASK.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetAHB_LITE_MASK_PRO() uint32 {
	return volatile.LoadUint32(&o.AHB_LITE_MASK.Reg) & 0x1
}
func (o *DPORT_Type) SetAHB_LITE_MASK_APP(value uint32) {
	volatile.StoreUint32(&o.AHB_LITE_MASK.Reg, volatile.LoadUint32(&o.AHB_LITE_MASK.Reg)&^(0x10)|value<<4)
}
func (o *DPORT_Type) GetAHB_LITE_MASK_APP() uint32 {
	return (volatile.LoadUint32(&o.AHB_LITE_MASK.Reg) & 0x10) >> 4
}
func (o *DPORT_Type) SetAHB_LITE_MASK_SDIO(value uint32) {
	volatile.StoreUint32(&o.AHB_LITE_MASK.Reg, volatile.LoadUint32(&o.AHB_LITE_MASK.Reg)&^(0x100)|value<<8)
}
func (o *DPORT_Type) GetAHB_LITE_MASK_SDIO() uint32 {
	return (volatile.LoadUint32(&o.AHB_LITE_MASK.Reg) & 0x100) >> 8
}
func (o *DPORT_Type) SetAHB_LITE_MASK_PRODPORT(value uint32) {
	volatile.StoreUint32(&o.AHB_LITE_MASK.Reg, volatile.LoadUint32(&o.AHB_LITE_MASK.Reg)&^(0x200)|value<<9)
}
func (o *DPORT_Type) GetAHB_LITE_MASK_PRODPORT() uint32 {
	return (volatile.LoadUint32(&o.AHB_LITE_MASK.Reg) & 0x200) >> 9
}
func (o *DPORT_Type) SetAHB_LITE_MASK_APPDPORT(value uint32) {
	volatile.StoreUint32(&o.AHB_LITE_MASK.Reg, volatile.LoadUint32(&o.AHB_LITE_MASK.Reg)&^(0x400)|value<<10)
}
func (o *DPORT_Type) GetAHB_LITE_MASK_APPDPORT() uint32 {
	return (volatile.LoadUint32(&o.AHB_LITE_MASK.Reg) & 0x400) >> 10
}
func (o *DPORT_Type) SetAHB_LITE_MASK_AHB_LITE_SDHOST_PID(value uint32) {
	volatile.StoreUint32(&o.AHB_LITE_MASK.Reg, volatile.LoadUint32(&o.AHB_LITE_MASK.Reg)&^(0x3800)|value<<11)
}
func (o *DPORT_Type) GetAHB_LITE_MASK_AHB_LITE_SDHOST_PID() uint32 {
	return (volatile.LoadUint32(&o.AHB_LITE_MASK.Reg) & 0x3800) >> 11
}

// DPORT.AHB_MPU_TABLE_0
func (o *DPORT_Type) SetAHB_MPU_TABLE_0(value uint32) {
	volatile.StoreUint32(&o.AHB_MPU_TABLE_0.Reg, value)
}
func (o *DPORT_Type) GetAHB_MPU_TABLE_0() uint32 {
	return volatile.LoadUint32(&o.AHB_MPU_TABLE_0.Reg)
}

// DPORT.AHB_MPU_TABLE_1
func (o *DPORT_Type) SetAHB_MPU_TABLE_1_AHB_ACCESS_GRANT_1(value uint32) {
	volatile.StoreUint32(&o.AHB_MPU_TABLE_1.Reg, volatile.LoadUint32(&o.AHB_MPU_TABLE_1.Reg)&^(0x1ff)|value)
}
func (o *DPORT_Type) GetAHB_MPU_TABLE_1_AHB_ACCESS_GRANT_1() uint32 {
	return volatile.LoadUint32(&o.AHB_MPU_TABLE_1.Reg) & 0x1ff
}

// DPORT.HOST_INF_SEL
func (o *DPORT_Type) SetHOST_INF_SEL_PERI_IO_SWAP(value uint32) {
	volatile.StoreUint32(&o.HOST_INF_SEL.Reg, volatile.LoadUint32(&o.HOST_INF_SEL.Reg)&^(0xff)|value)
}
func (o *DPORT_Type) GetHOST_INF_SEL_PERI_IO_SWAP() uint32 {
	return volatile.LoadUint32(&o.HOST_INF_SEL.Reg) & 0xff
}
func (o *DPORT_Type) SetHOST_INF_SEL_LINK_DEVICE_SEL(value uint32) {
	volatile.StoreUint32(&o.HOST_INF_SEL.Reg, volatile.LoadUint32(&o.HOST_INF_SEL.Reg)&^(0xff00)|value<<8)
}
func (o *DPORT_Type) GetHOST_INF_SEL_LINK_DEVICE_SEL() uint32 {
	return (volatile.LoadUint32(&o.HOST_INF_SEL.Reg) & 0xff00) >> 8
}

// DPORT.PERIP_CLK_EN
func (o *DPORT_Type) SetPERIP_CLK_EN_TIMERS_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_TIMERS_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x1
}
func (o *DPORT_Type) SetPERIP_CLK_EN_SPI01_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x2)|value<<1)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_SPI01_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x2) >> 1
}
func (o *DPORT_Type) SetPERIP_CLK_EN_UART_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x4)|value<<2)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_UART_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x4) >> 2
}
func (o *DPORT_Type) SetPERIP_CLK_EN_WDG_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x8)|value<<3)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_WDG_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x8) >> 3
}
func (o *DPORT_Type) SetPERIP_CLK_EN_I2S0_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x10)|value<<4)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_I2S0_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x10) >> 4
}
func (o *DPORT_Type) SetPERIP_CLK_EN_UART1_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x20)|value<<5)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_UART1_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x20) >> 5
}
func (o *DPORT_Type) SetPERIP_CLK_EN_SPI2_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x40)|value<<6)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_SPI2_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x40) >> 6
}
func (o *DPORT_Type) SetPERIP_CLK_EN_I2C0_EXT0_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x80)|value<<7)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_I2C0_EXT0_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x80) >> 7
}
func (o *DPORT_Type) SetPERIP_CLK_EN_UHCI0_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x100)|value<<8)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_UHCI0_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x100) >> 8
}
func (o *DPORT_Type) SetPERIP_CLK_EN_RMT_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x200)|value<<9)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_RMT_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x200) >> 9
}
func (o *DPORT_Type) SetPERIP_CLK_EN_PCNT_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x400)|value<<10)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_PCNT_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x400) >> 10
}
func (o *DPORT_Type) SetPERIP_CLK_EN_LEDC_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x800)|value<<11)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_LEDC_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x800) >> 11
}
func (o *DPORT_Type) SetPERIP_CLK_EN_UHCI1_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x1000)|value<<12)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_UHCI1_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x1000) >> 12
}
func (o *DPORT_Type) SetPERIP_CLK_EN_TIMERGROUP_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x2000)|value<<13)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_TIMERGROUP_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x2000) >> 13
}
func (o *DPORT_Type) SetPERIP_CLK_EN_EFUSE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x4000)|value<<14)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_EFUSE_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x4000) >> 14
}
func (o *DPORT_Type) SetPERIP_CLK_EN_TIMERGROUP1_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x8000)|value<<15)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_TIMERGROUP1_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x8000) >> 15
}
func (o *DPORT_Type) SetPERIP_CLK_EN_SPI3_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x10000)|value<<16)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_SPI3_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x10000) >> 16
}
func (o *DPORT_Type) SetPERIP_CLK_EN_PWM0_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x20000)|value<<17)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_PWM0_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x20000) >> 17
}
func (o *DPORT_Type) SetPERIP_CLK_EN_I2C_EXT1_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x40000)|value<<18)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_I2C_EXT1_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x40000) >> 18
}
func (o *DPORT_Type) SetPERIP_CLK_EN_TWAI_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x80000)|value<<19)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_TWAI_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x80000) >> 19
}
func (o *DPORT_Type) SetPERIP_CLK_EN_PWM1_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x100000)|value<<20)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_PWM1_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x100000) >> 20
}
func (o *DPORT_Type) SetPERIP_CLK_EN_I2S1_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x200000)|value<<21)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_I2S1_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x200000) >> 21
}
func (o *DPORT_Type) SetPERIP_CLK_EN_SPI_DMA_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x400000)|value<<22)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_SPI_DMA_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x400000) >> 22
}
func (o *DPORT_Type) SetPERIP_CLK_EN_UART2_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x800000)|value<<23)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_UART2_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x800000) >> 23
}
func (o *DPORT_Type) SetPERIP_CLK_EN_UART_MEM_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x1000000)|value<<24)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_UART_MEM_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x1000000) >> 24
}
func (o *DPORT_Type) SetPERIP_CLK_EN_PWM2_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x2000000)|value<<25)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_PWM2_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x2000000) >> 25
}
func (o *DPORT_Type) SetPERIP_CLK_EN_PWM3_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN.Reg)&^(0x4000000)|value<<26)
}
func (o *DPORT_Type) GetPERIP_CLK_EN_PWM3_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN.Reg) & 0x4000000) >> 26
}

// DPORT.PERIP_RST_EN
func (o *DPORT_Type) SetPERIP_RST_EN_TIMERS_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetPERIP_RST_EN_TIMERS_RST() uint32 {
	return volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x1
}
func (o *DPORT_Type) SetPERIP_RST_EN_SPI01_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x2)|value<<1)
}
func (o *DPORT_Type) GetPERIP_RST_EN_SPI01_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x2) >> 1
}
func (o *DPORT_Type) SetPERIP_RST_EN_UART_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x4)|value<<2)
}
func (o *DPORT_Type) GetPERIP_RST_EN_UART_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x4) >> 2
}
func (o *DPORT_Type) SetPERIP_RST_EN_WDG_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x8)|value<<3)
}
func (o *DPORT_Type) GetPERIP_RST_EN_WDG_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x8) >> 3
}
func (o *DPORT_Type) SetPERIP_RST_EN_I2S0_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x10)|value<<4)
}
func (o *DPORT_Type) GetPERIP_RST_EN_I2S0_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x10) >> 4
}
func (o *DPORT_Type) SetPERIP_RST_EN_UART1_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x20)|value<<5)
}
func (o *DPORT_Type) GetPERIP_RST_EN_UART1_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x20) >> 5
}
func (o *DPORT_Type) SetPERIP_RST_EN_SPI2_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x40)|value<<6)
}
func (o *DPORT_Type) GetPERIP_RST_EN_SPI2_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x40) >> 6
}
func (o *DPORT_Type) SetPERIP_RST_EN_I2C0_EXT0_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x80)|value<<7)
}
func (o *DPORT_Type) GetPERIP_RST_EN_I2C0_EXT0_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x80) >> 7
}
func (o *DPORT_Type) SetPERIP_RST_EN_UHCI0_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x100)|value<<8)
}
func (o *DPORT_Type) GetPERIP_RST_EN_UHCI0_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x100) >> 8
}
func (o *DPORT_Type) SetPERIP_RST_EN_RMT_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x200)|value<<9)
}
func (o *DPORT_Type) GetPERIP_RST_EN_RMT_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x200) >> 9
}
func (o *DPORT_Type) SetPERIP_RST_EN_PCNT_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x400)|value<<10)
}
func (o *DPORT_Type) GetPERIP_RST_EN_PCNT_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x400) >> 10
}
func (o *DPORT_Type) SetPERIP_RST_EN_LEDC_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x800)|value<<11)
}
func (o *DPORT_Type) GetPERIP_RST_EN_LEDC_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x800) >> 11
}
func (o *DPORT_Type) SetPERIP_RST_EN_UHCI1_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x1000)|value<<12)
}
func (o *DPORT_Type) GetPERIP_RST_EN_UHCI1_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x1000) >> 12
}
func (o *DPORT_Type) SetPERIP_RST_EN_TIMERGROUP_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x2000)|value<<13)
}
func (o *DPORT_Type) GetPERIP_RST_EN_TIMERGROUP_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x2000) >> 13
}
func (o *DPORT_Type) SetPERIP_RST_EN_EFUSE_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x4000)|value<<14)
}
func (o *DPORT_Type) GetPERIP_RST_EN_EFUSE_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x4000) >> 14
}
func (o *DPORT_Type) SetPERIP_RST_EN_TIMERGROUP1_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x8000)|value<<15)
}
func (o *DPORT_Type) GetPERIP_RST_EN_TIMERGROUP1_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x8000) >> 15
}
func (o *DPORT_Type) SetPERIP_RST_EN_SPI3_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x10000)|value<<16)
}
func (o *DPORT_Type) GetPERIP_RST_EN_SPI3_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x10000) >> 16
}
func (o *DPORT_Type) SetPERIP_RST_EN_PWM0_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x20000)|value<<17)
}
func (o *DPORT_Type) GetPERIP_RST_EN_PWM0_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x20000) >> 17
}
func (o *DPORT_Type) SetPERIP_RST_EN_I2C_EXT1_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x40000)|value<<18)
}
func (o *DPORT_Type) GetPERIP_RST_EN_I2C_EXT1_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x40000) >> 18
}
func (o *DPORT_Type) SetPERIP_RST_EN_TWAI_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x80000)|value<<19)
}
func (o *DPORT_Type) GetPERIP_RST_EN_TWAI_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x80000) >> 19
}
func (o *DPORT_Type) SetPERIP_RST_EN_PWM1_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x100000)|value<<20)
}
func (o *DPORT_Type) GetPERIP_RST_EN_PWM1_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x100000) >> 20
}
func (o *DPORT_Type) SetPERIP_RST_EN_I2S1_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x200000)|value<<21)
}
func (o *DPORT_Type) GetPERIP_RST_EN_I2S1_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x200000) >> 21
}
func (o *DPORT_Type) SetPERIP_RST_EN_SPI_DMA_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x400000)|value<<22)
}
func (o *DPORT_Type) GetPERIP_RST_EN_SPI_DMA_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x400000) >> 22
}
func (o *DPORT_Type) SetPERIP_RST_EN_UART2_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x800000)|value<<23)
}
func (o *DPORT_Type) GetPERIP_RST_EN_UART2_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x800000) >> 23
}
func (o *DPORT_Type) SetPERIP_RST_EN_UART_MEM_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x1000000)|value<<24)
}
func (o *DPORT_Type) GetPERIP_RST_EN_UART_MEM_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x1000000) >> 24
}
func (o *DPORT_Type) SetPERIP_RST_EN_PWM2_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x2000000)|value<<25)
}
func (o *DPORT_Type) GetPERIP_RST_EN_PWM2_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x2000000) >> 25
}
func (o *DPORT_Type) SetPERIP_RST_EN_PWM3_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN.Reg, volatile.LoadUint32(&o.PERIP_RST_EN.Reg)&^(0x4000000)|value<<26)
}
func (o *DPORT_Type) GetPERIP_RST_EN_PWM3_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN.Reg) & 0x4000000) >> 26
}

// DPORT.SLAVE_SPI_CONFIG
func (o *DPORT_Type) SetSLAVE_SPI_CONFIG_SLAVE_SPI_MASK_PRO(value uint32) {
	volatile.StoreUint32(&o.SLAVE_SPI_CONFIG.Reg, volatile.LoadUint32(&o.SLAVE_SPI_CONFIG.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetSLAVE_SPI_CONFIG_SLAVE_SPI_MASK_PRO() uint32 {
	return volatile.LoadUint32(&o.SLAVE_SPI_CONFIG.Reg) & 0x1
}
func (o *DPORT_Type) SetSLAVE_SPI_CONFIG_SLAVE_SPI_MASK_APP(value uint32) {
	volatile.StoreUint32(&o.SLAVE_SPI_CONFIG.Reg, volatile.LoadUint32(&o.SLAVE_SPI_CONFIG.Reg)&^(0x10)|value<<4)
}
func (o *DPORT_Type) GetSLAVE_SPI_CONFIG_SLAVE_SPI_MASK_APP() uint32 {
	return (volatile.LoadUint32(&o.SLAVE_SPI_CONFIG.Reg) & 0x10) >> 4
}
func (o *DPORT_Type) SetSLAVE_SPI_CONFIG_SPI_ENCRYPT_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SLAVE_SPI_CONFIG.Reg, volatile.LoadUint32(&o.SLAVE_SPI_CONFIG.Reg)&^(0x100)|value<<8)
}
func (o *DPORT_Type) GetSLAVE_SPI_CONFIG_SPI_ENCRYPT_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SLAVE_SPI_CONFIG.Reg) & 0x100) >> 8
}
func (o *DPORT_Type) SetSLAVE_SPI_CONFIG_SPI_DECRYPT_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SLAVE_SPI_CONFIG.Reg, volatile.LoadUint32(&o.SLAVE_SPI_CONFIG.Reg)&^(0x1000)|value<<12)
}
func (o *DPORT_Type) GetSLAVE_SPI_CONFIG_SPI_DECRYPT_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SLAVE_SPI_CONFIG.Reg) & 0x1000) >> 12
}

// DPORT.WIFI_CLK_EN
func (o *DPORT_Type) SetWIFI_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.WIFI_CLK_EN.Reg, value)
}
func (o *DPORT_Type) GetWIFI_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.WIFI_CLK_EN.Reg)
}
func (o *DPORT_Type) SetWIFI_CLK_EN_WIFI_CLK_WIFI_EN(value uint32) {
	volatile.StoreUint32(&o.WIFI_CLK_EN.Reg, volatile.LoadUint32(&o.WIFI_CLK_EN.Reg)&^(0x7)|value)
}
func (o *DPORT_Type) GetWIFI_CLK_EN_WIFI_CLK_WIFI_EN() uint32 {
	return volatile.LoadUint32(&o.WIFI_CLK_EN.Reg) & 0x7
}
func (o *DPORT_Type) SetWIFI_CLK_EN_WIFI_CLK_WIFI_BT_COMMON(value uint32) {
	volatile.StoreUint32(&o.WIFI_CLK_EN.Reg, volatile.LoadUint32(&o.WIFI_CLK_EN.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetWIFI_CLK_EN_WIFI_CLK_WIFI_BT_COMMON() uint32 {
	return volatile.LoadUint32(&o.WIFI_CLK_EN.Reg) & 0x3f
}
func (o *DPORT_Type) SetWIFI_CLK_EN_WIFI_CLK_BT_EN(value uint32) {
	volatile.StoreUint32(&o.WIFI_CLK_EN.Reg, volatile.LoadUint32(&o.WIFI_CLK_EN.Reg)&^(0x3800)|value<<11)
}
func (o *DPORT_Type) GetWIFI_CLK_EN_WIFI_CLK_BT_EN() uint32 {
	return (volatile.LoadUint32(&o.WIFI_CLK_EN.Reg) & 0x3800) >> 11
}

// DPORT.CORE_RST_EN
func (o *DPORT_Type) SetCORE_RST_EN_CORE_RST(value uint32) {
	volatile.StoreUint32(&o.CORE_RST_EN.Reg, volatile.LoadUint32(&o.CORE_RST_EN.Reg)&^(0xff)|value)
}
func (o *DPORT_Type) GetCORE_RST_EN_CORE_RST() uint32 {
	return volatile.LoadUint32(&o.CORE_RST_EN.Reg) & 0xff
}

// DPORT.BT_LPCK_DIV_INT
func (o *DPORT_Type) SetBT_LPCK_DIV_INT_BT_LPCK_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.BT_LPCK_DIV_INT.Reg, volatile.LoadUint32(&o.BT_LPCK_DIV_INT.Reg)&^(0xfff)|value)
}
func (o *DPORT_Type) GetBT_LPCK_DIV_INT_BT_LPCK_DIV_NUM() uint32 {
	return volatile.LoadUint32(&o.BT_LPCK_DIV_INT.Reg) & 0xfff
}
func (o *DPORT_Type) SetBT_LPCK_DIV_INT_BTEXTWAKEUP_REQ(value uint32) {
	volatile.StoreUint32(&o.BT_LPCK_DIV_INT.Reg, volatile.LoadUint32(&o.BT_LPCK_DIV_INT.Reg)&^(0x1000)|value<<12)
}
func (o *DPORT_Type) GetBT_LPCK_DIV_INT_BTEXTWAKEUP_REQ() uint32 {
	return (volatile.LoadUint32(&o.BT_LPCK_DIV_INT.Reg) & 0x1000) >> 12
}

// DPORT.BT_LPCK_DIV_FRAC
func (o *DPORT_Type) SetBT_LPCK_DIV_FRAC_BT_LPCK_DIV_B(value uint32) {
	volatile.StoreUint32(&o.BT_LPCK_DIV_FRAC.Reg, volatile.LoadUint32(&o.BT_LPCK_DIV_FRAC.Reg)&^(0xfff)|value)
}
func (o *DPORT_Type) GetBT_LPCK_DIV_FRAC_BT_LPCK_DIV_B() uint32 {
	return volatile.LoadUint32(&o.BT_LPCK_DIV_FRAC.Reg) & 0xfff
}
func (o *DPORT_Type) SetBT_LPCK_DIV_FRAC_BT_LPCK_DIV_A(value uint32) {
	volatile.StoreUint32(&o.BT_LPCK_DIV_FRAC.Reg, volatile.LoadUint32(&o.BT_LPCK_DIV_FRAC.Reg)&^(0xfff000)|value<<12)
}
func (o *DPORT_Type) GetBT_LPCK_DIV_FRAC_BT_LPCK_DIV_A() uint32 {
	return (volatile.LoadUint32(&o.BT_LPCK_DIV_FRAC.Reg) & 0xfff000) >> 12
}
func (o *DPORT_Type) SetBT_LPCK_DIV_FRAC_LPCLK_SEL_RTC_SLOW(value uint32) {
	volatile.StoreUint32(&o.BT_LPCK_DIV_FRAC.Reg, volatile.LoadUint32(&o.BT_LPCK_DIV_FRAC.Reg)&^(0x1000000)|value<<24)
}
func (o *DPORT_Type) GetBT_LPCK_DIV_FRAC_LPCLK_SEL_RTC_SLOW() uint32 {
	return (volatile.LoadUint32(&o.BT_LPCK_DIV_FRAC.Reg) & 0x1000000) >> 24
}
func (o *DPORT_Type) SetBT_LPCK_DIV_FRAC_LPCLK_SEL_8M(value uint32) {
	volatile.StoreUint32(&o.BT_LPCK_DIV_FRAC.Reg, volatile.LoadUint32(&o.BT_LPCK_DIV_FRAC.Reg)&^(0x2000000)|value<<25)
}
func (o *DPORT_Type) GetBT_LPCK_DIV_FRAC_LPCLK_SEL_8M() uint32 {
	return (volatile.LoadUint32(&o.BT_LPCK_DIV_FRAC.Reg) & 0x2000000) >> 25
}
func (o *DPORT_Type) SetBT_LPCK_DIV_FRAC_LPCLK_SEL_XTAL(value uint32) {
	volatile.StoreUint32(&o.BT_LPCK_DIV_FRAC.Reg, volatile.LoadUint32(&o.BT_LPCK_DIV_FRAC.Reg)&^(0x4000000)|value<<26)
}
func (o *DPORT_Type) GetBT_LPCK_DIV_FRAC_LPCLK_SEL_XTAL() uint32 {
	return (volatile.LoadUint32(&o.BT_LPCK_DIV_FRAC.Reg) & 0x4000000) >> 26
}
func (o *DPORT_Type) SetBT_LPCK_DIV_FRAC_LPCLK_SEL_XTAL32K(value uint32) {
	volatile.StoreUint32(&o.BT_LPCK_DIV_FRAC.Reg, volatile.LoadUint32(&o.BT_LPCK_DIV_FRAC.Reg)&^(0x8000000)|value<<27)
}
func (o *DPORT_Type) GetBT_LPCK_DIV_FRAC_LPCLK_SEL_XTAL32K() uint32 {
	return (volatile.LoadUint32(&o.BT_LPCK_DIV_FRAC.Reg) & 0x8000000) >> 27
}

// DPORT.CPU_INTR_FROM_CPU_0
func (o *DPORT_Type) SetCPU_INTR_FROM_CPU_0(value uint32) {
	volatile.StoreUint32(&o.CPU_INTR_FROM_CPU_0.Reg, volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_0.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetCPU_INTR_FROM_CPU_0() uint32 {
	return volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_0.Reg) & 0x1
}

// DPORT.CPU_INTR_FROM_CPU_1
func (o *DPORT_Type) SetCPU_INTR_FROM_CPU_1(value uint32) {
	volatile.StoreUint32(&o.CPU_INTR_FROM_CPU_1.Reg, volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_1.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetCPU_INTR_FROM_CPU_1() uint32 {
	return volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_1.Reg) & 0x1
}

// DPORT.CPU_INTR_FROM_CPU_2
func (o *DPORT_Type) SetCPU_INTR_FROM_CPU_2(value uint32) {
	volatile.StoreUint32(&o.CPU_INTR_FROM_CPU_2.Reg, volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_2.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetCPU_INTR_FROM_CPU_2() uint32 {
	return volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_2.Reg) & 0x1
}

// DPORT.CPU_INTR_FROM_CPU_3
func (o *DPORT_Type) SetCPU_INTR_FROM_CPU_3(value uint32) {
	volatile.StoreUint32(&o.CPU_INTR_FROM_CPU_3.Reg, volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_3.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetCPU_INTR_FROM_CPU_3() uint32 {
	return volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_3.Reg) & 0x1
}

// DPORT.PRO_INTR_STATUS_0
func (o *DPORT_Type) SetPRO_INTR_STATUS_0(value uint32) {
	volatile.StoreUint32(&o.PRO_INTR_STATUS_0.Reg, value)
}
func (o *DPORT_Type) GetPRO_INTR_STATUS_0() uint32 {
	return volatile.LoadUint32(&o.PRO_INTR_STATUS_0.Reg)
}

// DPORT.PRO_INTR_STATUS_1
func (o *DPORT_Type) SetPRO_INTR_STATUS_1(value uint32) {
	volatile.StoreUint32(&o.PRO_INTR_STATUS_1.Reg, value)
}
func (o *DPORT_Type) GetPRO_INTR_STATUS_1() uint32 {
	return volatile.LoadUint32(&o.PRO_INTR_STATUS_1.Reg)
}

// DPORT.PRO_INTR_STATUS_2
func (o *DPORT_Type) SetPRO_INTR_STATUS_2(value uint32) {
	volatile.StoreUint32(&o.PRO_INTR_STATUS_2.Reg, value)
}
func (o *DPORT_Type) GetPRO_INTR_STATUS_2() uint32 {
	return volatile.LoadUint32(&o.PRO_INTR_STATUS_2.Reg)
}

// DPORT.APP_INTR_STATUS_0
func (o *DPORT_Type) SetAPP_INTR_STATUS_0(value uint32) {
	volatile.StoreUint32(&o.APP_INTR_STATUS_0.Reg, value)
}
func (o *DPORT_Type) GetAPP_INTR_STATUS_0() uint32 {
	return volatile.LoadUint32(&o.APP_INTR_STATUS_0.Reg)
}

// DPORT.APP_INTR_STATUS_1
func (o *DPORT_Type) SetAPP_INTR_STATUS_1(value uint32) {
	volatile.StoreUint32(&o.APP_INTR_STATUS_1.Reg, value)
}
func (o *DPORT_Type) GetAPP_INTR_STATUS_1() uint32 {
	return volatile.LoadUint32(&o.APP_INTR_STATUS_1.Reg)
}

// DPORT.APP_INTR_STATUS_2
func (o *DPORT_Type) SetAPP_INTR_STATUS_2(value uint32) {
	volatile.StoreUint32(&o.APP_INTR_STATUS_2.Reg, value)
}
func (o *DPORT_Type) GetAPP_INTR_STATUS_2() uint32 {
	return volatile.LoadUint32(&o.APP_INTR_STATUS_2.Reg)
}

// DPORT.PRO_MAC_INTR_MAP
func (o *DPORT_Type) SetPRO_MAC_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_MAC_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_MAC_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_MAC_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_MAC_INTR_MAP.Reg) & 0x1f
}

// DPORT.PRO_MAC_NMI_MAP
func (o *DPORT_Type) SetPRO_MAC_NMI_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_MAC_NMI_MAP.Reg, volatile.LoadUint32(&o.PRO_MAC_NMI_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_MAC_NMI_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_MAC_NMI_MAP.Reg) & 0x1f
}

// DPORT.PRO_BB_INT_MAP
func (o *DPORT_Type) SetPRO_BB_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_BB_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_BB_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_BB_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_BB_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_BT_MAC_INT_MAP
func (o *DPORT_Type) SetPRO_BT_MAC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_BT_MAC_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_BT_MAC_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_BT_MAC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_BT_MAC_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_BT_BB_INT_MAP
func (o *DPORT_Type) SetPRO_BT_BB_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_BT_BB_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_BT_BB_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_BT_BB_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_BT_BB_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_BT_BB_NMI_MAP
func (o *DPORT_Type) SetPRO_BT_BB_NMI_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_BT_BB_NMI_MAP.Reg, volatile.LoadUint32(&o.PRO_BT_BB_NMI_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_BT_BB_NMI_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_BT_BB_NMI_MAP.Reg) & 0x1f
}

// DPORT.PRO_RWBT_IRQ_MAP
func (o *DPORT_Type) SetPRO_RWBT_IRQ_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_RWBT_IRQ_MAP.Reg, volatile.LoadUint32(&o.PRO_RWBT_IRQ_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_RWBT_IRQ_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_RWBT_IRQ_MAP.Reg) & 0x1f
}

// DPORT.PRO_RWBLE_IRQ_MAP
func (o *DPORT_Type) SetPRO_RWBLE_IRQ_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_RWBLE_IRQ_MAP.Reg, volatile.LoadUint32(&o.PRO_RWBLE_IRQ_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_RWBLE_IRQ_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_RWBLE_IRQ_MAP.Reg) & 0x1f
}

// DPORT.PRO_RWBT_NMI_MAP
func (o *DPORT_Type) SetPRO_RWBT_NMI_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_RWBT_NMI_MAP.Reg, volatile.LoadUint32(&o.PRO_RWBT_NMI_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_RWBT_NMI_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_RWBT_NMI_MAP.Reg) & 0x1f
}

// DPORT.PRO_RWBLE_NMI_MAP
func (o *DPORT_Type) SetPRO_RWBLE_NMI_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_RWBLE_NMI_MAP.Reg, volatile.LoadUint32(&o.PRO_RWBLE_NMI_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_RWBLE_NMI_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_RWBLE_NMI_MAP.Reg) & 0x1f
}

// DPORT.PRO_SLC0_INTR_MAP
func (o *DPORT_Type) SetPRO_SLC0_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_SLC0_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_SLC0_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_SLC0_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_SLC0_INTR_MAP.Reg) & 0x1f
}

// DPORT.PRO_SLC1_INTR_MAP
func (o *DPORT_Type) SetPRO_SLC1_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_SLC1_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_SLC1_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_SLC1_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_SLC1_INTR_MAP.Reg) & 0x1f
}

// DPORT.PRO_UHCI0_INTR_MAP
func (o *DPORT_Type) SetPRO_UHCI0_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_UHCI0_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_UHCI0_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_UHCI0_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_UHCI0_INTR_MAP.Reg) & 0x1f
}

// DPORT.PRO_UHCI1_INTR_MAP
func (o *DPORT_Type) SetPRO_UHCI1_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_UHCI1_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_UHCI1_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_UHCI1_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_UHCI1_INTR_MAP.Reg) & 0x1f
}

// DPORT.PRO_TG_T0_LEVEL_INT_MAP
func (o *DPORT_Type) SetPRO_TG_T0_LEVEL_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG_T0_LEVEL_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG_T0_LEVEL_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_TG_T0_LEVEL_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG_T0_LEVEL_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_TG_T1_LEVEL_INT_MAP
func (o *DPORT_Type) SetPRO_TG_T1_LEVEL_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG_T1_LEVEL_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG_T1_LEVEL_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_TG_T1_LEVEL_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG_T1_LEVEL_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_TG_WDT_LEVEL_INT_MAP
func (o *DPORT_Type) SetPRO_TG_WDT_LEVEL_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG_WDT_LEVEL_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG_WDT_LEVEL_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_TG_WDT_LEVEL_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG_WDT_LEVEL_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_TG_LACT_LEVEL_INT_MAP
func (o *DPORT_Type) SetPRO_TG_LACT_LEVEL_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG_LACT_LEVEL_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG_LACT_LEVEL_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_TG_LACT_LEVEL_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG_LACT_LEVEL_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_TG1_T0_LEVEL_INT_MAP
func (o *DPORT_Type) SetPRO_TG1_T0_LEVEL_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG1_T0_LEVEL_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG1_T0_LEVEL_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_TG1_T0_LEVEL_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG1_T0_LEVEL_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_TG1_T1_LEVEL_INT_MAP
func (o *DPORT_Type) SetPRO_TG1_T1_LEVEL_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG1_T1_LEVEL_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG1_T1_LEVEL_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_TG1_T1_LEVEL_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG1_T1_LEVEL_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_TG1_WDT_LEVEL_INT_MAP
func (o *DPORT_Type) SetPRO_TG1_WDT_LEVEL_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG1_WDT_LEVEL_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG1_WDT_LEVEL_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_TG1_WDT_LEVEL_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG1_WDT_LEVEL_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_TG1_LACT_LEVEL_INT_MAP
func (o *DPORT_Type) SetPRO_TG1_LACT_LEVEL_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG1_LACT_LEVEL_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG1_LACT_LEVEL_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_TG1_LACT_LEVEL_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG1_LACT_LEVEL_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_GPIO_INTERRUPT_MAP
func (o *DPORT_Type) SetPRO_GPIO_INTERRUPT_MAP_PRO_GPIO_INTERRUPT_PRO_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_GPIO_INTERRUPT_MAP.Reg, volatile.LoadUint32(&o.PRO_GPIO_INTERRUPT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_GPIO_INTERRUPT_MAP_PRO_GPIO_INTERRUPT_PRO_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_GPIO_INTERRUPT_MAP.Reg) & 0x1f
}

// DPORT.PRO_GPIO_INTERRUPT_NMI_MAP
func (o *DPORT_Type) SetPRO_GPIO_INTERRUPT_NMI_MAP_PRO_GPIO_INTERRUPT_PRO_NMI_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_GPIO_INTERRUPT_NMI_MAP.Reg, volatile.LoadUint32(&o.PRO_GPIO_INTERRUPT_NMI_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_GPIO_INTERRUPT_NMI_MAP_PRO_GPIO_INTERRUPT_PRO_NMI_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_GPIO_INTERRUPT_NMI_MAP.Reg) & 0x1f
}

// DPORT.PRO_CPU_INTR_FROM_CPU_0_MAP
func (o *DPORT_Type) SetPRO_CPU_INTR_FROM_CPU_0_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_INTR_FROM_CPU_0_MAP.Reg, volatile.LoadUint32(&o.PRO_CPU_INTR_FROM_CPU_0_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_CPU_INTR_FROM_CPU_0_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_INTR_FROM_CPU_0_MAP.Reg) & 0x1f
}

// DPORT.PRO_CPU_INTR_FROM_CPU_1_MAP
func (o *DPORT_Type) SetPRO_CPU_INTR_FROM_CPU_1_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_INTR_FROM_CPU_1_MAP.Reg, volatile.LoadUint32(&o.PRO_CPU_INTR_FROM_CPU_1_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_CPU_INTR_FROM_CPU_1_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_INTR_FROM_CPU_1_MAP.Reg) & 0x1f
}

// DPORT.PRO_CPU_INTR_FROM_CPU_2_MAP
func (o *DPORT_Type) SetPRO_CPU_INTR_FROM_CPU_2_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_INTR_FROM_CPU_2_MAP.Reg, volatile.LoadUint32(&o.PRO_CPU_INTR_FROM_CPU_2_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_CPU_INTR_FROM_CPU_2_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_INTR_FROM_CPU_2_MAP.Reg) & 0x1f
}

// DPORT.PRO_CPU_INTR_FROM_CPU_3_MAP
func (o *DPORT_Type) SetPRO_CPU_INTR_FROM_CPU_3_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_INTR_FROM_CPU_3_MAP.Reg, volatile.LoadUint32(&o.PRO_CPU_INTR_FROM_CPU_3_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_CPU_INTR_FROM_CPU_3_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_INTR_FROM_CPU_3_MAP.Reg) & 0x1f
}

// DPORT.PRO_SPI_INTR_0_MAP
func (o *DPORT_Type) SetPRO_SPI_INTR_0_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_SPI_INTR_0_MAP.Reg, volatile.LoadUint32(&o.PRO_SPI_INTR_0_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_SPI_INTR_0_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_SPI_INTR_0_MAP.Reg) & 0x1f
}

// DPORT.PRO_SPI_INTR_1_MAP
func (o *DPORT_Type) SetPRO_SPI_INTR_1_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_SPI_INTR_1_MAP.Reg, volatile.LoadUint32(&o.PRO_SPI_INTR_1_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_SPI_INTR_1_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_SPI_INTR_1_MAP.Reg) & 0x1f
}

// DPORT.PRO_SPI_INTR_2_MAP
func (o *DPORT_Type) SetPRO_SPI_INTR_2_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_SPI_INTR_2_MAP.Reg, volatile.LoadUint32(&o.PRO_SPI_INTR_2_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_SPI_INTR_2_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_SPI_INTR_2_MAP.Reg) & 0x1f
}

// DPORT.PRO_SPI_INTR_3_MAP
func (o *DPORT_Type) SetPRO_SPI_INTR_3_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_SPI_INTR_3_MAP.Reg, volatile.LoadUint32(&o.PRO_SPI_INTR_3_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_SPI_INTR_3_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_SPI_INTR_3_MAP.Reg) & 0x1f
}

// DPORT.PRO_I2S0_INT_MAP
func (o *DPORT_Type) SetPRO_I2S0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_I2S0_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_I2S0_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_I2S0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_I2S0_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_I2S1_INT_MAP
func (o *DPORT_Type) SetPRO_I2S1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_I2S1_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_I2S1_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_I2S1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_I2S1_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_UART_INTR_MAP
func (o *DPORT_Type) SetPRO_UART_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_UART_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_UART_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_UART_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_UART_INTR_MAP.Reg) & 0x1f
}

// DPORT.PRO_UART1_INTR_MAP
func (o *DPORT_Type) SetPRO_UART1_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_UART1_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_UART1_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_UART1_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_UART1_INTR_MAP.Reg) & 0x1f
}

// DPORT.PRO_UART2_INTR_MAP
func (o *DPORT_Type) SetPRO_UART2_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_UART2_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_UART2_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_UART2_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_UART2_INTR_MAP.Reg) & 0x1f
}

// DPORT.PRO_SDIO_HOST_INTERRUPT_MAP
func (o *DPORT_Type) SetPRO_SDIO_HOST_INTERRUPT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_SDIO_HOST_INTERRUPT_MAP.Reg, volatile.LoadUint32(&o.PRO_SDIO_HOST_INTERRUPT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_SDIO_HOST_INTERRUPT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_SDIO_HOST_INTERRUPT_MAP.Reg) & 0x1f
}

// DPORT.PRO_EMAC_INT_MAP
func (o *DPORT_Type) SetPRO_EMAC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_EMAC_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_EMAC_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_EMAC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_EMAC_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_PWM0_INTR_MAP
func (o *DPORT_Type) SetPRO_PWM0_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_PWM0_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_PWM0_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_PWM0_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_PWM0_INTR_MAP.Reg) & 0x1f
}

// DPORT.PRO_PWM1_INTR_MAP
func (o *DPORT_Type) SetPRO_PWM1_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_PWM1_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_PWM1_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_PWM1_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_PWM1_INTR_MAP.Reg) & 0x1f
}

// DPORT.PRO_PWM2_INTR_MAP
func (o *DPORT_Type) SetPRO_PWM2_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_PWM2_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_PWM2_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_PWM2_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_PWM2_INTR_MAP.Reg) & 0x1f
}

// DPORT.PRO_PWM3_INTR_MAP
func (o *DPORT_Type) SetPRO_PWM3_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_PWM3_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_PWM3_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_PWM3_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_PWM3_INTR_MAP.Reg) & 0x1f
}

// DPORT.PRO_LEDC_INT_MAP
func (o *DPORT_Type) SetPRO_LEDC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_LEDC_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_LEDC_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_LEDC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_LEDC_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_EFUSE_INT_MAP
func (o *DPORT_Type) SetPRO_EFUSE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_EFUSE_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_EFUSE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_EFUSE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_EFUSE_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_CAN_INT_MAP
func (o *DPORT_Type) SetPRO_CAN_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_CAN_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_CAN_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_CAN_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_CAN_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_RTC_CORE_INTR_MAP
func (o *DPORT_Type) SetPRO_RTC_CORE_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_RTC_CORE_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_RTC_CORE_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_RTC_CORE_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_RTC_CORE_INTR_MAP.Reg) & 0x1f
}

// DPORT.PRO_RMT_INTR_MAP
func (o *DPORT_Type) SetPRO_RMT_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_RMT_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_RMT_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_RMT_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_RMT_INTR_MAP.Reg) & 0x1f
}

// DPORT.PRO_PCNT_INTR_MAP
func (o *DPORT_Type) SetPRO_PCNT_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_PCNT_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_PCNT_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_PCNT_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_PCNT_INTR_MAP.Reg) & 0x1f
}

// DPORT.PRO_I2C_EXT0_INTR_MAP
func (o *DPORT_Type) SetPRO_I2C_EXT0_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_I2C_EXT0_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_I2C_EXT0_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_I2C_EXT0_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_I2C_EXT0_INTR_MAP.Reg) & 0x1f
}

// DPORT.PRO_I2C_EXT1_INTR_MAP
func (o *DPORT_Type) SetPRO_I2C_EXT1_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_I2C_EXT1_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_I2C_EXT1_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_I2C_EXT1_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_I2C_EXT1_INTR_MAP.Reg) & 0x1f
}

// DPORT.PRO_RSA_INTR_MAP
func (o *DPORT_Type) SetPRO_RSA_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_RSA_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_RSA_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_RSA_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_RSA_INTR_MAP.Reg) & 0x1f
}

// DPORT.PRO_SPI1_DMA_INT_MAP
func (o *DPORT_Type) SetPRO_SPI1_DMA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_SPI1_DMA_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_SPI1_DMA_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_SPI1_DMA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_SPI1_DMA_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_SPI2_DMA_INT_MAP
func (o *DPORT_Type) SetPRO_SPI2_DMA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_SPI2_DMA_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_SPI2_DMA_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_SPI2_DMA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_SPI2_DMA_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_SPI3_DMA_INT_MAP
func (o *DPORT_Type) SetPRO_SPI3_DMA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_SPI3_DMA_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_SPI3_DMA_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_SPI3_DMA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_SPI3_DMA_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_WDG_INT_MAP
func (o *DPORT_Type) SetPRO_WDG_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_WDG_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_WDG_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_WDG_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_WDG_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_TIMER_INT1_MAP
func (o *DPORT_Type) SetPRO_TIMER_INT1_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TIMER_INT1_MAP.Reg, volatile.LoadUint32(&o.PRO_TIMER_INT1_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_TIMER_INT1_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TIMER_INT1_MAP.Reg) & 0x1f
}

// DPORT.PRO_TIMER_INT2_MAP
func (o *DPORT_Type) SetPRO_TIMER_INT2_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TIMER_INT2_MAP.Reg, volatile.LoadUint32(&o.PRO_TIMER_INT2_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_TIMER_INT2_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TIMER_INT2_MAP.Reg) & 0x1f
}

// DPORT.PRO_TG_T0_EDGE_INT_MAP
func (o *DPORT_Type) SetPRO_TG_T0_EDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG_T0_EDGE_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG_T0_EDGE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_TG_T0_EDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG_T0_EDGE_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_TG_T1_EDGE_INT_MAP
func (o *DPORT_Type) SetPRO_TG_T1_EDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG_T1_EDGE_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG_T1_EDGE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_TG_T1_EDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG_T1_EDGE_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_TG_WDT_EDGE_INT_MAP
func (o *DPORT_Type) SetPRO_TG_WDT_EDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG_WDT_EDGE_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG_WDT_EDGE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_TG_WDT_EDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG_WDT_EDGE_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_TG_LACT_EDGE_INT_MAP
func (o *DPORT_Type) SetPRO_TG_LACT_EDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG_LACT_EDGE_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG_LACT_EDGE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_TG_LACT_EDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG_LACT_EDGE_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_TG1_T0_EDGE_INT_MAP
func (o *DPORT_Type) SetPRO_TG1_T0_EDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG1_T0_EDGE_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG1_T0_EDGE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_TG1_T0_EDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG1_T0_EDGE_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_TG1_T1_EDGE_INT_MAP
func (o *DPORT_Type) SetPRO_TG1_T1_EDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG1_T1_EDGE_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG1_T1_EDGE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_TG1_T1_EDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG1_T1_EDGE_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_TG1_WDT_EDGE_INT_MAP
func (o *DPORT_Type) SetPRO_TG1_WDT_EDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG1_WDT_EDGE_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG1_WDT_EDGE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_TG1_WDT_EDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG1_WDT_EDGE_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_TG1_LACT_EDGE_INT_MAP
func (o *DPORT_Type) SetPRO_TG1_LACT_EDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG1_LACT_EDGE_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG1_LACT_EDGE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_TG1_LACT_EDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG1_LACT_EDGE_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_MMU_IA_INT_MAP
func (o *DPORT_Type) SetPRO_MMU_IA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_MMU_IA_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_MMU_IA_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_MMU_IA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_MMU_IA_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_MPU_IA_INT_MAP
func (o *DPORT_Type) SetPRO_MPU_IA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_MPU_IA_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_MPU_IA_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_MPU_IA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_MPU_IA_INT_MAP.Reg) & 0x1f
}

// DPORT.PRO_CACHE_IA_INT_MAP
func (o *DPORT_Type) SetPRO_CACHE_IA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_IA_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_CACHE_IA_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_CACHE_IA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_CACHE_IA_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_MAC_INTR_MAP
func (o *DPORT_Type) SetAPP_MAC_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_MAC_INTR_MAP.Reg, volatile.LoadUint32(&o.APP_MAC_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_MAC_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_MAC_INTR_MAP.Reg) & 0x1f
}

// DPORT.APP_MAC_NMI_MAP
func (o *DPORT_Type) SetAPP_MAC_NMI_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_MAC_NMI_MAP.Reg, volatile.LoadUint32(&o.APP_MAC_NMI_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_MAC_NMI_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_MAC_NMI_MAP.Reg) & 0x1f
}

// DPORT.APP_BB_INT_MAP
func (o *DPORT_Type) SetAPP_BB_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_BB_INT_MAP.Reg, volatile.LoadUint32(&o.APP_BB_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_BB_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_BB_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_BT_MAC_INT_MAP
func (o *DPORT_Type) SetAPP_BT_MAC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_BT_MAC_INT_MAP.Reg, volatile.LoadUint32(&o.APP_BT_MAC_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_BT_MAC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_BT_MAC_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_BT_BB_INT_MAP
func (o *DPORT_Type) SetAPP_BT_BB_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_BT_BB_INT_MAP.Reg, volatile.LoadUint32(&o.APP_BT_BB_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_BT_BB_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_BT_BB_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_BT_BB_NMI_MAP
func (o *DPORT_Type) SetAPP_BT_BB_NMI_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_BT_BB_NMI_MAP.Reg, volatile.LoadUint32(&o.APP_BT_BB_NMI_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_BT_BB_NMI_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_BT_BB_NMI_MAP.Reg) & 0x1f
}

// DPORT.APP_RWBT_IRQ_MAP
func (o *DPORT_Type) SetAPP_RWBT_IRQ_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_RWBT_IRQ_MAP.Reg, volatile.LoadUint32(&o.APP_RWBT_IRQ_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_RWBT_IRQ_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_RWBT_IRQ_MAP.Reg) & 0x1f
}

// DPORT.APP_RWBLE_IRQ_MAP
func (o *DPORT_Type) SetAPP_RWBLE_IRQ_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_RWBLE_IRQ_MAP.Reg, volatile.LoadUint32(&o.APP_RWBLE_IRQ_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_RWBLE_IRQ_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_RWBLE_IRQ_MAP.Reg) & 0x1f
}

// DPORT.APP_RWBT_NMI_MAP
func (o *DPORT_Type) SetAPP_RWBT_NMI_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_RWBT_NMI_MAP.Reg, volatile.LoadUint32(&o.APP_RWBT_NMI_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_RWBT_NMI_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_RWBT_NMI_MAP.Reg) & 0x1f
}

// DPORT.APP_RWBLE_NMI_MAP
func (o *DPORT_Type) SetAPP_RWBLE_NMI_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_RWBLE_NMI_MAP.Reg, volatile.LoadUint32(&o.APP_RWBLE_NMI_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_RWBLE_NMI_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_RWBLE_NMI_MAP.Reg) & 0x1f
}

// DPORT.APP_SLC0_INTR_MAP
func (o *DPORT_Type) SetAPP_SLC0_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_SLC0_INTR_MAP.Reg, volatile.LoadUint32(&o.APP_SLC0_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_SLC0_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_SLC0_INTR_MAP.Reg) & 0x1f
}

// DPORT.APP_SLC1_INTR_MAP
func (o *DPORT_Type) SetAPP_SLC1_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_SLC1_INTR_MAP.Reg, volatile.LoadUint32(&o.APP_SLC1_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_SLC1_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_SLC1_INTR_MAP.Reg) & 0x1f
}

// DPORT.APP_UHCI0_INTR_MAP
func (o *DPORT_Type) SetAPP_UHCI0_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_UHCI0_INTR_MAP.Reg, volatile.LoadUint32(&o.APP_UHCI0_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_UHCI0_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_UHCI0_INTR_MAP.Reg) & 0x1f
}

// DPORT.APP_UHCI1_INTR_MAP
func (o *DPORT_Type) SetAPP_UHCI1_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_UHCI1_INTR_MAP.Reg, volatile.LoadUint32(&o.APP_UHCI1_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_UHCI1_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_UHCI1_INTR_MAP.Reg) & 0x1f
}

// DPORT.APP_TG_T0_LEVEL_INT_MAP
func (o *DPORT_Type) SetAPP_TG_T0_LEVEL_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_TG_T0_LEVEL_INT_MAP.Reg, volatile.LoadUint32(&o.APP_TG_T0_LEVEL_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_TG_T0_LEVEL_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_TG_T0_LEVEL_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_TG_T1_LEVEL_INT_MAP
func (o *DPORT_Type) SetAPP_TG_T1_LEVEL_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_TG_T1_LEVEL_INT_MAP.Reg, volatile.LoadUint32(&o.APP_TG_T1_LEVEL_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_TG_T1_LEVEL_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_TG_T1_LEVEL_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_TG_WDT_LEVEL_INT_MAP
func (o *DPORT_Type) SetAPP_TG_WDT_LEVEL_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_TG_WDT_LEVEL_INT_MAP.Reg, volatile.LoadUint32(&o.APP_TG_WDT_LEVEL_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_TG_WDT_LEVEL_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_TG_WDT_LEVEL_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_TG_LACT_LEVEL_INT_MAP
func (o *DPORT_Type) SetAPP_TG_LACT_LEVEL_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_TG_LACT_LEVEL_INT_MAP.Reg, volatile.LoadUint32(&o.APP_TG_LACT_LEVEL_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_TG_LACT_LEVEL_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_TG_LACT_LEVEL_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_TG1_T0_LEVEL_INT_MAP
func (o *DPORT_Type) SetAPP_TG1_T0_LEVEL_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_TG1_T0_LEVEL_INT_MAP.Reg, volatile.LoadUint32(&o.APP_TG1_T0_LEVEL_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_TG1_T0_LEVEL_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_TG1_T0_LEVEL_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_TG1_T1_LEVEL_INT_MAP
func (o *DPORT_Type) SetAPP_TG1_T1_LEVEL_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_TG1_T1_LEVEL_INT_MAP.Reg, volatile.LoadUint32(&o.APP_TG1_T1_LEVEL_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_TG1_T1_LEVEL_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_TG1_T1_LEVEL_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_TG1_WDT_LEVEL_INT_MAP
func (o *DPORT_Type) SetAPP_TG1_WDT_LEVEL_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_TG1_WDT_LEVEL_INT_MAP.Reg, volatile.LoadUint32(&o.APP_TG1_WDT_LEVEL_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_TG1_WDT_LEVEL_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_TG1_WDT_LEVEL_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_TG1_LACT_LEVEL_INT_MAP
func (o *DPORT_Type) SetAPP_TG1_LACT_LEVEL_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_TG1_LACT_LEVEL_INT_MAP.Reg, volatile.LoadUint32(&o.APP_TG1_LACT_LEVEL_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_TG1_LACT_LEVEL_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_TG1_LACT_LEVEL_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_GPIO_INTERRUPT_MAP
func (o *DPORT_Type) SetAPP_GPIO_INTERRUPT_MAP_APP_GPIO_INTERRUPT_APP_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_GPIO_INTERRUPT_MAP.Reg, volatile.LoadUint32(&o.APP_GPIO_INTERRUPT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_GPIO_INTERRUPT_MAP_APP_GPIO_INTERRUPT_APP_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_GPIO_INTERRUPT_MAP.Reg) & 0x1f
}

// DPORT.APP_GPIO_INTERRUPT_NMI_MAP
func (o *DPORT_Type) SetAPP_GPIO_INTERRUPT_NMI_MAP_APP_GPIO_INTERRUPT_APP_NMI_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_GPIO_INTERRUPT_NMI_MAP.Reg, volatile.LoadUint32(&o.APP_GPIO_INTERRUPT_NMI_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_GPIO_INTERRUPT_NMI_MAP_APP_GPIO_INTERRUPT_APP_NMI_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_GPIO_INTERRUPT_NMI_MAP.Reg) & 0x1f
}

// DPORT.APP_CPU_INTR_FROM_CPU_0_MAP
func (o *DPORT_Type) SetAPP_CPU_INTR_FROM_CPU_0_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_CPU_INTR_FROM_CPU_0_MAP.Reg, volatile.LoadUint32(&o.APP_CPU_INTR_FROM_CPU_0_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_CPU_INTR_FROM_CPU_0_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_CPU_INTR_FROM_CPU_0_MAP.Reg) & 0x1f
}

// DPORT.APP_CPU_INTR_FROM_CPU_1_MAP
func (o *DPORT_Type) SetAPP_CPU_INTR_FROM_CPU_1_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_CPU_INTR_FROM_CPU_1_MAP.Reg, volatile.LoadUint32(&o.APP_CPU_INTR_FROM_CPU_1_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_CPU_INTR_FROM_CPU_1_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_CPU_INTR_FROM_CPU_1_MAP.Reg) & 0x1f
}

// DPORT.APP_CPU_INTR_FROM_CPU_2_MAP
func (o *DPORT_Type) SetAPP_CPU_INTR_FROM_CPU_2_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_CPU_INTR_FROM_CPU_2_MAP.Reg, volatile.LoadUint32(&o.APP_CPU_INTR_FROM_CPU_2_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_CPU_INTR_FROM_CPU_2_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_CPU_INTR_FROM_CPU_2_MAP.Reg) & 0x1f
}

// DPORT.APP_CPU_INTR_FROM_CPU_3_MAP
func (o *DPORT_Type) SetAPP_CPU_INTR_FROM_CPU_3_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_CPU_INTR_FROM_CPU_3_MAP.Reg, volatile.LoadUint32(&o.APP_CPU_INTR_FROM_CPU_3_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_CPU_INTR_FROM_CPU_3_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_CPU_INTR_FROM_CPU_3_MAP.Reg) & 0x1f
}

// DPORT.APP_SPI_INTR_0_MAP
func (o *DPORT_Type) SetAPP_SPI_INTR_0_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_SPI_INTR_0_MAP.Reg, volatile.LoadUint32(&o.APP_SPI_INTR_0_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_SPI_INTR_0_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_SPI_INTR_0_MAP.Reg) & 0x1f
}

// DPORT.APP_SPI_INTR_1_MAP
func (o *DPORT_Type) SetAPP_SPI_INTR_1_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_SPI_INTR_1_MAP.Reg, volatile.LoadUint32(&o.APP_SPI_INTR_1_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_SPI_INTR_1_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_SPI_INTR_1_MAP.Reg) & 0x1f
}

// DPORT.APP_SPI_INTR_2_MAP
func (o *DPORT_Type) SetAPP_SPI_INTR_2_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_SPI_INTR_2_MAP.Reg, volatile.LoadUint32(&o.APP_SPI_INTR_2_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_SPI_INTR_2_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_SPI_INTR_2_MAP.Reg) & 0x1f
}

// DPORT.APP_SPI_INTR_3_MAP
func (o *DPORT_Type) SetAPP_SPI_INTR_3_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_SPI_INTR_3_MAP.Reg, volatile.LoadUint32(&o.APP_SPI_INTR_3_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_SPI_INTR_3_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_SPI_INTR_3_MAP.Reg) & 0x1f
}

// DPORT.APP_I2S0_INT_MAP
func (o *DPORT_Type) SetAPP_I2S0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_I2S0_INT_MAP.Reg, volatile.LoadUint32(&o.APP_I2S0_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_I2S0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_I2S0_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_I2S1_INT_MAP
func (o *DPORT_Type) SetAPP_I2S1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_I2S1_INT_MAP.Reg, volatile.LoadUint32(&o.APP_I2S1_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_I2S1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_I2S1_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_UART_INTR_MAP
func (o *DPORT_Type) SetAPP_UART_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_UART_INTR_MAP.Reg, volatile.LoadUint32(&o.APP_UART_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_UART_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_UART_INTR_MAP.Reg) & 0x1f
}

// DPORT.APP_UART1_INTR_MAP
func (o *DPORT_Type) SetAPP_UART1_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_UART1_INTR_MAP.Reg, volatile.LoadUint32(&o.APP_UART1_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_UART1_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_UART1_INTR_MAP.Reg) & 0x1f
}

// DPORT.APP_UART2_INTR_MAP
func (o *DPORT_Type) SetAPP_UART2_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_UART2_INTR_MAP.Reg, volatile.LoadUint32(&o.APP_UART2_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_UART2_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_UART2_INTR_MAP.Reg) & 0x1f
}

// DPORT.APP_SDIO_HOST_INTERRUPT_MAP
func (o *DPORT_Type) SetAPP_SDIO_HOST_INTERRUPT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_SDIO_HOST_INTERRUPT_MAP.Reg, volatile.LoadUint32(&o.APP_SDIO_HOST_INTERRUPT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_SDIO_HOST_INTERRUPT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_SDIO_HOST_INTERRUPT_MAP.Reg) & 0x1f
}

// DPORT.APP_EMAC_INT_MAP
func (o *DPORT_Type) SetAPP_EMAC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_EMAC_INT_MAP.Reg, volatile.LoadUint32(&o.APP_EMAC_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_EMAC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_EMAC_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_PWM0_INTR_MAP
func (o *DPORT_Type) SetAPP_PWM0_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_PWM0_INTR_MAP.Reg, volatile.LoadUint32(&o.APP_PWM0_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_PWM0_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_PWM0_INTR_MAP.Reg) & 0x1f
}

// DPORT.APP_PWM1_INTR_MAP
func (o *DPORT_Type) SetAPP_PWM1_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_PWM1_INTR_MAP.Reg, volatile.LoadUint32(&o.APP_PWM1_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_PWM1_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_PWM1_INTR_MAP.Reg) & 0x1f
}

// DPORT.APP_PWM2_INTR_MAP
func (o *DPORT_Type) SetAPP_PWM2_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_PWM2_INTR_MAP.Reg, volatile.LoadUint32(&o.APP_PWM2_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_PWM2_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_PWM2_INTR_MAP.Reg) & 0x1f
}

// DPORT.APP_PWM3_INTR_MAP
func (o *DPORT_Type) SetAPP_PWM3_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_PWM3_INTR_MAP.Reg, volatile.LoadUint32(&o.APP_PWM3_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_PWM3_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_PWM3_INTR_MAP.Reg) & 0x1f
}

// DPORT.APP_LEDC_INT_MAP
func (o *DPORT_Type) SetAPP_LEDC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_LEDC_INT_MAP.Reg, volatile.LoadUint32(&o.APP_LEDC_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_LEDC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_LEDC_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_EFUSE_INT_MAP
func (o *DPORT_Type) SetAPP_EFUSE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_EFUSE_INT_MAP.Reg, volatile.LoadUint32(&o.APP_EFUSE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_EFUSE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_EFUSE_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_CAN_INT_MAP
func (o *DPORT_Type) SetAPP_CAN_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_CAN_INT_MAP.Reg, volatile.LoadUint32(&o.APP_CAN_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_CAN_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_CAN_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_RTC_CORE_INTR_MAP
func (o *DPORT_Type) SetAPP_RTC_CORE_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_RTC_CORE_INTR_MAP.Reg, volatile.LoadUint32(&o.APP_RTC_CORE_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_RTC_CORE_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_RTC_CORE_INTR_MAP.Reg) & 0x1f
}

// DPORT.APP_RMT_INTR_MAP
func (o *DPORT_Type) SetAPP_RMT_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_RMT_INTR_MAP.Reg, volatile.LoadUint32(&o.APP_RMT_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_RMT_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_RMT_INTR_MAP.Reg) & 0x1f
}

// DPORT.APP_PCNT_INTR_MAP
func (o *DPORT_Type) SetAPP_PCNT_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_PCNT_INTR_MAP.Reg, volatile.LoadUint32(&o.APP_PCNT_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_PCNT_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_PCNT_INTR_MAP.Reg) & 0x1f
}

// DPORT.APP_I2C_EXT0_INTR_MAP
func (o *DPORT_Type) SetAPP_I2C_EXT0_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_I2C_EXT0_INTR_MAP.Reg, volatile.LoadUint32(&o.APP_I2C_EXT0_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_I2C_EXT0_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_I2C_EXT0_INTR_MAP.Reg) & 0x1f
}

// DPORT.APP_I2C_EXT1_INTR_MAP
func (o *DPORT_Type) SetAPP_I2C_EXT1_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_I2C_EXT1_INTR_MAP.Reg, volatile.LoadUint32(&o.APP_I2C_EXT1_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_I2C_EXT1_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_I2C_EXT1_INTR_MAP.Reg) & 0x1f
}

// DPORT.APP_RSA_INTR_MAP
func (o *DPORT_Type) SetAPP_RSA_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_RSA_INTR_MAP.Reg, volatile.LoadUint32(&o.APP_RSA_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_RSA_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_RSA_INTR_MAP.Reg) & 0x1f
}

// DPORT.APP_SPI1_DMA_INT_MAP
func (o *DPORT_Type) SetAPP_SPI1_DMA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_SPI1_DMA_INT_MAP.Reg, volatile.LoadUint32(&o.APP_SPI1_DMA_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_SPI1_DMA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_SPI1_DMA_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_SPI2_DMA_INT_MAP
func (o *DPORT_Type) SetAPP_SPI2_DMA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_SPI2_DMA_INT_MAP.Reg, volatile.LoadUint32(&o.APP_SPI2_DMA_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_SPI2_DMA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_SPI2_DMA_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_SPI3_DMA_INT_MAP
func (o *DPORT_Type) SetAPP_SPI3_DMA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_SPI3_DMA_INT_MAP.Reg, volatile.LoadUint32(&o.APP_SPI3_DMA_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_SPI3_DMA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_SPI3_DMA_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_WDG_INT_MAP
func (o *DPORT_Type) SetAPP_WDG_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_WDG_INT_MAP.Reg, volatile.LoadUint32(&o.APP_WDG_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_WDG_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_WDG_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_TIMER_INT1_MAP
func (o *DPORT_Type) SetAPP_TIMER_INT1_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_TIMER_INT1_MAP.Reg, volatile.LoadUint32(&o.APP_TIMER_INT1_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_TIMER_INT1_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_TIMER_INT1_MAP.Reg) & 0x1f
}

// DPORT.APP_TIMER_INT2_MAP
func (o *DPORT_Type) SetAPP_TIMER_INT2_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_TIMER_INT2_MAP.Reg, volatile.LoadUint32(&o.APP_TIMER_INT2_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_TIMER_INT2_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_TIMER_INT2_MAP.Reg) & 0x1f
}

// DPORT.APP_TG_T0_EDGE_INT_MAP
func (o *DPORT_Type) SetAPP_TG_T0_EDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_TG_T0_EDGE_INT_MAP.Reg, volatile.LoadUint32(&o.APP_TG_T0_EDGE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_TG_T0_EDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_TG_T0_EDGE_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_TG_T1_EDGE_INT_MAP
func (o *DPORT_Type) SetAPP_TG_T1_EDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_TG_T1_EDGE_INT_MAP.Reg, volatile.LoadUint32(&o.APP_TG_T1_EDGE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_TG_T1_EDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_TG_T1_EDGE_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_TG_WDT_EDGE_INT_MAP
func (o *DPORT_Type) SetAPP_TG_WDT_EDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_TG_WDT_EDGE_INT_MAP.Reg, volatile.LoadUint32(&o.APP_TG_WDT_EDGE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_TG_WDT_EDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_TG_WDT_EDGE_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_TG_LACT_EDGE_INT_MAP
func (o *DPORT_Type) SetAPP_TG_LACT_EDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_TG_LACT_EDGE_INT_MAP.Reg, volatile.LoadUint32(&o.APP_TG_LACT_EDGE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_TG_LACT_EDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_TG_LACT_EDGE_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_TG1_T0_EDGE_INT_MAP
func (o *DPORT_Type) SetAPP_TG1_T0_EDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_TG1_T0_EDGE_INT_MAP.Reg, volatile.LoadUint32(&o.APP_TG1_T0_EDGE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_TG1_T0_EDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_TG1_T0_EDGE_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_TG1_T1_EDGE_INT_MAP
func (o *DPORT_Type) SetAPP_TG1_T1_EDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_TG1_T1_EDGE_INT_MAP.Reg, volatile.LoadUint32(&o.APP_TG1_T1_EDGE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_TG1_T1_EDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_TG1_T1_EDGE_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_TG1_WDT_EDGE_INT_MAP
func (o *DPORT_Type) SetAPP_TG1_WDT_EDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_TG1_WDT_EDGE_INT_MAP.Reg, volatile.LoadUint32(&o.APP_TG1_WDT_EDGE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_TG1_WDT_EDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_TG1_WDT_EDGE_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_TG1_LACT_EDGE_INT_MAP
func (o *DPORT_Type) SetAPP_TG1_LACT_EDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_TG1_LACT_EDGE_INT_MAP.Reg, volatile.LoadUint32(&o.APP_TG1_LACT_EDGE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_TG1_LACT_EDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_TG1_LACT_EDGE_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_MMU_IA_INT_MAP
func (o *DPORT_Type) SetAPP_MMU_IA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_MMU_IA_INT_MAP.Reg, volatile.LoadUint32(&o.APP_MMU_IA_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_MMU_IA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_MMU_IA_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_MPU_IA_INT_MAP
func (o *DPORT_Type) SetAPP_MPU_IA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_MPU_IA_INT_MAP.Reg, volatile.LoadUint32(&o.APP_MPU_IA_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_MPU_IA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_MPU_IA_INT_MAP.Reg) & 0x1f
}

// DPORT.APP_CACHE_IA_INT_MAP
func (o *DPORT_Type) SetAPP_CACHE_IA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APP_CACHE_IA_INT_MAP.Reg, volatile.LoadUint32(&o.APP_CACHE_IA_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetAPP_CACHE_IA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APP_CACHE_IA_INT_MAP.Reg) & 0x1f
}

// DPORT.AHBLITE_MPU_TABLE_UART
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_UART_UART_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_UART.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_UART.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_UART_UART_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_UART.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_SPI1
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_SPI1_SPI1_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_SPI1.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_SPI1.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_SPI1_SPI1_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_SPI1.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_SPI0
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_SPI0_SPI0_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_SPI0.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_SPI0.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_SPI0_SPI0_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_SPI0.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_GPIO
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_GPIO_GPIO_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_GPIO.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_GPIO.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_GPIO_GPIO_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_GPIO.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_FE2
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_FE2_FE2_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_FE2.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_FE2.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_FE2_FE2_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_FE2.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_FE
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_FE_FE_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_FE.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_FE.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_FE_FE_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_FE.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_TIMER
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_TIMER_TIMER_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_TIMER.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_TIMER.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_TIMER_TIMER_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_TIMER.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_RTC
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_RTC_RTC_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_RTC.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_RTC.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_RTC_RTC_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_RTC.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_IO_MUX
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_IO_MUX_IOMUX_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_IO_MUX.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_IO_MUX.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_IO_MUX_IOMUX_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_IO_MUX.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_WDG
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_WDG_WDG_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_WDG.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_WDG.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_WDG_WDG_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_WDG.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_HINF
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_HINF_HINF_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_HINF.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_HINF.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_HINF_HINF_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_HINF.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_UHCI1
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_UHCI1_UHCI1_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_UHCI1.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_UHCI1.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_UHCI1_UHCI1_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_UHCI1.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_MISC
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_MISC_MISC_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_MISC.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_MISC.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_MISC_MISC_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_MISC.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_I2C
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_I2C_I2C_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_I2C.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_I2C.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_I2C_I2C_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_I2C.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_I2S0
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_I2S0_I2S0_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_I2S0.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_I2S0.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_I2S0_I2S0_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_I2S0.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_UART1
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_UART1_UART1_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_UART1.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_UART1.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_UART1_UART1_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_UART1.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_BT
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_BT_BT_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_BT.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_BT.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_BT_BT_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_BT.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_BT_BUFFER
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_BT_BUFFER_BTBUFFER_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_BT_BUFFER.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_BT_BUFFER.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_BT_BUFFER_BTBUFFER_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_BT_BUFFER.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_I2C_EXT0
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_I2C_EXT0_I2CEXT0_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_I2C_EXT0.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_I2C_EXT0.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_I2C_EXT0_I2CEXT0_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_I2C_EXT0.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_UHCI0
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_UHCI0_UHCI0_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_UHCI0.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_UHCI0.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_UHCI0_UHCI0_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_UHCI0.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_SLCHOST
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_SLCHOST_SLCHOST_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_SLCHOST.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_SLCHOST.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_SLCHOST_SLCHOST_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_SLCHOST.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_RMT
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_RMT_RMT_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_RMT.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_RMT.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_RMT_RMT_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_RMT.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_PCNT
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_PCNT_PCNT_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_PCNT.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_PCNT.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_PCNT_PCNT_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_PCNT.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_SLC
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_SLC_SLC_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_SLC.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_SLC.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_SLC_SLC_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_SLC.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_LEDC
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_LEDC_LEDC_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_LEDC.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_LEDC.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_LEDC_LEDC_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_LEDC.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_EFUSE
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_EFUSE_EFUSE_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_EFUSE.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_EFUSE.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_EFUSE_EFUSE_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_EFUSE.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_SPI_ENCRYPT
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_SPI_ENCRYPT_SPI_ENCRYPY_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_SPI_ENCRYPT.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_SPI_ENCRYPT.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_SPI_ENCRYPT_SPI_ENCRYPY_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_SPI_ENCRYPT.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_BB
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_BB_BB_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_BB.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_BB.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_BB_BB_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_BB.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_PWM0
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_PWM0_PWM0_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_PWM0.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_PWM0.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_PWM0_PWM0_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_PWM0.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_TIMERGROUP
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_TIMERGROUP_TIMERGROUP_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_TIMERGROUP.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_TIMERGROUP.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_TIMERGROUP_TIMERGROUP_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_TIMERGROUP.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_TIMERGROUP1
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_TIMERGROUP1_TIMERGROUP1_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_TIMERGROUP1.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_TIMERGROUP1.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_TIMERGROUP1_TIMERGROUP1_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_TIMERGROUP1.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_SPI2
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_SPI2_SPI2_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_SPI2.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_SPI2.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_SPI2_SPI2_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_SPI2.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_SPI3
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_SPI3_SPI3_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_SPI3.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_SPI3.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_SPI3_SPI3_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_SPI3.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_APB_CTRL
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_APB_CTRL_APBCTRL_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_APB_CTRL.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_APB_CTRL.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_APB_CTRL_APBCTRL_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_APB_CTRL.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_I2C_EXT1
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_I2C_EXT1_I2CEXT1_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_I2C_EXT1.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_I2C_EXT1.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_I2C_EXT1_I2CEXT1_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_I2C_EXT1.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_SDIO_HOST
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_SDIO_HOST_SDIOHOST_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_SDIO_HOST.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_SDIO_HOST.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_SDIO_HOST_SDIOHOST_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_SDIO_HOST.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_EMAC
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_EMAC_EMAC_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_EMAC.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_EMAC.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_EMAC_EMAC_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_EMAC.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_CAN
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_CAN_CAN_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_CAN.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_CAN.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_CAN_CAN_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_CAN.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_PWM1
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_PWM1_PWM1_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_PWM1.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_PWM1.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_PWM1_PWM1_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_PWM1.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_I2S1
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_I2S1_I2S1_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_I2S1.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_I2S1.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_I2S1_I2S1_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_I2S1.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_UART2
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_UART2_UART2_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_UART2.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_UART2.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_UART2_UART2_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_UART2.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_PWM2
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_PWM2_PWM2_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_PWM2.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_PWM2.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_PWM2_PWM2_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_PWM2.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_PWM3
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_PWM3_PWM3_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_PWM3.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_PWM3.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_PWM3_PWM3_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_PWM3.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_RWBT
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_RWBT_RWBT_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_RWBT.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_RWBT.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_RWBT_RWBT_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_RWBT.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_BTMAC
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_BTMAC_BTMAC_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_BTMAC.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_BTMAC.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_BTMAC_BTMAC_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_BTMAC.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_WIFIMAC
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_WIFIMAC_WIFIMAC_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_WIFIMAC.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_WIFIMAC.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_WIFIMAC_WIFIMAC_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_WIFIMAC.Reg) & 0x3f
}

// DPORT.AHBLITE_MPU_TABLE_PWR
func (o *DPORT_Type) SetAHBLITE_MPU_TABLE_PWR_PWR_ACCESS_GRANT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.AHBLITE_MPU_TABLE_PWR.Reg, volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_PWR.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetAHBLITE_MPU_TABLE_PWR_PWR_ACCESS_GRANT_CONFIG() uint32 {
	return volatile.LoadUint32(&o.AHBLITE_MPU_TABLE_PWR.Reg) & 0x3f
}

// DPORT.MEM_ACCESS_DBUG0
func (o *DPORT_Type) SetMEM_ACCESS_DBUG0_PRO_ROM_MPU_AD(value uint32) {
	volatile.StoreUint32(&o.MEM_ACCESS_DBUG0.Reg, volatile.LoadUint32(&o.MEM_ACCESS_DBUG0.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetMEM_ACCESS_DBUG0_PRO_ROM_MPU_AD() uint32 {
	return volatile.LoadUint32(&o.MEM_ACCESS_DBUG0.Reg) & 0x1
}
func (o *DPORT_Type) SetMEM_ACCESS_DBUG0_PRO_ROM_IA(value uint32) {
	volatile.StoreUint32(&o.MEM_ACCESS_DBUG0.Reg, volatile.LoadUint32(&o.MEM_ACCESS_DBUG0.Reg)&^(0x2)|value<<1)
}
func (o *DPORT_Type) GetMEM_ACCESS_DBUG0_PRO_ROM_IA() uint32 {
	return (volatile.LoadUint32(&o.MEM_ACCESS_DBUG0.Reg) & 0x2) >> 1
}
func (o *DPORT_Type) SetMEM_ACCESS_DBUG0_APP_ROM_MPU_AD(value uint32) {
	volatile.StoreUint32(&o.MEM_ACCESS_DBUG0.Reg, volatile.LoadUint32(&o.MEM_ACCESS_DBUG0.Reg)&^(0x4)|value<<2)
}
func (o *DPORT_Type) GetMEM_ACCESS_DBUG0_APP_ROM_MPU_AD() uint32 {
	return (volatile.LoadUint32(&o.MEM_ACCESS_DBUG0.Reg) & 0x4) >> 2
}
func (o *DPORT_Type) SetMEM_ACCESS_DBUG0_APP_ROM_IA(value uint32) {
	volatile.StoreUint32(&o.MEM_ACCESS_DBUG0.Reg, volatile.LoadUint32(&o.MEM_ACCESS_DBUG0.Reg)&^(0x8)|value<<3)
}
func (o *DPORT_Type) GetMEM_ACCESS_DBUG0_APP_ROM_IA() uint32 {
	return (volatile.LoadUint32(&o.MEM_ACCESS_DBUG0.Reg) & 0x8) >> 3
}
func (o *DPORT_Type) SetMEM_ACCESS_DBUG0_SHARE_ROM_MPU_AD(value uint32) {
	volatile.StoreUint32(&o.MEM_ACCESS_DBUG0.Reg, volatile.LoadUint32(&o.MEM_ACCESS_DBUG0.Reg)&^(0x30)|value<<4)
}
func (o *DPORT_Type) GetMEM_ACCESS_DBUG0_SHARE_ROM_MPU_AD() uint32 {
	return (volatile.LoadUint32(&o.MEM_ACCESS_DBUG0.Reg) & 0x30) >> 4
}
func (o *DPORT_Type) SetMEM_ACCESS_DBUG0_SHARE_ROM_IA(value uint32) {
	volatile.StoreUint32(&o.MEM_ACCESS_DBUG0.Reg, volatile.LoadUint32(&o.MEM_ACCESS_DBUG0.Reg)&^(0x3c0)|value<<6)
}
func (o *DPORT_Type) GetMEM_ACCESS_DBUG0_SHARE_ROM_IA() uint32 {
	return (volatile.LoadUint32(&o.MEM_ACCESS_DBUG0.Reg) & 0x3c0) >> 6
}
func (o *DPORT_Type) SetMEM_ACCESS_DBUG0_INTERNAL_SRAM_MMU_AD(value uint32) {
	volatile.StoreUint32(&o.MEM_ACCESS_DBUG0.Reg, volatile.LoadUint32(&o.MEM_ACCESS_DBUG0.Reg)&^(0x3c00)|value<<10)
}
func (o *DPORT_Type) GetMEM_ACCESS_DBUG0_INTERNAL_SRAM_MMU_AD() uint32 {
	return (volatile.LoadUint32(&o.MEM_ACCESS_DBUG0.Reg) & 0x3c00) >> 10
}
func (o *DPORT_Type) SetMEM_ACCESS_DBUG0_INTERNAL_SRAM_IA(value uint32) {
	volatile.StoreUint32(&o.MEM_ACCESS_DBUG0.Reg, volatile.LoadUint32(&o.MEM_ACCESS_DBUG0.Reg)&^(0x3ffc000)|value<<14)
}
func (o *DPORT_Type) GetMEM_ACCESS_DBUG0_INTERNAL_SRAM_IA() uint32 {
	return (volatile.LoadUint32(&o.MEM_ACCESS_DBUG0.Reg) & 0x3ffc000) >> 14
}
func (o *DPORT_Type) SetMEM_ACCESS_DBUG0_INTERNAL_SRAM_MMU_MULTI_HIT(value uint32) {
	volatile.StoreUint32(&o.MEM_ACCESS_DBUG0.Reg, volatile.LoadUint32(&o.MEM_ACCESS_DBUG0.Reg)&^(0x3c000000)|value<<26)
}
func (o *DPORT_Type) GetMEM_ACCESS_DBUG0_INTERNAL_SRAM_MMU_MULTI_HIT() uint32 {
	return (volatile.LoadUint32(&o.MEM_ACCESS_DBUG0.Reg) & 0x3c000000) >> 26
}

// DPORT.MEM_ACCESS_DBUG1
func (o *DPORT_Type) SetMEM_ACCESS_DBUG1_INTERNAL_SRAM_MMU_MISS(value uint32) {
	volatile.StoreUint32(&o.MEM_ACCESS_DBUG1.Reg, volatile.LoadUint32(&o.MEM_ACCESS_DBUG1.Reg)&^(0xf)|value)
}
func (o *DPORT_Type) GetMEM_ACCESS_DBUG1_INTERNAL_SRAM_MMU_MISS() uint32 {
	return volatile.LoadUint32(&o.MEM_ACCESS_DBUG1.Reg) & 0xf
}
func (o *DPORT_Type) SetMEM_ACCESS_DBUG1_ARB_IA(value uint32) {
	volatile.StoreUint32(&o.MEM_ACCESS_DBUG1.Reg, volatile.LoadUint32(&o.MEM_ACCESS_DBUG1.Reg)&^(0x30)|value<<4)
}
func (o *DPORT_Type) GetMEM_ACCESS_DBUG1_ARB_IA() uint32 {
	return (volatile.LoadUint32(&o.MEM_ACCESS_DBUG1.Reg) & 0x30) >> 4
}
func (o *DPORT_Type) SetMEM_ACCESS_DBUG1_PIDGEN_IA(value uint32) {
	volatile.StoreUint32(&o.MEM_ACCESS_DBUG1.Reg, volatile.LoadUint32(&o.MEM_ACCESS_DBUG1.Reg)&^(0xc0)|value<<6)
}
func (o *DPORT_Type) GetMEM_ACCESS_DBUG1_PIDGEN_IA() uint32 {
	return (volatile.LoadUint32(&o.MEM_ACCESS_DBUG1.Reg) & 0xc0) >> 6
}
func (o *DPORT_Type) SetMEM_ACCESS_DBUG1_AHB_ACCESS_DENY(value uint32) {
	volatile.StoreUint32(&o.MEM_ACCESS_DBUG1.Reg, volatile.LoadUint32(&o.MEM_ACCESS_DBUG1.Reg)&^(0x100)|value<<8)
}
func (o *DPORT_Type) GetMEM_ACCESS_DBUG1_AHB_ACCESS_DENY() uint32 {
	return (volatile.LoadUint32(&o.MEM_ACCESS_DBUG1.Reg) & 0x100) >> 8
}
func (o *DPORT_Type) SetMEM_ACCESS_DBUG1_AHBLITE_ACCESS_DENY(value uint32) {
	volatile.StoreUint32(&o.MEM_ACCESS_DBUG1.Reg, volatile.LoadUint32(&o.MEM_ACCESS_DBUG1.Reg)&^(0x200)|value<<9)
}
func (o *DPORT_Type) GetMEM_ACCESS_DBUG1_AHBLITE_ACCESS_DENY() uint32 {
	return (volatile.LoadUint32(&o.MEM_ACCESS_DBUG1.Reg) & 0x200) >> 9
}
func (o *DPORT_Type) SetMEM_ACCESS_DBUG1_AHBLITE_IA(value uint32) {
	volatile.StoreUint32(&o.MEM_ACCESS_DBUG1.Reg, volatile.LoadUint32(&o.MEM_ACCESS_DBUG1.Reg)&^(0x400)|value<<10)
}
func (o *DPORT_Type) GetMEM_ACCESS_DBUG1_AHBLITE_IA() uint32 {
	return (volatile.LoadUint32(&o.MEM_ACCESS_DBUG1.Reg) & 0x400) >> 10
}

// DPORT.PRO_DCACHE_DBUG0
func (o *DPORT_Type) SetPRO_DCACHE_DBUG0_PRO_SLAVE_WDATA(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_DBUG0.Reg, volatile.LoadUint32(&o.PRO_DCACHE_DBUG0.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetPRO_DCACHE_DBUG0_PRO_SLAVE_WDATA() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_DBUG0.Reg) & 0x1
}
func (o *DPORT_Type) SetPRO_DCACHE_DBUG0_PRO_CACHE_MMU_IA(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_DBUG0.Reg, volatile.LoadUint32(&o.PRO_DCACHE_DBUG0.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetPRO_DCACHE_DBUG0_PRO_CACHE_MMU_IA() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_DBUG0.Reg) & 0x1
}
func (o *DPORT_Type) SetPRO_DCACHE_DBUG0_PRO_CACHE_IA(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_DBUG0.Reg, volatile.LoadUint32(&o.PRO_DCACHE_DBUG0.Reg)&^(0x7e)|value<<1)
}
func (o *DPORT_Type) GetPRO_DCACHE_DBUG0_PRO_CACHE_IA() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_DBUG0.Reg) & 0x7e) >> 1
}
func (o *DPORT_Type) SetPRO_DCACHE_DBUG0_PRO_CACHE_STATE(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_DBUG0.Reg, volatile.LoadUint32(&o.PRO_DCACHE_DBUG0.Reg)&^(0x7ff80)|value<<7)
}
func (o *DPORT_Type) GetPRO_DCACHE_DBUG0_PRO_CACHE_STATE() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_DBUG0.Reg) & 0x7ff80) >> 7
}
func (o *DPORT_Type) SetPRO_DCACHE_DBUG0_PRO_WR_BAK_TO_READ(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_DBUG0.Reg, volatile.LoadUint32(&o.PRO_DCACHE_DBUG0.Reg)&^(0x80000)|value<<19)
}
func (o *DPORT_Type) GetPRO_DCACHE_DBUG0_PRO_WR_BAK_TO_READ() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_DBUG0.Reg) & 0x80000) >> 19
}
func (o *DPORT_Type) SetPRO_DCACHE_DBUG0_PRO_TX_END(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_DBUG0.Reg, volatile.LoadUint32(&o.PRO_DCACHE_DBUG0.Reg)&^(0x100000)|value<<20)
}
func (o *DPORT_Type) GetPRO_DCACHE_DBUG0_PRO_TX_END() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_DBUG0.Reg) & 0x100000) >> 20
}
func (o *DPORT_Type) SetPRO_DCACHE_DBUG0_PRO_SLAVE_WR(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_DBUG0.Reg, volatile.LoadUint32(&o.PRO_DCACHE_DBUG0.Reg)&^(0x200000)|value<<21)
}
func (o *DPORT_Type) GetPRO_DCACHE_DBUG0_PRO_SLAVE_WR() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_DBUG0.Reg) & 0x200000) >> 21
}
func (o *DPORT_Type) SetPRO_DCACHE_DBUG0_PRO_SLAVE_WDATA_V(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_DBUG0.Reg, volatile.LoadUint32(&o.PRO_DCACHE_DBUG0.Reg)&^(0x400000)|value<<22)
}
func (o *DPORT_Type) GetPRO_DCACHE_DBUG0_PRO_SLAVE_WDATA_V() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_DBUG0.Reg) & 0x400000) >> 22
}
func (o *DPORT_Type) SetPRO_DCACHE_DBUG0_PRO_RX_END(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_DBUG0.Reg, volatile.LoadUint32(&o.PRO_DCACHE_DBUG0.Reg)&^(0x800000)|value<<23)
}
func (o *DPORT_Type) GetPRO_DCACHE_DBUG0_PRO_RX_END() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_DBUG0.Reg) & 0x800000) >> 23
}

// DPORT.PRO_DCACHE_DBUG1
func (o *DPORT_Type) SetPRO_DCACHE_DBUG1(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_DBUG1.Reg, value)
}
func (o *DPORT_Type) GetPRO_DCACHE_DBUG1() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_DBUG1.Reg)
}

// DPORT.PRO_DCACHE_DBUG2
func (o *DPORT_Type) SetPRO_DCACHE_DBUG2_PRO_CACHE_VADDR(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_DBUG2.Reg, volatile.LoadUint32(&o.PRO_DCACHE_DBUG2.Reg)&^(0x7ffffff)|value)
}
func (o *DPORT_Type) GetPRO_DCACHE_DBUG2_PRO_CACHE_VADDR() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_DBUG2.Reg) & 0x7ffffff
}

// DPORT.PRO_DCACHE_DBUG3
func (o *DPORT_Type) SetPRO_DCACHE_DBUG3_PRO_MMU_RDATA(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_DBUG3.Reg, volatile.LoadUint32(&o.PRO_DCACHE_DBUG3.Reg)&^(0x1ff)|value)
}
func (o *DPORT_Type) GetPRO_DCACHE_DBUG3_PRO_MMU_RDATA() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_DBUG3.Reg) & 0x1ff
}
func (o *DPORT_Type) SetPRO_DCACHE_DBUG3_PRO_CPU_DISABLED_CACHE_IA(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_DBUG3.Reg, volatile.LoadUint32(&o.PRO_DCACHE_DBUG3.Reg)&^(0x7e00)|value<<9)
}
func (o *DPORT_Type) GetPRO_DCACHE_DBUG3_PRO_CPU_DISABLED_CACHE_IA() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_DBUG3.Reg) & 0x7e00) >> 9
}
func (o *DPORT_Type) SetPRO_DCACHE_DBUG3_PRO_CPU_DISABLED_CACHE_IA_OPPOSITE(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_DBUG3.Reg, volatile.LoadUint32(&o.PRO_DCACHE_DBUG3.Reg)&^(0x200)|value<<9)
}
func (o *DPORT_Type) GetPRO_DCACHE_DBUG3_PRO_CPU_DISABLED_CACHE_IA_OPPOSITE() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_DBUG3.Reg) & 0x200) >> 9
}
func (o *DPORT_Type) SetPRO_DCACHE_DBUG3_PRO_CPU_DISABLED_CACHE_IA_DRAM1(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_DBUG3.Reg, volatile.LoadUint32(&o.PRO_DCACHE_DBUG3.Reg)&^(0x400)|value<<10)
}
func (o *DPORT_Type) GetPRO_DCACHE_DBUG3_PRO_CPU_DISABLED_CACHE_IA_DRAM1() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_DBUG3.Reg) & 0x400) >> 10
}
func (o *DPORT_Type) SetPRO_DCACHE_DBUG3_PRO_CPU_DISABLED_CACHE_IA_IROM0(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_DBUG3.Reg, volatile.LoadUint32(&o.PRO_DCACHE_DBUG3.Reg)&^(0x800)|value<<11)
}
func (o *DPORT_Type) GetPRO_DCACHE_DBUG3_PRO_CPU_DISABLED_CACHE_IA_IROM0() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_DBUG3.Reg) & 0x800) >> 11
}
func (o *DPORT_Type) SetPRO_DCACHE_DBUG3_PRO_CPU_DISABLED_CACHE_IA_IRAM1(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_DBUG3.Reg, volatile.LoadUint32(&o.PRO_DCACHE_DBUG3.Reg)&^(0x1000)|value<<12)
}
func (o *DPORT_Type) GetPRO_DCACHE_DBUG3_PRO_CPU_DISABLED_CACHE_IA_IRAM1() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_DBUG3.Reg) & 0x1000) >> 12
}
func (o *DPORT_Type) SetPRO_DCACHE_DBUG3_PRO_CPU_DISABLED_CACHE_IA_IRAM0(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_DBUG3.Reg, volatile.LoadUint32(&o.PRO_DCACHE_DBUG3.Reg)&^(0x2000)|value<<13)
}
func (o *DPORT_Type) GetPRO_DCACHE_DBUG3_PRO_CPU_DISABLED_CACHE_IA_IRAM0() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_DBUG3.Reg) & 0x2000) >> 13
}
func (o *DPORT_Type) SetPRO_DCACHE_DBUG3_PRO_CPU_DISABLED_CACHE_IA_DROM0(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_DBUG3.Reg, volatile.LoadUint32(&o.PRO_DCACHE_DBUG3.Reg)&^(0x4000)|value<<14)
}
func (o *DPORT_Type) GetPRO_DCACHE_DBUG3_PRO_CPU_DISABLED_CACHE_IA_DROM0() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_DBUG3.Reg) & 0x4000) >> 14
}
func (o *DPORT_Type) SetPRO_DCACHE_DBUG3_PRO_CACHE_IRAM0_PID_ERROR(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_DBUG3.Reg, volatile.LoadUint32(&o.PRO_DCACHE_DBUG3.Reg)&^(0x8000)|value<<15)
}
func (o *DPORT_Type) GetPRO_DCACHE_DBUG3_PRO_CACHE_IRAM0_PID_ERROR() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_DBUG3.Reg) & 0x8000) >> 15
}

// DPORT.PRO_DCACHE_DBUG4
func (o *DPORT_Type) SetPRO_DCACHE_DBUG4_PRO_DRAM1ADDR0_IA(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_DBUG4.Reg, volatile.LoadUint32(&o.PRO_DCACHE_DBUG4.Reg)&^(0xfffff)|value)
}
func (o *DPORT_Type) GetPRO_DCACHE_DBUG4_PRO_DRAM1ADDR0_IA() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_DBUG4.Reg) & 0xfffff
}

// DPORT.PRO_DCACHE_DBUG5
func (o *DPORT_Type) SetPRO_DCACHE_DBUG5_PRO_DROM0ADDR0_IA(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_DBUG5.Reg, volatile.LoadUint32(&o.PRO_DCACHE_DBUG5.Reg)&^(0xfffff)|value)
}
func (o *DPORT_Type) GetPRO_DCACHE_DBUG5_PRO_DROM0ADDR0_IA() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_DBUG5.Reg) & 0xfffff
}

// DPORT.PRO_DCACHE_DBUG6
func (o *DPORT_Type) SetPRO_DCACHE_DBUG6_PRO_IRAM0ADDR_IA(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_DBUG6.Reg, volatile.LoadUint32(&o.PRO_DCACHE_DBUG6.Reg)&^(0xfffff)|value)
}
func (o *DPORT_Type) GetPRO_DCACHE_DBUG6_PRO_IRAM0ADDR_IA() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_DBUG6.Reg) & 0xfffff
}

// DPORT.PRO_DCACHE_DBUG7
func (o *DPORT_Type) SetPRO_DCACHE_DBUG7_PRO_IRAM1ADDR_IA(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_DBUG7.Reg, volatile.LoadUint32(&o.PRO_DCACHE_DBUG7.Reg)&^(0xfffff)|value)
}
func (o *DPORT_Type) GetPRO_DCACHE_DBUG7_PRO_IRAM1ADDR_IA() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_DBUG7.Reg) & 0xfffff
}

// DPORT.PRO_DCACHE_DBUG8
func (o *DPORT_Type) SetPRO_DCACHE_DBUG8_PRO_IROM0ADDR_IA(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_DBUG8.Reg, volatile.LoadUint32(&o.PRO_DCACHE_DBUG8.Reg)&^(0xfffff)|value)
}
func (o *DPORT_Type) GetPRO_DCACHE_DBUG8_PRO_IROM0ADDR_IA() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_DBUG8.Reg) & 0xfffff
}

// DPORT.PRO_DCACHE_DBUG9
func (o *DPORT_Type) SetPRO_DCACHE_DBUG9_PRO_OPSDRAMADDR_IA(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_DBUG9.Reg, volatile.LoadUint32(&o.PRO_DCACHE_DBUG9.Reg)&^(0xfffff)|value)
}
func (o *DPORT_Type) GetPRO_DCACHE_DBUG9_PRO_OPSDRAMADDR_IA() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_DBUG9.Reg) & 0xfffff
}

// DPORT.APP_DCACHE_DBUG0
func (o *DPORT_Type) SetAPP_DCACHE_DBUG0_APP_SLAVE_WDATA(value uint32) {
	volatile.StoreUint32(&o.APP_DCACHE_DBUG0.Reg, volatile.LoadUint32(&o.APP_DCACHE_DBUG0.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetAPP_DCACHE_DBUG0_APP_SLAVE_WDATA() uint32 {
	return volatile.LoadUint32(&o.APP_DCACHE_DBUG0.Reg) & 0x1
}
func (o *DPORT_Type) SetAPP_DCACHE_DBUG0_APP_CACHE_MMU_IA(value uint32) {
	volatile.StoreUint32(&o.APP_DCACHE_DBUG0.Reg, volatile.LoadUint32(&o.APP_DCACHE_DBUG0.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetAPP_DCACHE_DBUG0_APP_CACHE_MMU_IA() uint32 {
	return volatile.LoadUint32(&o.APP_DCACHE_DBUG0.Reg) & 0x1
}
func (o *DPORT_Type) SetAPP_DCACHE_DBUG0_APP_CACHE_IA(value uint32) {
	volatile.StoreUint32(&o.APP_DCACHE_DBUG0.Reg, volatile.LoadUint32(&o.APP_DCACHE_DBUG0.Reg)&^(0x7e)|value<<1)
}
func (o *DPORT_Type) GetAPP_DCACHE_DBUG0_APP_CACHE_IA() uint32 {
	return (volatile.LoadUint32(&o.APP_DCACHE_DBUG0.Reg) & 0x7e) >> 1
}
func (o *DPORT_Type) SetAPP_DCACHE_DBUG0_APP_CACHE_STATE(value uint32) {
	volatile.StoreUint32(&o.APP_DCACHE_DBUG0.Reg, volatile.LoadUint32(&o.APP_DCACHE_DBUG0.Reg)&^(0x7ff80)|value<<7)
}
func (o *DPORT_Type) GetAPP_DCACHE_DBUG0_APP_CACHE_STATE() uint32 {
	return (volatile.LoadUint32(&o.APP_DCACHE_DBUG0.Reg) & 0x7ff80) >> 7
}
func (o *DPORT_Type) SetAPP_DCACHE_DBUG0_APP_WR_BAK_TO_READ(value uint32) {
	volatile.StoreUint32(&o.APP_DCACHE_DBUG0.Reg, volatile.LoadUint32(&o.APP_DCACHE_DBUG0.Reg)&^(0x80000)|value<<19)
}
func (o *DPORT_Type) GetAPP_DCACHE_DBUG0_APP_WR_BAK_TO_READ() uint32 {
	return (volatile.LoadUint32(&o.APP_DCACHE_DBUG0.Reg) & 0x80000) >> 19
}
func (o *DPORT_Type) SetAPP_DCACHE_DBUG0_APP_TX_END(value uint32) {
	volatile.StoreUint32(&o.APP_DCACHE_DBUG0.Reg, volatile.LoadUint32(&o.APP_DCACHE_DBUG0.Reg)&^(0x100000)|value<<20)
}
func (o *DPORT_Type) GetAPP_DCACHE_DBUG0_APP_TX_END() uint32 {
	return (volatile.LoadUint32(&o.APP_DCACHE_DBUG0.Reg) & 0x100000) >> 20
}
func (o *DPORT_Type) SetAPP_DCACHE_DBUG0_APP_SLAVE_WR(value uint32) {
	volatile.StoreUint32(&o.APP_DCACHE_DBUG0.Reg, volatile.LoadUint32(&o.APP_DCACHE_DBUG0.Reg)&^(0x200000)|value<<21)
}
func (o *DPORT_Type) GetAPP_DCACHE_DBUG0_APP_SLAVE_WR() uint32 {
	return (volatile.LoadUint32(&o.APP_DCACHE_DBUG0.Reg) & 0x200000) >> 21
}
func (o *DPORT_Type) SetAPP_DCACHE_DBUG0_APP_SLAVE_WDATA_V(value uint32) {
	volatile.StoreUint32(&o.APP_DCACHE_DBUG0.Reg, volatile.LoadUint32(&o.APP_DCACHE_DBUG0.Reg)&^(0x400000)|value<<22)
}
func (o *DPORT_Type) GetAPP_DCACHE_DBUG0_APP_SLAVE_WDATA_V() uint32 {
	return (volatile.LoadUint32(&o.APP_DCACHE_DBUG0.Reg) & 0x400000) >> 22
}
func (o *DPORT_Type) SetAPP_DCACHE_DBUG0_APP_RX_END(value uint32) {
	volatile.StoreUint32(&o.APP_DCACHE_DBUG0.Reg, volatile.LoadUint32(&o.APP_DCACHE_DBUG0.Reg)&^(0x800000)|value<<23)
}
func (o *DPORT_Type) GetAPP_DCACHE_DBUG0_APP_RX_END() uint32 {
	return (volatile.LoadUint32(&o.APP_DCACHE_DBUG0.Reg) & 0x800000) >> 23
}

// DPORT.APP_DCACHE_DBUG1
func (o *DPORT_Type) SetAPP_DCACHE_DBUG1(value uint32) {
	volatile.StoreUint32(&o.APP_DCACHE_DBUG1.Reg, value)
}
func (o *DPORT_Type) GetAPP_DCACHE_DBUG1() uint32 {
	return volatile.LoadUint32(&o.APP_DCACHE_DBUG1.Reg)
}

// DPORT.APP_DCACHE_DBUG2
func (o *DPORT_Type) SetAPP_DCACHE_DBUG2_APP_CACHE_VADDR(value uint32) {
	volatile.StoreUint32(&o.APP_DCACHE_DBUG2.Reg, volatile.LoadUint32(&o.APP_DCACHE_DBUG2.Reg)&^(0x7ffffff)|value)
}
func (o *DPORT_Type) GetAPP_DCACHE_DBUG2_APP_CACHE_VADDR() uint32 {
	return volatile.LoadUint32(&o.APP_DCACHE_DBUG2.Reg) & 0x7ffffff
}

// DPORT.APP_DCACHE_DBUG3
func (o *DPORT_Type) SetAPP_DCACHE_DBUG3_APP_MMU_RDATA(value uint32) {
	volatile.StoreUint32(&o.APP_DCACHE_DBUG3.Reg, volatile.LoadUint32(&o.APP_DCACHE_DBUG3.Reg)&^(0x1ff)|value)
}
func (o *DPORT_Type) GetAPP_DCACHE_DBUG3_APP_MMU_RDATA() uint32 {
	return volatile.LoadUint32(&o.APP_DCACHE_DBUG3.Reg) & 0x1ff
}
func (o *DPORT_Type) SetAPP_DCACHE_DBUG3_APP_CPU_DISABLED_CACHE_IA(value uint32) {
	volatile.StoreUint32(&o.APP_DCACHE_DBUG3.Reg, volatile.LoadUint32(&o.APP_DCACHE_DBUG3.Reg)&^(0x7e00)|value<<9)
}
func (o *DPORT_Type) GetAPP_DCACHE_DBUG3_APP_CPU_DISABLED_CACHE_IA() uint32 {
	return (volatile.LoadUint32(&o.APP_DCACHE_DBUG3.Reg) & 0x7e00) >> 9
}
func (o *DPORT_Type) SetAPP_DCACHE_DBUG3_APP_CPU_DISABLED_CACHE_IA_OPPOSITE(value uint32) {
	volatile.StoreUint32(&o.APP_DCACHE_DBUG3.Reg, volatile.LoadUint32(&o.APP_DCACHE_DBUG3.Reg)&^(0x200)|value<<9)
}
func (o *DPORT_Type) GetAPP_DCACHE_DBUG3_APP_CPU_DISABLED_CACHE_IA_OPPOSITE() uint32 {
	return (volatile.LoadUint32(&o.APP_DCACHE_DBUG3.Reg) & 0x200) >> 9
}
func (o *DPORT_Type) SetAPP_DCACHE_DBUG3_APP_CPU_DISABLED_CACHE_IA_DRAM1(value uint32) {
	volatile.StoreUint32(&o.APP_DCACHE_DBUG3.Reg, volatile.LoadUint32(&o.APP_DCACHE_DBUG3.Reg)&^(0x400)|value<<10)
}
func (o *DPORT_Type) GetAPP_DCACHE_DBUG3_APP_CPU_DISABLED_CACHE_IA_DRAM1() uint32 {
	return (volatile.LoadUint32(&o.APP_DCACHE_DBUG3.Reg) & 0x400) >> 10
}
func (o *DPORT_Type) SetAPP_DCACHE_DBUG3_APP_CPU_DISABLED_CACHE_IA_IROM0(value uint32) {
	volatile.StoreUint32(&o.APP_DCACHE_DBUG3.Reg, volatile.LoadUint32(&o.APP_DCACHE_DBUG3.Reg)&^(0x800)|value<<11)
}
func (o *DPORT_Type) GetAPP_DCACHE_DBUG3_APP_CPU_DISABLED_CACHE_IA_IROM0() uint32 {
	return (volatile.LoadUint32(&o.APP_DCACHE_DBUG3.Reg) & 0x800) >> 11
}
func (o *DPORT_Type) SetAPP_DCACHE_DBUG3_APP_CPU_DISABLED_CACHE_IA_IRAM1(value uint32) {
	volatile.StoreUint32(&o.APP_DCACHE_DBUG3.Reg, volatile.LoadUint32(&o.APP_DCACHE_DBUG3.Reg)&^(0x1000)|value<<12)
}
func (o *DPORT_Type) GetAPP_DCACHE_DBUG3_APP_CPU_DISABLED_CACHE_IA_IRAM1() uint32 {
	return (volatile.LoadUint32(&o.APP_DCACHE_DBUG3.Reg) & 0x1000) >> 12
}
func (o *DPORT_Type) SetAPP_DCACHE_DBUG3_APP_CPU_DISABLED_CACHE_IA_IRAM0(value uint32) {
	volatile.StoreUint32(&o.APP_DCACHE_DBUG3.Reg, volatile.LoadUint32(&o.APP_DCACHE_DBUG3.Reg)&^(0x2000)|value<<13)
}
func (o *DPORT_Type) GetAPP_DCACHE_DBUG3_APP_CPU_DISABLED_CACHE_IA_IRAM0() uint32 {
	return (volatile.LoadUint32(&o.APP_DCACHE_DBUG3.Reg) & 0x2000) >> 13
}
func (o *DPORT_Type) SetAPP_DCACHE_DBUG3_APP_CPU_DISABLED_CACHE_IA_DROM0(value uint32) {
	volatile.StoreUint32(&o.APP_DCACHE_DBUG3.Reg, volatile.LoadUint32(&o.APP_DCACHE_DBUG3.Reg)&^(0x4000)|value<<14)
}
func (o *DPORT_Type) GetAPP_DCACHE_DBUG3_APP_CPU_DISABLED_CACHE_IA_DROM0() uint32 {
	return (volatile.LoadUint32(&o.APP_DCACHE_DBUG3.Reg) & 0x4000) >> 14
}
func (o *DPORT_Type) SetAPP_DCACHE_DBUG3_APP_CACHE_IRAM0_PID_ERROR(value uint32) {
	volatile.StoreUint32(&o.APP_DCACHE_DBUG3.Reg, volatile.LoadUint32(&o.APP_DCACHE_DBUG3.Reg)&^(0x8000)|value<<15)
}
func (o *DPORT_Type) GetAPP_DCACHE_DBUG3_APP_CACHE_IRAM0_PID_ERROR() uint32 {
	return (volatile.LoadUint32(&o.APP_DCACHE_DBUG3.Reg) & 0x8000) >> 15
}

// DPORT.APP_DCACHE_DBUG4
func (o *DPORT_Type) SetAPP_DCACHE_DBUG4_APP_DRAM1ADDR0_IA(value uint32) {
	volatile.StoreUint32(&o.APP_DCACHE_DBUG4.Reg, volatile.LoadUint32(&o.APP_DCACHE_DBUG4.Reg)&^(0xfffff)|value)
}
func (o *DPORT_Type) GetAPP_DCACHE_DBUG4_APP_DRAM1ADDR0_IA() uint32 {
	return volatile.LoadUint32(&o.APP_DCACHE_DBUG4.Reg) & 0xfffff
}

// DPORT.APP_DCACHE_DBUG5
func (o *DPORT_Type) SetAPP_DCACHE_DBUG5_APP_DROM0ADDR0_IA(value uint32) {
	volatile.StoreUint32(&o.APP_DCACHE_DBUG5.Reg, volatile.LoadUint32(&o.APP_DCACHE_DBUG5.Reg)&^(0xfffff)|value)
}
func (o *DPORT_Type) GetAPP_DCACHE_DBUG5_APP_DROM0ADDR0_IA() uint32 {
	return volatile.LoadUint32(&o.APP_DCACHE_DBUG5.Reg) & 0xfffff
}

// DPORT.APP_DCACHE_DBUG6
func (o *DPORT_Type) SetAPP_DCACHE_DBUG6_APP_IRAM0ADDR_IA(value uint32) {
	volatile.StoreUint32(&o.APP_DCACHE_DBUG6.Reg, volatile.LoadUint32(&o.APP_DCACHE_DBUG6.Reg)&^(0xfffff)|value)
}
func (o *DPORT_Type) GetAPP_DCACHE_DBUG6_APP_IRAM0ADDR_IA() uint32 {
	return volatile.LoadUint32(&o.APP_DCACHE_DBUG6.Reg) & 0xfffff
}

// DPORT.APP_DCACHE_DBUG7
func (o *DPORT_Type) SetAPP_DCACHE_DBUG7_APP_IRAM1ADDR_IA(value uint32) {
	volatile.StoreUint32(&o.APP_DCACHE_DBUG7.Reg, volatile.LoadUint32(&o.APP_DCACHE_DBUG7.Reg)&^(0xfffff)|value)
}
func (o *DPORT_Type) GetAPP_DCACHE_DBUG7_APP_IRAM1ADDR_IA() uint32 {
	return volatile.LoadUint32(&o.APP_DCACHE_DBUG7.Reg) & 0xfffff
}

// DPORT.APP_DCACHE_DBUG8
func (o *DPORT_Type) SetAPP_DCACHE_DBUG8_APP_IROM0ADDR_IA(value uint32) {
	volatile.StoreUint32(&o.APP_DCACHE_DBUG8.Reg, volatile.LoadUint32(&o.APP_DCACHE_DBUG8.Reg)&^(0xfffff)|value)
}
func (o *DPORT_Type) GetAPP_DCACHE_DBUG8_APP_IROM0ADDR_IA() uint32 {
	return volatile.LoadUint32(&o.APP_DCACHE_DBUG8.Reg) & 0xfffff
}

// DPORT.APP_DCACHE_DBUG9
func (o *DPORT_Type) SetAPP_DCACHE_DBUG9_APP_OPSDRAMADDR_IA(value uint32) {
	volatile.StoreUint32(&o.APP_DCACHE_DBUG9.Reg, volatile.LoadUint32(&o.APP_DCACHE_DBUG9.Reg)&^(0xfffff)|value)
}
func (o *DPORT_Type) GetAPP_DCACHE_DBUG9_APP_OPSDRAMADDR_IA() uint32 {
	return volatile.LoadUint32(&o.APP_DCACHE_DBUG9.Reg) & 0xfffff
}

// DPORT.PRO_CPU_RECORD_CTRL
func (o *DPORT_Type) SetPRO_CPU_RECORD_CTRL_PRO_CPU_RECORD_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_CTRL.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_CTRL.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_CTRL_PRO_CPU_RECORD_ENABLE() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_RECORD_CTRL.Reg) & 0x1
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_CTRL_PRO_CPU_RECORD_DISABLE(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_CTRL.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_CTRL_PRO_CPU_RECORD_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_CTRL.Reg) & 0x10) >> 4
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_CTRL_PRO_CPU_PDEBUG_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_CTRL.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_CTRL_PRO_CPU_PDEBUG_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_CTRL.Reg) & 0x100) >> 8
}

// DPORT.PRO_CPU_RECORD_STATUS
func (o *DPORT_Type) SetPRO_CPU_RECORD_STATUS_PRO_CPU_RECORDING(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_STATUS.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_STATUS.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_STATUS_PRO_CPU_RECORDING() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_RECORD_STATUS.Reg) & 0x1
}

// DPORT.PRO_CPU_RECORD_PID
func (o *DPORT_Type) SetPRO_CPU_RECORD_PID_RECORD_PRO_PID(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PID.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PID.Reg)&^(0x7)|value)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PID_RECORD_PRO_PID() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_RECORD_PID.Reg) & 0x7
}

// DPORT.PRO_CPU_RECORD_PDEBUGINST
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGINST(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGINST.Reg, value)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGINST() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGINST.Reg)
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGINST_RECORD_PDEBUGINST_SZ(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGINST.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGINST.Reg)&^(0xff)|value)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGINST_RECORD_PDEBUGINST_SZ() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGINST.Reg) & 0xff
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGINST_RECORD_PDEBUGINST_ISRC(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGINST.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGINST.Reg)&^(0x7000)|value<<12)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGINST_RECORD_PDEBUGINST_ISRC() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGINST.Reg) & 0x7000) >> 12
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGINST_RECORD_PDEBUGINST_LOOP_REP(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGINST.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGINST.Reg)&^(0x100000)|value<<20)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGINST_RECORD_PDEBUGINST_LOOP_REP() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGINST.Reg) & 0x100000) >> 20
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGINST_RECORD_PDEBUGINST_LOOP(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGINST.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGINST.Reg)&^(0x200000)|value<<21)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGINST_RECORD_PDEBUGINST_LOOP() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGINST.Reg) & 0x200000) >> 21
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGINST_RECORD_PDEBUGINST_CINTL(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGINST.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGINST.Reg)&^(0xf000000)|value<<24)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGINST_RECORD_PDEBUGINST_CINTL() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGINST.Reg) & 0xf000000) >> 24
}

// DPORT.PRO_CPU_RECORD_PDEBUGSTATUS
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGSTATUS_RECORD_PRO_PDEBUGSTATUS(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGSTATUS.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGSTATUS.Reg)&^(0xff)|value)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGSTATUS_RECORD_PRO_PDEBUGSTATUS() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGSTATUS.Reg) & 0xff
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGSTATUS_RECORD_PDEBUGSTATUS_BBCAUSE(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGSTATUS.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGSTATUS.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGSTATUS_RECORD_PDEBUGSTATUS_BBCAUSE() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGSTATUS.Reg) & 0x3f
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGSTATUS_RECORD_PDEBUGSTATUS_INSNTYPE(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGSTATUS.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGSTATUS.Reg)&^(0x3f)|value)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGSTATUS_RECORD_PDEBUGSTATUS_INSNTYPE() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGSTATUS.Reg) & 0x3f
}

// DPORT.PRO_CPU_RECORD_PDEBUGDATA
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, value)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_DEP_OTHER(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_DEP_OTHER() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x1
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_EXCVEC(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x1f)|value)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_EXCVEC() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x1f
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_INSNTYPE_SR(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0xff)|value)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_INSNTYPE_SR() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0xff
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_INSNTYPE_RER(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_INSNTYPE_RER() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x1
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_BUFF(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x2)|value<<1)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_BUFF() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x2) >> 1
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_INSNTYPE_WER(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x2)|value<<1)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_INSNTYPE_WER() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x2) >> 1
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_BUFFCONFL(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x4)|value<<2)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_BUFFCONFL() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x4) >> 2
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_INSNTYPE_ER(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x3ffc)|value<<2)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_INSNTYPE_ER() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x3ffc) >> 2
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_DCM(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x8)|value<<3)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_DCM() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x8) >> 3
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_LSU(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x10)|value<<4)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_LSU() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x10) >> 4
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_ICM(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x40)|value<<6)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_ICM() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x40) >> 6
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_IRAMBUSY(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x80)|value<<7)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_IRAMBUSY() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x80) >> 7
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_DEP_LSU(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x100)|value<<8)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_DEP_LSU() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x100) >> 8
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_IPIF(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x100)|value<<8)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_IPIF() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x100) >> 8
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_INSNTYPE_RSR(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x100)|value<<8)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_INSNTYPE_RSR() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x100) >> 8
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_TIE(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x200)|value<<9)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_TIE() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x200) >> 9
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_INSNTYPE_WSR(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x200)|value<<9)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_INSNTYPE_WSR() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x200) >> 9
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_RUN(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x400)|value<<10)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_RUN() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x400) >> 10
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_INSNTYPE_XSR(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x400)|value<<10)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_INSNTYPE_XSR() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x400) >> 10
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_DEP_STR(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x800)|value<<11)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_DEP_STR() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x800) >> 11
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_DEP(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x1000)|value<<12)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_DEP() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x1000) >> 12
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_BPIFETCH(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x1000)|value<<12)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_BPIFETCH() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x1000) >> 12
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_L32R(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x2000)|value<<13)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_L32R() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x2000) >> 13
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_LSPROC(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x4000)|value<<14)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_LSPROC() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x4000) >> 14
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_BPLOAD(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x8000)|value<<15)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_BPLOAD() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x8000) >> 15
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_DEP_MEMW(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x10000)|value<<16)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_DEP_MEMW() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x10000) >> 16
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_EXCCAUSE(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x3f0000)|value<<16)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_EXCCAUSE() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x3f0000) >> 16
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_BANKCONFL(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x10000)|value<<16)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_BANKCONFL() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x10000) >> 16
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_DEP_HALT(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x20000)|value<<17)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_DEP_HALT() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x20000) >> 17
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_ITERMUL(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x40000)|value<<18)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_ITERMUL() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x40000) >> 18
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_ITERDIV(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg)&^(0x80000)|value<<19)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGDATA_RECORD_PDEBUGDATA_STALL_ITERDIV() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGDATA.Reg) & 0x80000) >> 19
}

// DPORT.PRO_CPU_RECORD_PDEBUGPC
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGPC(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGPC.Reg, value)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGPC() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGPC.Reg)
}

// DPORT.PRO_CPU_RECORD_PDEBUGLS0STAT
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGLS0STAT(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg, value)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGLS0STAT() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg)
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGLS0STAT_RECORD_PDEBUGLS0STAT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg)&^(0xf)|value)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGLS0STAT_RECORD_PDEBUGLS0STAT_TYPE() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg) & 0xf
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGLS0STAT_RECORD_PDEBUGLS0STAT_SZ(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg)&^(0xf0)|value<<4)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGLS0STAT_RECORD_PDEBUGLS0STAT_SZ() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg) & 0xf0) >> 4
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGLS0STAT_RECORD_PDEBUGLS0STAT_DTLBM(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg)&^(0x100)|value<<8)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGLS0STAT_RECORD_PDEBUGLS0STAT_DTLBM() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg) & 0x100) >> 8
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGLS0STAT_RECORD_PDEBUGLS0STAT_DCM(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg)&^(0x200)|value<<9)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGLS0STAT_RECORD_PDEBUGLS0STAT_DCM() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg) & 0x200) >> 9
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGLS0STAT_RECORD_PDEBUGLS0STAT_DCH(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg)&^(0x400)|value<<10)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGLS0STAT_RECORD_PDEBUGLS0STAT_DCH() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg) & 0x400) >> 10
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGLS0STAT_RECORD_PDEBUGLS0STAT_UC(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg)&^(0x1000)|value<<12)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGLS0STAT_RECORD_PDEBUGLS0STAT_UC() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg) & 0x1000) >> 12
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGLS0STAT_RECORD_PDEBUGLS0STAT_WB(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg)&^(0x2000)|value<<13)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGLS0STAT_RECORD_PDEBUGLS0STAT_WB() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg) & 0x2000) >> 13
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGLS0STAT_RECORD_PDEBUGLS0STAT_COH(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg)&^(0x10000)|value<<16)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGLS0STAT_RECORD_PDEBUGLS0STAT_COH() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg) & 0x10000) >> 16
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGLS0STAT_RECORD_PDEBUGLS0STAT_STCOH(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg)&^(0x60000)|value<<17)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGLS0STAT_RECORD_PDEBUGLS0STAT_STCOH() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg) & 0x60000) >> 17
}
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGLS0STAT_RECORD_PDEBUGLS0STAT_TGT(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg, volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg)&^(0xf00000)|value<<20)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGLS0STAT_RECORD_PDEBUGLS0STAT_TGT() uint32 {
	return (volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGLS0STAT.Reg) & 0xf00000) >> 20
}

// DPORT.PRO_CPU_RECORD_PDEBUGLS0ADDR
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGLS0ADDR(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGLS0ADDR.Reg, value)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGLS0ADDR() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGLS0ADDR.Reg)
}

// DPORT.PRO_CPU_RECORD_PDEBUGLS0DATA
func (o *DPORT_Type) SetPRO_CPU_RECORD_PDEBUGLS0DATA(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_RECORD_PDEBUGLS0DATA.Reg, value)
}
func (o *DPORT_Type) GetPRO_CPU_RECORD_PDEBUGLS0DATA() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_RECORD_PDEBUGLS0DATA.Reg)
}

// DPORT.APP_CPU_RECORD_CTRL
func (o *DPORT_Type) SetAPP_CPU_RECORD_CTRL_APP_CPU_RECORD_ENABLE(value uint32) {
	volatile.StoreUint32(&o.APP_CPU_RECORD_CTRL.Reg, volatile.LoadUint32(&o.APP_CPU_RECORD_CTRL.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetAPP_CPU_RECORD_CTRL_APP_CPU_RECORD_ENABLE() uint32 {
	return volatile.LoadUint32(&o.APP_CPU_RECORD_CTRL.Reg) & 0x1
}
func (o *DPORT_Type) SetAPP_CPU_RECORD_CTRL_APP_CPU_RECORD_DISABLE(value uint32) {
	volatile.StoreUint32(&o.APP_CPU_RECORD_CTRL.Reg, volatile.LoadUint32(&o.APP_CPU_RECORD_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *DPORT_Type) GetAPP_CPU_RECORD_CTRL_APP_CPU_RECORD_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.APP_CPU_RECORD_CTRL.Reg) & 0x10) >> 4
}
func (o *DPORT_Type) SetAPP_CPU_RECORD_CTRL_APP_CPU_PDEBUG_ENABLE(value uint32) {
	volatile.StoreUint32(&o.APP_CPU_RECORD_CTRL.Reg, volatile.LoadUint32(&o.APP_CPU_RECORD_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *DPORT_Type) GetAPP_CPU_RECORD_CTRL_APP_CPU_PDEBUG_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.APP_CPU_RECORD_CTRL.Reg) & 0x100) >> 8
}

// DPORT.APP_CPU_RECORD_STATUS
func (o *DPORT_Type) SetAPP_CPU_RECORD_STATUS_APP_CPU_RECORDING(value uint32) {
	volatile.StoreUint32(&o.APP_CPU_RECORD_STATUS.Reg, volatile.LoadUint32(&o.APP_CPU_RECORD_STATUS.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetAPP_CPU_RECORD_STATUS_APP_CPU_RECORDING() uint32 {
	return volatile.LoadUint32(&o.APP_CPU_RECORD_STATUS.Reg) & 0x1
}

// DPORT.APP_CPU_RECORD_PID
func (o *DPORT_Type) SetAPP_CPU_RECORD_PID_RECORD_APP_PID(value uint32) {
	volatile.StoreUint32(&o.APP_CPU_RECORD_PID.Reg, volatile.LoadUint32(&o.APP_CPU_RECORD_PID.Reg)&^(0x7)|value)
}
func (o *DPORT_Type) GetAPP_CPU_RECORD_PID_RECORD_APP_PID() uint32 {
	return volatile.LoadUint32(&o.APP_CPU_RECORD_PID.Reg) & 0x7
}

// DPORT.APP_CPU_RECORD_PDEBUGINST
func (o *DPORT_Type) SetAPP_CPU_RECORD_PDEBUGINST(value uint32) {
	volatile.StoreUint32(&o.APP_CPU_RECORD_PDEBUGINST.Reg, value)
}
func (o *DPORT_Type) GetAPP_CPU_RECORD_PDEBUGINST() uint32 {
	return volatile.LoadUint32(&o.APP_CPU_RECORD_PDEBUGINST.Reg)
}

// DPORT.APP_CPU_RECORD_PDEBUGSTATUS
func (o *DPORT_Type) SetAPP_CPU_RECORD_PDEBUGSTATUS_RECORD_APP_PDEBUGSTATUS(value uint32) {
	volatile.StoreUint32(&o.APP_CPU_RECORD_PDEBUGSTATUS.Reg, volatile.LoadUint32(&o.APP_CPU_RECORD_PDEBUGSTATUS.Reg)&^(0xff)|value)
}
func (o *DPORT_Type) GetAPP_CPU_RECORD_PDEBUGSTATUS_RECORD_APP_PDEBUGSTATUS() uint32 {
	return volatile.LoadUint32(&o.APP_CPU_RECORD_PDEBUGSTATUS.Reg) & 0xff
}

// DPORT.APP_CPU_RECORD_PDEBUGDATA
func (o *DPORT_Type) SetAPP_CPU_RECORD_PDEBUGDATA(value uint32) {
	volatile.StoreUint32(&o.APP_CPU_RECORD_PDEBUGDATA.Reg, value)
}
func (o *DPORT_Type) GetAPP_CPU_RECORD_PDEBUGDATA() uint32 {
	return volatile.LoadUint32(&o.APP_CPU_RECORD_PDEBUGDATA.Reg)
}

// DPORT.APP_CPU_RECORD_PDEBUGPC
func (o *DPORT_Type) SetAPP_CPU_RECORD_PDEBUGPC(value uint32) {
	volatile.StoreUint32(&o.APP_CPU_RECORD_PDEBUGPC.Reg, value)
}
func (o *DPORT_Type) GetAPP_CPU_RECORD_PDEBUGPC() uint32 {
	return volatile.LoadUint32(&o.APP_CPU_RECORD_PDEBUGPC.Reg)
}

// DPORT.APP_CPU_RECORD_PDEBUGLS0STAT
func (o *DPORT_Type) SetAPP_CPU_RECORD_PDEBUGLS0STAT(value uint32) {
	volatile.StoreUint32(&o.APP_CPU_RECORD_PDEBUGLS0STAT.Reg, value)
}
func (o *DPORT_Type) GetAPP_CPU_RECORD_PDEBUGLS0STAT() uint32 {
	return volatile.LoadUint32(&o.APP_CPU_RECORD_PDEBUGLS0STAT.Reg)
}

// DPORT.APP_CPU_RECORD_PDEBUGLS0ADDR
func (o *DPORT_Type) SetAPP_CPU_RECORD_PDEBUGLS0ADDR(value uint32) {
	volatile.StoreUint32(&o.APP_CPU_RECORD_PDEBUGLS0ADDR.Reg, value)
}
func (o *DPORT_Type) GetAPP_CPU_RECORD_PDEBUGLS0ADDR() uint32 {
	return volatile.LoadUint32(&o.APP_CPU_RECORD_PDEBUGLS0ADDR.Reg)
}

// DPORT.APP_CPU_RECORD_PDEBUGLS0DATA
func (o *DPORT_Type) SetAPP_CPU_RECORD_PDEBUGLS0DATA(value uint32) {
	volatile.StoreUint32(&o.APP_CPU_RECORD_PDEBUGLS0DATA.Reg, value)
}
func (o *DPORT_Type) GetAPP_CPU_RECORD_PDEBUGLS0DATA() uint32 {
	return volatile.LoadUint32(&o.APP_CPU_RECORD_PDEBUGLS0DATA.Reg)
}

// DPORT.RSA_PD_CTRL
func (o *DPORT_Type) SetRSA_PD_CTRL_RSA_PD(value uint32) {
	volatile.StoreUint32(&o.RSA_PD_CTRL.Reg, volatile.LoadUint32(&o.RSA_PD_CTRL.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetRSA_PD_CTRL_RSA_PD() uint32 {
	return volatile.LoadUint32(&o.RSA_PD_CTRL.Reg) & 0x1
}

// DPORT.ROM_MPU_TABLE0
func (o *DPORT_Type) SetROM_MPU_TABLE0(value uint32) {
	volatile.StoreUint32(&o.ROM_MPU_TABLE0.Reg, volatile.LoadUint32(&o.ROM_MPU_TABLE0.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetROM_MPU_TABLE0() uint32 {
	return volatile.LoadUint32(&o.ROM_MPU_TABLE0.Reg) & 0x3
}

// DPORT.ROM_MPU_TABLE1
func (o *DPORT_Type) SetROM_MPU_TABLE1(value uint32) {
	volatile.StoreUint32(&o.ROM_MPU_TABLE1.Reg, volatile.LoadUint32(&o.ROM_MPU_TABLE1.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetROM_MPU_TABLE1() uint32 {
	return volatile.LoadUint32(&o.ROM_MPU_TABLE1.Reg) & 0x3
}

// DPORT.ROM_MPU_TABLE2
func (o *DPORT_Type) SetROM_MPU_TABLE2(value uint32) {
	volatile.StoreUint32(&o.ROM_MPU_TABLE2.Reg, volatile.LoadUint32(&o.ROM_MPU_TABLE2.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetROM_MPU_TABLE2() uint32 {
	return volatile.LoadUint32(&o.ROM_MPU_TABLE2.Reg) & 0x3
}

// DPORT.ROM_MPU_TABLE3
func (o *DPORT_Type) SetROM_MPU_TABLE3(value uint32) {
	volatile.StoreUint32(&o.ROM_MPU_TABLE3.Reg, volatile.LoadUint32(&o.ROM_MPU_TABLE3.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetROM_MPU_TABLE3() uint32 {
	return volatile.LoadUint32(&o.ROM_MPU_TABLE3.Reg) & 0x3
}

// DPORT.SHROM_MPU_TABLE0
func (o *DPORT_Type) SetSHROM_MPU_TABLE0(value uint32) {
	volatile.StoreUint32(&o.SHROM_MPU_TABLE0.Reg, volatile.LoadUint32(&o.SHROM_MPU_TABLE0.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetSHROM_MPU_TABLE0() uint32 {
	return volatile.LoadUint32(&o.SHROM_MPU_TABLE0.Reg) & 0x3
}

// DPORT.SHROM_MPU_TABLE1
func (o *DPORT_Type) SetSHROM_MPU_TABLE1(value uint32) {
	volatile.StoreUint32(&o.SHROM_MPU_TABLE1.Reg, volatile.LoadUint32(&o.SHROM_MPU_TABLE1.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetSHROM_MPU_TABLE1() uint32 {
	return volatile.LoadUint32(&o.SHROM_MPU_TABLE1.Reg) & 0x3
}

// DPORT.SHROM_MPU_TABLE2
func (o *DPORT_Type) SetSHROM_MPU_TABLE2(value uint32) {
	volatile.StoreUint32(&o.SHROM_MPU_TABLE2.Reg, volatile.LoadUint32(&o.SHROM_MPU_TABLE2.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetSHROM_MPU_TABLE2() uint32 {
	return volatile.LoadUint32(&o.SHROM_MPU_TABLE2.Reg) & 0x3
}

// DPORT.SHROM_MPU_TABLE3
func (o *DPORT_Type) SetSHROM_MPU_TABLE3(value uint32) {
	volatile.StoreUint32(&o.SHROM_MPU_TABLE3.Reg, volatile.LoadUint32(&o.SHROM_MPU_TABLE3.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetSHROM_MPU_TABLE3() uint32 {
	return volatile.LoadUint32(&o.SHROM_MPU_TABLE3.Reg) & 0x3
}

// DPORT.SHROM_MPU_TABLE4
func (o *DPORT_Type) SetSHROM_MPU_TABLE4(value uint32) {
	volatile.StoreUint32(&o.SHROM_MPU_TABLE4.Reg, volatile.LoadUint32(&o.SHROM_MPU_TABLE4.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetSHROM_MPU_TABLE4() uint32 {
	return volatile.LoadUint32(&o.SHROM_MPU_TABLE4.Reg) & 0x3
}

// DPORT.SHROM_MPU_TABLE5
func (o *DPORT_Type) SetSHROM_MPU_TABLE5(value uint32) {
	volatile.StoreUint32(&o.SHROM_MPU_TABLE5.Reg, volatile.LoadUint32(&o.SHROM_MPU_TABLE5.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetSHROM_MPU_TABLE5() uint32 {
	return volatile.LoadUint32(&o.SHROM_MPU_TABLE5.Reg) & 0x3
}

// DPORT.SHROM_MPU_TABLE6
func (o *DPORT_Type) SetSHROM_MPU_TABLE6(value uint32) {
	volatile.StoreUint32(&o.SHROM_MPU_TABLE6.Reg, volatile.LoadUint32(&o.SHROM_MPU_TABLE6.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetSHROM_MPU_TABLE6() uint32 {
	return volatile.LoadUint32(&o.SHROM_MPU_TABLE6.Reg) & 0x3
}

// DPORT.SHROM_MPU_TABLE7
func (o *DPORT_Type) SetSHROM_MPU_TABLE7(value uint32) {
	volatile.StoreUint32(&o.SHROM_MPU_TABLE7.Reg, volatile.LoadUint32(&o.SHROM_MPU_TABLE7.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetSHROM_MPU_TABLE7() uint32 {
	return volatile.LoadUint32(&o.SHROM_MPU_TABLE7.Reg) & 0x3
}

// DPORT.SHROM_MPU_TABLE8
func (o *DPORT_Type) SetSHROM_MPU_TABLE8(value uint32) {
	volatile.StoreUint32(&o.SHROM_MPU_TABLE8.Reg, volatile.LoadUint32(&o.SHROM_MPU_TABLE8.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetSHROM_MPU_TABLE8() uint32 {
	return volatile.LoadUint32(&o.SHROM_MPU_TABLE8.Reg) & 0x3
}

// DPORT.SHROM_MPU_TABLE9
func (o *DPORT_Type) SetSHROM_MPU_TABLE9(value uint32) {
	volatile.StoreUint32(&o.SHROM_MPU_TABLE9.Reg, volatile.LoadUint32(&o.SHROM_MPU_TABLE9.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetSHROM_MPU_TABLE9() uint32 {
	return volatile.LoadUint32(&o.SHROM_MPU_TABLE9.Reg) & 0x3
}

// DPORT.SHROM_MPU_TABLE10
func (o *DPORT_Type) SetSHROM_MPU_TABLE10(value uint32) {
	volatile.StoreUint32(&o.SHROM_MPU_TABLE10.Reg, volatile.LoadUint32(&o.SHROM_MPU_TABLE10.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetSHROM_MPU_TABLE10() uint32 {
	return volatile.LoadUint32(&o.SHROM_MPU_TABLE10.Reg) & 0x3
}

// DPORT.SHROM_MPU_TABLE11
func (o *DPORT_Type) SetSHROM_MPU_TABLE11(value uint32) {
	volatile.StoreUint32(&o.SHROM_MPU_TABLE11.Reg, volatile.LoadUint32(&o.SHROM_MPU_TABLE11.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetSHROM_MPU_TABLE11() uint32 {
	return volatile.LoadUint32(&o.SHROM_MPU_TABLE11.Reg) & 0x3
}

// DPORT.SHROM_MPU_TABLE12
func (o *DPORT_Type) SetSHROM_MPU_TABLE12(value uint32) {
	volatile.StoreUint32(&o.SHROM_MPU_TABLE12.Reg, volatile.LoadUint32(&o.SHROM_MPU_TABLE12.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetSHROM_MPU_TABLE12() uint32 {
	return volatile.LoadUint32(&o.SHROM_MPU_TABLE12.Reg) & 0x3
}

// DPORT.SHROM_MPU_TABLE13
func (o *DPORT_Type) SetSHROM_MPU_TABLE13(value uint32) {
	volatile.StoreUint32(&o.SHROM_MPU_TABLE13.Reg, volatile.LoadUint32(&o.SHROM_MPU_TABLE13.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetSHROM_MPU_TABLE13() uint32 {
	return volatile.LoadUint32(&o.SHROM_MPU_TABLE13.Reg) & 0x3
}

// DPORT.SHROM_MPU_TABLE14
func (o *DPORT_Type) SetSHROM_MPU_TABLE14(value uint32) {
	volatile.StoreUint32(&o.SHROM_MPU_TABLE14.Reg, volatile.LoadUint32(&o.SHROM_MPU_TABLE14.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetSHROM_MPU_TABLE14() uint32 {
	return volatile.LoadUint32(&o.SHROM_MPU_TABLE14.Reg) & 0x3
}

// DPORT.SHROM_MPU_TABLE15
func (o *DPORT_Type) SetSHROM_MPU_TABLE15(value uint32) {
	volatile.StoreUint32(&o.SHROM_MPU_TABLE15.Reg, volatile.LoadUint32(&o.SHROM_MPU_TABLE15.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetSHROM_MPU_TABLE15() uint32 {
	return volatile.LoadUint32(&o.SHROM_MPU_TABLE15.Reg) & 0x3
}

// DPORT.SHROM_MPU_TABLE16
func (o *DPORT_Type) SetSHROM_MPU_TABLE16(value uint32) {
	volatile.StoreUint32(&o.SHROM_MPU_TABLE16.Reg, volatile.LoadUint32(&o.SHROM_MPU_TABLE16.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetSHROM_MPU_TABLE16() uint32 {
	return volatile.LoadUint32(&o.SHROM_MPU_TABLE16.Reg) & 0x3
}

// DPORT.SHROM_MPU_TABLE17
func (o *DPORT_Type) SetSHROM_MPU_TABLE17(value uint32) {
	volatile.StoreUint32(&o.SHROM_MPU_TABLE17.Reg, volatile.LoadUint32(&o.SHROM_MPU_TABLE17.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetSHROM_MPU_TABLE17() uint32 {
	return volatile.LoadUint32(&o.SHROM_MPU_TABLE17.Reg) & 0x3
}

// DPORT.SHROM_MPU_TABLE18
func (o *DPORT_Type) SetSHROM_MPU_TABLE18(value uint32) {
	volatile.StoreUint32(&o.SHROM_MPU_TABLE18.Reg, volatile.LoadUint32(&o.SHROM_MPU_TABLE18.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetSHROM_MPU_TABLE18() uint32 {
	return volatile.LoadUint32(&o.SHROM_MPU_TABLE18.Reg) & 0x3
}

// DPORT.SHROM_MPU_TABLE19
func (o *DPORT_Type) SetSHROM_MPU_TABLE19(value uint32) {
	volatile.StoreUint32(&o.SHROM_MPU_TABLE19.Reg, volatile.LoadUint32(&o.SHROM_MPU_TABLE19.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetSHROM_MPU_TABLE19() uint32 {
	return volatile.LoadUint32(&o.SHROM_MPU_TABLE19.Reg) & 0x3
}

// DPORT.SHROM_MPU_TABLE20
func (o *DPORT_Type) SetSHROM_MPU_TABLE20(value uint32) {
	volatile.StoreUint32(&o.SHROM_MPU_TABLE20.Reg, volatile.LoadUint32(&o.SHROM_MPU_TABLE20.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetSHROM_MPU_TABLE20() uint32 {
	return volatile.LoadUint32(&o.SHROM_MPU_TABLE20.Reg) & 0x3
}

// DPORT.SHROM_MPU_TABLE21
func (o *DPORT_Type) SetSHROM_MPU_TABLE21(value uint32) {
	volatile.StoreUint32(&o.SHROM_MPU_TABLE21.Reg, volatile.LoadUint32(&o.SHROM_MPU_TABLE21.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetSHROM_MPU_TABLE21() uint32 {
	return volatile.LoadUint32(&o.SHROM_MPU_TABLE21.Reg) & 0x3
}

// DPORT.SHROM_MPU_TABLE22
func (o *DPORT_Type) SetSHROM_MPU_TABLE22(value uint32) {
	volatile.StoreUint32(&o.SHROM_MPU_TABLE22.Reg, volatile.LoadUint32(&o.SHROM_MPU_TABLE22.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetSHROM_MPU_TABLE22() uint32 {
	return volatile.LoadUint32(&o.SHROM_MPU_TABLE22.Reg) & 0x3
}

// DPORT.SHROM_MPU_TABLE23
func (o *DPORT_Type) SetSHROM_MPU_TABLE23(value uint32) {
	volatile.StoreUint32(&o.SHROM_MPU_TABLE23.Reg, volatile.LoadUint32(&o.SHROM_MPU_TABLE23.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetSHROM_MPU_TABLE23() uint32 {
	return volatile.LoadUint32(&o.SHROM_MPU_TABLE23.Reg) & 0x3
}

// DPORT.IMMU_TABLE0
func (o *DPORT_Type) SetIMMU_TABLE0(value uint32) {
	volatile.StoreUint32(&o.IMMU_TABLE0.Reg, volatile.LoadUint32(&o.IMMU_TABLE0.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetIMMU_TABLE0() uint32 {
	return volatile.LoadUint32(&o.IMMU_TABLE0.Reg) & 0x7f
}

// DPORT.IMMU_TABLE1
func (o *DPORT_Type) SetIMMU_TABLE1(value uint32) {
	volatile.StoreUint32(&o.IMMU_TABLE1.Reg, volatile.LoadUint32(&o.IMMU_TABLE1.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetIMMU_TABLE1() uint32 {
	return volatile.LoadUint32(&o.IMMU_TABLE1.Reg) & 0x7f
}

// DPORT.IMMU_TABLE2
func (o *DPORT_Type) SetIMMU_TABLE2(value uint32) {
	volatile.StoreUint32(&o.IMMU_TABLE2.Reg, volatile.LoadUint32(&o.IMMU_TABLE2.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetIMMU_TABLE2() uint32 {
	return volatile.LoadUint32(&o.IMMU_TABLE2.Reg) & 0x7f
}

// DPORT.IMMU_TABLE3
func (o *DPORT_Type) SetIMMU_TABLE3(value uint32) {
	volatile.StoreUint32(&o.IMMU_TABLE3.Reg, volatile.LoadUint32(&o.IMMU_TABLE3.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetIMMU_TABLE3() uint32 {
	return volatile.LoadUint32(&o.IMMU_TABLE3.Reg) & 0x7f
}

// DPORT.IMMU_TABLE4
func (o *DPORT_Type) SetIMMU_TABLE4(value uint32) {
	volatile.StoreUint32(&o.IMMU_TABLE4.Reg, volatile.LoadUint32(&o.IMMU_TABLE4.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetIMMU_TABLE4() uint32 {
	return volatile.LoadUint32(&o.IMMU_TABLE4.Reg) & 0x7f
}

// DPORT.IMMU_TABLE5
func (o *DPORT_Type) SetIMMU_TABLE5(value uint32) {
	volatile.StoreUint32(&o.IMMU_TABLE5.Reg, volatile.LoadUint32(&o.IMMU_TABLE5.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetIMMU_TABLE5() uint32 {
	return volatile.LoadUint32(&o.IMMU_TABLE5.Reg) & 0x7f
}

// DPORT.IMMU_TABLE6
func (o *DPORT_Type) SetIMMU_TABLE6(value uint32) {
	volatile.StoreUint32(&o.IMMU_TABLE6.Reg, volatile.LoadUint32(&o.IMMU_TABLE6.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetIMMU_TABLE6() uint32 {
	return volatile.LoadUint32(&o.IMMU_TABLE6.Reg) & 0x7f
}

// DPORT.IMMU_TABLE7
func (o *DPORT_Type) SetIMMU_TABLE7(value uint32) {
	volatile.StoreUint32(&o.IMMU_TABLE7.Reg, volatile.LoadUint32(&o.IMMU_TABLE7.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetIMMU_TABLE7() uint32 {
	return volatile.LoadUint32(&o.IMMU_TABLE7.Reg) & 0x7f
}

// DPORT.IMMU_TABLE8
func (o *DPORT_Type) SetIMMU_TABLE8(value uint32) {
	volatile.StoreUint32(&o.IMMU_TABLE8.Reg, volatile.LoadUint32(&o.IMMU_TABLE8.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetIMMU_TABLE8() uint32 {
	return volatile.LoadUint32(&o.IMMU_TABLE8.Reg) & 0x7f
}

// DPORT.IMMU_TABLE9
func (o *DPORT_Type) SetIMMU_TABLE9(value uint32) {
	volatile.StoreUint32(&o.IMMU_TABLE9.Reg, volatile.LoadUint32(&o.IMMU_TABLE9.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetIMMU_TABLE9() uint32 {
	return volatile.LoadUint32(&o.IMMU_TABLE9.Reg) & 0x7f
}

// DPORT.IMMU_TABLE10
func (o *DPORT_Type) SetIMMU_TABLE10(value uint32) {
	volatile.StoreUint32(&o.IMMU_TABLE10.Reg, volatile.LoadUint32(&o.IMMU_TABLE10.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetIMMU_TABLE10() uint32 {
	return volatile.LoadUint32(&o.IMMU_TABLE10.Reg) & 0x7f
}

// DPORT.IMMU_TABLE11
func (o *DPORT_Type) SetIMMU_TABLE11(value uint32) {
	volatile.StoreUint32(&o.IMMU_TABLE11.Reg, volatile.LoadUint32(&o.IMMU_TABLE11.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetIMMU_TABLE11() uint32 {
	return volatile.LoadUint32(&o.IMMU_TABLE11.Reg) & 0x7f
}

// DPORT.IMMU_TABLE12
func (o *DPORT_Type) SetIMMU_TABLE12(value uint32) {
	volatile.StoreUint32(&o.IMMU_TABLE12.Reg, volatile.LoadUint32(&o.IMMU_TABLE12.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetIMMU_TABLE12() uint32 {
	return volatile.LoadUint32(&o.IMMU_TABLE12.Reg) & 0x7f
}

// DPORT.IMMU_TABLE13
func (o *DPORT_Type) SetIMMU_TABLE13(value uint32) {
	volatile.StoreUint32(&o.IMMU_TABLE13.Reg, volatile.LoadUint32(&o.IMMU_TABLE13.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetIMMU_TABLE13() uint32 {
	return volatile.LoadUint32(&o.IMMU_TABLE13.Reg) & 0x7f
}

// DPORT.IMMU_TABLE14
func (o *DPORT_Type) SetIMMU_TABLE14(value uint32) {
	volatile.StoreUint32(&o.IMMU_TABLE14.Reg, volatile.LoadUint32(&o.IMMU_TABLE14.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetIMMU_TABLE14() uint32 {
	return volatile.LoadUint32(&o.IMMU_TABLE14.Reg) & 0x7f
}

// DPORT.IMMU_TABLE15
func (o *DPORT_Type) SetIMMU_TABLE15(value uint32) {
	volatile.StoreUint32(&o.IMMU_TABLE15.Reg, volatile.LoadUint32(&o.IMMU_TABLE15.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetIMMU_TABLE15() uint32 {
	return volatile.LoadUint32(&o.IMMU_TABLE15.Reg) & 0x7f
}

// DPORT.DMMU_TABLE0
func (o *DPORT_Type) SetDMMU_TABLE0(value uint32) {
	volatile.StoreUint32(&o.DMMU_TABLE0.Reg, volatile.LoadUint32(&o.DMMU_TABLE0.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetDMMU_TABLE0() uint32 {
	return volatile.LoadUint32(&o.DMMU_TABLE0.Reg) & 0x7f
}

// DPORT.DMMU_TABLE1
func (o *DPORT_Type) SetDMMU_TABLE1(value uint32) {
	volatile.StoreUint32(&o.DMMU_TABLE1.Reg, volatile.LoadUint32(&o.DMMU_TABLE1.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetDMMU_TABLE1() uint32 {
	return volatile.LoadUint32(&o.DMMU_TABLE1.Reg) & 0x7f
}

// DPORT.DMMU_TABLE2
func (o *DPORT_Type) SetDMMU_TABLE2(value uint32) {
	volatile.StoreUint32(&o.DMMU_TABLE2.Reg, volatile.LoadUint32(&o.DMMU_TABLE2.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetDMMU_TABLE2() uint32 {
	return volatile.LoadUint32(&o.DMMU_TABLE2.Reg) & 0x7f
}

// DPORT.DMMU_TABLE3
func (o *DPORT_Type) SetDMMU_TABLE3(value uint32) {
	volatile.StoreUint32(&o.DMMU_TABLE3.Reg, volatile.LoadUint32(&o.DMMU_TABLE3.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetDMMU_TABLE3() uint32 {
	return volatile.LoadUint32(&o.DMMU_TABLE3.Reg) & 0x7f
}

// DPORT.DMMU_TABLE4
func (o *DPORT_Type) SetDMMU_TABLE4(value uint32) {
	volatile.StoreUint32(&o.DMMU_TABLE4.Reg, volatile.LoadUint32(&o.DMMU_TABLE4.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetDMMU_TABLE4() uint32 {
	return volatile.LoadUint32(&o.DMMU_TABLE4.Reg) & 0x7f
}

// DPORT.DMMU_TABLE5
func (o *DPORT_Type) SetDMMU_TABLE5(value uint32) {
	volatile.StoreUint32(&o.DMMU_TABLE5.Reg, volatile.LoadUint32(&o.DMMU_TABLE5.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetDMMU_TABLE5() uint32 {
	return volatile.LoadUint32(&o.DMMU_TABLE5.Reg) & 0x7f
}

// DPORT.DMMU_TABLE6
func (o *DPORT_Type) SetDMMU_TABLE6(value uint32) {
	volatile.StoreUint32(&o.DMMU_TABLE6.Reg, volatile.LoadUint32(&o.DMMU_TABLE6.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetDMMU_TABLE6() uint32 {
	return volatile.LoadUint32(&o.DMMU_TABLE6.Reg) & 0x7f
}

// DPORT.DMMU_TABLE7
func (o *DPORT_Type) SetDMMU_TABLE7(value uint32) {
	volatile.StoreUint32(&o.DMMU_TABLE7.Reg, volatile.LoadUint32(&o.DMMU_TABLE7.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetDMMU_TABLE7() uint32 {
	return volatile.LoadUint32(&o.DMMU_TABLE7.Reg) & 0x7f
}

// DPORT.DMMU_TABLE8
func (o *DPORT_Type) SetDMMU_TABLE8(value uint32) {
	volatile.StoreUint32(&o.DMMU_TABLE8.Reg, volatile.LoadUint32(&o.DMMU_TABLE8.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetDMMU_TABLE8() uint32 {
	return volatile.LoadUint32(&o.DMMU_TABLE8.Reg) & 0x7f
}

// DPORT.DMMU_TABLE9
func (o *DPORT_Type) SetDMMU_TABLE9(value uint32) {
	volatile.StoreUint32(&o.DMMU_TABLE9.Reg, volatile.LoadUint32(&o.DMMU_TABLE9.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetDMMU_TABLE9() uint32 {
	return volatile.LoadUint32(&o.DMMU_TABLE9.Reg) & 0x7f
}

// DPORT.DMMU_TABLE10
func (o *DPORT_Type) SetDMMU_TABLE10(value uint32) {
	volatile.StoreUint32(&o.DMMU_TABLE10.Reg, volatile.LoadUint32(&o.DMMU_TABLE10.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetDMMU_TABLE10() uint32 {
	return volatile.LoadUint32(&o.DMMU_TABLE10.Reg) & 0x7f
}

// DPORT.DMMU_TABLE11
func (o *DPORT_Type) SetDMMU_TABLE11(value uint32) {
	volatile.StoreUint32(&o.DMMU_TABLE11.Reg, volatile.LoadUint32(&o.DMMU_TABLE11.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetDMMU_TABLE11() uint32 {
	return volatile.LoadUint32(&o.DMMU_TABLE11.Reg) & 0x7f
}

// DPORT.DMMU_TABLE12
func (o *DPORT_Type) SetDMMU_TABLE12(value uint32) {
	volatile.StoreUint32(&o.DMMU_TABLE12.Reg, volatile.LoadUint32(&o.DMMU_TABLE12.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetDMMU_TABLE12() uint32 {
	return volatile.LoadUint32(&o.DMMU_TABLE12.Reg) & 0x7f
}

// DPORT.DMMU_TABLE13
func (o *DPORT_Type) SetDMMU_TABLE13(value uint32) {
	volatile.StoreUint32(&o.DMMU_TABLE13.Reg, volatile.LoadUint32(&o.DMMU_TABLE13.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetDMMU_TABLE13() uint32 {
	return volatile.LoadUint32(&o.DMMU_TABLE13.Reg) & 0x7f
}

// DPORT.DMMU_TABLE14
func (o *DPORT_Type) SetDMMU_TABLE14(value uint32) {
	volatile.StoreUint32(&o.DMMU_TABLE14.Reg, volatile.LoadUint32(&o.DMMU_TABLE14.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetDMMU_TABLE14() uint32 {
	return volatile.LoadUint32(&o.DMMU_TABLE14.Reg) & 0x7f
}

// DPORT.DMMU_TABLE15
func (o *DPORT_Type) SetDMMU_TABLE15(value uint32) {
	volatile.StoreUint32(&o.DMMU_TABLE15.Reg, volatile.LoadUint32(&o.DMMU_TABLE15.Reg)&^(0x7f)|value)
}
func (o *DPORT_Type) GetDMMU_TABLE15() uint32 {
	return volatile.LoadUint32(&o.DMMU_TABLE15.Reg) & 0x7f
}

// DPORT.PRO_INTRUSION_CTRL
func (o *DPORT_Type) SetPRO_INTRUSION_CTRL_PRO_INTRUSION_RECORD_RESET_N(value uint32) {
	volatile.StoreUint32(&o.PRO_INTRUSION_CTRL.Reg, volatile.LoadUint32(&o.PRO_INTRUSION_CTRL.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetPRO_INTRUSION_CTRL_PRO_INTRUSION_RECORD_RESET_N() uint32 {
	return volatile.LoadUint32(&o.PRO_INTRUSION_CTRL.Reg) & 0x1
}

// DPORT.PRO_INTRUSION_STATUS
func (o *DPORT_Type) SetPRO_INTRUSION_STATUS_PRO_INTRUSION_RECORD(value uint32) {
	volatile.StoreUint32(&o.PRO_INTRUSION_STATUS.Reg, volatile.LoadUint32(&o.PRO_INTRUSION_STATUS.Reg)&^(0xf)|value)
}
func (o *DPORT_Type) GetPRO_INTRUSION_STATUS_PRO_INTRUSION_RECORD() uint32 {
	return volatile.LoadUint32(&o.PRO_INTRUSION_STATUS.Reg) & 0xf
}

// DPORT.APP_INTRUSION_CTRL
func (o *DPORT_Type) SetAPP_INTRUSION_CTRL_APP_INTRUSION_RECORD_RESET_N(value uint32) {
	volatile.StoreUint32(&o.APP_INTRUSION_CTRL.Reg, volatile.LoadUint32(&o.APP_INTRUSION_CTRL.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetAPP_INTRUSION_CTRL_APP_INTRUSION_RECORD_RESET_N() uint32 {
	return volatile.LoadUint32(&o.APP_INTRUSION_CTRL.Reg) & 0x1
}

// DPORT.APP_INTRUSION_STATUS
func (o *DPORT_Type) SetAPP_INTRUSION_STATUS_APP_INTRUSION_RECORD(value uint32) {
	volatile.StoreUint32(&o.APP_INTRUSION_STATUS.Reg, volatile.LoadUint32(&o.APP_INTRUSION_STATUS.Reg)&^(0xf)|value)
}
func (o *DPORT_Type) GetAPP_INTRUSION_STATUS_APP_INTRUSION_RECORD() uint32 {
	return volatile.LoadUint32(&o.APP_INTRUSION_STATUS.Reg) & 0xf
}

// DPORT.FRONT_END_MEM_PD
func (o *DPORT_Type) SetFRONT_END_MEM_PD_AGC_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.FRONT_END_MEM_PD.Reg, volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetFRONT_END_MEM_PD_AGC_MEM_FORCE_PU() uint32 {
	return volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg) & 0x1
}
func (o *DPORT_Type) SetFRONT_END_MEM_PD_AGC_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.FRONT_END_MEM_PD.Reg, volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg)&^(0x2)|value<<1)
}
func (o *DPORT_Type) GetFRONT_END_MEM_PD_AGC_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg) & 0x2) >> 1
}
func (o *DPORT_Type) SetFRONT_END_MEM_PD_PBUS_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.FRONT_END_MEM_PD.Reg, volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg)&^(0x4)|value<<2)
}
func (o *DPORT_Type) GetFRONT_END_MEM_PD_PBUS_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg) & 0x4) >> 2
}
func (o *DPORT_Type) SetFRONT_END_MEM_PD_PBUS_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.FRONT_END_MEM_PD.Reg, volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg)&^(0x8)|value<<3)
}
func (o *DPORT_Type) GetFRONT_END_MEM_PD_PBUS_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg) & 0x8) >> 3
}

// DPORT.MMU_IA_INT_EN
func (o *DPORT_Type) SetMMU_IA_INT_EN(value uint32) {
	volatile.StoreUint32(&o.MMU_IA_INT_EN.Reg, volatile.LoadUint32(&o.MMU_IA_INT_EN.Reg)&^(0xffffff)|value)
}
func (o *DPORT_Type) GetMMU_IA_INT_EN() uint32 {
	return volatile.LoadUint32(&o.MMU_IA_INT_EN.Reg) & 0xffffff
}

// DPORT.MPU_IA_INT_EN
func (o *DPORT_Type) SetMPU_IA_INT_EN(value uint32) {
	volatile.StoreUint32(&o.MPU_IA_INT_EN.Reg, volatile.LoadUint32(&o.MPU_IA_INT_EN.Reg)&^(0x1ffff)|value)
}
func (o *DPORT_Type) GetMPU_IA_INT_EN() uint32 {
	return volatile.LoadUint32(&o.MPU_IA_INT_EN.Reg) & 0x1ffff
}

// DPORT.CACHE_IA_INT_EN
func (o *DPORT_Type) SetCACHE_IA_INT_EN(value uint32) {
	volatile.StoreUint32(&o.CACHE_IA_INT_EN.Reg, volatile.LoadUint32(&o.CACHE_IA_INT_EN.Reg)&^(0xfffffff)|value)
}
func (o *DPORT_Type) GetCACHE_IA_INT_EN() uint32 {
	return volatile.LoadUint32(&o.CACHE_IA_INT_EN.Reg) & 0xfffffff
}
func (o *DPORT_Type) SetCACHE_IA_INT_EN_CACHE_IA_INT_APP_DROM0(value uint32) {
	volatile.StoreUint32(&o.CACHE_IA_INT_EN.Reg, volatile.LoadUint32(&o.CACHE_IA_INT_EN.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetCACHE_IA_INT_EN_CACHE_IA_INT_APP_DROM0() uint32 {
	return volatile.LoadUint32(&o.CACHE_IA_INT_EN.Reg) & 0x1
}
func (o *DPORT_Type) SetCACHE_IA_INT_EN_CACHE_IA_INT_APP_IRAM0(value uint32) {
	volatile.StoreUint32(&o.CACHE_IA_INT_EN.Reg, volatile.LoadUint32(&o.CACHE_IA_INT_EN.Reg)&^(0x2)|value<<1)
}
func (o *DPORT_Type) GetCACHE_IA_INT_EN_CACHE_IA_INT_APP_IRAM0() uint32 {
	return (volatile.LoadUint32(&o.CACHE_IA_INT_EN.Reg) & 0x2) >> 1
}
func (o *DPORT_Type) SetCACHE_IA_INT_EN_CACHE_IA_INT_APP_IRAM1(value uint32) {
	volatile.StoreUint32(&o.CACHE_IA_INT_EN.Reg, volatile.LoadUint32(&o.CACHE_IA_INT_EN.Reg)&^(0x4)|value<<2)
}
func (o *DPORT_Type) GetCACHE_IA_INT_EN_CACHE_IA_INT_APP_IRAM1() uint32 {
	return (volatile.LoadUint32(&o.CACHE_IA_INT_EN.Reg) & 0x4) >> 2
}
func (o *DPORT_Type) SetCACHE_IA_INT_EN_CACHE_IA_INT_APP_IROM0(value uint32) {
	volatile.StoreUint32(&o.CACHE_IA_INT_EN.Reg, volatile.LoadUint32(&o.CACHE_IA_INT_EN.Reg)&^(0x8)|value<<3)
}
func (o *DPORT_Type) GetCACHE_IA_INT_EN_CACHE_IA_INT_APP_IROM0() uint32 {
	return (volatile.LoadUint32(&o.CACHE_IA_INT_EN.Reg) & 0x8) >> 3
}
func (o *DPORT_Type) SetCACHE_IA_INT_EN_CACHE_IA_INT_APP_DRAM1(value uint32) {
	volatile.StoreUint32(&o.CACHE_IA_INT_EN.Reg, volatile.LoadUint32(&o.CACHE_IA_INT_EN.Reg)&^(0x10)|value<<4)
}
func (o *DPORT_Type) GetCACHE_IA_INT_EN_CACHE_IA_INT_APP_DRAM1() uint32 {
	return (volatile.LoadUint32(&o.CACHE_IA_INT_EN.Reg) & 0x10) >> 4
}
func (o *DPORT_Type) SetCACHE_IA_INT_EN_CACHE_IA_INT_APP_OPPOSITE(value uint32) {
	volatile.StoreUint32(&o.CACHE_IA_INT_EN.Reg, volatile.LoadUint32(&o.CACHE_IA_INT_EN.Reg)&^(0x20)|value<<5)
}
func (o *DPORT_Type) GetCACHE_IA_INT_EN_CACHE_IA_INT_APP_OPPOSITE() uint32 {
	return (volatile.LoadUint32(&o.CACHE_IA_INT_EN.Reg) & 0x20) >> 5
}
func (o *DPORT_Type) SetCACHE_IA_INT_EN_CACHE_IA_INT_PRO_DROM0(value uint32) {
	volatile.StoreUint32(&o.CACHE_IA_INT_EN.Reg, volatile.LoadUint32(&o.CACHE_IA_INT_EN.Reg)&^(0x4000)|value<<14)
}
func (o *DPORT_Type) GetCACHE_IA_INT_EN_CACHE_IA_INT_PRO_DROM0() uint32 {
	return (volatile.LoadUint32(&o.CACHE_IA_INT_EN.Reg) & 0x4000) >> 14
}
func (o *DPORT_Type) SetCACHE_IA_INT_EN_CACHE_IA_INT_PRO_IRAM0(value uint32) {
	volatile.StoreUint32(&o.CACHE_IA_INT_EN.Reg, volatile.LoadUint32(&o.CACHE_IA_INT_EN.Reg)&^(0x8000)|value<<15)
}
func (o *DPORT_Type) GetCACHE_IA_INT_EN_CACHE_IA_INT_PRO_IRAM0() uint32 {
	return (volatile.LoadUint32(&o.CACHE_IA_INT_EN.Reg) & 0x8000) >> 15
}
func (o *DPORT_Type) SetCACHE_IA_INT_EN_CACHE_IA_INT_PRO_IRAM1(value uint32) {
	volatile.StoreUint32(&o.CACHE_IA_INT_EN.Reg, volatile.LoadUint32(&o.CACHE_IA_INT_EN.Reg)&^(0x10000)|value<<16)
}
func (o *DPORT_Type) GetCACHE_IA_INT_EN_CACHE_IA_INT_PRO_IRAM1() uint32 {
	return (volatile.LoadUint32(&o.CACHE_IA_INT_EN.Reg) & 0x10000) >> 16
}
func (o *DPORT_Type) SetCACHE_IA_INT_EN_CACHE_IA_INT_PRO_IROM0(value uint32) {
	volatile.StoreUint32(&o.CACHE_IA_INT_EN.Reg, volatile.LoadUint32(&o.CACHE_IA_INT_EN.Reg)&^(0x20000)|value<<17)
}
func (o *DPORT_Type) GetCACHE_IA_INT_EN_CACHE_IA_INT_PRO_IROM0() uint32 {
	return (volatile.LoadUint32(&o.CACHE_IA_INT_EN.Reg) & 0x20000) >> 17
}
func (o *DPORT_Type) SetCACHE_IA_INT_EN_CACHE_IA_INT_PRO_DRAM1(value uint32) {
	volatile.StoreUint32(&o.CACHE_IA_INT_EN.Reg, volatile.LoadUint32(&o.CACHE_IA_INT_EN.Reg)&^(0x40000)|value<<18)
}
func (o *DPORT_Type) GetCACHE_IA_INT_EN_CACHE_IA_INT_PRO_DRAM1() uint32 {
	return (volatile.LoadUint32(&o.CACHE_IA_INT_EN.Reg) & 0x40000) >> 18
}
func (o *DPORT_Type) SetCACHE_IA_INT_EN_CACHE_IA_INT_PRO_OPPOSITE(value uint32) {
	volatile.StoreUint32(&o.CACHE_IA_INT_EN.Reg, volatile.LoadUint32(&o.CACHE_IA_INT_EN.Reg)&^(0x80000)|value<<19)
}
func (o *DPORT_Type) GetCACHE_IA_INT_EN_CACHE_IA_INT_PRO_OPPOSITE() uint32 {
	return (volatile.LoadUint32(&o.CACHE_IA_INT_EN.Reg) & 0x80000) >> 19
}

// DPORT.SECURE_BOOT_CTRL
func (o *DPORT_Type) SetSECURE_BOOT_CTRL_SW_BOOTLOADER_SEL(value uint32) {
	volatile.StoreUint32(&o.SECURE_BOOT_CTRL.Reg, volatile.LoadUint32(&o.SECURE_BOOT_CTRL.Reg)&^(0x1)|value)
}
func (o *DPORT_Type) GetSECURE_BOOT_CTRL_SW_BOOTLOADER_SEL() uint32 {
	return volatile.LoadUint32(&o.SECURE_BOOT_CTRL.Reg) & 0x1
}

// DPORT.SPI_DMA_CHAN_SEL
func (o *DPORT_Type) SetSPI_DMA_CHAN_SEL_SPI1_DMA_CHAN_SEL(value uint32) {
	volatile.StoreUint32(&o.SPI_DMA_CHAN_SEL.Reg, volatile.LoadUint32(&o.SPI_DMA_CHAN_SEL.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetSPI_DMA_CHAN_SEL_SPI1_DMA_CHAN_SEL() uint32 {
	return volatile.LoadUint32(&o.SPI_DMA_CHAN_SEL.Reg) & 0x3
}
func (o *DPORT_Type) SetSPI_DMA_CHAN_SEL_SPI2_DMA_CHAN_SEL(value uint32) {
	volatile.StoreUint32(&o.SPI_DMA_CHAN_SEL.Reg, volatile.LoadUint32(&o.SPI_DMA_CHAN_SEL.Reg)&^(0xc)|value<<2)
}
func (o *DPORT_Type) GetSPI_DMA_CHAN_SEL_SPI2_DMA_CHAN_SEL() uint32 {
	return (volatile.LoadUint32(&o.SPI_DMA_CHAN_SEL.Reg) & 0xc) >> 2
}
func (o *DPORT_Type) SetSPI_DMA_CHAN_SEL_SPI3_DMA_CHAN_SEL(value uint32) {
	volatile.StoreUint32(&o.SPI_DMA_CHAN_SEL.Reg, volatile.LoadUint32(&o.SPI_DMA_CHAN_SEL.Reg)&^(0x30)|value<<4)
}
func (o *DPORT_Type) GetSPI_DMA_CHAN_SEL_SPI3_DMA_CHAN_SEL() uint32 {
	return (volatile.LoadUint32(&o.SPI_DMA_CHAN_SEL.Reg) & 0x30) >> 4
}

// DPORT.PRO_VECBASE_CTRL
func (o *DPORT_Type) SetPRO_VECBASE_CTRL_PRO_OUT_VECBASE_SEL(value uint32) {
	volatile.StoreUint32(&o.PRO_VECBASE_CTRL.Reg, volatile.LoadUint32(&o.PRO_VECBASE_CTRL.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetPRO_VECBASE_CTRL_PRO_OUT_VECBASE_SEL() uint32 {
	return volatile.LoadUint32(&o.PRO_VECBASE_CTRL.Reg) & 0x3
}

// DPORT.PRO_VECBASE_SET
func (o *DPORT_Type) SetPRO_VECBASE_SET_PRO_OUT_VECBASE(value uint32) {
	volatile.StoreUint32(&o.PRO_VECBASE_SET.Reg, volatile.LoadUint32(&o.PRO_VECBASE_SET.Reg)&^(0x3fffff)|value)
}
func (o *DPORT_Type) GetPRO_VECBASE_SET_PRO_OUT_VECBASE() uint32 {
	return volatile.LoadUint32(&o.PRO_VECBASE_SET.Reg) & 0x3fffff
}

// DPORT.APP_VECBASE_CTRL
func (o *DPORT_Type) SetAPP_VECBASE_CTRL_APP_OUT_VECBASE_SEL(value uint32) {
	volatile.StoreUint32(&o.APP_VECBASE_CTRL.Reg, volatile.LoadUint32(&o.APP_VECBASE_CTRL.Reg)&^(0x3)|value)
}
func (o *DPORT_Type) GetAPP_VECBASE_CTRL_APP_OUT_VECBASE_SEL() uint32 {
	return volatile.LoadUint32(&o.APP_VECBASE_CTRL.Reg) & 0x3
}

// DPORT.APP_VECBASE_SET
func (o *DPORT_Type) SetAPP_VECBASE_SET_APP_OUT_VECBASE(value uint32) {
	volatile.StoreUint32(&o.APP_VECBASE_SET.Reg, volatile.LoadUint32(&o.APP_VECBASE_SET.Reg)&^(0x3fffff)|value)
}
func (o *DPORT_Type) GetAPP_VECBASE_SET_APP_OUT_VECBASE() uint32 {
	return volatile.LoadUint32(&o.APP_VECBASE_SET.Reg) & 0x3fffff
}

// DPORT.DATE
func (o *DPORT_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *DPORT_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}

// eFuse Controller
type EFUSE_Type struct {
	BLK0_RDATA0 volatile.Register32 // 0x0
	BLK0_RDATA1 volatile.Register32 // 0x4
	BLK0_RDATA2 volatile.Register32 // 0x8
	BLK0_RDATA3 volatile.Register32 // 0xC
	BLK0_RDATA4 volatile.Register32 // 0x10
	BLK0_RDATA5 volatile.Register32 // 0x14
	BLK0_RDATA6 volatile.Register32 // 0x18
	BLK0_WDATA0 volatile.Register32 // 0x1C
	BLK0_WDATA1 volatile.Register32 // 0x20
	BLK0_WDATA2 volatile.Register32 // 0x24
	BLK0_WDATA3 volatile.Register32 // 0x28
	BLK0_WDATA4 volatile.Register32 // 0x2C
	BLK0_WDATA5 volatile.Register32 // 0x30
	BLK0_WDATA6 volatile.Register32 // 0x34
	BLK1_RDATA0 volatile.Register32 // 0x38
	BLK1_RDATA1 volatile.Register32 // 0x3C
	BLK1_RDATA2 volatile.Register32 // 0x40
	BLK1_RDATA3 volatile.Register32 // 0x44
	BLK1_RDATA4 volatile.Register32 // 0x48
	BLK1_RDATA5 volatile.Register32 // 0x4C
	BLK1_RDATA6 volatile.Register32 // 0x50
	BLK1_RDATA7 volatile.Register32 // 0x54
	BLK2_RDATA0 volatile.Register32 // 0x58
	BLK2_RDATA1 volatile.Register32 // 0x5C
	BLK2_RDATA2 volatile.Register32 // 0x60
	BLK2_RDATA3 volatile.Register32 // 0x64
	BLK2_RDATA4 volatile.Register32 // 0x68
	BLK2_RDATA5 volatile.Register32 // 0x6C
	BLK2_RDATA6 volatile.Register32 // 0x70
	BLK2_RDATA7 volatile.Register32 // 0x74
	BLK3_RDATA0 volatile.Register32 // 0x78
	BLK3_RDATA1 volatile.Register32 // 0x7C
	BLK3_RDATA2 volatile.Register32 // 0x80
	BLK3_RDATA3 volatile.Register32 // 0x84
	BLK3_RDATA4 volatile.Register32 // 0x88
	BLK3_RDATA5 volatile.Register32 // 0x8C
	BLK3_RDATA6 volatile.Register32 // 0x90
	BLK3_RDATA7 volatile.Register32 // 0x94
	BLK1_WDATA0 volatile.Register32 // 0x98
	BLK1_WDATA1 volatile.Register32 // 0x9C
	BLK1_WDATA2 volatile.Register32 // 0xA0
	BLK1_WDATA3 volatile.Register32 // 0xA4
	BLK1_WDATA4 volatile.Register32 // 0xA8
	BLK1_WDATA5 volatile.Register32 // 0xAC
	BLK1_WDATA6 volatile.Register32 // 0xB0
	BLK1_WDATA7 volatile.Register32 // 0xB4
	BLK2_WDATA0 volatile.Register32 // 0xB8
	BLK2_WDATA1 volatile.Register32 // 0xBC
	BLK2_WDATA2 volatile.Register32 // 0xC0
	BLK2_WDATA3 volatile.Register32 // 0xC4
	BLK2_WDATA4 volatile.Register32 // 0xC8
	BLK2_WDATA5 volatile.Register32 // 0xCC
	BLK2_WDATA6 volatile.Register32 // 0xD0
	BLK2_WDATA7 volatile.Register32 // 0xD4
	BLK3_WDATA0 volatile.Register32 // 0xD8
	BLK3_WDATA1 volatile.Register32 // 0xDC
	BLK3_WDATA2 volatile.Register32 // 0xE0
	BLK3_WDATA3 volatile.Register32 // 0xE4
	BLK3_WDATA4 volatile.Register32 // 0xE8
	BLK3_WDATA5 volatile.Register32 // 0xEC
	BLK3_WDATA6 volatile.Register32 // 0xF0
	BLK3_WDATA7 volatile.Register32 // 0xF4
	CLK         volatile.Register32 // 0xF8
	CONF        volatile.Register32 // 0xFC
	STATUS      volatile.Register32 // 0x100
	CMD         volatile.Register32 // 0x104
	INT_RAW     volatile.Register32 // 0x108
	INT_ST      volatile.Register32 // 0x10C
	INT_ENA     volatile.Register32 // 0x110
	INT_CLR     volatile.Register32 // 0x114
	DAC_CONF    volatile.Register32 // 0x118
	DEC_STATUS  volatile.Register32 // 0x11C
	_           [220]byte
	DATE        volatile.Register32 // 0x1FC
}

// EFUSE.BLK0_RDATA0
func (o *EFUSE_Type) SetBLK0_RDATA0_RD_EFUSE_WR_DIS(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA0.Reg, volatile.LoadUint32(&o.BLK0_RDATA0.Reg)&^(0xffff)|value)
}
func (o *EFUSE_Type) GetBLK0_RDATA0_RD_EFUSE_WR_DIS() uint32 {
	return volatile.LoadUint32(&o.BLK0_RDATA0.Reg) & 0xffff
}
func (o *EFUSE_Type) SetBLK0_RDATA0_RD_EFUSE_RD_DIS(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA0.Reg, volatile.LoadUint32(&o.BLK0_RDATA0.Reg)&^(0xf0000)|value<<16)
}
func (o *EFUSE_Type) GetBLK0_RDATA0_RD_EFUSE_RD_DIS() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA0.Reg) & 0xf0000) >> 16
}
func (o *EFUSE_Type) SetBLK0_RDATA0_RD_FLASH_CRYPT_CNT(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA0.Reg, volatile.LoadUint32(&o.BLK0_RDATA0.Reg)&^(0x7f00000)|value<<20)
}
func (o *EFUSE_Type) GetBLK0_RDATA0_RD_FLASH_CRYPT_CNT() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA0.Reg) & 0x7f00000) >> 20
}
func (o *EFUSE_Type) SetBLK0_RDATA0_RD_UART_DOWNLOAD_DIS(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA0.Reg, volatile.LoadUint32(&o.BLK0_RDATA0.Reg)&^(0x8000000)|value<<27)
}
func (o *EFUSE_Type) GetBLK0_RDATA0_RD_UART_DOWNLOAD_DIS() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA0.Reg) & 0x8000000) >> 27
}
func (o *EFUSE_Type) SetBLK0_RDATA0_RESERVED_0_28(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA0.Reg, volatile.LoadUint32(&o.BLK0_RDATA0.Reg)&^(0xf0000000)|value<<28)
}
func (o *EFUSE_Type) GetBLK0_RDATA0_RESERVED_0_28() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA0.Reg) & 0xf0000000) >> 28
}

// EFUSE.BLK0_RDATA1
func (o *EFUSE_Type) SetBLK0_RDATA1(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA1.Reg, value)
}
func (o *EFUSE_Type) GetBLK0_RDATA1() uint32 {
	return volatile.LoadUint32(&o.BLK0_RDATA1.Reg)
}

// EFUSE.BLK0_RDATA2
func (o *EFUSE_Type) SetBLK0_RDATA2_RD_MAC_1(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA2.Reg, volatile.LoadUint32(&o.BLK0_RDATA2.Reg)&^(0xffff)|value)
}
func (o *EFUSE_Type) GetBLK0_RDATA2_RD_MAC_1() uint32 {
	return volatile.LoadUint32(&o.BLK0_RDATA2.Reg) & 0xffff
}
func (o *EFUSE_Type) SetBLK0_RDATA2_RD_MAC_CRC(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA2.Reg, volatile.LoadUint32(&o.BLK0_RDATA2.Reg)&^(0xff0000)|value<<16)
}
func (o *EFUSE_Type) GetBLK0_RDATA2_RD_MAC_CRC() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA2.Reg) & 0xff0000) >> 16
}
func (o *EFUSE_Type) SetBLK0_RDATA2_RD_RESERVE_0_88(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA2.Reg, volatile.LoadUint32(&o.BLK0_RDATA2.Reg)&^(0xff000000)|value<<24)
}
func (o *EFUSE_Type) GetBLK0_RDATA2_RD_RESERVE_0_88() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA2.Reg) & 0xff000000) >> 24
}

// EFUSE.BLK0_RDATA3
func (o *EFUSE_Type) SetBLK0_RDATA3_RD_DISABLE_APP_CPU(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA3.Reg, volatile.LoadUint32(&o.BLK0_RDATA3.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetBLK0_RDATA3_RD_DISABLE_APP_CPU() uint32 {
	return volatile.LoadUint32(&o.BLK0_RDATA3.Reg) & 0x1
}
func (o *EFUSE_Type) SetBLK0_RDATA3_RD_DISABLE_BT(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA3.Reg, volatile.LoadUint32(&o.BLK0_RDATA3.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetBLK0_RDATA3_RD_DISABLE_BT() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA3.Reg) & 0x2) >> 1
}
func (o *EFUSE_Type) SetBLK0_RDATA3_RD_CHIP_PACKAGE_4BIT(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA3.Reg, volatile.LoadUint32(&o.BLK0_RDATA3.Reg)&^(0x4)|value<<2)
}
func (o *EFUSE_Type) GetBLK0_RDATA3_RD_CHIP_PACKAGE_4BIT() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA3.Reg) & 0x4) >> 2
}
func (o *EFUSE_Type) SetBLK0_RDATA3_RD_DIS_CACHE(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA3.Reg, volatile.LoadUint32(&o.BLK0_RDATA3.Reg)&^(0x8)|value<<3)
}
func (o *EFUSE_Type) GetBLK0_RDATA3_RD_DIS_CACHE() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA3.Reg) & 0x8) >> 3
}
func (o *EFUSE_Type) SetBLK0_RDATA3_RD_SPI_PAD_CONFIG_HD(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA3.Reg, volatile.LoadUint32(&o.BLK0_RDATA3.Reg)&^(0x1f0)|value<<4)
}
func (o *EFUSE_Type) GetBLK0_RDATA3_RD_SPI_PAD_CONFIG_HD() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA3.Reg) & 0x1f0) >> 4
}
func (o *EFUSE_Type) SetBLK0_RDATA3_RD_CHIP_PACKAGE(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA3.Reg, volatile.LoadUint32(&o.BLK0_RDATA3.Reg)&^(0xe00)|value<<9)
}
func (o *EFUSE_Type) GetBLK0_RDATA3_RD_CHIP_PACKAGE() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA3.Reg) & 0xe00) >> 9
}
func (o *EFUSE_Type) SetBLK0_RDATA3_RD_CHIP_CPU_FREQ_LOW(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA3.Reg, volatile.LoadUint32(&o.BLK0_RDATA3.Reg)&^(0x1000)|value<<12)
}
func (o *EFUSE_Type) GetBLK0_RDATA3_RD_CHIP_CPU_FREQ_LOW() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA3.Reg) & 0x1000) >> 12
}
func (o *EFUSE_Type) SetBLK0_RDATA3_RD_CHIP_CPU_FREQ_RATED(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA3.Reg, volatile.LoadUint32(&o.BLK0_RDATA3.Reg)&^(0x2000)|value<<13)
}
func (o *EFUSE_Type) GetBLK0_RDATA3_RD_CHIP_CPU_FREQ_RATED() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA3.Reg) & 0x2000) >> 13
}
func (o *EFUSE_Type) SetBLK0_RDATA3_RD_BLK3_PART_RESERVE(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA3.Reg, volatile.LoadUint32(&o.BLK0_RDATA3.Reg)&^(0x4000)|value<<14)
}
func (o *EFUSE_Type) GetBLK0_RDATA3_RD_BLK3_PART_RESERVE() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA3.Reg) & 0x4000) >> 14
}
func (o *EFUSE_Type) SetBLK0_RDATA3_RD_CHIP_VER_REV1(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA3.Reg, volatile.LoadUint32(&o.BLK0_RDATA3.Reg)&^(0x8000)|value<<15)
}
func (o *EFUSE_Type) GetBLK0_RDATA3_RD_CHIP_VER_REV1() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA3.Reg) & 0x8000) >> 15
}
func (o *EFUSE_Type) SetBLK0_RDATA3_RD_RESERVE_0_112(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA3.Reg, volatile.LoadUint32(&o.BLK0_RDATA3.Reg)&^(0xffff0000)|value<<16)
}
func (o *EFUSE_Type) GetBLK0_RDATA3_RD_RESERVE_0_112() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA3.Reg) & 0xffff0000) >> 16
}

// EFUSE.BLK0_RDATA4
func (o *EFUSE_Type) SetBLK0_RDATA4_RD_CLK8M_FREQ(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA4.Reg, volatile.LoadUint32(&o.BLK0_RDATA4.Reg)&^(0xff)|value)
}
func (o *EFUSE_Type) GetBLK0_RDATA4_RD_CLK8M_FREQ() uint32 {
	return volatile.LoadUint32(&o.BLK0_RDATA4.Reg) & 0xff
}
func (o *EFUSE_Type) SetBLK0_RDATA4_RD_ADC_VREF(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA4.Reg, volatile.LoadUint32(&o.BLK0_RDATA4.Reg)&^(0x1f00)|value<<8)
}
func (o *EFUSE_Type) GetBLK0_RDATA4_RD_ADC_VREF() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA4.Reg) & 0x1f00) >> 8
}
func (o *EFUSE_Type) SetBLK0_RDATA4_RD_RESERVE_0_141(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA4.Reg, volatile.LoadUint32(&o.BLK0_RDATA4.Reg)&^(0x2000)|value<<13)
}
func (o *EFUSE_Type) GetBLK0_RDATA4_RD_RESERVE_0_141() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA4.Reg) & 0x2000) >> 13
}
func (o *EFUSE_Type) SetBLK0_RDATA4_RD_XPD_SDIO(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA4.Reg, volatile.LoadUint32(&o.BLK0_RDATA4.Reg)&^(0x4000)|value<<14)
}
func (o *EFUSE_Type) GetBLK0_RDATA4_RD_XPD_SDIO() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA4.Reg) & 0x4000) >> 14
}
func (o *EFUSE_Type) SetBLK0_RDATA4_RD_XPD_SDIO_TIEH(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA4.Reg, volatile.LoadUint32(&o.BLK0_RDATA4.Reg)&^(0x8000)|value<<15)
}
func (o *EFUSE_Type) GetBLK0_RDATA4_RD_XPD_SDIO_TIEH() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA4.Reg) & 0x8000) >> 15
}
func (o *EFUSE_Type) SetBLK0_RDATA4_RD_XPD_SDIO_FORCE(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA4.Reg, volatile.LoadUint32(&o.BLK0_RDATA4.Reg)&^(0x10000)|value<<16)
}
func (o *EFUSE_Type) GetBLK0_RDATA4_RD_XPD_SDIO_FORCE() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA4.Reg) & 0x10000) >> 16
}
func (o *EFUSE_Type) SetBLK0_RDATA4_RD_RESERVE_0_145(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA4.Reg, volatile.LoadUint32(&o.BLK0_RDATA4.Reg)&^(0xfffe0000)|value<<17)
}
func (o *EFUSE_Type) GetBLK0_RDATA4_RD_RESERVE_0_145() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA4.Reg) & 0xfffe0000) >> 17
}

// EFUSE.BLK0_RDATA5
func (o *EFUSE_Type) SetBLK0_RDATA5_RD_SPI_PAD_CONFIG_CLK(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA5.Reg, volatile.LoadUint32(&o.BLK0_RDATA5.Reg)&^(0x1f)|value)
}
func (o *EFUSE_Type) GetBLK0_RDATA5_RD_SPI_PAD_CONFIG_CLK() uint32 {
	return volatile.LoadUint32(&o.BLK0_RDATA5.Reg) & 0x1f
}
func (o *EFUSE_Type) SetBLK0_RDATA5_RD_SPI_PAD_CONFIG_Q(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA5.Reg, volatile.LoadUint32(&o.BLK0_RDATA5.Reg)&^(0x3e0)|value<<5)
}
func (o *EFUSE_Type) GetBLK0_RDATA5_RD_SPI_PAD_CONFIG_Q() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA5.Reg) & 0x3e0) >> 5
}
func (o *EFUSE_Type) SetBLK0_RDATA5_RD_SPI_PAD_CONFIG_D(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA5.Reg, volatile.LoadUint32(&o.BLK0_RDATA5.Reg)&^(0x7c00)|value<<10)
}
func (o *EFUSE_Type) GetBLK0_RDATA5_RD_SPI_PAD_CONFIG_D() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA5.Reg) & 0x7c00) >> 10
}
func (o *EFUSE_Type) SetBLK0_RDATA5_RD_SPI_PAD_CONFIG_CS0(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA5.Reg, volatile.LoadUint32(&o.BLK0_RDATA5.Reg)&^(0xf8000)|value<<15)
}
func (o *EFUSE_Type) GetBLK0_RDATA5_RD_SPI_PAD_CONFIG_CS0() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA5.Reg) & 0xf8000) >> 15
}
func (o *EFUSE_Type) SetBLK0_RDATA5_RD_CHIP_VER_REV2(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA5.Reg, volatile.LoadUint32(&o.BLK0_RDATA5.Reg)&^(0x100000)|value<<20)
}
func (o *EFUSE_Type) GetBLK0_RDATA5_RD_CHIP_VER_REV2() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA5.Reg) & 0x100000) >> 20
}
func (o *EFUSE_Type) SetBLK0_RDATA5_RD_RESERVE_0_181(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA5.Reg, volatile.LoadUint32(&o.BLK0_RDATA5.Reg)&^(0x200000)|value<<21)
}
func (o *EFUSE_Type) GetBLK0_RDATA5_RD_RESERVE_0_181() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA5.Reg) & 0x200000) >> 21
}
func (o *EFUSE_Type) SetBLK0_RDATA5_RD_VOL_LEVEL_HP_INV(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA5.Reg, volatile.LoadUint32(&o.BLK0_RDATA5.Reg)&^(0xc00000)|value<<22)
}
func (o *EFUSE_Type) GetBLK0_RDATA5_RD_VOL_LEVEL_HP_INV() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA5.Reg) & 0xc00000) >> 22
}
func (o *EFUSE_Type) SetBLK0_RDATA5_RD_WAFER_VERSION_MINOR(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA5.Reg, volatile.LoadUint32(&o.BLK0_RDATA5.Reg)&^(0x3000000)|value<<24)
}
func (o *EFUSE_Type) GetBLK0_RDATA5_RD_WAFER_VERSION_MINOR() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA5.Reg) & 0x3000000) >> 24
}
func (o *EFUSE_Type) SetBLK0_RDATA5_RD_RESERVE_0_186(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA5.Reg, volatile.LoadUint32(&o.BLK0_RDATA5.Reg)&^(0xc000000)|value<<26)
}
func (o *EFUSE_Type) GetBLK0_RDATA5_RD_RESERVE_0_186() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA5.Reg) & 0xc000000) >> 26
}
func (o *EFUSE_Type) SetBLK0_RDATA5_RD_FLASH_CRYPT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA5.Reg, volatile.LoadUint32(&o.BLK0_RDATA5.Reg)&^(0xf0000000)|value<<28)
}
func (o *EFUSE_Type) GetBLK0_RDATA5_RD_FLASH_CRYPT_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA5.Reg) & 0xf0000000) >> 28
}

// EFUSE.BLK0_RDATA6
func (o *EFUSE_Type) SetBLK0_RDATA6_RD_CODING_SCHEME(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA6.Reg, volatile.LoadUint32(&o.BLK0_RDATA6.Reg)&^(0x3)|value)
}
func (o *EFUSE_Type) GetBLK0_RDATA6_RD_CODING_SCHEME() uint32 {
	return volatile.LoadUint32(&o.BLK0_RDATA6.Reg) & 0x3
}
func (o *EFUSE_Type) SetBLK0_RDATA6_RD_CONSOLE_DEBUG_DISABLE(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA6.Reg, volatile.LoadUint32(&o.BLK0_RDATA6.Reg)&^(0x4)|value<<2)
}
func (o *EFUSE_Type) GetBLK0_RDATA6_RD_CONSOLE_DEBUG_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA6.Reg) & 0x4) >> 2
}
func (o *EFUSE_Type) SetBLK0_RDATA6_RD_DISABLE_SDIO_HOST(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA6.Reg, volatile.LoadUint32(&o.BLK0_RDATA6.Reg)&^(0x8)|value<<3)
}
func (o *EFUSE_Type) GetBLK0_RDATA6_RD_DISABLE_SDIO_HOST() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA6.Reg) & 0x8) >> 3
}
func (o *EFUSE_Type) SetBLK0_RDATA6_RD_ABS_DONE_0(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA6.Reg, volatile.LoadUint32(&o.BLK0_RDATA6.Reg)&^(0x10)|value<<4)
}
func (o *EFUSE_Type) GetBLK0_RDATA6_RD_ABS_DONE_0() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA6.Reg) & 0x10) >> 4
}
func (o *EFUSE_Type) SetBLK0_RDATA6_RD_ABS_DONE_1(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA6.Reg, volatile.LoadUint32(&o.BLK0_RDATA6.Reg)&^(0x20)|value<<5)
}
func (o *EFUSE_Type) GetBLK0_RDATA6_RD_ABS_DONE_1() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA6.Reg) & 0x20) >> 5
}
func (o *EFUSE_Type) SetBLK0_RDATA6_RD_JTAG_DISABLE(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA6.Reg, volatile.LoadUint32(&o.BLK0_RDATA6.Reg)&^(0x40)|value<<6)
}
func (o *EFUSE_Type) GetBLK0_RDATA6_RD_JTAG_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA6.Reg) & 0x40) >> 6
}
func (o *EFUSE_Type) SetBLK0_RDATA6_RD_DISABLE_DL_ENCRYPT(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA6.Reg, volatile.LoadUint32(&o.BLK0_RDATA6.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetBLK0_RDATA6_RD_DISABLE_DL_ENCRYPT() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA6.Reg) & 0x80) >> 7
}
func (o *EFUSE_Type) SetBLK0_RDATA6_RD_DISABLE_DL_DECRYPT(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA6.Reg, volatile.LoadUint32(&o.BLK0_RDATA6.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetBLK0_RDATA6_RD_DISABLE_DL_DECRYPT() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA6.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetBLK0_RDATA6_RD_DISABLE_DL_CACHE(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA6.Reg, volatile.LoadUint32(&o.BLK0_RDATA6.Reg)&^(0x200)|value<<9)
}
func (o *EFUSE_Type) GetBLK0_RDATA6_RD_DISABLE_DL_CACHE() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA6.Reg) & 0x200) >> 9
}
func (o *EFUSE_Type) SetBLK0_RDATA6_RD_KEY_STATUS(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA6.Reg, volatile.LoadUint32(&o.BLK0_RDATA6.Reg)&^(0x400)|value<<10)
}
func (o *EFUSE_Type) GetBLK0_RDATA6_RD_KEY_STATUS() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA6.Reg) & 0x400) >> 10
}
func (o *EFUSE_Type) SetBLK0_RDATA6_RD_RESERVE_0_203(value uint32) {
	volatile.StoreUint32(&o.BLK0_RDATA6.Reg, volatile.LoadUint32(&o.BLK0_RDATA6.Reg)&^(0xfffff800)|value<<11)
}
func (o *EFUSE_Type) GetBLK0_RDATA6_RD_RESERVE_0_203() uint32 {
	return (volatile.LoadUint32(&o.BLK0_RDATA6.Reg) & 0xfffff800) >> 11
}

// EFUSE.BLK0_WDATA0
func (o *EFUSE_Type) SetBLK0_WDATA0_WR_DIS(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA0.Reg, volatile.LoadUint32(&o.BLK0_WDATA0.Reg)&^(0xffff)|value)
}
func (o *EFUSE_Type) GetBLK0_WDATA0_WR_DIS() uint32 {
	return volatile.LoadUint32(&o.BLK0_WDATA0.Reg) & 0xffff
}
func (o *EFUSE_Type) SetBLK0_WDATA0_RD_DIS(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA0.Reg, volatile.LoadUint32(&o.BLK0_WDATA0.Reg)&^(0xf0000)|value<<16)
}
func (o *EFUSE_Type) GetBLK0_WDATA0_RD_DIS() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA0.Reg) & 0xf0000) >> 16
}
func (o *EFUSE_Type) SetBLK0_WDATA0_FLASH_CRYPT_CNT(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA0.Reg, volatile.LoadUint32(&o.BLK0_WDATA0.Reg)&^(0x7f00000)|value<<20)
}
func (o *EFUSE_Type) GetBLK0_WDATA0_FLASH_CRYPT_CNT() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA0.Reg) & 0x7f00000) >> 20
}

// EFUSE.BLK0_WDATA1
func (o *EFUSE_Type) SetBLK0_WDATA1(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA1.Reg, value)
}
func (o *EFUSE_Type) GetBLK0_WDATA1() uint32 {
	return volatile.LoadUint32(&o.BLK0_WDATA1.Reg)
}

// EFUSE.BLK0_WDATA2
func (o *EFUSE_Type) SetBLK0_WDATA2_WIFI_MAC_CRC_HIGH(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA2.Reg, volatile.LoadUint32(&o.BLK0_WDATA2.Reg)&^(0xffffff)|value)
}
func (o *EFUSE_Type) GetBLK0_WDATA2_WIFI_MAC_CRC_HIGH() uint32 {
	return volatile.LoadUint32(&o.BLK0_WDATA2.Reg) & 0xffffff
}

// EFUSE.BLK0_WDATA3
func (o *EFUSE_Type) SetBLK0_WDATA3_DISABLE_APP_CPU(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA3.Reg, volatile.LoadUint32(&o.BLK0_WDATA3.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetBLK0_WDATA3_DISABLE_APP_CPU() uint32 {
	return volatile.LoadUint32(&o.BLK0_WDATA3.Reg) & 0x1
}
func (o *EFUSE_Type) SetBLK0_WDATA3_DISABLE_BT(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA3.Reg, volatile.LoadUint32(&o.BLK0_WDATA3.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetBLK0_WDATA3_DISABLE_BT() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA3.Reg) & 0x2) >> 1
}
func (o *EFUSE_Type) SetBLK0_WDATA3_CHIP_PACKAGE_4BIT(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA3.Reg, volatile.LoadUint32(&o.BLK0_WDATA3.Reg)&^(0x4)|value<<2)
}
func (o *EFUSE_Type) GetBLK0_WDATA3_CHIP_PACKAGE_4BIT() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA3.Reg) & 0x4) >> 2
}
func (o *EFUSE_Type) SetBLK0_WDATA3_DIS_CACHE(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA3.Reg, volatile.LoadUint32(&o.BLK0_WDATA3.Reg)&^(0x8)|value<<3)
}
func (o *EFUSE_Type) GetBLK0_WDATA3_DIS_CACHE() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA3.Reg) & 0x8) >> 3
}
func (o *EFUSE_Type) SetBLK0_WDATA3_SPI_PAD_CONFIG_HD(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA3.Reg, volatile.LoadUint32(&o.BLK0_WDATA3.Reg)&^(0x1f0)|value<<4)
}
func (o *EFUSE_Type) GetBLK0_WDATA3_SPI_PAD_CONFIG_HD() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA3.Reg) & 0x1f0) >> 4
}
func (o *EFUSE_Type) SetBLK0_WDATA3_CHIP_PACKAGE(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA3.Reg, volatile.LoadUint32(&o.BLK0_WDATA3.Reg)&^(0xe00)|value<<9)
}
func (o *EFUSE_Type) GetBLK0_WDATA3_CHIP_PACKAGE() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA3.Reg) & 0xe00) >> 9
}
func (o *EFUSE_Type) SetBLK0_WDATA3_CHIP_CPU_FREQ_LOW(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA3.Reg, volatile.LoadUint32(&o.BLK0_WDATA3.Reg)&^(0x1000)|value<<12)
}
func (o *EFUSE_Type) GetBLK0_WDATA3_CHIP_CPU_FREQ_LOW() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA3.Reg) & 0x1000) >> 12
}
func (o *EFUSE_Type) SetBLK0_WDATA3_CHIP_CPU_FREQ_RATED(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA3.Reg, volatile.LoadUint32(&o.BLK0_WDATA3.Reg)&^(0x2000)|value<<13)
}
func (o *EFUSE_Type) GetBLK0_WDATA3_CHIP_CPU_FREQ_RATED() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA3.Reg) & 0x2000) >> 13
}
func (o *EFUSE_Type) SetBLK0_WDATA3_BLK3_PART_RESERVE(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA3.Reg, volatile.LoadUint32(&o.BLK0_WDATA3.Reg)&^(0x4000)|value<<14)
}
func (o *EFUSE_Type) GetBLK0_WDATA3_BLK3_PART_RESERVE() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA3.Reg) & 0x4000) >> 14
}
func (o *EFUSE_Type) SetBLK0_WDATA3_CHIP_VER_REV1(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA3.Reg, volatile.LoadUint32(&o.BLK0_WDATA3.Reg)&^(0x8000)|value<<15)
}
func (o *EFUSE_Type) GetBLK0_WDATA3_CHIP_VER_REV1() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA3.Reg) & 0x8000) >> 15
}
func (o *EFUSE_Type) SetBLK0_WDATA3_RESERVE_0_112(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA3.Reg, volatile.LoadUint32(&o.BLK0_WDATA3.Reg)&^(0xffff0000)|value<<16)
}
func (o *EFUSE_Type) GetBLK0_WDATA3_RESERVE_0_112() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA3.Reg) & 0xffff0000) >> 16
}

// EFUSE.BLK0_WDATA4
func (o *EFUSE_Type) SetBLK0_WDATA4_CLK8M_FREQ(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA4.Reg, volatile.LoadUint32(&o.BLK0_WDATA4.Reg)&^(0xff)|value)
}
func (o *EFUSE_Type) GetBLK0_WDATA4_CLK8M_FREQ() uint32 {
	return volatile.LoadUint32(&o.BLK0_WDATA4.Reg) & 0xff
}
func (o *EFUSE_Type) SetBLK0_WDATA4_ADC_VREF(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA4.Reg, volatile.LoadUint32(&o.BLK0_WDATA4.Reg)&^(0x1f00)|value<<8)
}
func (o *EFUSE_Type) GetBLK0_WDATA4_ADC_VREF() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA4.Reg) & 0x1f00) >> 8
}
func (o *EFUSE_Type) SetBLK0_WDATA4_RESERVE_0_141(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA4.Reg, volatile.LoadUint32(&o.BLK0_WDATA4.Reg)&^(0x2000)|value<<13)
}
func (o *EFUSE_Type) GetBLK0_WDATA4_RESERVE_0_141() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA4.Reg) & 0x2000) >> 13
}
func (o *EFUSE_Type) SetBLK0_WDATA4_XPD_SDIO(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA4.Reg, volatile.LoadUint32(&o.BLK0_WDATA4.Reg)&^(0x4000)|value<<14)
}
func (o *EFUSE_Type) GetBLK0_WDATA4_XPD_SDIO() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA4.Reg) & 0x4000) >> 14
}
func (o *EFUSE_Type) SetBLK0_WDATA4_XPD_SDIO_TIEH(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA4.Reg, volatile.LoadUint32(&o.BLK0_WDATA4.Reg)&^(0x8000)|value<<15)
}
func (o *EFUSE_Type) GetBLK0_WDATA4_XPD_SDIO_TIEH() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA4.Reg) & 0x8000) >> 15
}
func (o *EFUSE_Type) SetBLK0_WDATA4_XPD_SDIO_FORCE(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA4.Reg, volatile.LoadUint32(&o.BLK0_WDATA4.Reg)&^(0x10000)|value<<16)
}
func (o *EFUSE_Type) GetBLK0_WDATA4_XPD_SDIO_FORCE() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA4.Reg) & 0x10000) >> 16
}
func (o *EFUSE_Type) SetBLK0_WDATA4_RESERVE_0_145(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA4.Reg, volatile.LoadUint32(&o.BLK0_WDATA4.Reg)&^(0xfffe0000)|value<<17)
}
func (o *EFUSE_Type) GetBLK0_WDATA4_RESERVE_0_145() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA4.Reg) & 0xfffe0000) >> 17
}

// EFUSE.BLK0_WDATA5
func (o *EFUSE_Type) SetBLK0_WDATA5_SPI_PAD_CONFIG_CLK(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA5.Reg, volatile.LoadUint32(&o.BLK0_WDATA5.Reg)&^(0x1f)|value)
}
func (o *EFUSE_Type) GetBLK0_WDATA5_SPI_PAD_CONFIG_CLK() uint32 {
	return volatile.LoadUint32(&o.BLK0_WDATA5.Reg) & 0x1f
}
func (o *EFUSE_Type) SetBLK0_WDATA5_SPI_PAD_CONFIG_Q(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA5.Reg, volatile.LoadUint32(&o.BLK0_WDATA5.Reg)&^(0x3e0)|value<<5)
}
func (o *EFUSE_Type) GetBLK0_WDATA5_SPI_PAD_CONFIG_Q() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA5.Reg) & 0x3e0) >> 5
}
func (o *EFUSE_Type) SetBLK0_WDATA5_SPI_PAD_CONFIG_D(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA5.Reg, volatile.LoadUint32(&o.BLK0_WDATA5.Reg)&^(0x7c00)|value<<10)
}
func (o *EFUSE_Type) GetBLK0_WDATA5_SPI_PAD_CONFIG_D() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA5.Reg) & 0x7c00) >> 10
}
func (o *EFUSE_Type) SetBLK0_WDATA5_SPI_PAD_CONFIG_CS0(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA5.Reg, volatile.LoadUint32(&o.BLK0_WDATA5.Reg)&^(0xf8000)|value<<15)
}
func (o *EFUSE_Type) GetBLK0_WDATA5_SPI_PAD_CONFIG_CS0() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA5.Reg) & 0xf8000) >> 15
}
func (o *EFUSE_Type) SetBLK0_WDATA5_CHIP_VER_REV2(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA5.Reg, volatile.LoadUint32(&o.BLK0_WDATA5.Reg)&^(0x100000)|value<<20)
}
func (o *EFUSE_Type) GetBLK0_WDATA5_CHIP_VER_REV2() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA5.Reg) & 0x100000) >> 20
}
func (o *EFUSE_Type) SetBLK0_WDATA5_RESERVE_0_181(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA5.Reg, volatile.LoadUint32(&o.BLK0_WDATA5.Reg)&^(0x200000)|value<<21)
}
func (o *EFUSE_Type) GetBLK0_WDATA5_RESERVE_0_181() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA5.Reg) & 0x200000) >> 21
}
func (o *EFUSE_Type) SetBLK0_WDATA5_VOL_LEVEL_HP_INV(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA5.Reg, volatile.LoadUint32(&o.BLK0_WDATA5.Reg)&^(0xc00000)|value<<22)
}
func (o *EFUSE_Type) GetBLK0_WDATA5_VOL_LEVEL_HP_INV() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA5.Reg) & 0xc00000) >> 22
}
func (o *EFUSE_Type) SetBLK0_WDATA5_WAFER_VERSION_MINOR(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA5.Reg, volatile.LoadUint32(&o.BLK0_WDATA5.Reg)&^(0x3000000)|value<<24)
}
func (o *EFUSE_Type) GetBLK0_WDATA5_WAFER_VERSION_MINOR() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA5.Reg) & 0x3000000) >> 24
}
func (o *EFUSE_Type) SetBLK0_WDATA5_RESERVE_0_186(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA5.Reg, volatile.LoadUint32(&o.BLK0_WDATA5.Reg)&^(0xc000000)|value<<26)
}
func (o *EFUSE_Type) GetBLK0_WDATA5_RESERVE_0_186() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA5.Reg) & 0xc000000) >> 26
}
func (o *EFUSE_Type) SetBLK0_WDATA5_FLASH_CRYPT_CONFIG(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA5.Reg, volatile.LoadUint32(&o.BLK0_WDATA5.Reg)&^(0xf0000000)|value<<28)
}
func (o *EFUSE_Type) GetBLK0_WDATA5_FLASH_CRYPT_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA5.Reg) & 0xf0000000) >> 28
}

// EFUSE.BLK0_WDATA6
func (o *EFUSE_Type) SetBLK0_WDATA6_CODING_SCHEME(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA6.Reg, volatile.LoadUint32(&o.BLK0_WDATA6.Reg)&^(0x3)|value)
}
func (o *EFUSE_Type) GetBLK0_WDATA6_CODING_SCHEME() uint32 {
	return volatile.LoadUint32(&o.BLK0_WDATA6.Reg) & 0x3
}
func (o *EFUSE_Type) SetBLK0_WDATA6_CONSOLE_DEBUG_DISABLE(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA6.Reg, volatile.LoadUint32(&o.BLK0_WDATA6.Reg)&^(0x4)|value<<2)
}
func (o *EFUSE_Type) GetBLK0_WDATA6_CONSOLE_DEBUG_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA6.Reg) & 0x4) >> 2
}
func (o *EFUSE_Type) SetBLK0_WDATA6_DISABLE_SDIO_HOST(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA6.Reg, volatile.LoadUint32(&o.BLK0_WDATA6.Reg)&^(0x8)|value<<3)
}
func (o *EFUSE_Type) GetBLK0_WDATA6_DISABLE_SDIO_HOST() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA6.Reg) & 0x8) >> 3
}
func (o *EFUSE_Type) SetBLK0_WDATA6_ABS_DONE_0(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA6.Reg, volatile.LoadUint32(&o.BLK0_WDATA6.Reg)&^(0x10)|value<<4)
}
func (o *EFUSE_Type) GetBLK0_WDATA6_ABS_DONE_0() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA6.Reg) & 0x10) >> 4
}
func (o *EFUSE_Type) SetBLK0_WDATA6_ABS_DONE_1(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA6.Reg, volatile.LoadUint32(&o.BLK0_WDATA6.Reg)&^(0x20)|value<<5)
}
func (o *EFUSE_Type) GetBLK0_WDATA6_ABS_DONE_1() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA6.Reg) & 0x20) >> 5
}
func (o *EFUSE_Type) SetBLK0_WDATA6_DISABLE_JTAG(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA6.Reg, volatile.LoadUint32(&o.BLK0_WDATA6.Reg)&^(0x40)|value<<6)
}
func (o *EFUSE_Type) GetBLK0_WDATA6_DISABLE_JTAG() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA6.Reg) & 0x40) >> 6
}
func (o *EFUSE_Type) SetBLK0_WDATA6_DISABLE_DL_ENCRYPT(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA6.Reg, volatile.LoadUint32(&o.BLK0_WDATA6.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetBLK0_WDATA6_DISABLE_DL_ENCRYPT() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA6.Reg) & 0x80) >> 7
}
func (o *EFUSE_Type) SetBLK0_WDATA6_DISABLE_DL_DECRYPT(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA6.Reg, volatile.LoadUint32(&o.BLK0_WDATA6.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetBLK0_WDATA6_DISABLE_DL_DECRYPT() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA6.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetBLK0_WDATA6_DISABLE_DL_CACHE(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA6.Reg, volatile.LoadUint32(&o.BLK0_WDATA6.Reg)&^(0x200)|value<<9)
}
func (o *EFUSE_Type) GetBLK0_WDATA6_DISABLE_DL_CACHE() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA6.Reg) & 0x200) >> 9
}
func (o *EFUSE_Type) SetBLK0_WDATA6_KEY_STATUS(value uint32) {
	volatile.StoreUint32(&o.BLK0_WDATA6.Reg, volatile.LoadUint32(&o.BLK0_WDATA6.Reg)&^(0x400)|value<<10)
}
func (o *EFUSE_Type) GetBLK0_WDATA6_KEY_STATUS() uint32 {
	return (volatile.LoadUint32(&o.BLK0_WDATA6.Reg) & 0x400) >> 10
}

// EFUSE.BLK1_RDATA0
func (o *EFUSE_Type) SetBLK1_RDATA0(value uint32) {
	volatile.StoreUint32(&o.BLK1_RDATA0.Reg, value)
}
func (o *EFUSE_Type) GetBLK1_RDATA0() uint32 {
	return volatile.LoadUint32(&o.BLK1_RDATA0.Reg)
}

// EFUSE.BLK1_RDATA1
func (o *EFUSE_Type) SetBLK1_RDATA1(value uint32) {
	volatile.StoreUint32(&o.BLK1_RDATA1.Reg, value)
}
func (o *EFUSE_Type) GetBLK1_RDATA1() uint32 {
	return volatile.LoadUint32(&o.BLK1_RDATA1.Reg)
}

// EFUSE.BLK1_RDATA2
func (o *EFUSE_Type) SetBLK1_RDATA2(value uint32) {
	volatile.StoreUint32(&o.BLK1_RDATA2.Reg, value)
}
func (o *EFUSE_Type) GetBLK1_RDATA2() uint32 {
	return volatile.LoadUint32(&o.BLK1_RDATA2.Reg)
}

// EFUSE.BLK1_RDATA3
func (o *EFUSE_Type) SetBLK1_RDATA3(value uint32) {
	volatile.StoreUint32(&o.BLK1_RDATA3.Reg, value)
}
func (o *EFUSE_Type) GetBLK1_RDATA3() uint32 {
	return volatile.LoadUint32(&o.BLK1_RDATA3.Reg)
}

// EFUSE.BLK1_RDATA4
func (o *EFUSE_Type) SetBLK1_RDATA4(value uint32) {
	volatile.StoreUint32(&o.BLK1_RDATA4.Reg, value)
}
func (o *EFUSE_Type) GetBLK1_RDATA4() uint32 {
	return volatile.LoadUint32(&o.BLK1_RDATA4.Reg)
}

// EFUSE.BLK1_RDATA5
func (o *EFUSE_Type) SetBLK1_RDATA5(value uint32) {
	volatile.StoreUint32(&o.BLK1_RDATA5.Reg, value)
}
func (o *EFUSE_Type) GetBLK1_RDATA5() uint32 {
	return volatile.LoadUint32(&o.BLK1_RDATA5.Reg)
}

// EFUSE.BLK1_RDATA6
func (o *EFUSE_Type) SetBLK1_RDATA6(value uint32) {
	volatile.StoreUint32(&o.BLK1_RDATA6.Reg, value)
}
func (o *EFUSE_Type) GetBLK1_RDATA6() uint32 {
	return volatile.LoadUint32(&o.BLK1_RDATA6.Reg)
}

// EFUSE.BLK1_RDATA7
func (o *EFUSE_Type) SetBLK1_RDATA7(value uint32) {
	volatile.StoreUint32(&o.BLK1_RDATA7.Reg, value)
}
func (o *EFUSE_Type) GetBLK1_RDATA7() uint32 {
	return volatile.LoadUint32(&o.BLK1_RDATA7.Reg)
}

// EFUSE.BLK2_RDATA0
func (o *EFUSE_Type) SetBLK2_RDATA0(value uint32) {
	volatile.StoreUint32(&o.BLK2_RDATA0.Reg, value)
}
func (o *EFUSE_Type) GetBLK2_RDATA0() uint32 {
	return volatile.LoadUint32(&o.BLK2_RDATA0.Reg)
}

// EFUSE.BLK2_RDATA1
func (o *EFUSE_Type) SetBLK2_RDATA1(value uint32) {
	volatile.StoreUint32(&o.BLK2_RDATA1.Reg, value)
}
func (o *EFUSE_Type) GetBLK2_RDATA1() uint32 {
	return volatile.LoadUint32(&o.BLK2_RDATA1.Reg)
}

// EFUSE.BLK2_RDATA2
func (o *EFUSE_Type) SetBLK2_RDATA2(value uint32) {
	volatile.StoreUint32(&o.BLK2_RDATA2.Reg, value)
}
func (o *EFUSE_Type) GetBLK2_RDATA2() uint32 {
	return volatile.LoadUint32(&o.BLK2_RDATA2.Reg)
}

// EFUSE.BLK2_RDATA3
func (o *EFUSE_Type) SetBLK2_RDATA3(value uint32) {
	volatile.StoreUint32(&o.BLK2_RDATA3.Reg, value)
}
func (o *EFUSE_Type) GetBLK2_RDATA3() uint32 {
	return volatile.LoadUint32(&o.BLK2_RDATA3.Reg)
}

// EFUSE.BLK2_RDATA4
func (o *EFUSE_Type) SetBLK2_RDATA4(value uint32) {
	volatile.StoreUint32(&o.BLK2_RDATA4.Reg, value)
}
func (o *EFUSE_Type) GetBLK2_RDATA4() uint32 {
	return volatile.LoadUint32(&o.BLK2_RDATA4.Reg)
}

// EFUSE.BLK2_RDATA5
func (o *EFUSE_Type) SetBLK2_RDATA5(value uint32) {
	volatile.StoreUint32(&o.BLK2_RDATA5.Reg, value)
}
func (o *EFUSE_Type) GetBLK2_RDATA5() uint32 {
	return volatile.LoadUint32(&o.BLK2_RDATA5.Reg)
}

// EFUSE.BLK2_RDATA6
func (o *EFUSE_Type) SetBLK2_RDATA6(value uint32) {
	volatile.StoreUint32(&o.BLK2_RDATA6.Reg, value)
}
func (o *EFUSE_Type) GetBLK2_RDATA6() uint32 {
	return volatile.LoadUint32(&o.BLK2_RDATA6.Reg)
}

// EFUSE.BLK2_RDATA7
func (o *EFUSE_Type) SetBLK2_RDATA7(value uint32) {
	volatile.StoreUint32(&o.BLK2_RDATA7.Reg, value)
}
func (o *EFUSE_Type) GetBLK2_RDATA7() uint32 {
	return volatile.LoadUint32(&o.BLK2_RDATA7.Reg)
}

// EFUSE.BLK3_RDATA0
func (o *EFUSE_Type) SetBLK3_RDATA0_RD_CUSTOM_MAC_CRC(value uint32) {
	volatile.StoreUint32(&o.BLK3_RDATA0.Reg, volatile.LoadUint32(&o.BLK3_RDATA0.Reg)&^(0xff)|value)
}
func (o *EFUSE_Type) GetBLK3_RDATA0_RD_CUSTOM_MAC_CRC() uint32 {
	return volatile.LoadUint32(&o.BLK3_RDATA0.Reg) & 0xff
}
func (o *EFUSE_Type) SetBLK3_RDATA0_RD_CUSTOM_MAC(value uint32) {
	volatile.StoreUint32(&o.BLK3_RDATA0.Reg, volatile.LoadUint32(&o.BLK3_RDATA0.Reg)&^(0xffffff00)|value<<8)
}
func (o *EFUSE_Type) GetBLK3_RDATA0_RD_CUSTOM_MAC() uint32 {
	return (volatile.LoadUint32(&o.BLK3_RDATA0.Reg) & 0xffffff00) >> 8
}

// EFUSE.BLK3_RDATA1
func (o *EFUSE_Type) SetBLK3_RDATA1_RD_CUSTOM_MAC_1(value uint32) {
	volatile.StoreUint32(&o.BLK3_RDATA1.Reg, volatile.LoadUint32(&o.BLK3_RDATA1.Reg)&^(0xffffff)|value)
}
func (o *EFUSE_Type) GetBLK3_RDATA1_RD_CUSTOM_MAC_1() uint32 {
	return volatile.LoadUint32(&o.BLK3_RDATA1.Reg) & 0xffffff
}
func (o *EFUSE_Type) SetBLK3_RDATA1_RESERVED_3_56(value uint32) {
	volatile.StoreUint32(&o.BLK3_RDATA1.Reg, volatile.LoadUint32(&o.BLK3_RDATA1.Reg)&^(0xff000000)|value<<24)
}
func (o *EFUSE_Type) GetBLK3_RDATA1_RESERVED_3_56() uint32 {
	return (volatile.LoadUint32(&o.BLK3_RDATA1.Reg) & 0xff000000) >> 24
}

// EFUSE.BLK3_RDATA2
func (o *EFUSE_Type) SetBLK3_RDATA2(value uint32) {
	volatile.StoreUint32(&o.BLK3_RDATA2.Reg, value)
}
func (o *EFUSE_Type) GetBLK3_RDATA2() uint32 {
	return volatile.LoadUint32(&o.BLK3_RDATA2.Reg)
}

// EFUSE.BLK3_RDATA3
func (o *EFUSE_Type) SetBLK3_RDATA3_RD_ADC1_TP_LOW(value uint32) {
	volatile.StoreUint32(&o.BLK3_RDATA3.Reg, volatile.LoadUint32(&o.BLK3_RDATA3.Reg)&^(0x7f)|value)
}
func (o *EFUSE_Type) GetBLK3_RDATA3_RD_ADC1_TP_LOW() uint32 {
	return volatile.LoadUint32(&o.BLK3_RDATA3.Reg) & 0x7f
}
func (o *EFUSE_Type) SetBLK3_RDATA3_RD_ADC1_TP_HIGH(value uint32) {
	volatile.StoreUint32(&o.BLK3_RDATA3.Reg, volatile.LoadUint32(&o.BLK3_RDATA3.Reg)&^(0xff80)|value<<7)
}
func (o *EFUSE_Type) GetBLK3_RDATA3_RD_ADC1_TP_HIGH() uint32 {
	return (volatile.LoadUint32(&o.BLK3_RDATA3.Reg) & 0xff80) >> 7
}
func (o *EFUSE_Type) SetBLK3_RDATA3_RD_ADC2_TP_LOW(value uint32) {
	volatile.StoreUint32(&o.BLK3_RDATA3.Reg, volatile.LoadUint32(&o.BLK3_RDATA3.Reg)&^(0x7f0000)|value<<16)
}
func (o *EFUSE_Type) GetBLK3_RDATA3_RD_ADC2_TP_LOW() uint32 {
	return (volatile.LoadUint32(&o.BLK3_RDATA3.Reg) & 0x7f0000) >> 16
}
func (o *EFUSE_Type) SetBLK3_RDATA3_RD_ADC2_TP_HIGH(value uint32) {
	volatile.StoreUint32(&o.BLK3_RDATA3.Reg, volatile.LoadUint32(&o.BLK3_RDATA3.Reg)&^(0xff800000)|value<<23)
}
func (o *EFUSE_Type) GetBLK3_RDATA3_RD_ADC2_TP_HIGH() uint32 {
	return (volatile.LoadUint32(&o.BLK3_RDATA3.Reg) & 0xff800000) >> 23
}

// EFUSE.BLK3_RDATA4
func (o *EFUSE_Type) SetBLK3_RDATA4(value uint32) {
	volatile.StoreUint32(&o.BLK3_RDATA4.Reg, value)
}
func (o *EFUSE_Type) GetBLK3_RDATA4() uint32 {
	return volatile.LoadUint32(&o.BLK3_RDATA4.Reg)
}

// EFUSE.BLK3_RDATA5
func (o *EFUSE_Type) SetBLK3_RDATA5_RESERVED_3_160(value uint32) {
	volatile.StoreUint32(&o.BLK3_RDATA5.Reg, volatile.LoadUint32(&o.BLK3_RDATA5.Reg)&^(0xffffff)|value)
}
func (o *EFUSE_Type) GetBLK3_RDATA5_RESERVED_3_160() uint32 {
	return volatile.LoadUint32(&o.BLK3_RDATA5.Reg) & 0xffffff
}
func (o *EFUSE_Type) SetBLK3_RDATA5_RD_MAC_VERSION(value uint32) {
	volatile.StoreUint32(&o.BLK3_RDATA5.Reg, volatile.LoadUint32(&o.BLK3_RDATA5.Reg)&^(0xff000000)|value<<24)
}
func (o *EFUSE_Type) GetBLK3_RDATA5_RD_MAC_VERSION() uint32 {
	return (volatile.LoadUint32(&o.BLK3_RDATA5.Reg) & 0xff000000) >> 24
}

// EFUSE.BLK3_RDATA6
func (o *EFUSE_Type) SetBLK3_RDATA6(value uint32) {
	volatile.StoreUint32(&o.BLK3_RDATA6.Reg, value)
}
func (o *EFUSE_Type) GetBLK3_RDATA6() uint32 {
	return volatile.LoadUint32(&o.BLK3_RDATA6.Reg)
}

// EFUSE.BLK3_RDATA7
func (o *EFUSE_Type) SetBLK3_RDATA7(value uint32) {
	volatile.StoreUint32(&o.BLK3_RDATA7.Reg, value)
}
func (o *EFUSE_Type) GetBLK3_RDATA7() uint32 {
	return volatile.LoadUint32(&o.BLK3_RDATA7.Reg)
}

// EFUSE.BLK1_WDATA0
func (o *EFUSE_Type) SetBLK1_WDATA0(value uint32) {
	volatile.StoreUint32(&o.BLK1_WDATA0.Reg, value)
}
func (o *EFUSE_Type) GetBLK1_WDATA0() uint32 {
	return volatile.LoadUint32(&o.BLK1_WDATA0.Reg)
}

// EFUSE.BLK1_WDATA1
func (o *EFUSE_Type) SetBLK1_WDATA1(value uint32) {
	volatile.StoreUint32(&o.BLK1_WDATA1.Reg, value)
}
func (o *EFUSE_Type) GetBLK1_WDATA1() uint32 {
	return volatile.LoadUint32(&o.BLK1_WDATA1.Reg)
}

// EFUSE.BLK1_WDATA2
func (o *EFUSE_Type) SetBLK1_WDATA2(value uint32) {
	volatile.StoreUint32(&o.BLK1_WDATA2.Reg, value)
}
func (o *EFUSE_Type) GetBLK1_WDATA2() uint32 {
	return volatile.LoadUint32(&o.BLK1_WDATA2.Reg)
}

// EFUSE.BLK1_WDATA3
func (o *EFUSE_Type) SetBLK1_WDATA3(value uint32) {
	volatile.StoreUint32(&o.BLK1_WDATA3.Reg, value)
}
func (o *EFUSE_Type) GetBLK1_WDATA3() uint32 {
	return volatile.LoadUint32(&o.BLK1_WDATA3.Reg)
}

// EFUSE.BLK1_WDATA4
func (o *EFUSE_Type) SetBLK1_WDATA4(value uint32) {
	volatile.StoreUint32(&o.BLK1_WDATA4.Reg, value)
}
func (o *EFUSE_Type) GetBLK1_WDATA4() uint32 {
	return volatile.LoadUint32(&o.BLK1_WDATA4.Reg)
}

// EFUSE.BLK1_WDATA5
func (o *EFUSE_Type) SetBLK1_WDATA5(value uint32) {
	volatile.StoreUint32(&o.BLK1_WDATA5.Reg, value)
}
func (o *EFUSE_Type) GetBLK1_WDATA5() uint32 {
	return volatile.LoadUint32(&o.BLK1_WDATA5.Reg)
}

// EFUSE.BLK1_WDATA6
func (o *EFUSE_Type) SetBLK1_WDATA6(value uint32) {
	volatile.StoreUint32(&o.BLK1_WDATA6.Reg, value)
}
func (o *EFUSE_Type) GetBLK1_WDATA6() uint32 {
	return volatile.LoadUint32(&o.BLK1_WDATA6.Reg)
}

// EFUSE.BLK1_WDATA7
func (o *EFUSE_Type) SetBLK1_WDATA7(value uint32) {
	volatile.StoreUint32(&o.BLK1_WDATA7.Reg, value)
}
func (o *EFUSE_Type) GetBLK1_WDATA7() uint32 {
	return volatile.LoadUint32(&o.BLK1_WDATA7.Reg)
}

// EFUSE.BLK2_WDATA0
func (o *EFUSE_Type) SetBLK2_WDATA0(value uint32) {
	volatile.StoreUint32(&o.BLK2_WDATA0.Reg, value)
}
func (o *EFUSE_Type) GetBLK2_WDATA0() uint32 {
	return volatile.LoadUint32(&o.BLK2_WDATA0.Reg)
}

// EFUSE.BLK2_WDATA1
func (o *EFUSE_Type) SetBLK2_WDATA1(value uint32) {
	volatile.StoreUint32(&o.BLK2_WDATA1.Reg, value)
}
func (o *EFUSE_Type) GetBLK2_WDATA1() uint32 {
	return volatile.LoadUint32(&o.BLK2_WDATA1.Reg)
}

// EFUSE.BLK2_WDATA2
func (o *EFUSE_Type) SetBLK2_WDATA2(value uint32) {
	volatile.StoreUint32(&o.BLK2_WDATA2.Reg, value)
}
func (o *EFUSE_Type) GetBLK2_WDATA2() uint32 {
	return volatile.LoadUint32(&o.BLK2_WDATA2.Reg)
}

// EFUSE.BLK2_WDATA3
func (o *EFUSE_Type) SetBLK2_WDATA3(value uint32) {
	volatile.StoreUint32(&o.BLK2_WDATA3.Reg, value)
}
func (o *EFUSE_Type) GetBLK2_WDATA3() uint32 {
	return volatile.LoadUint32(&o.BLK2_WDATA3.Reg)
}

// EFUSE.BLK2_WDATA4
func (o *EFUSE_Type) SetBLK2_WDATA4(value uint32) {
	volatile.StoreUint32(&o.BLK2_WDATA4.Reg, value)
}
func (o *EFUSE_Type) GetBLK2_WDATA4() uint32 {
	return volatile.LoadUint32(&o.BLK2_WDATA4.Reg)
}

// EFUSE.BLK2_WDATA5
func (o *EFUSE_Type) SetBLK2_WDATA5(value uint32) {
	volatile.StoreUint32(&o.BLK2_WDATA5.Reg, value)
}
func (o *EFUSE_Type) GetBLK2_WDATA5() uint32 {
	return volatile.LoadUint32(&o.BLK2_WDATA5.Reg)
}

// EFUSE.BLK2_WDATA6
func (o *EFUSE_Type) SetBLK2_WDATA6(value uint32) {
	volatile.StoreUint32(&o.BLK2_WDATA6.Reg, value)
}
func (o *EFUSE_Type) GetBLK2_WDATA6() uint32 {
	return volatile.LoadUint32(&o.BLK2_WDATA6.Reg)
}

// EFUSE.BLK2_WDATA7
func (o *EFUSE_Type) SetBLK2_WDATA7(value uint32) {
	volatile.StoreUint32(&o.BLK2_WDATA7.Reg, value)
}
func (o *EFUSE_Type) GetBLK2_WDATA7() uint32 {
	return volatile.LoadUint32(&o.BLK2_WDATA7.Reg)
}

// EFUSE.BLK3_WDATA0
func (o *EFUSE_Type) SetBLK3_WDATA0(value uint32) {
	volatile.StoreUint32(&o.BLK3_WDATA0.Reg, value)
}
func (o *EFUSE_Type) GetBLK3_WDATA0() uint32 {
	return volatile.LoadUint32(&o.BLK3_WDATA0.Reg)
}

// EFUSE.BLK3_WDATA1
func (o *EFUSE_Type) SetBLK3_WDATA1(value uint32) {
	volatile.StoreUint32(&o.BLK3_WDATA1.Reg, value)
}
func (o *EFUSE_Type) GetBLK3_WDATA1() uint32 {
	return volatile.LoadUint32(&o.BLK3_WDATA1.Reg)
}

// EFUSE.BLK3_WDATA2
func (o *EFUSE_Type) SetBLK3_WDATA2(value uint32) {
	volatile.StoreUint32(&o.BLK3_WDATA2.Reg, value)
}
func (o *EFUSE_Type) GetBLK3_WDATA2() uint32 {
	return volatile.LoadUint32(&o.BLK3_WDATA2.Reg)
}

// EFUSE.BLK3_WDATA3
func (o *EFUSE_Type) SetBLK3_WDATA3_ADC1_TP_LOW(value uint32) {
	volatile.StoreUint32(&o.BLK3_WDATA3.Reg, volatile.LoadUint32(&o.BLK3_WDATA3.Reg)&^(0x7f)|value)
}
func (o *EFUSE_Type) GetBLK3_WDATA3_ADC1_TP_LOW() uint32 {
	return volatile.LoadUint32(&o.BLK3_WDATA3.Reg) & 0x7f
}
func (o *EFUSE_Type) SetBLK3_WDATA3_ADC1_TP_HIGH(value uint32) {
	volatile.StoreUint32(&o.BLK3_WDATA3.Reg, volatile.LoadUint32(&o.BLK3_WDATA3.Reg)&^(0xff80)|value<<7)
}
func (o *EFUSE_Type) GetBLK3_WDATA3_ADC1_TP_HIGH() uint32 {
	return (volatile.LoadUint32(&o.BLK3_WDATA3.Reg) & 0xff80) >> 7
}
func (o *EFUSE_Type) SetBLK3_WDATA3_ADC2_TP_LOW(value uint32) {
	volatile.StoreUint32(&o.BLK3_WDATA3.Reg, volatile.LoadUint32(&o.BLK3_WDATA3.Reg)&^(0x7f0000)|value<<16)
}
func (o *EFUSE_Type) GetBLK3_WDATA3_ADC2_TP_LOW() uint32 {
	return (volatile.LoadUint32(&o.BLK3_WDATA3.Reg) & 0x7f0000) >> 16
}
func (o *EFUSE_Type) SetBLK3_WDATA3_ADC2_TP_HIGH(value uint32) {
	volatile.StoreUint32(&o.BLK3_WDATA3.Reg, volatile.LoadUint32(&o.BLK3_WDATA3.Reg)&^(0xff800000)|value<<23)
}
func (o *EFUSE_Type) GetBLK3_WDATA3_ADC2_TP_HIGH() uint32 {
	return (volatile.LoadUint32(&o.BLK3_WDATA3.Reg) & 0xff800000) >> 23
}

// EFUSE.BLK3_WDATA4
func (o *EFUSE_Type) SetBLK3_WDATA4(value uint32) {
	volatile.StoreUint32(&o.BLK3_WDATA4.Reg, value)
}
func (o *EFUSE_Type) GetBLK3_WDATA4() uint32 {
	return volatile.LoadUint32(&o.BLK3_WDATA4.Reg)
}

// EFUSE.BLK3_WDATA5
func (o *EFUSE_Type) SetBLK3_WDATA5(value uint32) {
	volatile.StoreUint32(&o.BLK3_WDATA5.Reg, value)
}
func (o *EFUSE_Type) GetBLK3_WDATA5() uint32 {
	return volatile.LoadUint32(&o.BLK3_WDATA5.Reg)
}

// EFUSE.BLK3_WDATA6
func (o *EFUSE_Type) SetBLK3_WDATA6(value uint32) {
	volatile.StoreUint32(&o.BLK3_WDATA6.Reg, value)
}
func (o *EFUSE_Type) GetBLK3_WDATA6() uint32 {
	return volatile.LoadUint32(&o.BLK3_WDATA6.Reg)
}

// EFUSE.BLK3_WDATA7
func (o *EFUSE_Type) SetBLK3_WDATA7(value uint32) {
	volatile.StoreUint32(&o.BLK3_WDATA7.Reg, value)
}
func (o *EFUSE_Type) GetBLK3_WDATA7() uint32 {
	return volatile.LoadUint32(&o.BLK3_WDATA7.Reg)
}

// EFUSE.CLK
func (o *EFUSE_Type) SetCLK_SEL0(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0xff)|value)
}
func (o *EFUSE_Type) GetCLK_SEL0() uint32 {
	return volatile.LoadUint32(&o.CLK.Reg) & 0xff
}
func (o *EFUSE_Type) SetCLK_SEL1(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0xff00)|value<<8)
}
func (o *EFUSE_Type) GetCLK_SEL1() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0xff00) >> 8
}
func (o *EFUSE_Type) SetCLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x10000)|value<<16)
}
func (o *EFUSE_Type) GetCLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0x10000) >> 16
}

// EFUSE.CONF
func (o *EFUSE_Type) SetCONF_OP_CODE(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0xffff)|value)
}
func (o *EFUSE_Type) GetCONF_OP_CODE() uint32 {
	return volatile.LoadUint32(&o.CONF.Reg) & 0xffff
}
func (o *EFUSE_Type) SetCONF_FORCE_NO_WR_RD_DIS(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x10000)|value<<16)
}
func (o *EFUSE_Type) GetCONF_FORCE_NO_WR_RD_DIS() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x10000) >> 16
}

// EFUSE.STATUS
func (o *EFUSE_Type) SetSTATUS(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, value)
}
func (o *EFUSE_Type) GetSTATUS() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg)
}

// EFUSE.CMD
func (o *EFUSE_Type) SetCMD_READ_CMD(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetCMD_READ_CMD() uint32 {
	return volatile.LoadUint32(&o.CMD.Reg) & 0x1
}
func (o *EFUSE_Type) SetCMD_PGM_CMD(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetCMD_PGM_CMD() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x2) >> 1
}

// EFUSE.INT_RAW
func (o *EFUSE_Type) SetINT_RAW_READ_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetINT_RAW_READ_DONE_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1
}
func (o *EFUSE_Type) SetINT_RAW_PGM_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetINT_RAW_PGM_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2) >> 1
}

// EFUSE.INT_ST
func (o *EFUSE_Type) SetINT_ST_READ_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetINT_ST_READ_DONE_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_ST.Reg) & 0x1
}
func (o *EFUSE_Type) SetINT_ST_PGM_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetINT_ST_PGM_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x2) >> 1
}

// EFUSE.INT_ENA
func (o *EFUSE_Type) SetINT_ENA_READ_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetINT_ENA_READ_DONE_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}
func (o *EFUSE_Type) SetINT_ENA_PGM_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetINT_ENA_PGM_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2) >> 1
}

// EFUSE.INT_CLR
func (o *EFUSE_Type) SetINT_CLR_READ_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetINT_CLR_READ_DONE_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1
}
func (o *EFUSE_Type) SetINT_CLR_PGM_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetINT_CLR_PGM_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2) >> 1
}

// EFUSE.DAC_CONF
func (o *EFUSE_Type) SetDAC_CONF_DAC_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.DAC_CONF.Reg, volatile.LoadUint32(&o.DAC_CONF.Reg)&^(0xff)|value)
}
func (o *EFUSE_Type) GetDAC_CONF_DAC_CLK_DIV() uint32 {
	return volatile.LoadUint32(&o.DAC_CONF.Reg) & 0xff
}
func (o *EFUSE_Type) SetDAC_CONF_DAC_CLK_PAD_SEL(value uint32) {
	volatile.StoreUint32(&o.DAC_CONF.Reg, volatile.LoadUint32(&o.DAC_CONF.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetDAC_CONF_DAC_CLK_PAD_SEL() uint32 {
	return (volatile.LoadUint32(&o.DAC_CONF.Reg) & 0x100) >> 8
}

// EFUSE.DEC_STATUS
func (o *EFUSE_Type) SetDEC_STATUS_DEC_WARNINGS(value uint32) {
	volatile.StoreUint32(&o.DEC_STATUS.Reg, volatile.LoadUint32(&o.DEC_STATUS.Reg)&^(0xfff)|value)
}
func (o *EFUSE_Type) GetDEC_STATUS_DEC_WARNINGS() uint32 {
	return volatile.LoadUint32(&o.DEC_STATUS.Reg) & 0xfff
}

// EFUSE.DATE
func (o *EFUSE_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, value)
}
func (o *EFUSE_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg)
}

// Ethernet DMA configuration and control registers
type EMAC_DMA_Type struct {
	DMABUSMODE        volatile.Register32 // 0x0
	DMATXPOLLDEMAND   volatile.Register32 // 0x4
	DMARXPOLLDEMAND   volatile.Register32 // 0x8
	DMARXBASEADDR     volatile.Register32 // 0xC
	DMATXBASEADDR     volatile.Register32 // 0x10
	DMASTATUS         volatile.Register32 // 0x14
	DMAOPERATION_MODE volatile.Register32 // 0x18
	DMAIN_EN          volatile.Register32 // 0x1C
	DMAMISSEDFR       volatile.Register32 // 0x20
	DMARINTWDTIMER    volatile.Register32 // 0x24
	_                 [32]byte
	DMATXCURRDESC     volatile.Register32 // 0x48
	DMARXCURRDESC     volatile.Register32 // 0x4C
	DMATXCURRADDR_BUF volatile.Register32 // 0x50
	DMARXCURRADDR_BUF volatile.Register32 // 0x54
}

// EMAC_DMA.DMABUSMODE: Bus mode configuration
func (o *EMAC_DMA_Type) SetDMABUSMODE_SW_RST(value uint32) {
	volatile.StoreUint32(&o.DMABUSMODE.Reg, volatile.LoadUint32(&o.DMABUSMODE.Reg)&^(0x1)|value)
}
func (o *EMAC_DMA_Type) GetDMABUSMODE_SW_RST() uint32 {
	return volatile.LoadUint32(&o.DMABUSMODE.Reg) & 0x1
}
func (o *EMAC_DMA_Type) SetDMABUSMODE_DMA_ARB_SCH(value uint32) {
	volatile.StoreUint32(&o.DMABUSMODE.Reg, volatile.LoadUint32(&o.DMABUSMODE.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_DMA_Type) GetDMABUSMODE_DMA_ARB_SCH() uint32 {
	return (volatile.LoadUint32(&o.DMABUSMODE.Reg) & 0x2) >> 1
}
func (o *EMAC_DMA_Type) SetDMABUSMODE_DESC_SKIP_LEN(value uint32) {
	volatile.StoreUint32(&o.DMABUSMODE.Reg, volatile.LoadUint32(&o.DMABUSMODE.Reg)&^(0x7c)|value<<2)
}
func (o *EMAC_DMA_Type) GetDMABUSMODE_DESC_SKIP_LEN() uint32 {
	return (volatile.LoadUint32(&o.DMABUSMODE.Reg) & 0x7c) >> 2
}
func (o *EMAC_DMA_Type) SetDMABUSMODE_ALT_DESC_SIZE(value uint32) {
	volatile.StoreUint32(&o.DMABUSMODE.Reg, volatile.LoadUint32(&o.DMABUSMODE.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_DMA_Type) GetDMABUSMODE_ALT_DESC_SIZE() uint32 {
	return (volatile.LoadUint32(&o.DMABUSMODE.Reg) & 0x80) >> 7
}
func (o *EMAC_DMA_Type) SetDMABUSMODE_PROG_BURST_LEN(value uint32) {
	volatile.StoreUint32(&o.DMABUSMODE.Reg, volatile.LoadUint32(&o.DMABUSMODE.Reg)&^(0x3f00)|value<<8)
}
func (o *EMAC_DMA_Type) GetDMABUSMODE_PROG_BURST_LEN() uint32 {
	return (volatile.LoadUint32(&o.DMABUSMODE.Reg) & 0x3f00) >> 8
}
func (o *EMAC_DMA_Type) SetDMABUSMODE_PRI_RATIO(value uint32) {
	volatile.StoreUint32(&o.DMABUSMODE.Reg, volatile.LoadUint32(&o.DMABUSMODE.Reg)&^(0xc000)|value<<14)
}
func (o *EMAC_DMA_Type) GetDMABUSMODE_PRI_RATIO() uint32 {
	return (volatile.LoadUint32(&o.DMABUSMODE.Reg) & 0xc000) >> 14
}
func (o *EMAC_DMA_Type) SetDMABUSMODE_FIXED_BURST(value uint32) {
	volatile.StoreUint32(&o.DMABUSMODE.Reg, volatile.LoadUint32(&o.DMABUSMODE.Reg)&^(0x10000)|value<<16)
}
func (o *EMAC_DMA_Type) GetDMABUSMODE_FIXED_BURST() uint32 {
	return (volatile.LoadUint32(&o.DMABUSMODE.Reg) & 0x10000) >> 16
}
func (o *EMAC_DMA_Type) SetDMABUSMODE_RX_DMA_PBL(value uint32) {
	volatile.StoreUint32(&o.DMABUSMODE.Reg, volatile.LoadUint32(&o.DMABUSMODE.Reg)&^(0x7e0000)|value<<17)
}
func (o *EMAC_DMA_Type) GetDMABUSMODE_RX_DMA_PBL() uint32 {
	return (volatile.LoadUint32(&o.DMABUSMODE.Reg) & 0x7e0000) >> 17
}
func (o *EMAC_DMA_Type) SetDMABUSMODE_USE_SEP_PBL(value uint32) {
	volatile.StoreUint32(&o.DMABUSMODE.Reg, volatile.LoadUint32(&o.DMABUSMODE.Reg)&^(0x800000)|value<<23)
}
func (o *EMAC_DMA_Type) GetDMABUSMODE_USE_SEP_PBL() uint32 {
	return (volatile.LoadUint32(&o.DMABUSMODE.Reg) & 0x800000) >> 23
}
func (o *EMAC_DMA_Type) SetDMABUSMODE_PBLX8_MODE(value uint32) {
	volatile.StoreUint32(&o.DMABUSMODE.Reg, volatile.LoadUint32(&o.DMABUSMODE.Reg)&^(0x1000000)|value<<24)
}
func (o *EMAC_DMA_Type) GetDMABUSMODE_PBLX8_MODE() uint32 {
	return (volatile.LoadUint32(&o.DMABUSMODE.Reg) & 0x1000000) >> 24
}
func (o *EMAC_DMA_Type) SetDMABUSMODE_DMAADDRALIBEA(value uint32) {
	volatile.StoreUint32(&o.DMABUSMODE.Reg, volatile.LoadUint32(&o.DMABUSMODE.Reg)&^(0x2000000)|value<<25)
}
func (o *EMAC_DMA_Type) GetDMABUSMODE_DMAADDRALIBEA() uint32 {
	return (volatile.LoadUint32(&o.DMABUSMODE.Reg) & 0x2000000) >> 25
}
func (o *EMAC_DMA_Type) SetDMABUSMODE_DMAMIXEDBURST(value uint32) {
	volatile.StoreUint32(&o.DMABUSMODE.Reg, volatile.LoadUint32(&o.DMABUSMODE.Reg)&^(0x4000000)|value<<26)
}
func (o *EMAC_DMA_Type) GetDMABUSMODE_DMAMIXEDBURST() uint32 {
	return (volatile.LoadUint32(&o.DMABUSMODE.Reg) & 0x4000000) >> 26
}

// EMAC_DMA.DMASTATUS: State of interrupts, errors and other events
func (o *EMAC_DMA_Type) SetDMASTATUS_TRANS_INT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS.Reg, volatile.LoadUint32(&o.DMASTATUS.Reg)&^(0x1)|value)
}
func (o *EMAC_DMA_Type) GetDMASTATUS_TRANS_INT() uint32 {
	return volatile.LoadUint32(&o.DMASTATUS.Reg) & 0x1
}
func (o *EMAC_DMA_Type) SetDMASTATUS_TRANS_PROC_STOP(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS.Reg, volatile.LoadUint32(&o.DMASTATUS.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_DMA_Type) GetDMASTATUS_TRANS_PROC_STOP() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS.Reg) & 0x2) >> 1
}
func (o *EMAC_DMA_Type) SetDMASTATUS_TRANS_BUF_UNAVAIL(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS.Reg, volatile.LoadUint32(&o.DMASTATUS.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_DMA_Type) GetDMASTATUS_TRANS_BUF_UNAVAIL() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS.Reg) & 0x4) >> 2
}
func (o *EMAC_DMA_Type) SetDMASTATUS_TRANS_JABBER_TO(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS.Reg, volatile.LoadUint32(&o.DMASTATUS.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_DMA_Type) GetDMASTATUS_TRANS_JABBER_TO() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS.Reg) & 0x8) >> 3
}
func (o *EMAC_DMA_Type) SetDMASTATUS_RECV_OVFLOW(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS.Reg, volatile.LoadUint32(&o.DMASTATUS.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_DMA_Type) GetDMASTATUS_RECV_OVFLOW() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS.Reg) & 0x10) >> 4
}
func (o *EMAC_DMA_Type) SetDMASTATUS_TRANS_UNDFLOW(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS.Reg, volatile.LoadUint32(&o.DMASTATUS.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_DMA_Type) GetDMASTATUS_TRANS_UNDFLOW() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS.Reg) & 0x20) >> 5
}
func (o *EMAC_DMA_Type) SetDMASTATUS_RECV_INT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS.Reg, volatile.LoadUint32(&o.DMASTATUS.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_DMA_Type) GetDMASTATUS_RECV_INT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS.Reg) & 0x40) >> 6
}
func (o *EMAC_DMA_Type) SetDMASTATUS_RECV_BUF_UNAVAIL(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS.Reg, volatile.LoadUint32(&o.DMASTATUS.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_DMA_Type) GetDMASTATUS_RECV_BUF_UNAVAIL() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS.Reg) & 0x80) >> 7
}
func (o *EMAC_DMA_Type) SetDMASTATUS_RECV_PROC_STOP(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS.Reg, volatile.LoadUint32(&o.DMASTATUS.Reg)&^(0x100)|value<<8)
}
func (o *EMAC_DMA_Type) GetDMASTATUS_RECV_PROC_STOP() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS.Reg) & 0x100) >> 8
}
func (o *EMAC_DMA_Type) SetDMASTATUS_RECV_WDT_TO(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS.Reg, volatile.LoadUint32(&o.DMASTATUS.Reg)&^(0x200)|value<<9)
}
func (o *EMAC_DMA_Type) GetDMASTATUS_RECV_WDT_TO() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS.Reg) & 0x200) >> 9
}
func (o *EMAC_DMA_Type) SetDMASTATUS_EARLY_TRANS_INT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS.Reg, volatile.LoadUint32(&o.DMASTATUS.Reg)&^(0x400)|value<<10)
}
func (o *EMAC_DMA_Type) GetDMASTATUS_EARLY_TRANS_INT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS.Reg) & 0x400) >> 10
}
func (o *EMAC_DMA_Type) SetDMASTATUS_FATAL_BUS_ERR_INT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS.Reg, volatile.LoadUint32(&o.DMASTATUS.Reg)&^(0x2000)|value<<13)
}
func (o *EMAC_DMA_Type) GetDMASTATUS_FATAL_BUS_ERR_INT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS.Reg) & 0x2000) >> 13
}
func (o *EMAC_DMA_Type) SetDMASTATUS_EARLY_RECV_INT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS.Reg, volatile.LoadUint32(&o.DMASTATUS.Reg)&^(0x4000)|value<<14)
}
func (o *EMAC_DMA_Type) GetDMASTATUS_EARLY_RECV_INT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS.Reg) & 0x4000) >> 14
}
func (o *EMAC_DMA_Type) SetDMASTATUS_ABN_INT_SUMM(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS.Reg, volatile.LoadUint32(&o.DMASTATUS.Reg)&^(0x8000)|value<<15)
}
func (o *EMAC_DMA_Type) GetDMASTATUS_ABN_INT_SUMM() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS.Reg) & 0x8000) >> 15
}
func (o *EMAC_DMA_Type) SetDMASTATUS_NORM_INT_SUMM(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS.Reg, volatile.LoadUint32(&o.DMASTATUS.Reg)&^(0x10000)|value<<16)
}
func (o *EMAC_DMA_Type) GetDMASTATUS_NORM_INT_SUMM() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS.Reg) & 0x10000) >> 16
}
func (o *EMAC_DMA_Type) SetDMASTATUS_RECV_PROC_STATE(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS.Reg, volatile.LoadUint32(&o.DMASTATUS.Reg)&^(0xe0000)|value<<17)
}
func (o *EMAC_DMA_Type) GetDMASTATUS_RECV_PROC_STATE() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS.Reg) & 0xe0000) >> 17
}
func (o *EMAC_DMA_Type) SetDMASTATUS_TRANS_PROC_STATE(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS.Reg, volatile.LoadUint32(&o.DMASTATUS.Reg)&^(0x700000)|value<<20)
}
func (o *EMAC_DMA_Type) GetDMASTATUS_TRANS_PROC_STATE() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS.Reg) & 0x700000) >> 20
}
func (o *EMAC_DMA_Type) SetDMASTATUS_ERROR_BITS(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS.Reg, volatile.LoadUint32(&o.DMASTATUS.Reg)&^(0x3800000)|value<<23)
}
func (o *EMAC_DMA_Type) GetDMASTATUS_ERROR_BITS() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS.Reg) & 0x3800000) >> 23
}
func (o *EMAC_DMA_Type) SetDMASTATUS_PMT_INT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS.Reg, volatile.LoadUint32(&o.DMASTATUS.Reg)&^(0x10000000)|value<<28)
}
func (o *EMAC_DMA_Type) GetDMASTATUS_PMT_INT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS.Reg) & 0x10000000) >> 28
}
func (o *EMAC_DMA_Type) SetDMASTATUS_TS_TRI_INT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS.Reg, volatile.LoadUint32(&o.DMASTATUS.Reg)&^(0x20000000)|value<<29)
}
func (o *EMAC_DMA_Type) GetDMASTATUS_TS_TRI_INT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS.Reg) & 0x20000000) >> 29
}

// EMAC_DMA.DMAOPERATION_MODE: Receive and Transmit operating modes and command
func (o *EMAC_DMA_Type) SetDMAOPERATION_MODE_START_STOP_RX(value uint32) {
	volatile.StoreUint32(&o.DMAOPERATION_MODE.Reg, volatile.LoadUint32(&o.DMAOPERATION_MODE.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_DMA_Type) GetDMAOPERATION_MODE_START_STOP_RX() uint32 {
	return (volatile.LoadUint32(&o.DMAOPERATION_MODE.Reg) & 0x2) >> 1
}
func (o *EMAC_DMA_Type) SetDMAOPERATION_MODE_OPT_SECOND_FRAME(value uint32) {
	volatile.StoreUint32(&o.DMAOPERATION_MODE.Reg, volatile.LoadUint32(&o.DMAOPERATION_MODE.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_DMA_Type) GetDMAOPERATION_MODE_OPT_SECOND_FRAME() uint32 {
	return (volatile.LoadUint32(&o.DMAOPERATION_MODE.Reg) & 0x4) >> 2
}
func (o *EMAC_DMA_Type) SetDMAOPERATION_MODE_RX_THRESH_CTRL(value uint32) {
	volatile.StoreUint32(&o.DMAOPERATION_MODE.Reg, volatile.LoadUint32(&o.DMAOPERATION_MODE.Reg)&^(0x18)|value<<3)
}
func (o *EMAC_DMA_Type) GetDMAOPERATION_MODE_RX_THRESH_CTRL() uint32 {
	return (volatile.LoadUint32(&o.DMAOPERATION_MODE.Reg) & 0x18) >> 3
}
func (o *EMAC_DMA_Type) SetDMAOPERATION_MODE_DROP_GFRM(value uint32) {
	volatile.StoreUint32(&o.DMAOPERATION_MODE.Reg, volatile.LoadUint32(&o.DMAOPERATION_MODE.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_DMA_Type) GetDMAOPERATION_MODE_DROP_GFRM() uint32 {
	return (volatile.LoadUint32(&o.DMAOPERATION_MODE.Reg) & 0x20) >> 5
}
func (o *EMAC_DMA_Type) SetDMAOPERATION_MODE_FWD_UNDER_GF(value uint32) {
	volatile.StoreUint32(&o.DMAOPERATION_MODE.Reg, volatile.LoadUint32(&o.DMAOPERATION_MODE.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_DMA_Type) GetDMAOPERATION_MODE_FWD_UNDER_GF() uint32 {
	return (volatile.LoadUint32(&o.DMAOPERATION_MODE.Reg) & 0x40) >> 6
}
func (o *EMAC_DMA_Type) SetDMAOPERATION_MODE_FWD_ERR_FRAME(value uint32) {
	volatile.StoreUint32(&o.DMAOPERATION_MODE.Reg, volatile.LoadUint32(&o.DMAOPERATION_MODE.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_DMA_Type) GetDMAOPERATION_MODE_FWD_ERR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.DMAOPERATION_MODE.Reg) & 0x80) >> 7
}
func (o *EMAC_DMA_Type) SetDMAOPERATION_MODE_START_STOP_TRANSMISSION_COMMAND(value uint32) {
	volatile.StoreUint32(&o.DMAOPERATION_MODE.Reg, volatile.LoadUint32(&o.DMAOPERATION_MODE.Reg)&^(0x2000)|value<<13)
}
func (o *EMAC_DMA_Type) GetDMAOPERATION_MODE_START_STOP_TRANSMISSION_COMMAND() uint32 {
	return (volatile.LoadUint32(&o.DMAOPERATION_MODE.Reg) & 0x2000) >> 13
}
func (o *EMAC_DMA_Type) SetDMAOPERATION_MODE_TX_THRESH_CTRL(value uint32) {
	volatile.StoreUint32(&o.DMAOPERATION_MODE.Reg, volatile.LoadUint32(&o.DMAOPERATION_MODE.Reg)&^(0x1c000)|value<<14)
}
func (o *EMAC_DMA_Type) GetDMAOPERATION_MODE_TX_THRESH_CTRL() uint32 {
	return (volatile.LoadUint32(&o.DMAOPERATION_MODE.Reg) & 0x1c000) >> 14
}
func (o *EMAC_DMA_Type) SetDMAOPERATION_MODE_FLUSH_TX_FIFO(value uint32) {
	volatile.StoreUint32(&o.DMAOPERATION_MODE.Reg, volatile.LoadUint32(&o.DMAOPERATION_MODE.Reg)&^(0x100000)|value<<20)
}
func (o *EMAC_DMA_Type) GetDMAOPERATION_MODE_FLUSH_TX_FIFO() uint32 {
	return (volatile.LoadUint32(&o.DMAOPERATION_MODE.Reg) & 0x100000) >> 20
}
func (o *EMAC_DMA_Type) SetDMAOPERATION_MODE_TX_STR_FWD(value uint32) {
	volatile.StoreUint32(&o.DMAOPERATION_MODE.Reg, volatile.LoadUint32(&o.DMAOPERATION_MODE.Reg)&^(0x200000)|value<<21)
}
func (o *EMAC_DMA_Type) GetDMAOPERATION_MODE_TX_STR_FWD() uint32 {
	return (volatile.LoadUint32(&o.DMAOPERATION_MODE.Reg) & 0x200000) >> 21
}
func (o *EMAC_DMA_Type) SetDMAOPERATION_MODE_DIS_FLUSH_RECV_FRAMES(value uint32) {
	volatile.StoreUint32(&o.DMAOPERATION_MODE.Reg, volatile.LoadUint32(&o.DMAOPERATION_MODE.Reg)&^(0x1000000)|value<<24)
}
func (o *EMAC_DMA_Type) GetDMAOPERATION_MODE_DIS_FLUSH_RECV_FRAMES() uint32 {
	return (volatile.LoadUint32(&o.DMAOPERATION_MODE.Reg) & 0x1000000) >> 24
}
func (o *EMAC_DMA_Type) SetDMAOPERATION_MODE_RX_STORE_FORWARD(value uint32) {
	volatile.StoreUint32(&o.DMAOPERATION_MODE.Reg, volatile.LoadUint32(&o.DMAOPERATION_MODE.Reg)&^(0x2000000)|value<<25)
}
func (o *EMAC_DMA_Type) GetDMAOPERATION_MODE_RX_STORE_FORWARD() uint32 {
	return (volatile.LoadUint32(&o.DMAOPERATION_MODE.Reg) & 0x2000000) >> 25
}
func (o *EMAC_DMA_Type) SetDMAOPERATION_MODE_DIS_DROP_TCPIP_ERR_FRAM(value uint32) {
	volatile.StoreUint32(&o.DMAOPERATION_MODE.Reg, volatile.LoadUint32(&o.DMAOPERATION_MODE.Reg)&^(0x4000000)|value<<26)
}
func (o *EMAC_DMA_Type) GetDMAOPERATION_MODE_DIS_DROP_TCPIP_ERR_FRAM() uint32 {
	return (volatile.LoadUint32(&o.DMAOPERATION_MODE.Reg) & 0x4000000) >> 26
}

// EMAC_DMA.DMAIN_EN
func (o *EMAC_DMA_Type) SetDMAIN_EN_DMAIN_TIE(value uint32) {
	volatile.StoreUint32(&o.DMAIN_EN.Reg, volatile.LoadUint32(&o.DMAIN_EN.Reg)&^(0x1)|value)
}
func (o *EMAC_DMA_Type) GetDMAIN_EN_DMAIN_TIE() uint32 {
	return volatile.LoadUint32(&o.DMAIN_EN.Reg) & 0x1
}
func (o *EMAC_DMA_Type) SetDMAIN_EN_DMAIN_TSE(value uint32) {
	volatile.StoreUint32(&o.DMAIN_EN.Reg, volatile.LoadUint32(&o.DMAIN_EN.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_DMA_Type) GetDMAIN_EN_DMAIN_TSE() uint32 {
	return (volatile.LoadUint32(&o.DMAIN_EN.Reg) & 0x2) >> 1
}
func (o *EMAC_DMA_Type) SetDMAIN_EN_DMAIN_TBUE(value uint32) {
	volatile.StoreUint32(&o.DMAIN_EN.Reg, volatile.LoadUint32(&o.DMAIN_EN.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_DMA_Type) GetDMAIN_EN_DMAIN_TBUE() uint32 {
	return (volatile.LoadUint32(&o.DMAIN_EN.Reg) & 0x4) >> 2
}
func (o *EMAC_DMA_Type) SetDMAIN_EN_DMAIN_TJTE(value uint32) {
	volatile.StoreUint32(&o.DMAIN_EN.Reg, volatile.LoadUint32(&o.DMAIN_EN.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_DMA_Type) GetDMAIN_EN_DMAIN_TJTE() uint32 {
	return (volatile.LoadUint32(&o.DMAIN_EN.Reg) & 0x8) >> 3
}
func (o *EMAC_DMA_Type) SetDMAIN_EN_DMAIN_OIE(value uint32) {
	volatile.StoreUint32(&o.DMAIN_EN.Reg, volatile.LoadUint32(&o.DMAIN_EN.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_DMA_Type) GetDMAIN_EN_DMAIN_OIE() uint32 {
	return (volatile.LoadUint32(&o.DMAIN_EN.Reg) & 0x10) >> 4
}
func (o *EMAC_DMA_Type) SetDMAIN_EN_DMAIN_UIE(value uint32) {
	volatile.StoreUint32(&o.DMAIN_EN.Reg, volatile.LoadUint32(&o.DMAIN_EN.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_DMA_Type) GetDMAIN_EN_DMAIN_UIE() uint32 {
	return (volatile.LoadUint32(&o.DMAIN_EN.Reg) & 0x20) >> 5
}
func (o *EMAC_DMA_Type) SetDMAIN_EN_DMAIN_RIE(value uint32) {
	volatile.StoreUint32(&o.DMAIN_EN.Reg, volatile.LoadUint32(&o.DMAIN_EN.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_DMA_Type) GetDMAIN_EN_DMAIN_RIE() uint32 {
	return (volatile.LoadUint32(&o.DMAIN_EN.Reg) & 0x40) >> 6
}
func (o *EMAC_DMA_Type) SetDMAIN_EN_DMAIN_RBUE(value uint32) {
	volatile.StoreUint32(&o.DMAIN_EN.Reg, volatile.LoadUint32(&o.DMAIN_EN.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_DMA_Type) GetDMAIN_EN_DMAIN_RBUE() uint32 {
	return (volatile.LoadUint32(&o.DMAIN_EN.Reg) & 0x80) >> 7
}
func (o *EMAC_DMA_Type) SetDMAIN_EN_DMAIN_RSE(value uint32) {
	volatile.StoreUint32(&o.DMAIN_EN.Reg, volatile.LoadUint32(&o.DMAIN_EN.Reg)&^(0x100)|value<<8)
}
func (o *EMAC_DMA_Type) GetDMAIN_EN_DMAIN_RSE() uint32 {
	return (volatile.LoadUint32(&o.DMAIN_EN.Reg) & 0x100) >> 8
}
func (o *EMAC_DMA_Type) SetDMAIN_EN_DMAIN_RWTE(value uint32) {
	volatile.StoreUint32(&o.DMAIN_EN.Reg, volatile.LoadUint32(&o.DMAIN_EN.Reg)&^(0x200)|value<<9)
}
func (o *EMAC_DMA_Type) GetDMAIN_EN_DMAIN_RWTE() uint32 {
	return (volatile.LoadUint32(&o.DMAIN_EN.Reg) & 0x200) >> 9
}
func (o *EMAC_DMA_Type) SetDMAIN_EN_DMAIN_ETIE(value uint32) {
	volatile.StoreUint32(&o.DMAIN_EN.Reg, volatile.LoadUint32(&o.DMAIN_EN.Reg)&^(0x400)|value<<10)
}
func (o *EMAC_DMA_Type) GetDMAIN_EN_DMAIN_ETIE() uint32 {
	return (volatile.LoadUint32(&o.DMAIN_EN.Reg) & 0x400) >> 10
}
func (o *EMAC_DMA_Type) SetDMAIN_EN_DMAIN_FBEE(value uint32) {
	volatile.StoreUint32(&o.DMAIN_EN.Reg, volatile.LoadUint32(&o.DMAIN_EN.Reg)&^(0x2000)|value<<13)
}
func (o *EMAC_DMA_Type) GetDMAIN_EN_DMAIN_FBEE() uint32 {
	return (volatile.LoadUint32(&o.DMAIN_EN.Reg) & 0x2000) >> 13
}
func (o *EMAC_DMA_Type) SetDMAIN_EN_DMAIN_ERIE(value uint32) {
	volatile.StoreUint32(&o.DMAIN_EN.Reg, volatile.LoadUint32(&o.DMAIN_EN.Reg)&^(0x4000)|value<<14)
}
func (o *EMAC_DMA_Type) GetDMAIN_EN_DMAIN_ERIE() uint32 {
	return (volatile.LoadUint32(&o.DMAIN_EN.Reg) & 0x4000) >> 14
}
func (o *EMAC_DMA_Type) SetDMAIN_EN_DMAIN_AISE(value uint32) {
	volatile.StoreUint32(&o.DMAIN_EN.Reg, volatile.LoadUint32(&o.DMAIN_EN.Reg)&^(0x8000)|value<<15)
}
func (o *EMAC_DMA_Type) GetDMAIN_EN_DMAIN_AISE() uint32 {
	return (volatile.LoadUint32(&o.DMAIN_EN.Reg) & 0x8000) >> 15
}
func (o *EMAC_DMA_Type) SetDMAIN_EN_DMAIN_NISE(value uint32) {
	volatile.StoreUint32(&o.DMAIN_EN.Reg, volatile.LoadUint32(&o.DMAIN_EN.Reg)&^(0x10000)|value<<16)
}
func (o *EMAC_DMA_Type) GetDMAIN_EN_DMAIN_NISE() uint32 {
	return (volatile.LoadUint32(&o.DMAIN_EN.Reg) & 0x10000) >> 16
}

// EMAC_DMA.DMAMISSEDFR: Missed Frame and Buffer Overflow Counter Register
func (o *EMAC_DMA_Type) SetDMAMISSEDFR_MISSED_FC(value uint32) {
	volatile.StoreUint32(&o.DMAMISSEDFR.Reg, volatile.LoadUint32(&o.DMAMISSEDFR.Reg)&^(0xffff)|value)
}
func (o *EMAC_DMA_Type) GetDMAMISSEDFR_MISSED_FC() uint32 {
	return volatile.LoadUint32(&o.DMAMISSEDFR.Reg) & 0xffff
}
func (o *EMAC_DMA_Type) SetDMAMISSEDFR_OVERFLOW_BMFC(value uint32) {
	volatile.StoreUint32(&o.DMAMISSEDFR.Reg, volatile.LoadUint32(&o.DMAMISSEDFR.Reg)&^(0x10000)|value<<16)
}
func (o *EMAC_DMA_Type) GetDMAMISSEDFR_OVERFLOW_BMFC() uint32 {
	return (volatile.LoadUint32(&o.DMAMISSEDFR.Reg) & 0x10000) >> 16
}
func (o *EMAC_DMA_Type) SetDMAMISSEDFR_OVERFLOW_FC(value uint32) {
	volatile.StoreUint32(&o.DMAMISSEDFR.Reg, volatile.LoadUint32(&o.DMAMISSEDFR.Reg)&^(0xffe0000)|value<<17)
}
func (o *EMAC_DMA_Type) GetDMAMISSEDFR_OVERFLOW_FC() uint32 {
	return (volatile.LoadUint32(&o.DMAMISSEDFR.Reg) & 0xffe0000) >> 17
}
func (o *EMAC_DMA_Type) SetDMAMISSEDFR_OVERFLOW_BFOC(value uint32) {
	volatile.StoreUint32(&o.DMAMISSEDFR.Reg, volatile.LoadUint32(&o.DMAMISSEDFR.Reg)&^(0x10000000)|value<<28)
}
func (o *EMAC_DMA_Type) GetDMAMISSEDFR_OVERFLOW_BFOC() uint32 {
	return (volatile.LoadUint32(&o.DMAMISSEDFR.Reg) & 0x10000000) >> 28
}

// EMAC_DMA.DMARINTWDTIMER: Watchdog timer count on receive
func (o *EMAC_DMA_Type) SetDMARINTWDTIMER_RIWTC(value uint32) {
	volatile.StoreUint32(&o.DMARINTWDTIMER.Reg, volatile.LoadUint32(&o.DMARINTWDTIMER.Reg)&^(0xff)|value)
}
func (o *EMAC_DMA_Type) GetDMARINTWDTIMER_RIWTC() uint32 {
	return volatile.LoadUint32(&o.DMARINTWDTIMER.Reg) & 0xff
}

// Ethernet Clock, PHY type, and SRAM configuration registers
type EMAC_EXT_Type struct {
	EX_CLKOUT_CONF volatile.Register32 // 0x0
	EX_OSCCLK_CONF volatile.Register32 // 0x4
	EX_CLK_CTRL    volatile.Register32 // 0x8
	EX_PHYINF_CONF volatile.Register32 // 0xC
	PD_SEL         volatile.Register32 // 0x10
	_              [232]byte
	EX_DATE        volatile.Register32 // 0xFC
}

// EMAC_EXT.EX_CLKOUT_CONF: RMII clock divider setting
func (o *EMAC_EXT_Type) SetEX_CLKOUT_CONF_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.EX_CLKOUT_CONF.Reg, volatile.LoadUint32(&o.EX_CLKOUT_CONF.Reg)&^(0xf)|value)
}
func (o *EMAC_EXT_Type) GetEX_CLKOUT_CONF_DIV_NUM() uint32 {
	return volatile.LoadUint32(&o.EX_CLKOUT_CONF.Reg) & 0xf
}
func (o *EMAC_EXT_Type) SetEX_CLKOUT_CONF_H_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.EX_CLKOUT_CONF.Reg, volatile.LoadUint32(&o.EX_CLKOUT_CONF.Reg)&^(0xf0)|value<<4)
}
func (o *EMAC_EXT_Type) GetEX_CLKOUT_CONF_H_DIV_NUM() uint32 {
	return (volatile.LoadUint32(&o.EX_CLKOUT_CONF.Reg) & 0xf0) >> 4
}
func (o *EMAC_EXT_Type) SetEX_CLKOUT_CONF_DLY_NUM(value uint32) {
	volatile.StoreUint32(&o.EX_CLKOUT_CONF.Reg, volatile.LoadUint32(&o.EX_CLKOUT_CONF.Reg)&^(0x300)|value<<8)
}
func (o *EMAC_EXT_Type) GetEX_CLKOUT_CONF_DLY_NUM() uint32 {
	return (volatile.LoadUint32(&o.EX_CLKOUT_CONF.Reg) & 0x300) >> 8
}

// EMAC_EXT.EX_OSCCLK_CONF: RMII clock half and whole divider settings
func (o *EMAC_EXT_Type) SetEX_OSCCLK_CONF_DIV_NUM_10M(value uint32) {
	volatile.StoreUint32(&o.EX_OSCCLK_CONF.Reg, volatile.LoadUint32(&o.EX_OSCCLK_CONF.Reg)&^(0x3f)|value)
}
func (o *EMAC_EXT_Type) GetEX_OSCCLK_CONF_DIV_NUM_10M() uint32 {
	return volatile.LoadUint32(&o.EX_OSCCLK_CONF.Reg) & 0x3f
}
func (o *EMAC_EXT_Type) SetEX_OSCCLK_CONF_H_DIV_NUM_10M(value uint32) {
	volatile.StoreUint32(&o.EX_OSCCLK_CONF.Reg, volatile.LoadUint32(&o.EX_OSCCLK_CONF.Reg)&^(0xfc0)|value<<6)
}
func (o *EMAC_EXT_Type) GetEX_OSCCLK_CONF_H_DIV_NUM_10M() uint32 {
	return (volatile.LoadUint32(&o.EX_OSCCLK_CONF.Reg) & 0xfc0) >> 6
}
func (o *EMAC_EXT_Type) SetEX_OSCCLK_CONF_DIV_NUM_100M(value uint32) {
	volatile.StoreUint32(&o.EX_OSCCLK_CONF.Reg, volatile.LoadUint32(&o.EX_OSCCLK_CONF.Reg)&^(0x3f000)|value<<12)
}
func (o *EMAC_EXT_Type) GetEX_OSCCLK_CONF_DIV_NUM_100M() uint32 {
	return (volatile.LoadUint32(&o.EX_OSCCLK_CONF.Reg) & 0x3f000) >> 12
}
func (o *EMAC_EXT_Type) SetEX_OSCCLK_CONF_H_DIV_NUM_100M(value uint32) {
	volatile.StoreUint32(&o.EX_OSCCLK_CONF.Reg, volatile.LoadUint32(&o.EX_OSCCLK_CONF.Reg)&^(0xfc0000)|value<<18)
}
func (o *EMAC_EXT_Type) GetEX_OSCCLK_CONF_H_DIV_NUM_100M() uint32 {
	return (volatile.LoadUint32(&o.EX_OSCCLK_CONF.Reg) & 0xfc0000) >> 18
}
func (o *EMAC_EXT_Type) SetEX_OSCCLK_CONF_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.EX_OSCCLK_CONF.Reg, volatile.LoadUint32(&o.EX_OSCCLK_CONF.Reg)&^(0x1000000)|value<<24)
}
func (o *EMAC_EXT_Type) GetEX_OSCCLK_CONF_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.EX_OSCCLK_CONF.Reg) & 0x1000000) >> 24
}

// EMAC_EXT.EX_CLK_CTRL: Clock enable and external/internal clock selection
func (o *EMAC_EXT_Type) SetEX_CLK_CTRL_EXT_EN(value uint32) {
	volatile.StoreUint32(&o.EX_CLK_CTRL.Reg, volatile.LoadUint32(&o.EX_CLK_CTRL.Reg)&^(0x1)|value)
}
func (o *EMAC_EXT_Type) GetEX_CLK_CTRL_EXT_EN() uint32 {
	return volatile.LoadUint32(&o.EX_CLK_CTRL.Reg) & 0x1
}
func (o *EMAC_EXT_Type) SetEX_CLK_CTRL_INT_EN(value uint32) {
	volatile.StoreUint32(&o.EX_CLK_CTRL.Reg, volatile.LoadUint32(&o.EX_CLK_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_EXT_Type) GetEX_CLK_CTRL_INT_EN() uint32 {
	return (volatile.LoadUint32(&o.EX_CLK_CTRL.Reg) & 0x2) >> 1
}
func (o *EMAC_EXT_Type) SetEX_CLK_CTRL_RX_125_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.EX_CLK_CTRL.Reg, volatile.LoadUint32(&o.EX_CLK_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_EXT_Type) GetEX_CLK_CTRL_RX_125_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.EX_CLK_CTRL.Reg) & 0x4) >> 2
}
func (o *EMAC_EXT_Type) SetEX_CLK_CTRL_MII_CLK_TX_EN(value uint32) {
	volatile.StoreUint32(&o.EX_CLK_CTRL.Reg, volatile.LoadUint32(&o.EX_CLK_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_EXT_Type) GetEX_CLK_CTRL_MII_CLK_TX_EN() uint32 {
	return (volatile.LoadUint32(&o.EX_CLK_CTRL.Reg) & 0x8) >> 3
}
func (o *EMAC_EXT_Type) SetEX_CLK_CTRL_MII_CLK_RX_EN(value uint32) {
	volatile.StoreUint32(&o.EX_CLK_CTRL.Reg, volatile.LoadUint32(&o.EX_CLK_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_EXT_Type) GetEX_CLK_CTRL_MII_CLK_RX_EN() uint32 {
	return (volatile.LoadUint32(&o.EX_CLK_CTRL.Reg) & 0x10) >> 4
}
func (o *EMAC_EXT_Type) SetEX_CLK_CTRL_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.EX_CLK_CTRL.Reg, volatile.LoadUint32(&o.EX_CLK_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_EXT_Type) GetEX_CLK_CTRL_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.EX_CLK_CTRL.Reg) & 0x20) >> 5
}

// EMAC_EXT.EX_PHYINF_CONF: Selection of MII/RMII phy
func (o *EMAC_EXT_Type) SetEX_PHYINF_CONF_INT_REVMII_RX_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.EX_PHYINF_CONF.Reg, volatile.LoadUint32(&o.EX_PHYINF_CONF.Reg)&^(0x1)|value)
}
func (o *EMAC_EXT_Type) GetEX_PHYINF_CONF_INT_REVMII_RX_CLK_SEL() uint32 {
	return volatile.LoadUint32(&o.EX_PHYINF_CONF.Reg) & 0x1
}
func (o *EMAC_EXT_Type) SetEX_PHYINF_CONF_EXT_REVMII_RX_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.EX_PHYINF_CONF.Reg, volatile.LoadUint32(&o.EX_PHYINF_CONF.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_EXT_Type) GetEX_PHYINF_CONF_EXT_REVMII_RX_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.EX_PHYINF_CONF.Reg) & 0x2) >> 1
}
func (o *EMAC_EXT_Type) SetEX_PHYINF_CONF_SBD_FLOWCTRL(value uint32) {
	volatile.StoreUint32(&o.EX_PHYINF_CONF.Reg, volatile.LoadUint32(&o.EX_PHYINF_CONF.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_EXT_Type) GetEX_PHYINF_CONF_SBD_FLOWCTRL() uint32 {
	return (volatile.LoadUint32(&o.EX_PHYINF_CONF.Reg) & 0x4) >> 2
}
func (o *EMAC_EXT_Type) SetEX_PHYINF_CONF_CORE_PHY_ADDR(value uint32) {
	volatile.StoreUint32(&o.EX_PHYINF_CONF.Reg, volatile.LoadUint32(&o.EX_PHYINF_CONF.Reg)&^(0xf8)|value<<3)
}
func (o *EMAC_EXT_Type) GetEX_PHYINF_CONF_CORE_PHY_ADDR() uint32 {
	return (volatile.LoadUint32(&o.EX_PHYINF_CONF.Reg) & 0xf8) >> 3
}
func (o *EMAC_EXT_Type) SetEX_PHYINF_CONF_REVMII_PHY_ADDR(value uint32) {
	volatile.StoreUint32(&o.EX_PHYINF_CONF.Reg, volatile.LoadUint32(&o.EX_PHYINF_CONF.Reg)&^(0x1f00)|value<<8)
}
func (o *EMAC_EXT_Type) GetEX_PHYINF_CONF_REVMII_PHY_ADDR() uint32 {
	return (volatile.LoadUint32(&o.EX_PHYINF_CONF.Reg) & 0x1f00) >> 8
}
func (o *EMAC_EXT_Type) SetEX_PHYINF_CONF_PHY_INTF_SEL(value uint32) {
	volatile.StoreUint32(&o.EX_PHYINF_CONF.Reg, volatile.LoadUint32(&o.EX_PHYINF_CONF.Reg)&^(0xe000)|value<<13)
}
func (o *EMAC_EXT_Type) GetEX_PHYINF_CONF_PHY_INTF_SEL() uint32 {
	return (volatile.LoadUint32(&o.EX_PHYINF_CONF.Reg) & 0xe000) >> 13
}
func (o *EMAC_EXT_Type) SetEX_PHYINF_CONF_SS_MODE(value uint32) {
	volatile.StoreUint32(&o.EX_PHYINF_CONF.Reg, volatile.LoadUint32(&o.EX_PHYINF_CONF.Reg)&^(0x10000)|value<<16)
}
func (o *EMAC_EXT_Type) GetEX_PHYINF_CONF_SS_MODE() uint32 {
	return (volatile.LoadUint32(&o.EX_PHYINF_CONF.Reg) & 0x10000) >> 16
}
func (o *EMAC_EXT_Type) SetEX_PHYINF_CONF_SBD_CLK_GATING_EN(value uint32) {
	volatile.StoreUint32(&o.EX_PHYINF_CONF.Reg, volatile.LoadUint32(&o.EX_PHYINF_CONF.Reg)&^(0x20000)|value<<17)
}
func (o *EMAC_EXT_Type) GetEX_PHYINF_CONF_SBD_CLK_GATING_EN() uint32 {
	return (volatile.LoadUint32(&o.EX_PHYINF_CONF.Reg) & 0x20000) >> 17
}
func (o *EMAC_EXT_Type) SetEX_PHYINF_CONF_PMT_CTRL_EN(value uint32) {
	volatile.StoreUint32(&o.EX_PHYINF_CONF.Reg, volatile.LoadUint32(&o.EX_PHYINF_CONF.Reg)&^(0x40000)|value<<18)
}
func (o *EMAC_EXT_Type) GetEX_PHYINF_CONF_PMT_CTRL_EN() uint32 {
	return (volatile.LoadUint32(&o.EX_PHYINF_CONF.Reg) & 0x40000) >> 18
}
func (o *EMAC_EXT_Type) SetEX_PHYINF_CONF_SCR_SMI_DLY_RX_SYNC(value uint32) {
	volatile.StoreUint32(&o.EX_PHYINF_CONF.Reg, volatile.LoadUint32(&o.EX_PHYINF_CONF.Reg)&^(0x80000)|value<<19)
}
func (o *EMAC_EXT_Type) GetEX_PHYINF_CONF_SCR_SMI_DLY_RX_SYNC() uint32 {
	return (volatile.LoadUint32(&o.EX_PHYINF_CONF.Reg) & 0x80000) >> 19
}
func (o *EMAC_EXT_Type) SetEX_PHYINF_CONF_TX_ERR_OUT_EN(value uint32) {
	volatile.StoreUint32(&o.EX_PHYINF_CONF.Reg, volatile.LoadUint32(&o.EX_PHYINF_CONF.Reg)&^(0x100000)|value<<20)
}
func (o *EMAC_EXT_Type) GetEX_PHYINF_CONF_TX_ERR_OUT_EN() uint32 {
	return (volatile.LoadUint32(&o.EX_PHYINF_CONF.Reg) & 0x100000) >> 20
}

// EMAC_EXT.PD_SEL: Ethernet RAM power-down enable
func (o *EMAC_EXT_Type) SetPD_SEL_RAM_PD_EN(value uint32) {
	volatile.StoreUint32(&o.PD_SEL.Reg, volatile.LoadUint32(&o.PD_SEL.Reg)&^(0x3)|value)
}
func (o *EMAC_EXT_Type) GetPD_SEL_RAM_PD_EN() uint32 {
	return volatile.LoadUint32(&o.PD_SEL.Reg) & 0x3
}

// Ethernet MAC configuration and control registers
type EMAC_MAC_Type struct {
	EMACCONFIG           volatile.Register32 // 0x0
	EMACFF               volatile.Register32 // 0x4
	_                    [8]byte
	EMACGMIIADDR         volatile.Register32 // 0x10
	EMACMIIDATA          volatile.Register32 // 0x14
	EMACFC               volatile.Register32 // 0x18
	_                    [8]byte
	EMACDEBUG            volatile.Register32 // 0x24
	PMT_RWUFFR           volatile.Register32 // 0x28
	PMT_CSR              volatile.Register32 // 0x2C
	EMACLPI_CRS          volatile.Register32 // 0x30
	EMACLPITIMERSCONTROL volatile.Register32 // 0x34
	EMACINTS             volatile.Register32 // 0x38
	EMACINTMASK          volatile.Register32 // 0x3C
	EMACADDR0HIGH        volatile.Register32 // 0x40
	EMACADDR0LOW         volatile.Register32 // 0x44
	EMACADDR1HIGH        volatile.Register32 // 0x48
	EMACADDR1LOW         volatile.Register32 // 0x4C
	EMACADDR2HIGH        volatile.Register32 // 0x50
	EMACADDR2LOW         volatile.Register32 // 0x54
	EMACADDR3HIGH        volatile.Register32 // 0x58
	EMACADDR3LOW         volatile.Register32 // 0x5C
	EMACADDR4HIGH        volatile.Register32 // 0x60
	EMACADDR4LOW         volatile.Register32 // 0x64
	EMACADDR5HIGH        volatile.Register32 // 0x68
	EMACADDR5LOW         volatile.Register32 // 0x6C
	EMACADDR6HIGH        volatile.Register32 // 0x70
	EMACADDR6LOW         volatile.Register32 // 0x74
	EMACADDR7HIGH        volatile.Register32 // 0x78
	EMACADDR7LOW         volatile.Register32 // 0x7C
	_                    [88]byte
	EMACCSTATUS          volatile.Register32 // 0xD8
	EMACWDOGTO           volatile.Register32 // 0xDC
}

// EMAC_MAC.EMACCONFIG: MAC configuration
func (o *EMAC_MAC_Type) SetEMACCONFIG_PLTF(value uint32) {
	volatile.StoreUint32(&o.EMACCONFIG.Reg, volatile.LoadUint32(&o.EMACCONFIG.Reg)&^(0x3)|value)
}
func (o *EMAC_MAC_Type) GetEMACCONFIG_PLTF() uint32 {
	return volatile.LoadUint32(&o.EMACCONFIG.Reg) & 0x3
}
func (o *EMAC_MAC_Type) SetEMACCONFIG_RX(value uint32) {
	volatile.StoreUint32(&o.EMACCONFIG.Reg, volatile.LoadUint32(&o.EMACCONFIG.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_MAC_Type) GetEMACCONFIG_RX() uint32 {
	return (volatile.LoadUint32(&o.EMACCONFIG.Reg) & 0x4) >> 2
}
func (o *EMAC_MAC_Type) SetEMACCONFIG_TX(value uint32) {
	volatile.StoreUint32(&o.EMACCONFIG.Reg, volatile.LoadUint32(&o.EMACCONFIG.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_MAC_Type) GetEMACCONFIG_TX() uint32 {
	return (volatile.LoadUint32(&o.EMACCONFIG.Reg) & 0x8) >> 3
}
func (o *EMAC_MAC_Type) SetEMACCONFIG_DEFERRALCHECK(value uint32) {
	volatile.StoreUint32(&o.EMACCONFIG.Reg, volatile.LoadUint32(&o.EMACCONFIG.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_MAC_Type) GetEMACCONFIG_DEFERRALCHECK() uint32 {
	return (volatile.LoadUint32(&o.EMACCONFIG.Reg) & 0x10) >> 4
}
func (o *EMAC_MAC_Type) SetEMACCONFIG_BACKOFFLIMIT(value uint32) {
	volatile.StoreUint32(&o.EMACCONFIG.Reg, volatile.LoadUint32(&o.EMACCONFIG.Reg)&^(0x60)|value<<5)
}
func (o *EMAC_MAC_Type) GetEMACCONFIG_BACKOFFLIMIT() uint32 {
	return (volatile.LoadUint32(&o.EMACCONFIG.Reg) & 0x60) >> 5
}
func (o *EMAC_MAC_Type) SetEMACCONFIG_PADCRCSTRIP(value uint32) {
	volatile.StoreUint32(&o.EMACCONFIG.Reg, volatile.LoadUint32(&o.EMACCONFIG.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_MAC_Type) GetEMACCONFIG_PADCRCSTRIP() uint32 {
	return (volatile.LoadUint32(&o.EMACCONFIG.Reg) & 0x80) >> 7
}
func (o *EMAC_MAC_Type) SetEMACCONFIG_RETRY(value uint32) {
	volatile.StoreUint32(&o.EMACCONFIG.Reg, volatile.LoadUint32(&o.EMACCONFIG.Reg)&^(0x200)|value<<9)
}
func (o *EMAC_MAC_Type) GetEMACCONFIG_RETRY() uint32 {
	return (volatile.LoadUint32(&o.EMACCONFIG.Reg) & 0x200) >> 9
}
func (o *EMAC_MAC_Type) SetEMACCONFIG_RXIPCOFFLOAD(value uint32) {
	volatile.StoreUint32(&o.EMACCONFIG.Reg, volatile.LoadUint32(&o.EMACCONFIG.Reg)&^(0x400)|value<<10)
}
func (o *EMAC_MAC_Type) GetEMACCONFIG_RXIPCOFFLOAD() uint32 {
	return (volatile.LoadUint32(&o.EMACCONFIG.Reg) & 0x400) >> 10
}
func (o *EMAC_MAC_Type) SetEMACCONFIG_DUPLEX(value uint32) {
	volatile.StoreUint32(&o.EMACCONFIG.Reg, volatile.LoadUint32(&o.EMACCONFIG.Reg)&^(0x800)|value<<11)
}
func (o *EMAC_MAC_Type) GetEMACCONFIG_DUPLEX() uint32 {
	return (volatile.LoadUint32(&o.EMACCONFIG.Reg) & 0x800) >> 11
}
func (o *EMAC_MAC_Type) SetEMACCONFIG_LOOPBACK(value uint32) {
	volatile.StoreUint32(&o.EMACCONFIG.Reg, volatile.LoadUint32(&o.EMACCONFIG.Reg)&^(0x1000)|value<<12)
}
func (o *EMAC_MAC_Type) GetEMACCONFIG_LOOPBACK() uint32 {
	return (volatile.LoadUint32(&o.EMACCONFIG.Reg) & 0x1000) >> 12
}
func (o *EMAC_MAC_Type) SetEMACCONFIG_RXOWN(value uint32) {
	volatile.StoreUint32(&o.EMACCONFIG.Reg, volatile.LoadUint32(&o.EMACCONFIG.Reg)&^(0x2000)|value<<13)
}
func (o *EMAC_MAC_Type) GetEMACCONFIG_RXOWN() uint32 {
	return (volatile.LoadUint32(&o.EMACCONFIG.Reg) & 0x2000) >> 13
}
func (o *EMAC_MAC_Type) SetEMACCONFIG_FESPEED(value uint32) {
	volatile.StoreUint32(&o.EMACCONFIG.Reg, volatile.LoadUint32(&o.EMACCONFIG.Reg)&^(0x4000)|value<<14)
}
func (o *EMAC_MAC_Type) GetEMACCONFIG_FESPEED() uint32 {
	return (volatile.LoadUint32(&o.EMACCONFIG.Reg) & 0x4000) >> 14
}
func (o *EMAC_MAC_Type) SetEMACCONFIG_MII(value uint32) {
	volatile.StoreUint32(&o.EMACCONFIG.Reg, volatile.LoadUint32(&o.EMACCONFIG.Reg)&^(0x8000)|value<<15)
}
func (o *EMAC_MAC_Type) GetEMACCONFIG_MII() uint32 {
	return (volatile.LoadUint32(&o.EMACCONFIG.Reg) & 0x8000) >> 15
}
func (o *EMAC_MAC_Type) SetEMACCONFIG_DISABLECRS(value uint32) {
	volatile.StoreUint32(&o.EMACCONFIG.Reg, volatile.LoadUint32(&o.EMACCONFIG.Reg)&^(0x10000)|value<<16)
}
func (o *EMAC_MAC_Type) GetEMACCONFIG_DISABLECRS() uint32 {
	return (volatile.LoadUint32(&o.EMACCONFIG.Reg) & 0x10000) >> 16
}
func (o *EMAC_MAC_Type) SetEMACCONFIG_INTERFRAMEGAP(value uint32) {
	volatile.StoreUint32(&o.EMACCONFIG.Reg, volatile.LoadUint32(&o.EMACCONFIG.Reg)&^(0xe0000)|value<<17)
}
func (o *EMAC_MAC_Type) GetEMACCONFIG_INTERFRAMEGAP() uint32 {
	return (volatile.LoadUint32(&o.EMACCONFIG.Reg) & 0xe0000) >> 17
}
func (o *EMAC_MAC_Type) SetEMACCONFIG_JUMBOFRAME(value uint32) {
	volatile.StoreUint32(&o.EMACCONFIG.Reg, volatile.LoadUint32(&o.EMACCONFIG.Reg)&^(0x100000)|value<<20)
}
func (o *EMAC_MAC_Type) GetEMACCONFIG_JUMBOFRAME() uint32 {
	return (volatile.LoadUint32(&o.EMACCONFIG.Reg) & 0x100000) >> 20
}
func (o *EMAC_MAC_Type) SetEMACCONFIG_JABBER(value uint32) {
	volatile.StoreUint32(&o.EMACCONFIG.Reg, volatile.LoadUint32(&o.EMACCONFIG.Reg)&^(0x400000)|value<<22)
}
func (o *EMAC_MAC_Type) GetEMACCONFIG_JABBER() uint32 {
	return (volatile.LoadUint32(&o.EMACCONFIG.Reg) & 0x400000) >> 22
}
func (o *EMAC_MAC_Type) SetEMACCONFIG_WATCHDOG(value uint32) {
	volatile.StoreUint32(&o.EMACCONFIG.Reg, volatile.LoadUint32(&o.EMACCONFIG.Reg)&^(0x800000)|value<<23)
}
func (o *EMAC_MAC_Type) GetEMACCONFIG_WATCHDOG() uint32 {
	return (volatile.LoadUint32(&o.EMACCONFIG.Reg) & 0x800000) >> 23
}
func (o *EMAC_MAC_Type) SetEMACCONFIG_ASS2KP(value uint32) {
	volatile.StoreUint32(&o.EMACCONFIG.Reg, volatile.LoadUint32(&o.EMACCONFIG.Reg)&^(0x8000000)|value<<27)
}
func (o *EMAC_MAC_Type) GetEMACCONFIG_ASS2KP() uint32 {
	return (volatile.LoadUint32(&o.EMACCONFIG.Reg) & 0x8000000) >> 27
}
func (o *EMAC_MAC_Type) SetEMACCONFIG_SAIRC(value uint32) {
	volatile.StoreUint32(&o.EMACCONFIG.Reg, volatile.LoadUint32(&o.EMACCONFIG.Reg)&^(0x70000000)|value<<28)
}
func (o *EMAC_MAC_Type) GetEMACCONFIG_SAIRC() uint32 {
	return (volatile.LoadUint32(&o.EMACCONFIG.Reg) & 0x70000000) >> 28
}

// EMAC_MAC.EMACFF: Frame filter settings
func (o *EMAC_MAC_Type) SetEMACFF_PMODE(value uint32) {
	volatile.StoreUint32(&o.EMACFF.Reg, volatile.LoadUint32(&o.EMACFF.Reg)&^(0x1)|value)
}
func (o *EMAC_MAC_Type) GetEMACFF_PMODE() uint32 {
	return volatile.LoadUint32(&o.EMACFF.Reg) & 0x1
}
func (o *EMAC_MAC_Type) SetEMACFF_DAIF(value uint32) {
	volatile.StoreUint32(&o.EMACFF.Reg, volatile.LoadUint32(&o.EMACFF.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_MAC_Type) GetEMACFF_DAIF() uint32 {
	return (volatile.LoadUint32(&o.EMACFF.Reg) & 0x8) >> 3
}
func (o *EMAC_MAC_Type) SetEMACFF_PAM(value uint32) {
	volatile.StoreUint32(&o.EMACFF.Reg, volatile.LoadUint32(&o.EMACFF.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_MAC_Type) GetEMACFF_PAM() uint32 {
	return (volatile.LoadUint32(&o.EMACFF.Reg) & 0x10) >> 4
}
func (o *EMAC_MAC_Type) SetEMACFF_DBF(value uint32) {
	volatile.StoreUint32(&o.EMACFF.Reg, volatile.LoadUint32(&o.EMACFF.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_MAC_Type) GetEMACFF_DBF() uint32 {
	return (volatile.LoadUint32(&o.EMACFF.Reg) & 0x20) >> 5
}
func (o *EMAC_MAC_Type) SetEMACFF_PCF(value uint32) {
	volatile.StoreUint32(&o.EMACFF.Reg, volatile.LoadUint32(&o.EMACFF.Reg)&^(0xc0)|value<<6)
}
func (o *EMAC_MAC_Type) GetEMACFF_PCF() uint32 {
	return (volatile.LoadUint32(&o.EMACFF.Reg) & 0xc0) >> 6
}
func (o *EMAC_MAC_Type) SetEMACFF_SAIF(value uint32) {
	volatile.StoreUint32(&o.EMACFF.Reg, volatile.LoadUint32(&o.EMACFF.Reg)&^(0x100)|value<<8)
}
func (o *EMAC_MAC_Type) GetEMACFF_SAIF() uint32 {
	return (volatile.LoadUint32(&o.EMACFF.Reg) & 0x100) >> 8
}
func (o *EMAC_MAC_Type) SetEMACFF_SAFE(value uint32) {
	volatile.StoreUint32(&o.EMACFF.Reg, volatile.LoadUint32(&o.EMACFF.Reg)&^(0x200)|value<<9)
}
func (o *EMAC_MAC_Type) GetEMACFF_SAFE() uint32 {
	return (volatile.LoadUint32(&o.EMACFF.Reg) & 0x200) >> 9
}
func (o *EMAC_MAC_Type) SetEMACFF_RECEIVE_ALL(value uint32) {
	volatile.StoreUint32(&o.EMACFF.Reg, volatile.LoadUint32(&o.EMACFF.Reg)&^(0x80000000)|value<<31)
}
func (o *EMAC_MAC_Type) GetEMACFF_RECEIVE_ALL() uint32 {
	return (volatile.LoadUint32(&o.EMACFF.Reg) & 0x80000000) >> 31
}

// EMAC_MAC.EMACGMIIADDR: PHY configuration access
func (o *EMAC_MAC_Type) SetEMACGMIIADDR_MIIBUSY(value uint32) {
	volatile.StoreUint32(&o.EMACGMIIADDR.Reg, volatile.LoadUint32(&o.EMACGMIIADDR.Reg)&^(0x1)|value)
}
func (o *EMAC_MAC_Type) GetEMACGMIIADDR_MIIBUSY() uint32 {
	return volatile.LoadUint32(&o.EMACGMIIADDR.Reg) & 0x1
}
func (o *EMAC_MAC_Type) SetEMACGMIIADDR_MIIWRITE(value uint32) {
	volatile.StoreUint32(&o.EMACGMIIADDR.Reg, volatile.LoadUint32(&o.EMACGMIIADDR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_MAC_Type) GetEMACGMIIADDR_MIIWRITE() uint32 {
	return (volatile.LoadUint32(&o.EMACGMIIADDR.Reg) & 0x2) >> 1
}
func (o *EMAC_MAC_Type) SetEMACGMIIADDR_MIICSRCLK(value uint32) {
	volatile.StoreUint32(&o.EMACGMIIADDR.Reg, volatile.LoadUint32(&o.EMACGMIIADDR.Reg)&^(0x3c)|value<<2)
}
func (o *EMAC_MAC_Type) GetEMACGMIIADDR_MIICSRCLK() uint32 {
	return (volatile.LoadUint32(&o.EMACGMIIADDR.Reg) & 0x3c) >> 2
}
func (o *EMAC_MAC_Type) SetEMACGMIIADDR_MIIREG(value uint32) {
	volatile.StoreUint32(&o.EMACGMIIADDR.Reg, volatile.LoadUint32(&o.EMACGMIIADDR.Reg)&^(0x7c0)|value<<6)
}
func (o *EMAC_MAC_Type) GetEMACGMIIADDR_MIIREG() uint32 {
	return (volatile.LoadUint32(&o.EMACGMIIADDR.Reg) & 0x7c0) >> 6
}
func (o *EMAC_MAC_Type) SetEMACGMIIADDR_MIIDEV(value uint32) {
	volatile.StoreUint32(&o.EMACGMIIADDR.Reg, volatile.LoadUint32(&o.EMACGMIIADDR.Reg)&^(0xf800)|value<<11)
}
func (o *EMAC_MAC_Type) GetEMACGMIIADDR_MIIDEV() uint32 {
	return (volatile.LoadUint32(&o.EMACGMIIADDR.Reg) & 0xf800) >> 11
}

// EMAC_MAC.EMACMIIDATA: PHY data read write
func (o *EMAC_MAC_Type) SetEMACMIIDATA_MII_DATA(value uint32) {
	volatile.StoreUint32(&o.EMACMIIDATA.Reg, volatile.LoadUint32(&o.EMACMIIDATA.Reg)&^(0xffff)|value)
}
func (o *EMAC_MAC_Type) GetEMACMIIDATA_MII_DATA() uint32 {
	return volatile.LoadUint32(&o.EMACMIIDATA.Reg) & 0xffff
}

// EMAC_MAC.EMACFC: Frame flow control
func (o *EMAC_MAC_Type) SetEMACFC_FCBBA(value uint32) {
	volatile.StoreUint32(&o.EMACFC.Reg, volatile.LoadUint32(&o.EMACFC.Reg)&^(0x1)|value)
}
func (o *EMAC_MAC_Type) GetEMACFC_FCBBA() uint32 {
	return volatile.LoadUint32(&o.EMACFC.Reg) & 0x1
}
func (o *EMAC_MAC_Type) SetEMACFC_TFCE(value uint32) {
	volatile.StoreUint32(&o.EMACFC.Reg, volatile.LoadUint32(&o.EMACFC.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_MAC_Type) GetEMACFC_TFCE() uint32 {
	return (volatile.LoadUint32(&o.EMACFC.Reg) & 0x2) >> 1
}
func (o *EMAC_MAC_Type) SetEMACFC_RFCE(value uint32) {
	volatile.StoreUint32(&o.EMACFC.Reg, volatile.LoadUint32(&o.EMACFC.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_MAC_Type) GetEMACFC_RFCE() uint32 {
	return (volatile.LoadUint32(&o.EMACFC.Reg) & 0x4) >> 2
}
func (o *EMAC_MAC_Type) SetEMACFC_UPFD(value uint32) {
	volatile.StoreUint32(&o.EMACFC.Reg, volatile.LoadUint32(&o.EMACFC.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_MAC_Type) GetEMACFC_UPFD() uint32 {
	return (volatile.LoadUint32(&o.EMACFC.Reg) & 0x8) >> 3
}
func (o *EMAC_MAC_Type) SetEMACFC_PLT(value uint32) {
	volatile.StoreUint32(&o.EMACFC.Reg, volatile.LoadUint32(&o.EMACFC.Reg)&^(0x30)|value<<4)
}
func (o *EMAC_MAC_Type) GetEMACFC_PLT() uint32 {
	return (volatile.LoadUint32(&o.EMACFC.Reg) & 0x30) >> 4
}
func (o *EMAC_MAC_Type) SetEMACFC_DZPQ(value uint32) {
	volatile.StoreUint32(&o.EMACFC.Reg, volatile.LoadUint32(&o.EMACFC.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_MAC_Type) GetEMACFC_DZPQ() uint32 {
	return (volatile.LoadUint32(&o.EMACFC.Reg) & 0x80) >> 7
}
func (o *EMAC_MAC_Type) SetEMACFC_PAUSE_TIME(value uint32) {
	volatile.StoreUint32(&o.EMACFC.Reg, volatile.LoadUint32(&o.EMACFC.Reg)&^(0xffff0000)|value<<16)
}
func (o *EMAC_MAC_Type) GetEMACFC_PAUSE_TIME() uint32 {
	return (volatile.LoadUint32(&o.EMACFC.Reg) & 0xffff0000) >> 16
}

// EMAC_MAC.EMACDEBUG: Status debugging bits
func (o *EMAC_MAC_Type) SetEMACDEBUG_MACRPES(value uint32) {
	volatile.StoreUint32(&o.EMACDEBUG.Reg, volatile.LoadUint32(&o.EMACDEBUG.Reg)&^(0x1)|value)
}
func (o *EMAC_MAC_Type) GetEMACDEBUG_MACRPES() uint32 {
	return volatile.LoadUint32(&o.EMACDEBUG.Reg) & 0x1
}
func (o *EMAC_MAC_Type) SetEMACDEBUG_MACRFFCS(value uint32) {
	volatile.StoreUint32(&o.EMACDEBUG.Reg, volatile.LoadUint32(&o.EMACDEBUG.Reg)&^(0x6)|value<<1)
}
func (o *EMAC_MAC_Type) GetEMACDEBUG_MACRFFCS() uint32 {
	return (volatile.LoadUint32(&o.EMACDEBUG.Reg) & 0x6) >> 1
}
func (o *EMAC_MAC_Type) SetEMACDEBUG_MTLRFWCAS(value uint32) {
	volatile.StoreUint32(&o.EMACDEBUG.Reg, volatile.LoadUint32(&o.EMACDEBUG.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_MAC_Type) GetEMACDEBUG_MTLRFWCAS() uint32 {
	return (volatile.LoadUint32(&o.EMACDEBUG.Reg) & 0x10) >> 4
}
func (o *EMAC_MAC_Type) SetEMACDEBUG_MTLRFRCS(value uint32) {
	volatile.StoreUint32(&o.EMACDEBUG.Reg, volatile.LoadUint32(&o.EMACDEBUG.Reg)&^(0x60)|value<<5)
}
func (o *EMAC_MAC_Type) GetEMACDEBUG_MTLRFRCS() uint32 {
	return (volatile.LoadUint32(&o.EMACDEBUG.Reg) & 0x60) >> 5
}
func (o *EMAC_MAC_Type) SetEMACDEBUG_MTLRFFLS(value uint32) {
	volatile.StoreUint32(&o.EMACDEBUG.Reg, volatile.LoadUint32(&o.EMACDEBUG.Reg)&^(0x300)|value<<8)
}
func (o *EMAC_MAC_Type) GetEMACDEBUG_MTLRFFLS() uint32 {
	return (volatile.LoadUint32(&o.EMACDEBUG.Reg) & 0x300) >> 8
}
func (o *EMAC_MAC_Type) SetEMACDEBUG_MACTPES(value uint32) {
	volatile.StoreUint32(&o.EMACDEBUG.Reg, volatile.LoadUint32(&o.EMACDEBUG.Reg)&^(0x10000)|value<<16)
}
func (o *EMAC_MAC_Type) GetEMACDEBUG_MACTPES() uint32 {
	return (volatile.LoadUint32(&o.EMACDEBUG.Reg) & 0x10000) >> 16
}
func (o *EMAC_MAC_Type) SetEMACDEBUG_MACTFCS(value uint32) {
	volatile.StoreUint32(&o.EMACDEBUG.Reg, volatile.LoadUint32(&o.EMACDEBUG.Reg)&^(0x60000)|value<<17)
}
func (o *EMAC_MAC_Type) GetEMACDEBUG_MACTFCS() uint32 {
	return (volatile.LoadUint32(&o.EMACDEBUG.Reg) & 0x60000) >> 17
}
func (o *EMAC_MAC_Type) SetEMACDEBUG_MACTP(value uint32) {
	volatile.StoreUint32(&o.EMACDEBUG.Reg, volatile.LoadUint32(&o.EMACDEBUG.Reg)&^(0x80000)|value<<19)
}
func (o *EMAC_MAC_Type) GetEMACDEBUG_MACTP() uint32 {
	return (volatile.LoadUint32(&o.EMACDEBUG.Reg) & 0x80000) >> 19
}
func (o *EMAC_MAC_Type) SetEMACDEBUG_MTLTFRCS(value uint32) {
	volatile.StoreUint32(&o.EMACDEBUG.Reg, volatile.LoadUint32(&o.EMACDEBUG.Reg)&^(0x300000)|value<<20)
}
func (o *EMAC_MAC_Type) GetEMACDEBUG_MTLTFRCS() uint32 {
	return (volatile.LoadUint32(&o.EMACDEBUG.Reg) & 0x300000) >> 20
}
func (o *EMAC_MAC_Type) SetEMACDEBUG_MTLTFWCS(value uint32) {
	volatile.StoreUint32(&o.EMACDEBUG.Reg, volatile.LoadUint32(&o.EMACDEBUG.Reg)&^(0x400000)|value<<22)
}
func (o *EMAC_MAC_Type) GetEMACDEBUG_MTLTFWCS() uint32 {
	return (volatile.LoadUint32(&o.EMACDEBUG.Reg) & 0x400000) >> 22
}
func (o *EMAC_MAC_Type) SetEMACDEBUG_MTLTFNES(value uint32) {
	volatile.StoreUint32(&o.EMACDEBUG.Reg, volatile.LoadUint32(&o.EMACDEBUG.Reg)&^(0x1000000)|value<<24)
}
func (o *EMAC_MAC_Type) GetEMACDEBUG_MTLTFNES() uint32 {
	return (volatile.LoadUint32(&o.EMACDEBUG.Reg) & 0x1000000) >> 24
}
func (o *EMAC_MAC_Type) SetEMACDEBUG_MTLTSFFS(value uint32) {
	volatile.StoreUint32(&o.EMACDEBUG.Reg, volatile.LoadUint32(&o.EMACDEBUG.Reg)&^(0x2000000)|value<<25)
}
func (o *EMAC_MAC_Type) GetEMACDEBUG_MTLTSFFS() uint32 {
	return (volatile.LoadUint32(&o.EMACDEBUG.Reg) & 0x2000000) >> 25
}

// EMAC_MAC.PMT_CSR: PMT Control and Status
func (o *EMAC_MAC_Type) SetPMT_CSR_PWRDWN(value uint32) {
	volatile.StoreUint32(&o.PMT_CSR.Reg, volatile.LoadUint32(&o.PMT_CSR.Reg)&^(0x1)|value)
}
func (o *EMAC_MAC_Type) GetPMT_CSR_PWRDWN() uint32 {
	return volatile.LoadUint32(&o.PMT_CSR.Reg) & 0x1
}
func (o *EMAC_MAC_Type) SetPMT_CSR_MGKPKTEN(value uint32) {
	volatile.StoreUint32(&o.PMT_CSR.Reg, volatile.LoadUint32(&o.PMT_CSR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_MAC_Type) GetPMT_CSR_MGKPKTEN() uint32 {
	return (volatile.LoadUint32(&o.PMT_CSR.Reg) & 0x2) >> 1
}
func (o *EMAC_MAC_Type) SetPMT_CSR_RWKPKTEN(value uint32) {
	volatile.StoreUint32(&o.PMT_CSR.Reg, volatile.LoadUint32(&o.PMT_CSR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_MAC_Type) GetPMT_CSR_RWKPKTEN() uint32 {
	return (volatile.LoadUint32(&o.PMT_CSR.Reg) & 0x4) >> 2
}
func (o *EMAC_MAC_Type) SetPMT_CSR_MGKPRCVD(value uint32) {
	volatile.StoreUint32(&o.PMT_CSR.Reg, volatile.LoadUint32(&o.PMT_CSR.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_MAC_Type) GetPMT_CSR_MGKPRCVD() uint32 {
	return (volatile.LoadUint32(&o.PMT_CSR.Reg) & 0x20) >> 5
}
func (o *EMAC_MAC_Type) SetPMT_CSR_RWKPRCVD(value uint32) {
	volatile.StoreUint32(&o.PMT_CSR.Reg, volatile.LoadUint32(&o.PMT_CSR.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_MAC_Type) GetPMT_CSR_RWKPRCVD() uint32 {
	return (volatile.LoadUint32(&o.PMT_CSR.Reg) & 0x40) >> 6
}
func (o *EMAC_MAC_Type) SetPMT_CSR_GLBLUCAST(value uint32) {
	volatile.StoreUint32(&o.PMT_CSR.Reg, volatile.LoadUint32(&o.PMT_CSR.Reg)&^(0x200)|value<<9)
}
func (o *EMAC_MAC_Type) GetPMT_CSR_GLBLUCAST() uint32 {
	return (volatile.LoadUint32(&o.PMT_CSR.Reg) & 0x200) >> 9
}
func (o *EMAC_MAC_Type) SetPMT_CSR_RWKPTR(value uint32) {
	volatile.StoreUint32(&o.PMT_CSR.Reg, volatile.LoadUint32(&o.PMT_CSR.Reg)&^(0x1f000000)|value<<24)
}
func (o *EMAC_MAC_Type) GetPMT_CSR_RWKPTR() uint32 {
	return (volatile.LoadUint32(&o.PMT_CSR.Reg) & 0x1f000000) >> 24
}
func (o *EMAC_MAC_Type) SetPMT_CSR_RWKFILTRST(value uint32) {
	volatile.StoreUint32(&o.PMT_CSR.Reg, volatile.LoadUint32(&o.PMT_CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *EMAC_MAC_Type) GetPMT_CSR_RWKFILTRST() uint32 {
	return (volatile.LoadUint32(&o.PMT_CSR.Reg) & 0x80000000) >> 31
}

// EMAC_MAC.EMACLPI_CRS: LPI Control and Status
func (o *EMAC_MAC_Type) SetEMACLPI_CRS_TLPIEN(value uint32) {
	volatile.StoreUint32(&o.EMACLPI_CRS.Reg, volatile.LoadUint32(&o.EMACLPI_CRS.Reg)&^(0x1)|value)
}
func (o *EMAC_MAC_Type) GetEMACLPI_CRS_TLPIEN() uint32 {
	return volatile.LoadUint32(&o.EMACLPI_CRS.Reg) & 0x1
}
func (o *EMAC_MAC_Type) SetEMACLPI_CRS_TLPIEX(value uint32) {
	volatile.StoreUint32(&o.EMACLPI_CRS.Reg, volatile.LoadUint32(&o.EMACLPI_CRS.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_MAC_Type) GetEMACLPI_CRS_TLPIEX() uint32 {
	return (volatile.LoadUint32(&o.EMACLPI_CRS.Reg) & 0x2) >> 1
}
func (o *EMAC_MAC_Type) SetEMACLPI_CRS_RLPIEN(value uint32) {
	volatile.StoreUint32(&o.EMACLPI_CRS.Reg, volatile.LoadUint32(&o.EMACLPI_CRS.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_MAC_Type) GetEMACLPI_CRS_RLPIEN() uint32 {
	return (volatile.LoadUint32(&o.EMACLPI_CRS.Reg) & 0x4) >> 2
}
func (o *EMAC_MAC_Type) SetEMACLPI_CRS_RLPIEX(value uint32) {
	volatile.StoreUint32(&o.EMACLPI_CRS.Reg, volatile.LoadUint32(&o.EMACLPI_CRS.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_MAC_Type) GetEMACLPI_CRS_RLPIEX() uint32 {
	return (volatile.LoadUint32(&o.EMACLPI_CRS.Reg) & 0x8) >> 3
}
func (o *EMAC_MAC_Type) SetEMACLPI_CRS_TLPIST(value uint32) {
	volatile.StoreUint32(&o.EMACLPI_CRS.Reg, volatile.LoadUint32(&o.EMACLPI_CRS.Reg)&^(0x100)|value<<8)
}
func (o *EMAC_MAC_Type) GetEMACLPI_CRS_TLPIST() uint32 {
	return (volatile.LoadUint32(&o.EMACLPI_CRS.Reg) & 0x100) >> 8
}
func (o *EMAC_MAC_Type) SetEMACLPI_CRS_RLPIST(value uint32) {
	volatile.StoreUint32(&o.EMACLPI_CRS.Reg, volatile.LoadUint32(&o.EMACLPI_CRS.Reg)&^(0x200)|value<<9)
}
func (o *EMAC_MAC_Type) GetEMACLPI_CRS_RLPIST() uint32 {
	return (volatile.LoadUint32(&o.EMACLPI_CRS.Reg) & 0x200) >> 9
}
func (o *EMAC_MAC_Type) SetEMACLPI_CRS_LPIEN(value uint32) {
	volatile.StoreUint32(&o.EMACLPI_CRS.Reg, volatile.LoadUint32(&o.EMACLPI_CRS.Reg)&^(0x10000)|value<<16)
}
func (o *EMAC_MAC_Type) GetEMACLPI_CRS_LPIEN() uint32 {
	return (volatile.LoadUint32(&o.EMACLPI_CRS.Reg) & 0x10000) >> 16
}
func (o *EMAC_MAC_Type) SetEMACLPI_CRS_PLS(value uint32) {
	volatile.StoreUint32(&o.EMACLPI_CRS.Reg, volatile.LoadUint32(&o.EMACLPI_CRS.Reg)&^(0x20000)|value<<17)
}
func (o *EMAC_MAC_Type) GetEMACLPI_CRS_PLS() uint32 {
	return (volatile.LoadUint32(&o.EMACLPI_CRS.Reg) & 0x20000) >> 17
}
func (o *EMAC_MAC_Type) SetEMACLPI_CRS_LPITXA(value uint32) {
	volatile.StoreUint32(&o.EMACLPI_CRS.Reg, volatile.LoadUint32(&o.EMACLPI_CRS.Reg)&^(0x80000)|value<<19)
}
func (o *EMAC_MAC_Type) GetEMACLPI_CRS_LPITXA() uint32 {
	return (volatile.LoadUint32(&o.EMACLPI_CRS.Reg) & 0x80000) >> 19
}

// EMAC_MAC.EMACLPITIMERSCONTROL: LPI Timers Control
func (o *EMAC_MAC_Type) SetEMACLPITIMERSCONTROL_LPI_TW_TIMER(value uint32) {
	volatile.StoreUint32(&o.EMACLPITIMERSCONTROL.Reg, volatile.LoadUint32(&o.EMACLPITIMERSCONTROL.Reg)&^(0xffff)|value)
}
func (o *EMAC_MAC_Type) GetEMACLPITIMERSCONTROL_LPI_TW_TIMER() uint32 {
	return volatile.LoadUint32(&o.EMACLPITIMERSCONTROL.Reg) & 0xffff
}
func (o *EMAC_MAC_Type) SetEMACLPITIMERSCONTROL_LPI_LS_TIMER(value uint32) {
	volatile.StoreUint32(&o.EMACLPITIMERSCONTROL.Reg, volatile.LoadUint32(&o.EMACLPITIMERSCONTROL.Reg)&^(0x3ff0000)|value<<16)
}
func (o *EMAC_MAC_Type) GetEMACLPITIMERSCONTROL_LPI_LS_TIMER() uint32 {
	return (volatile.LoadUint32(&o.EMACLPITIMERSCONTROL.Reg) & 0x3ff0000) >> 16
}

// EMAC_MAC.EMACINTS: Interrupt status
func (o *EMAC_MAC_Type) SetEMACINTS_PMTINTS(value uint32) {
	volatile.StoreUint32(&o.EMACINTS.Reg, volatile.LoadUint32(&o.EMACINTS.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_MAC_Type) GetEMACINTS_PMTINTS() uint32 {
	return (volatile.LoadUint32(&o.EMACINTS.Reg) & 0x8) >> 3
}
func (o *EMAC_MAC_Type) SetEMACINTS_LPIIS(value uint32) {
	volatile.StoreUint32(&o.EMACINTS.Reg, volatile.LoadUint32(&o.EMACINTS.Reg)&^(0x400)|value<<10)
}
func (o *EMAC_MAC_Type) GetEMACINTS_LPIIS() uint32 {
	return (volatile.LoadUint32(&o.EMACINTS.Reg) & 0x400) >> 10
}

// EMAC_MAC.EMACINTMASK: Interrupt mask
func (o *EMAC_MAC_Type) SetEMACINTMASK_PMTINTMASK(value uint32) {
	volatile.StoreUint32(&o.EMACINTMASK.Reg, volatile.LoadUint32(&o.EMACINTMASK.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_MAC_Type) GetEMACINTMASK_PMTINTMASK() uint32 {
	return (volatile.LoadUint32(&o.EMACINTMASK.Reg) & 0x8) >> 3
}
func (o *EMAC_MAC_Type) SetEMACINTMASK_LPIINTMASK(value uint32) {
	volatile.StoreUint32(&o.EMACINTMASK.Reg, volatile.LoadUint32(&o.EMACINTMASK.Reg)&^(0x400)|value<<10)
}
func (o *EMAC_MAC_Type) GetEMACINTMASK_LPIINTMASK() uint32 {
	return (volatile.LoadUint32(&o.EMACINTMASK.Reg) & 0x400) >> 10
}

// EMAC_MAC.EMACADDR0HIGH: Upper 16 bits of the first 6-byte MAC address
func (o *EMAC_MAC_Type) SetEMACADDR0HIGH_ADDRESS0_HI(value uint32) {
	volatile.StoreUint32(&o.EMACADDR0HIGH.Reg, volatile.LoadUint32(&o.EMACADDR0HIGH.Reg)&^(0xffff)|value)
}
func (o *EMAC_MAC_Type) GetEMACADDR0HIGH_ADDRESS0_HI() uint32 {
	return volatile.LoadUint32(&o.EMACADDR0HIGH.Reg) & 0xffff
}
func (o *EMAC_MAC_Type) SetEMACADDR0HIGH_ADDRESS_ENABLE0(value uint32) {
	volatile.StoreUint32(&o.EMACADDR0HIGH.Reg, volatile.LoadUint32(&o.EMACADDR0HIGH.Reg)&^(0x80000000)|value<<31)
}
func (o *EMAC_MAC_Type) GetEMACADDR0HIGH_ADDRESS_ENABLE0() uint32 {
	return (volatile.LoadUint32(&o.EMACADDR0HIGH.Reg) & 0x80000000) >> 31
}

// EMAC_MAC.EMACADDR1HIGH: Upper 16 bits of the second 6-byte MAC address
func (o *EMAC_MAC_Type) SetEMACADDR1HIGH_MAC_ADDRESS1_HI(value uint32) {
	volatile.StoreUint32(&o.EMACADDR1HIGH.Reg, volatile.LoadUint32(&o.EMACADDR1HIGH.Reg)&^(0xffff)|value)
}
func (o *EMAC_MAC_Type) GetEMACADDR1HIGH_MAC_ADDRESS1_HI() uint32 {
	return volatile.LoadUint32(&o.EMACADDR1HIGH.Reg) & 0xffff
}
func (o *EMAC_MAC_Type) SetEMACADDR1HIGH_MASK_BYTE_CONTROL(value uint32) {
	volatile.StoreUint32(&o.EMACADDR1HIGH.Reg, volatile.LoadUint32(&o.EMACADDR1HIGH.Reg)&^(0x3f000000)|value<<24)
}
func (o *EMAC_MAC_Type) GetEMACADDR1HIGH_MASK_BYTE_CONTROL() uint32 {
	return (volatile.LoadUint32(&o.EMACADDR1HIGH.Reg) & 0x3f000000) >> 24
}
func (o *EMAC_MAC_Type) SetEMACADDR1HIGH_SOURCE_ADDRESS(value uint32) {
	volatile.StoreUint32(&o.EMACADDR1HIGH.Reg, volatile.LoadUint32(&o.EMACADDR1HIGH.Reg)&^(0x40000000)|value<<30)
}
func (o *EMAC_MAC_Type) GetEMACADDR1HIGH_SOURCE_ADDRESS() uint32 {
	return (volatile.LoadUint32(&o.EMACADDR1HIGH.Reg) & 0x40000000) >> 30
}
func (o *EMAC_MAC_Type) SetEMACADDR1HIGH_ADDRESS_ENABLE1(value uint32) {
	volatile.StoreUint32(&o.EMACADDR1HIGH.Reg, volatile.LoadUint32(&o.EMACADDR1HIGH.Reg)&^(0x80000000)|value<<31)
}
func (o *EMAC_MAC_Type) GetEMACADDR1HIGH_ADDRESS_ENABLE1() uint32 {
	return (volatile.LoadUint32(&o.EMACADDR1HIGH.Reg) & 0x80000000) >> 31
}

// EMAC_MAC.EMACADDR2HIGH: Upper 16 bits of the third 6-byte MAC address
func (o *EMAC_MAC_Type) SetEMACADDR2HIGH_MAC_ADDRESS2_HI(value uint32) {
	volatile.StoreUint32(&o.EMACADDR2HIGH.Reg, volatile.LoadUint32(&o.EMACADDR2HIGH.Reg)&^(0xffff)|value)
}
func (o *EMAC_MAC_Type) GetEMACADDR2HIGH_MAC_ADDRESS2_HI() uint32 {
	return volatile.LoadUint32(&o.EMACADDR2HIGH.Reg) & 0xffff
}
func (o *EMAC_MAC_Type) SetEMACADDR2HIGH_MASK_BYTE_CONTROL2(value uint32) {
	volatile.StoreUint32(&o.EMACADDR2HIGH.Reg, volatile.LoadUint32(&o.EMACADDR2HIGH.Reg)&^(0x3f000000)|value<<24)
}
func (o *EMAC_MAC_Type) GetEMACADDR2HIGH_MASK_BYTE_CONTROL2() uint32 {
	return (volatile.LoadUint32(&o.EMACADDR2HIGH.Reg) & 0x3f000000) >> 24
}
func (o *EMAC_MAC_Type) SetEMACADDR2HIGH_SOURCE_ADDRESS2(value uint32) {
	volatile.StoreUint32(&o.EMACADDR2HIGH.Reg, volatile.LoadUint32(&o.EMACADDR2HIGH.Reg)&^(0x40000000)|value<<30)
}
func (o *EMAC_MAC_Type) GetEMACADDR2HIGH_SOURCE_ADDRESS2() uint32 {
	return (volatile.LoadUint32(&o.EMACADDR2HIGH.Reg) & 0x40000000) >> 30
}
func (o *EMAC_MAC_Type) SetEMACADDR2HIGH_ADDRESS_ENABLE2(value uint32) {
	volatile.StoreUint32(&o.EMACADDR2HIGH.Reg, volatile.LoadUint32(&o.EMACADDR2HIGH.Reg)&^(0x80000000)|value<<31)
}
func (o *EMAC_MAC_Type) GetEMACADDR2HIGH_ADDRESS_ENABLE2() uint32 {
	return (volatile.LoadUint32(&o.EMACADDR2HIGH.Reg) & 0x80000000) >> 31
}

// EMAC_MAC.EMACADDR3HIGH: Upper 16 bits of the fourth 6-byte MAC address
func (o *EMAC_MAC_Type) SetEMACADDR3HIGH_MAC_ADDRESS3_HI(value uint32) {
	volatile.StoreUint32(&o.EMACADDR3HIGH.Reg, volatile.LoadUint32(&o.EMACADDR3HIGH.Reg)&^(0xffff)|value)
}
func (o *EMAC_MAC_Type) GetEMACADDR3HIGH_MAC_ADDRESS3_HI() uint32 {
	return volatile.LoadUint32(&o.EMACADDR3HIGH.Reg) & 0xffff
}
func (o *EMAC_MAC_Type) SetEMACADDR3HIGH_MASK_BYTE_CONTROL3(value uint32) {
	volatile.StoreUint32(&o.EMACADDR3HIGH.Reg, volatile.LoadUint32(&o.EMACADDR3HIGH.Reg)&^(0x3f000000)|value<<24)
}
func (o *EMAC_MAC_Type) GetEMACADDR3HIGH_MASK_BYTE_CONTROL3() uint32 {
	return (volatile.LoadUint32(&o.EMACADDR3HIGH.Reg) & 0x3f000000) >> 24
}
func (o *EMAC_MAC_Type) SetEMACADDR3HIGH_SOURCE_ADDRESS3(value uint32) {
	volatile.StoreUint32(&o.EMACADDR3HIGH.Reg, volatile.LoadUint32(&o.EMACADDR3HIGH.Reg)&^(0x40000000)|value<<30)
}
func (o *EMAC_MAC_Type) GetEMACADDR3HIGH_SOURCE_ADDRESS3() uint32 {
	return (volatile.LoadUint32(&o.EMACADDR3HIGH.Reg) & 0x40000000) >> 30
}
func (o *EMAC_MAC_Type) SetEMACADDR3HIGH_ADDRESS_ENABLE3(value uint32) {
	volatile.StoreUint32(&o.EMACADDR3HIGH.Reg, volatile.LoadUint32(&o.EMACADDR3HIGH.Reg)&^(0x80000000)|value<<31)
}
func (o *EMAC_MAC_Type) GetEMACADDR3HIGH_ADDRESS_ENABLE3() uint32 {
	return (volatile.LoadUint32(&o.EMACADDR3HIGH.Reg) & 0x80000000) >> 31
}

// EMAC_MAC.EMACADDR4HIGH: Upper 16 bits of the fifth 6-byte MAC address
func (o *EMAC_MAC_Type) SetEMACADDR4HIGH_MAC_ADDRESS4_HI(value uint32) {
	volatile.StoreUint32(&o.EMACADDR4HIGH.Reg, volatile.LoadUint32(&o.EMACADDR4HIGH.Reg)&^(0xffff)|value)
}
func (o *EMAC_MAC_Type) GetEMACADDR4HIGH_MAC_ADDRESS4_HI() uint32 {
	return volatile.LoadUint32(&o.EMACADDR4HIGH.Reg) & 0xffff
}
func (o *EMAC_MAC_Type) SetEMACADDR4HIGH_MASK_BYTE_CONTROL4(value uint32) {
	volatile.StoreUint32(&o.EMACADDR4HIGH.Reg, volatile.LoadUint32(&o.EMACADDR4HIGH.Reg)&^(0x3f000000)|value<<24)
}
func (o *EMAC_MAC_Type) GetEMACADDR4HIGH_MASK_BYTE_CONTROL4() uint32 {
	return (volatile.LoadUint32(&o.EMACADDR4HIGH.Reg) & 0x3f000000) >> 24
}
func (o *EMAC_MAC_Type) SetEMACADDR4HIGH_SOURCE_ADDRESS4(value uint32) {
	volatile.StoreUint32(&o.EMACADDR4HIGH.Reg, volatile.LoadUint32(&o.EMACADDR4HIGH.Reg)&^(0x40000000)|value<<30)
}
func (o *EMAC_MAC_Type) GetEMACADDR4HIGH_SOURCE_ADDRESS4() uint32 {
	return (volatile.LoadUint32(&o.EMACADDR4HIGH.Reg) & 0x40000000) >> 30
}
func (o *EMAC_MAC_Type) SetEMACADDR4HIGH_ADDRESS_ENABLE4(value uint32) {
	volatile.StoreUint32(&o.EMACADDR4HIGH.Reg, volatile.LoadUint32(&o.EMACADDR4HIGH.Reg)&^(0x80000000)|value<<31)
}
func (o *EMAC_MAC_Type) GetEMACADDR4HIGH_ADDRESS_ENABLE4() uint32 {
	return (volatile.LoadUint32(&o.EMACADDR4HIGH.Reg) & 0x80000000) >> 31
}

// EMAC_MAC.EMACADDR5HIGH: Upper 16 bits of the sixth 6-byte MAC address
func (o *EMAC_MAC_Type) SetEMACADDR5HIGH_MAC_ADDRESS5_HI(value uint32) {
	volatile.StoreUint32(&o.EMACADDR5HIGH.Reg, volatile.LoadUint32(&o.EMACADDR5HIGH.Reg)&^(0xffff)|value)
}
func (o *EMAC_MAC_Type) GetEMACADDR5HIGH_MAC_ADDRESS5_HI() uint32 {
	return volatile.LoadUint32(&o.EMACADDR5HIGH.Reg) & 0xffff
}
func (o *EMAC_MAC_Type) SetEMACADDR5HIGH_MASK_BYTE_CONTROL5(value uint32) {
	volatile.StoreUint32(&o.EMACADDR5HIGH.Reg, volatile.LoadUint32(&o.EMACADDR5HIGH.Reg)&^(0x3f000000)|value<<24)
}
func (o *EMAC_MAC_Type) GetEMACADDR5HIGH_MASK_BYTE_CONTROL5() uint32 {
	return (volatile.LoadUint32(&o.EMACADDR5HIGH.Reg) & 0x3f000000) >> 24
}
func (o *EMAC_MAC_Type) SetEMACADDR5HIGH_SOURCE_ADDRESS5(value uint32) {
	volatile.StoreUint32(&o.EMACADDR5HIGH.Reg, volatile.LoadUint32(&o.EMACADDR5HIGH.Reg)&^(0x40000000)|value<<30)
}
func (o *EMAC_MAC_Type) GetEMACADDR5HIGH_SOURCE_ADDRESS5() uint32 {
	return (volatile.LoadUint32(&o.EMACADDR5HIGH.Reg) & 0x40000000) >> 30
}
func (o *EMAC_MAC_Type) SetEMACADDR5HIGH_ADDRESS_ENABLE5(value uint32) {
	volatile.StoreUint32(&o.EMACADDR5HIGH.Reg, volatile.LoadUint32(&o.EMACADDR5HIGH.Reg)&^(0x80000000)|value<<31)
}
func (o *EMAC_MAC_Type) GetEMACADDR5HIGH_ADDRESS_ENABLE5() uint32 {
	return (volatile.LoadUint32(&o.EMACADDR5HIGH.Reg) & 0x80000000) >> 31
}

// EMAC_MAC.EMACADDR6HIGH: Upper 16 bits of the seventh 6-byte MAC address
func (o *EMAC_MAC_Type) SetEMACADDR6HIGH_MAC_ADDRESS6_HI(value uint32) {
	volatile.StoreUint32(&o.EMACADDR6HIGH.Reg, volatile.LoadUint32(&o.EMACADDR6HIGH.Reg)&^(0xffff)|value)
}
func (o *EMAC_MAC_Type) GetEMACADDR6HIGH_MAC_ADDRESS6_HI() uint32 {
	return volatile.LoadUint32(&o.EMACADDR6HIGH.Reg) & 0xffff
}
func (o *EMAC_MAC_Type) SetEMACADDR6HIGH_MASK_BYTE_CONTROL6(value uint32) {
	volatile.StoreUint32(&o.EMACADDR6HIGH.Reg, volatile.LoadUint32(&o.EMACADDR6HIGH.Reg)&^(0x3f000000)|value<<24)
}
func (o *EMAC_MAC_Type) GetEMACADDR6HIGH_MASK_BYTE_CONTROL6() uint32 {
	return (volatile.LoadUint32(&o.EMACADDR6HIGH.Reg) & 0x3f000000) >> 24
}
func (o *EMAC_MAC_Type) SetEMACADDR6HIGH_SOURCE_ADDRESS6(value uint32) {
	volatile.StoreUint32(&o.EMACADDR6HIGH.Reg, volatile.LoadUint32(&o.EMACADDR6HIGH.Reg)&^(0x40000000)|value<<30)
}
func (o *EMAC_MAC_Type) GetEMACADDR6HIGH_SOURCE_ADDRESS6() uint32 {
	return (volatile.LoadUint32(&o.EMACADDR6HIGH.Reg) & 0x40000000) >> 30
}
func (o *EMAC_MAC_Type) SetEMACADDR6HIGH_ADDRESS_ENABLE6(value uint32) {
	volatile.StoreUint32(&o.EMACADDR6HIGH.Reg, volatile.LoadUint32(&o.EMACADDR6HIGH.Reg)&^(0x80000000)|value<<31)
}
func (o *EMAC_MAC_Type) GetEMACADDR6HIGH_ADDRESS_ENABLE6() uint32 {
	return (volatile.LoadUint32(&o.EMACADDR6HIGH.Reg) & 0x80000000) >> 31
}

// EMAC_MAC.EMACADDR7HIGH: Upper 16 bits of the eighth 6-byte MAC address
func (o *EMAC_MAC_Type) SetEMACADDR7HIGH_MAC_ADDRESS7_HI(value uint32) {
	volatile.StoreUint32(&o.EMACADDR7HIGH.Reg, volatile.LoadUint32(&o.EMACADDR7HIGH.Reg)&^(0xffff)|value)
}
func (o *EMAC_MAC_Type) GetEMACADDR7HIGH_MAC_ADDRESS7_HI() uint32 {
	return volatile.LoadUint32(&o.EMACADDR7HIGH.Reg) & 0xffff
}
func (o *EMAC_MAC_Type) SetEMACADDR7HIGH_MASK_BYTE_CONTROL7(value uint32) {
	volatile.StoreUint32(&o.EMACADDR7HIGH.Reg, volatile.LoadUint32(&o.EMACADDR7HIGH.Reg)&^(0x3f000000)|value<<24)
}
func (o *EMAC_MAC_Type) GetEMACADDR7HIGH_MASK_BYTE_CONTROL7() uint32 {
	return (volatile.LoadUint32(&o.EMACADDR7HIGH.Reg) & 0x3f000000) >> 24
}
func (o *EMAC_MAC_Type) SetEMACADDR7HIGH_SOURCE_ADDRESS7(value uint32) {
	volatile.StoreUint32(&o.EMACADDR7HIGH.Reg, volatile.LoadUint32(&o.EMACADDR7HIGH.Reg)&^(0x40000000)|value<<30)
}
func (o *EMAC_MAC_Type) GetEMACADDR7HIGH_SOURCE_ADDRESS7() uint32 {
	return (volatile.LoadUint32(&o.EMACADDR7HIGH.Reg) & 0x40000000) >> 30
}
func (o *EMAC_MAC_Type) SetEMACADDR7HIGH_ADDRESS_ENABLE7(value uint32) {
	volatile.StoreUint32(&o.EMACADDR7HIGH.Reg, volatile.LoadUint32(&o.EMACADDR7HIGH.Reg)&^(0x80000000)|value<<31)
}
func (o *EMAC_MAC_Type) GetEMACADDR7HIGH_ADDRESS_ENABLE7() uint32 {
	return (volatile.LoadUint32(&o.EMACADDR7HIGH.Reg) & 0x80000000) >> 31
}

// EMAC_MAC.EMACCSTATUS: Link communication status
func (o *EMAC_MAC_Type) SetEMACCSTATUS_LINK_MODE(value uint32) {
	volatile.StoreUint32(&o.EMACCSTATUS.Reg, volatile.LoadUint32(&o.EMACCSTATUS.Reg)&^(0x1)|value)
}
func (o *EMAC_MAC_Type) GetEMACCSTATUS_LINK_MODE() uint32 {
	return volatile.LoadUint32(&o.EMACCSTATUS.Reg) & 0x1
}
func (o *EMAC_MAC_Type) SetEMACCSTATUS_LINK_SPEED(value uint32) {
	volatile.StoreUint32(&o.EMACCSTATUS.Reg, volatile.LoadUint32(&o.EMACCSTATUS.Reg)&^(0x6)|value<<1)
}
func (o *EMAC_MAC_Type) GetEMACCSTATUS_LINK_SPEED() uint32 {
	return (volatile.LoadUint32(&o.EMACCSTATUS.Reg) & 0x6) >> 1
}
func (o *EMAC_MAC_Type) SetEMACCSTATUS_JABBER_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.EMACCSTATUS.Reg, volatile.LoadUint32(&o.EMACCSTATUS.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_MAC_Type) GetEMACCSTATUS_JABBER_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.EMACCSTATUS.Reg) & 0x10) >> 4
}

// EMAC_MAC.EMACWDOGTO: Watchdog timeout control
func (o *EMAC_MAC_Type) SetEMACWDOGTO_WDOGTO(value uint32) {
	volatile.StoreUint32(&o.EMACWDOGTO.Reg, volatile.LoadUint32(&o.EMACWDOGTO.Reg)&^(0x3fff)|value)
}
func (o *EMAC_MAC_Type) GetEMACWDOGTO_WDOGTO() uint32 {
	return volatile.LoadUint32(&o.EMACWDOGTO.Reg) & 0x3fff
}
func (o *EMAC_MAC_Type) SetEMACWDOGTO_PWDOGEN(value uint32) {
	volatile.StoreUint32(&o.EMACWDOGTO.Reg, volatile.LoadUint32(&o.EMACWDOGTO.Reg)&^(0x10000)|value<<16)
}
func (o *EMAC_MAC_Type) GetEMACWDOGTO_PWDOGEN() uint32 {
	return (volatile.LoadUint32(&o.EMACWDOGTO.Reg) & 0x10000) >> 16
}

// FLASH_ENCRYPTION Peripheral
type FLASH_ENCRYPTION_Type struct {
	BUFFER_0 volatile.Register32 // 0x0
	BUFFER_1 volatile.Register32 // 0x4
	BUFFER_2 volatile.Register32 // 0x8
	BUFFER_3 volatile.Register32 // 0xC
	BUFFER_4 volatile.Register32 // 0x10
	BUFFER_5 volatile.Register32 // 0x14
	BUFFER_6 volatile.Register32 // 0x18
	BUFFER_7 volatile.Register32 // 0x1C
	START    volatile.Register32 // 0x20
	ADDRESS  volatile.Register32 // 0x24
	DONE     volatile.Register32 // 0x28
}

// FLASH_ENCRYPTION.BUFFER_0
func (o *FLASH_ENCRYPTION_Type) SetBUFFER_0_BUFFER(value uint32) {
	volatile.StoreUint32(&o.BUFFER_0.Reg, volatile.LoadUint32(&o.BUFFER_0.Reg)&^(0xff)|value)
}
func (o *FLASH_ENCRYPTION_Type) GetBUFFER_0_BUFFER() uint32 {
	return volatile.LoadUint32(&o.BUFFER_0.Reg) & 0xff
}

// FLASH_ENCRYPTION.BUFFER_1
func (o *FLASH_ENCRYPTION_Type) SetBUFFER_1_BUFFER(value uint32) {
	volatile.StoreUint32(&o.BUFFER_1.Reg, volatile.LoadUint32(&o.BUFFER_1.Reg)&^(0xff)|value)
}
func (o *FLASH_ENCRYPTION_Type) GetBUFFER_1_BUFFER() uint32 {
	return volatile.LoadUint32(&o.BUFFER_1.Reg) & 0xff
}

// FLASH_ENCRYPTION.BUFFER_2
func (o *FLASH_ENCRYPTION_Type) SetBUFFER_2_BUFFER(value uint32) {
	volatile.StoreUint32(&o.BUFFER_2.Reg, volatile.LoadUint32(&o.BUFFER_2.Reg)&^(0xff)|value)
}
func (o *FLASH_ENCRYPTION_Type) GetBUFFER_2_BUFFER() uint32 {
	return volatile.LoadUint32(&o.BUFFER_2.Reg) & 0xff
}

// FLASH_ENCRYPTION.BUFFER_3
func (o *FLASH_ENCRYPTION_Type) SetBUFFER_3_BUFFER(value uint32) {
	volatile.StoreUint32(&o.BUFFER_3.Reg, volatile.LoadUint32(&o.BUFFER_3.Reg)&^(0xff)|value)
}
func (o *FLASH_ENCRYPTION_Type) GetBUFFER_3_BUFFER() uint32 {
	return volatile.LoadUint32(&o.BUFFER_3.Reg) & 0xff
}

// FLASH_ENCRYPTION.BUFFER_4
func (o *FLASH_ENCRYPTION_Type) SetBUFFER_4_BUFFER(value uint32) {
	volatile.StoreUint32(&o.BUFFER_4.Reg, volatile.LoadUint32(&o.BUFFER_4.Reg)&^(0xff)|value)
}
func (o *FLASH_ENCRYPTION_Type) GetBUFFER_4_BUFFER() uint32 {
	return volatile.LoadUint32(&o.BUFFER_4.Reg) & 0xff
}

// FLASH_ENCRYPTION.BUFFER_5
func (o *FLASH_ENCRYPTION_Type) SetBUFFER_5_BUFFER(value uint32) {
	volatile.StoreUint32(&o.BUFFER_5.Reg, volatile.LoadUint32(&o.BUFFER_5.Reg)&^(0xff)|value)
}
func (o *FLASH_ENCRYPTION_Type) GetBUFFER_5_BUFFER() uint32 {
	return volatile.LoadUint32(&o.BUFFER_5.Reg) & 0xff
}

// FLASH_ENCRYPTION.BUFFER_6
func (o *FLASH_ENCRYPTION_Type) SetBUFFER_6_BUFFER(value uint32) {
	volatile.StoreUint32(&o.BUFFER_6.Reg, volatile.LoadUint32(&o.BUFFER_6.Reg)&^(0xff)|value)
}
func (o *FLASH_ENCRYPTION_Type) GetBUFFER_6_BUFFER() uint32 {
	return volatile.LoadUint32(&o.BUFFER_6.Reg) & 0xff
}

// FLASH_ENCRYPTION.BUFFER_7
func (o *FLASH_ENCRYPTION_Type) SetBUFFER_7_BUFFER(value uint32) {
	volatile.StoreUint32(&o.BUFFER_7.Reg, volatile.LoadUint32(&o.BUFFER_7.Reg)&^(0xff)|value)
}
func (o *FLASH_ENCRYPTION_Type) GetBUFFER_7_BUFFER() uint32 {
	return volatile.LoadUint32(&o.BUFFER_7.Reg) & 0xff
}

// FLASH_ENCRYPTION.START
func (o *FLASH_ENCRYPTION_Type) SetSTART_FLASH_START(value uint32) {
	volatile.StoreUint32(&o.START.Reg, volatile.LoadUint32(&o.START.Reg)&^(0xff)|value)
}
func (o *FLASH_ENCRYPTION_Type) GetSTART_FLASH_START() uint32 {
	return volatile.LoadUint32(&o.START.Reg) & 0xff
}

// FLASH_ENCRYPTION.ADDRESS
func (o *FLASH_ENCRYPTION_Type) SetADDRESS(value uint32) {
	volatile.StoreUint32(&o.ADDRESS.Reg, volatile.LoadUint32(&o.ADDRESS.Reg)&^(0xff)|value)
}
func (o *FLASH_ENCRYPTION_Type) GetADDRESS() uint32 {
	return volatile.LoadUint32(&o.ADDRESS.Reg) & 0xff
}

// FLASH_ENCRYPTION.DONE
func (o *FLASH_ENCRYPTION_Type) SetDONE_FLASH_DONE(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x1)|value)
}
func (o *FLASH_ENCRYPTION_Type) GetDONE_FLASH_DONE() uint32 {
	return volatile.LoadUint32(&o.DONE.Reg) & 0x1
}

// FRC_TIMER Peripheral
type FRC_Type struct {
	TIMER_LOAD  volatile.Register32 // 0x0
	TIMER_COUNT volatile.Register32 // 0x4
	TIMER_CTRL  volatile.Register32 // 0x8
	TIMER_INT   volatile.Register32 // 0xC
	TIMER_ALARM volatile.Register32 // 0x10
}

// FRC.TIMER_LOAD
func (o *FRC_Type) SetTIMER_LOAD_VALUE(value uint32) {
	volatile.StoreUint32(&o.TIMER_LOAD.Reg, volatile.LoadUint32(&o.TIMER_LOAD.Reg)&^(0xff)|value)
}
func (o *FRC_Type) GetTIMER_LOAD_VALUE() uint32 {
	return volatile.LoadUint32(&o.TIMER_LOAD.Reg) & 0xff
}

// FRC.TIMER_COUNT
func (o *FRC_Type) SetTIMER_COUNT(value uint32) {
	volatile.StoreUint32(&o.TIMER_COUNT.Reg, volatile.LoadUint32(&o.TIMER_COUNT.Reg)&^(0xff)|value)
}
func (o *FRC_Type) GetTIMER_COUNT() uint32 {
	return volatile.LoadUint32(&o.TIMER_COUNT.Reg) & 0xff
}

// FRC.TIMER_CTRL
func (o *FRC_Type) SetTIMER_CTRL_TIMER_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.TIMER_CTRL.Reg, volatile.LoadUint32(&o.TIMER_CTRL.Reg)&^(0x1fe)|value<<1)
}
func (o *FRC_Type) GetTIMER_CTRL_TIMER_PRESCALER() uint32 {
	return (volatile.LoadUint32(&o.TIMER_CTRL.Reg) & 0x1fe) >> 1
}

// FRC.TIMER_INT
func (o *FRC_Type) SetTIMER_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.TIMER_INT.Reg, volatile.LoadUint32(&o.TIMER_INT.Reg)&^(0x1)|value)
}
func (o *FRC_Type) GetTIMER_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.TIMER_INT.Reg) & 0x1
}

// FRC.TIMER_ALARM
func (o *FRC_Type) SetTIMER_ALARM(value uint32) {
	volatile.StoreUint32(&o.TIMER_ALARM.Reg, volatile.LoadUint32(&o.TIMER_ALARM.Reg)&^(0xff)|value)
}
func (o *FRC_Type) GetTIMER_ALARM() uint32 {
	return volatile.LoadUint32(&o.TIMER_ALARM.Reg) & 0xff
}

// General Purpose Input/Output
type GPIO_Type struct {
	BT_SELECT          volatile.Register32 // 0x0
	OUT                volatile.Register32 // 0x4
	OUT_W1TS           volatile.Register32 // 0x8
	OUT_W1TC           volatile.Register32 // 0xC
	OUT1               volatile.Register32 // 0x10
	OUT1_W1TS          volatile.Register32 // 0x14
	OUT1_W1TC          volatile.Register32 // 0x18
	SDIO_SELECT        volatile.Register32 // 0x1C
	ENABLE             volatile.Register32 // 0x20
	ENABLE_W1TS        volatile.Register32 // 0x24
	ENABLE_W1TC        volatile.Register32 // 0x28
	ENABLE1            volatile.Register32 // 0x2C
	ENABLE1_W1TS       volatile.Register32 // 0x30
	ENABLE1_W1TC       volatile.Register32 // 0x34
	STRAP              volatile.Register32 // 0x38
	IN                 volatile.Register32 // 0x3C
	IN1                volatile.Register32 // 0x40
	STATUS             volatile.Register32 // 0x44
	STATUS_W1TS        volatile.Register32 // 0x48
	STATUS_W1TC        volatile.Register32 // 0x4C
	STATUS1            volatile.Register32 // 0x50
	STATUS1_W1TS       volatile.Register32 // 0x54
	STATUS1_W1TC       volatile.Register32 // 0x58
	_                  [4]byte
	ACPU_INT           volatile.Register32 // 0x60
	ACPU_NMI_INT       volatile.Register32 // 0x64
	PCPU_INT           volatile.Register32 // 0x68
	PCPU_NMI_INT       volatile.Register32 // 0x6C
	CPUSDIO_INT        volatile.Register32 // 0x70
	ACPU_INT1          volatile.Register32 // 0x74
	ACPU_NMI_INT1      volatile.Register32 // 0x78
	PCPU_INT1          volatile.Register32 // 0x7C
	PCPU_NMI_INT1      volatile.Register32 // 0x80
	CPUSDIO_INT1       volatile.Register32 // 0x84
	PIN0               volatile.Register32 // 0x88
	PIN1               volatile.Register32 // 0x8C
	PIN2               volatile.Register32 // 0x90
	PIN3               volatile.Register32 // 0x94
	PIN4               volatile.Register32 // 0x98
	PIN5               volatile.Register32 // 0x9C
	PIN6               volatile.Register32 // 0xA0
	PIN7               volatile.Register32 // 0xA4
	PIN8               volatile.Register32 // 0xA8
	PIN9               volatile.Register32 // 0xAC
	PIN10              volatile.Register32 // 0xB0
	PIN11              volatile.Register32 // 0xB4
	PIN12              volatile.Register32 // 0xB8
	PIN13              volatile.Register32 // 0xBC
	PIN14              volatile.Register32 // 0xC0
	PIN15              volatile.Register32 // 0xC4
	PIN16              volatile.Register32 // 0xC8
	PIN17              volatile.Register32 // 0xCC
	PIN18              volatile.Register32 // 0xD0
	PIN19              volatile.Register32 // 0xD4
	PIN20              volatile.Register32 // 0xD8
	PIN21              volatile.Register32 // 0xDC
	PIN22              volatile.Register32 // 0xE0
	PIN23              volatile.Register32 // 0xE4
	PIN24              volatile.Register32 // 0xE8
	PIN25              volatile.Register32 // 0xEC
	PIN26              volatile.Register32 // 0xF0
	PIN27              volatile.Register32 // 0xF4
	PIN28              volatile.Register32 // 0xF8
	PIN29              volatile.Register32 // 0xFC
	PIN30              volatile.Register32 // 0x100
	PIN31              volatile.Register32 // 0x104
	PIN32              volatile.Register32 // 0x108
	PIN33              volatile.Register32 // 0x10C
	PIN34              volatile.Register32 // 0x110
	PIN35              volatile.Register32 // 0x114
	PIN36              volatile.Register32 // 0x118
	PIN37              volatile.Register32 // 0x11C
	PIN38              volatile.Register32 // 0x120
	PIN39              volatile.Register32 // 0x124
	CALI_CONF          volatile.Register32 // 0x128
	CALI_DATA          volatile.Register32 // 0x12C
	FUNC0_IN_SEL_CFG   volatile.Register32 // 0x130
	FUNC1_IN_SEL_CFG   volatile.Register32 // 0x134
	FUNC2_IN_SEL_CFG   volatile.Register32 // 0x138
	FUNC3_IN_SEL_CFG   volatile.Register32 // 0x13C
	FUNC4_IN_SEL_CFG   volatile.Register32 // 0x140
	FUNC5_IN_SEL_CFG   volatile.Register32 // 0x144
	FUNC6_IN_SEL_CFG   volatile.Register32 // 0x148
	FUNC7_IN_SEL_CFG   volatile.Register32 // 0x14C
	FUNC8_IN_SEL_CFG   volatile.Register32 // 0x150
	FUNC9_IN_SEL_CFG   volatile.Register32 // 0x154
	FUNC10_IN_SEL_CFG  volatile.Register32 // 0x158
	FUNC11_IN_SEL_CFG  volatile.Register32 // 0x15C
	FUNC12_IN_SEL_CFG  volatile.Register32 // 0x160
	FUNC13_IN_SEL_CFG  volatile.Register32 // 0x164
	FUNC14_IN_SEL_CFG  volatile.Register32 // 0x168
	FUNC15_IN_SEL_CFG  volatile.Register32 // 0x16C
	FUNC16_IN_SEL_CFG  volatile.Register32 // 0x170
	FUNC17_IN_SEL_CFG  volatile.Register32 // 0x174
	FUNC18_IN_SEL_CFG  volatile.Register32 // 0x178
	FUNC19_IN_SEL_CFG  volatile.Register32 // 0x17C
	FUNC20_IN_SEL_CFG  volatile.Register32 // 0x180
	FUNC21_IN_SEL_CFG  volatile.Register32 // 0x184
	FUNC22_IN_SEL_CFG  volatile.Register32 // 0x188
	FUNC23_IN_SEL_CFG  volatile.Register32 // 0x18C
	FUNC24_IN_SEL_CFG  volatile.Register32 // 0x190
	FUNC25_IN_SEL_CFG  volatile.Register32 // 0x194
	FUNC26_IN_SEL_CFG  volatile.Register32 // 0x198
	FUNC27_IN_SEL_CFG  volatile.Register32 // 0x19C
	FUNC28_IN_SEL_CFG  volatile.Register32 // 0x1A0
	FUNC29_IN_SEL_CFG  volatile.Register32 // 0x1A4
	FUNC30_IN_SEL_CFG  volatile.Register32 // 0x1A8
	FUNC31_IN_SEL_CFG  volatile.Register32 // 0x1AC
	FUNC32_IN_SEL_CFG  volatile.Register32 // 0x1B0
	FUNC33_IN_SEL_CFG  volatile.Register32 // 0x1B4
	FUNC34_IN_SEL_CFG  volatile.Register32 // 0x1B8
	FUNC35_IN_SEL_CFG  volatile.Register32 // 0x1BC
	FUNC36_IN_SEL_CFG  volatile.Register32 // 0x1C0
	FUNC37_IN_SEL_CFG  volatile.Register32 // 0x1C4
	FUNC38_IN_SEL_CFG  volatile.Register32 // 0x1C8
	FUNC39_IN_SEL_CFG  volatile.Register32 // 0x1CC
	FUNC40_IN_SEL_CFG  volatile.Register32 // 0x1D0
	FUNC41_IN_SEL_CFG  volatile.Register32 // 0x1D4
	FUNC42_IN_SEL_CFG  volatile.Register32 // 0x1D8
	FUNC43_IN_SEL_CFG  volatile.Register32 // 0x1DC
	FUNC44_IN_SEL_CFG  volatile.Register32 // 0x1E0
	FUNC45_IN_SEL_CFG  volatile.Register32 // 0x1E4
	FUNC46_IN_SEL_CFG  volatile.Register32 // 0x1E8
	FUNC47_IN_SEL_CFG  volatile.Register32 // 0x1EC
	FUNC48_IN_SEL_CFG  volatile.Register32 // 0x1F0
	FUNC49_IN_SEL_CFG  volatile.Register32 // 0x1F4
	FUNC50_IN_SEL_CFG  volatile.Register32 // 0x1F8
	FUNC51_IN_SEL_CFG  volatile.Register32 // 0x1FC
	FUNC52_IN_SEL_CFG  volatile.Register32 // 0x200
	FUNC53_IN_SEL_CFG  volatile.Register32 // 0x204
	FUNC54_IN_SEL_CFG  volatile.Register32 // 0x208
	FUNC55_IN_SEL_CFG  volatile.Register32 // 0x20C
	FUNC56_IN_SEL_CFG  volatile.Register32 // 0x210
	FUNC57_IN_SEL_CFG  volatile.Register32 // 0x214
	FUNC58_IN_SEL_CFG  volatile.Register32 // 0x218
	FUNC59_IN_SEL_CFG  volatile.Register32 // 0x21C
	FUNC60_IN_SEL_CFG  volatile.Register32 // 0x220
	FUNC61_IN_SEL_CFG  volatile.Register32 // 0x224
	FUNC62_IN_SEL_CFG  volatile.Register32 // 0x228
	FUNC63_IN_SEL_CFG  volatile.Register32 // 0x22C
	FUNC64_IN_SEL_CFG  volatile.Register32 // 0x230
	FUNC65_IN_SEL_CFG  volatile.Register32 // 0x234
	FUNC66_IN_SEL_CFG  volatile.Register32 // 0x238
	FUNC67_IN_SEL_CFG  volatile.Register32 // 0x23C
	FUNC68_IN_SEL_CFG  volatile.Register32 // 0x240
	FUNC69_IN_SEL_CFG  volatile.Register32 // 0x244
	FUNC70_IN_SEL_CFG  volatile.Register32 // 0x248
	FUNC71_IN_SEL_CFG  volatile.Register32 // 0x24C
	FUNC72_IN_SEL_CFG  volatile.Register32 // 0x250
	FUNC73_IN_SEL_CFG  volatile.Register32 // 0x254
	FUNC74_IN_SEL_CFG  volatile.Register32 // 0x258
	FUNC75_IN_SEL_CFG  volatile.Register32 // 0x25C
	FUNC76_IN_SEL_CFG  volatile.Register32 // 0x260
	FUNC77_IN_SEL_CFG  volatile.Register32 // 0x264
	FUNC78_IN_SEL_CFG  volatile.Register32 // 0x268
	FUNC79_IN_SEL_CFG  volatile.Register32 // 0x26C
	FUNC80_IN_SEL_CFG  volatile.Register32 // 0x270
	FUNC81_IN_SEL_CFG  volatile.Register32 // 0x274
	FUNC82_IN_SEL_CFG  volatile.Register32 // 0x278
	FUNC83_IN_SEL_CFG  volatile.Register32 // 0x27C
	FUNC84_IN_SEL_CFG  volatile.Register32 // 0x280
	FUNC85_IN_SEL_CFG  volatile.Register32 // 0x284
	FUNC86_IN_SEL_CFG  volatile.Register32 // 0x288
	FUNC87_IN_SEL_CFG  volatile.Register32 // 0x28C
	FUNC88_IN_SEL_CFG  volatile.Register32 // 0x290
	FUNC89_IN_SEL_CFG  volatile.Register32 // 0x294
	FUNC90_IN_SEL_CFG  volatile.Register32 // 0x298
	FUNC91_IN_SEL_CFG  volatile.Register32 // 0x29C
	FUNC92_IN_SEL_CFG  volatile.Register32 // 0x2A0
	FUNC93_IN_SEL_CFG  volatile.Register32 // 0x2A4
	FUNC94_IN_SEL_CFG  volatile.Register32 // 0x2A8
	FUNC95_IN_SEL_CFG  volatile.Register32 // 0x2AC
	FUNC96_IN_SEL_CFG  volatile.Register32 // 0x2B0
	FUNC97_IN_SEL_CFG  volatile.Register32 // 0x2B4
	FUNC98_IN_SEL_CFG  volatile.Register32 // 0x2B8
	FUNC99_IN_SEL_CFG  volatile.Register32 // 0x2BC
	FUNC100_IN_SEL_CFG volatile.Register32 // 0x2C0
	FUNC101_IN_SEL_CFG volatile.Register32 // 0x2C4
	FUNC102_IN_SEL_CFG volatile.Register32 // 0x2C8
	FUNC103_IN_SEL_CFG volatile.Register32 // 0x2CC
	FUNC104_IN_SEL_CFG volatile.Register32 // 0x2D0
	FUNC105_IN_SEL_CFG volatile.Register32 // 0x2D4
	FUNC106_IN_SEL_CFG volatile.Register32 // 0x2D8
	FUNC107_IN_SEL_CFG volatile.Register32 // 0x2DC
	FUNC108_IN_SEL_CFG volatile.Register32 // 0x2E0
	FUNC109_IN_SEL_CFG volatile.Register32 // 0x2E4
	FUNC110_IN_SEL_CFG volatile.Register32 // 0x2E8
	FUNC111_IN_SEL_CFG volatile.Register32 // 0x2EC
	FUNC112_IN_SEL_CFG volatile.Register32 // 0x2F0
	FUNC113_IN_SEL_CFG volatile.Register32 // 0x2F4
	FUNC114_IN_SEL_CFG volatile.Register32 // 0x2F8
	FUNC115_IN_SEL_CFG volatile.Register32 // 0x2FC
	FUNC116_IN_SEL_CFG volatile.Register32 // 0x300
	FUNC117_IN_SEL_CFG volatile.Register32 // 0x304
	FUNC118_IN_SEL_CFG volatile.Register32 // 0x308
	FUNC119_IN_SEL_CFG volatile.Register32 // 0x30C
	FUNC120_IN_SEL_CFG volatile.Register32 // 0x310
	FUNC121_IN_SEL_CFG volatile.Register32 // 0x314
	FUNC122_IN_SEL_CFG volatile.Register32 // 0x318
	FUNC123_IN_SEL_CFG volatile.Register32 // 0x31C
	FUNC124_IN_SEL_CFG volatile.Register32 // 0x320
	FUNC125_IN_SEL_CFG volatile.Register32 // 0x324
	FUNC126_IN_SEL_CFG volatile.Register32 // 0x328
	FUNC127_IN_SEL_CFG volatile.Register32 // 0x32C
	FUNC128_IN_SEL_CFG volatile.Register32 // 0x330
	FUNC129_IN_SEL_CFG volatile.Register32 // 0x334
	FUNC130_IN_SEL_CFG volatile.Register32 // 0x338
	FUNC131_IN_SEL_CFG volatile.Register32 // 0x33C
	FUNC132_IN_SEL_CFG volatile.Register32 // 0x340
	FUNC133_IN_SEL_CFG volatile.Register32 // 0x344
	FUNC134_IN_SEL_CFG volatile.Register32 // 0x348
	FUNC135_IN_SEL_CFG volatile.Register32 // 0x34C
	FUNC136_IN_SEL_CFG volatile.Register32 // 0x350
	FUNC137_IN_SEL_CFG volatile.Register32 // 0x354
	FUNC138_IN_SEL_CFG volatile.Register32 // 0x358
	FUNC139_IN_SEL_CFG volatile.Register32 // 0x35C
	FUNC140_IN_SEL_CFG volatile.Register32 // 0x360
	FUNC141_IN_SEL_CFG volatile.Register32 // 0x364
	FUNC142_IN_SEL_CFG volatile.Register32 // 0x368
	FUNC143_IN_SEL_CFG volatile.Register32 // 0x36C
	FUNC144_IN_SEL_CFG volatile.Register32 // 0x370
	FUNC145_IN_SEL_CFG volatile.Register32 // 0x374
	FUNC146_IN_SEL_CFG volatile.Register32 // 0x378
	FUNC147_IN_SEL_CFG volatile.Register32 // 0x37C
	FUNC148_IN_SEL_CFG volatile.Register32 // 0x380
	FUNC149_IN_SEL_CFG volatile.Register32 // 0x384
	FUNC150_IN_SEL_CFG volatile.Register32 // 0x388
	FUNC151_IN_SEL_CFG volatile.Register32 // 0x38C
	FUNC152_IN_SEL_CFG volatile.Register32 // 0x390
	FUNC153_IN_SEL_CFG volatile.Register32 // 0x394
	FUNC154_IN_SEL_CFG volatile.Register32 // 0x398
	FUNC155_IN_SEL_CFG volatile.Register32 // 0x39C
	FUNC156_IN_SEL_CFG volatile.Register32 // 0x3A0
	FUNC157_IN_SEL_CFG volatile.Register32 // 0x3A4
	FUNC158_IN_SEL_CFG volatile.Register32 // 0x3A8
	FUNC159_IN_SEL_CFG volatile.Register32 // 0x3AC
	FUNC160_IN_SEL_CFG volatile.Register32 // 0x3B0
	FUNC161_IN_SEL_CFG volatile.Register32 // 0x3B4
	FUNC162_IN_SEL_CFG volatile.Register32 // 0x3B8
	FUNC163_IN_SEL_CFG volatile.Register32 // 0x3BC
	FUNC164_IN_SEL_CFG volatile.Register32 // 0x3C0
	FUNC165_IN_SEL_CFG volatile.Register32 // 0x3C4
	FUNC166_IN_SEL_CFG volatile.Register32 // 0x3C8
	FUNC167_IN_SEL_CFG volatile.Register32 // 0x3CC
	FUNC168_IN_SEL_CFG volatile.Register32 // 0x3D0
	FUNC169_IN_SEL_CFG volatile.Register32 // 0x3D4
	FUNC170_IN_SEL_CFG volatile.Register32 // 0x3D8
	FUNC171_IN_SEL_CFG volatile.Register32 // 0x3DC
	FUNC172_IN_SEL_CFG volatile.Register32 // 0x3E0
	FUNC173_IN_SEL_CFG volatile.Register32 // 0x3E4
	FUNC174_IN_SEL_CFG volatile.Register32 // 0x3E8
	FUNC175_IN_SEL_CFG volatile.Register32 // 0x3EC
	FUNC176_IN_SEL_CFG volatile.Register32 // 0x3F0
	FUNC177_IN_SEL_CFG volatile.Register32 // 0x3F4
	FUNC178_IN_SEL_CFG volatile.Register32 // 0x3F8
	FUNC179_IN_SEL_CFG volatile.Register32 // 0x3FC
	FUNC180_IN_SEL_CFG volatile.Register32 // 0x400
	FUNC181_IN_SEL_CFG volatile.Register32 // 0x404
	FUNC182_IN_SEL_CFG volatile.Register32 // 0x408
	FUNC183_IN_SEL_CFG volatile.Register32 // 0x40C
	FUNC184_IN_SEL_CFG volatile.Register32 // 0x410
	FUNC185_IN_SEL_CFG volatile.Register32 // 0x414
	FUNC186_IN_SEL_CFG volatile.Register32 // 0x418
	FUNC187_IN_SEL_CFG volatile.Register32 // 0x41C
	FUNC188_IN_SEL_CFG volatile.Register32 // 0x420
	FUNC189_IN_SEL_CFG volatile.Register32 // 0x424
	FUNC190_IN_SEL_CFG volatile.Register32 // 0x428
	FUNC191_IN_SEL_CFG volatile.Register32 // 0x42C
	FUNC192_IN_SEL_CFG volatile.Register32 // 0x430
	FUNC193_IN_SEL_CFG volatile.Register32 // 0x434
	FUNC194_IN_SEL_CFG volatile.Register32 // 0x438
	FUNC195_IN_SEL_CFG volatile.Register32 // 0x43C
	FUNC196_IN_SEL_CFG volatile.Register32 // 0x440
	FUNC197_IN_SEL_CFG volatile.Register32 // 0x444
	FUNC198_IN_SEL_CFG volatile.Register32 // 0x448
	FUNC199_IN_SEL_CFG volatile.Register32 // 0x44C
	FUNC200_IN_SEL_CFG volatile.Register32 // 0x450
	FUNC201_IN_SEL_CFG volatile.Register32 // 0x454
	FUNC202_IN_SEL_CFG volatile.Register32 // 0x458
	FUNC203_IN_SEL_CFG volatile.Register32 // 0x45C
	FUNC204_IN_SEL_CFG volatile.Register32 // 0x460
	FUNC205_IN_SEL_CFG volatile.Register32 // 0x464
	FUNC206_IN_SEL_CFG volatile.Register32 // 0x468
	FUNC207_IN_SEL_CFG volatile.Register32 // 0x46C
	FUNC208_IN_SEL_CFG volatile.Register32 // 0x470
	FUNC209_IN_SEL_CFG volatile.Register32 // 0x474
	FUNC210_IN_SEL_CFG volatile.Register32 // 0x478
	FUNC211_IN_SEL_CFG volatile.Register32 // 0x47C
	FUNC212_IN_SEL_CFG volatile.Register32 // 0x480
	FUNC213_IN_SEL_CFG volatile.Register32 // 0x484
	FUNC214_IN_SEL_CFG volatile.Register32 // 0x488
	FUNC215_IN_SEL_CFG volatile.Register32 // 0x48C
	FUNC216_IN_SEL_CFG volatile.Register32 // 0x490
	FUNC217_IN_SEL_CFG volatile.Register32 // 0x494
	FUNC218_IN_SEL_CFG volatile.Register32 // 0x498
	FUNC219_IN_SEL_CFG volatile.Register32 // 0x49C
	FUNC220_IN_SEL_CFG volatile.Register32 // 0x4A0
	FUNC221_IN_SEL_CFG volatile.Register32 // 0x4A4
	FUNC222_IN_SEL_CFG volatile.Register32 // 0x4A8
	FUNC223_IN_SEL_CFG volatile.Register32 // 0x4AC
	FUNC224_IN_SEL_CFG volatile.Register32 // 0x4B0
	FUNC225_IN_SEL_CFG volatile.Register32 // 0x4B4
	FUNC226_IN_SEL_CFG volatile.Register32 // 0x4B8
	FUNC227_IN_SEL_CFG volatile.Register32 // 0x4BC
	FUNC228_IN_SEL_CFG volatile.Register32 // 0x4C0
	FUNC229_IN_SEL_CFG volatile.Register32 // 0x4C4
	FUNC230_IN_SEL_CFG volatile.Register32 // 0x4C8
	FUNC231_IN_SEL_CFG volatile.Register32 // 0x4CC
	FUNC232_IN_SEL_CFG volatile.Register32 // 0x4D0
	FUNC233_IN_SEL_CFG volatile.Register32 // 0x4D4
	FUNC234_IN_SEL_CFG volatile.Register32 // 0x4D8
	FUNC235_IN_SEL_CFG volatile.Register32 // 0x4DC
	FUNC236_IN_SEL_CFG volatile.Register32 // 0x4E0
	FUNC237_IN_SEL_CFG volatile.Register32 // 0x4E4
	FUNC238_IN_SEL_CFG volatile.Register32 // 0x4E8
	FUNC239_IN_SEL_CFG volatile.Register32 // 0x4EC
	FUNC240_IN_SEL_CFG volatile.Register32 // 0x4F0
	FUNC241_IN_SEL_CFG volatile.Register32 // 0x4F4
	FUNC242_IN_SEL_CFG volatile.Register32 // 0x4F8
	FUNC243_IN_SEL_CFG volatile.Register32 // 0x4FC
	FUNC244_IN_SEL_CFG volatile.Register32 // 0x500
	FUNC245_IN_SEL_CFG volatile.Register32 // 0x504
	FUNC246_IN_SEL_CFG volatile.Register32 // 0x508
	FUNC247_IN_SEL_CFG volatile.Register32 // 0x50C
	FUNC248_IN_SEL_CFG volatile.Register32 // 0x510
	FUNC249_IN_SEL_CFG volatile.Register32 // 0x514
	FUNC250_IN_SEL_CFG volatile.Register32 // 0x518
	FUNC251_IN_SEL_CFG volatile.Register32 // 0x51C
	FUNC252_IN_SEL_CFG volatile.Register32 // 0x520
	FUNC253_IN_SEL_CFG volatile.Register32 // 0x524
	FUNC254_IN_SEL_CFG volatile.Register32 // 0x528
	FUNC255_IN_SEL_CFG volatile.Register32 // 0x52C
	FUNC0_OUT_SEL_CFG  volatile.Register32 // 0x530
	FUNC1_OUT_SEL_CFG  volatile.Register32 // 0x534
	FUNC2_OUT_SEL_CFG  volatile.Register32 // 0x538
	FUNC3_OUT_SEL_CFG  volatile.Register32 // 0x53C
	FUNC4_OUT_SEL_CFG  volatile.Register32 // 0x540
	FUNC5_OUT_SEL_CFG  volatile.Register32 // 0x544
	FUNC6_OUT_SEL_CFG  volatile.Register32 // 0x548
	FUNC7_OUT_SEL_CFG  volatile.Register32 // 0x54C
	FUNC8_OUT_SEL_CFG  volatile.Register32 // 0x550
	FUNC9_OUT_SEL_CFG  volatile.Register32 // 0x554
	FUNC10_OUT_SEL_CFG volatile.Register32 // 0x558
	FUNC11_OUT_SEL_CFG volatile.Register32 // 0x55C
	FUNC12_OUT_SEL_CFG volatile.Register32 // 0x560
	FUNC13_OUT_SEL_CFG volatile.Register32 // 0x564
	FUNC14_OUT_SEL_CFG volatile.Register32 // 0x568
	FUNC15_OUT_SEL_CFG volatile.Register32 // 0x56C
	FUNC16_OUT_SEL_CFG volatile.Register32 // 0x570
	FUNC17_OUT_SEL_CFG volatile.Register32 // 0x574
	FUNC18_OUT_SEL_CFG volatile.Register32 // 0x578
	FUNC19_OUT_SEL_CFG volatile.Register32 // 0x57C
	FUNC20_OUT_SEL_CFG volatile.Register32 // 0x580
	FUNC21_OUT_SEL_CFG volatile.Register32 // 0x584
	FUNC22_OUT_SEL_CFG volatile.Register32 // 0x588
	FUNC23_OUT_SEL_CFG volatile.Register32 // 0x58C
	FUNC24_OUT_SEL_CFG volatile.Register32 // 0x590
	FUNC25_OUT_SEL_CFG volatile.Register32 // 0x594
	FUNC26_OUT_SEL_CFG volatile.Register32 // 0x598
	FUNC27_OUT_SEL_CFG volatile.Register32 // 0x59C
	FUNC28_OUT_SEL_CFG volatile.Register32 // 0x5A0
	FUNC29_OUT_SEL_CFG volatile.Register32 // 0x5A4
	FUNC30_OUT_SEL_CFG volatile.Register32 // 0x5A8
	FUNC31_OUT_SEL_CFG volatile.Register32 // 0x5AC
	FUNC32_OUT_SEL_CFG volatile.Register32 // 0x5B0
	FUNC33_OUT_SEL_CFG volatile.Register32 // 0x5B4
	FUNC34_OUT_SEL_CFG volatile.Register32 // 0x5B8
	FUNC35_OUT_SEL_CFG volatile.Register32 // 0x5BC
	FUNC36_OUT_SEL_CFG volatile.Register32 // 0x5C0
	FUNC37_OUT_SEL_CFG volatile.Register32 // 0x5C4
	FUNC38_OUT_SEL_CFG volatile.Register32 // 0x5C8
	FUNC39_OUT_SEL_CFG volatile.Register32 // 0x5CC
}

// GPIO.BT_SELECT
func (o *GPIO_Type) SetBT_SELECT(value uint32) {
	volatile.StoreUint32(&o.BT_SELECT.Reg, value)
}
func (o *GPIO_Type) GetBT_SELECT() uint32 {
	return volatile.LoadUint32(&o.BT_SELECT.Reg)
}

// GPIO.OUT
func (o *GPIO_Type) SetOUT(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, value)
}
func (o *GPIO_Type) GetOUT() uint32 {
	return volatile.LoadUint32(&o.OUT.Reg)
}

// GPIO.OUT_W1TS
func (o *GPIO_Type) SetOUT_W1TS(value uint32) {
	volatile.StoreUint32(&o.OUT_W1TS.Reg, value)
}
func (o *GPIO_Type) GetOUT_W1TS() uint32 {
	return volatile.LoadUint32(&o.OUT_W1TS.Reg)
}

// GPIO.OUT_W1TC
func (o *GPIO_Type) SetOUT_W1TC(value uint32) {
	volatile.StoreUint32(&o.OUT_W1TC.Reg, value)
}
func (o *GPIO_Type) GetOUT_W1TC() uint32 {
	return volatile.LoadUint32(&o.OUT_W1TC.Reg)
}

// GPIO.OUT1
func (o *GPIO_Type) SetOUT1_DATA(value uint32) {
	volatile.StoreUint32(&o.OUT1.Reg, volatile.LoadUint32(&o.OUT1.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetOUT1_DATA() uint32 {
	return volatile.LoadUint32(&o.OUT1.Reg) & 0xff
}

// GPIO.OUT1_W1TS
func (o *GPIO_Type) SetOUT1_W1TS_OUT1_DATA_W1TS(value uint32) {
	volatile.StoreUint32(&o.OUT1_W1TS.Reg, volatile.LoadUint32(&o.OUT1_W1TS.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetOUT1_W1TS_OUT1_DATA_W1TS() uint32 {
	return volatile.LoadUint32(&o.OUT1_W1TS.Reg) & 0xff
}

// GPIO.OUT1_W1TC
func (o *GPIO_Type) SetOUT1_W1TC_OUT1_DATA_W1TC(value uint32) {
	volatile.StoreUint32(&o.OUT1_W1TC.Reg, volatile.LoadUint32(&o.OUT1_W1TC.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetOUT1_W1TC_OUT1_DATA_W1TC() uint32 {
	return volatile.LoadUint32(&o.OUT1_W1TC.Reg) & 0xff
}

// GPIO.SDIO_SELECT
func (o *GPIO_Type) SetSDIO_SELECT_SDIO_SEL(value uint32) {
	volatile.StoreUint32(&o.SDIO_SELECT.Reg, volatile.LoadUint32(&o.SDIO_SELECT.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetSDIO_SELECT_SDIO_SEL() uint32 {
	return volatile.LoadUint32(&o.SDIO_SELECT.Reg) & 0xff
}

// GPIO.ENABLE
func (o *GPIO_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, value)
}
func (o *GPIO_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg)
}

// GPIO.ENABLE_W1TS
func (o *GPIO_Type) SetENABLE_W1TS(value uint32) {
	volatile.StoreUint32(&o.ENABLE_W1TS.Reg, value)
}
func (o *GPIO_Type) GetENABLE_W1TS() uint32 {
	return volatile.LoadUint32(&o.ENABLE_W1TS.Reg)
}

// GPIO.ENABLE_W1TC
func (o *GPIO_Type) SetENABLE_W1TC(value uint32) {
	volatile.StoreUint32(&o.ENABLE_W1TC.Reg, value)
}
func (o *GPIO_Type) GetENABLE_W1TC() uint32 {
	return volatile.LoadUint32(&o.ENABLE_W1TC.Reg)
}

// GPIO.ENABLE1
func (o *GPIO_Type) SetENABLE1_DATA(value uint32) {
	volatile.StoreUint32(&o.ENABLE1.Reg, volatile.LoadUint32(&o.ENABLE1.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetENABLE1_DATA() uint32 {
	return volatile.LoadUint32(&o.ENABLE1.Reg) & 0xff
}

// GPIO.ENABLE1_W1TS
func (o *GPIO_Type) SetENABLE1_W1TS_ENABLE1_DATA_W1TS(value uint32) {
	volatile.StoreUint32(&o.ENABLE1_W1TS.Reg, volatile.LoadUint32(&o.ENABLE1_W1TS.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetENABLE1_W1TS_ENABLE1_DATA_W1TS() uint32 {
	return volatile.LoadUint32(&o.ENABLE1_W1TS.Reg) & 0xff
}

// GPIO.ENABLE1_W1TC
func (o *GPIO_Type) SetENABLE1_W1TC_ENABLE1_DATA_W1TC(value uint32) {
	volatile.StoreUint32(&o.ENABLE1_W1TC.Reg, volatile.LoadUint32(&o.ENABLE1_W1TC.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetENABLE1_W1TC_ENABLE1_DATA_W1TC() uint32 {
	return volatile.LoadUint32(&o.ENABLE1_W1TC.Reg) & 0xff
}

// GPIO.STRAP
func (o *GPIO_Type) SetSTRAP_STRAPPING(value uint32) {
	volatile.StoreUint32(&o.STRAP.Reg, volatile.LoadUint32(&o.STRAP.Reg)&^(0xffff)|value)
}
func (o *GPIO_Type) GetSTRAP_STRAPPING() uint32 {
	return volatile.LoadUint32(&o.STRAP.Reg) & 0xffff
}

// GPIO.IN
func (o *GPIO_Type) SetIN(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, value)
}
func (o *GPIO_Type) GetIN() uint32 {
	return volatile.LoadUint32(&o.IN.Reg)
}

// GPIO.IN1
func (o *GPIO_Type) SetIN1_DATA_NEXT(value uint32) {
	volatile.StoreUint32(&o.IN1.Reg, volatile.LoadUint32(&o.IN1.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetIN1_DATA_NEXT() uint32 {
	return volatile.LoadUint32(&o.IN1.Reg) & 0xff
}

// GPIO.STATUS
func (o *GPIO_Type) SetSTATUS(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, value)
}
func (o *GPIO_Type) GetSTATUS() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg)
}

// GPIO.STATUS_W1TS
func (o *GPIO_Type) SetSTATUS_W1TS(value uint32) {
	volatile.StoreUint32(&o.STATUS_W1TS.Reg, value)
}
func (o *GPIO_Type) GetSTATUS_W1TS() uint32 {
	return volatile.LoadUint32(&o.STATUS_W1TS.Reg)
}

// GPIO.STATUS_W1TC
func (o *GPIO_Type) SetSTATUS_W1TC(value uint32) {
	volatile.StoreUint32(&o.STATUS_W1TC.Reg, value)
}
func (o *GPIO_Type) GetSTATUS_W1TC() uint32 {
	return volatile.LoadUint32(&o.STATUS_W1TC.Reg)
}

// GPIO.STATUS1
func (o *GPIO_Type) SetSTATUS1_INT(value uint32) {
	volatile.StoreUint32(&o.STATUS1.Reg, volatile.LoadUint32(&o.STATUS1.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetSTATUS1_INT() uint32 {
	return volatile.LoadUint32(&o.STATUS1.Reg) & 0xff
}

// GPIO.STATUS1_W1TS
func (o *GPIO_Type) SetSTATUS1_W1TS_STATUS1_INT_W1TS(value uint32) {
	volatile.StoreUint32(&o.STATUS1_W1TS.Reg, volatile.LoadUint32(&o.STATUS1_W1TS.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetSTATUS1_W1TS_STATUS1_INT_W1TS() uint32 {
	return volatile.LoadUint32(&o.STATUS1_W1TS.Reg) & 0xff
}

// GPIO.STATUS1_W1TC
func (o *GPIO_Type) SetSTATUS1_W1TC_STATUS1_INT_W1TC(value uint32) {
	volatile.StoreUint32(&o.STATUS1_W1TC.Reg, volatile.LoadUint32(&o.STATUS1_W1TC.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetSTATUS1_W1TC_STATUS1_INT_W1TC() uint32 {
	return volatile.LoadUint32(&o.STATUS1_W1TC.Reg) & 0xff
}

// GPIO.ACPU_INT
func (o *GPIO_Type) SetACPU_INT(value uint32) {
	volatile.StoreUint32(&o.ACPU_INT.Reg, value)
}
func (o *GPIO_Type) GetACPU_INT() uint32 {
	return volatile.LoadUint32(&o.ACPU_INT.Reg)
}

// GPIO.ACPU_NMI_INT
func (o *GPIO_Type) SetACPU_NMI_INT(value uint32) {
	volatile.StoreUint32(&o.ACPU_NMI_INT.Reg, value)
}
func (o *GPIO_Type) GetACPU_NMI_INT() uint32 {
	return volatile.LoadUint32(&o.ACPU_NMI_INT.Reg)
}

// GPIO.PCPU_INT
func (o *GPIO_Type) SetPCPU_INT(value uint32) {
	volatile.StoreUint32(&o.PCPU_INT.Reg, value)
}
func (o *GPIO_Type) GetPCPU_INT() uint32 {
	return volatile.LoadUint32(&o.PCPU_INT.Reg)
}

// GPIO.PCPU_NMI_INT
func (o *GPIO_Type) SetPCPU_NMI_INT(value uint32) {
	volatile.StoreUint32(&o.PCPU_NMI_INT.Reg, value)
}
func (o *GPIO_Type) GetPCPU_NMI_INT() uint32 {
	return volatile.LoadUint32(&o.PCPU_NMI_INT.Reg)
}

// GPIO.CPUSDIO_INT
func (o *GPIO_Type) SetCPUSDIO_INT(value uint32) {
	volatile.StoreUint32(&o.CPUSDIO_INT.Reg, value)
}
func (o *GPIO_Type) GetCPUSDIO_INT() uint32 {
	return volatile.LoadUint32(&o.CPUSDIO_INT.Reg)
}

// GPIO.ACPU_INT1
func (o *GPIO_Type) SetACPU_INT1_APPCPU_INT_H(value uint32) {
	volatile.StoreUint32(&o.ACPU_INT1.Reg, volatile.LoadUint32(&o.ACPU_INT1.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetACPU_INT1_APPCPU_INT_H() uint32 {
	return volatile.LoadUint32(&o.ACPU_INT1.Reg) & 0xff
}

// GPIO.ACPU_NMI_INT1
func (o *GPIO_Type) SetACPU_NMI_INT1_APPCPU_NMI_INT_H(value uint32) {
	volatile.StoreUint32(&o.ACPU_NMI_INT1.Reg, volatile.LoadUint32(&o.ACPU_NMI_INT1.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetACPU_NMI_INT1_APPCPU_NMI_INT_H() uint32 {
	return volatile.LoadUint32(&o.ACPU_NMI_INT1.Reg) & 0xff
}

// GPIO.PCPU_INT1
func (o *GPIO_Type) SetPCPU_INT1_PROCPU_INT_H(value uint32) {
	volatile.StoreUint32(&o.PCPU_INT1.Reg, volatile.LoadUint32(&o.PCPU_INT1.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetPCPU_INT1_PROCPU_INT_H() uint32 {
	return volatile.LoadUint32(&o.PCPU_INT1.Reg) & 0xff
}

// GPIO.PCPU_NMI_INT1
func (o *GPIO_Type) SetPCPU_NMI_INT1_PROCPU_NMI_INT_H(value uint32) {
	volatile.StoreUint32(&o.PCPU_NMI_INT1.Reg, volatile.LoadUint32(&o.PCPU_NMI_INT1.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetPCPU_NMI_INT1_PROCPU_NMI_INT_H() uint32 {
	return volatile.LoadUint32(&o.PCPU_NMI_INT1.Reg) & 0xff
}

// GPIO.CPUSDIO_INT1
func (o *GPIO_Type) SetCPUSDIO_INT1_SDIO_INT_H(value uint32) {
	volatile.StoreUint32(&o.CPUSDIO_INT1.Reg, volatile.LoadUint32(&o.CPUSDIO_INT1.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetCPUSDIO_INT1_SDIO_INT_H() uint32 {
	return volatile.LoadUint32(&o.CPUSDIO_INT1.Reg) & 0xff
}
func (o *GPIO_Type) SetCPUSDIO_INT1_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.CPUSDIO_INT1.Reg, volatile.LoadUint32(&o.CPUSDIO_INT1.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetCPUSDIO_INT1_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.CPUSDIO_INT1.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetCPUSDIO_INT1_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.CPUSDIO_INT1.Reg, volatile.LoadUint32(&o.CPUSDIO_INT1.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetCPUSDIO_INT1_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.CPUSDIO_INT1.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetCPUSDIO_INT1_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CPUSDIO_INT1.Reg, volatile.LoadUint32(&o.CPUSDIO_INT1.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetCPUSDIO_INT1_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CPUSDIO_INT1.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetCPUSDIO_INT1_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.CPUSDIO_INT1.Reg, volatile.LoadUint32(&o.CPUSDIO_INT1.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetCPUSDIO_INT1_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.CPUSDIO_INT1.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetCPUSDIO_INT1_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CPUSDIO_INT1.Reg, volatile.LoadUint32(&o.CPUSDIO_INT1.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetCPUSDIO_INT1_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CPUSDIO_INT1.Reg) & 0x3e000) >> 13
}

// GPIO.PIN0
func (o *GPIO_Type) SetPIN0_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN0_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN0_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN0_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN0_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN0_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN0_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN0_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN0_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN0_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x3e000) >> 13
}

// GPIO.PIN1
func (o *GPIO_Type) SetPIN1_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN1_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN1_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN1_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN1_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN1_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN1_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN1_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN1_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN1_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x3e000) >> 13
}

// GPIO.PIN2
func (o *GPIO_Type) SetPIN2_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN2_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN2_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN2_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN2_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN2_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN2_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN2_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN2_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN2_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x3e000) >> 13
}

// GPIO.PIN3
func (o *GPIO_Type) SetPIN3_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN3_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN3_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN3_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN3_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN3_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN3_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN3_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN3_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN3_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x3e000) >> 13
}

// GPIO.PIN4
func (o *GPIO_Type) SetPIN4_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN4_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN4_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN4_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN4_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN4_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN4_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN4_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN4_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN4_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x3e000) >> 13
}

// GPIO.PIN5
func (o *GPIO_Type) SetPIN5_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN5_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN5_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN5_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN5_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN5_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN5_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN5_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN5_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN5_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x3e000) >> 13
}

// GPIO.PIN6
func (o *GPIO_Type) SetPIN6_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN6_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN6_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN6_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN6_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN6_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN6_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN6_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN6_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN6_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x3e000) >> 13
}

// GPIO.PIN7
func (o *GPIO_Type) SetPIN7_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN7_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN7_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN7_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN7_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN7_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN7_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN7_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN7_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN7_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x3e000) >> 13
}

// GPIO.PIN8
func (o *GPIO_Type) SetPIN8_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN8_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN8_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN8_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN8_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN8_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN8_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN8_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN8_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN8_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x3e000) >> 13
}

// GPIO.PIN9
func (o *GPIO_Type) SetPIN9_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN9_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN9_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN9_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN9_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN9_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN9_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN9_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN9_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN9_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x3e000) >> 13
}

// GPIO.PIN10
func (o *GPIO_Type) SetPIN10_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN10_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN10_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN10_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN10_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN10_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN10_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN10_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN10_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN10_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x3e000) >> 13
}

// GPIO.PIN11
func (o *GPIO_Type) SetPIN11_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN11_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN11_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN11_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN11_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN11_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN11_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN11_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN11_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN11_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x3e000) >> 13
}

// GPIO.PIN12
func (o *GPIO_Type) SetPIN12_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN12_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN12_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN12_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN12_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN12_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN12_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN12_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN12_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN12_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x3e000) >> 13
}

// GPIO.PIN13
func (o *GPIO_Type) SetPIN13_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN13_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN13_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN13_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN13_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN13_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN13_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN13_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN13_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN13_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x3e000) >> 13
}

// GPIO.PIN14
func (o *GPIO_Type) SetPIN14_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN14_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN14_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN14_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN14_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN14_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN14_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN14_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN14_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN14_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x3e000) >> 13
}

// GPIO.PIN15
func (o *GPIO_Type) SetPIN15_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN15_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN15_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN15_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN15_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN15_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN15_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN15_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN15_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN15_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x3e000) >> 13
}

// GPIO.PIN16
func (o *GPIO_Type) SetPIN16_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN16_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN16_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN16_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN16_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN16_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN16_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN16_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN16_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN16_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x3e000) >> 13
}

// GPIO.PIN17
func (o *GPIO_Type) SetPIN17_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN17_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN17_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN17_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN17_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN17_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN17_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN17_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN17_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN17_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x3e000) >> 13
}

// GPIO.PIN18
func (o *GPIO_Type) SetPIN18_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN18_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN18_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN18_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN18_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN18_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN18_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN18_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN18_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN18_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x3e000) >> 13
}

// GPIO.PIN19
func (o *GPIO_Type) SetPIN19_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN19_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN19_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN19_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN19_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN19_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN19_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN19_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN19_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN19_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x3e000) >> 13
}

// GPIO.PIN20
func (o *GPIO_Type) SetPIN20_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN20_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN20_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN20_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN20_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN20_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN20_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN20_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN20_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN20_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x3e000) >> 13
}

// GPIO.PIN21
func (o *GPIO_Type) SetPIN21_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN21_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN21_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN21_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN21_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN21_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN21_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN21_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN21_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN21_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x3e000) >> 13
}

// GPIO.PIN22
func (o *GPIO_Type) SetPIN22_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN22_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN22_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN22_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN22_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN22_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN22_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN22_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN22_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN22_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x3e000) >> 13
}

// GPIO.PIN23
func (o *GPIO_Type) SetPIN23_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN23_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN23_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN23_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN23_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN23_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN23_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN23_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN23_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN23_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x3e000) >> 13
}

// GPIO.PIN24
func (o *GPIO_Type) SetPIN24_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN24_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN24_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN24_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN24_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN24_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN24_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN24_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN24_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN24_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x3e000) >> 13
}

// GPIO.PIN25
func (o *GPIO_Type) SetPIN25_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN25_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN25_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN25_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN25_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN25_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN25_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN25_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN25_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN25_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x3e000) >> 13
}

// GPIO.PIN26
func (o *GPIO_Type) SetPIN26_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN26.Reg, volatile.LoadUint32(&o.PIN26.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN26_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN26.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN26_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN26.Reg, volatile.LoadUint32(&o.PIN26.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN26_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN26.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN26_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN26.Reg, volatile.LoadUint32(&o.PIN26.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN26_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN26.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN26_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN26.Reg, volatile.LoadUint32(&o.PIN26.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN26_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN26.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN26_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN26.Reg, volatile.LoadUint32(&o.PIN26.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN26_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN26.Reg) & 0x3e000) >> 13
}

// GPIO.PIN27
func (o *GPIO_Type) SetPIN27_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN27.Reg, volatile.LoadUint32(&o.PIN27.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN27_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN27.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN27_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN27.Reg, volatile.LoadUint32(&o.PIN27.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN27_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN27.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN27_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN27.Reg, volatile.LoadUint32(&o.PIN27.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN27_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN27.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN27_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN27.Reg, volatile.LoadUint32(&o.PIN27.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN27_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN27.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN27_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN27.Reg, volatile.LoadUint32(&o.PIN27.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN27_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN27.Reg) & 0x3e000) >> 13
}

// GPIO.PIN28
func (o *GPIO_Type) SetPIN28_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN28.Reg, volatile.LoadUint32(&o.PIN28.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN28_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN28.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN28_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN28.Reg, volatile.LoadUint32(&o.PIN28.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN28_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN28.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN28_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN28.Reg, volatile.LoadUint32(&o.PIN28.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN28_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN28.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN28_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN28.Reg, volatile.LoadUint32(&o.PIN28.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN28_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN28.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN28_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN28.Reg, volatile.LoadUint32(&o.PIN28.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN28_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN28.Reg) & 0x3e000) >> 13
}

// GPIO.PIN29
func (o *GPIO_Type) SetPIN29_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN29.Reg, volatile.LoadUint32(&o.PIN29.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN29_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN29.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN29_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN29.Reg, volatile.LoadUint32(&o.PIN29.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN29_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN29.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN29_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN29.Reg, volatile.LoadUint32(&o.PIN29.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN29_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN29.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN29_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN29.Reg, volatile.LoadUint32(&o.PIN29.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN29_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN29.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN29_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN29.Reg, volatile.LoadUint32(&o.PIN29.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN29_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN29.Reg) & 0x3e000) >> 13
}

// GPIO.PIN30
func (o *GPIO_Type) SetPIN30_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN30.Reg, volatile.LoadUint32(&o.PIN30.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN30_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN30.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN30_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN30.Reg, volatile.LoadUint32(&o.PIN30.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN30_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN30.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN30_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN30.Reg, volatile.LoadUint32(&o.PIN30.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN30_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN30.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN30_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN30.Reg, volatile.LoadUint32(&o.PIN30.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN30_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN30.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN30_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN30.Reg, volatile.LoadUint32(&o.PIN30.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN30_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN30.Reg) & 0x3e000) >> 13
}

// GPIO.PIN31
func (o *GPIO_Type) SetPIN31_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN31.Reg, volatile.LoadUint32(&o.PIN31.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN31_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN31.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN31_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN31.Reg, volatile.LoadUint32(&o.PIN31.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN31_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN31.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN31_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN31.Reg, volatile.LoadUint32(&o.PIN31.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN31_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN31.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN31_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN31.Reg, volatile.LoadUint32(&o.PIN31.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN31_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN31.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN31_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN31.Reg, volatile.LoadUint32(&o.PIN31.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN31_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN31.Reg) & 0x3e000) >> 13
}

// GPIO.PIN32
func (o *GPIO_Type) SetPIN32_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN32.Reg, volatile.LoadUint32(&o.PIN32.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN32_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN32.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN32_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN32.Reg, volatile.LoadUint32(&o.PIN32.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN32_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN32.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN32_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN32.Reg, volatile.LoadUint32(&o.PIN32.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN32_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN32.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN32_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN32.Reg, volatile.LoadUint32(&o.PIN32.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN32_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN32.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN32_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN32.Reg, volatile.LoadUint32(&o.PIN32.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN32_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN32.Reg) & 0x3e000) >> 13
}

// GPIO.PIN33
func (o *GPIO_Type) SetPIN33_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN33.Reg, volatile.LoadUint32(&o.PIN33.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN33_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN33.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN33_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN33.Reg, volatile.LoadUint32(&o.PIN33.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN33_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN33.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN33_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN33.Reg, volatile.LoadUint32(&o.PIN33.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN33_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN33.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN33_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN33.Reg, volatile.LoadUint32(&o.PIN33.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN33_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN33.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN33_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN33.Reg, volatile.LoadUint32(&o.PIN33.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN33_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN33.Reg) & 0x3e000) >> 13
}

// GPIO.PIN34
func (o *GPIO_Type) SetPIN34_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN34.Reg, volatile.LoadUint32(&o.PIN34.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN34_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN34.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN34_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN34.Reg, volatile.LoadUint32(&o.PIN34.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN34_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN34.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN34_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN34.Reg, volatile.LoadUint32(&o.PIN34.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN34_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN34.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN34_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN34.Reg, volatile.LoadUint32(&o.PIN34.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN34_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN34.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN34_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN34.Reg, volatile.LoadUint32(&o.PIN34.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN34_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN34.Reg) & 0x3e000) >> 13
}

// GPIO.PIN35
func (o *GPIO_Type) SetPIN35_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN35.Reg, volatile.LoadUint32(&o.PIN35.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN35_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN35.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN35_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN35.Reg, volatile.LoadUint32(&o.PIN35.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN35_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN35.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN35_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN35.Reg, volatile.LoadUint32(&o.PIN35.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN35_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN35.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN35_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN35.Reg, volatile.LoadUint32(&o.PIN35.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN35_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN35.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN35_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN35.Reg, volatile.LoadUint32(&o.PIN35.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN35_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN35.Reg) & 0x3e000) >> 13
}

// GPIO.PIN36
func (o *GPIO_Type) SetPIN36_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN36.Reg, volatile.LoadUint32(&o.PIN36.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN36_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN36.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN36_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN36.Reg, volatile.LoadUint32(&o.PIN36.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN36_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN36.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN36_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN36.Reg, volatile.LoadUint32(&o.PIN36.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN36_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN36.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN36_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN36.Reg, volatile.LoadUint32(&o.PIN36.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN36_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN36.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN36_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN36.Reg, volatile.LoadUint32(&o.PIN36.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN36_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN36.Reg) & 0x3e000) >> 13
}

// GPIO.PIN37
func (o *GPIO_Type) SetPIN37_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN37.Reg, volatile.LoadUint32(&o.PIN37.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN37_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN37.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN37_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN37.Reg, volatile.LoadUint32(&o.PIN37.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN37_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN37.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN37_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN37.Reg, volatile.LoadUint32(&o.PIN37.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN37_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN37.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN37_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN37.Reg, volatile.LoadUint32(&o.PIN37.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN37_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN37.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN37_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN37.Reg, volatile.LoadUint32(&o.PIN37.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN37_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN37.Reg) & 0x3e000) >> 13
}

// GPIO.PIN38
func (o *GPIO_Type) SetPIN38_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN38.Reg, volatile.LoadUint32(&o.PIN38.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN38_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN38.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN38_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN38.Reg, volatile.LoadUint32(&o.PIN38.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN38_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN38.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN38_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN38.Reg, volatile.LoadUint32(&o.PIN38.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN38_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN38.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN38_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN38.Reg, volatile.LoadUint32(&o.PIN38.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN38_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN38.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN38_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN38.Reg, volatile.LoadUint32(&o.PIN38.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN38_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN38.Reg) & 0x3e000) >> 13
}

// GPIO.PIN39
func (o *GPIO_Type) SetPIN39_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN39.Reg, volatile.LoadUint32(&o.PIN39.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN39_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN39.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN39_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN39.Reg, volatile.LoadUint32(&o.PIN39.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN39_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN39.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN39_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN39.Reg, volatile.LoadUint32(&o.PIN39.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN39_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN39.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN39_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN39.Reg, volatile.LoadUint32(&o.PIN39.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN39_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN39.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN39_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN39.Reg, volatile.LoadUint32(&o.PIN39.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN39_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN39.Reg) & 0x3e000) >> 13
}

// GPIO.CALI_CONF
func (o *GPIO_Type) SetCALI_CONF_CALI_RTC_MAX(value uint32) {
	volatile.StoreUint32(&o.CALI_CONF.Reg, volatile.LoadUint32(&o.CALI_CONF.Reg)&^(0x3ff)|value)
}
func (o *GPIO_Type) GetCALI_CONF_CALI_RTC_MAX() uint32 {
	return volatile.LoadUint32(&o.CALI_CONF.Reg) & 0x3ff
}
func (o *GPIO_Type) SetCALI_CONF_CALI_START(value uint32) {
	volatile.StoreUint32(&o.CALI_CONF.Reg, volatile.LoadUint32(&o.CALI_CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetCALI_CONF_CALI_START() uint32 {
	return (volatile.LoadUint32(&o.CALI_CONF.Reg) & 0x80000000) >> 31
}

// GPIO.CALI_DATA
func (o *GPIO_Type) SetCALI_DATA_CALI_VALUE_SYNC2(value uint32) {
	volatile.StoreUint32(&o.CALI_DATA.Reg, volatile.LoadUint32(&o.CALI_DATA.Reg)&^(0xfffff)|value)
}
func (o *GPIO_Type) GetCALI_DATA_CALI_VALUE_SYNC2() uint32 {
	return volatile.LoadUint32(&o.CALI_DATA.Reg) & 0xfffff
}
func (o *GPIO_Type) SetCALI_DATA_CALI_RDY_REAL(value uint32) {
	volatile.StoreUint32(&o.CALI_DATA.Reg, volatile.LoadUint32(&o.CALI_DATA.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetCALI_DATA_CALI_RDY_REAL() uint32 {
	return (volatile.LoadUint32(&o.CALI_DATA.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetCALI_DATA_CALI_RDY_SYNC2(value uint32) {
	volatile.StoreUint32(&o.CALI_DATA.Reg, volatile.LoadUint32(&o.CALI_DATA.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetCALI_DATA_CALI_RDY_SYNC2() uint32 {
	return (volatile.LoadUint32(&o.CALI_DATA.Reg) & 0x80000000) >> 31
}

// GPIO.FUNC0_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC0_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC0_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC0_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC0_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC0_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC0_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC1_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC1_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC1_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC1_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC1_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC1_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC1_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC2_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC2_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC2_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC2_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC2_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC2_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC2_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC3_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC3_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC3_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC3_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC3_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC3_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC3_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC4_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC4_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC4_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC4_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC4_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC4_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC4_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC5_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC5_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC5_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC5_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC5_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC5_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC5_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC6_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC6_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC6_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC6_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC6_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC6_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC6_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC7_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC7_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC7_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC7_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC7_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC7_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC7_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC8_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC8_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC8_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC8_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC8_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC8_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC8_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC9_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC9_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC9_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC9_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC9_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC9_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC9_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC10_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC10_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC10_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC10_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC10_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC10_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC10_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC11_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC11_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC11_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC11_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC11_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC11_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC11_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC12_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC12_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC12_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC12_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC12_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC12_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC12_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC13_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC13_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC13_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC13_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC13_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC13_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC13_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC14_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC14_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC14_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC14_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC14_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC14_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC14_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC15_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC15_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC15_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC15_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC15_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC15_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC15_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC16_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC16_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC16_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC16_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC16_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC16_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC16_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC17_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC17_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC17_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC17_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC17_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC17_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC17_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC18_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC18_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC18_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC18_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC18_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC18_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC18_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC19_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC19_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC19_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC19_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC19_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC19_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC19_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC20_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC20_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC20_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC20_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC20_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC20_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC20_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC21_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC21_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC21_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC21_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC21_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC21_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC21_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC22_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC22_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC22_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC22_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC22_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC22_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC22_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC23_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC23_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC23_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC23_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC23_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC23_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC23_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC24_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC24_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC24_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC24_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC24_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC24_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC24_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC25_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC25_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC25_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC25_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC25_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC25_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC25_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC26_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC26_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC26_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC26_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC26_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC26_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC26_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC27_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC27_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC27_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC27_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC27_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC27_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC27_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC28_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC28_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC28_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC28_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC28_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC28_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC28_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC29_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC29_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC29_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC29_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC29_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC29_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC29_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC30_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC30_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC30_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC30_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC30_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC30_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC30_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC30_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC30_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC30_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC31_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC31_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC31_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC31_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC31_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC31_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC31_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC31_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC31_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC31_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC32_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC32_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC32_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC32_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC32_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC32_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC32_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC32_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC32_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC32_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC33_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC33_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC33_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC33_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC33_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC33_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC33_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC33_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC33_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC33_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC34_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC34_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC34_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC34_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC34_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC34_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC34_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC34_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC34_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC34_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC35_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC35_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC35_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC35_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC35_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC35_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC35_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC35_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC35_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC35_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC36_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC36_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC36_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC36_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC36_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC36_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC36_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC36_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC36_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC36_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC37_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC37_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC37_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC37_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC37_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC37_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC37_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC37_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC37_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC37_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC38_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC38_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC38_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC38_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC38_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC38_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC38_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC38_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC38_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC38_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC39_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC39_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC39_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC39_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC39_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC39_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC39_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC39_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC39_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC39_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC40_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC40_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC40_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC40_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC40_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC40_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC40_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC40_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC40_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC40_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC41_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC41_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC41_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC41_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC41_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC41_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC41_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC41_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC41_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC41_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC42_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC42_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC42_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC42_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC42_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC42_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC42_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC42_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC42_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC42_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC43_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC43_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC43_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC43_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC43_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC43_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC43_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC43_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC43_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC43_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC44_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC44_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC44_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC44_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC44_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC44_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC44_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC44_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC44_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC44_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC45_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC45_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC45_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC45_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC45_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC45_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC45_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC45_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC45_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC45_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC46_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC46_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC46_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC46_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC46_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC46_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC46_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC46_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC46_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC46_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC47_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC47_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC47_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC47_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC47_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC47_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC47_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC47_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC47_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC47_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC48_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC48_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC48_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC48_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC48_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC48_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC48_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC48_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC48_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC48_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC49_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC49_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC49_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC49_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC49_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC49_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC49_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC49_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC49_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC49_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC50_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC50_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC50_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC50_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC50_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC50_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC50_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC50_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC50_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC50_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC51_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC51_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC51_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC51_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC51_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC51_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC51_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC51_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC51_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC51_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC52_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC52_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC52_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC52_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC52_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC52_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC52_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC52_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC52_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC52_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC53_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC53_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC53_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC53_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC53_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC53_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC53_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC53_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC53_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC53_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC54_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC54_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC54_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC54_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC54_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC54_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC54_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC54_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC54_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC54_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC55_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC55_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC55_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC55_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC55_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC55_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC55_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC55_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC55_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC55_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC56_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC56_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC56_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC56_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC56_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC56_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC56_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC56_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC56_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC56_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC57_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC57_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC57_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC57_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC57_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC57_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC57_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC57_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC57_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC57_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC58_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC58_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC58_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC58_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC58_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC58_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC58_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC58_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC58_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC58_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC59_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC59_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC59_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC59_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC59_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC59_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC59_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC59_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC59_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC59_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC60_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC60_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC60_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC60_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC60_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC60_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC60_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC60_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC60_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC60_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC61_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC61_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC61_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC61_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC61_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC61_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC61_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC61_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC61_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC61_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC62_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC62_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC62_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC62_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC62_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC62_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC62_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC62_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC62_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC62_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC63_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC63_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC63_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC63_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC63_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC63_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC63_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC63_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC63_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC63_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC64_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC64_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC64_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC64_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC64_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC64_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC64_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC64_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC64_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC64_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC65_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC65_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC65_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC65_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC65_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC65_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC65_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC65_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC65_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC65_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC66_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC66_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC66_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC66_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC66_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC66_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC66_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC66_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC66_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC66_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC67_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC67_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC67_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC67_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC67_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC67_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC67_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC67_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC67_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC67_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC68_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC68_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC68_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC68_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC68_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC68_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC68_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC68_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC68_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC68_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC69_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC69_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC69_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC69_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC69_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC69_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC69_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC69_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC69_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC69_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC70_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC70_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC70_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC70_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC70_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC70_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC70_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC70_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC70_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC70_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC71_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC71_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC71_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC71_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC71_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC71_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC71_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC71_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC71_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC71_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC72_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC72_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC72_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC72_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC72_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC72_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC72_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC72_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC72_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC72_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC73_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC73_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC73_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC73_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC73_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC73_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC73_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC73_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC73_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC73_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC74_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC74_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC74_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC74_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC74_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC74_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC74_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC74_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC74_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC74_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC75_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC75_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC75_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC75_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC75_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC75_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC75_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC75_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC75_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC75_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC76_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC76_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC76_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC76_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC76_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC76_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC76_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC76_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC76_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC76_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC77_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC77_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC77_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC77_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC77_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC77_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC77_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC77_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC77_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC77_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC78_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC78_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC78_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC78_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC78_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC78_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC78_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC78_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC78_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC78_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC79_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC79_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC79_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC79_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC79_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC79_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC79_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC79_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC79_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC79_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC80_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC80_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC80_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC80_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC80_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC80_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC80_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC80_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC80_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC80_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC81_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC81_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC81_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC81_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC81_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC81_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC81_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC81_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC81_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC81_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC82_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC82_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC82_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC82_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC82_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC82_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC82_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC82_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC82_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC82_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC83_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC83_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC83_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC83_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC83_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC83_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC83_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC83_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC83_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC83_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC84_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC84_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC84_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC84_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC84_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC84_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC84_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC84_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC84_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC84_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC85_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC85_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC85_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC85_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC85_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC85_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC85_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC85_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC85_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC85_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC86_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC86_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC86_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC86_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC86_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC86_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC86_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC86_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC86_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC86_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC87_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC87_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC87_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC87_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC87_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC87_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC87_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC87_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC87_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC87_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC88_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC88_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC88_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC88_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC88_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC88_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC88_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC88_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC88_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC88_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC89_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC89_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC89_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC89_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC89_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC89_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC89_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC89_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC89_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC89_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC90_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC90_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC90_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC90_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC90_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC90_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC90_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC90_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC90_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC90_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC91_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC91_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC91_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC91_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC91_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC91_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC91_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC91_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC91_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC91_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC92_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC92_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC92_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC92_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC92_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC92_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC92_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC92_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC92_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC92_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC93_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC93_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC93_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC93_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC93_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC93_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC93_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC93_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC93_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC93_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC94_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC94_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC94_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC94_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC94_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC94_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC94_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC94_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC94_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC94_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC95_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC95_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC95_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC95_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC95_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC95_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC95_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC95_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC95_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC95_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC96_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC96_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC96_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC96_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC96_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC96_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC96_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC96_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC96_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC96_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC97_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC97_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC97_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC97_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC97_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC97_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC97_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC97_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC97_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC97_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC98_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC98_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC98_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC98_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC98_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC98_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC98_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC98_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC98_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC98_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC99_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC99_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC99_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC99_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC99_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC99_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC99_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC99_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC99_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC99_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC100_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC100_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC100_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC100_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC100_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC100_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC100_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC100_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC100_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC100_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC101_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC101_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC101_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC101_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC101_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC101_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC101_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC101_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC101_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC101_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC102_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC102_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC102_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC102_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC102_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC102_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC102_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC102_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC102_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC102_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC103_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC103_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC103_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC103_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC103_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC103_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC103_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC103_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC103_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC103_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC104_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC104_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC104_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC104_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC104_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC104_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC104_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC104_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC104_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC104_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC105_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC105_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC105_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC105_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC105_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC105_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC105_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC105_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC105_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC105_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC106_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC106_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC106_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC106_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC106_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC106_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC106_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC106_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC106_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC106_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC107_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC107_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC107_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC107_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC107_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC107_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC107_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC107_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC107_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC107_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC108_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC108_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC108_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC108_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC108_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC108_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC108_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC108_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC108_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC108_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC109_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC109_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC109_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC109_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC109_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC109_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC109_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC109_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC109_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC109_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC110_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC110_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC110_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC110_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC110_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC110_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC110_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC110_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC110_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC110_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC111_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC111_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC111_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC111_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC111_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC111_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC111_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC111_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC111_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC111_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC112_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC112_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC112_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC112_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC112_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC112_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC112_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC112_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC112_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC112_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC113_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC113_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC113_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC113_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC113_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC113_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC113_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC113_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC113_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC113_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC114_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC114_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC114_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC114_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC114_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC114_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC114_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC114_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC114_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC114_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC115_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC115_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC115_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC115_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC115_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC115_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC115_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC115_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC115_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC115_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC116_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC116_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC116_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC116_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC116_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC116_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC116_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC116_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC116_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC116_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC117_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC117_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC117_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC117_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC117_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC117_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC117_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC117_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC117_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC117_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC118_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC118_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC118_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC118_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC118_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC118_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC118_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC118_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC118_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC118_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC119_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC119_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC119_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC119_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC119_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC119_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC119_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC119_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC119_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC119_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC120_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC120_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC120_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC120_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC120_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC120_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC120_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC120_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC120_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC120_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC121_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC121_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC121_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC121_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC121_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC121_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC121_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC121_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC121_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC121_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC122_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC122_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC122_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC122_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC122_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC122_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC122_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC122_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC122_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC122_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC123_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC123_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC123_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC123_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC123_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC123_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC123_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC123_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC123_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC123_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC124_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC124_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC124_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC124_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC124_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC124_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC124_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC124_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC124_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC124_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC125_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC125_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC125_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC125_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC125_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC125_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC125_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC125_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC125_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC125_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC126_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC126_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC126_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC126_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC126_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC126_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC126_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC126_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC126_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC126_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC127_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC127_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC127_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC127_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC127_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC127_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC127_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC127_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC127_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC127_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC128_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC128_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC128_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC128_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC128_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC128_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC128_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC128_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC128_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC128_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC128_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC128_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC128_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC128_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC128_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC128_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC129_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC129_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC129_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC129_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC129_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC129_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC129_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC129_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC129_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC129_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC129_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC129_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC129_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC129_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC129_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC129_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC130_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC130_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC130_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC130_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC130_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC130_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC130_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC130_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC130_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC130_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC130_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC130_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC130_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC130_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC130_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC130_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC131_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC131_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC131_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC131_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC131_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC131_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC131_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC131_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC131_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC131_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC131_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC131_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC131_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC131_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC131_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC131_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC132_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC132_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC132_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC132_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC132_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC132_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC132_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC132_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC132_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC132_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC132_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC132_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC132_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC132_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC132_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC132_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC133_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC133_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC133_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC133_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC133_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC133_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC133_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC133_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC133_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC133_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC133_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC133_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC133_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC133_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC133_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC133_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC134_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC134_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC134_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC134_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC134_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC134_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC134_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC134_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC134_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC134_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC134_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC134_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC134_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC134_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC134_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC134_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC135_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC135_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC135_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC135_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC135_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC135_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC135_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC135_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC135_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC135_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC135_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC135_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC135_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC135_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC135_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC135_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC136_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC136_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC136_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC136_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC136_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC136_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC136_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC136_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC136_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC136_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC136_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC136_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC136_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC136_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC136_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC136_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC137_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC137_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC137_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC137_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC137_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC137_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC137_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC137_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC137_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC137_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC137_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC137_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC137_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC137_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC137_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC137_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC138_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC138_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC138_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC138_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC138_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC138_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC138_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC138_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC138_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC138_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC138_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC138_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC138_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC138_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC138_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC138_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC139_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC139_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC139_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC139_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC139_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC139_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC139_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC139_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC139_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC139_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC139_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC139_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC139_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC139_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC139_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC139_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC140_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC140_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC140_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC140_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC140_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC140_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC140_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC140_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC140_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC140_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC140_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC140_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC140_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC140_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC140_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC140_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC141_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC141_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC141_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC141_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC141_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC141_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC141_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC141_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC141_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC141_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC141_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC141_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC141_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC141_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC141_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC141_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC142_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC142_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC142_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC142_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC142_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC142_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC142_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC142_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC142_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC142_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC142_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC142_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC142_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC142_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC142_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC142_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC143_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC143_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC143_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC143_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC143_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC143_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC143_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC143_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC143_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC143_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC143_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC143_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC143_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC143_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC143_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC143_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC144_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC144_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC144_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC144_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC144_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC144_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC144_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC144_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC144_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC144_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC144_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC144_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC144_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC144_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC144_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC144_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC145_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC145_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC145_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC145_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC145_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC145_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC145_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC145_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC145_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC145_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC145_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC145_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC145_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC145_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC145_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC145_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC146_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC146_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC146_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC146_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC146_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC146_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC146_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC146_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC146_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC146_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC146_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC146_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC146_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC146_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC146_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC146_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC147_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC147_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC147_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC147_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC147_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC147_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC147_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC147_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC147_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC147_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC147_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC147_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC147_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC147_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC147_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC147_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC148_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC148_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC148_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC148_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC148_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC148_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC148_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC148_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC148_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC148_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC148_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC148_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC148_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC148_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC148_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC148_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC149_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC149_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC149_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC149_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC149_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC149_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC149_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC149_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC149_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC149_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC149_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC149_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC149_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC149_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC149_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC149_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC150_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC150_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC150_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC150_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC150_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC150_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC150_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC150_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC150_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC150_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC150_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC150_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC150_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC150_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC150_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC150_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC151_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC151_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC151_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC151_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC151_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC151_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC151_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC151_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC151_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC151_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC151_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC151_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC151_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC151_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC151_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC151_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC152_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC152_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC152_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC152_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC152_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC152_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC152_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC152_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC152_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC152_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC152_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC152_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC152_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC152_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC152_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC152_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC153_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC153_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC153_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC153_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC153_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC153_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC153_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC153_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC153_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC153_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC153_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC153_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC153_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC153_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC153_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC153_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC154_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC154_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC154_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC154_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC154_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC154_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC154_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC154_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC154_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC154_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC154_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC154_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC154_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC154_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC154_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC154_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC155_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC155_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC155_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC155_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC155_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC155_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC155_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC155_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC155_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC155_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC155_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC155_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC155_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC155_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC155_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC155_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC156_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC156_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC156_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC156_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC156_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC156_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC156_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC156_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC156_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC156_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC156_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC156_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC156_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC156_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC156_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC156_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC157_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC157_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC157_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC157_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC157_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC157_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC157_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC157_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC157_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC157_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC157_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC157_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC157_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC157_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC157_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC157_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC158_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC158_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC158_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC158_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC158_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC158_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC158_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC158_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC158_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC158_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC158_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC158_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC158_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC158_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC158_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC158_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC159_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC159_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC159_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC159_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC159_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC159_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC159_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC159_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC159_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC159_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC159_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC159_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC159_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC159_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC159_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC159_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC160_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC160_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC160_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC160_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC160_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC160_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC160_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC160_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC160_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC160_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC160_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC160_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC160_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC160_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC160_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC160_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC161_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC161_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC161_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC161_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC161_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC161_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC161_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC161_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC161_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC161_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC161_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC161_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC161_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC161_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC161_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC161_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC162_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC162_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC162_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC162_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC162_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC162_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC162_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC162_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC162_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC162_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC162_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC162_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC162_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC162_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC162_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC162_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC163_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC163_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC163_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC163_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC163_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC163_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC163_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC163_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC163_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC163_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC163_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC163_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC163_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC163_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC163_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC163_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC164_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC164_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC164_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC164_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC164_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC164_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC164_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC164_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC164_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC164_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC164_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC164_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC164_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC164_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC164_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC164_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC165_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC165_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC165_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC165_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC165_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC165_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC165_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC165_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC165_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC165_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC165_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC165_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC165_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC165_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC165_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC165_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC166_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC166_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC166_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC166_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC166_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC166_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC166_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC166_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC166_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC166_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC166_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC166_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC166_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC166_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC166_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC166_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC167_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC167_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC167_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC167_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC167_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC167_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC167_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC167_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC167_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC167_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC167_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC167_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC167_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC167_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC167_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC167_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC168_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC168_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC168_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC168_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC168_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC168_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC168_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC168_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC168_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC168_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC168_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC168_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC168_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC168_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC168_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC168_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC169_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC169_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC169_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC169_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC169_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC169_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC169_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC169_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC169_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC169_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC169_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC169_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC169_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC169_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC169_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC169_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC170_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC170_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC170_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC170_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC170_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC170_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC170_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC170_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC170_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC170_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC170_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC170_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC170_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC170_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC170_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC170_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC171_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC171_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC171_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC171_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC171_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC171_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC171_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC171_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC171_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC171_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC171_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC171_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC171_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC171_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC171_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC171_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC172_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC172_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC172_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC172_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC172_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC172_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC172_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC172_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC172_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC172_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC172_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC172_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC172_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC172_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC172_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC172_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC173_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC173_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC173_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC173_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC173_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC173_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC173_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC173_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC173_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC173_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC173_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC173_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC173_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC173_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC173_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC173_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC174_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC174_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC174_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC174_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC174_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC174_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC174_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC174_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC174_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC174_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC174_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC174_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC174_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC174_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC174_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC174_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC175_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC175_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC175_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC175_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC175_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC175_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC175_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC175_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC175_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC175_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC175_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC175_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC175_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC175_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC175_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC175_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC176_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC176_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC176_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC176_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC176_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC176_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC176_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC176_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC176_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC176_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC176_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC176_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC176_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC176_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC176_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC176_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC177_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC177_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC177_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC177_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC177_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC177_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC177_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC177_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC177_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC177_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC177_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC177_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC177_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC177_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC177_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC177_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC178_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC178_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC178_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC178_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC178_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC178_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC178_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC178_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC178_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC178_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC178_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC178_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC178_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC178_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC178_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC178_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC179_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC179_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC179_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC179_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC179_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC179_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC179_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC179_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC179_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC179_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC179_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC179_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC179_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC179_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC179_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC179_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC180_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC180_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC180_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC180_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC180_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC180_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC180_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC180_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC180_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC180_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC180_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC180_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC180_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC180_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC180_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC180_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC181_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC181_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC181_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC181_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC181_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC181_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC181_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC181_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC181_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC181_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC181_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC181_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC181_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC181_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC181_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC181_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC182_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC182_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC182_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC182_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC182_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC182_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC182_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC182_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC182_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC182_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC182_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC182_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC182_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC182_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC182_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC182_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC183_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC183_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC183_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC183_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC183_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC183_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC183_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC183_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC183_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC183_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC183_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC183_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC183_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC183_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC183_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC183_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC184_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC184_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC184_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC184_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC184_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC184_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC184_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC184_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC184_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC184_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC184_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC184_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC184_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC184_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC184_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC184_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC185_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC185_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC185_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC185_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC185_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC185_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC185_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC185_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC185_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC185_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC185_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC185_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC185_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC185_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC185_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC185_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC186_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC186_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC186_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC186_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC186_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC186_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC186_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC186_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC186_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC186_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC186_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC186_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC186_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC186_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC186_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC186_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC187_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC187_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC187_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC187_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC187_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC187_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC187_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC187_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC187_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC187_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC187_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC187_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC187_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC187_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC187_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC187_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC188_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC188_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC188_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC188_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC188_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC188_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC188_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC188_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC188_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC188_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC188_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC188_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC188_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC188_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC188_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC188_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC189_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC189_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC189_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC189_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC189_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC189_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC189_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC189_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC189_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC189_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC189_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC189_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC189_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC189_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC189_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC189_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC190_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC190_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC190_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC190_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC190_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC190_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC190_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC190_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC190_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC190_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC190_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC190_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC190_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC190_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC190_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC190_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC191_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC191_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC191_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC191_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC191_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC191_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC191_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC191_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC191_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC191_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC191_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC191_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC191_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC191_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC191_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC191_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC192_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC192_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC192_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC192_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC192_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC192_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC192_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC192_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC192_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC192_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC192_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC192_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC192_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC192_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC192_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC192_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC193_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC193_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC193_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC193_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC193_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC193_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC193_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC193_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC193_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC193_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC193_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC193_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC193_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC193_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC193_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC193_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC194_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC194_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC194_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC194_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC194_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC194_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC194_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC194_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC194_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC194_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC194_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC194_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC194_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC194_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC194_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC194_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC195_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC195_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC195_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC195_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC195_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC195_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC195_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC195_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC195_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC195_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC195_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC195_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC195_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC195_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC195_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC195_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC196_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC196_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC196_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC196_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC196_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC196_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC196_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC196_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC196_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC196_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC196_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC196_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC196_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC196_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC196_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC196_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC197_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC197_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC197_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC197_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC197_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC197_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC197_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC197_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC197_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC197_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC197_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC197_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC197_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC197_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC197_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC197_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC198_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC198_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC198_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC198_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC198_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC198_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC198_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC198_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC198_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC198_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC198_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC198_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC198_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC198_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC198_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC198_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC199_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC199_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC199_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC199_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC199_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC199_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC199_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC199_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC199_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC199_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC199_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC199_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC199_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC199_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC199_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC199_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC200_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC200_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC200_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC200_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC200_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC200_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC200_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC200_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC200_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC200_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC200_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC200_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC200_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC200_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC200_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC200_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC201_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC201_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC201_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC201_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC201_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC201_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC201_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC201_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC201_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC201_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC201_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC201_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC201_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC201_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC201_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC201_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC202_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC202_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC202_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC202_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC202_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC202_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC202_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC202_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC202_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC202_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC202_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC202_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC202_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC202_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC202_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC202_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC203_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC203_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC203_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC203_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC203_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC203_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC203_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC203_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC203_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC203_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC203_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC203_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC203_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC203_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC203_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC203_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC204_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC204_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC204_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC204_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC204_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC204_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC204_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC204_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC204_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC204_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC204_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC204_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC204_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC204_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC204_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC204_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC205_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC205_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC205_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC205_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC205_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC205_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC205_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC205_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC205_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC205_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC205_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC205_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC205_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC205_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC205_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC205_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC206_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC206_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC206_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC206_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC206_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC206_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC206_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC206_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC206_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC206_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC206_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC206_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC206_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC206_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC206_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC206_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC207_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC207_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC207_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC207_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC207_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC207_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC207_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC207_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC207_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC207_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC207_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC207_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC207_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC207_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC207_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC207_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC208_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC208_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC208_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC208_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC208_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC208_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC208_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC208_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC208_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC208_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC208_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC208_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC208_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC208_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC208_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC208_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC209_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC209_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC209_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC209_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC209_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC209_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC209_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC209_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC209_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC209_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC209_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC209_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC209_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC209_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC209_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC209_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC210_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC210_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC210_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC210_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC210_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC210_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC210_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC210_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC210_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC210_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC210_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC210_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC210_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC210_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC210_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC210_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC211_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC211_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC211_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC211_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC211_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC211_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC211_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC211_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC211_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC211_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC211_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC211_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC211_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC211_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC211_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC211_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC212_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC212_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC212_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC212_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC212_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC212_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC212_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC212_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC212_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC212_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC212_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC212_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC212_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC212_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC212_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC212_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC213_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC213_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC213_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC213_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC213_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC213_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC213_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC213_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC213_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC213_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC213_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC213_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC213_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC213_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC213_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC213_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC214_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC214_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC214_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC214_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC214_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC214_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC214_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC214_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC214_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC214_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC214_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC214_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC214_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC214_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC214_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC214_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC215_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC215_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC215_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC215_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC215_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC215_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC215_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC215_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC215_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC215_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC215_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC215_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC215_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC215_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC215_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC215_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC216_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC216_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC216_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC216_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC216_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC216_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC216_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC216_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC216_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC216_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC216_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC216_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC216_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC216_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC216_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC216_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC217_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC217_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC217_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC217_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC217_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC217_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC217_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC217_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC217_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC217_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC217_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC217_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC217_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC217_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC217_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC217_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC218_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC218_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC218_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC218_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC218_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC218_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC218_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC218_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC218_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC218_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC218_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC218_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC218_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC218_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC218_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC218_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC219_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC219_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC219_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC219_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC219_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC219_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC219_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC219_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC219_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC219_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC219_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC219_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC219_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC219_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC219_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC219_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC220_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC220_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC220_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC220_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC220_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC220_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC220_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC220_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC220_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC220_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC220_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC220_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC220_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC220_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC220_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC220_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC221_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC221_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC221_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC221_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC221_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC221_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC221_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC221_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC221_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC221_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC221_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC221_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC221_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC221_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC221_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC221_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC222_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC222_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC222_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC222_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC222_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC222_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC222_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC222_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC222_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC222_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC222_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC222_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC222_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC222_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC222_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC222_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC223_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC223_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC223_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC223_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC223_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC223_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC223_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC223_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC223_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC223_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC223_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC223_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC223_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC223_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC223_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC223_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC224_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC224_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC224_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC224_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC224_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC224_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC224_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC224_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC224_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC224_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC224_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC224_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC224_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC224_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC224_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC224_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC225_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC225_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC225_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC225_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC225_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC225_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC225_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC225_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC225_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC225_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC225_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC225_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC225_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC225_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC225_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC225_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC226_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC226_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC226_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC226_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC226_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC226_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC226_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC226_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC226_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC226_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC226_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC226_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC226_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC226_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC226_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC226_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC227_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC227_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC227_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC227_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC227_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC227_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC227_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC227_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC227_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC227_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC227_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC227_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC227_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC227_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC227_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC227_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC228_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC228_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC228_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC228_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC228_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC228_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC228_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC228_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC228_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC228_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC228_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC228_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC228_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC228_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC228_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC228_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC229_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC229_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC229_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC229_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC229_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC229_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC229_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC229_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC229_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC229_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC229_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC229_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC229_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC229_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC229_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC229_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC230_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC230_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC230_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC230_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC230_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC230_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC230_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC230_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC230_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC230_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC230_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC230_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC230_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC230_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC230_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC230_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC231_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC231_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC231_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC231_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC231_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC231_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC231_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC231_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC231_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC231_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC231_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC231_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC231_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC231_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC231_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC231_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC232_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC232_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC232_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC232_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC232_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC232_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC232_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC232_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC232_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC232_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC232_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC232_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC232_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC232_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC232_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC232_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC233_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC233_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC233_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC233_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC233_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC233_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC233_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC233_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC233_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC233_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC233_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC233_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC233_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC233_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC233_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC233_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC234_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC234_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC234_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC234_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC234_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC234_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC234_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC234_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC234_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC234_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC234_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC234_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC234_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC234_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC234_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC234_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC235_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC235_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC235_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC235_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC235_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC235_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC235_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC235_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC235_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC235_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC235_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC235_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC235_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC235_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC235_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC235_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC236_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC236_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC236_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC236_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC236_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC236_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC236_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC236_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC236_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC236_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC236_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC236_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC236_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC236_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC236_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC236_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC237_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC237_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC237_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC237_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC237_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC237_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC237_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC237_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC237_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC237_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC237_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC237_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC237_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC237_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC237_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC237_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC238_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC238_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC238_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC238_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC238_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC238_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC238_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC238_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC238_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC238_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC238_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC238_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC238_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC238_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC238_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC238_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC239_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC239_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC239_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC239_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC239_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC239_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC239_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC239_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC239_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC239_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC239_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC239_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC239_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC239_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC239_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC239_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC240_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC240_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC240_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC240_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC240_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC240_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC240_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC240_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC240_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC240_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC240_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC240_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC240_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC240_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC240_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC240_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC241_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC241_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC241_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC241_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC241_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC241_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC241_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC241_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC241_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC241_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC241_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC241_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC241_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC241_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC241_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC241_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC242_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC242_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC242_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC242_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC242_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC242_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC242_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC242_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC242_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC242_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC242_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC242_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC242_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC242_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC242_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC242_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC243_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC243_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC243_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC243_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC243_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC243_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC243_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC243_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC243_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC243_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC243_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC243_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC243_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC243_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC243_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC243_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC244_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC244_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC244_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC244_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC244_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC244_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC244_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC244_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC244_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC244_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC244_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC244_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC244_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC244_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC244_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC244_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC245_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC245_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC245_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC245_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC245_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC245_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC245_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC245_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC245_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC245_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC245_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC245_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC245_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC245_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC245_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC245_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC246_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC246_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC246_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC246_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC246_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC246_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC246_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC246_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC246_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC246_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC246_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC246_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC246_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC246_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC246_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC246_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC247_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC247_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC247_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC247_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC247_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC247_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC247_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC247_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC247_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC247_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC247_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC247_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC247_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC247_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC247_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC247_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC248_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC248_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC248_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC248_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC248_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC248_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC248_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC248_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC248_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC248_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC248_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC248_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC248_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC248_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC248_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC248_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC249_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC249_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC249_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC249_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC249_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC249_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC249_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC249_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC249_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC249_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC249_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC249_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC249_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC249_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC249_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC249_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC250_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC250_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC250_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC250_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC250_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC250_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC250_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC250_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC250_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC250_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC250_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC250_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC250_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC250_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC250_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC250_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC251_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC251_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC251_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC251_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC251_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC251_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC251_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC251_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC251_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC251_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC251_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC251_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC251_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC251_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC251_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC251_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC252_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC252_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC252_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC252_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC252_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC252_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC252_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC252_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC252_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC252_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC252_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC252_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC252_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC252_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC252_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC252_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC253_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC253_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC253_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC253_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC253_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC253_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC253_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC253_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC253_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC253_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC253_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC253_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC253_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC253_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC253_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC253_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC254_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC254_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC254_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC254_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC254_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC254_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC254_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC254_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC254_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC254_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC254_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC254_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC254_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC254_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC254_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC254_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC255_IN_SEL_CFG
func (o *GPIO_Type) SetFUNC255_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC255_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC255_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC255_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC255_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC255_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC255_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC255_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC255_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC255_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC255_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC255_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC255_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC255_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC255_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC0_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC0_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC0_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC0_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC0_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC0_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC0_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC0_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC0_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC1_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC1_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC1_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC1_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC1_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC1_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC1_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC1_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC1_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC2_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC2_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC2_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC2_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC2_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC2_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC2_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC2_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC2_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC3_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC3_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC3_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC3_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC3_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC3_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC3_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC3_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC3_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC4_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC4_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC4_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC4_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC4_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC4_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC4_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC4_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC4_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC5_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC5_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC5_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC5_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC5_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC5_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC5_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC5_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC5_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC6_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC6_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC6_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC6_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC6_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC6_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC6_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC6_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC6_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC7_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC7_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC7_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC7_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC7_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC7_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC7_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC7_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC7_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC8_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC8_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC8_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC8_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC8_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC8_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC8_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC8_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC8_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC9_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC9_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC9_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC9_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC9_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC9_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC9_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC9_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC9_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC10_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC10_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC10_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC10_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC10_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC10_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC10_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC10_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC10_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC11_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC11_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC11_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC11_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC11_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC11_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC11_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC11_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC11_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC12_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC12_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC12_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC12_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC12_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC12_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC12_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC12_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC12_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC13_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC13_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC13_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC13_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC13_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC13_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC13_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC13_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC13_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC14_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC14_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC14_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC14_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC14_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC14_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC14_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC14_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC14_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC15_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC15_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC15_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC15_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC15_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC15_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC15_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC15_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC15_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC16_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC16_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC16_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC16_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC16_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC16_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC16_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC16_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC16_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC17_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC17_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC17_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC17_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC17_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC17_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC17_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC17_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC17_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC18_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC18_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC18_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC18_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC18_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC18_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC18_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC18_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC18_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC19_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC19_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC19_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC19_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC19_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC19_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC19_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC19_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC19_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC20_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC20_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC20_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC20_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC20_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC20_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC20_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC20_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC20_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC21_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC21_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC21_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC21_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC21_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC21_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC21_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC21_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC21_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC22_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC22_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC22_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC22_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC22_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC22_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC22_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC22_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC22_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC23_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC23_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC23_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC23_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC23_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC23_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC23_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC23_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC23_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC24_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC24_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC24_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC24_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC24_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC24_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC24_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC24_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC24_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC25_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC25_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC25_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC25_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC25_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC25_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC25_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC25_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC25_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC26_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC26_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC26_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC26_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC26_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC26_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC26_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC26_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC26_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC26_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC26_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC26_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC26_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC27_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC27_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC27_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC27_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC27_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC27_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC27_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC27_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC27_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC27_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC27_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC27_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC27_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC28_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC28_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC28_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC28_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC28_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC28_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC28_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC28_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC28_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC28_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC28_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC28_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC28_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC29_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC29_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC29_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC29_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC29_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC29_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC29_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC29_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC29_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC29_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC29_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC29_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC29_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC30_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC30_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC30_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC30_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC30_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC30_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC30_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC30_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC30_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC30_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC30_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC30_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC30_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC30_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC30_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC30_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC30_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC30_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC30_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC30_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC30_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC31_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC31_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC31_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC31_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC31_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC31_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC31_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC31_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC31_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC31_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC31_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC31_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC31_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC31_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC31_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC31_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC31_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC31_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC31_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC31_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC31_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC32_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC32_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC32_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC32_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC32_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC32_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC32_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC32_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC32_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC32_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC32_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC32_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC32_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC32_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC32_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC32_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC32_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC32_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC32_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC32_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC32_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC33_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC33_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC33_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC33_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC33_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC33_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC33_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC33_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC33_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC33_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC33_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC33_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC33_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC33_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC33_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC33_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC33_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC33_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC33_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC33_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC33_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC34_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC34_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC34_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC34_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC34_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC34_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC34_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC34_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC34_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC34_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC34_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC34_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC34_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC34_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC34_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC34_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC34_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC34_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC34_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC34_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC34_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC35_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC35_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC35_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC35_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC35_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC35_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC35_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC35_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC35_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC35_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC35_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC35_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC35_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC35_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC35_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC35_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC35_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC35_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC35_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC35_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC35_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC36_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC36_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC36_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC36_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC36_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC36_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC36_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC36_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC36_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC36_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC36_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC36_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC36_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC36_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC36_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC36_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC36_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC36_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC36_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC36_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC36_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC37_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC37_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC37_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC37_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC37_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC37_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC37_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC37_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC37_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC37_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC37_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC37_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC37_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC37_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC37_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC37_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC37_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC37_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC37_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC37_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC37_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC38_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC38_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC38_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC38_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC38_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC38_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC38_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC38_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC38_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC38_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC38_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC38_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC38_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC38_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC38_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC38_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC38_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC38_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC38_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC38_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC38_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC39_OUT_SEL_CFG
func (o *GPIO_Type) SetFUNC39_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC39_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC39_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC39_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC39_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC39_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC39_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC39_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC39_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC39_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC39_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC39_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC39_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC39_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC39_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC39_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC39_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC39_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC39_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC39_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// Sigma-Delta Modulation
type GPIO_SIGMADELTA_Type struct {
	SIGMADELTA0 volatile.Register32 // 0x0
	SIGMADELTA1 volatile.Register32 // 0x4
	SIGMADELTA2 volatile.Register32 // 0x8
	SIGMADELTA3 volatile.Register32 // 0xC
	SIGMADELTA4 volatile.Register32 // 0x10
	SIGMADELTA5 volatile.Register32 // 0x14
	SIGMADELTA6 volatile.Register32 // 0x18
	SIGMADELTA7 volatile.Register32 // 0x1C
	CG          volatile.Register32 // 0x20
	MISC        volatile.Register32 // 0x24
	VERSION     volatile.Register32 // 0x28
}

// GPIO_SIGMADELTA.SIGMADELTA0
func (o *GPIO_SIGMADELTA_Type) SetSIGMADELTA0_SD0_IN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA0.Reg, volatile.LoadUint32(&o.SIGMADELTA0.Reg)&^(0xff)|value)
}
func (o *GPIO_SIGMADELTA_Type) GetSIGMADELTA0_SD0_IN() uint32 {
	return volatile.LoadUint32(&o.SIGMADELTA0.Reg) & 0xff
}
func (o *GPIO_SIGMADELTA_Type) SetSIGMADELTA0_SD0_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA0.Reg, volatile.LoadUint32(&o.SIGMADELTA0.Reg)&^(0xff00)|value<<8)
}
func (o *GPIO_SIGMADELTA_Type) GetSIGMADELTA0_SD0_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA0.Reg) & 0xff00) >> 8
}

// GPIO_SIGMADELTA.SIGMADELTA1
func (o *GPIO_SIGMADELTA_Type) SetSIGMADELTA1_SD0_IN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA1.Reg, volatile.LoadUint32(&o.SIGMADELTA1.Reg)&^(0xff)|value)
}
func (o *GPIO_SIGMADELTA_Type) GetSIGMADELTA1_SD0_IN() uint32 {
	return volatile.LoadUint32(&o.SIGMADELTA1.Reg) & 0xff
}
func (o *GPIO_SIGMADELTA_Type) SetSIGMADELTA1_SD0_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA1.Reg, volatile.LoadUint32(&o.SIGMADELTA1.Reg)&^(0xff00)|value<<8)
}
func (o *GPIO_SIGMADELTA_Type) GetSIGMADELTA1_SD0_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA1.Reg) & 0xff00) >> 8
}

// GPIO_SIGMADELTA.SIGMADELTA2
func (o *GPIO_SIGMADELTA_Type) SetSIGMADELTA2_SD0_IN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA2.Reg, volatile.LoadUint32(&o.SIGMADELTA2.Reg)&^(0xff)|value)
}
func (o *GPIO_SIGMADELTA_Type) GetSIGMADELTA2_SD0_IN() uint32 {
	return volatile.LoadUint32(&o.SIGMADELTA2.Reg) & 0xff
}
func (o *GPIO_SIGMADELTA_Type) SetSIGMADELTA2_SD0_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA2.Reg, volatile.LoadUint32(&o.SIGMADELTA2.Reg)&^(0xff00)|value<<8)
}
func (o *GPIO_SIGMADELTA_Type) GetSIGMADELTA2_SD0_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA2.Reg) & 0xff00) >> 8
}

// GPIO_SIGMADELTA.SIGMADELTA3
func (o *GPIO_SIGMADELTA_Type) SetSIGMADELTA3_SD0_IN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA3.Reg, volatile.LoadUint32(&o.SIGMADELTA3.Reg)&^(0xff)|value)
}
func (o *GPIO_SIGMADELTA_Type) GetSIGMADELTA3_SD0_IN() uint32 {
	return volatile.LoadUint32(&o.SIGMADELTA3.Reg) & 0xff
}
func (o *GPIO_SIGMADELTA_Type) SetSIGMADELTA3_SD0_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA3.Reg, volatile.LoadUint32(&o.SIGMADELTA3.Reg)&^(0xff00)|value<<8)
}
func (o *GPIO_SIGMADELTA_Type) GetSIGMADELTA3_SD0_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA3.Reg) & 0xff00) >> 8
}

// GPIO_SIGMADELTA.SIGMADELTA4
func (o *GPIO_SIGMADELTA_Type) SetSIGMADELTA4_SD0_IN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA4.Reg, volatile.LoadUint32(&o.SIGMADELTA4.Reg)&^(0xff)|value)
}
func (o *GPIO_SIGMADELTA_Type) GetSIGMADELTA4_SD0_IN() uint32 {
	return volatile.LoadUint32(&o.SIGMADELTA4.Reg) & 0xff
}
func (o *GPIO_SIGMADELTA_Type) SetSIGMADELTA4_SD0_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA4.Reg, volatile.LoadUint32(&o.SIGMADELTA4.Reg)&^(0xff00)|value<<8)
}
func (o *GPIO_SIGMADELTA_Type) GetSIGMADELTA4_SD0_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA4.Reg) & 0xff00) >> 8
}

// GPIO_SIGMADELTA.SIGMADELTA5
func (o *GPIO_SIGMADELTA_Type) SetSIGMADELTA5_SD0_IN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA5.Reg, volatile.LoadUint32(&o.SIGMADELTA5.Reg)&^(0xff)|value)
}
func (o *GPIO_SIGMADELTA_Type) GetSIGMADELTA5_SD0_IN() uint32 {
	return volatile.LoadUint32(&o.SIGMADELTA5.Reg) & 0xff
}
func (o *GPIO_SIGMADELTA_Type) SetSIGMADELTA5_SD0_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA5.Reg, volatile.LoadUint32(&o.SIGMADELTA5.Reg)&^(0xff00)|value<<8)
}
func (o *GPIO_SIGMADELTA_Type) GetSIGMADELTA5_SD0_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA5.Reg) & 0xff00) >> 8
}

// GPIO_SIGMADELTA.SIGMADELTA6
func (o *GPIO_SIGMADELTA_Type) SetSIGMADELTA6_SD0_IN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA6.Reg, volatile.LoadUint32(&o.SIGMADELTA6.Reg)&^(0xff)|value)
}
func (o *GPIO_SIGMADELTA_Type) GetSIGMADELTA6_SD0_IN() uint32 {
	return volatile.LoadUint32(&o.SIGMADELTA6.Reg) & 0xff
}
func (o *GPIO_SIGMADELTA_Type) SetSIGMADELTA6_SD0_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA6.Reg, volatile.LoadUint32(&o.SIGMADELTA6.Reg)&^(0xff00)|value<<8)
}
func (o *GPIO_SIGMADELTA_Type) GetSIGMADELTA6_SD0_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA6.Reg) & 0xff00) >> 8
}

// GPIO_SIGMADELTA.SIGMADELTA7
func (o *GPIO_SIGMADELTA_Type) SetSIGMADELTA7_SD0_IN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA7.Reg, volatile.LoadUint32(&o.SIGMADELTA7.Reg)&^(0xff)|value)
}
func (o *GPIO_SIGMADELTA_Type) GetSIGMADELTA7_SD0_IN() uint32 {
	return volatile.LoadUint32(&o.SIGMADELTA7.Reg) & 0xff
}
func (o *GPIO_SIGMADELTA_Type) SetSIGMADELTA7_SD0_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA7.Reg, volatile.LoadUint32(&o.SIGMADELTA7.Reg)&^(0xff00)|value<<8)
}
func (o *GPIO_SIGMADELTA_Type) GetSIGMADELTA7_SD0_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA7.Reg) & 0xff00) >> 8
}

// GPIO_SIGMADELTA.CG
func (o *GPIO_SIGMADELTA_Type) SetCG_SD_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CG.Reg, volatile.LoadUint32(&o.CG.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_SIGMADELTA_Type) GetCG_SD_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CG.Reg) & 0x80000000) >> 31
}

// GPIO_SIGMADELTA.MISC
func (o *GPIO_SIGMADELTA_Type) SetMISC_SPI_SWAP(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_SIGMADELTA_Type) GetMISC_SPI_SWAP() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x80000000) >> 31
}

// GPIO_SIGMADELTA.VERSION
func (o *GPIO_SIGMADELTA_Type) SetVERSION_SD_DATE(value uint32) {
	volatile.StoreUint32(&o.VERSION.Reg, volatile.LoadUint32(&o.VERSION.Reg)&^(0xfffffff)|value)
}
func (o *GPIO_SIGMADELTA_Type) GetVERSION_SD_DATE() uint32 {
	return volatile.LoadUint32(&o.VERSION.Reg) & 0xfffffff
}

// HINF Peripheral
type HINF_Type struct {
	CFG_DATA0  volatile.Register32 // 0x0
	CFG_DATA1  volatile.Register32 // 0x4
	_          [20]byte
	CFG_DATA7  volatile.Register32 // 0x1C
	CIS_CONF0  volatile.Register32 // 0x20
	CIS_CONF1  volatile.Register32 // 0x24
	CIS_CONF2  volatile.Register32 // 0x28
	CIS_CONF3  volatile.Register32 // 0x2C
	CIS_CONF4  volatile.Register32 // 0x30
	CIS_CONF5  volatile.Register32 // 0x34
	CIS_CONF6  volatile.Register32 // 0x38
	CIS_CONF7  volatile.Register32 // 0x3C
	CFG_DATA16 volatile.Register32 // 0x40
	_          [184]byte
	DATE       volatile.Register32 // 0xFC
}

// HINF.CFG_DATA0
func (o *HINF_Type) SetCFG_DATA0_USER_ID_FN1(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA0.Reg, volatile.LoadUint32(&o.CFG_DATA0.Reg)&^(0xffff)|value)
}
func (o *HINF_Type) GetCFG_DATA0_USER_ID_FN1() uint32 {
	return volatile.LoadUint32(&o.CFG_DATA0.Reg) & 0xffff
}
func (o *HINF_Type) SetCFG_DATA0_DEVICE_ID_FN1(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA0.Reg, volatile.LoadUint32(&o.CFG_DATA0.Reg)&^(0xffff0000)|value<<16)
}
func (o *HINF_Type) GetCFG_DATA0_DEVICE_ID_FN1() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA0.Reg) & 0xffff0000) >> 16
}

// HINF.CFG_DATA1
func (o *HINF_Type) SetCFG_DATA1_SDIO_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0x1)|value)
}
func (o *HINF_Type) GetCFG_DATA1_SDIO_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0x1
}
func (o *HINF_Type) SetCFG_DATA1_SDIO_IOREADY1(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0x2)|value<<1)
}
func (o *HINF_Type) GetCFG_DATA1_SDIO_IOREADY1() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0x2) >> 1
}
func (o *HINF_Type) SetCFG_DATA1_HIGHSPEED_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0x4)|value<<2)
}
func (o *HINF_Type) GetCFG_DATA1_HIGHSPEED_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0x4) >> 2
}
func (o *HINF_Type) SetCFG_DATA1_HIGHSPEED_MODE(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0x8)|value<<3)
}
func (o *HINF_Type) GetCFG_DATA1_HIGHSPEED_MODE() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0x8) >> 3
}
func (o *HINF_Type) SetCFG_DATA1_SDIO_CD_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0x10)|value<<4)
}
func (o *HINF_Type) GetCFG_DATA1_SDIO_CD_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0x10) >> 4
}
func (o *HINF_Type) SetCFG_DATA1_SDIO_IOREADY2(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0x20)|value<<5)
}
func (o *HINF_Type) GetCFG_DATA1_SDIO_IOREADY2() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0x20) >> 5
}
func (o *HINF_Type) SetCFG_DATA1_SDIO_INT_MASK(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0x40)|value<<6)
}
func (o *HINF_Type) GetCFG_DATA1_SDIO_INT_MASK() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0x40) >> 6
}
func (o *HINF_Type) SetCFG_DATA1_IOENABLE2(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0x80)|value<<7)
}
func (o *HINF_Type) GetCFG_DATA1_IOENABLE2() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0x80) >> 7
}
func (o *HINF_Type) SetCFG_DATA1_CD_DISABLE(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0x100)|value<<8)
}
func (o *HINF_Type) GetCFG_DATA1_CD_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0x100) >> 8
}
func (o *HINF_Type) SetCFG_DATA1_FUNC1_EPS(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0x200)|value<<9)
}
func (o *HINF_Type) GetCFG_DATA1_FUNC1_EPS() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0x200) >> 9
}
func (o *HINF_Type) SetCFG_DATA1_EMP(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0x400)|value<<10)
}
func (o *HINF_Type) GetCFG_DATA1_EMP() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0x400) >> 10
}
func (o *HINF_Type) SetCFG_DATA1_IOENABLE1(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0x800)|value<<11)
}
func (o *HINF_Type) GetCFG_DATA1_IOENABLE1() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0x800) >> 11
}
func (o *HINF_Type) SetCFG_DATA1_SDIO20_CONF0(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0xf000)|value<<12)
}
func (o *HINF_Type) GetCFG_DATA1_SDIO20_CONF0() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0xf000) >> 12
}
func (o *HINF_Type) SetCFG_DATA1_SDIO_VER(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0xfff0000)|value<<16)
}
func (o *HINF_Type) GetCFG_DATA1_SDIO_VER() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0xfff0000) >> 16
}
func (o *HINF_Type) SetCFG_DATA1_FUNC2_EPS(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0x10000000)|value<<28)
}
func (o *HINF_Type) GetCFG_DATA1_FUNC2_EPS() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0x10000000) >> 28
}
func (o *HINF_Type) SetCFG_DATA1_SDIO20_CONF1(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0xe0000000)|value<<29)
}
func (o *HINF_Type) GetCFG_DATA1_SDIO20_CONF1() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0xe0000000) >> 29
}

// HINF.CFG_DATA7
func (o *HINF_Type) SetCFG_DATA7_PIN_STATE(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA7.Reg, volatile.LoadUint32(&o.CFG_DATA7.Reg)&^(0xff)|value)
}
func (o *HINF_Type) GetCFG_DATA7_PIN_STATE() uint32 {
	return volatile.LoadUint32(&o.CFG_DATA7.Reg) & 0xff
}
func (o *HINF_Type) SetCFG_DATA7_CHIP_STATE(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA7.Reg, volatile.LoadUint32(&o.CFG_DATA7.Reg)&^(0xff00)|value<<8)
}
func (o *HINF_Type) GetCFG_DATA7_CHIP_STATE() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA7.Reg) & 0xff00) >> 8
}
func (o *HINF_Type) SetCFG_DATA7_SDIO_RST(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA7.Reg, volatile.LoadUint32(&o.CFG_DATA7.Reg)&^(0x10000)|value<<16)
}
func (o *HINF_Type) GetCFG_DATA7_SDIO_RST() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA7.Reg) & 0x10000) >> 16
}
func (o *HINF_Type) SetCFG_DATA7_SDIO_IOREADY0(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA7.Reg, volatile.LoadUint32(&o.CFG_DATA7.Reg)&^(0x20000)|value<<17)
}
func (o *HINF_Type) GetCFG_DATA7_SDIO_IOREADY0() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA7.Reg) & 0x20000) >> 17
}

// HINF.CIS_CONF0
func (o *HINF_Type) SetCIS_CONF0(value uint32) {
	volatile.StoreUint32(&o.CIS_CONF0.Reg, value)
}
func (o *HINF_Type) GetCIS_CONF0() uint32 {
	return volatile.LoadUint32(&o.CIS_CONF0.Reg)
}

// HINF.CIS_CONF1
func (o *HINF_Type) SetCIS_CONF1(value uint32) {
	volatile.StoreUint32(&o.CIS_CONF1.Reg, value)
}
func (o *HINF_Type) GetCIS_CONF1() uint32 {
	return volatile.LoadUint32(&o.CIS_CONF1.Reg)
}

// HINF.CIS_CONF2
func (o *HINF_Type) SetCIS_CONF2(value uint32) {
	volatile.StoreUint32(&o.CIS_CONF2.Reg, value)
}
func (o *HINF_Type) GetCIS_CONF2() uint32 {
	return volatile.LoadUint32(&o.CIS_CONF2.Reg)
}

// HINF.CIS_CONF3
func (o *HINF_Type) SetCIS_CONF3(value uint32) {
	volatile.StoreUint32(&o.CIS_CONF3.Reg, value)
}
func (o *HINF_Type) GetCIS_CONF3() uint32 {
	return volatile.LoadUint32(&o.CIS_CONF3.Reg)
}

// HINF.CIS_CONF4
func (o *HINF_Type) SetCIS_CONF4(value uint32) {
	volatile.StoreUint32(&o.CIS_CONF4.Reg, value)
}
func (o *HINF_Type) GetCIS_CONF4() uint32 {
	return volatile.LoadUint32(&o.CIS_CONF4.Reg)
}

// HINF.CIS_CONF5
func (o *HINF_Type) SetCIS_CONF5(value uint32) {
	volatile.StoreUint32(&o.CIS_CONF5.Reg, value)
}
func (o *HINF_Type) GetCIS_CONF5() uint32 {
	return volatile.LoadUint32(&o.CIS_CONF5.Reg)
}

// HINF.CIS_CONF6
func (o *HINF_Type) SetCIS_CONF6(value uint32) {
	volatile.StoreUint32(&o.CIS_CONF6.Reg, value)
}
func (o *HINF_Type) GetCIS_CONF6() uint32 {
	return volatile.LoadUint32(&o.CIS_CONF6.Reg)
}

// HINF.CIS_CONF7
func (o *HINF_Type) SetCIS_CONF7(value uint32) {
	volatile.StoreUint32(&o.CIS_CONF7.Reg, value)
}
func (o *HINF_Type) GetCIS_CONF7() uint32 {
	return volatile.LoadUint32(&o.CIS_CONF7.Reg)
}

// HINF.CFG_DATA16
func (o *HINF_Type) SetCFG_DATA16_USER_ID_FN2(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA16.Reg, volatile.LoadUint32(&o.CFG_DATA16.Reg)&^(0xffff)|value)
}
func (o *HINF_Type) GetCFG_DATA16_USER_ID_FN2() uint32 {
	return volatile.LoadUint32(&o.CFG_DATA16.Reg) & 0xffff
}
func (o *HINF_Type) SetCFG_DATA16_DEVICE_ID_FN2(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA16.Reg, volatile.LoadUint32(&o.CFG_DATA16.Reg)&^(0xffff0000)|value<<16)
}
func (o *HINF_Type) GetCFG_DATA16_DEVICE_ID_FN2() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA16.Reg) & 0xffff0000) >> 16
}

// HINF.DATE
func (o *HINF_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, value)
}
func (o *HINF_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg)
}

// I2C (Inter-Integrated Circuit) Controller 0
type I2C_Type struct {
	SCL_LOW_PERIOD   volatile.Register32 // 0x0
	CTR              volatile.Register32 // 0x4
	SR               volatile.Register32 // 0x8
	TO               volatile.Register32 // 0xC
	SLAVE_ADDR       volatile.Register32 // 0x10
	RXFIFO_ST        volatile.Register32 // 0x14
	FIFO_CONF        volatile.Register32 // 0x18
	DATA             volatile.Register32 // 0x1C
	INT_RAW          volatile.Register32 // 0x20
	INT_CLR          volatile.Register32 // 0x24
	INT_ENA          volatile.Register32 // 0x28
	INT_STATUS       volatile.Register32 // 0x2C
	SDA_HOLD         volatile.Register32 // 0x30
	SDA_SAMPLE       volatile.Register32 // 0x34
	SCL_HIGH_PERIOD  volatile.Register32 // 0x38
	_                [4]byte
	SCL_START_HOLD   volatile.Register32 // 0x40
	SCL_RSTART_SETUP volatile.Register32 // 0x44
	SCL_STOP_HOLD    volatile.Register32 // 0x48
	SCL_STOP_SETUP   volatile.Register32 // 0x4C
	SCL_FILTER_CFG   volatile.Register32 // 0x50
	SDA_FILTER_CFG   volatile.Register32 // 0x54
	COMD0            volatile.Register32 // 0x58
	COMD1            volatile.Register32 // 0x5C
	COMD2            volatile.Register32 // 0x60
	COMD3            volatile.Register32 // 0x64
	COMD4            volatile.Register32 // 0x68
	COMD5            volatile.Register32 // 0x6C
	COMD6            volatile.Register32 // 0x70
	COMD7            volatile.Register32 // 0x74
	COMD8            volatile.Register32 // 0x78
	COMD9            volatile.Register32 // 0x7C
	COMD10           volatile.Register32 // 0x80
	COMD11           volatile.Register32 // 0x84
	COMD12           volatile.Register32 // 0x88
	COMD13           volatile.Register32 // 0x8C
	COMD14           volatile.Register32 // 0x90
	COMD15           volatile.Register32 // 0x94
	_                [96]byte
	DATE             volatile.Register32 // 0xF8
	_                [4]byte
	FIFO_START_ADDR  volatile.Register32 // 0x100
}

// I2C.SCL_LOW_PERIOD
func (o *I2C_Type) SetSCL_LOW_PERIOD(value uint32) {
	volatile.StoreUint32(&o.SCL_LOW_PERIOD.Reg, volatile.LoadUint32(&o.SCL_LOW_PERIOD.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetSCL_LOW_PERIOD() uint32 {
	return volatile.LoadUint32(&o.SCL_LOW_PERIOD.Reg) & 0x3fff
}

// I2C.CTR
func (o *I2C_Type) SetCTR_SDA_FORCE_OUT(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCTR_SDA_FORCE_OUT() uint32 {
	return volatile.LoadUint32(&o.CTR.Reg) & 0x1
}
func (o *I2C_Type) SetCTR_SCL_FORCE_OUT(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetCTR_SCL_FORCE_OUT() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetCTR_SAMPLE_SCL_LEVEL(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetCTR_SAMPLE_SCL_LEVEL() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetCTR_MS_MODE(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCTR_MS_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCTR_TRANS_START(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCTR_TRANS_START() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCTR_TX_LSB_FIRST(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCTR_TX_LSB_FIRST() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCTR_RX_LSB_FIRST(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCTR_RX_LSB_FIRST() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCTR_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetCTR_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x100) >> 8
}

// I2C.SR
func (o *I2C_Type) SetSR_ACK_REC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetSR_ACK_REC() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *I2C_Type) SetSR_SLAVE_RW(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetSR_SLAVE_RW() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetSR_TIME_OUT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetSR_TIME_OUT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetSR_ARB_LOST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetSR_ARB_LOST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetSR_BUS_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetSR_BUS_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetSR_SLAVE_ADDRESSED(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetSR_SLAVE_ADDRESSED() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetSR_BYTE_TRANS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetSR_BYTE_TRANS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetSR_RXFIFO_CNT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x3f00)|value<<8)
}
func (o *I2C_Type) GetSR_RXFIFO_CNT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x3f00) >> 8
}
func (o *I2C_Type) SetSR_TXFIFO_CNT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xfc0000)|value<<18)
}
func (o *I2C_Type) GetSR_TXFIFO_CNT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xfc0000) >> 18
}
func (o *I2C_Type) SetSR_SCL_MAIN_STATE_LAST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x7000000)|value<<24)
}
func (o *I2C_Type) GetSR_SCL_MAIN_STATE_LAST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x7000000) >> 24
}
func (o *I2C_Type) SetSR_SCL_STATE_LAST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x70000000)|value<<28)
}
func (o *I2C_Type) GetSR_SCL_STATE_LAST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x70000000) >> 28
}

// I2C.TO
func (o *I2C_Type) SetTO_TIME_OUT(value uint32) {
	volatile.StoreUint32(&o.TO.Reg, volatile.LoadUint32(&o.TO.Reg)&^(0xfffff)|value)
}
func (o *I2C_Type) GetTO_TIME_OUT() uint32 {
	return volatile.LoadUint32(&o.TO.Reg) & 0xfffff
}

// I2C.SLAVE_ADDR
func (o *I2C_Type) SetSLAVE_ADDR(value uint32) {
	volatile.StoreUint32(&o.SLAVE_ADDR.Reg, volatile.LoadUint32(&o.SLAVE_ADDR.Reg)&^(0x7fff)|value)
}
func (o *I2C_Type) GetSLAVE_ADDR() uint32 {
	return volatile.LoadUint32(&o.SLAVE_ADDR.Reg) & 0x7fff
}
func (o *I2C_Type) SetSLAVE_ADDR_ADDR_10BIT_EN(value uint32) {
	volatile.StoreUint32(&o.SLAVE_ADDR.Reg, volatile.LoadUint32(&o.SLAVE_ADDR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetSLAVE_ADDR_ADDR_10BIT_EN() uint32 {
	return (volatile.LoadUint32(&o.SLAVE_ADDR.Reg) & 0x80000000) >> 31
}

// I2C.RXFIFO_ST
func (o *I2C_Type) SetRXFIFO_ST_RXFIFO_START_ADDR(value uint32) {
	volatile.StoreUint32(&o.RXFIFO_ST.Reg, volatile.LoadUint32(&o.RXFIFO_ST.Reg)&^(0x1f)|value)
}
func (o *I2C_Type) GetRXFIFO_ST_RXFIFO_START_ADDR() uint32 {
	return volatile.LoadUint32(&o.RXFIFO_ST.Reg) & 0x1f
}
func (o *I2C_Type) SetRXFIFO_ST_RXFIFO_END_ADDR(value uint32) {
	volatile.StoreUint32(&o.RXFIFO_ST.Reg, volatile.LoadUint32(&o.RXFIFO_ST.Reg)&^(0x3e0)|value<<5)
}
func (o *I2C_Type) GetRXFIFO_ST_RXFIFO_END_ADDR() uint32 {
	return (volatile.LoadUint32(&o.RXFIFO_ST.Reg) & 0x3e0) >> 5
}
func (o *I2C_Type) SetRXFIFO_ST_TXFIFO_START_ADDR(value uint32) {
	volatile.StoreUint32(&o.RXFIFO_ST.Reg, volatile.LoadUint32(&o.RXFIFO_ST.Reg)&^(0x7c00)|value<<10)
}
func (o *I2C_Type) GetRXFIFO_ST_TXFIFO_START_ADDR() uint32 {
	return (volatile.LoadUint32(&o.RXFIFO_ST.Reg) & 0x7c00) >> 10
}
func (o *I2C_Type) SetRXFIFO_ST_TXFIFO_END_ADDR(value uint32) {
	volatile.StoreUint32(&o.RXFIFO_ST.Reg, volatile.LoadUint32(&o.RXFIFO_ST.Reg)&^(0xf8000)|value<<15)
}
func (o *I2C_Type) GetRXFIFO_ST_TXFIFO_END_ADDR() uint32 {
	return (volatile.LoadUint32(&o.RXFIFO_ST.Reg) & 0xf8000) >> 15
}

// I2C.FIFO_CONF
func (o *I2C_Type) SetFIFO_CONF_RXFIFO_FULL_THRHD(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x1f)|value)
}
func (o *I2C_Type) GetFIFO_CONF_RXFIFO_FULL_THRHD() uint32 {
	return volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x1f
}
func (o *I2C_Type) SetFIFO_CONF_TXFIFO_EMPTY_THRHD(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x3e0)|value<<5)
}
func (o *I2C_Type) GetFIFO_CONF_TXFIFO_EMPTY_THRHD() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x3e0) >> 5
}
func (o *I2C_Type) SetFIFO_CONF_NONFIFO_EN(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetFIFO_CONF_NONFIFO_EN() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetFIFO_CONF_FIFO_ADDR_CFG_EN(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetFIFO_CONF_FIFO_ADDR_CFG_EN() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetFIFO_CONF_RX_FIFO_RST(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetFIFO_CONF_RX_FIFO_RST() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetFIFO_CONF_TX_FIFO_RST(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetFIFO_CONF_TX_FIFO_RST() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetFIFO_CONF_NONFIFO_RX_THRES(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0xfc000)|value<<14)
}
func (o *I2C_Type) GetFIFO_CONF_NONFIFO_RX_THRES() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0xfc000) >> 14
}
func (o *I2C_Type) SetFIFO_CONF_NONFIFO_TX_THRES(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x3f00000)|value<<20)
}
func (o *I2C_Type) GetFIFO_CONF_NONFIFO_TX_THRES() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x3f00000) >> 20
}

// I2C.DATA
func (o *I2C_Type) SetDATA_FIFO_RDATA(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetDATA_FIFO_RDATA() uint32 {
	return volatile.LoadUint32(&o.DATA.Reg) & 0xff
}

// I2C.INT_RAW
func (o *I2C_Type) SetINT_RAW_RXFIFO_FULL_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetINT_RAW_RXFIFO_FULL_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1
}
func (o *I2C_Type) SetINT_RAW_TXFIFO_EMPTY_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetINT_RAW_TXFIFO_EMPTY_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetINT_RAW_RXFIFO_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetINT_RAW_RXFIFO_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetINT_RAW_END_DETECT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetINT_RAW_END_DETECT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetINT_RAW_SLAVE_TRAN_COMP_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetINT_RAW_SLAVE_TRAN_COMP_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetINT_RAW_ARBITRATION_LOST_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetINT_RAW_ARBITRATION_LOST_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetINT_RAW_MASTER_TRAN_COMP_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetINT_RAW_MASTER_TRAN_COMP_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetINT_RAW_TRANS_COMPLETE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetINT_RAW_TRANS_COMPLETE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetINT_RAW_TIME_OUT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetINT_RAW_TIME_OUT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetINT_RAW_TRANS_START_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetINT_RAW_TRANS_START_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetINT_RAW_ACK_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetINT_RAW_ACK_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetINT_RAW_RX_REC_FULL_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetINT_RAW_RX_REC_FULL_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetINT_RAW_TX_SEND_EMPTY_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetINT_RAW_TX_SEND_EMPTY_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1000) >> 12
}

// I2C.INT_CLR
func (o *I2C_Type) SetINT_CLR_RXFIFO_FULL_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetINT_CLR_RXFIFO_FULL_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1
}
func (o *I2C_Type) SetINT_CLR_TXFIFO_EMPTY_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetINT_CLR_TXFIFO_EMPTY_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetINT_CLR_RXFIFO_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetINT_CLR_RXFIFO_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetINT_CLR_END_DETECT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetINT_CLR_END_DETECT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetINT_CLR_SLAVE_TRAN_COMP_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetINT_CLR_SLAVE_TRAN_COMP_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetINT_CLR_ARBITRATION_LOST_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetINT_CLR_ARBITRATION_LOST_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetINT_CLR_MASTER_TRAN_COMP_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetINT_CLR_MASTER_TRAN_COMP_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetINT_CLR_TRANS_COMPLETE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetINT_CLR_TRANS_COMPLETE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetINT_CLR_TIME_OUT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetINT_CLR_TIME_OUT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetINT_CLR_TRANS_START_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetINT_CLR_TRANS_START_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetINT_CLR_ACK_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetINT_CLR_ACK_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetINT_CLR_RX_REC_FULL_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetINT_CLR_RX_REC_FULL_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetINT_CLR_TX_SEND_EMPTY_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetINT_CLR_TX_SEND_EMPTY_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1000) >> 12
}

// I2C.INT_ENA
func (o *I2C_Type) SetINT_ENA_RXFIFO_FULL_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetINT_ENA_RXFIFO_FULL_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}
func (o *I2C_Type) SetINT_ENA_TXFIFO_EMPTY_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetINT_ENA_TXFIFO_EMPTY_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetINT_ENA_RXFIFO_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetINT_ENA_RXFIFO_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetINT_ENA_END_DETECT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetINT_ENA_END_DETECT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetINT_ENA_SLAVE_TRAN_COMP_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetINT_ENA_SLAVE_TRAN_COMP_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetINT_ENA_ARBITRATION_LOST_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetINT_ENA_ARBITRATION_LOST_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetINT_ENA_MASTER_TRAN_COMP_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetINT_ENA_MASTER_TRAN_COMP_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetINT_ENA_TRANS_COMPLETE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetINT_ENA_TRANS_COMPLETE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetINT_ENA_TIME_OUT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetINT_ENA_TIME_OUT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetINT_ENA_TRANS_START_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetINT_ENA_TRANS_START_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetINT_ENA_ACK_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetINT_ENA_ACK_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetINT_ENA_RX_REC_FULL_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetINT_ENA_RX_REC_FULL_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetINT_ENA_TX_SEND_EMPTY_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetINT_ENA_TX_SEND_EMPTY_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1000) >> 12
}

// I2C.INT_STATUS
func (o *I2C_Type) SetINT_STATUS_RXFIFO_FULL_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetINT_STATUS_RXFIFO_FULL_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x1
}
func (o *I2C_Type) SetINT_STATUS_TXFIFO_EMPTY_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetINT_STATUS_TXFIFO_EMPTY_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetINT_STATUS_RXFIFO_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetINT_STATUS_RXFIFO_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetINT_STATUS_END_DETECT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetINT_STATUS_END_DETECT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetINT_STATUS_SLAVE_TRAN_COMP_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetINT_STATUS_SLAVE_TRAN_COMP_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetINT_STATUS_ARBITRATION_LOST_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetINT_STATUS_ARBITRATION_LOST_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetINT_STATUS_MASTER_TRAN_COMP_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetINT_STATUS_MASTER_TRAN_COMP_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetINT_STATUS_TRANS_COMPLETE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetINT_STATUS_TRANS_COMPLETE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetINT_STATUS_TIME_OUT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetINT_STATUS_TIME_OUT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetINT_STATUS_TRANS_START_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetINT_STATUS_TRANS_START_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetINT_STATUS_ACK_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetINT_STATUS_ACK_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetINT_STATUS_RX_REC_FULL_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetINT_STATUS_RX_REC_FULL_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetINT_STATUS_TX_SEND_EMPTY_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetINT_STATUS_TX_SEND_EMPTY_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x1000) >> 12
}

// I2C.SDA_HOLD
func (o *I2C_Type) SetSDA_HOLD_TIME(value uint32) {
	volatile.StoreUint32(&o.SDA_HOLD.Reg, volatile.LoadUint32(&o.SDA_HOLD.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetSDA_HOLD_TIME() uint32 {
	return volatile.LoadUint32(&o.SDA_HOLD.Reg) & 0x3ff
}

// I2C.SDA_SAMPLE
func (o *I2C_Type) SetSDA_SAMPLE_TIME(value uint32) {
	volatile.StoreUint32(&o.SDA_SAMPLE.Reg, volatile.LoadUint32(&o.SDA_SAMPLE.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetSDA_SAMPLE_TIME() uint32 {
	return volatile.LoadUint32(&o.SDA_SAMPLE.Reg) & 0x3ff
}

// I2C.SCL_HIGH_PERIOD
func (o *I2C_Type) SetSCL_HIGH_PERIOD(value uint32) {
	volatile.StoreUint32(&o.SCL_HIGH_PERIOD.Reg, volatile.LoadUint32(&o.SCL_HIGH_PERIOD.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetSCL_HIGH_PERIOD() uint32 {
	return volatile.LoadUint32(&o.SCL_HIGH_PERIOD.Reg) & 0x3fff
}

// I2C.SCL_START_HOLD
func (o *I2C_Type) SetSCL_START_HOLD_TIME(value uint32) {
	volatile.StoreUint32(&o.SCL_START_HOLD.Reg, volatile.LoadUint32(&o.SCL_START_HOLD.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetSCL_START_HOLD_TIME() uint32 {
	return volatile.LoadUint32(&o.SCL_START_HOLD.Reg) & 0x3ff
}

// I2C.SCL_RSTART_SETUP
func (o *I2C_Type) SetSCL_RSTART_SETUP_TIME(value uint32) {
	volatile.StoreUint32(&o.SCL_RSTART_SETUP.Reg, volatile.LoadUint32(&o.SCL_RSTART_SETUP.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetSCL_RSTART_SETUP_TIME() uint32 {
	return volatile.LoadUint32(&o.SCL_RSTART_SETUP.Reg) & 0x3ff
}

// I2C.SCL_STOP_HOLD
func (o *I2C_Type) SetSCL_STOP_HOLD_TIME(value uint32) {
	volatile.StoreUint32(&o.SCL_STOP_HOLD.Reg, volatile.LoadUint32(&o.SCL_STOP_HOLD.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetSCL_STOP_HOLD_TIME() uint32 {
	return volatile.LoadUint32(&o.SCL_STOP_HOLD.Reg) & 0x3fff
}

// I2C.SCL_STOP_SETUP
func (o *I2C_Type) SetSCL_STOP_SETUP_TIME(value uint32) {
	volatile.StoreUint32(&o.SCL_STOP_SETUP.Reg, volatile.LoadUint32(&o.SCL_STOP_SETUP.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetSCL_STOP_SETUP_TIME() uint32 {
	return volatile.LoadUint32(&o.SCL_STOP_SETUP.Reg) & 0x3ff
}

// I2C.SCL_FILTER_CFG
func (o *I2C_Type) SetSCL_FILTER_CFG_SCL_FILTER_THRES(value uint32) {
	volatile.StoreUint32(&o.SCL_FILTER_CFG.Reg, volatile.LoadUint32(&o.SCL_FILTER_CFG.Reg)&^(0x7)|value)
}
func (o *I2C_Type) GetSCL_FILTER_CFG_SCL_FILTER_THRES() uint32 {
	return volatile.LoadUint32(&o.SCL_FILTER_CFG.Reg) & 0x7
}
func (o *I2C_Type) SetSCL_FILTER_CFG_SCL_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.SCL_FILTER_CFG.Reg, volatile.LoadUint32(&o.SCL_FILTER_CFG.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetSCL_FILTER_CFG_SCL_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.SCL_FILTER_CFG.Reg) & 0x8) >> 3
}

// I2C.SDA_FILTER_CFG
func (o *I2C_Type) SetSDA_FILTER_CFG_SDA_FILTER_THRES(value uint32) {
	volatile.StoreUint32(&o.SDA_FILTER_CFG.Reg, volatile.LoadUint32(&o.SDA_FILTER_CFG.Reg)&^(0x7)|value)
}
func (o *I2C_Type) GetSDA_FILTER_CFG_SDA_FILTER_THRES() uint32 {
	return volatile.LoadUint32(&o.SDA_FILTER_CFG.Reg) & 0x7
}
func (o *I2C_Type) SetSDA_FILTER_CFG_SDA_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.SDA_FILTER_CFG.Reg, volatile.LoadUint32(&o.SDA_FILTER_CFG.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetSDA_FILTER_CFG_SDA_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.SDA_FILTER_CFG.Reg) & 0x8) >> 3
}

// I2C.COMD0
func (o *I2C_Type) SetCOMD0_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD0.Reg, volatile.LoadUint32(&o.COMD0.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD0_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD0.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD0_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD0.Reg, volatile.LoadUint32(&o.COMD0.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD0_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD0.Reg) & 0x80000000) >> 31
}

// I2C.COMD1
func (o *I2C_Type) SetCOMD1_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD1.Reg, volatile.LoadUint32(&o.COMD1.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD1_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD1.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD1_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD1.Reg, volatile.LoadUint32(&o.COMD1.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD1_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD1.Reg) & 0x80000000) >> 31
}

// I2C.COMD2
func (o *I2C_Type) SetCOMD2_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD2.Reg, volatile.LoadUint32(&o.COMD2.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD2_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD2.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD2_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD2.Reg, volatile.LoadUint32(&o.COMD2.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD2_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD2.Reg) & 0x80000000) >> 31
}

// I2C.COMD3
func (o *I2C_Type) SetCOMD3_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD3.Reg, volatile.LoadUint32(&o.COMD3.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD3_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD3.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD3_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD3.Reg, volatile.LoadUint32(&o.COMD3.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD3_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD3.Reg) & 0x80000000) >> 31
}

// I2C.COMD4
func (o *I2C_Type) SetCOMD4_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD4.Reg, volatile.LoadUint32(&o.COMD4.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD4_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD4.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD4_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD4.Reg, volatile.LoadUint32(&o.COMD4.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD4_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD4.Reg) & 0x80000000) >> 31
}

// I2C.COMD5
func (o *I2C_Type) SetCOMD5_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD5.Reg, volatile.LoadUint32(&o.COMD5.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD5_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD5.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD5_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD5.Reg, volatile.LoadUint32(&o.COMD5.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD5_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD5.Reg) & 0x80000000) >> 31
}

// I2C.COMD6
func (o *I2C_Type) SetCOMD6_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD6.Reg, volatile.LoadUint32(&o.COMD6.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD6_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD6.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD6_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD6.Reg, volatile.LoadUint32(&o.COMD6.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD6_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD6.Reg) & 0x80000000) >> 31
}

// I2C.COMD7
func (o *I2C_Type) SetCOMD7_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD7.Reg, volatile.LoadUint32(&o.COMD7.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD7_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD7.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD7_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD7.Reg, volatile.LoadUint32(&o.COMD7.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD7_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD7.Reg) & 0x80000000) >> 31
}

// I2C.COMD8
func (o *I2C_Type) SetCOMD8_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD8.Reg, volatile.LoadUint32(&o.COMD8.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD8_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD8.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD8_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD8.Reg, volatile.LoadUint32(&o.COMD8.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD8_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD8.Reg) & 0x80000000) >> 31
}

// I2C.COMD9
func (o *I2C_Type) SetCOMD9_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD9.Reg, volatile.LoadUint32(&o.COMD9.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD9_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD9.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD9_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD9.Reg, volatile.LoadUint32(&o.COMD9.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD9_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD9.Reg) & 0x80000000) >> 31
}

// I2C.COMD10
func (o *I2C_Type) SetCOMD10_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD10.Reg, volatile.LoadUint32(&o.COMD10.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD10_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD10.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD10_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD10.Reg, volatile.LoadUint32(&o.COMD10.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD10_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD10.Reg) & 0x80000000) >> 31
}

// I2C.COMD11
func (o *I2C_Type) SetCOMD11_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD11.Reg, volatile.LoadUint32(&o.COMD11.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD11_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD11.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD11_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD11.Reg, volatile.LoadUint32(&o.COMD11.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD11_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD11.Reg) & 0x80000000) >> 31
}

// I2C.COMD12
func (o *I2C_Type) SetCOMD12_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD12.Reg, volatile.LoadUint32(&o.COMD12.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD12_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD12.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD12_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD12.Reg, volatile.LoadUint32(&o.COMD12.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD12_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD12.Reg) & 0x80000000) >> 31
}

// I2C.COMD13
func (o *I2C_Type) SetCOMD13_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD13.Reg, volatile.LoadUint32(&o.COMD13.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD13_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD13.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD13_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD13.Reg, volatile.LoadUint32(&o.COMD13.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD13_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD13.Reg) & 0x80000000) >> 31
}

// I2C.COMD14
func (o *I2C_Type) SetCOMD14_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD14.Reg, volatile.LoadUint32(&o.COMD14.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD14_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD14.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD14_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD14.Reg, volatile.LoadUint32(&o.COMD14.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD14_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD14.Reg) & 0x80000000) >> 31
}

// I2C.COMD15
func (o *I2C_Type) SetCOMD15_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD15.Reg, volatile.LoadUint32(&o.COMD15.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD15_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD15.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD15_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD15.Reg, volatile.LoadUint32(&o.COMD15.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD15_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD15.Reg) & 0x80000000) >> 31
}

// I2C.DATE
func (o *I2C_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, value)
}
func (o *I2C_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg)
}

// I2S (Inter-IC Sound) Controller 0
type I2S_Type struct {
	_                    [8]byte
	CONF                 volatile.Register32 // 0x8
	INT_RAW              volatile.Register32 // 0xC
	INT_ST               volatile.Register32 // 0x10
	INT_ENA              volatile.Register32 // 0x14
	INT_CLR              volatile.Register32 // 0x18
	TIMING               volatile.Register32 // 0x1C
	FIFO_CONF            volatile.Register32 // 0x20
	RXEOF_NUM            volatile.Register32 // 0x24
	CONF_SIGLE_DATA      volatile.Register32 // 0x28
	CONF_CHAN            volatile.Register32 // 0x2C
	OUT_LINK             volatile.Register32 // 0x30
	IN_LINK              volatile.Register32 // 0x34
	OUT_EOF_DES_ADDR     volatile.Register32 // 0x38
	IN_EOF_DES_ADDR      volatile.Register32 // 0x3C
	OUT_EOF_BFR_DES_ADDR volatile.Register32 // 0x40
	AHB_TEST             volatile.Register32 // 0x44
	INLINK_DSCR          volatile.Register32 // 0x48
	INLINK_DSCR_BF0      volatile.Register32 // 0x4C
	INLINK_DSCR_BF1      volatile.Register32 // 0x50
	OUTLINK_DSCR         volatile.Register32 // 0x54
	OUTLINK_DSCR_BF0     volatile.Register32 // 0x58
	OUTLINK_DSCR_BF1     volatile.Register32 // 0x5C
	LC_CONF              volatile.Register32 // 0x60
	OUTFIFO_PUSH         volatile.Register32 // 0x64
	INFIFO_POP           volatile.Register32 // 0x68
	LC_STATE0            volatile.Register32 // 0x6C
	LC_STATE1            volatile.Register32 // 0x70
	LC_HUNG_CONF         volatile.Register32 // 0x74
	_                    [8]byte
	CVSD_CONF0           volatile.Register32 // 0x80
	CVSD_CONF1           volatile.Register32 // 0x84
	CVSD_CONF2           volatile.Register32 // 0x88
	PLC_CONF0            volatile.Register32 // 0x8C
	PLC_CONF1            volatile.Register32 // 0x90
	PLC_CONF2            volatile.Register32 // 0x94
	ESCO_CONF0           volatile.Register32 // 0x98
	SCO_CONF0            volatile.Register32 // 0x9C
	CONF1                volatile.Register32 // 0xA0
	PD_CONF              volatile.Register32 // 0xA4
	CONF2                volatile.Register32 // 0xA8
	CLKM_CONF            volatile.Register32 // 0xAC
	SAMPLE_RATE_CONF     volatile.Register32 // 0xB0
	PDM_CONF             volatile.Register32 // 0xB4
	PDM_FREQ_CONF        volatile.Register32 // 0xB8
	STATE                volatile.Register32 // 0xBC
	_                    [60]byte
	DATE                 volatile.Register32 // 0xFC
}

// I2S.CONF
func (o *I2S_Type) SetCONF_TX_RESET(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetCONF_TX_RESET() uint32 {
	return volatile.LoadUint32(&o.CONF.Reg) & 0x1
}
func (o *I2S_Type) SetCONF_RX_RESET(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetCONF_RX_RESET() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetCONF_TX_FIFO_RESET(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetCONF_TX_FIFO_RESET() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetCONF_RX_FIFO_RESET(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetCONF_RX_FIFO_RESET() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetCONF_TX_START(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x10)|value<<4)
}
func (o *I2S_Type) GetCONF_TX_START() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x10) >> 4
}
func (o *I2S_Type) SetCONF_RX_START(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetCONF_RX_START() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetCONF_TX_SLAVE_MOD(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x40)|value<<6)
}
func (o *I2S_Type) GetCONF_TX_SLAVE_MOD() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x40) >> 6
}
func (o *I2S_Type) SetCONF_RX_SLAVE_MOD(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetCONF_RX_SLAVE_MOD() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x80) >> 7
}
func (o *I2S_Type) SetCONF_TX_RIGHT_FIRST(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetCONF_TX_RIGHT_FIRST() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetCONF_RX_RIGHT_FIRST(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x200)|value<<9)
}
func (o *I2S_Type) GetCONF_RX_RIGHT_FIRST() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x200) >> 9
}
func (o *I2S_Type) SetCONF_TX_MSB_SHIFT(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x400)|value<<10)
}
func (o *I2S_Type) GetCONF_TX_MSB_SHIFT() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x400) >> 10
}
func (o *I2S_Type) SetCONF_RX_MSB_SHIFT(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x800)|value<<11)
}
func (o *I2S_Type) GetCONF_RX_MSB_SHIFT() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x800) >> 11
}
func (o *I2S_Type) SetCONF_TX_SHORT_SYNC(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x1000)|value<<12)
}
func (o *I2S_Type) GetCONF_TX_SHORT_SYNC() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x1000) >> 12
}
func (o *I2S_Type) SetCONF_RX_SHORT_SYNC(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x2000)|value<<13)
}
func (o *I2S_Type) GetCONF_RX_SHORT_SYNC() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x2000) >> 13
}
func (o *I2S_Type) SetCONF_TX_MONO(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x4000)|value<<14)
}
func (o *I2S_Type) GetCONF_TX_MONO() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x4000) >> 14
}
func (o *I2S_Type) SetCONF_RX_MONO(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x8000)|value<<15)
}
func (o *I2S_Type) GetCONF_RX_MONO() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x8000) >> 15
}
func (o *I2S_Type) SetCONF_TX_MSB_RIGHT(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x10000)|value<<16)
}
func (o *I2S_Type) GetCONF_TX_MSB_RIGHT() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x10000) >> 16
}
func (o *I2S_Type) SetCONF_RX_MSB_RIGHT(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x20000)|value<<17)
}
func (o *I2S_Type) GetCONF_RX_MSB_RIGHT() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x20000) >> 17
}
func (o *I2S_Type) SetCONF_SIG_LOOPBACK(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x40000)|value<<18)
}
func (o *I2S_Type) GetCONF_SIG_LOOPBACK() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x40000) >> 18
}

// I2S.INT_RAW
func (o *I2S_Type) SetINT_RAW_RX_TAKE_DATA_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetINT_RAW_RX_TAKE_DATA_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1
}
func (o *I2S_Type) SetINT_RAW_TX_PUT_DATA_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetINT_RAW_TX_PUT_DATA_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetINT_RAW_RX_WFULL_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetINT_RAW_RX_WFULL_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetINT_RAW_RX_REMPTY_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetINT_RAW_RX_REMPTY_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetINT_RAW_TX_WFULL_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x10)|value<<4)
}
func (o *I2S_Type) GetINT_RAW_TX_WFULL_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x10) >> 4
}
func (o *I2S_Type) SetINT_RAW_TX_REMPTY_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetINT_RAW_TX_REMPTY_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetINT_RAW_RX_HUNG_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x40)|value<<6)
}
func (o *I2S_Type) GetINT_RAW_RX_HUNG_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x40) >> 6
}
func (o *I2S_Type) SetINT_RAW_TX_HUNG_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetINT_RAW_TX_HUNG_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x80) >> 7
}
func (o *I2S_Type) SetINT_RAW_IN_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetINT_RAW_IN_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetINT_RAW_IN_SUC_EOF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x200)|value<<9)
}
func (o *I2S_Type) GetINT_RAW_IN_SUC_EOF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x200) >> 9
}
func (o *I2S_Type) SetINT_RAW_IN_ERR_EOF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x400)|value<<10)
}
func (o *I2S_Type) GetINT_RAW_IN_ERR_EOF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x400) >> 10
}
func (o *I2S_Type) SetINT_RAW_OUT_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x800)|value<<11)
}
func (o *I2S_Type) GetINT_RAW_OUT_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x800) >> 11
}
func (o *I2S_Type) SetINT_RAW_OUT_EOF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1000)|value<<12)
}
func (o *I2S_Type) GetINT_RAW_OUT_EOF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1000) >> 12
}
func (o *I2S_Type) SetINT_RAW_IN_DSCR_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2000)|value<<13)
}
func (o *I2S_Type) GetINT_RAW_IN_DSCR_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2000) >> 13
}
func (o *I2S_Type) SetINT_RAW_OUT_DSCR_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4000)|value<<14)
}
func (o *I2S_Type) GetINT_RAW_OUT_DSCR_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4000) >> 14
}
func (o *I2S_Type) SetINT_RAW_IN_DSCR_EMPTY_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8000)|value<<15)
}
func (o *I2S_Type) GetINT_RAW_IN_DSCR_EMPTY_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8000) >> 15
}
func (o *I2S_Type) SetINT_RAW_OUT_TOTAL_EOF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x10000)|value<<16)
}
func (o *I2S_Type) GetINT_RAW_OUT_TOTAL_EOF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x10000) >> 16
}

// I2S.INT_ST
func (o *I2S_Type) SetINT_ST_RX_TAKE_DATA_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetINT_ST_RX_TAKE_DATA_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_ST.Reg) & 0x1
}
func (o *I2S_Type) SetINT_ST_TX_PUT_DATA_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetINT_ST_TX_PUT_DATA_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetINT_ST_RX_WFULL_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetINT_ST_RX_WFULL_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetINT_ST_RX_REMPTY_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetINT_ST_RX_REMPTY_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetINT_ST_TX_WFULL_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x10)|value<<4)
}
func (o *I2S_Type) GetINT_ST_TX_WFULL_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x10) >> 4
}
func (o *I2S_Type) SetINT_ST_TX_REMPTY_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetINT_ST_TX_REMPTY_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetINT_ST_RX_HUNG_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x40)|value<<6)
}
func (o *I2S_Type) GetINT_ST_RX_HUNG_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x40) >> 6
}
func (o *I2S_Type) SetINT_ST_TX_HUNG_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetINT_ST_TX_HUNG_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x80) >> 7
}
func (o *I2S_Type) SetINT_ST_IN_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetINT_ST_IN_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetINT_ST_IN_SUC_EOF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x200)|value<<9)
}
func (o *I2S_Type) GetINT_ST_IN_SUC_EOF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x200) >> 9
}
func (o *I2S_Type) SetINT_ST_IN_ERR_EOF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x400)|value<<10)
}
func (o *I2S_Type) GetINT_ST_IN_ERR_EOF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x400) >> 10
}
func (o *I2S_Type) SetINT_ST_OUT_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x800)|value<<11)
}
func (o *I2S_Type) GetINT_ST_OUT_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x800) >> 11
}
func (o *I2S_Type) SetINT_ST_OUT_EOF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x1000)|value<<12)
}
func (o *I2S_Type) GetINT_ST_OUT_EOF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x1000) >> 12
}
func (o *I2S_Type) SetINT_ST_IN_DSCR_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x2000)|value<<13)
}
func (o *I2S_Type) GetINT_ST_IN_DSCR_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x2000) >> 13
}
func (o *I2S_Type) SetINT_ST_OUT_DSCR_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x4000)|value<<14)
}
func (o *I2S_Type) GetINT_ST_OUT_DSCR_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x4000) >> 14
}
func (o *I2S_Type) SetINT_ST_IN_DSCR_EMPTY_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x8000)|value<<15)
}
func (o *I2S_Type) GetINT_ST_IN_DSCR_EMPTY_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x8000) >> 15
}
func (o *I2S_Type) SetINT_ST_OUT_TOTAL_EOF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x10000)|value<<16)
}
func (o *I2S_Type) GetINT_ST_OUT_TOTAL_EOF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x10000) >> 16
}

// I2S.INT_ENA
func (o *I2S_Type) SetINT_ENA_RX_TAKE_DATA_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetINT_ENA_RX_TAKE_DATA_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}
func (o *I2S_Type) SetINT_ENA_TX_PUT_DATA_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetINT_ENA_TX_PUT_DATA_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetINT_ENA_RX_WFULL_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetINT_ENA_RX_WFULL_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetINT_ENA_RX_REMPTY_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetINT_ENA_RX_REMPTY_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetINT_ENA_TX_WFULL_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *I2S_Type) GetINT_ENA_TX_WFULL_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x10) >> 4
}
func (o *I2S_Type) SetINT_ENA_TX_REMPTY_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetINT_ENA_TX_REMPTY_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetINT_ENA_RX_HUNG_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x40)|value<<6)
}
func (o *I2S_Type) GetINT_ENA_RX_HUNG_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x40) >> 6
}
func (o *I2S_Type) SetINT_ENA_TX_HUNG_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetINT_ENA_TX_HUNG_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x80) >> 7
}
func (o *I2S_Type) SetINT_ENA_IN_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetINT_ENA_IN_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetINT_ENA_IN_SUC_EOF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x200)|value<<9)
}
func (o *I2S_Type) GetINT_ENA_IN_SUC_EOF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x200) >> 9
}
func (o *I2S_Type) SetINT_ENA_IN_ERR_EOF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x400)|value<<10)
}
func (o *I2S_Type) GetINT_ENA_IN_ERR_EOF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x400) >> 10
}
func (o *I2S_Type) SetINT_ENA_OUT_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x800)|value<<11)
}
func (o *I2S_Type) GetINT_ENA_OUT_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x800) >> 11
}
func (o *I2S_Type) SetINT_ENA_OUT_EOF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1000)|value<<12)
}
func (o *I2S_Type) GetINT_ENA_OUT_EOF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1000) >> 12
}
func (o *I2S_Type) SetINT_ENA_IN_DSCR_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2000)|value<<13)
}
func (o *I2S_Type) GetINT_ENA_IN_DSCR_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2000) >> 13
}
func (o *I2S_Type) SetINT_ENA_OUT_DSCR_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4000)|value<<14)
}
func (o *I2S_Type) GetINT_ENA_OUT_DSCR_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4000) >> 14
}
func (o *I2S_Type) SetINT_ENA_IN_DSCR_EMPTY_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8000)|value<<15)
}
func (o *I2S_Type) GetINT_ENA_IN_DSCR_EMPTY_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8000) >> 15
}
func (o *I2S_Type) SetINT_ENA_OUT_TOTAL_EOF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x10000)|value<<16)
}
func (o *I2S_Type) GetINT_ENA_OUT_TOTAL_EOF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x10000) >> 16
}

// I2S.INT_CLR
func (o *I2S_Type) SetINT_CLR_TAKE_DATA_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetINT_CLR_TAKE_DATA_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1
}
func (o *I2S_Type) SetINT_CLR_PUT_DATA_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetINT_CLR_PUT_DATA_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetINT_CLR_RX_WFULL_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetINT_CLR_RX_WFULL_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetINT_CLR_RX_REMPTY_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetINT_CLR_RX_REMPTY_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetINT_CLR_TX_WFULL_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *I2S_Type) GetINT_CLR_TX_WFULL_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x10) >> 4
}
func (o *I2S_Type) SetINT_CLR_TX_REMPTY_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetINT_CLR_TX_REMPTY_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetINT_CLR_RX_HUNG_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x40)|value<<6)
}
func (o *I2S_Type) GetINT_CLR_RX_HUNG_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x40) >> 6
}
func (o *I2S_Type) SetINT_CLR_TX_HUNG_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetINT_CLR_TX_HUNG_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x80) >> 7
}
func (o *I2S_Type) SetINT_CLR_IN_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetINT_CLR_IN_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetINT_CLR_IN_SUC_EOF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x200)|value<<9)
}
func (o *I2S_Type) GetINT_CLR_IN_SUC_EOF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x200) >> 9
}
func (o *I2S_Type) SetINT_CLR_IN_ERR_EOF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x400)|value<<10)
}
func (o *I2S_Type) GetINT_CLR_IN_ERR_EOF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x400) >> 10
}
func (o *I2S_Type) SetINT_CLR_OUT_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x800)|value<<11)
}
func (o *I2S_Type) GetINT_CLR_OUT_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x800) >> 11
}
func (o *I2S_Type) SetINT_CLR_OUT_EOF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *I2S_Type) GetINT_CLR_OUT_EOF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1000) >> 12
}
func (o *I2S_Type) SetINT_CLR_IN_DSCR_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *I2S_Type) GetINT_CLR_IN_DSCR_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2000) >> 13
}
func (o *I2S_Type) SetINT_CLR_OUT_DSCR_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *I2S_Type) GetINT_CLR_OUT_DSCR_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4000) >> 14
}
func (o *I2S_Type) SetINT_CLR_IN_DSCR_EMPTY_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *I2S_Type) GetINT_CLR_IN_DSCR_EMPTY_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8000) >> 15
}
func (o *I2S_Type) SetINT_CLR_OUT_TOTAL_EOF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x10000)|value<<16)
}
func (o *I2S_Type) GetINT_CLR_OUT_TOTAL_EOF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x10000) >> 16
}

// I2S.TIMING
func (o *I2S_Type) SetTIMING_TX_BCK_IN_DELAY(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0x3)|value)
}
func (o *I2S_Type) GetTIMING_TX_BCK_IN_DELAY() uint32 {
	return volatile.LoadUint32(&o.TIMING.Reg) & 0x3
}
func (o *I2S_Type) SetTIMING_TX_WS_IN_DELAY(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0xc)|value<<2)
}
func (o *I2S_Type) GetTIMING_TX_WS_IN_DELAY() uint32 {
	return (volatile.LoadUint32(&o.TIMING.Reg) & 0xc) >> 2
}
func (o *I2S_Type) SetTIMING_RX_BCK_IN_DELAY(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0x30)|value<<4)
}
func (o *I2S_Type) GetTIMING_RX_BCK_IN_DELAY() uint32 {
	return (volatile.LoadUint32(&o.TIMING.Reg) & 0x30) >> 4
}
func (o *I2S_Type) SetTIMING_RX_WS_IN_DELAY(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0xc0)|value<<6)
}
func (o *I2S_Type) GetTIMING_RX_WS_IN_DELAY() uint32 {
	return (volatile.LoadUint32(&o.TIMING.Reg) & 0xc0) >> 6
}
func (o *I2S_Type) SetTIMING_RX_SD_IN_DELAY(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0x300)|value<<8)
}
func (o *I2S_Type) GetTIMING_RX_SD_IN_DELAY() uint32 {
	return (volatile.LoadUint32(&o.TIMING.Reg) & 0x300) >> 8
}
func (o *I2S_Type) SetTIMING_TX_BCK_OUT_DELAY(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0xc00)|value<<10)
}
func (o *I2S_Type) GetTIMING_TX_BCK_OUT_DELAY() uint32 {
	return (volatile.LoadUint32(&o.TIMING.Reg) & 0xc00) >> 10
}
func (o *I2S_Type) SetTIMING_TX_WS_OUT_DELAY(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0x3000)|value<<12)
}
func (o *I2S_Type) GetTIMING_TX_WS_OUT_DELAY() uint32 {
	return (volatile.LoadUint32(&o.TIMING.Reg) & 0x3000) >> 12
}
func (o *I2S_Type) SetTIMING_TX_SD_OUT_DELAY(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0xc000)|value<<14)
}
func (o *I2S_Type) GetTIMING_TX_SD_OUT_DELAY() uint32 {
	return (volatile.LoadUint32(&o.TIMING.Reg) & 0xc000) >> 14
}
func (o *I2S_Type) SetTIMING_RX_WS_OUT_DELAY(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0x30000)|value<<16)
}
func (o *I2S_Type) GetTIMING_RX_WS_OUT_DELAY() uint32 {
	return (volatile.LoadUint32(&o.TIMING.Reg) & 0x30000) >> 16
}
func (o *I2S_Type) SetTIMING_RX_BCK_OUT_DELAY(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0xc0000)|value<<18)
}
func (o *I2S_Type) GetTIMING_RX_BCK_OUT_DELAY() uint32 {
	return (volatile.LoadUint32(&o.TIMING.Reg) & 0xc0000) >> 18
}
func (o *I2S_Type) SetTIMING_TX_DSYNC_SW(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0x100000)|value<<20)
}
func (o *I2S_Type) GetTIMING_TX_DSYNC_SW() uint32 {
	return (volatile.LoadUint32(&o.TIMING.Reg) & 0x100000) >> 20
}
func (o *I2S_Type) SetTIMING_RX_DSYNC_SW(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0x200000)|value<<21)
}
func (o *I2S_Type) GetTIMING_RX_DSYNC_SW() uint32 {
	return (volatile.LoadUint32(&o.TIMING.Reg) & 0x200000) >> 21
}
func (o *I2S_Type) SetTIMING_DATA_ENABLE_DELAY(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0xc00000)|value<<22)
}
func (o *I2S_Type) GetTIMING_DATA_ENABLE_DELAY() uint32 {
	return (volatile.LoadUint32(&o.TIMING.Reg) & 0xc00000) >> 22
}
func (o *I2S_Type) SetTIMING_TX_BCK_IN_INV(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0x1000000)|value<<24)
}
func (o *I2S_Type) GetTIMING_TX_BCK_IN_INV() uint32 {
	return (volatile.LoadUint32(&o.TIMING.Reg) & 0x1000000) >> 24
}

// I2S.FIFO_CONF
func (o *I2S_Type) SetFIFO_CONF_RX_DATA_NUM(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x3f)|value)
}
func (o *I2S_Type) GetFIFO_CONF_RX_DATA_NUM() uint32 {
	return volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x3f
}
func (o *I2S_Type) SetFIFO_CONF_TX_DATA_NUM(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0xfc0)|value<<6)
}
func (o *I2S_Type) GetFIFO_CONF_TX_DATA_NUM() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0xfc0) >> 6
}
func (o *I2S_Type) SetFIFO_CONF_DSCR_EN(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *I2S_Type) GetFIFO_CONF_DSCR_EN() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x1000) >> 12
}
func (o *I2S_Type) SetFIFO_CONF_TX_FIFO_MOD(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0xe000)|value<<13)
}
func (o *I2S_Type) GetFIFO_CONF_TX_FIFO_MOD() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0xe000) >> 13
}
func (o *I2S_Type) SetFIFO_CONF_RX_FIFO_MOD(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x70000)|value<<16)
}
func (o *I2S_Type) GetFIFO_CONF_RX_FIFO_MOD() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x70000) >> 16
}
func (o *I2S_Type) SetFIFO_CONF_TX_FIFO_MOD_FORCE_EN(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x80000)|value<<19)
}
func (o *I2S_Type) GetFIFO_CONF_TX_FIFO_MOD_FORCE_EN() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x80000) >> 19
}
func (o *I2S_Type) SetFIFO_CONF_RX_FIFO_MOD_FORCE_EN(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x100000)|value<<20)
}
func (o *I2S_Type) GetFIFO_CONF_RX_FIFO_MOD_FORCE_EN() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x100000) >> 20
}

// I2S.RXEOF_NUM
func (o *I2S_Type) SetRXEOF_NUM(value uint32) {
	volatile.StoreUint32(&o.RXEOF_NUM.Reg, value)
}
func (o *I2S_Type) GetRXEOF_NUM() uint32 {
	return volatile.LoadUint32(&o.RXEOF_NUM.Reg)
}

// I2S.CONF_SIGLE_DATA
func (o *I2S_Type) SetCONF_SIGLE_DATA(value uint32) {
	volatile.StoreUint32(&o.CONF_SIGLE_DATA.Reg, value)
}
func (o *I2S_Type) GetCONF_SIGLE_DATA() uint32 {
	return volatile.LoadUint32(&o.CONF_SIGLE_DATA.Reg)
}

// I2S.CONF_CHAN
func (o *I2S_Type) SetCONF_CHAN_TX_CHAN_MOD(value uint32) {
	volatile.StoreUint32(&o.CONF_CHAN.Reg, volatile.LoadUint32(&o.CONF_CHAN.Reg)&^(0x7)|value)
}
func (o *I2S_Type) GetCONF_CHAN_TX_CHAN_MOD() uint32 {
	return volatile.LoadUint32(&o.CONF_CHAN.Reg) & 0x7
}
func (o *I2S_Type) SetCONF_CHAN_RX_CHAN_MOD(value uint32) {
	volatile.StoreUint32(&o.CONF_CHAN.Reg, volatile.LoadUint32(&o.CONF_CHAN.Reg)&^(0x18)|value<<3)
}
func (o *I2S_Type) GetCONF_CHAN_RX_CHAN_MOD() uint32 {
	return (volatile.LoadUint32(&o.CONF_CHAN.Reg) & 0x18) >> 3
}

// I2S.OUT_LINK
func (o *I2S_Type) SetOUT_LINK_OUTLINK_ADDR(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK.Reg, volatile.LoadUint32(&o.OUT_LINK.Reg)&^(0xfffff)|value)
}
func (o *I2S_Type) GetOUT_LINK_OUTLINK_ADDR() uint32 {
	return volatile.LoadUint32(&o.OUT_LINK.Reg) & 0xfffff
}
func (o *I2S_Type) SetOUT_LINK_OUTLINK_STOP(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK.Reg, volatile.LoadUint32(&o.OUT_LINK.Reg)&^(0x10000000)|value<<28)
}
func (o *I2S_Type) GetOUT_LINK_OUTLINK_STOP() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK.Reg) & 0x10000000) >> 28
}
func (o *I2S_Type) SetOUT_LINK_OUTLINK_START(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK.Reg, volatile.LoadUint32(&o.OUT_LINK.Reg)&^(0x20000000)|value<<29)
}
func (o *I2S_Type) GetOUT_LINK_OUTLINK_START() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK.Reg) & 0x20000000) >> 29
}
func (o *I2S_Type) SetOUT_LINK_OUTLINK_RESTART(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK.Reg, volatile.LoadUint32(&o.OUT_LINK.Reg)&^(0x40000000)|value<<30)
}
func (o *I2S_Type) GetOUT_LINK_OUTLINK_RESTART() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK.Reg) & 0x40000000) >> 30
}
func (o *I2S_Type) SetOUT_LINK_OUTLINK_PARK(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK.Reg, volatile.LoadUint32(&o.OUT_LINK.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_Type) GetOUT_LINK_OUTLINK_PARK() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK.Reg) & 0x80000000) >> 31
}

// I2S.IN_LINK
func (o *I2S_Type) SetIN_LINK_INLINK_ADDR(value uint32) {
	volatile.StoreUint32(&o.IN_LINK.Reg, volatile.LoadUint32(&o.IN_LINK.Reg)&^(0xfffff)|value)
}
func (o *I2S_Type) GetIN_LINK_INLINK_ADDR() uint32 {
	return volatile.LoadUint32(&o.IN_LINK.Reg) & 0xfffff
}
func (o *I2S_Type) SetIN_LINK_INLINK_STOP(value uint32) {
	volatile.StoreUint32(&o.IN_LINK.Reg, volatile.LoadUint32(&o.IN_LINK.Reg)&^(0x10000000)|value<<28)
}
func (o *I2S_Type) GetIN_LINK_INLINK_STOP() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK.Reg) & 0x10000000) >> 28
}
func (o *I2S_Type) SetIN_LINK_INLINK_START(value uint32) {
	volatile.StoreUint32(&o.IN_LINK.Reg, volatile.LoadUint32(&o.IN_LINK.Reg)&^(0x20000000)|value<<29)
}
func (o *I2S_Type) GetIN_LINK_INLINK_START() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK.Reg) & 0x20000000) >> 29
}
func (o *I2S_Type) SetIN_LINK_INLINK_RESTART(value uint32) {
	volatile.StoreUint32(&o.IN_LINK.Reg, volatile.LoadUint32(&o.IN_LINK.Reg)&^(0x40000000)|value<<30)
}
func (o *I2S_Type) GetIN_LINK_INLINK_RESTART() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK.Reg) & 0x40000000) >> 30
}
func (o *I2S_Type) SetIN_LINK_INLINK_PARK(value uint32) {
	volatile.StoreUint32(&o.IN_LINK.Reg, volatile.LoadUint32(&o.IN_LINK.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_Type) GetIN_LINK_INLINK_PARK() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK.Reg) & 0x80000000) >> 31
}

// I2S.OUT_EOF_DES_ADDR
func (o *I2S_Type) SetOUT_EOF_DES_ADDR(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_DES_ADDR.Reg, value)
}
func (o *I2S_Type) GetOUT_EOF_DES_ADDR() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_DES_ADDR.Reg)
}

// I2S.IN_EOF_DES_ADDR
func (o *I2S_Type) SetIN_EOF_DES_ADDR(value uint32) {
	volatile.StoreUint32(&o.IN_EOF_DES_ADDR.Reg, value)
}
func (o *I2S_Type) GetIN_EOF_DES_ADDR() uint32 {
	return volatile.LoadUint32(&o.IN_EOF_DES_ADDR.Reg)
}

// I2S.OUT_EOF_BFR_DES_ADDR
func (o *I2S_Type) SetOUT_EOF_BFR_DES_ADDR(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_BFR_DES_ADDR.Reg, value)
}
func (o *I2S_Type) GetOUT_EOF_BFR_DES_ADDR() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_BFR_DES_ADDR.Reg)
}

// I2S.AHB_TEST
func (o *I2S_Type) SetAHB_TEST_AHB_TESTMODE(value uint32) {
	volatile.StoreUint32(&o.AHB_TEST.Reg, volatile.LoadUint32(&o.AHB_TEST.Reg)&^(0x7)|value)
}
func (o *I2S_Type) GetAHB_TEST_AHB_TESTMODE() uint32 {
	return volatile.LoadUint32(&o.AHB_TEST.Reg) & 0x7
}
func (o *I2S_Type) SetAHB_TEST_AHB_TESTADDR(value uint32) {
	volatile.StoreUint32(&o.AHB_TEST.Reg, volatile.LoadUint32(&o.AHB_TEST.Reg)&^(0x30)|value<<4)
}
func (o *I2S_Type) GetAHB_TEST_AHB_TESTADDR() uint32 {
	return (volatile.LoadUint32(&o.AHB_TEST.Reg) & 0x30) >> 4
}

// I2S.INLINK_DSCR
func (o *I2S_Type) SetINLINK_DSCR(value uint32) {
	volatile.StoreUint32(&o.INLINK_DSCR.Reg, value)
}
func (o *I2S_Type) GetINLINK_DSCR() uint32 {
	return volatile.LoadUint32(&o.INLINK_DSCR.Reg)
}

// I2S.INLINK_DSCR_BF0
func (o *I2S_Type) SetINLINK_DSCR_BF0(value uint32) {
	volatile.StoreUint32(&o.INLINK_DSCR_BF0.Reg, value)
}
func (o *I2S_Type) GetINLINK_DSCR_BF0() uint32 {
	return volatile.LoadUint32(&o.INLINK_DSCR_BF0.Reg)
}

// I2S.INLINK_DSCR_BF1
func (o *I2S_Type) SetINLINK_DSCR_BF1(value uint32) {
	volatile.StoreUint32(&o.INLINK_DSCR_BF1.Reg, value)
}
func (o *I2S_Type) GetINLINK_DSCR_BF1() uint32 {
	return volatile.LoadUint32(&o.INLINK_DSCR_BF1.Reg)
}

// I2S.OUTLINK_DSCR
func (o *I2S_Type) SetOUTLINK_DSCR(value uint32) {
	volatile.StoreUint32(&o.OUTLINK_DSCR.Reg, value)
}
func (o *I2S_Type) GetOUTLINK_DSCR() uint32 {
	return volatile.LoadUint32(&o.OUTLINK_DSCR.Reg)
}

// I2S.OUTLINK_DSCR_BF0
func (o *I2S_Type) SetOUTLINK_DSCR_BF0(value uint32) {
	volatile.StoreUint32(&o.OUTLINK_DSCR_BF0.Reg, value)
}
func (o *I2S_Type) GetOUTLINK_DSCR_BF0() uint32 {
	return volatile.LoadUint32(&o.OUTLINK_DSCR_BF0.Reg)
}

// I2S.OUTLINK_DSCR_BF1
func (o *I2S_Type) SetOUTLINK_DSCR_BF1(value uint32) {
	volatile.StoreUint32(&o.OUTLINK_DSCR_BF1.Reg, value)
}
func (o *I2S_Type) GetOUTLINK_DSCR_BF1() uint32 {
	return volatile.LoadUint32(&o.OUTLINK_DSCR_BF1.Reg)
}

// I2S.LC_CONF
func (o *I2S_Type) SetLC_CONF_IN_RST(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetLC_CONF_IN_RST() uint32 {
	return volatile.LoadUint32(&o.LC_CONF.Reg) & 0x1
}
func (o *I2S_Type) SetLC_CONF_OUT_RST(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetLC_CONF_OUT_RST() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetLC_CONF_AHBM_FIFO_RST(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetLC_CONF_AHBM_FIFO_RST() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetLC_CONF_AHBM_RST(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetLC_CONF_AHBM_RST() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetLC_CONF_OUT_LOOP_TEST(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x10)|value<<4)
}
func (o *I2S_Type) GetLC_CONF_OUT_LOOP_TEST() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0x10) >> 4
}
func (o *I2S_Type) SetLC_CONF_IN_LOOP_TEST(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetLC_CONF_IN_LOOP_TEST() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetLC_CONF_OUT_AUTO_WRBACK(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x40)|value<<6)
}
func (o *I2S_Type) GetLC_CONF_OUT_AUTO_WRBACK() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0x40) >> 6
}
func (o *I2S_Type) SetLC_CONF_OUT_NO_RESTART_CLR(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetLC_CONF_OUT_NO_RESTART_CLR() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0x80) >> 7
}
func (o *I2S_Type) SetLC_CONF_OUT_EOF_MODE(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetLC_CONF_OUT_EOF_MODE() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetLC_CONF_OUTDSCR_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x200)|value<<9)
}
func (o *I2S_Type) GetLC_CONF_OUTDSCR_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0x200) >> 9
}
func (o *I2S_Type) SetLC_CONF_INDSCR_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x400)|value<<10)
}
func (o *I2S_Type) GetLC_CONF_INDSCR_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0x400) >> 10
}
func (o *I2S_Type) SetLC_CONF_OUT_DATA_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x800)|value<<11)
}
func (o *I2S_Type) GetLC_CONF_OUT_DATA_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0x800) >> 11
}
func (o *I2S_Type) SetLC_CONF_CHECK_OWNER(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *I2S_Type) GetLC_CONF_CHECK_OWNER() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0x1000) >> 12
}
func (o *I2S_Type) SetLC_CONF_MEM_TRANS_EN(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x2000)|value<<13)
}
func (o *I2S_Type) GetLC_CONF_MEM_TRANS_EN() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0x2000) >> 13
}

// I2S.OUTFIFO_PUSH
func (o *I2S_Type) SetOUTFIFO_PUSH_OUTFIFO_WDATA(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_PUSH.Reg, volatile.LoadUint32(&o.OUTFIFO_PUSH.Reg)&^(0x1ff)|value)
}
func (o *I2S_Type) GetOUTFIFO_PUSH_OUTFIFO_WDATA() uint32 {
	return volatile.LoadUint32(&o.OUTFIFO_PUSH.Reg) & 0x1ff
}
func (o *I2S_Type) SetOUTFIFO_PUSH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_PUSH.Reg, volatile.LoadUint32(&o.OUTFIFO_PUSH.Reg)&^(0x10000)|value<<16)
}
func (o *I2S_Type) GetOUTFIFO_PUSH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_PUSH.Reg) & 0x10000) >> 16
}

// I2S.INFIFO_POP
func (o *I2S_Type) SetINFIFO_POP_INFIFO_RDATA(value uint32) {
	volatile.StoreUint32(&o.INFIFO_POP.Reg, volatile.LoadUint32(&o.INFIFO_POP.Reg)&^(0xfff)|value)
}
func (o *I2S_Type) GetINFIFO_POP_INFIFO_RDATA() uint32 {
	return volatile.LoadUint32(&o.INFIFO_POP.Reg) & 0xfff
}
func (o *I2S_Type) SetINFIFO_POP(value uint32) {
	volatile.StoreUint32(&o.INFIFO_POP.Reg, volatile.LoadUint32(&o.INFIFO_POP.Reg)&^(0x10000)|value<<16)
}
func (o *I2S_Type) GetINFIFO_POP() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_POP.Reg) & 0x10000) >> 16
}

// I2S.LC_STATE0
func (o *I2S_Type) SetLC_STATE0(value uint32) {
	volatile.StoreUint32(&o.LC_STATE0.Reg, value)
}
func (o *I2S_Type) GetLC_STATE0() uint32 {
	return volatile.LoadUint32(&o.LC_STATE0.Reg)
}

// I2S.LC_STATE1
func (o *I2S_Type) SetLC_STATE1(value uint32) {
	volatile.StoreUint32(&o.LC_STATE1.Reg, value)
}
func (o *I2S_Type) GetLC_STATE1() uint32 {
	return volatile.LoadUint32(&o.LC_STATE1.Reg)
}

// I2S.LC_HUNG_CONF
func (o *I2S_Type) SetLC_HUNG_CONF_LC_FIFO_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.LC_HUNG_CONF.Reg, volatile.LoadUint32(&o.LC_HUNG_CONF.Reg)&^(0xff)|value)
}
func (o *I2S_Type) GetLC_HUNG_CONF_LC_FIFO_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.LC_HUNG_CONF.Reg) & 0xff
}
func (o *I2S_Type) SetLC_HUNG_CONF_LC_FIFO_TIMEOUT_SHIFT(value uint32) {
	volatile.StoreUint32(&o.LC_HUNG_CONF.Reg, volatile.LoadUint32(&o.LC_HUNG_CONF.Reg)&^(0x700)|value<<8)
}
func (o *I2S_Type) GetLC_HUNG_CONF_LC_FIFO_TIMEOUT_SHIFT() uint32 {
	return (volatile.LoadUint32(&o.LC_HUNG_CONF.Reg) & 0x700) >> 8
}
func (o *I2S_Type) SetLC_HUNG_CONF_LC_FIFO_TIMEOUT_ENA(value uint32) {
	volatile.StoreUint32(&o.LC_HUNG_CONF.Reg, volatile.LoadUint32(&o.LC_HUNG_CONF.Reg)&^(0x800)|value<<11)
}
func (o *I2S_Type) GetLC_HUNG_CONF_LC_FIFO_TIMEOUT_ENA() uint32 {
	return (volatile.LoadUint32(&o.LC_HUNG_CONF.Reg) & 0x800) >> 11
}

// I2S.CVSD_CONF0
func (o *I2S_Type) SetCVSD_CONF0_CVSD_Y_MAX(value uint32) {
	volatile.StoreUint32(&o.CVSD_CONF0.Reg, volatile.LoadUint32(&o.CVSD_CONF0.Reg)&^(0xffff)|value)
}
func (o *I2S_Type) GetCVSD_CONF0_CVSD_Y_MAX() uint32 {
	return volatile.LoadUint32(&o.CVSD_CONF0.Reg) & 0xffff
}
func (o *I2S_Type) SetCVSD_CONF0_CVSD_Y_MIN(value uint32) {
	volatile.StoreUint32(&o.CVSD_CONF0.Reg, volatile.LoadUint32(&o.CVSD_CONF0.Reg)&^(0xffff0000)|value<<16)
}
func (o *I2S_Type) GetCVSD_CONF0_CVSD_Y_MIN() uint32 {
	return (volatile.LoadUint32(&o.CVSD_CONF0.Reg) & 0xffff0000) >> 16
}

// I2S.CVSD_CONF1
func (o *I2S_Type) SetCVSD_CONF1_CVSD_SIGMA_MAX(value uint32) {
	volatile.StoreUint32(&o.CVSD_CONF1.Reg, volatile.LoadUint32(&o.CVSD_CONF1.Reg)&^(0xffff)|value)
}
func (o *I2S_Type) GetCVSD_CONF1_CVSD_SIGMA_MAX() uint32 {
	return volatile.LoadUint32(&o.CVSD_CONF1.Reg) & 0xffff
}
func (o *I2S_Type) SetCVSD_CONF1_CVSD_SIGMA_MIN(value uint32) {
	volatile.StoreUint32(&o.CVSD_CONF1.Reg, volatile.LoadUint32(&o.CVSD_CONF1.Reg)&^(0xffff0000)|value<<16)
}
func (o *I2S_Type) GetCVSD_CONF1_CVSD_SIGMA_MIN() uint32 {
	return (volatile.LoadUint32(&o.CVSD_CONF1.Reg) & 0xffff0000) >> 16
}

// I2S.CVSD_CONF2
func (o *I2S_Type) SetCVSD_CONF2_CVSD_K(value uint32) {
	volatile.StoreUint32(&o.CVSD_CONF2.Reg, volatile.LoadUint32(&o.CVSD_CONF2.Reg)&^(0x7)|value)
}
func (o *I2S_Type) GetCVSD_CONF2_CVSD_K() uint32 {
	return volatile.LoadUint32(&o.CVSD_CONF2.Reg) & 0x7
}
func (o *I2S_Type) SetCVSD_CONF2_CVSD_J(value uint32) {
	volatile.StoreUint32(&o.CVSD_CONF2.Reg, volatile.LoadUint32(&o.CVSD_CONF2.Reg)&^(0x38)|value<<3)
}
func (o *I2S_Type) GetCVSD_CONF2_CVSD_J() uint32 {
	return (volatile.LoadUint32(&o.CVSD_CONF2.Reg) & 0x38) >> 3
}
func (o *I2S_Type) SetCVSD_CONF2_CVSD_BETA(value uint32) {
	volatile.StoreUint32(&o.CVSD_CONF2.Reg, volatile.LoadUint32(&o.CVSD_CONF2.Reg)&^(0xffc0)|value<<6)
}
func (o *I2S_Type) GetCVSD_CONF2_CVSD_BETA() uint32 {
	return (volatile.LoadUint32(&o.CVSD_CONF2.Reg) & 0xffc0) >> 6
}
func (o *I2S_Type) SetCVSD_CONF2_CVSD_H(value uint32) {
	volatile.StoreUint32(&o.CVSD_CONF2.Reg, volatile.LoadUint32(&o.CVSD_CONF2.Reg)&^(0x70000)|value<<16)
}
func (o *I2S_Type) GetCVSD_CONF2_CVSD_H() uint32 {
	return (volatile.LoadUint32(&o.CVSD_CONF2.Reg) & 0x70000) >> 16
}

// I2S.PLC_CONF0
func (o *I2S_Type) SetPLC_CONF0_GOOD_PACK_MAX(value uint32) {
	volatile.StoreUint32(&o.PLC_CONF0.Reg, volatile.LoadUint32(&o.PLC_CONF0.Reg)&^(0x3f)|value)
}
func (o *I2S_Type) GetPLC_CONF0_GOOD_PACK_MAX() uint32 {
	return volatile.LoadUint32(&o.PLC_CONF0.Reg) & 0x3f
}
func (o *I2S_Type) SetPLC_CONF0_N_ERR_SEG(value uint32) {
	volatile.StoreUint32(&o.PLC_CONF0.Reg, volatile.LoadUint32(&o.PLC_CONF0.Reg)&^(0x1c0)|value<<6)
}
func (o *I2S_Type) GetPLC_CONF0_N_ERR_SEG() uint32 {
	return (volatile.LoadUint32(&o.PLC_CONF0.Reg) & 0x1c0) >> 6
}
func (o *I2S_Type) SetPLC_CONF0_SHIFT_RATE(value uint32) {
	volatile.StoreUint32(&o.PLC_CONF0.Reg, volatile.LoadUint32(&o.PLC_CONF0.Reg)&^(0xe00)|value<<9)
}
func (o *I2S_Type) GetPLC_CONF0_SHIFT_RATE() uint32 {
	return (volatile.LoadUint32(&o.PLC_CONF0.Reg) & 0xe00) >> 9
}
func (o *I2S_Type) SetPLC_CONF0_MAX_SLIDE_SAMPLE(value uint32) {
	volatile.StoreUint32(&o.PLC_CONF0.Reg, volatile.LoadUint32(&o.PLC_CONF0.Reg)&^(0xff000)|value<<12)
}
func (o *I2S_Type) GetPLC_CONF0_MAX_SLIDE_SAMPLE() uint32 {
	return (volatile.LoadUint32(&o.PLC_CONF0.Reg) & 0xff000) >> 12
}
func (o *I2S_Type) SetPLC_CONF0_PACK_LEN_8K(value uint32) {
	volatile.StoreUint32(&o.PLC_CONF0.Reg, volatile.LoadUint32(&o.PLC_CONF0.Reg)&^(0x1f00000)|value<<20)
}
func (o *I2S_Type) GetPLC_CONF0_PACK_LEN_8K() uint32 {
	return (volatile.LoadUint32(&o.PLC_CONF0.Reg) & 0x1f00000) >> 20
}
func (o *I2S_Type) SetPLC_CONF0_N_MIN_ERR(value uint32) {
	volatile.StoreUint32(&o.PLC_CONF0.Reg, volatile.LoadUint32(&o.PLC_CONF0.Reg)&^(0xe000000)|value<<25)
}
func (o *I2S_Type) GetPLC_CONF0_N_MIN_ERR() uint32 {
	return (volatile.LoadUint32(&o.PLC_CONF0.Reg) & 0xe000000) >> 25
}

// I2S.PLC_CONF1
func (o *I2S_Type) SetPLC_CONF1_BAD_CEF_ATTEN_PARA(value uint32) {
	volatile.StoreUint32(&o.PLC_CONF1.Reg, volatile.LoadUint32(&o.PLC_CONF1.Reg)&^(0xff)|value)
}
func (o *I2S_Type) GetPLC_CONF1_BAD_CEF_ATTEN_PARA() uint32 {
	return volatile.LoadUint32(&o.PLC_CONF1.Reg) & 0xff
}
func (o *I2S_Type) SetPLC_CONF1_BAD_CEF_ATTEN_PARA_SHIFT(value uint32) {
	volatile.StoreUint32(&o.PLC_CONF1.Reg, volatile.LoadUint32(&o.PLC_CONF1.Reg)&^(0xf00)|value<<8)
}
func (o *I2S_Type) GetPLC_CONF1_BAD_CEF_ATTEN_PARA_SHIFT() uint32 {
	return (volatile.LoadUint32(&o.PLC_CONF1.Reg) & 0xf00) >> 8
}
func (o *I2S_Type) SetPLC_CONF1_BAD_OLA_WIN2_PARA_SHIFT(value uint32) {
	volatile.StoreUint32(&o.PLC_CONF1.Reg, volatile.LoadUint32(&o.PLC_CONF1.Reg)&^(0xf000)|value<<12)
}
func (o *I2S_Type) GetPLC_CONF1_BAD_OLA_WIN2_PARA_SHIFT() uint32 {
	return (volatile.LoadUint32(&o.PLC_CONF1.Reg) & 0xf000) >> 12
}
func (o *I2S_Type) SetPLC_CONF1_BAD_OLA_WIN2_PARA(value uint32) {
	volatile.StoreUint32(&o.PLC_CONF1.Reg, volatile.LoadUint32(&o.PLC_CONF1.Reg)&^(0xff0000)|value<<16)
}
func (o *I2S_Type) GetPLC_CONF1_BAD_OLA_WIN2_PARA() uint32 {
	return (volatile.LoadUint32(&o.PLC_CONF1.Reg) & 0xff0000) >> 16
}
func (o *I2S_Type) SetPLC_CONF1_SLIDE_WIN_LEN(value uint32) {
	volatile.StoreUint32(&o.PLC_CONF1.Reg, volatile.LoadUint32(&o.PLC_CONF1.Reg)&^(0xff000000)|value<<24)
}
func (o *I2S_Type) GetPLC_CONF1_SLIDE_WIN_LEN() uint32 {
	return (volatile.LoadUint32(&o.PLC_CONF1.Reg) & 0xff000000) >> 24
}

// I2S.PLC_CONF2
func (o *I2S_Type) SetPLC_CONF2_CVSD_SEG_MOD(value uint32) {
	volatile.StoreUint32(&o.PLC_CONF2.Reg, volatile.LoadUint32(&o.PLC_CONF2.Reg)&^(0x3)|value)
}
func (o *I2S_Type) GetPLC_CONF2_CVSD_SEG_MOD() uint32 {
	return volatile.LoadUint32(&o.PLC_CONF2.Reg) & 0x3
}
func (o *I2S_Type) SetPLC_CONF2_MIN_PERIOD(value uint32) {
	volatile.StoreUint32(&o.PLC_CONF2.Reg, volatile.LoadUint32(&o.PLC_CONF2.Reg)&^(0x7c)|value<<2)
}
func (o *I2S_Type) GetPLC_CONF2_MIN_PERIOD() uint32 {
	return (volatile.LoadUint32(&o.PLC_CONF2.Reg) & 0x7c) >> 2
}

// I2S.ESCO_CONF0
func (o *I2S_Type) SetESCO_CONF0_ESCO_EN(value uint32) {
	volatile.StoreUint32(&o.ESCO_CONF0.Reg, volatile.LoadUint32(&o.ESCO_CONF0.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetESCO_CONF0_ESCO_EN() uint32 {
	return volatile.LoadUint32(&o.ESCO_CONF0.Reg) & 0x1
}
func (o *I2S_Type) SetESCO_CONF0_ESCO_CHAN_MOD(value uint32) {
	volatile.StoreUint32(&o.ESCO_CONF0.Reg, volatile.LoadUint32(&o.ESCO_CONF0.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetESCO_CONF0_ESCO_CHAN_MOD() uint32 {
	return (volatile.LoadUint32(&o.ESCO_CONF0.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetESCO_CONF0_ESCO_CVSD_DEC_PACK_ERR(value uint32) {
	volatile.StoreUint32(&o.ESCO_CONF0.Reg, volatile.LoadUint32(&o.ESCO_CONF0.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetESCO_CONF0_ESCO_CVSD_DEC_PACK_ERR() uint32 {
	return (volatile.LoadUint32(&o.ESCO_CONF0.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetESCO_CONF0_ESCO_CVSD_PACK_LEN_8K(value uint32) {
	volatile.StoreUint32(&o.ESCO_CONF0.Reg, volatile.LoadUint32(&o.ESCO_CONF0.Reg)&^(0xf8)|value<<3)
}
func (o *I2S_Type) GetESCO_CONF0_ESCO_CVSD_PACK_LEN_8K() uint32 {
	return (volatile.LoadUint32(&o.ESCO_CONF0.Reg) & 0xf8) >> 3
}
func (o *I2S_Type) SetESCO_CONF0_ESCO_CVSD_INF_EN(value uint32) {
	volatile.StoreUint32(&o.ESCO_CONF0.Reg, volatile.LoadUint32(&o.ESCO_CONF0.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetESCO_CONF0_ESCO_CVSD_INF_EN() uint32 {
	return (volatile.LoadUint32(&o.ESCO_CONF0.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetESCO_CONF0_CVSD_DEC_START(value uint32) {
	volatile.StoreUint32(&o.ESCO_CONF0.Reg, volatile.LoadUint32(&o.ESCO_CONF0.Reg)&^(0x200)|value<<9)
}
func (o *I2S_Type) GetESCO_CONF0_CVSD_DEC_START() uint32 {
	return (volatile.LoadUint32(&o.ESCO_CONF0.Reg) & 0x200) >> 9
}
func (o *I2S_Type) SetESCO_CONF0_CVSD_DEC_RESET(value uint32) {
	volatile.StoreUint32(&o.ESCO_CONF0.Reg, volatile.LoadUint32(&o.ESCO_CONF0.Reg)&^(0x400)|value<<10)
}
func (o *I2S_Type) GetESCO_CONF0_CVSD_DEC_RESET() uint32 {
	return (volatile.LoadUint32(&o.ESCO_CONF0.Reg) & 0x400) >> 10
}
func (o *I2S_Type) SetESCO_CONF0_PLC_EN(value uint32) {
	volatile.StoreUint32(&o.ESCO_CONF0.Reg, volatile.LoadUint32(&o.ESCO_CONF0.Reg)&^(0x800)|value<<11)
}
func (o *I2S_Type) GetESCO_CONF0_PLC_EN() uint32 {
	return (volatile.LoadUint32(&o.ESCO_CONF0.Reg) & 0x800) >> 11
}
func (o *I2S_Type) SetESCO_CONF0_PLC2DMA_EN(value uint32) {
	volatile.StoreUint32(&o.ESCO_CONF0.Reg, volatile.LoadUint32(&o.ESCO_CONF0.Reg)&^(0x1000)|value<<12)
}
func (o *I2S_Type) GetESCO_CONF0_PLC2DMA_EN() uint32 {
	return (volatile.LoadUint32(&o.ESCO_CONF0.Reg) & 0x1000) >> 12
}

// I2S.SCO_CONF0
func (o *I2S_Type) SetSCO_CONF0_SCO_WITH_I2S_EN(value uint32) {
	volatile.StoreUint32(&o.SCO_CONF0.Reg, volatile.LoadUint32(&o.SCO_CONF0.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetSCO_CONF0_SCO_WITH_I2S_EN() uint32 {
	return volatile.LoadUint32(&o.SCO_CONF0.Reg) & 0x1
}
func (o *I2S_Type) SetSCO_CONF0_SCO_NO_I2S_EN(value uint32) {
	volatile.StoreUint32(&o.SCO_CONF0.Reg, volatile.LoadUint32(&o.SCO_CONF0.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetSCO_CONF0_SCO_NO_I2S_EN() uint32 {
	return (volatile.LoadUint32(&o.SCO_CONF0.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetSCO_CONF0_CVSD_ENC_START(value uint32) {
	volatile.StoreUint32(&o.SCO_CONF0.Reg, volatile.LoadUint32(&o.SCO_CONF0.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetSCO_CONF0_CVSD_ENC_START() uint32 {
	return (volatile.LoadUint32(&o.SCO_CONF0.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetSCO_CONF0_CVSD_ENC_RESET(value uint32) {
	volatile.StoreUint32(&o.SCO_CONF0.Reg, volatile.LoadUint32(&o.SCO_CONF0.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetSCO_CONF0_CVSD_ENC_RESET() uint32 {
	return (volatile.LoadUint32(&o.SCO_CONF0.Reg) & 0x8) >> 3
}

// I2S.CONF1
func (o *I2S_Type) SetCONF1_TX_PCM_CONF(value uint32) {
	volatile.StoreUint32(&o.CONF1.Reg, volatile.LoadUint32(&o.CONF1.Reg)&^(0x7)|value)
}
func (o *I2S_Type) GetCONF1_TX_PCM_CONF() uint32 {
	return volatile.LoadUint32(&o.CONF1.Reg) & 0x7
}
func (o *I2S_Type) SetCONF1_TX_PCM_BYPASS(value uint32) {
	volatile.StoreUint32(&o.CONF1.Reg, volatile.LoadUint32(&o.CONF1.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetCONF1_TX_PCM_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.CONF1.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetCONF1_RX_PCM_CONF(value uint32) {
	volatile.StoreUint32(&o.CONF1.Reg, volatile.LoadUint32(&o.CONF1.Reg)&^(0x70)|value<<4)
}
func (o *I2S_Type) GetCONF1_RX_PCM_CONF() uint32 {
	return (volatile.LoadUint32(&o.CONF1.Reg) & 0x70) >> 4
}
func (o *I2S_Type) SetCONF1_RX_PCM_BYPASS(value uint32) {
	volatile.StoreUint32(&o.CONF1.Reg, volatile.LoadUint32(&o.CONF1.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetCONF1_RX_PCM_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.CONF1.Reg) & 0x80) >> 7
}
func (o *I2S_Type) SetCONF1_TX_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.CONF1.Reg, volatile.LoadUint32(&o.CONF1.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetCONF1_TX_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF1.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetCONF1_TX_ZEROS_RM_EN(value uint32) {
	volatile.StoreUint32(&o.CONF1.Reg, volatile.LoadUint32(&o.CONF1.Reg)&^(0x200)|value<<9)
}
func (o *I2S_Type) GetCONF1_TX_ZEROS_RM_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF1.Reg) & 0x200) >> 9
}

// I2S.PD_CONF
func (o *I2S_Type) SetPD_CONF_FIFO_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.PD_CONF.Reg, volatile.LoadUint32(&o.PD_CONF.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetPD_CONF_FIFO_FORCE_PD() uint32 {
	return volatile.LoadUint32(&o.PD_CONF.Reg) & 0x1
}
func (o *I2S_Type) SetPD_CONF_FIFO_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.PD_CONF.Reg, volatile.LoadUint32(&o.PD_CONF.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetPD_CONF_FIFO_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.PD_CONF.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetPD_CONF_PLC_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.PD_CONF.Reg, volatile.LoadUint32(&o.PD_CONF.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetPD_CONF_PLC_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.PD_CONF.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetPD_CONF_PLC_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.PD_CONF.Reg, volatile.LoadUint32(&o.PD_CONF.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetPD_CONF_PLC_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.PD_CONF.Reg) & 0x8) >> 3
}

// I2S.CONF2
func (o *I2S_Type) SetCONF2_CAMERA_EN(value uint32) {
	volatile.StoreUint32(&o.CONF2.Reg, volatile.LoadUint32(&o.CONF2.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetCONF2_CAMERA_EN() uint32 {
	return volatile.LoadUint32(&o.CONF2.Reg) & 0x1
}
func (o *I2S_Type) SetCONF2_LCD_TX_WRX2_EN(value uint32) {
	volatile.StoreUint32(&o.CONF2.Reg, volatile.LoadUint32(&o.CONF2.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetCONF2_LCD_TX_WRX2_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF2.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetCONF2_LCD_TX_SDX2_EN(value uint32) {
	volatile.StoreUint32(&o.CONF2.Reg, volatile.LoadUint32(&o.CONF2.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetCONF2_LCD_TX_SDX2_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF2.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetCONF2_DATA_ENABLE_TEST_EN(value uint32) {
	volatile.StoreUint32(&o.CONF2.Reg, volatile.LoadUint32(&o.CONF2.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetCONF2_DATA_ENABLE_TEST_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF2.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetCONF2_DATA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CONF2.Reg, volatile.LoadUint32(&o.CONF2.Reg)&^(0x10)|value<<4)
}
func (o *I2S_Type) GetCONF2_DATA_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CONF2.Reg) & 0x10) >> 4
}
func (o *I2S_Type) SetCONF2_LCD_EN(value uint32) {
	volatile.StoreUint32(&o.CONF2.Reg, volatile.LoadUint32(&o.CONF2.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetCONF2_LCD_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF2.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetCONF2_EXT_ADC_START_EN(value uint32) {
	volatile.StoreUint32(&o.CONF2.Reg, volatile.LoadUint32(&o.CONF2.Reg)&^(0x40)|value<<6)
}
func (o *I2S_Type) GetCONF2_EXT_ADC_START_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF2.Reg) & 0x40) >> 6
}
func (o *I2S_Type) SetCONF2_INTER_VALID_EN(value uint32) {
	volatile.StoreUint32(&o.CONF2.Reg, volatile.LoadUint32(&o.CONF2.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetCONF2_INTER_VALID_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF2.Reg) & 0x80) >> 7
}

// I2S.CLKM_CONF
func (o *I2S_Type) SetCLKM_CONF_CLKM_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0xff)|value)
}
func (o *I2S_Type) GetCLKM_CONF_CLKM_DIV_NUM() uint32 {
	return volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0xff
}
func (o *I2S_Type) SetCLKM_CONF_CLKM_DIV_B(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0x3f00)|value<<8)
}
func (o *I2S_Type) GetCLKM_CONF_CLKM_DIV_B() uint32 {
	return (volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0x3f00) >> 8
}
func (o *I2S_Type) SetCLKM_CONF_CLKM_DIV_A(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0xfc000)|value<<14)
}
func (o *I2S_Type) GetCLKM_CONF_CLKM_DIV_A() uint32 {
	return (volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0xfc000) >> 14
}
func (o *I2S_Type) SetCLKM_CONF_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0x100000)|value<<20)
}
func (o *I2S_Type) GetCLKM_CONF_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0x100000) >> 20
}
func (o *I2S_Type) SetCLKM_CONF_CLKA_ENA(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0x200000)|value<<21)
}
func (o *I2S_Type) GetCLKM_CONF_CLKA_ENA() uint32 {
	return (volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0x200000) >> 21
}

// I2S.SAMPLE_RATE_CONF
func (o *I2S_Type) SetSAMPLE_RATE_CONF_TX_BCK_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.SAMPLE_RATE_CONF.Reg, volatile.LoadUint32(&o.SAMPLE_RATE_CONF.Reg)&^(0x3f)|value)
}
func (o *I2S_Type) GetSAMPLE_RATE_CONF_TX_BCK_DIV_NUM() uint32 {
	return volatile.LoadUint32(&o.SAMPLE_RATE_CONF.Reg) & 0x3f
}
func (o *I2S_Type) SetSAMPLE_RATE_CONF_RX_BCK_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.SAMPLE_RATE_CONF.Reg, volatile.LoadUint32(&o.SAMPLE_RATE_CONF.Reg)&^(0xfc0)|value<<6)
}
func (o *I2S_Type) GetSAMPLE_RATE_CONF_RX_BCK_DIV_NUM() uint32 {
	return (volatile.LoadUint32(&o.SAMPLE_RATE_CONF.Reg) & 0xfc0) >> 6
}
func (o *I2S_Type) SetSAMPLE_RATE_CONF_TX_BITS_MOD(value uint32) {
	volatile.StoreUint32(&o.SAMPLE_RATE_CONF.Reg, volatile.LoadUint32(&o.SAMPLE_RATE_CONF.Reg)&^(0x3f000)|value<<12)
}
func (o *I2S_Type) GetSAMPLE_RATE_CONF_TX_BITS_MOD() uint32 {
	return (volatile.LoadUint32(&o.SAMPLE_RATE_CONF.Reg) & 0x3f000) >> 12
}
func (o *I2S_Type) SetSAMPLE_RATE_CONF_RX_BITS_MOD(value uint32) {
	volatile.StoreUint32(&o.SAMPLE_RATE_CONF.Reg, volatile.LoadUint32(&o.SAMPLE_RATE_CONF.Reg)&^(0xfc0000)|value<<18)
}
func (o *I2S_Type) GetSAMPLE_RATE_CONF_RX_BITS_MOD() uint32 {
	return (volatile.LoadUint32(&o.SAMPLE_RATE_CONF.Reg) & 0xfc0000) >> 18
}

// I2S.PDM_CONF
func (o *I2S_Type) SetPDM_CONF_TX_PDM_EN(value uint32) {
	volatile.StoreUint32(&o.PDM_CONF.Reg, volatile.LoadUint32(&o.PDM_CONF.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetPDM_CONF_TX_PDM_EN() uint32 {
	return volatile.LoadUint32(&o.PDM_CONF.Reg) & 0x1
}
func (o *I2S_Type) SetPDM_CONF_RX_PDM_EN(value uint32) {
	volatile.StoreUint32(&o.PDM_CONF.Reg, volatile.LoadUint32(&o.PDM_CONF.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetPDM_CONF_RX_PDM_EN() uint32 {
	return (volatile.LoadUint32(&o.PDM_CONF.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetPDM_CONF_PCM2PDM_CONV_EN(value uint32) {
	volatile.StoreUint32(&o.PDM_CONF.Reg, volatile.LoadUint32(&o.PDM_CONF.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetPDM_CONF_PCM2PDM_CONV_EN() uint32 {
	return (volatile.LoadUint32(&o.PDM_CONF.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetPDM_CONF_PDM2PCM_CONV_EN(value uint32) {
	volatile.StoreUint32(&o.PDM_CONF.Reg, volatile.LoadUint32(&o.PDM_CONF.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetPDM_CONF_PDM2PCM_CONV_EN() uint32 {
	return (volatile.LoadUint32(&o.PDM_CONF.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetPDM_CONF_TX_PDM_SINC_OSR2(value uint32) {
	volatile.StoreUint32(&o.PDM_CONF.Reg, volatile.LoadUint32(&o.PDM_CONF.Reg)&^(0xf0)|value<<4)
}
func (o *I2S_Type) GetPDM_CONF_TX_PDM_SINC_OSR2() uint32 {
	return (volatile.LoadUint32(&o.PDM_CONF.Reg) & 0xf0) >> 4
}
func (o *I2S_Type) SetPDM_CONF_TX_PDM_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.PDM_CONF.Reg, volatile.LoadUint32(&o.PDM_CONF.Reg)&^(0xff00)|value<<8)
}
func (o *I2S_Type) GetPDM_CONF_TX_PDM_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.PDM_CONF.Reg) & 0xff00) >> 8
}
func (o *I2S_Type) SetPDM_CONF_TX_PDM_HP_IN_SHIFT(value uint32) {
	volatile.StoreUint32(&o.PDM_CONF.Reg, volatile.LoadUint32(&o.PDM_CONF.Reg)&^(0x30000)|value<<16)
}
func (o *I2S_Type) GetPDM_CONF_TX_PDM_HP_IN_SHIFT() uint32 {
	return (volatile.LoadUint32(&o.PDM_CONF.Reg) & 0x30000) >> 16
}
func (o *I2S_Type) SetPDM_CONF_TX_PDM_LP_IN_SHIFT(value uint32) {
	volatile.StoreUint32(&o.PDM_CONF.Reg, volatile.LoadUint32(&o.PDM_CONF.Reg)&^(0xc0000)|value<<18)
}
func (o *I2S_Type) GetPDM_CONF_TX_PDM_LP_IN_SHIFT() uint32 {
	return (volatile.LoadUint32(&o.PDM_CONF.Reg) & 0xc0000) >> 18
}
func (o *I2S_Type) SetPDM_CONF_TX_PDM_SINC_IN_SHIFT(value uint32) {
	volatile.StoreUint32(&o.PDM_CONF.Reg, volatile.LoadUint32(&o.PDM_CONF.Reg)&^(0x300000)|value<<20)
}
func (o *I2S_Type) GetPDM_CONF_TX_PDM_SINC_IN_SHIFT() uint32 {
	return (volatile.LoadUint32(&o.PDM_CONF.Reg) & 0x300000) >> 20
}
func (o *I2S_Type) SetPDM_CONF_TX_PDM_SIGMADELTA_IN_SHIFT(value uint32) {
	volatile.StoreUint32(&o.PDM_CONF.Reg, volatile.LoadUint32(&o.PDM_CONF.Reg)&^(0xc00000)|value<<22)
}
func (o *I2S_Type) GetPDM_CONF_TX_PDM_SIGMADELTA_IN_SHIFT() uint32 {
	return (volatile.LoadUint32(&o.PDM_CONF.Reg) & 0xc00000) >> 22
}
func (o *I2S_Type) SetPDM_CONF_RX_PDM_SINC_DSR_16_EN(value uint32) {
	volatile.StoreUint32(&o.PDM_CONF.Reg, volatile.LoadUint32(&o.PDM_CONF.Reg)&^(0x1000000)|value<<24)
}
func (o *I2S_Type) GetPDM_CONF_RX_PDM_SINC_DSR_16_EN() uint32 {
	return (volatile.LoadUint32(&o.PDM_CONF.Reg) & 0x1000000) >> 24
}
func (o *I2S_Type) SetPDM_CONF_TX_PDM_HP_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PDM_CONF.Reg, volatile.LoadUint32(&o.PDM_CONF.Reg)&^(0x2000000)|value<<25)
}
func (o *I2S_Type) GetPDM_CONF_TX_PDM_HP_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PDM_CONF.Reg) & 0x2000000) >> 25
}

// I2S.PDM_FREQ_CONF
func (o *I2S_Type) SetPDM_FREQ_CONF_TX_PDM_FS(value uint32) {
	volatile.StoreUint32(&o.PDM_FREQ_CONF.Reg, volatile.LoadUint32(&o.PDM_FREQ_CONF.Reg)&^(0x3ff)|value)
}
func (o *I2S_Type) GetPDM_FREQ_CONF_TX_PDM_FS() uint32 {
	return volatile.LoadUint32(&o.PDM_FREQ_CONF.Reg) & 0x3ff
}
func (o *I2S_Type) SetPDM_FREQ_CONF_TX_PDM_FP(value uint32) {
	volatile.StoreUint32(&o.PDM_FREQ_CONF.Reg, volatile.LoadUint32(&o.PDM_FREQ_CONF.Reg)&^(0xffc00)|value<<10)
}
func (o *I2S_Type) GetPDM_FREQ_CONF_TX_PDM_FP() uint32 {
	return (volatile.LoadUint32(&o.PDM_FREQ_CONF.Reg) & 0xffc00) >> 10
}

// I2S.STATE
func (o *I2S_Type) SetSTATE_TX_IDLE(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetSTATE_TX_IDLE() uint32 {
	return volatile.LoadUint32(&o.STATE.Reg) & 0x1
}
func (o *I2S_Type) SetSTATE_TX_FIFO_RESET_BACK(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetSTATE_TX_FIFO_RESET_BACK() uint32 {
	return (volatile.LoadUint32(&o.STATE.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetSTATE_RX_FIFO_RESET_BACK(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetSTATE_RX_FIFO_RESET_BACK() uint32 {
	return (volatile.LoadUint32(&o.STATE.Reg) & 0x4) >> 2
}

// I2S.DATE
func (o *I2S_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, value)
}
func (o *I2S_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg)
}

// Input/Output Multiplexer
type IO_MUX_Type struct {
	PIN_CTRL volatile.Register32 // 0x0
	GPIO36   volatile.Register32 // 0x4
	GPIO37   volatile.Register32 // 0x8
	GPIO38   volatile.Register32 // 0xC
	GPIO39   volatile.Register32 // 0x10
	GPIO34   volatile.Register32 // 0x14
	GPIO35   volatile.Register32 // 0x18
	GPIO32   volatile.Register32 // 0x1C
	GPIO33   volatile.Register32 // 0x20
	GPIO25   volatile.Register32 // 0x24
	GPIO26   volatile.Register32 // 0x28
	GPIO27   volatile.Register32 // 0x2C
	GPIO14   volatile.Register32 // 0x30
	GPIO12   volatile.Register32 // 0x34
	GPIO13   volatile.Register32 // 0x38
	GPIO15   volatile.Register32 // 0x3C
	GPIO2    volatile.Register32 // 0x40
	GPIO0    volatile.Register32 // 0x44
	GPIO4    volatile.Register32 // 0x48
	GPIO16   volatile.Register32 // 0x4C
	GPIO17   volatile.Register32 // 0x50
	GPIO9    volatile.Register32 // 0x54
	GPIO10   volatile.Register32 // 0x58
	GPIO11   volatile.Register32 // 0x5C
	GPIO6    volatile.Register32 // 0x60
	GPIO7    volatile.Register32 // 0x64
	GPIO8    volatile.Register32 // 0x68
	GPIO5    volatile.Register32 // 0x6C
	GPIO18   volatile.Register32 // 0x70
	GPIO19   volatile.Register32 // 0x74
	GPIO20   volatile.Register32 // 0x78
	GPIO21   volatile.Register32 // 0x7C
	GPIO22   volatile.Register32 // 0x80
	GPIO3    volatile.Register32 // 0x84
	GPIO1    volatile.Register32 // 0x88
	GPIO23   volatile.Register32 // 0x8C
	GPIO24   volatile.Register32 // 0x90
}

// IO_MUX.PIN_CTRL
func (o *IO_MUX_Type) SetPIN_CTRL_CLK1(value uint32) {
	volatile.StoreUint32(&o.PIN_CTRL.Reg, volatile.LoadUint32(&o.PIN_CTRL.Reg)&^(0xf)|value)
}
func (o *IO_MUX_Type) GetPIN_CTRL_CLK1() uint32 {
	return volatile.LoadUint32(&o.PIN_CTRL.Reg) & 0xf
}
func (o *IO_MUX_Type) SetPIN_CTRL_CLK2(value uint32) {
	volatile.StoreUint32(&o.PIN_CTRL.Reg, volatile.LoadUint32(&o.PIN_CTRL.Reg)&^(0xf0)|value<<4)
}
func (o *IO_MUX_Type) GetPIN_CTRL_CLK2() uint32 {
	return (volatile.LoadUint32(&o.PIN_CTRL.Reg) & 0xf0) >> 4
}
func (o *IO_MUX_Type) SetPIN_CTRL_CLK3(value uint32) {
	volatile.StoreUint32(&o.PIN_CTRL.Reg, volatile.LoadUint32(&o.PIN_CTRL.Reg)&^(0xf00)|value<<8)
}
func (o *IO_MUX_Type) GetPIN_CTRL_CLK3() uint32 {
	return (volatile.LoadUint32(&o.PIN_CTRL.Reg) & 0xf00) >> 8
}

// IO_MUX.GPIO36
func (o *IO_MUX_Type) SetGPIO36_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO36_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO36.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO36_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO36_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO36_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO36_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO36_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO36_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO36_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO36_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO36_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO36_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO36_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO36_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO36_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO36_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO36_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO36_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO36_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO36_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO36_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO36_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO37
func (o *IO_MUX_Type) SetGPIO37_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO37_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO37.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO37_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO37_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO37_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO37_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO37_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO37_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO37_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO37_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO37_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO37_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO37_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO37_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO37_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO37_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO37_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO37_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO37_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO37_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO37_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO37_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO38
func (o *IO_MUX_Type) SetGPIO38_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO38_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO38.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO38_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO38_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO38_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO38_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO38_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO38_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO38_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO38_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO38_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO38_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO38_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO38_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO38_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO38_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO38_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO38_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO38_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO38_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO38_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO38_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO39
func (o *IO_MUX_Type) SetGPIO39_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO39_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO39.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO39_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO39_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO39.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO39_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO39_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO39.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO39_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO39_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO39.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO39_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO39_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO39.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO39_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO39_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO39.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO39_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO39_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO39.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO39_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO39_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO39.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO39_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO39_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO39.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO39_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO39_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO39.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO39_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO39_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO39.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO34
func (o *IO_MUX_Type) SetGPIO34_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO34_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO34.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO34_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO34_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO34_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO34_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO34_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO34_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO34_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO34_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO34_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO34_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO34_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO34_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO34_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO34_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO34_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO34_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO34_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO34_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO34_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO34_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO35
func (o *IO_MUX_Type) SetGPIO35_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO35_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO35.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO35_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO35_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO35_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO35_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO35_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO35_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO35_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO35_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO35_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO35_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO35_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO35_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO35_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO35_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO35_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO35_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO35_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO35_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO35_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO35_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO32
func (o *IO_MUX_Type) SetGPIO32_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO32_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO32.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO32_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO32_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO32_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO32_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO32_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO32_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO32_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO32_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO32_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO32_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO32_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO32_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO32_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO32_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO32_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO32_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO32_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO32_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO32_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO32_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO33
func (o *IO_MUX_Type) SetGPIO33_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO33_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO33.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO33_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO33_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO33_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO33_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO33_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO33_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO33_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO33_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO33_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO33_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO33_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO33_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO33_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO33_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO33_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO33_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO33_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO33_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO33_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO33_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO25
func (o *IO_MUX_Type) SetGPIO25_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO25.Reg, volatile.LoadUint32(&o.GPIO25.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO25_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO25.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO25_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO25.Reg, volatile.LoadUint32(&o.GPIO25.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO25_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO25.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO25_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO25.Reg, volatile.LoadUint32(&o.GPIO25.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO25_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO25.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO25_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO25.Reg, volatile.LoadUint32(&o.GPIO25.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO25_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO25.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO25_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO25.Reg, volatile.LoadUint32(&o.GPIO25.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO25_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO25.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO25_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO25.Reg, volatile.LoadUint32(&o.GPIO25.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO25_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO25.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO25_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO25.Reg, volatile.LoadUint32(&o.GPIO25.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO25_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO25.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO25_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO25.Reg, volatile.LoadUint32(&o.GPIO25.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO25_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO25.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO25_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO25.Reg, volatile.LoadUint32(&o.GPIO25.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO25_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO25.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO25_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO25.Reg, volatile.LoadUint32(&o.GPIO25.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO25_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO25.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO25_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO25.Reg, volatile.LoadUint32(&o.GPIO25.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO25_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO25.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO26
func (o *IO_MUX_Type) SetGPIO26_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO26_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO26.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO26_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO26_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO26_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO26_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO26_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO26_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO26_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO26_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO26_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO26_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO26_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO26_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO26_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO26_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO26_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO26_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO26_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO26_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO26_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO26_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO27
func (o *IO_MUX_Type) SetGPIO27_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO27_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO27.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO27_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO27_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO27_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO27_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO27_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO27_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO27_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO27_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO27_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO27_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO27_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO27_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO27_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO27_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO27_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO27_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO27_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO27_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO27_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO27_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO14
func (o *IO_MUX_Type) SetGPIO14_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO14_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO14.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO14_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO14_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO14_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO14_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO14_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO14_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO14_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO14_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO14_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO14_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO14_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO14_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO14_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO14_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO14_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO14_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO14_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO14_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO14_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO14_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO12
func (o *IO_MUX_Type) SetGPIO12_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO12_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO12.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO12_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO12_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO12_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO12_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO12_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO12_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO12_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO12_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO12_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO12_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO12_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO12_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO12_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO12_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO12_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO12_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO12_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO12_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO12_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO12_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO13
func (o *IO_MUX_Type) SetGPIO13_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO13_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO13.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO13_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO13_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO13_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO13_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO13_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO13_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO13_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO13_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO13_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO13_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO13_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO13_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO13_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO13_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO13_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO13_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO13_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO13_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO13_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO13_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO15
func (o *IO_MUX_Type) SetGPIO15_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO15_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO15.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO15_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO15_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO15_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO15_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO15_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO15_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO15_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO15_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO15_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO15_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO15_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO15_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO15_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO15_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO15_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO15_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO15_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO15_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO15_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO15_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO2
func (o *IO_MUX_Type) SetGPIO2_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO2_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO2.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO2_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO2_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO2_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO2_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO2_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO2_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO2_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO2_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO2_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO2_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO2_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO2_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO2_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO2_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO2_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO2_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO2_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO2_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO2_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO2_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO0
func (o *IO_MUX_Type) SetGPIO0_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO0_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO0.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO0_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO0_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO0_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO0_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO0_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO0_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO0_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO0_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO0_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO0_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO0_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO0_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO0_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO0_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO0_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO0_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO0_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO0_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO0_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO0_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO4
func (o *IO_MUX_Type) SetGPIO4_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO4_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO4.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO4_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO4_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO4_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO4_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO4_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO4_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO4_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO4_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO4_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO4_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO4_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO4_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO4_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO4_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO4_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO4_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO4_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO4_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO4_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO4_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO16
func (o *IO_MUX_Type) SetGPIO16_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO16_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO16.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO16_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO16_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO16_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO16_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO16_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO16_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO16_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO16_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO16_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO16_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO16_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO16_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO16_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO16_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO16_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO16_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO16_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO16_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO16_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO16_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO17
func (o *IO_MUX_Type) SetGPIO17_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO17_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO17.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO17_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO17_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO17_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO17_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO17_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO17_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO17_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO17_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO17_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO17_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO17_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO17_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO17_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO17_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO17_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO17_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO17_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO17_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO17_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO17_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO9
func (o *IO_MUX_Type) SetGPIO9_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO9_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO9.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO9_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO9_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO9_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO9_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO9_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO9_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO9_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO9_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO9_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO9_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO9_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO9_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO9_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO9_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO9_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO9_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO9_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO9_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO9_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO9_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO10
func (o *IO_MUX_Type) SetGPIO10_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO10_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO10.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO10_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO10_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO10_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO10_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO10_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO10_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO10_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO10_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO10_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO10_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO10_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO10_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO10_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO10_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO10_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO10_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO10_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO10_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO10_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO10_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO11
func (o *IO_MUX_Type) SetGPIO11_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO11_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO11.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO11_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO11_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO11_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO11_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO11_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO11_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO11_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO11_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO11_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO11_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO11_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO11_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO11_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO11_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO11_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO11_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO11_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO11_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO11_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO11_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO6
func (o *IO_MUX_Type) SetGPIO6_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO6_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO6.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO6_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO6_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO6_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO6_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO6_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO6_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO6_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO6_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO6_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO6_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO6_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO6_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO6_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO6_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO6_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO6_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO6_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO6_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO6_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO6_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO7
func (o *IO_MUX_Type) SetGPIO7_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO7_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO7.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO7_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO7_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO7_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO7_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO7_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO7_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO7_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO7_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO7_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO7_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO7_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO7_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO7_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO7_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO7_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO7_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO7_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO7_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO7_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO7_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO8
func (o *IO_MUX_Type) SetGPIO8_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO8_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO8.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO8_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO8_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO8_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO8_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO8_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO8_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO8_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO8_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO8_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO8_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO8_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO8_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO8_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO8_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO8_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO8_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO8_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO8_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO8_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO8_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO5
func (o *IO_MUX_Type) SetGPIO5_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO5_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO5.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO5_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO5_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO5_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO5_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO5_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO5_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO5_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO5_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO5_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO5_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO5_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO5_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO5_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO5_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO5_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO5_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO5_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO5_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO5_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO5_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO18
func (o *IO_MUX_Type) SetGPIO18_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO18_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO18.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO18_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO18_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO18_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO18_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO18_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO18_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO18_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO18_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO18_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO18_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO18_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO18_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO18_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO18_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO18_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO18_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO18_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO18_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO18_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO18_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO19
func (o *IO_MUX_Type) SetGPIO19_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO19_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO19.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO19_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO19_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO19_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO19_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO19_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO19_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO19_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO19_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO19_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO19_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO19_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO19_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO19_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO19_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO19_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO19_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO19_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO19_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO19_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO19_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO20
func (o *IO_MUX_Type) SetGPIO20_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO20_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO20.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO20_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO20_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO20_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO20_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO20_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO20_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO20_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO20_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO20_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO20_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO20_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO20_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO20_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO20_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO20_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO20_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO20_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO20_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO20_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO20_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO21
func (o *IO_MUX_Type) SetGPIO21_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO21_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO21.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO21_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO21_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO21_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO21_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO21_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO21_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO21_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO21_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO21_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO21_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO21_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO21_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO21_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO21_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO21_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO21_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO21_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO21_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO21_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO21_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO22
func (o *IO_MUX_Type) SetGPIO22_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO22.Reg, volatile.LoadUint32(&o.GPIO22.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO22_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO22.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO22_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO22.Reg, volatile.LoadUint32(&o.GPIO22.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO22_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO22.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO22_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO22.Reg, volatile.LoadUint32(&o.GPIO22.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO22_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO22.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO22_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO22.Reg, volatile.LoadUint32(&o.GPIO22.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO22_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO22.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO22_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO22.Reg, volatile.LoadUint32(&o.GPIO22.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO22_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO22.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO22_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO22.Reg, volatile.LoadUint32(&o.GPIO22.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO22_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO22.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO22_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO22.Reg, volatile.LoadUint32(&o.GPIO22.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO22_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO22.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO22_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO22.Reg, volatile.LoadUint32(&o.GPIO22.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO22_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO22.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO22_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO22.Reg, volatile.LoadUint32(&o.GPIO22.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO22_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO22.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO22_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO22.Reg, volatile.LoadUint32(&o.GPIO22.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO22_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO22.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO22_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO22.Reg, volatile.LoadUint32(&o.GPIO22.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO22_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO22.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO3
func (o *IO_MUX_Type) SetGPIO3_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO3_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO3.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO3_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO3_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO3_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO3_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO3_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO3_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO3_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO3_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO3_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO3_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO3_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO3_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO3_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO3_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO3_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO3_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO3_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO3_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO3_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO3_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO1
func (o *IO_MUX_Type) SetGPIO1_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO1_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO1.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO1_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO1_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO1_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO1_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO1_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO1_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO1_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO1_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO1_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO1_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO1_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO1_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO1_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO1_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO1_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO1_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO1_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO1_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO1_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO1_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO23
func (o *IO_MUX_Type) SetGPIO23_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO23.Reg, volatile.LoadUint32(&o.GPIO23.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO23_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO23.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO23_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO23.Reg, volatile.LoadUint32(&o.GPIO23.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO23_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO23.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO23_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO23.Reg, volatile.LoadUint32(&o.GPIO23.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO23_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO23.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO23_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO23.Reg, volatile.LoadUint32(&o.GPIO23.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO23_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO23.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO23_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO23.Reg, volatile.LoadUint32(&o.GPIO23.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO23_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO23.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO23_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO23.Reg, volatile.LoadUint32(&o.GPIO23.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO23_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO23.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO23_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO23.Reg, volatile.LoadUint32(&o.GPIO23.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO23_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO23.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO23_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO23.Reg, volatile.LoadUint32(&o.GPIO23.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO23_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO23.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO23_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO23.Reg, volatile.LoadUint32(&o.GPIO23.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO23_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO23.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO23_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO23.Reg, volatile.LoadUint32(&o.GPIO23.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO23_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO23.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO23_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO23.Reg, volatile.LoadUint32(&o.GPIO23.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO23_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO23.Reg) & 0x7000) >> 12
}

// IO_MUX.GPIO24
func (o *IO_MUX_Type) SetGPIO24_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO24.Reg, volatile.LoadUint32(&o.GPIO24.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO24_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO24.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO24_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO24.Reg, volatile.LoadUint32(&o.GPIO24.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO24_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO24.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO24_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO24.Reg, volatile.LoadUint32(&o.GPIO24.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO24_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO24.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO24_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO24.Reg, volatile.LoadUint32(&o.GPIO24.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO24_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO24.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO24_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO24.Reg, volatile.LoadUint32(&o.GPIO24.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO24_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO24.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO24_MCU_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO24.Reg, volatile.LoadUint32(&o.GPIO24.Reg)&^(0x60)|value<<5)
}
func (o *IO_MUX_Type) GetGPIO24_MCU_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO24.Reg) & 0x60) >> 5
}
func (o *IO_MUX_Type) SetGPIO24_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO24.Reg, volatile.LoadUint32(&o.GPIO24.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO24_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO24.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO24_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO24.Reg, volatile.LoadUint32(&o.GPIO24.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO24_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO24.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO24_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO24.Reg, volatile.LoadUint32(&o.GPIO24.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO24_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO24.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO24_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO24.Reg, volatile.LoadUint32(&o.GPIO24.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO24_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO24.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO24_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO24.Reg, volatile.LoadUint32(&o.GPIO24.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO24_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO24.Reg) & 0x7000) >> 12
}

// LED Control PWM (Pulse Width Modulation)
type LEDC_Type struct {
	HSCH0_CONF0    volatile.Register32 // 0x0
	HSCH0_HPOINT   volatile.Register32 // 0x4
	HSCH0_DUTY     volatile.Register32 // 0x8
	HSCH0_CONF1    volatile.Register32 // 0xC
	HSCH0_DUTY_R   volatile.Register32 // 0x10
	HSCH1_CONF0    volatile.Register32 // 0x14
	HSCH1_HPOINT   volatile.Register32 // 0x18
	HSCH1_DUTY     volatile.Register32 // 0x1C
	HSCH1_CONF1    volatile.Register32 // 0x20
	HSCH1_DUTY_R   volatile.Register32 // 0x24
	HSCH2_CONF0    volatile.Register32 // 0x28
	HSCH2_HPOINT   volatile.Register32 // 0x2C
	HSCH2_DUTY     volatile.Register32 // 0x30
	HSCH2_CONF1    volatile.Register32 // 0x34
	HSCH2_DUTY_R   volatile.Register32 // 0x38
	HSCH3_CONF0    volatile.Register32 // 0x3C
	HSCH3_HPOINT   volatile.Register32 // 0x40
	HSCH3_DUTY     volatile.Register32 // 0x44
	HSCH3_CONF1    volatile.Register32 // 0x48
	HSCH3_DUTY_R   volatile.Register32 // 0x4C
	HSCH4_CONF0    volatile.Register32 // 0x50
	HSCH4_HPOINT   volatile.Register32 // 0x54
	HSCH4_DUTY     volatile.Register32 // 0x58
	HSCH4_CONF1    volatile.Register32 // 0x5C
	HSCH4_DUTY_R   volatile.Register32 // 0x60
	HSCH5_CONF0    volatile.Register32 // 0x64
	HSCH5_HPOINT   volatile.Register32 // 0x68
	HSCH5_DUTY     volatile.Register32 // 0x6C
	HSCH5_CONF1    volatile.Register32 // 0x70
	HSCH5_DUTY_R   volatile.Register32 // 0x74
	HSCH6_CONF0    volatile.Register32 // 0x78
	HSCH6_HPOINT   volatile.Register32 // 0x7C
	HSCH6_DUTY     volatile.Register32 // 0x80
	HSCH6_CONF1    volatile.Register32 // 0x84
	HSCH6_DUTY_R   volatile.Register32 // 0x88
	HSCH7_CONF0    volatile.Register32 // 0x8C
	HSCH7_HPOINT   volatile.Register32 // 0x90
	HSCH7_DUTY     volatile.Register32 // 0x94
	HSCH7_CONF1    volatile.Register32 // 0x98
	HSCH7_DUTY_R   volatile.Register32 // 0x9C
	LSCH0_CONF0    volatile.Register32 // 0xA0
	LSCH0_HPOINT   volatile.Register32 // 0xA4
	LSCH0_DUTY     volatile.Register32 // 0xA8
	LSCH0_CONF1    volatile.Register32 // 0xAC
	LSCH0_DUTY_R   volatile.Register32 // 0xB0
	LSCH1_CONF0    volatile.Register32 // 0xB4
	LSCH1_HPOINT   volatile.Register32 // 0xB8
	LSCH1_DUTY     volatile.Register32 // 0xBC
	LSCH1_CONF1    volatile.Register32 // 0xC0
	LSCH1_DUTY_R   volatile.Register32 // 0xC4
	LSCH2_CONF0    volatile.Register32 // 0xC8
	LSCH2_HPOINT   volatile.Register32 // 0xCC
	LSCH2_DUTY     volatile.Register32 // 0xD0
	LSCH2_CONF1    volatile.Register32 // 0xD4
	LSCH2_DUTY_R   volatile.Register32 // 0xD8
	LSCH3_CONF0    volatile.Register32 // 0xDC
	LSCH3_HPOINT   volatile.Register32 // 0xE0
	LSCH3_DUTY     volatile.Register32 // 0xE4
	LSCH3_CONF1    volatile.Register32 // 0xE8
	LSCH3_DUTY_R   volatile.Register32 // 0xEC
	LSCH4_CONF0    volatile.Register32 // 0xF0
	LSCH4_HPOINT   volatile.Register32 // 0xF4
	LSCH4_DUTY     volatile.Register32 // 0xF8
	LSCH4_CONF1    volatile.Register32 // 0xFC
	LSCH4_DUTY_R   volatile.Register32 // 0x100
	LSCH5_CONF0    volatile.Register32 // 0x104
	LSCH5_HPOINT   volatile.Register32 // 0x108
	LSCH5_DUTY     volatile.Register32 // 0x10C
	LSCH5_CONF1    volatile.Register32 // 0x110
	LSCH5_DUTY_R   volatile.Register32 // 0x114
	LSCH6_CONF0    volatile.Register32 // 0x118
	LSCH6_HPOINT   volatile.Register32 // 0x11C
	LSCH6_DUTY     volatile.Register32 // 0x120
	LSCH6_CONF1    volatile.Register32 // 0x124
	LSCH6_DUTY_R   volatile.Register32 // 0x128
	LSCH7_CONF0    volatile.Register32 // 0x12C
	LSCH7_HPOINT   volatile.Register32 // 0x130
	LSCH7_DUTY     volatile.Register32 // 0x134
	LSCH7_CONF1    volatile.Register32 // 0x138
	LSCH7_DUTY_R   volatile.Register32 // 0x13C
	HSTIMER0_CONF  volatile.Register32 // 0x140
	HSTIMER0_VALUE volatile.Register32 // 0x144
	HSTIMER1_CONF  volatile.Register32 // 0x148
	HSTIMER1_VALUE volatile.Register32 // 0x14C
	HSTIMER2_CONF  volatile.Register32 // 0x150
	HSTIMER2_VALUE volatile.Register32 // 0x154
	HSTIMER3_CONF  volatile.Register32 // 0x158
	HSTIMER3_VALUE volatile.Register32 // 0x15C
	LSTIMER0_CONF  volatile.Register32 // 0x160
	LSTIMER0_VALUE volatile.Register32 // 0x164
	LSTIMER1_CONF  volatile.Register32 // 0x168
	LSTIMER1_VALUE volatile.Register32 // 0x16C
	LSTIMER2_CONF  volatile.Register32 // 0x170
	LSTIMER2_VALUE volatile.Register32 // 0x174
	LSTIMER3_CONF  volatile.Register32 // 0x178
	LSTIMER3_VALUE volatile.Register32 // 0x17C
	INT_RAW        volatile.Register32 // 0x180
	INT_ST         volatile.Register32 // 0x184
	INT_ENA        volatile.Register32 // 0x188
	INT_CLR        volatile.Register32 // 0x18C
	CONF           volatile.Register32 // 0x190
	_              [104]byte
	DATE           volatile.Register32 // 0x1FC
}

// LEDC.HSCH0_CONF0
func (o *LEDC_Type) SetHSCH0_CONF0_TIMER_SEL(value uint32) {
	volatile.StoreUint32(&o.HSCH0_CONF0.Reg, volatile.LoadUint32(&o.HSCH0_CONF0.Reg)&^(0x3)|value)
}
func (o *LEDC_Type) GetHSCH0_CONF0_TIMER_SEL() uint32 {
	return volatile.LoadUint32(&o.HSCH0_CONF0.Reg) & 0x3
}
func (o *LEDC_Type) SetHSCH0_CONF0_SIG_OUT_EN(value uint32) {
	volatile.StoreUint32(&o.HSCH0_CONF0.Reg, volatile.LoadUint32(&o.HSCH0_CONF0.Reg)&^(0x4)|value<<2)
}
func (o *LEDC_Type) GetHSCH0_CONF0_SIG_OUT_EN() uint32 {
	return (volatile.LoadUint32(&o.HSCH0_CONF0.Reg) & 0x4) >> 2
}
func (o *LEDC_Type) SetHSCH0_CONF0_IDLE_LV(value uint32) {
	volatile.StoreUint32(&o.HSCH0_CONF0.Reg, volatile.LoadUint32(&o.HSCH0_CONF0.Reg)&^(0x8)|value<<3)
}
func (o *LEDC_Type) GetHSCH0_CONF0_IDLE_LV() uint32 {
	return (volatile.LoadUint32(&o.HSCH0_CONF0.Reg) & 0x8) >> 3
}

// LEDC.HSCH0_HPOINT
func (o *LEDC_Type) SetHSCH0_HPOINT_HPOINT(value uint32) {
	volatile.StoreUint32(&o.HSCH0_HPOINT.Reg, volatile.LoadUint32(&o.HSCH0_HPOINT.Reg)&^(0xfffff)|value)
}
func (o *LEDC_Type) GetHSCH0_HPOINT_HPOINT() uint32 {
	return volatile.LoadUint32(&o.HSCH0_HPOINT.Reg) & 0xfffff
}

// LEDC.HSCH0_DUTY
func (o *LEDC_Type) SetHSCH0_DUTY_DUTY(value uint32) {
	volatile.StoreUint32(&o.HSCH0_DUTY.Reg, volatile.LoadUint32(&o.HSCH0_DUTY.Reg)&^(0x1ffffff)|value)
}
func (o *LEDC_Type) GetHSCH0_DUTY_DUTY() uint32 {
	return volatile.LoadUint32(&o.HSCH0_DUTY.Reg) & 0x1ffffff
}

// LEDC.HSCH0_CONF1
func (o *LEDC_Type) SetHSCH0_CONF1_DUTY_SCALE(value uint32) {
	volatile.StoreUint32(&o.HSCH0_CONF1.Reg, volatile.LoadUint32(&o.HSCH0_CONF1.Reg)&^(0x3ff)|value)
}
func (o *LEDC_Type) GetHSCH0_CONF1_DUTY_SCALE() uint32 {
	return volatile.LoadUint32(&o.HSCH0_CONF1.Reg) & 0x3ff
}
func (o *LEDC_Type) SetHSCH0_CONF1_DUTY_CYCLE(value uint32) {
	volatile.StoreUint32(&o.HSCH0_CONF1.Reg, volatile.LoadUint32(&o.HSCH0_CONF1.Reg)&^(0xffc00)|value<<10)
}
func (o *LEDC_Type) GetHSCH0_CONF1_DUTY_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.HSCH0_CONF1.Reg) & 0xffc00) >> 10
}
func (o *LEDC_Type) SetHSCH0_CONF1_DUTY_NUM(value uint32) {
	volatile.StoreUint32(&o.HSCH0_CONF1.Reg, volatile.LoadUint32(&o.HSCH0_CONF1.Reg)&^(0x3ff00000)|value<<20)
}
func (o *LEDC_Type) GetHSCH0_CONF1_DUTY_NUM() uint32 {
	return (volatile.LoadUint32(&o.HSCH0_CONF1.Reg) & 0x3ff00000) >> 20
}
func (o *LEDC_Type) SetHSCH0_CONF1_DUTY_INC(value uint32) {
	volatile.StoreUint32(&o.HSCH0_CONF1.Reg, volatile.LoadUint32(&o.HSCH0_CONF1.Reg)&^(0x40000000)|value<<30)
}
func (o *LEDC_Type) GetHSCH0_CONF1_DUTY_INC() uint32 {
	return (volatile.LoadUint32(&o.HSCH0_CONF1.Reg) & 0x40000000) >> 30
}
func (o *LEDC_Type) SetHSCH0_CONF1_DUTY_START(value uint32) {
	volatile.StoreUint32(&o.HSCH0_CONF1.Reg, volatile.LoadUint32(&o.HSCH0_CONF1.Reg)&^(0x80000000)|value<<31)
}
func (o *LEDC_Type) GetHSCH0_CONF1_DUTY_START() uint32 {
	return (volatile.LoadUint32(&o.HSCH0_CONF1.Reg) & 0x80000000) >> 31
}

// LEDC.HSCH0_DUTY_R
func (o *LEDC_Type) SetHSCH0_DUTY_R_DUTY_R(value uint32) {
	volatile.StoreUint32(&o.HSCH0_DUTY_R.Reg, volatile.LoadUint32(&o.HSCH0_DUTY_R.Reg)&^(0x1ffffff)|value)
}
func (o *LEDC_Type) GetHSCH0_DUTY_R_DUTY_R() uint32 {
	return volatile.LoadUint32(&o.HSCH0_DUTY_R.Reg) & 0x1ffffff
}

// LEDC.HSCH1_CONF0
func (o *LEDC_Type) SetHSCH1_CONF0_TIMER_SEL(value uint32) {
	volatile.StoreUint32(&o.HSCH1_CONF0.Reg, volatile.LoadUint32(&o.HSCH1_CONF0.Reg)&^(0x3)|value)
}
func (o *LEDC_Type) GetHSCH1_CONF0_TIMER_SEL() uint32 {
	return volatile.LoadUint32(&o.HSCH1_CONF0.Reg) & 0x3
}
func (o *LEDC_Type) SetHSCH1_CONF0_SIG_OUT_EN(value uint32) {
	volatile.StoreUint32(&o.HSCH1_CONF0.Reg, volatile.LoadUint32(&o.HSCH1_CONF0.Reg)&^(0x4)|value<<2)
}
func (o *LEDC_Type) GetHSCH1_CONF0_SIG_OUT_EN() uint32 {
	return (volatile.LoadUint32(&o.HSCH1_CONF0.Reg) & 0x4) >> 2
}
func (o *LEDC_Type) SetHSCH1_CONF0_IDLE_LV(value uint32) {
	volatile.StoreUint32(&o.HSCH1_CONF0.Reg, volatile.LoadUint32(&o.HSCH1_CONF0.Reg)&^(0x8)|value<<3)
}
func (o *LEDC_Type) GetHSCH1_CONF0_IDLE_LV() uint32 {
	return (volatile.LoadUint32(&o.HSCH1_CONF0.Reg) & 0x8) >> 3
}

// LEDC.HSCH1_HPOINT
func (o *LEDC_Type) SetHSCH1_HPOINT_HPOINT(value uint32) {
	volatile.StoreUint32(&o.HSCH1_HPOINT.Reg, volatile.LoadUint32(&o.HSCH1_HPOINT.Reg)&^(0xfffff)|value)
}
func (o *LEDC_Type) GetHSCH1_HPOINT_HPOINT() uint32 {
	return volatile.LoadUint32(&o.HSCH1_HPOINT.Reg) & 0xfffff
}

// LEDC.HSCH1_DUTY
func (o *LEDC_Type) SetHSCH1_DUTY_DUTY(value uint32) {
	volatile.StoreUint32(&o.HSCH1_DUTY.Reg, volatile.LoadUint32(&o.HSCH1_DUTY.Reg)&^(0x1ffffff)|value)
}
func (o *LEDC_Type) GetHSCH1_DUTY_DUTY() uint32 {
	return volatile.LoadUint32(&o.HSCH1_DUTY.Reg) & 0x1ffffff
}

// LEDC.HSCH1_CONF1
func (o *LEDC_Type) SetHSCH1_CONF1_DUTY_SCALE(value uint32) {
	volatile.StoreUint32(&o.HSCH1_CONF1.Reg, volatile.LoadUint32(&o.HSCH1_CONF1.Reg)&^(0x3ff)|value)
}
func (o *LEDC_Type) GetHSCH1_CONF1_DUTY_SCALE() uint32 {
	return volatile.LoadUint32(&o.HSCH1_CONF1.Reg) & 0x3ff
}
func (o *LEDC_Type) SetHSCH1_CONF1_DUTY_CYCLE(value uint32) {
	volatile.StoreUint32(&o.HSCH1_CONF1.Reg, volatile.LoadUint32(&o.HSCH1_CONF1.Reg)&^(0xffc00)|value<<10)
}
func (o *LEDC_Type) GetHSCH1_CONF1_DUTY_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.HSCH1_CONF1.Reg) & 0xffc00) >> 10
}
func (o *LEDC_Type) SetHSCH1_CONF1_DUTY_NUM(value uint32) {
	volatile.StoreUint32(&o.HSCH1_CONF1.Reg, volatile.LoadUint32(&o.HSCH1_CONF1.Reg)&^(0x3ff00000)|value<<20)
}
func (o *LEDC_Type) GetHSCH1_CONF1_DUTY_NUM() uint32 {
	return (volatile.LoadUint32(&o.HSCH1_CONF1.Reg) & 0x3ff00000) >> 20
}
func (o *LEDC_Type) SetHSCH1_CONF1_DUTY_INC(value uint32) {
	volatile.StoreUint32(&o.HSCH1_CONF1.Reg, volatile.LoadUint32(&o.HSCH1_CONF1.Reg)&^(0x40000000)|value<<30)
}
func (o *LEDC_Type) GetHSCH1_CONF1_DUTY_INC() uint32 {
	return (volatile.LoadUint32(&o.HSCH1_CONF1.Reg) & 0x40000000) >> 30
}
func (o *LEDC_Type) SetHSCH1_CONF1_DUTY_START(value uint32) {
	volatile.StoreUint32(&o.HSCH1_CONF1.Reg, volatile.LoadUint32(&o.HSCH1_CONF1.Reg)&^(0x80000000)|value<<31)
}
func (o *LEDC_Type) GetHSCH1_CONF1_DUTY_START() uint32 {
	return (volatile.LoadUint32(&o.HSCH1_CONF1.Reg) & 0x80000000) >> 31
}

// LEDC.HSCH1_DUTY_R
func (o *LEDC_Type) SetHSCH1_DUTY_R_DUTY_R(value uint32) {
	volatile.StoreUint32(&o.HSCH1_DUTY_R.Reg, volatile.LoadUint32(&o.HSCH1_DUTY_R.Reg)&^(0x1ffffff)|value)
}
func (o *LEDC_Type) GetHSCH1_DUTY_R_DUTY_R() uint32 {
	return volatile.LoadUint32(&o.HSCH1_DUTY_R.Reg) & 0x1ffffff
}

// LEDC.HSCH2_CONF0
func (o *LEDC_Type) SetHSCH2_CONF0_TIMER_SEL(value uint32) {
	volatile.StoreUint32(&o.HSCH2_CONF0.Reg, volatile.LoadUint32(&o.HSCH2_CONF0.Reg)&^(0x3)|value)
}
func (o *LEDC_Type) GetHSCH2_CONF0_TIMER_SEL() uint32 {
	return volatile.LoadUint32(&o.HSCH2_CONF0.Reg) & 0x3
}
func (o *LEDC_Type) SetHSCH2_CONF0_SIG_OUT_EN(value uint32) {
	volatile.StoreUint32(&o.HSCH2_CONF0.Reg, volatile.LoadUint32(&o.HSCH2_CONF0.Reg)&^(0x4)|value<<2)
}
func (o *LEDC_Type) GetHSCH2_CONF0_SIG_OUT_EN() uint32 {
	return (volatile.LoadUint32(&o.HSCH2_CONF0.Reg) & 0x4) >> 2
}
func (o *LEDC_Type) SetHSCH2_CONF0_IDLE_LV(value uint32) {
	volatile.StoreUint32(&o.HSCH2_CONF0.Reg, volatile.LoadUint32(&o.HSCH2_CONF0.Reg)&^(0x8)|value<<3)
}
func (o *LEDC_Type) GetHSCH2_CONF0_IDLE_LV() uint32 {
	return (volatile.LoadUint32(&o.HSCH2_CONF0.Reg) & 0x8) >> 3
}

// LEDC.HSCH2_HPOINT
func (o *LEDC_Type) SetHSCH2_HPOINT_HPOINT(value uint32) {
	volatile.StoreUint32(&o.HSCH2_HPOINT.Reg, volatile.LoadUint32(&o.HSCH2_HPOINT.Reg)&^(0xfffff)|value)
}
func (o *LEDC_Type) GetHSCH2_HPOINT_HPOINT() uint32 {
	return volatile.LoadUint32(&o.HSCH2_HPOINT.Reg) & 0xfffff
}

// LEDC.HSCH2_DUTY
func (o *LEDC_Type) SetHSCH2_DUTY_DUTY(value uint32) {
	volatile.StoreUint32(&o.HSCH2_DUTY.Reg, volatile.LoadUint32(&o.HSCH2_DUTY.Reg)&^(0x1ffffff)|value)
}
func (o *LEDC_Type) GetHSCH2_DUTY_DUTY() uint32 {
	return volatile.LoadUint32(&o.HSCH2_DUTY.Reg) & 0x1ffffff
}

// LEDC.HSCH2_CONF1
func (o *LEDC_Type) SetHSCH2_CONF1_DUTY_SCALE(value uint32) {
	volatile.StoreUint32(&o.HSCH2_CONF1.Reg, volatile.LoadUint32(&o.HSCH2_CONF1.Reg)&^(0x3ff)|value)
}
func (o *LEDC_Type) GetHSCH2_CONF1_DUTY_SCALE() uint32 {
	return volatile.LoadUint32(&o.HSCH2_CONF1.Reg) & 0x3ff
}
func (o *LEDC_Type) SetHSCH2_CONF1_DUTY_CYCLE(value uint32) {
	volatile.StoreUint32(&o.HSCH2_CONF1.Reg, volatile.LoadUint32(&o.HSCH2_CONF1.Reg)&^(0xffc00)|value<<10)
}
func (o *LEDC_Type) GetHSCH2_CONF1_DUTY_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.HSCH2_CONF1.Reg) & 0xffc00) >> 10
}
func (o *LEDC_Type) SetHSCH2_CONF1_DUTY_NUM(value uint32) {
	volatile.StoreUint32(&o.HSCH2_CONF1.Reg, volatile.LoadUint32(&o.HSCH2_CONF1.Reg)&^(0x3ff00000)|value<<20)
}
func (o *LEDC_Type) GetHSCH2_CONF1_DUTY_NUM() uint32 {
	return (volatile.LoadUint32(&o.HSCH2_CONF1.Reg) & 0x3ff00000) >> 20
}
func (o *LEDC_Type) SetHSCH2_CONF1_DUTY_INC(value uint32) {
	volatile.StoreUint32(&o.HSCH2_CONF1.Reg, volatile.LoadUint32(&o.HSCH2_CONF1.Reg)&^(0x40000000)|value<<30)
}
func (o *LEDC_Type) GetHSCH2_CONF1_DUTY_INC() uint32 {
	return (volatile.LoadUint32(&o.HSCH2_CONF1.Reg) & 0x40000000) >> 30
}
func (o *LEDC_Type) SetHSCH2_CONF1_DUTY_START(value uint32) {
	volatile.StoreUint32(&o.HSCH2_CONF1.Reg, volatile.LoadUint32(&o.HSCH2_CONF1.Reg)&^(0x80000000)|value<<31)
}
func (o *LEDC_Type) GetHSCH2_CONF1_DUTY_START() uint32 {
	return (volatile.LoadUint32(&o.HSCH2_CONF1.Reg) & 0x80000000) >> 31
}

// LEDC.HSCH2_DUTY_R
func (o *LEDC_Type) SetHSCH2_DUTY_R_DUTY_R(value uint32) {
	volatile.StoreUint32(&o.HSCH2_DUTY_R.Reg, volatile.LoadUint32(&o.HSCH2_DUTY_R.Reg)&^(0x1ffffff)|value)
}
func (o *LEDC_Type) GetHSCH2_DUTY_R_DUTY_R() uint32 {
	return volatile.LoadUint32(&o.HSCH2_DUTY_R.Reg) & 0x1ffffff
}

// LEDC.HSCH3_CONF0
func (o *LEDC_Type) SetHSCH3_CONF0_TIMER_SEL(value uint32) {
	volatile.StoreUint32(&o.HSCH3_CONF0.Reg, volatile.LoadUint32(&o.HSCH3_CONF0.Reg)&^(0x3)|value)
}
func (o *LEDC_Type) GetHSCH3_CONF0_TIMER_SEL() uint32 {
	return volatile.LoadUint32(&o.HSCH3_CONF0.Reg) & 0x3
}
func (o *LEDC_Type) SetHSCH3_CONF0_SIG_OUT_EN(value uint32) {
	volatile.StoreUint32(&o.HSCH3_CONF0.Reg, volatile.LoadUint32(&o.HSCH3_CONF0.Reg)&^(0x4)|value<<2)
}
func (o *LEDC_Type) GetHSCH3_CONF0_SIG_OUT_EN() uint32 {
	return (volatile.LoadUint32(&o.HSCH3_CONF0.Reg) & 0x4) >> 2
}
func (o *LEDC_Type) SetHSCH3_CONF0_IDLE_LV(value uint32) {
	volatile.StoreUint32(&o.HSCH3_CONF0.Reg, volatile.LoadUint32(&o.HSCH3_CONF0.Reg)&^(0x8)|value<<3)
}
func (o *LEDC_Type) GetHSCH3_CONF0_IDLE_LV() uint32 {
	return (volatile.LoadUint32(&o.HSCH3_CONF0.Reg) & 0x8) >> 3
}

// LEDC.HSCH3_HPOINT
func (o *LEDC_Type) SetHSCH3_HPOINT_HPOINT(value uint32) {
	volatile.StoreUint32(&o.HSCH3_HPOINT.Reg, volatile.LoadUint32(&o.HSCH3_HPOINT.Reg)&^(0xfffff)|value)
}
func (o *LEDC_Type) GetHSCH3_HPOINT_HPOINT() uint32 {
	return volatile.LoadUint32(&o.HSCH3_HPOINT.Reg) & 0xfffff
}

// LEDC.HSCH3_DUTY
func (o *LEDC_Type) SetHSCH3_DUTY_DUTY(value uint32) {
	volatile.StoreUint32(&o.HSCH3_DUTY.Reg, volatile.LoadUint32(&o.HSCH3_DUTY.Reg)&^(0x1ffffff)|value)
}
func (o *LEDC_Type) GetHSCH3_DUTY_DUTY() uint32 {
	return volatile.LoadUint32(&o.HSCH3_DUTY.Reg) & 0x1ffffff
}

// LEDC.HSCH3_CONF1
func (o *LEDC_Type) SetHSCH3_CONF1_DUTY_SCALE(value uint32) {
	volatile.StoreUint32(&o.HSCH3_CONF1.Reg, volatile.LoadUint32(&o.HSCH3_CONF1.Reg)&^(0x3ff)|value)
}
func (o *LEDC_Type) GetHSCH3_CONF1_DUTY_SCALE() uint32 {
	return volatile.LoadUint32(&o.HSCH3_CONF1.Reg) & 0x3ff
}
func (o *LEDC_Type) SetHSCH3_CONF1_DUTY_CYCLE(value uint32) {
	volatile.StoreUint32(&o.HSCH3_CONF1.Reg, volatile.LoadUint32(&o.HSCH3_CONF1.Reg)&^(0xffc00)|value<<10)
}
func (o *LEDC_Type) GetHSCH3_CONF1_DUTY_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.HSCH3_CONF1.Reg) & 0xffc00) >> 10
}
func (o *LEDC_Type) SetHSCH3_CONF1_DUTY_NUM(value uint32) {
	volatile.StoreUint32(&o.HSCH3_CONF1.Reg, volatile.LoadUint32(&o.HSCH3_CONF1.Reg)&^(0x3ff00000)|value<<20)
}
func (o *LEDC_Type) GetHSCH3_CONF1_DUTY_NUM() uint32 {
	return (volatile.LoadUint32(&o.HSCH3