/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.Objects;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.sequencediagram.InGroupable;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalElement;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.SegmentColored;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.url.Url;

final class NoteBox
extends GraphicalElement
implements InGroupable {
    private final NotePosition position;
    private final Url url;
    private final LivingParticipantBox p1;
    private final LivingParticipantBox p2;
    private final Component comp;
    private double delta = 0.0;

    public NoteBox(double startingY, Component comp, LivingParticipantBox p1, LivingParticipantBox p2, NotePosition position, Url url) {
        super(startingY);
        if (p2 != null ^ position == NotePosition.OVER_SEVERAL) {
            throw new IllegalArgumentException();
        }
        this.p1 = Objects.requireNonNull(p1);
        this.p2 = p2;
        this.position = position;
        this.url = url;
        this.comp = comp;
    }

    public double getRightShift(double y) {
        if (this.p1 == null) {
            return 0.0;
        }
        return this.p1.getLifeLine().getRightShift(y) + 5.0;
    }

    @Override
    public final double getPreferredWidth(StringBounder stringBounder) {
        double preferredWidth = this.comp.getPreferredWidth(stringBounder);
        if (this.position == NotePosition.OVER_SEVERAL) {
            assert (this.p1 != this.p2);
            double diff1 = this.p2.getParticipantBox().getMaxX(stringBounder) - this.p1.getParticipantBox().getMinX();
            if (diff1 > preferredWidth) {
                return diff1;
            }
        }
        return preferredWidth;
    }

    @Override
    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.comp.getPreferredHeight(stringBounder);
    }

    @Override
    protected void drawInternalU(UGraphic ug, double maxX, Context2D context) {
        StringBounder stringBounder = ug.getStringBounder();
        double xStart = this.getStartingX(stringBounder);
        ug = ug.apply(new UTranslate(xStart, this.getStartingY()));
        XDimension2D dimensionToUse = new XDimension2D(this.getPreferredWidth(stringBounder), this.comp.getPreferredHeight(stringBounder));
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        this.comp.drawU(ug, new Area(dimensionToUse), context);
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    @Override
    public double getStartingX(StringBounder stringBounder) {
        int xStart;
        SegmentColored segment = this.getSegment(stringBounder);
        if (this.position == NotePosition.LEFT) {
            xStart = (int)(segment.getSegment().getPos1() - this.getPreferredWidth(stringBounder));
        } else if (this.position == NotePosition.RIGHT) {
            xStart = (int)segment.getSegment().getPos2();
        } else if (this.position == NotePosition.OVER) {
            xStart = (int)(this.p1.getParticipantBox().getCenterX(stringBounder) - this.getPreferredWidth(stringBounder) / 2.0);
        } else if (this.position == NotePosition.OVER_SEVERAL) {
            double centre = (this.p1.getParticipantBox().getCenterX(stringBounder) + this.p2.getParticipantBox().getCenterX(stringBounder)) / 2.0;
            xStart = (int)(centre - this.getPreferredWidth(stringBounder) / 2.0);
        } else {
            throw new IllegalStateException();
        }
        return (double)xStart + this.delta;
    }

    private SegmentColored getSegment(StringBounder stringBounder) {
        SegmentColored segment = this.p1.getLiveThicknessAt(stringBounder, this.getStartingY());
        SegmentColored segment2 = this.p1.getLiveThicknessAt(stringBounder, this.getStartingY() + this.comp.getPreferredHeight(stringBounder));
        return segment.merge(segment2);
    }

    public void pushToRight(double x) {
        this.delta += x;
    }

    @Override
    public double getMaxX(StringBounder stringBounder) {
        return this.getStartingX(stringBounder) + this.getPreferredWidth(stringBounder);
    }

    @Override
    public double getMinX(StringBounder stringBounder) {
        return this.getStartingX(stringBounder);
    }

    @Override
    public String toString(StringBounder stringBounder) {
        return this.toString();
    }

    public final Url getUrl() {
        return this.url;
    }

    public NotePosition getNotePosition() {
        return this.position;
    }
}

