/*
 * Decompiled with CFR 0.152.
 */
package zext.plantuml.com.ctreber.acearth.shader;

import java.awt.Color;
import zext.plantuml.com.ctreber.acearth.shader.Shader;

public class ShaderOrtho
extends Shader {
    private static double[] fXValues;

    @Override
    public Color[] getShadedColors(int pRowNo, int[] pRowTypes) {
        if (pRowNo == 0) {
            fXValues = this.computeXValues(pRowTypes.length);
        }
        double y = this.fProjection.inverseProjectY(this.fProjection.inverseFinalizeY(pRowNo));
        double tmp = 1.0 - y * y;
        double lYBySunVectorY = y * this.fLightVector.getY();
        Color[] lColors = new Color[pRowTypes.length];
        for (int lColNo = 0; lColNo < pRowTypes.length; ++lColNo) {
            double x = fXValues[lColNo];
            double z = Math.sqrt(tmp - x * x);
            double lSunValue = x * this.fLightVector.getX() + lYBySunVectorY + z * this.fLightVector.getZ();
            lColors[lColNo] = this.getShadedColorForType(pRowTypes[lColNo], lSunValue);
        }
        return lColors;
    }

    private double[] computeXValues(int pWidth) {
        double[] lTable = new double[pWidth];
        for (int lColNo = 0; lColNo < pWidth; ++lColNo) {
            lTable[lColNo] = this.fProjection.inverseProjectX(this.fProjection.inverseFinalizeX(lColNo));
        }
        return lTable;
    }
}

