/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.data.type.OpenSearchDataType;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprValueFactory;
import org.opensearch.sql.opensearch.planner.physical.ADOperator;
import org.opensearch.sql.opensearch.planner.physical.MLCommonsOperator;
import org.opensearch.sql.opensearch.planner.physical.MLOperator;
import org.opensearch.sql.opensearch.request.OpenSearchRequest;
import org.opensearch.sql.opensearch.request.OpenSearchRequestBuilder;
import org.opensearch.sql.opensearch.request.system.OpenSearchDescribeIndexRequest;
import org.opensearch.sql.opensearch.storage.scan.OpenSearchIndexScan;
import org.opensearch.sql.opensearch.storage.scan.OpenSearchIndexScanBuilder;
import org.opensearch.sql.planner.DefaultImplementor;
import org.opensearch.sql.planner.logical.LogicalAD;
import org.opensearch.sql.planner.logical.LogicalML;
import org.opensearch.sql.planner.logical.LogicalMLCommons;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalPlanNodeVisitor;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.storage.Table;
import org.opensearch.sql.storage.read.TableScanBuilder;

public class OpenSearchIndex
implements Table {
    public static final String METADATA_FIELD_ID = "_id";
    public static final String METADATA_FIELD_INDEX = "_index";
    public static final String METADATA_FIELD_SCORE = "_score";
    public static final String METADATA_FIELD_MAXSCORE = "_maxscore";
    public static final String METADATA_FIELD_SORT = "_sort";
    public static final String METADATA_FIELD_ROUTING = "_routing";
    public static final Map<String, ExprType> METADATAFIELD_TYPE_MAP = Map.of("_id", ExprCoreType.STRING, "_index", ExprCoreType.STRING, "_score", ExprCoreType.FLOAT, "_maxscore", ExprCoreType.FLOAT, "_sort", ExprCoreType.LONG, "_routing", ExprCoreType.STRING);
    private final OpenSearchClient client;
    private final Settings settings;
    private final OpenSearchRequest.IndexName indexName;
    private Map<String, OpenSearchDataType> cachedFieldOpenSearchTypes = null;
    private Map<String, ExprType> cachedFieldTypes = null;
    private Integer cachedMaxResultWindow = null;

    public OpenSearchIndex(OpenSearchClient client, Settings settings, String indexName) {
        this.client = client;
        this.settings = settings;
        this.indexName = new OpenSearchRequest.IndexName(indexName);
    }

    public boolean exists() {
        return this.client.exists(this.indexName.toString());
    }

    public void create(Map<String, ExprType> schema) {
        HashMap<String, Object> mappings = new HashMap<String, Object>();
        HashMap<String, String> properties = new HashMap<String, String>();
        mappings.put("properties", properties);
        for (Map.Entry<String, ExprType> colType : schema.entrySet()) {
            properties.put(colType.getKey(), colType.getValue().legacyTypeName().toLowerCase());
        }
        this.client.createIndex(this.indexName.toString(), mappings);
    }

    public Map<String, ExprType> getFieldTypes() {
        if (this.cachedFieldOpenSearchTypes == null) {
            this.cachedFieldOpenSearchTypes = new OpenSearchDescribeIndexRequest(this.client, this.indexName).getFieldTypes();
        }
        if (this.cachedFieldTypes == null) {
            this.cachedFieldTypes = OpenSearchDataType.traverseAndFlatten(this.cachedFieldOpenSearchTypes).entrySet().stream().collect(LinkedHashMap::new, (map, item) -> map.put((String)item.getKey(), ((OpenSearchDataType)item.getValue()).getExprType()), Map::putAll);
        }
        return this.cachedFieldTypes;
    }

    public Map<String, ExprType> getReservedFieldTypes() {
        return METADATAFIELD_TYPE_MAP;
    }

    public Map<String, OpenSearchDataType> getFieldOpenSearchTypes() {
        if (this.cachedFieldOpenSearchTypes == null) {
            this.cachedFieldOpenSearchTypes = new OpenSearchDescribeIndexRequest(this.client, this.indexName).getFieldTypes();
        }
        return this.cachedFieldOpenSearchTypes;
    }

    public Integer getMaxResultWindow() {
        if (this.cachedMaxResultWindow == null) {
            this.cachedMaxResultWindow = new OpenSearchDescribeIndexRequest(this.client, this.indexName).getMaxResultWindow();
        }
        return this.cachedMaxResultWindow;
    }

    public PhysicalPlan implement(LogicalPlan plan) {
        return (PhysicalPlan)plan.accept((LogicalPlanNodeVisitor)new OpenSearchDefaultImplementor(this.client), null);
    }

    public TableScanBuilder createScanBuilder() {
        int querySizeLimit = (Integer)this.settings.getSettingValue(Settings.Key.QUERY_SIZE_LIMIT);
        TimeValue cursorKeepAlive = (TimeValue)this.settings.getSettingValue(Settings.Key.SQL_CURSOR_KEEP_ALIVE);
        OpenSearchRequestBuilder builder = new OpenSearchRequestBuilder(querySizeLimit, this.createExprValueFactory());
        Function<OpenSearchRequestBuilder, OpenSearchIndexScan> createScanOperator = requestBuilder -> new OpenSearchIndexScan(this.client, requestBuilder.getMaxResponseSize(), requestBuilder.build(this.indexName, this.getMaxResultWindow(), cursorKeepAlive));
        return new OpenSearchIndexScanBuilder(builder, createScanOperator);
    }

    private OpenSearchExprValueFactory createExprValueFactory() {
        HashMap<String, OpenSearchDataType> allFields = new HashMap<String, OpenSearchDataType>();
        this.getReservedFieldTypes().forEach((k, v) -> allFields.put((String)k, OpenSearchDataType.of(v)));
        allFields.putAll(this.getFieldOpenSearchTypes());
        return new OpenSearchExprValueFactory(allFields);
    }

    @VisibleForTesting
    public static class OpenSearchDefaultImplementor
    extends DefaultImplementor<OpenSearchIndexScan> {
        private final OpenSearchClient client;

        public PhysicalPlan visitMLCommons(LogicalMLCommons node, OpenSearchIndexScan context) {
            return new MLCommonsOperator(this.visitChild((LogicalPlan)node, (Object)context), node.getAlgorithm(), node.getArguments(), this.client.getNodeClient());
        }

        public PhysicalPlan visitAD(LogicalAD node, OpenSearchIndexScan context) {
            return new ADOperator(this.visitChild((LogicalPlan)node, (Object)context), node.getArguments(), this.client.getNodeClient());
        }

        public PhysicalPlan visitML(LogicalML node, OpenSearchIndexScan context) {
            return new MLOperator(this.visitChild((LogicalPlan)node, (Object)context), node.getArguments(), this.client.getNodeClient());
        }

        @Generated
        public OpenSearchDefaultImplementor(OpenSearchClient client) {
            this.client = client;
        }
    }
}

