/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.core;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opensearch.performanceanalyzer.rca.framework.core.Node;
import org.opensearch.performanceanalyzer.rca.framework.core.SortByIngressOrder;

public class ConnectedComponent {
    private List<Node<?>> leafNodes;
    private List<List<Node<?>>> dependencyOrderedNodes;
    private Set<String> nodeNames = new HashSet<String>();
    private int graphId;

    public Set<Node<?>> getAllNodes() {
        HashSet traversed = new HashSet();
        ArrayDeque inline = new ArrayDeque(this.leafNodes);
        while (!inline.isEmpty()) {
            Node currNode = (Node)inline.poll();
            if (traversed.contains(currNode)) continue;
            traversed.add(currNode);
            this.nodeNames.add(currNode.name());
            List<Node<?>> currNodesDownstream = currNode.getDownStreams();
            if (currNodesDownstream.size() <= 0) continue;
            inline.addAll(currNodesDownstream);
        }
        return traversed;
    }

    public ConnectedComponent(int graphId) {
        this.leafNodes = new ArrayList();
        this.graphId = graphId;
    }

    public int getGraphId() {
        return this.graphId;
    }

    public void addLeafNode(Node node) {
        this.leafNodes.add(node);
    }

    public List<List<Node<?>>> getAllNodesByDependencyOrder() {
        if (this.dependencyOrderedNodes != null) {
            return this.dependencyOrderedNodes;
        }
        ArrayList allNodes = new ArrayList(this.getAllNodes());
        allNodes.sort(new SortByIngressOrder());
        this.dependencyOrderedNodes = new ArrayList(allNodes.size());
        int[] ingressCountArray = new int[allNodes.size()];
        ArrayDeque zeroIngressNodes = new ArrayDeque(allNodes.size() / 2);
        HashMap<Node, Integer> nodePositionMap = new HashMap<Node, Integer>(allNodes.size());
        int index = 0;
        for (Node node : allNodes) {
            int upStreamNodesCount = node.getUpStreamNodesCount();
            if (upStreamNodesCount == 0) {
                zeroIngressNodes.add(node);
            }
            ingressCountArray[index] = upStreamNodesCount;
            nodePositionMap.put(node, index);
            ++index;
        }
        while (!zeroIngressNodes.isEmpty()) {
            ArrayList innerList = new ArrayList(zeroIngressNodes);
            this.dependencyOrderedNodes.add(innerList);
            zeroIngressNodes.clear();
            for (Node node : innerList) {
                for (Node<?> downstreamNode : node.getDownStreams()) {
                    int pos;
                    int n = pos = ((Integer)nodePositionMap.get(downstreamNode)).intValue();
                    ingressCountArray[n] = ingressCountArray[n] - 1;
                    if (ingressCountArray[pos] != 0) continue;
                    zeroIngressNodes.addLast(downstreamNode);
                }
            }
        }
        return this.dependencyOrderedNodes;
    }

    public Set<String> getNodeNames() {
        return this.nodeNames;
    }

    public static Set<String> getNodesForAllComponents(List<ConnectedComponent> connectedComponentList) {
        HashSet<String> allNodes = new HashSet<String>();
        if (connectedComponentList != null) {
            for (ConnectedComponent connectedComponent : connectedComponentList) {
                allNodes.addAll(connectedComponent.getNodeNames());
            }
        }
        return allNodes;
    }
}

