/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.CapacityReservationFleet;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsResponse;

public class DescribeCapacityReservationFleetsPublisher
implements SdkPublisher<DescribeCapacityReservationFleetsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeCapacityReservationFleetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCapacityReservationFleetsPublisher(Ec2AsyncClient client, DescribeCapacityReservationFleetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCapacityReservationFleetsPublisher(Ec2AsyncClient client, DescribeCapacityReservationFleetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCapacityReservationFleetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCapacityReservationFleetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CapacityReservationFleet> capacityReservationFleets() {
        Function<DescribeCapacityReservationFleetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.capacityReservationFleets() != null) {
                return response.capacityReservationFleets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeCapacityReservationFleetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeCapacityReservationFleetsResponseFetcher
    implements AsyncPageFetcher<DescribeCapacityReservationFleetsResponse> {
        private DescribeCapacityReservationFleetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCapacityReservationFleetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeCapacityReservationFleetsResponse> nextPage(DescribeCapacityReservationFleetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCapacityReservationFleetsPublisher.this.client.describeCapacityReservationFleets(DescribeCapacityReservationFleetsPublisher.this.firstRequest);
            }
            return DescribeCapacityReservationFleetsPublisher.this.client.describeCapacityReservationFleets((DescribeCapacityReservationFleetsRequest)((Object)DescribeCapacityReservationFleetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

