/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.query;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.Query;
import org.opensearch.common.util.FeatureFlags;
import org.opensearch.search.aggregations.AggregationProcessor;
import org.opensearch.search.internal.ContextIndexSearcher;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.query.ConcurrentQueryPhaseSearcher;
import org.opensearch.search.query.QueryCollectorContext;
import org.opensearch.search.query.QueryPhase;
import org.opensearch.search.query.QueryPhaseSearcher;

public class QueryPhaseSearcherWrapper
implements QueryPhaseSearcher {
    private static final Logger LOGGER = LogManager.getLogger(QueryPhaseSearcherWrapper.class);
    private final QueryPhaseSearcher defaultQueryPhaseSearcher = new QueryPhase.DefaultQueryPhaseSearcher();
    private final QueryPhaseSearcher concurrentQueryPhaseSearcher = FeatureFlags.isEnabled("opensearch.experimental.feature.concurrent_segment_search.enabled") ? new ConcurrentQueryPhaseSearcher() : null;

    @Override
    public boolean searchWith(SearchContext searchContext, ContextIndexSearcher searcher, Query query, LinkedList<QueryCollectorContext> collectors, boolean hasFilterCollector, boolean hasTimeout) throws IOException {
        if (searchContext.shouldUseConcurrentSearch()) {
            LOGGER.debug("Using concurrent search over segments (experimental) for request with context id {}", (Object)searchContext.id());
            return this.concurrentQueryPhaseSearcher.searchWith(searchContext, searcher, query, collectors, hasFilterCollector, hasTimeout);
        }
        LOGGER.debug("Using non-concurrent search over segments for request with context id {}", (Object)searchContext.id());
        return this.defaultQueryPhaseSearcher.searchWith(searchContext, searcher, query, collectors, hasFilterCollector, hasTimeout);
    }

    @Override
    public AggregationProcessor aggregationProcessor(SearchContext searchContext) {
        if (searchContext.shouldUseConcurrentSearch()) {
            LOGGER.debug("Using concurrent aggregation processor over segments (experimental) for request with context id {}", (Object)searchContext.id());
            return this.concurrentQueryPhaseSearcher.aggregationProcessor(searchContext);
        }
        LOGGER.debug("Using non-concurrent aggregation processor over segments for request with context id {}", (Object)searchContext.id());
        return this.defaultQueryPhaseSearcher.aggregationProcessor(searchContext);
    }
}

