/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.concurrent.AbstractRefCounted;
import org.opensearch.index.IndexService;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.search.RescoreDocIds;
import org.opensearch.search.dfs.AggregatedDfs;
import org.opensearch.search.internal.ScrollContext;
import org.opensearch.search.internal.ShardSearchContextId;
import org.opensearch.search.internal.ShardSearchRequest;
import org.opensearch.transport.TransportRequest;

public class ReaderContext
implements Releasable {
    private final ShardSearchContextId id;
    private final IndexService indexService;
    private final IndexShard indexShard;
    protected final Engine.SearcherSupplier searcherSupplier;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final boolean singleSession;
    private final AtomicLong keepAlive;
    private final AtomicLong lastAccessTime;
    private final AbstractRefCounted refCounted;
    private final List<Releasable> onCloses = new CopyOnWriteArrayList<Releasable>();
    private final long startTimeInNano = System.nanoTime();
    private Map<String, Object> context;

    public ReaderContext(ShardSearchContextId id, IndexService indexService, IndexShard indexShard, Engine.SearcherSupplier searcherSupplier, long keepAliveInMillis, boolean singleSession) {
        this.id = id;
        this.indexService = indexService;
        this.indexShard = indexShard;
        this.searcherSupplier = searcherSupplier;
        this.singleSession = singleSession;
        this.keepAlive = new AtomicLong(keepAliveInMillis);
        this.lastAccessTime = new AtomicLong(this.nowInMillis());
        this.refCounted = new AbstractRefCounted("reader_context"){

            protected void closeInternal() {
                ReaderContext.this.doClose();
            }
        };
    }

    public void validate(TransportRequest request) {
        this.indexShard.getSearchOperationListener().validateReaderContext(this, request);
    }

    protected AbstractRefCounted getRefCounted() {
        return this.refCounted;
    }

    protected void updateLastAccessTime() {
        this.lastAccessTime.updateAndGet(curr -> Math.max(curr, this.nowInMillis()));
    }

    protected long nowInMillis() {
        return this.indexShard.getThreadPool().relativeTimeInMillis();
    }

    public long getKeepAlive() {
        return this.keepAlive.get();
    }

    public final void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.refCounted.decRef();
        }
    }

    void doClose() {
        Releasables.close((Releasable[])new Releasable[]{Releasables.wrap(this.onCloses), this.searcherSupplier});
    }

    public void addOnClose(Releasable releasable) {
        this.onCloses.add(releasable);
    }

    public ShardSearchContextId id() {
        return this.id;
    }

    public IndexService indexService() {
        return this.indexService;
    }

    public IndexShard indexShard() {
        return this.indexShard;
    }

    public Engine.Searcher acquireSearcher(String source) {
        return this.searcherSupplier.acquireSearcher(source);
    }

    public void tryUpdateKeepAlive(long keepAlive) {
        this.keepAlive.updateAndGet(curr -> Math.max(curr, keepAlive));
    }

    public Releasable markAsUsed(long keepAliveInMillis) {
        this.refCounted.incRef();
        this.tryUpdateKeepAlive(keepAliveInMillis);
        return Releasables.releaseOnce(() -> {
            this.lastAccessTime.updateAndGet(curr -> Math.max(curr, this.nowInMillis()));
            this.refCounted.decRef();
        });
    }

    public boolean isExpired() {
        if (this.refCounted.refCount() > 1) {
            return false;
        }
        long elapsed = this.nowInMillis() - this.lastAccessTime.get();
        return elapsed > this.keepAlive.get();
    }

    public ShardSearchRequest getShardSearchRequest(ShardSearchRequest other) {
        return Objects.requireNonNull(other);
    }

    public ScrollContext scrollContext() {
        return null;
    }

    public AggregatedDfs getAggregatedDfs(AggregatedDfs other) {
        return other;
    }

    public void setAggregatedDfs(AggregatedDfs aggregatedDfs) {
    }

    public RescoreDocIds getRescoreDocIds(RescoreDocIds other) {
        return Objects.requireNonNull(other);
    }

    public void setRescoreDocIds(RescoreDocIds rescoreDocIds) {
    }

    public boolean singleSession() {
        return this.singleSession;
    }

    public <T> T getFromContext(String key) {
        return (T)(this.context != null ? this.context.get(key) : null);
    }

    public void putInContext(String key, Object value) {
        if (this.context == null) {
            this.context = new HashMap<String, Object>();
        }
        this.context.put(key, value);
    }

    public long getStartTimeInNano() {
        return this.startTimeInNano;
    }
}

