# Changelog

## 5.5.2 – 2024-02-19
### Fixed
- sort fallback if not member of circle

## 5.5.1 – 2024-01-03
### Fixed
- Rename types in propreties
- Remove empty content overlaping related resources

## 5.5.0 – 2023-12-11
### Added
- Nextcloud 28 file action compatibility
- PHP8.3 support
- Circle type icons
- Shared items and events for each contact
### Changed
- Sort circles by initiator level
- Upgrade to Nextcloud vue 8.0.0
### Fixed
- Localization
- Telephone number type matching
- Lost contact groups
- Group deselection
- Permission check on files-actions
- Empty content showing on edit mode

## 5.4.0-rc.1 - 2023-08-31
### Added
- Quick actions for contacts
- Disabled wording to disabled address books
- Show/hide option for system and shared addressbooks
- Show address book description if provided
- Nextcloud 28 support
- Contact and group counters to address books
- Improve quick actions design
### Changed
- Deactivate social avatars from twitter
- Show single-value dropdowns as text in view mode
- Better description of circles
- Import modal improvement
- Hide contact groups if its empty
- Hide empty properties
- Always display Circles info
### Fixed
- Import loads forever
- Split up detailed-name again to fix vCard
- Hide not copyable addressbooks in copy select
- Handling group update
- Allow dynamic autoloading for classes added during upgrade
- Don't show groups in share placeholder if group sharing is disabled
- Add missing loading Icon
- Move QR code close button away from QR code image
## 5.1.0 - 2023-02-02
### Added
- Support for Nextcloud 26
- Support for PHP 8.2
- Allow social avatars from telegram
- Move app settings to a modal
### Removed
- Support for PHP 7.3 (EOL)
- Support for PHP 7.4 (EOL)
### Changed
- Use composer's authoritative classmap
- Rephrase "There is no member in this circle"
- Rename 'Groups' to 'Contact groups'
- Changed grammar of email address field label
### Fixed
- Prioritize local users in mastodon avatar download
- Empty content for settings dialogs

## 5.0.3 - 2023-01-24
### Fixed
- Social avatar background update
- Double scrollbar in contact details pane
- Use mastodon API instead of scraping HTML
- Mime case matching

## 4.2.4 - 2023-01-24
### Fixed
- Social avatar background update
- Double scrollbar in contact details pane
- Use mastodon API instead of scraping HTML
- Mime case matching

## 5.0.1 – 2022-10-18
### Fixed
- Org chart expand icon overlapped

## 5.0.0 – 2022-10-11
### Added
- Nextcloud 25 design
- Organization chart via manager property
### Changed
- New and updated translations
### Removed
- Nextcloud 22-24 support

## 4.2.2 – 2022-10-02
### Fixed
- Sharing address books with groups that have spaces in their name

## 4.2.1 – 2022-09-19
### Changed
- Important npm package updates

## 4.2.0 - 2022-07-19
### Added
- Enforce circle share password
- Quick search
### Changed
- Replaced icons with SVGs
- Manual date input
- New and updated translations
- Updated dependencies
### Fixed
- Encode group names for x-property-replace header

## 4.1.1 – 2022-05-18
### Changed
- Autosave birthdate
### Fixed
- Large social image import
- Screenshot URL

## 4.1.0 – 2022-03-22
### Added
- Nextcloud 24 support
- PHP8.1 support
- Sending emails to contact groups
- Performance improvements
### Changed
- New and updated translations
- Updated dependencies
- Expensive background jobs run only at off-peak times
### Fixed
- App icon
- Various small bugs
### Removed
- Nextcloud 20 support (EOL)

## 4.0.8 - 2022-02-17
### Fixed
- Overlapping navigation toggle
- Adding Circles members
- Broken IE check
- Date time picker

## 4.0.7 - 2021-12-16
### Fixed
- Missing action button closing after clicking QR code
- Circles

## 4.0.6 - 2021-11-03
### Fixed
- Missing front-end build artifacts

## 4.0.5 - 2021-11-03
### Fixed
- Missing front-end build artifacts

## 4.0.4 - 2021-11-03
### Fixed
- Missing avatars
- Group download

## 4.0.3 – 2021-09-15
### Fixed
- Missing SVG sanitization for SVG contact images

## 4.0.2 – 2021-08-25
### Changed
- App initialization logic migrated to silence a deprecation notice
### Fixed
- Blank page when files_sharing is disabled
- Mobile contacts list
- Scrolling of the app content details

## 4.0.1 - 2021-07-28

[Full Changelog](https://github.com/nextcloud/contacts/compare/v4.0.0...v4.0.1)

### Enhancements
- Streamlined Settings 
  [\#2372](https://github.com/nextcloud/contacts/pull/2372) ([szaimen](https://github.com/szaimen))
- Wording improvements 
  [\#2350](https://github.com/nextcloud/contacts/pull/2350) ([Valdnet](https://github.com/Valdnet))
- Various dependencies updates

### Fixed
- Fixed dark contacts icon 
  [\#2340](https://github.com/nextcloud/contacts/pull/2340) ([skjnldsv](https://github.com/skjnldsv))
- Adjusted the padding of app-content-details 
  [\#2341](https://github.com/nextcloud/contacts/pull/2341) ([szaimen](https://github.com/szaimen)) 
- Fixed call on null in SocialApiService
  [\#2351](https://github.com/nextcloud/contacts/pull/2351) ([juliushaertl](https://github.com/juliushaertl)) 

## 4.0.0 - 2021-07-06

[Full Changelog](https://github.com/nextcloud/contacts/compare/v3.5.1...v4.0.0)

### Featured enhancement
- Circles integration 
  [\#2098](https://github.com/nextcloud/contacts/pull/2098) ([skjnldsv](https://github.com/skjnldsv))

### Enhancements
- Comply to new resizeable list feature 
  [\#2246](https://github.com/nextcloud/contacts/pull/2246) ([skjnldsv](https://github.com/skjnldsv))
- Bump deps and use npm7 
  [\#2281](https://github.com/nextcloud/contacts/pull/2281) ([skjnldsv](https://github.com/skjnldsv))
- Bump dependencies and webpack 5 
  [\#2140](https://github.com/nextcloud/contacts/pull/2140) ([skjnldsv](https://github.com/skjnldsv))
- Remove core-js 
  [\#2323](https://github.com/nextcloud/contacts/pull/2323) ([skjnldsv](https://github.com/skjnldsv))
- Various dependencies updates

### Fixed
- Improve Compatibily with macOS Contacts 
  [\#1999](https://github.com/nextcloud/contacts/pull/1999) ([zlajo](https://github.com/zlajo))
- Fix chain condition of responses 
  [\#2286](https://github.com/nextcloud/contacts/pull/2286) ([skjnldsv](https://github.com/skjnldsv))
- Increase max-version to current dev version 22 
  [\#2169](https://github.com/nextcloud/contacts/pull/2169) ([jancborchardt](https://github.com/jancborchardt))
- l10n: Change spelling 
  [\#2189](https://github.com/nextcloud/contacts/pull/2189) ([Valdnet](https://github.com/Valdnet))
- l10n: Change to lowercase 
  [\#2190](https://github.com/nextcloud/contacts/pull/2190) ([Valdnet](https://github.com/Valdnet))
- l10n: Correct spelling 
  [\#2244](https://github.com/nextcloud/contacts/pull/2244) ([Valdnet](https://github.com/Valdnet))
- l10n: Spelling unification 
  [\#2233](https://github.com/nextcloud/contacts/pull/2233) ([Valdnet](https://github.com/Valdnet))
- l10n: Unify spelling 
  [\#2162](https://github.com/nextcloud/contacts/pull/2162) ([Valdnet](https://github.com/Valdnet))
- l10n: Error message changed 
  [\#2326](https://github.com/nextcloud/contacts/pull/2326) ([Valdnet](https://github.com/Valdnet))
- l10n: Change to a capital letter 
  [\#2305](https://github.com/nextcloud/contacts/pull/2305) ([Valdnet](https://github.com/Valdnet))
- l10n: Change to a capital letter 
  [\#2304](https://github.com/nextcloud/contacts/pull/2304) ([Valdnet](https://github.com/Valdnet))

## 3.5.1 - 2021-03-17

[Full Changelog](https://github.com/nextcloud/contacts/compare/v3.5.0...v3.5.1)

### Fixed
- Min support version is 19
  ([skjnldsv](https://github.com/skjnldsv))

## 3.5.0 - 2021-03-15

[Full Changelog](https://github.com/nextcloud/contacts/compare/v3.4.3...v3.5.0)

### Fixed
- Fix contact deletion from addressbook
  [\#2086](https://github.com/nextcloud/contacts/pull/2086) ([skjnldsv](https://github.com/skjnldsv))
- Alphabetically order groups in contact details \(\#2051\)
  [\#2076](https://github.com/nextcloud/contacts/pull/2076) ([harryyoud](https://github.com/harryyoud))
- Fix custom labels not being displayed
  [\#2064](https://github.com/nextcloud/contacts/pull/2064) ([Y0hy0h](https://github.com/Y0hy0h))
- Fix display name with empty last name when sorting by last name
  [\#2040](https://github.com/nextcloud/contacts/pull/2040) ([NerLOR](https://github.com/NerLOR))
- Make sure twitter returns the raw static html page so we can get the …
  [\#2013](https://github.com/nextcloud/contacts/pull/2013) ([skjnldsv](https://github.com/skjnldsv))
- Instagram profile sync with agent
  [\#2083](https://github.com/nextcloud/contacts/pull/2083) ([call-me-matt](https://github.com/call-me-matt))
- Adapted twitter uri
  [\#2081](https://github.com/nextcloud/contacts/pull/2081) ([call-me-matt](https://github.com/call-me-matt))

### Enhancements
- Use all email addresses for gravatar search
  [\#2085](https://github.com/nextcloud/contacts/pull/2085) ([call-me-matt](https://github.com/call-me-matt))


## 3.4.3 - 2021-01-04)

[Full Changelog](https://github.com/nextcloud/contacts/compare/v3.4.2...v3.4.3)

### Fixed
- Remove Workaround for Postal Addresses Containing Commas
  [\#2000](https://github.com/nextcloud/contacts/pull/2000) ([zlajo](https://github.com/zlajo))
- Fix masonry redraw
  [\#1982](https://github.com/nextcloud/contacts/pull/1982) ([skjnldsv](https://github.com/skjnldsv))
- Fix generating the redirect url
  [\#1972](https://github.com/nextcloud/contacts/pull/1972) ([juliushaertl](https://github.com/juliushaertl))
- Change to the name of the app
  [\#1965](https://github.com/nextcloud/contacts/pull/1965) ([Valdnet](https://github.com/Valdnet))
- Add favicons
  [\#1960](https://github.com/nextcloud/contacts/pull/1960) ([st3iny](https://github.com/st3iny))

## 3.4.2 - 2020-11-18

[Full Changelog](https://github.com/nextcloud/contacts/compare/v3.4.1...v3.4.2)

### Enhancements
- add support for downloading avatars from gravatar
  [\#1906](https://github.com/nextcloud/contacts/pull/1906) ([eleith](https://github.com/eleith))
- add xing to list of social networks
  [\#1871](https://github.com/nextcloud/contacts/pull/1871) ([call-me-matt](https://github.com/call-me-matt))
- add xing to social sync
  [\#1869](https://github.com/nextcloud/contacts/pull/1869) ([call-me-matt](https://github.com/call-me-matt))

### Fixed
- Replace the deprecated OC.Util.relativeModifiedDate by nextcloud/moment
  [\#1936](https://github.com/nextcloud/contacts/pull/1936) ([tintou](https://github.com/tintou))
- l10n: Rebuild string text
  [\#1893](https://github.com/nextcloud/contacts/pull/1893) ([Valdnet](https://github.com/Valdnet))
- Fix/dav plugins groups registration
  [\#1938](https://github.com/nextcloud/contacts/pull/1938) ([skjnldsv](https://github.com/skjnldsv))
- vcard should only have 1 photo field when adding/removing photos
  [\#1918](https://github.com/nextcloud/contacts/pull/1918) ([eleith](https://github.com/eleith))
- new facebook api prevents usage without authentication
  [\#1894](https://github.com/nextcloud/contacts/pull/1894) ([call-me-matt](https://github.com/call-me-matt))
- Fix Avatar ratio display
  [\#1884](https://github.com/nextcloud/contacts/pull/1884) ([skjnldsv](https://github.com/skjnldsv))
- Fix bulk contacts add to group
  [\#1883](https://github.com/nextcloud/contacts/pull/1883) ([skjnldsv](https://github.com/skjnldsv))
- l10n: Correct text string tag
  [\#1896](https://github.com/nextcloud/contacts/pull/1896) ([Valdnet](https://github.com/Valdnet))
- l10n: Correct text string tag for Settings
  [\#1895](https://github.com/nextcloud/contacts/pull/1895) ([Valdnet](https://github.com/Valdnet))
- l10n: Remove the quotation marks
  [\#1892](https://github.com/nextcloud/contacts/pull/1892) ([Valdnet](https://github.com/Valdnet))

## 3.4.1 - 2020-10-20

[Full Changelog](https://github.com/nextcloud/contacts/compare/v3.4.0...v3.4.1)

### Enhancements
- adding diaspora to the list for social sync
  [\#1853](https://github.com/nextcloud/contacts/pull/1853) ([call-me-matt](https://github.com/call-me-matt))

### Fixed
- Fix avatar display on read-only contacts and use global Avatar component
  [\#1846](https://github.com/nextcloud/contacts/pull/1846) ([skjnldsv](https://github.com/skjnldsv))
- Ignore errors from invalid social ids
  [\#1829](https://github.com/nextcloud/contacts/pull/1829) ([call-me-matt](https://github.com/call-me-matt))
- Fix placeholder display
  [\#1828](https://github.com/nextcloud/contacts/pull/1828) ([skjnldsv](https://github.com/skjnldsv))
- Fix social sync admin settings
  [\#1821](https://github.com/nextcloud/contacts/pull/1821) ([skjnldsv](https://github.com/skjnldsv))
- Force redraw masonry on property resize
  [\#1819](https://github.com/nextcloud/contacts/pull/1819) ([skjnldsv](https://github.com/skjnldsv))
- More robust social ids for social sync
  [\#1843](https://github.com/nextcloud/contacts/pull/1843) ([call-me-matt](https://github.com/call-me-matt))

## 3.4.0 - 2020-09-30

[Full Changelog](https://github.com/nextcloud/contacts/compare/v3.3.0...v3.4.0)

### Enhancements
- Add Matrix to list of instant messaging networks
  [\#1761](https://github.com/nextcloud/contacts/pull/1761) ([jtrees](https://github.com/jtrees))
- Add Zoom as instant messaging
  [\#1759](https://github.com/nextcloud/contacts/pull/1759) ([EmTeedee](https://github.com/EmTeedee))
- Update social avatars in chunks
  [\#1745](https://github.com/nextcloud/contacts/pull/1745) ([call-me-matt](https://github.com/call-me-matt))
- Allow to get direct contact route
  [\#1730](https://github.com/nextcloud/contacts/pull/1730) ([skjnldsv](https://github.com/skjnldsv))
- Allow for regular background updates of avatars from social networks
  [\#1722](https://github.com/nextcloud/contacts/pull/1722) ([call-me-matt](https://github.com/call-me-matt))
- Enh/social sync
  [\#1692](https://github.com/nextcloud/contacts/pull/1692) ([skjnldsv](https://github.com/skjnldsv))
- Add php cs & stylelint
  [\#1690](https://github.com/nextcloud/contacts/pull/1690) ([skjnldsv](https://github.com/skjnldsv))
- Import vcf from files
  [\#1688](https://github.com/nextcloud/contacts/pull/1688) ([skjnldsv](https://github.com/skjnldsv))
- Enh/add virtual group
  [\#1687](https://github.com/nextcloud/contacts/pull/1687) ([skjnldsv](https://github.com/skjnldsv))
- Additional link to picture menu
  [\#1645](https://github.com/nextcloud/contacts/pull/1645) ([call-me-matt](https://github.com/call-me-matt))
- Simplify form
  [\#1446](https://github.com/nextcloud/contacts/pull/1446) ([jancborchardt](https://github.com/jancborchardt))
- Support X-PHONETIC-FIRST-NAME and X-PHONETIC-LAST-NAME
  [\#1741](https://github.com/nextcloud/contacts/pull/1741) ([t-bucchi](https://github.com/t-bucchi))

### Fixed
- Fix/various design
  [\#1792](https://github.com/nextcloud/contacts/pull/1792) ([skjnldsv](https://github.com/skjnldsv))
- Add back the app details toggle
  [\#1790](https://github.com/nextcloud/contacts/pull/1790) ([skjnldsv](https://github.com/skjnldsv))
- Properly sort groups
  [\#1788](https://github.com/nextcloud/contacts/pull/1788) ([skjnldsv](https://github.com/skjnldsv))
- Fix default addressbook creation
  [\#1787](https://github.com/nextcloud/contacts/pull/1787) ([skjnldsv](https://github.com/skjnldsv))
- Fix avatar sanitize and cleanup code & css
  [\#1786](https://github.com/nextcloud/contacts/pull/1786) ([skjnldsv](https://github.com/skjnldsv))
- Fix/virtual group
  [\#1770](https://github.com/nextcloud/contacts/pull/1770) ([skjnldsv](https://github.com/skjnldsv))
- Implement masonry
  [\#1755](https://github.com/nextcloud/contacts/pull/1755) ([skjnldsv](https://github.com/skjnldsv))
- Fix group filter trim
  [\#1732](https://github.com/nextcloud/contacts/pull/1732) ([skjnldsv](https://github.com/skjnldsv))

## 3.3.0 – 2020-04-14

[Full Changelog](https://github.com/nextcloud/contacts/compare/v3.2.0...v3.3.0)

### Enhancements
- Add ability to clone contact
  [\#1462](https://github.com/nextcloud/contacts/pull/1462) ([skjnldsv](https://github.com/skjnldsv))

### Fixed
- Fix no sharing menu position
  [\#1500](https://github.com/nextcloud/contacts/pull/1500) ([skjnldsv](https://github.com/skjnldsv))
- Support multiple type declaration
  [\#942](https://github.com/nextcloud/contacts/issues/942) ([skjnldsv](https://github.com/skjnldsv))

### Security fixed
- Properly sanitize avatars in upload
  [\#1514](https://github.com/nextcloud/contacts/pull/1514) ([skjnldsv](https://github.com/skjnldsv))

## 3.2.0 – 2020-02-29
### Fixed
- Fix first contact sync (Contact saving hangs and protocol says uid already exists)
  [\#1488](https://github.com/nextcloud/contacts/pull/1488) ([skjnldsv](https://github.com/skjnldsv))

### Updated
- Translations

## 3.1.9 – 2020-02-26
### Enhancements
- Fix sorting and wording of contact picture actions
  [\#1448](https://github.com/nextcloud/contacts/pull/1448) ([jancborchardt](https://github.com/jancborchardt))
- Allow importing from files
  [\#1438](https://github.com/nextcloud/contacts/pull/1438) ([skjnldsv](https://github.com/skjnldsv))
- Remove delete action from list, fix \#1368
  [\#1430](https://github.com/nextcloud/contacts/pull/1430) ([jancborchardt](https://github.com/jancborchardt))

### Fixed
- l10n: Changed spelling
  [\#1463](https://github.com/nextcloud/contacts/pull/1463) ([rakekniven](https://github.com/rakekniven))
- Disable form validation for text properties
  [\#1418](https://github.com/nextcloud/contacts/pull/1418) ([hanzi](https://github.com/hanzi))

## 3.1.8 – 2020-01-22
### Fixed
- Fixed release number and 15 is EOL
- Fix issue that prevented new contacts from being saved
  [#1416](https://github.com/nextcloud/contacts/pull/1416) ([hanzi](https://github.com/hanzi))
- remove delete buttons and other actions if contact is not readable
  [#1413](https://github.com/nextcloud/contacts/pull/1413) ([myrho](https://github.com/myrho))
- Only add sharee if not present already
  [#1401](https://github.com/nextcloud/contacts/pull/1401) ([raimund-schluessler](https://github.com/raimund-schluessler))
- Fix 'duplicate types' check for properties with a single type
  [#1399](https://github.com/nextcloud/contacts/pull/1399) ([hanzi](https://github.com/hanzi))
- Workaround for bug that prevented editing vCards with commas in the address
  [#1394](https://github.com/nextcloud/contacts/pull/1394) ([hanzi](https://github.com/hanzi))
- Use correct syntax for vCard version when saving
  [#1393](https://github.com/nextcloud/contacts/pull/1393) ([hanzi](https://github.com/hanzi))
- short company field only if empty
  [#1412](https://github.com/nextcloud/contacts/pull/1412) ([myrho](https://github.com/myrho))

## 3.1.7 – 2019-12-09
### Enhancements
- Make the work profile the default one when adding Contacts
  [#1307](https://github.com/nextcloud/contacts/pull/1307)

### Fixed
- Fix first day of datepicker
  [#1314](https://github.com/nextcloud/contacts/pull/1314)

### Updated
- Dependencies
- Translations

## 3.1.6 – 2019-10-03
### Fixed
- Fix initialStateService for 15
  [#1292](https://github.com/nextcloud/contacts/pull/1292)

## 3.1.5 – 2019-10-03
### Fixed
- Better debug of the duplicate types check
  [#1290](https://github.com/nextcloud/contacts/pull/1290)
- Fix initialStateService for 15
  [#1291](https://github.com/nextcloud/contacts/pull/1291)

## 3.1.4 – 2019-09-28
### Enhancements
- Enhancement/allow year removal
  [#1248](https://github.com/nextcloud/contacts/pull/1248)
- Add TZ & LANG
  [#1264](https://github.com/nextcloud/contacts/pull/1264)
- Added possibility to show and edit vCard Geo attributes
  [#1250](https://github.com/nextcloud/contacts/pull/1250)

### Fixed
- Support vcard 3 photo syntax
  [#1239](https://github.com/nextcloud/contacts/pull/1239)
- Fix moment loading
  [#1249](https://github.com/nextcloud/contacts/pull/1249)
- Add push warning on fixed contact
  [#982](https://github.com/nextcloud/contacts/pull/982)

### Updated
- Dependencies
- Translations

## 3.1.3 – 2019-06-11
### Fixed
- Error on instances <16
  [853c3de](https://github.com/nextcloud/contacts/commit/853c3dead32d1375954e252bb4c3ccce867b56ec)

### Updated
- Translations

## 3.1.2 – 2019-06-10
### Added
- Components update, enhanced design and avatar management
  [#1103](https://github.com/nextcloud/contacts/pull/1103)

### Fixed
- Capture ctrl+s
  [#1102](https://github.com/nextcloud/contacts/pull/1102)
- Fix ghost contact when scrolling
  [#1132](https://github.com/nextcloud/contacts/pull/1132)
- Fix alignment and remove addressbook selector if only one
  [#1074](https://github.com/nextcloud/contacts/pull/1074)

### Updated
- [Security] axios library
- Dependencies
- Translations

## 3.1.1 – 2019-04-16
### Fixed
- Edge support
  [#1064](https://github.com/nextcloud/contacts/pull/1064)
- Cannot remove some properties
  [#1050](https://github.com/nextcloud/contacts/pull/1050)
- Avoid qrcode getting cropped
  [#1055](https://github.com/nextcloud/contacts/pull/1055)
- Add CLOUD property to fieldOrder, so it can be grouped in the UI
  [#1056](https://github.com/nextcloud/contacts/pull/1056)
- Add some padding between header and properties in contact details
  [#1052](https://github.com/nextcloud/contacts/pull/1052)
- Fix some photos not being shown in the list
  [6a9025c](https://github.com/nextcloud/contacts/commit/6a9025c57dfd738d3d25651853bc38e15db90f1c)

### Updated
- Dependencies
- Translations

## 3.1.0 – 2019-04-08
### Added
- Add undo deletion
  [#1025](https://github.com/nextcloud/contacts/pull/1025)
- Allow to pick avatar from files + use modal
  [#1024](https://github.com/nextcloud/contacts/pull/1024)
- Add ABLABEL and ITEMX.property support
  [#991](https://github.com/nextcloud/contacts/pull/991)
- Use displayname as file name when downloading a contact
  [#1022](https://github.com/nextcloud/contacts/pull/1022)
- Show vCard as qrcode
  [#1017](https://github.com/nextcloud/contacts/pull/1017)
- Use virtual scroller for big contacts list display performances
  [#1018](https://github.com/nextcloud/contacts/pull/1018)
- Add sorting by last modified
  [#992](https://github.com/nextcloud/contacts/pull/992)


### Fixed
- Automatic repair of duplicate types
  [#1042](https://github.com/nextcloud/contacts/issues/1042)
- Remove some properties if empty
  [#1035](https://github.com/nextcloud/contacts/issues/1035)
- Use dav hasPhoto to properly load photos into the list
  [#1021](https://github.com/nextcloud/contacts/issues/1021)
- Unable to create new user since v3.0.5 on some browsers, oca_contacts
  [#1010](https://github.com/nextcloud/contacts/issues/1010)
- Cannot see Date of Death to existing contacts
  [#988](https://github.com/nextcloud/contacts/issues/988)
- Properly update store contact on first push
  [#987](https://github.com/nextcloud/contacts/issues/987)

### Updated
- Dependencies
- Translations

## 3.0.5 – 2019-03-11
### Fixed
- Initial contact loading:
  [#984](https://github.com/nextcloud/contacts/issues/984)


## 3.0.4 – 2019-03-10
### Added
- Add REV on update
  [#969](https://github.com/nextcloud/contacts/pull/969)
- Better handle parsing errors
  [#971](https://github.com/nextcloud/contacts/pull/971)
- Add not grouped entry
  [#970](https://github.com/nextcloud/contacts/pull/970)

### Fixed
- Spelling mistake in error message
  [#945](https://github.com/nextcloud/contacts/issues/945)
- Automatically redirect if modRewriteWorking is supported
  [#899](https://github.com/nextcloud/contacts/issues/899)
- Force display date for bday, anniversary and deathdate
  [9057462c34977103a2c68124ee8f50a2d1a967ce](https://github.com/nextcloud/contacts/commit/9057462c34977103a2c68124ee8f50a2d1a967ce)
- Fix FN repair step for ORG
  [bdd93836aa0613e5f9c61f2496505e4c45f1febc](https://github.com/nextcloud/contacts/commit/bdd93836aa0613e5f9c61f2496505e4c45f1febc)
- Saving reverts changes which happened during the save
  [#923](https://github.com/nextcloud/contacts/issues/923)
  [#968](https://github.com/nextcloud/contacts/issues/968)
- White icons fix for preview
  [91dd5c38df05ebb9247df4611703beffa6d08b0e](https://github.com/nextcloud/contacts/commit/91dd5c38df05ebb9247df4611703beffa6d08b0e) 
- Validate on app initialisation
  [#973](https://github.com/nextcloud/contacts/issues/973)
- Fix gender select + auto repair
  [#972](https://github.com/nextcloud/contacts/issues/972)
- Fix conflict mode
  [#981](https://github.com/nextcloud/contacts/issues/981)

### Updated
- Dependencies
- Translations


## 3.0.3 – 2019-02-01
### Added
- Auto fill the display name from the detailed name field if empty, invalid or unchanged from New Contact
  [#898](https://github.com/nextcloud/contacts/issues/898)

### Fixed
- Address book url copy to clipboard
  [#878](https://github.com/nextcloud/contacts/issues/878)
- Conflicting issue when multiple changes to a contact
  [#879](https://github.com/nextcloud/contacts/issues/879)
- Auto fix the display name if invalid
  [#880](https://github.com/nextcloud/contacts/issues/880)
- Fix the display name Format and sorting display
  [#880](https://github.com/nextcloud/contacts/issues/880)
- Removed unnecessary request on contact creation

### Updated
- Dependencies
- Translations


## 3.0.2 – 2019-01-21
### Changed
- Search case is now insensitive

### Fixed
- VCard group download on firefox
- Data propagation across different set of fields
- Dates off by one month
- Property deletion
- Addressbook deletion
- Federated cloud fields
- Contactsmenu
- Datepicker design

### Updated
- Dependencies
- Translations


## 3.0.1 – 2018-12-24
### Changed
- Better error handling

### Fixed
- Deathdate
- Datepicker
- Add new property

### Updated
- Dependencies
- Translations


## 3.0.0 – 2018-12-15
### Added
- Use nextcloud locale settings to display dates
- Faster loading and overall reactivity
- Better import process
- Show default set of fields on new contacts
- Design enhancement
- You can now delete contacts from the list
- You can now download groups as vcf file
- New contacts are not synced to the server until edited. No more empty contacts on your addressbooks!
- Better compatibility with other vcard editors

### Fixed
- #122, BDAY format in VCARD, missing "-"
- #133, allow to enter and differentiate more than one mobile phone - number, e.g for business and private use
- #146, German Date Format
- #200, Empty field property options missing
- #270, FN field behaviour: first and last name
- #488, Removing default name for new contact and leaving it blank
- #253, Show fields for phone, email, address and groups by default for new contact
- #259, Show fields for phone, email, address and groups by default
- #293, Improve the sharing view of addressbooks
- #337, "undefined" group is created
- #361, Display Name is overwritten by First Name / Last Name changes.
- #372, sorting order to 'first name' or 'last name' leads to strange behavior when scrolling to contacts
- #379, "/" in a user group name doesn't work
- #394, optimize the shortening and alignment of field labels
- #433, vCard import broken: window.localStorage is null
- #468, SVG not encoded or rendered correctly
- #520, please clarify which formats AND versions are supported
- #545, Social Network types drop-down is missing "Mastodon"
- #547, Company contact entries don't display properly on load
- #585, Click on a non existing contact results in a endless spinner
- #592, Inconsistent use of username when sharing an address book
