/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wiki;

import com.sun.star.uno.XComponentContext;
import com.sun.star.wiki.EditPageParser;
import com.sun.star.wiki.Helper;
import com.sun.star.wiki.MainThreadDialogExecutor;
import com.sun.star.wiki.WikiCancelException;
import com.sun.star.wiki.WikiEditSettingDialog;
import com.sun.star.wiki.WikiPropDialog;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Map;
import javax.swing.text.html.HTMLEditorKit;

public class WikiArticle {
    private final XComponentContext m_xContext;
    private String m_sEditTime = "";
    private String m_sEditToken = "";
    private String m_sHTMLCode;
    private boolean m_bNoArticle = true;
    private String m_sWikiUser;
    private String m_sWikiPass;
    private final String m_sTitle;
    private final URI m_aMainURI;
    private boolean m_isLoggedIn = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WikiArticle(XComponentContext xContext, String sTitle, Map<String, String> wikiSettings, boolean bLogin, WikiPropDialog aPropDialog) throws URISyntaxException, IOException, WikiCancelException {
        this.m_xContext = xContext;
        String sMainUrl = wikiSettings.get("Url");
        this.m_sWikiUser = wikiSettings.get("Username");
        this.m_sWikiPass = wikiSettings.get("Password");
        this.m_sTitle = sTitle;
        this.m_aMainURI = new URI(sMainUrl);
        if (bLogin) {
            WikiEditSettingDialog aDialog = new WikiEditSettingDialog(this.m_xContext, "vnd.sun.star.script:WikiEditor.EditSetting?location=application", wikiSettings, false);
            try {
                while (!this.Login()) {
                    if (aPropDialog != null) {
                        aPropDialog.SetThrobberActive(false);
                    }
                    if (!MainThreadDialogExecutor.Show(xContext, aDialog)) {
                        throw new WikiCancelException();
                    }
                    this.m_sWikiUser = wikiSettings.get("Username");
                    this.m_sWikiPass = wikiSettings.get("Password");
                    if (aPropDialog == null) continue;
                    aPropDialog.SetThrobberActive(true);
                    Thread.yield();
                }
            }
            finally {
                aDialog.DisposeDialog();
            }
        }
        this.InitArticleHTML();
    }

    public String GetMainURL() {
        return this.m_aMainURI.toString();
    }

    public String GetTitle() {
        return this.m_sTitle;
    }

    private String getArticleWiki() throws URISyntaxException, IOException, WikiCancelException {
        String sWikiCode = null;
        if (this.m_isLoggedIn) {
            URI aURI = new URI(this.m_aMainURI.toString() + "index.php?title=" + this.m_sTitle + "&action=edit");
            HttpURLConnection connGet = Helper.PrepareMethod("GET", aURI, this.m_xContext);
            connGet.connect();
            int nResultCode = connGet.getResponseCode();
            String sWebPage = null;
            if (nResultCode == 200) {
                sWebPage = Helper.ReadResponseBody(connGet);
            }
            if (sWebPage != null) {
                StringReader r = new StringReader(sWebPage);
                HTMLEditorKit.Parser parse = Helper.GetHTMLParser();
                EditPageParser callback = new EditPageParser();
                parse.parse(r, callback, true);
                this.m_sEditTime = callback.m_sEditTime;
                this.m_sEditToken = callback.m_sEditToken;
                int iPosStart = callback.m_nWikiArticleStart;
                int iPosEnd = callback.m_nWikiArticleEnd;
                if (iPosStart >= 0 && iPosEnd > 0) {
                    String sArticle = sWebPage.substring(iPosStart, iPosEnd);
                    iPosStart = sArticle.indexOf(62) + 1;
                    sWikiCode = sArticle.substring(iPosStart, sArticle.length());
                }
            }
        }
        return sWikiCode;
    }

    private void InitArticleHTML() throws URISyntaxException, IOException, WikiCancelException {
        if (this.m_isLoggedIn) {
            URI uri = new URI(this.m_aMainURI.toString() + "index.php?title=" + this.m_sTitle);
            HttpURLConnection connGet = Helper.PrepareMethod("GET", uri, this.m_xContext);
            connGet.connect();
            int nResultCode = connGet.getResponseCode();
            String sWebPage = null;
            if (nResultCode == 200) {
                sWebPage = Helper.ReadResponseBody(connGet);
            }
            if (sWebPage != null) {
                StringReader r = new StringReader(sWebPage);
                HTMLEditorKit.Parser parse = Helper.GetHTMLParser();
                EditPageParser callback = new EditPageParser();
                parse.parse(r, callback, true);
                int iPosStart = callback.m_nHTMLArticleStart;
                int iPosEnd = callback.m_nHTMLArticleEnd;
                int nPosNoArt = callback.m_nNoArticleInd;
                if (iPosStart >= 0 && iPosEnd > 0) {
                    this.m_sHTMLCode = sWebPage.substring(iPosStart, iPosEnd);
                    this.m_bNoArticle = nPosNoArt >= 0 && nPosNoArt >= iPosStart && nPosNoArt <= iPosEnd;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setArticle(String sWikiCode, String sWikiComment, boolean bMinorEdit) throws URISyntaxException, IOException, WikiCancelException {
        boolean bResult = false;
        if (this.m_isLoggedIn && sWikiCode != null && sWikiComment != null) {
            this.getArticleWiki();
            URI uri = new URI(this.m_aMainURI.toString() + "index.php?title=" + this.m_sTitle + "&action=submit");
            HttpURLConnection connPost = Helper.PrepareMethod("POST", uri, this.m_xContext);
            connPost.setDoInput(true);
            connPost.setDoOutput(true);
            connPost.connect();
            try (OutputStreamWriter post = new OutputStreamWriter(connPost.getOutputStream(), "UTF-8");){
                post.write("wpTextbox1=");
                post.write(URLEncoder.encode(sWikiCode, "UTF-8"));
                post.write("&wpSummary=");
                post.write(URLEncoder.encode(sWikiComment, "UTF-8"));
                post.write("&wpSection=");
                post.write("&wpEdittime=");
                post.write(URLEncoder.encode(this.m_sEditTime, "UTF-8"));
                post.write("&wpSave=Save%20page");
                post.write("&wpEditToken=");
                post.write(URLEncoder.encode(this.m_sEditToken, "UTF-8"));
                if (bMinorEdit) {
                    post.write("&wpMinoredit=1");
                }
                post.flush();
            }
            int nResultCode = connPost.getResponseCode();
            if (nResultCode < 400) {
                bResult = true;
            }
            String aResult = Helper.ReadResponseBody(connPost);
            System.out.print("nSubmitCode = " + nResultCode + "\n===\n" + aResult);
        }
        return bResult;
    }

    private boolean Login() throws URISyntaxException, IOException, WikiCancelException {
        this.m_isLoggedIn = Helper.Login(this.m_aMainURI, this.m_sWikiUser, this.m_sWikiPass, this.m_xContext);
        return this.m_isLoggedIn;
    }

    protected boolean NotExist() {
        boolean bResult = true;
        if (this.m_sHTMLCode != null) {
            bResult = this.m_bNoArticle;
        }
        return bResult;
    }
}

