/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.classification.utilities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class CollectionUtility {
    public static <K, V extends Comparable<V>> Map<K, V> sortMapByValue(Map<K, V> input, final boolean desc) {
        LinkedHashMap<K, V> output = new LinkedHashMap<K, V>(input.size());
        ArrayList<Map.Entry<K, V>> entryList = new ArrayList<Map.Entry<K, V>>(input.entrySet());
        Collections.sort(entryList, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                if (desc) {
                    return ((Comparable)o2.getValue()).compareTo(o1.getValue());
                }
                return ((Comparable)o1.getValue()).compareTo(o2.getValue());
            }
        });
        for (Map.Entry<K, V> entry : entryList) {
            output.put(entry.getKey(), entry.getValue());
        }
        return output;
    }

    public static <K, V extends Comparable<V>> Map<K, V> sortMapByValue(Map<K, V> input) {
        return CollectionUtility.sortMapByValue(input, true);
    }

    public static String max(Map<String, Double> scoreMap) {
        double max = Double.NEGATIVE_INFINITY;
        String best = null;
        for (Map.Entry<String, Double> entry : scoreMap.entrySet()) {
            Double score = entry.getValue();
            if (!(score > max)) continue;
            max = score;
            best = entry.getKey();
        }
        return best;
    }

    public static String[][] spiltArray(String[] src, double rate) {
        String[][] output;
        assert (0.0 <= rate && rate <= 1.0);
        output = new String[][]{new String[(int)((double)src.length * rate)], new String[src.length - output[0].length]};
        System.arraycopy(src, 0, output[0], 0, output[0].length);
        System.arraycopy(src, output[0].length, output[1], 0, output[1].length);
        return output;
    }

    public static Map<String, String[]> splitMap(Map<String, String[]> src, double rate) {
        assert (0.0 <= rate && rate <= 1.0);
        TreeMap<String, String[]> output = new TreeMap<String, String[]>();
        for (Map.Entry<String, String[]> entry : src.entrySet()) {
            String[][] array = CollectionUtility.spiltArray(entry.getValue(), rate);
            output.put(entry.getKey(), array[0]);
            entry.setValue(array[1]);
        }
        return output;
    }
}

