/****************************************************************************
** Shared Class code from reading file 'KDbSelectStatementOptions.shared.h'
**
** Created
**      by: The Shared Data Compiler version 0.3
**
** WARNING! All changes made in this file will be lost!
*****************************************************************************/

/* This file is part of the KDE project
   Copyright (C) 2003-2017 Jarosław Staniek <staniek@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KDB_KDBSELECTSTATEMENTOPTIONS_H
#define KDB_KDBSELECTSTATEMENTOPTIONS_H

#include "kdb_export.h"
#include <QSharedData>

class KDbConnection;
class KDbQuerySchema;
class KDbTableSchema;
class KDbEscapedString;

//! Options used in KDbNativeStatementBuilder::generateSelectStatement()
/*! @note objects of this class are implicitly shared, what means they have value semantics
          by offering copy-on-write behaviour to maximize resource usage and minimize copying.
          Only a pointer to the data is passed around. See <a href="https://doc.qt.io/qt-5/qshareddatapointer.html#details">Qt documentation</a>.
 */
//! @note This class has been generated using the following SDC class options: operator==, implicit
class KDB_EXPORT KDbSelectStatementOptions
{
public:

    //! @internal data class used to implement implicitly shared class KDbSelectStatementOptions.
    //! Provides thread-safe reference counting.
    class Data : public QSharedData
    {
    public:
        Data()
        : alsoRetrieveRecordId(false)
        , addVisibleLookupColumns(true)
        {
        }

        Data(const Data &other)
         : QSharedData(other)
         , alsoRetrieveRecordId(other.alsoRetrieveRecordId)
         , addVisibleLookupColumns(other.addVisibleLookupColumns)
        {
        }

        virtual ~Data() {}

        //! Clones the object with all attributes; the copy isn't shared with the original.
        virtual Data* clone() const { return new Data(*this); }

        bool operator==(const Data &other) const {
            return alsoRetrieveRecordId == other.alsoRetrieveRecordId
                   && addVisibleLookupColumns == other.addVisibleLookupColumns;
        }

        bool alsoRetrieveRecordId; //!< @see KDbSelectStatementOptions::alsoRetrieveRecordId(), KDbSelectStatementOptions::setAlsoRetrieveRecordId()
        bool addVisibleLookupColumns; //!< @see KDbSelectStatementOptions::addVisibleLookupColumns(), KDbSelectStatementOptions::setAddVisibleLookupColumns()
    };

    KDbSelectStatementOptions()
     : d(new Data)
    {
    }

    KDbSelectStatementOptions(const KDbSelectStatementOptions &other)
     : d(other.d)
    {
    }

    virtual ~KDbSelectStatementOptions();

    /*!
    @return @c true if record IDs should be also retrieved. @c false by default.
    */
    bool alsoRetrieveRecordId() const {
        return d->alsoRetrieveRecordId;
    }

    /*!
    Specifies whether record IDs should be also retrieved.
    */
    void setAlsoRetrieveRecordId(bool alsoRetrieveRecordId) {
        d->alsoRetrieveRecordId = alsoRetrieveRecordId;
    }

    /*!
    @return @c true if relations (LEFT OUTER JOIN) for visible lookup columns should be added.
    @c false is used only when user-visible statement is generated e.g. the one used in Kexi's
    Query Designer. @c true by default.
    */
    bool addVisibleLookupColumns() const {
        return d->addVisibleLookupColumns;
    }

    /*!
    Specifies whether if relations (LEFT OUTER JOIN) for visible lookup columns should be added.
    */
    void setAddVisibleLookupColumns(bool addVisibleLookupColumns) {
        d->addVisibleLookupColumns = addVisibleLookupColumns;
    }

    //! @return true if this object is equal to @a other; otherwise returns false.
    bool operator==(const KDbSelectStatementOptions &other) const {
        return *d == *other.d;
    }

    //! @return true if this object is not equal to @a other; otherwise returns false.
    bool operator!=(const KDbSelectStatementOptions &other) const {
        return !operator==(other);
    }



protected:
    QSharedDataPointer<Data> d;
};

#endif
