/*******************************************************************************
* Copyright 2010-2022 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

/*
!  Content:
!  mkl_comatadd - out-of-place transposition routine,
!  Example Program Text ( C Interface )
!******************************************************************************/
#include <mkl_trans.h>
#include "common_func.h"

int main(void)
{ 
  size_t n=4, m=3; /* rows, cols of source matrix */
  MKL_Complex8 alpha;
  MKL_Complex8 beta;
  MKL_Complex8 a[]={
    { 1.f,  2.f},  { 3.f,  4.f}, { 5.f,  6.f},
    { 7.f,  8.f},  { 9.f, 10.f}, {11.f, 12.f},
    {13.f, 14.f},  {15.f, 16.f}, {17.f, 18.f},
    {25.f, 26.f},  {27.f, 28.f}, {29.f, 30.f}
  }; /* source matrix */
  MKL_Complex8 b[]={
    { 1.1f,  2.1f}, { 3.2f,  4.2f}, { 5.3f,  6.3f},
    { 7.1f,  8.1f}, { 9.2f, 10.2f}, {11.3f, 12.3f},
    {13.1f, 14.1f}, {15.2f, 16.2f}, {17.3f, 18.3f},
    {25.1f, 26.1f}, {27.2f, 28.2f}, {29.3f, 30.3f}
  }; /* source matrix   */
  MKL_Complex8 dst[9];/* destination matrix */
  alpha.real = 1.f;
  alpha.imag = 0.f;
  beta.real = 1.f;
  beta.imag = 0.f;

  printf("\nExample of using mkl_comatadd transposition\n");
  printf("INPUT DATA:\nSource matrix A:\n");
  print_matrix(n, m, 'c', a);

  printf("Source matrix B:\n");
  print_matrix(n, m, 'c', b);

  /* 
  **  Addition of transposed submatrix(3,3) a and unchanged submatrix(3,3) b 
  */
  mkl_comatadd('R'    /* row-major ordering */, 
               'T'    /* A will be transposed */,
               'N'    /* no changes to B */, 
                3     /* rows */, 
                3     /* cols */, 
                alpha /* alpha */, 
                a     /* source matrix */, 
                3     /* lda */, 
                beta  /* beta */, 
                b     /* source matrix */, 
                3     /* ldb */, 
                dst   /* destination matrix */, 
                3     /* ldc */); 
  /*
  **  New matrix: c =  { 
  **    2.1, 4.1,     10.2, 12.2,    18.3, 20.3,
  **    10.1, 12.1,    18.2, 20.2,    26.3, 28.3,
  **    18.1, 20.1,    26.2, 28.2,    34.3, 36.3
  **  }
  */
  printf("OUTPUT DATA:\nDestination matrix - addition of transposed submatrix(3,3) A and submatrix B:\n");  
  print_matrix(3, 3, 'c', dst);
  /*
  **  Addition of transposed submatrix(3,3) a and conjugate transposed submatrix(3,3) b 
  */
  mkl_comatadd('R'    /* row-major ordering */, 
               'T'    /* A will be transposed */,
               'C'    /* B will be conjugate transposed */, 
                3     /* rows */, 
                3     /* cols */, 
                alpha /* alpha */, 
                a     /* source matrix */, 
                3     /* lda */, 
                beta  /* beta */, 
                b     /* source matrix */, 
                3     /* ldb */, 
                dst   /* destination matrix */, 
                3     /* ldc */);  
  /*  New matrix: c = {
  **    2.1, -0.1,  14.1, -0.1,  26.1, -0.1,
  **    6.2, -0.2,  18.2, -0.2,  30.2, -0.2,
  **    10.3, -0.3, 22.3, -0.3,  34.3, -0.3   
  **  }
  */
  printf("Destination matrix - Addition of transposed submatrix(3,3) A and conjugate transposed submatrix(3,3) B:\n");  
  print_matrix(3, 3, 'c', dst);
  
  return 0;
}
