complete -c delta -l blame-code-style -x -d "Style string for the code section of a git blame line"
complete -c delta -l blame-format -x -d "Format string for git blame commit metadata"
complete -c delta -l blame-palette -x -d "Background colors used for git blame lines"
complete -c delta -l blame-separator-format -x -d "Separator between the blame format and the code section of a git blame line"
complete -c delta -l blame-separator-style -x -d "Style string for the blame-separator-format"
complete -c delta -l blame-timestamp-format -x -d "Format of git blame timestamp in raw git output received by delta"
complete -c delta -l color-only -d "Do not alter the input structurally in any way"
complete -c delta -l commit-decoration-style -x -d "Style string for the commit hash decoration"
complete -c delta -l commit-regex -x -d "Regular expression used to identify the commit line when parsing git output"
complete -c delta -l commit-style -x -d "Style string for the commit hash line"
complete -c delta -l dark -d "Use default colors appropriate for a dark terminal background"
complete -c delta -l default-language -x -d "Default language used for syntax highlighting"
complete -c delta -l diff-highlight -d "Emulate diff-highlight"
complete -c delta -l diff-so-fancy -d "Emulate diff-so-fancy"
complete -c delta -l diff-stat-align-width -x -d "Width allocated for file paths in a diff stat section"
complete -c delta -l features -x -d "Names of delta features to activate"
complete -c delta -l file-added-label -x -d "Text to display before an added file path"
complete -c delta -l file-copied-label -x -d "Text to display before a copied file path"
complete -c delta -l file-decoration-style -x -d "Style string for the file decoration"
complete -c delta -l file-modified-label -x -d "Text to display before a modified file path"
complete -c delta -l file-removed-label -x -d "Text to display before a removed file path"
complete -c delta -l file-renamed-label -x -d "Text to display before a renamed file path"
complete -c delta -l file-style -x -d "Style string for the file section"
complete -c delta -l file-transformation -x -d "Sed-style command transforming file paths for display"
complete -c delta -l grep-context-line-style -x -d "Style string for non-matching lines of grep output"
complete -c delta -l grep-file-style -x -d "Style string for file paths in grep output"
complete -c delta -l grep-line-number-style -x -d "Style string for line numbers in grep output"
complete -c delta -l grep-match-line-style -x -d "Style string for matching lines of grep output"
complete -c delta -l grep-match-word-style -x -d "Style string for the matching substrings within a matching line of grep output"
complete -c delta -l grep-separator-symbol -x -d "Separator symbol printed after the file path and line number in grep output"
complete -c delta -l hunk-header-decoration-style -x -d "Style string for the hunk-header decoration"
complete -c delta -l hunk-header-file-style -x -d "Style string for the file path part of the hunk-header"
complete -c delta -l hunk-header-line-number-style -x -d "Style string for the line number part of the hunk-header"
complete -c delta -l hunk-header-style -x -d "Style string for the hunk-header"
complete -c delta -l hunk-label -x -d "Text to display before a hunk header"
complete -c delta -l hyperlinks -d "Render commit hashes, file names, and line numbers as hyperlinks"
complete -c delta -l hyperlinks-commit-link-format -x -d "Format string for commit hyperlinks"
complete -c delta -l hyperlinks-file-link-format -x -d "Format string for file hyperlinks"
complete -c delta -l inline-hint-style -x -d "Style string for short inline hint text"
complete -c delta -l inspect-raw-lines -xa "true false" -d "Kill-switch for --color-moved support"
complete -c delta -l keep-plus-minus-markers -d "Prefix added/removed lines with a +/- character"
complete -c delta -l light -d "Use default colors appropriate for a light terminal background"
complete -c delta -l line-buffer-size -x -d "Size of internal line buffer"
complete -c delta -l line-fill-method -xa "ansi spaces" -d "Line-fill method in side-by-side mode"
complete -c delta -l line-numbers -s n -d "Display line numbers next to the diff"
complete -c delta -l line-numbers-left-format -x -d "Format string for the left column of line numbers"
complete -c delta -l line-numbers-left-style -x -d "Style string for the left column of line numbers"
complete -c delta -l line-numbers-minus-style -x -d "Style string for line numbers in the old (minus) version of the file"
complete -c delta -l line-numbers-plus-style -x -d "Style string for line numbers in the new (plus) version of the file"
complete -c delta -l line-numbers-right-format -x -d "Format string for the right column of line numbers"
complete -c delta -l line-numbers-right-style -x -d "Style string for the right column of line numbers"
complete -c delta -l line-numbers-zero-style -x -d "Style string for line numbers in unchanged (zero) lines"
complete -c delta -l list-languages -d "List supported languages and associated file extensions"
complete -c delta -l list-syntax-themes -d "List available syntax-highlighting color themes"
complete -c delta -l map-styles -x -d "Map styles encountered in raw input to desired output styles"
complete -c delta -l max-line-distance -x -d "Maximum line pair distance parameter in within-line diff algorithm"
complete -c delta -l max-line-length -x -d "Truncate lines longer than this"
complete -c delta -l merge-conflict-begin-symbol -x -d "String marking the beginning of a merge conflict region"
complete -c delta -l merge-conflict-end-symbol -x -d "String marking the end of a merge conflict region"
complete -c delta -l merge-conflict-ours-diff-header-decoration-style -x -d "Style string for the decoration of the header above the 'ours' merge conflict diff"
complete -c delta -l merge-conflict-ours-diff-header-style -x -d "Style string for the header above the 'ours' branch merge conflict diff"
complete -c delta -l merge-conflict-theirs-diff-header-decoration-style -x -d "Style string for the decoration of the header above the 'theirs' merge conflict diff"
complete -c delta -l merge-conflict-theirs-diff-header-style -x -d "Style string for the header above the 'theirs' branch merge conflict diff"
complete -c delta -l minus-empty-line-marker-style -x -d "Style string for removed empty line marker"
complete -c delta -l minus-emph-style -x -d "Style string for emphasized sections of removed lines"
complete -c delta -l minus-non-emph-style -x -d "Style string for non-emphasized sections of removed lines that have an emphasized section"
complete -c delta -l minus-style -x -d "Style string for removed lines"
complete -c delta -l navigate -d "Activate diff navigation"
complete -c delta -l navigate-regex -x -d "Regular expression defining navigation stop points"
complete -c delta -l no-gitconfig -d "Do not read any settings from git config"
complete -c delta -l pager -x -d "Which pager to use"
complete -c delta -l paging -xa "auto always never" -d "Whether to use a pager when displaying output"
complete -c delta -l parse-ansi -d "Display ANSI color escape sequences in human-readable form"
complete -c delta -l plus-emph-style -x -d "Style string for emphasized sections of added lines"
complete -c delta -l plus-empty-line-marker-style -x -d "Style string for added empty line marker"
complete -c delta -l plus-non-emph-style -x -d "Style string for non-emphasized sections of added lines that have an emphasized section"
complete -c delta -l plus-style -x -d "Style string for added lines"
complete -c delta -l raw -d "Do not alter the input in any way"
complete -c delta -l relative-paths -d "Output all file paths relative to the current directory"
complete -c delta -l right-arrow -x -d "Text to display with a changed file path"
complete -c delta -l show-colors -d "Show available named colors"
complete -c delta -l show-config -d "Display the active values for all Delta options"
complete -c delta -l show-syntax-themes -d "Show example diff for available syntax-highlighting themes"
complete -c delta -l show-themes -d "Show example diff for available delta themes"
complete -c delta -l side-by-side -s s -d "Display diffs in side-by-side layout"
complete -c delta -l syntax-theme -xa "(delta --list-syntax-themes | cut -f 2)" -d "The syntax-highlighting theme to use"
complete -c delta -l tabs -x -d "The number of spaces to replace tab characters with"
complete -c delta -l true-color -xa "auto always never" -d "Whether to emit 24-bit RGB color codes"
complete -c delta -l whitespace-error-style -x -d "Style string for whitespace errors"
complete -c delta -l width -s w -x -d "The width of underline/overline decorations"
complete -c delta -l word-diff-regex -x -d "Regular expression defining a 'word' in within-line diff algorithm"
complete -c delta -l wrap-left-symbol -x -d "End-of-line wrapped content symbol"
complete -c delta -l wrap-max-lines -x -d "How often a line should be wrapped if it does not fit"
complete -c delta -l wrap-right-percent -x -d "Threshold for right-aligning wrapped content"
complete -c delta -l wrap-right-prefix-symbol -x -d "Pre-wrapped content symbol"
complete -c delta -l wrap-right-symbol -x -d "End-of-line wrapped content symbol"
complete -c delta -l zero-style -x -d "Style string for unchanged lines"
complete -c delta -l help -s h -d "Print help information"
complete -c delta -l version -s V -d "Print version information"
