/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.image;

import java.io.File;
import java.io.FileFilter;
import java.util.List;
import org.fibs.geotag.Settings;
import org.fibs.geotag.image.FileTypes;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class ImageFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private static final I18n i18n = I18nFactory.getI18n(ImageFileFilter.class);
    private static final ImageFileFilter ALL_IMAGES_FILTER = new ImageFileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            FileTypes fileType = FileTypes.fileType(file);
            switch (fileType) {
                case UNKOWN: {
                    return false;
                }
                case JPEG: {
                    return true;
                }
                case RAW_READ_ONLY: {
                    return true;
                }
                case RAW_READ_WRITE: {
                    return true;
                }
                case TIFF: {
                    return true;
                }
                case XMP: {
                    return false;
                }
                case CUSTOM_FILE_WITH_XMP: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public String getDescription() {
            return i18n.tr("Image files");
        }

        @Override
        public Type getType() {
            return Type.ALL_IMAGES;
        }
    };
    private static final ImageFileFilter JPEG_IMAGES_FILTER = new ImageFileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return FileTypes.JPEG == FileTypes.fileType(file);
        }

        @Override
        public String getDescription() {
            return i18n.tr("JPEG files");
        }

        @Override
        public Type getType() {
            return Type.JPEG;
        }
    };
    private static final ImageFileFilter RAW_IMAGES_FILTER = new ImageFileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return FileTypes.RAW_READ_ONLY == FileTypes.fileType(file) || FileTypes.RAW_READ_WRITE == FileTypes.fileType(file);
        }

        @Override
        public String getDescription() {
            return i18n.tr("RAW files");
        }

        @Override
        public Type getType() {
            return Type.RAW;
        }
    };
    private static final ImageFileFilter TIFF_IMAGES_FILTER = new ImageFileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return FileTypes.TIFF == FileTypes.fileType(file);
        }

        @Override
        public String getDescription() {
            return i18n.tr("TIFF files");
        }

        @Override
        public Type getType() {
            return Type.TIFF;
        }
    };
    private static final ImageFileFilter CUSTOM_FILE_WITH_XMP_FILTER = new ImageFileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return FileTypes.CUSTOM_FILE_WITH_XMP == FileTypes.fileType(file);
        }

        @Override
        public String getDescription() {
            StringBuilder description = new StringBuilder();
            List<String> supportedFileTypes = FileTypes.getFileTypesSupportedByXmp();
            int index = 0;
            while (index < supportedFileTypes.size()) {
                String fileType = supportedFileTypes.get(index);
                if (index > 0) {
                    description.append(',');
                }
                description.append(fileType.toUpperCase());
                ++index;
            }
            description.append(' ');
            description.append(i18n.tr("files with XMP sidecar"));
            return description.toString();
        }

        @Override
        public Type getType() {
            return Type.CUSTOM_FILE_WITH_XMP;
        }
    };

    public abstract Type getType();

    public static ImageFileFilter getFilter(Type type) {
        switch (type) {
            case ALL_IMAGES: {
                return ALL_IMAGES_FILTER;
            }
            case JPEG: {
                return JPEG_IMAGES_FILTER;
            }
            case RAW: {
                return RAW_IMAGES_FILTER;
            }
            case TIFF: {
                return TIFF_IMAGES_FILTER;
            }
            case CUSTOM_FILE_WITH_XMP: {
                return CUSTOM_FILE_WITH_XMP_FILTER;
            }
        }
        return ALL_IMAGES_FILTER;
    }

    public static void storeLastFilterUsed(ImageFileFilter filter) {
        Settings.put(Settings.SETTING.LAST_FILE_FILTER_SELECTED, filter.getType().toString());
        Settings.flush();
    }

    public static ImageFileFilter getLastFilterUsed() {
        String filterId = Settings.get(Settings.SETTING.LAST_FILE_FILTER_SELECTED, Type.ALL_IMAGES.toString());
        try {
            Type type = Type.valueOf(filterId);
            return ImageFileFilter.getFilter(type);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ALL_IMAGES_FILTER;
        }
    }

    public static enum Type {
        ALL_IMAGES,
        JPEG,
        RAW,
        TIFF,
        CUSTOM_FILE_WITH_XMP;

    }
}

