/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.tasks;

import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.data.UpdateCityName;
import org.fibs.geotag.data.UpdateCountryName;
import org.fibs.geotag.data.UpdateLocationName;
import org.fibs.geotag.data.UpdateProvinceName;
import org.fibs.geotag.data.UpdateUserComment;
import org.fibs.geotag.table.ImagesTableColumns;
import org.fibs.geotag.tasks.UndoableBackgroundTask;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ManualEditTask
extends UndoableBackgroundTask<ImageInfo> {
    private static final I18n i18n = I18nFactory.getI18n(ManualEditTask.class);
    private ImageInfo imageInfo;
    private ImagesTableColumns.COLUMN column;
    private String newValue;

    public ManualEditTask(String name, ImageInfo imageInfo, ImagesTableColumns.COLUMN column, String newValue) {
        super(i18n.tr("Manual edit"), name);
        this.imageInfo = imageInfo;
        this.column = column;
        this.newValue = newValue;
    }

    @Override
    public int getCurrentProgress() {
        return 1;
    }

    @Override
    public int getMaxProgress() {
        return 1;
    }

    @Override
    public int getMinProgress() {
        return 1;
    }

    @Override
    protected String doInBackground() throws Exception {
        if (this.imageInfo != null) {
            if (this.newValue.length() == 0) {
                this.newValue = null;
            }
            switch (this.column) {
                case IMAGE_NAME: 
                case GPS_DATE: 
                case TIME_OFFSET: 
                case CAMERA_DATE: 
                case LATITUDE: 
                case LONGITUDE: 
                case ALTITUDE: 
                case DIRECTION: {
                    break;
                }
                case LOCATION_NAME: {
                    new UpdateLocationName(this.imageInfo, this.newValue, ImageInfo.DATA_SOURCE.MANUAL);
                    break;
                }
                case CITY_NAME: {
                    new UpdateCityName(this.imageInfo, this.newValue, ImageInfo.DATA_SOURCE.MANUAL);
                    break;
                }
                case PROVINCE_NAME: {
                    new UpdateProvinceName(this.imageInfo, this.newValue, ImageInfo.DATA_SOURCE.MANUAL);
                    break;
                }
                case COUNTRY_NAME: {
                    new UpdateCountryName(this.imageInfo, this.newValue, ImageInfo.DATA_SOURCE.MANUAL);
                    break;
                }
                case USER_COMMENT: {
                    new UpdateUserComment(this.imageInfo, this.newValue, ImageInfo.DATA_SOURCE.MANUAL);
                    break;
                }
            }
            this.publish(this.imageInfo);
        }
        return String.format(i18n.tr("%1$s edited."), this.getName());
    }
}

