/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.libraries;

import cc.arduino.contributions.VersionComparator;
import cc.arduino.contributions.libraries.ContributedLibrary;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import processing.app.packages.UserLibraryFolder;

public class ContributedLibraryReleases {
    private List<ContributedLibrary> releases = new LinkedList<ContributedLibrary>();
    private List<String> versions = new LinkedList<String>();
    private ContributedLibrary latest = null;
    private ContributedLibrary selected = null;

    public ContributedLibraryReleases(ContributedLibrary library) {
        this.add(library);
    }

    public ContributedLibraryReleases(List<ContributedLibrary> libraries) {
        libraries.forEach(this::add);
    }

    public List<ContributedLibrary> getReleases() {
        return this.releases;
    }

    public boolean shouldContain(ContributedLibrary lib) {
        if (this.latest == null) {
            return true;
        }
        return lib.getName().equals(this.latest.getName());
    }

    public void add(ContributedLibrary library) {
        if (this.latest == null) {
            this.latest = library;
        }
        this.releases.add(library);
        String version = library.getParsedVersion();
        if (version != null) {
            this.versions.add(version);
        }
        if (VersionComparator.greaterThan(version, this.latest.getParsedVersion())) {
            this.latest = library;
        }
        this.selected = this.latest;
    }

    public Optional<ContributedLibrary> getInstalled() {
        return this.releases.stream().filter(ContributedLibrary::isLibraryInstalled).reduce((x, y) -> {
            UserLibraryFolder.Location ly;
            UserLibraryFolder.Location lx = x.getInstalledLibrary().get().getLocation();
            if (lx == (ly = y.getInstalledLibrary().get().getLocation())) {
                return VersionComparator.max(x, y);
            }
            return lx == UserLibraryFolder.Location.SKETCHBOOK ? x : y;
        });
    }

    public ContributedLibrary getLatest() {
        return this.latest;
    }

    public ContributedLibrary getSelected() {
        return this.selected;
    }

    public void select(ContributedLibrary lib) {
        for (ContributedLibrary r : this.releases) {
            if (r != lib) continue;
            this.selected = r;
            return;
        }
    }
}

