"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Column = exports.Columns = exports.filterColumnsProps = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const sizes_1 = require("./sizes");
const mediaQueries_1 = require("../mediaQueries");
const util_1 = require("../util");
const filterColumnsProps = (props) => {
    return (0, util_1.filterProps)(props, ['query']);
};
exports.filterColumnsProps = filterColumnsProps;
const columnsStyle = ({ query = mediaQueries_1.QueryKeys.MOBILE }) => ({
    display: 'flex',
    marginLeft: `-${sizes_1.GUTTER}px`,
    [mediaQueries_1.media[query]]: { flexDirection: 'column' },
});
const Columns = (props) => (0, jsx_runtime_1.jsx)("div", Object.assign({ css: columnsStyle(props) }, (0, exports.filterColumnsProps)(props)));
exports.Columns = Columns;
const columnStyle = _ => ({
    display: 'block',
    flexBasis: '0',
    flexGrow: 1,
    flexShrink: 1,
    marginLeft: `${sizes_1.GUTTER}px`,
});
const Column = (props) => (0, jsx_runtime_1.jsx)("div", Object.assign({ css: columnStyle(props) }, props));
exports.Column = Column;
