"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Lead = exports.leadStyle = exports.Paragraph = exports.paragraphStyle = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const Text_1 = require("./Text");
const mediaQueries_1 = require("../mediaQueries");
const paragraphStyle = (theme, _a) => {
    var { block = true } = _a, props = __rest(_a, ["block"]);
    return (Object.assign(Object.assign({}, (0, Text_1.textStyle)(theme, Object.assign({ block }, props))), { marginBottom: '16px', marginTop: 0 }));
};
exports.paragraphStyle = paragraphStyle;
const Paragraph = (props) => ((0, jsx_runtime_1.jsx)("p", Object.assign({ css: (theme) => (0, exports.paragraphStyle)(theme, props) }, (0, Text_1.filterTextProps)(props))));
exports.Paragraph = Paragraph;
const leadStyle = (theme, _a) => {
    var { block = true, center = true, fontSize = theme.fontSizes.extraLarge } = _a, props = __rest(_a, ["block", "center", "fontSize"]);
    return (Object.assign(Object.assign({}, (0, Text_1.textStyle)(theme, Object.assign({ block, center, fontSize }, props))), { marginBottom: '56px', marginTop: 0, [mediaQueries_1.media[mediaQueries_1.QueryKeys.MOBILE]]: {
            fontSize: '1.125rem',
        } }));
};
exports.leadStyle = leadStyle;
const Lead = (props) => ((0, jsx_runtime_1.jsx)("p", Object.assign({ css: (theme) => (0, exports.leadStyle)(theme, props) }, (0, Text_1.filterTextProps)(props))));
exports.Lead = Lead;
