"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Link = exports.filterLinkProps = exports.linkStyle = exports.LinkVariant = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const Text_1 = require("./Text");
const motions_1 = require("../Identity/motions");
const util_1 = require("../util");
var LinkVariant;
(function (LinkVariant) {
    LinkVariant["PRIMARY"] = "primary";
    LinkVariant["SECONDARY"] = "secondary";
})(LinkVariant = exports.LinkVariant || (exports.LinkVariant = {}));
const linkStyle = (theme, _a) => {
    var { bold = true, fontSize = theme.fontSizes.extraSmall, textTransform = 'uppercase', variant = LinkVariant.SECONDARY, color = theme.general.color } = _a, props = __rest(_a, ["bold", "fontSize", "textTransform", "variant", "color"]);
    return Object.assign(Object.assign(Object.assign(Object.assign({}, (0, Text_1.textStyle)(theme, Object.assign({ bold, color, fontSize, textTransform }, props))), { color: color, cursor: 'pointer', textDecoration: 'none', '&:visited, &:link, &:active': {
            color: color,
        } }), (variant === LinkVariant.PRIMARY && {
        '&:hover, &:visited:hover, &:focus-visible': {
            color: theme.general.primaryColor,
        },
        fontSize: theme.fontSizes.base,
        fontWeight: 400,
        textTransform: 'none',
        textDecoration: 'underline',
        textUnderlineOffset: '2px',
    })), (variant === LinkVariant.SECONDARY && {
        transition: motions_1.defaultTransition,
        '&:hover': {
            filter: 'brightness(70%)',
        },
    }));
};
exports.linkStyle = linkStyle;
const filterLinkProps = (props) => (0, util_1.filterProps)((0, Text_1.filterTextProps)(props), []);
exports.filterLinkProps = filterLinkProps;
const Link = (_a) => {
    var { targetBlank } = _a, props = __rest(_a, ["targetBlank"]);
    return ((0, jsx_runtime_1.jsx)("a", Object.assign({ css: (theme) => (0, exports.linkStyle)(theme, props), target: targetBlank && '_blank', rel: "noopener noreferrer" }, (0, exports.filterLinkProps)(props), { children: props.children })));
};
exports.Link = Link;
