"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TrayHandler = void 0;
const electron_1 = require("electron");
const path = __importStar(require("path"));
const locale = __importStar(require("../locale"));
const EnvironmentUtil_1 = require("../runtime/EnvironmentUtil");
const lifecycle = __importStar(require("../runtime/lifecycle"));
const config_1 = require("../settings/config");
const WindowManager_1 = require("../window/WindowManager");
class TrayHandler {
    constructor() {
        this.lastUnreadCount = 0;
    }
    initTray(trayIcon = new electron_1.Tray(electron_1.nativeImage.createEmpty())) {
        const IMAGE_ROOT = path.join(electron_1.app.getAppPath(), config_1.config.electronDirectory, 'img');
        let trayPng = 'tray.png';
        let trayBadgePng = 'tray.badge.png';
        if (EnvironmentUtil_1.platform.IS_LINUX) {
            trayPng = `tray${EnvironmentUtil_1.linuxDesktop.isGnomeX11 ? '.gnome' : '@3x'}.png`;
            trayBadgePng = `tray.badge${EnvironmentUtil_1.linuxDesktop.isGnomeX11 ? '.gnome' : '@3x'}.png`;
        }
        const iconPaths = {
            badge: path.join(IMAGE_ROOT, 'taskbar.overlay.png'),
            tray: path.join(IMAGE_ROOT, 'tray-icon/tray', trayPng),
            trayWithBadge: path.join(IMAGE_ROOT, 'tray-icon/tray-with-badge', trayBadgePng),
        };
        this.icons = {
            badge: electron_1.nativeImage.createFromPath(iconPaths.badge),
            tray: electron_1.nativeImage.createFromPath(iconPaths.tray),
            trayWithBadge: electron_1.nativeImage.createFromPath(iconPaths.trayWithBadge),
        };
        this.trayIcon = trayIcon;
        this.trayIcon.setImage(this.icons.tray);
        this.buildTrayMenu();
    }
    showUnreadCount(win, count, ignoreFlash) {
        if (count !== this.lastUnreadCount) {
            this.updateIcons(win, count);
            if (!ignoreFlash) {
                this.flashApplicationWindow(win, count);
            }
            this.updateBadgeCount(count);
        }
    }
    buildTrayMenu() {
        var _a, _b, _c;
        const contextMenu = electron_1.Menu.buildFromTemplate([
            {
                click: () => WindowManager_1.WindowManager.showPrimaryWindow(),
                label: locale.getText('trayOpen'),
            },
            {
                click: () => lifecycle.quit(),
                label: locale.getText('trayQuit'),
            },
        ]);
        (_a = this.trayIcon) === null || _a === void 0 ? void 0 : _a.on('click', () => WindowManager_1.WindowManager.showPrimaryWindow());
        (_b = this.trayIcon) === null || _b === void 0 ? void 0 : _b.setContextMenu(contextMenu);
        (_c = this.trayIcon) === null || _c === void 0 ? void 0 : _c.setToolTip(config_1.config.name);
    }
    flashApplicationWindow(win, count) {
        if (win.isFocused() || !count) {
            win.flashFrame(false);
        }
        else if (count > this.lastUnreadCount) {
            win.flashFrame(true);
        }
    }
    updateBadgeCount(count) {
        if (typeof count !== 'undefined') {
            electron_1.app.setBadgeCount(count);
            this.lastUnreadCount = count;
        }
    }
    updateIcons(win, count) {
        var _a;
        if (this.icons) {
            const trayImage = count ? this.icons.trayWithBadge : this.icons.tray;
            (_a = this.trayIcon) === null || _a === void 0 ? void 0 : _a.setImage(trayImage);
            const overlayImage = count ? this.icons.badge : null;
            win.setOverlayIcon(overlayImage, locale.getText('unreadMessages'));
        }
    }
}
exports.TrayHandler = TrayHandler;
//# sourceMappingURL=TrayHandler.js.map