/* search-provider.c generated by valac 0.56.14, the Vala compiler
 * generated from search-provider.vala, do not modify */

/*
 *  pamac-vala
 *
 *  Copyright (C) 2014  Paolo Borelli <pborelli@gnome.org>
 *  Copyright (C) 2018-2022 Guillaume Benoit <guillaume@manjaro.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a get of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <pamac.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PAMAC_TYPE_SEARCH_PROVIDER (pamac_search_provider_get_type ())
#define PAMAC_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_SEARCH_PROVIDER, PamacSearchProvider))
#define PAMAC_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_SEARCH_PROVIDER, PamacSearchProviderClass))
#define PAMAC_IS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_SEARCH_PROVIDER))
#define PAMAC_IS_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_SEARCH_PROVIDER))
#define PAMAC_SEARCH_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_SEARCH_PROVIDER, PamacSearchProviderClass))

typedef struct _PamacSearchProvider PamacSearchProvider;
typedef struct _PamacSearchProviderClass PamacSearchProviderClass;
typedef struct _PamacSearchProviderPrivate PamacSearchProviderPrivate;
enum  {
	PAMAC_SEARCH_PROVIDER_0_PROPERTY,
	PAMAC_SEARCH_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* pamac_search_provider_properties[PAMAC_SEARCH_PROVIDER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _PamacSearchProviderGetInitialResultSetData PamacSearchProviderGetInitialResultSetData;
typedef struct _PamacSearchProviderGetSubsearchResultSetData PamacSearchProviderGetSubsearchResultSetData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
enum  {
	PAMAC_SEARCH_PROVIDER_SHOW_DETAILS_SIGNAL,
	PAMAC_SEARCH_PROVIDER_SEARCH_FULL_SIGNAL,
	PAMAC_SEARCH_PROVIDER_NUM_SIGNALS
};
static guint pamac_search_provider_signals[PAMAC_SEARCH_PROVIDER_NUM_SIGNALS] = {0};
typedef struct _PamacSearchProviderGetInitialResultSetReadyData PamacSearchProviderGetInitialResultSetReadyData;
typedef struct _PamacSearchProviderGetSubsearchResultSetReadyData PamacSearchProviderGetSubsearchResultSetReadyData;

struct _PamacSearchProvider {
	GObject parent_instance;
	PamacSearchProviderPrivate * priv;
};

struct _PamacSearchProviderClass {
	GObjectClass parent_class;
};

struct _PamacSearchProviderPrivate {
	PamacDatabase* database;
};

struct _PamacSearchProviderGetInitialResultSetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PamacSearchProvider* self;
	gchar** terms;
	gint terms_length1;
	gchar** result;
	gint result_length1;
	GPtrArray* normalized_terms;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
};

struct _PamacSearchProviderGetSubsearchResultSetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PamacSearchProvider* self;
	gchar** previous_results;
	gint previous_results_length1;
	gchar** terms;
	gint terms_length1;
	gchar** result;
	gint result_length1;
	GPtrArray* normalized_terms;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
};

struct _PamacSearchProviderGetInitialResultSetReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar** terms;
	gint terms_length1;
};

struct _PamacSearchProviderGetSubsearchResultSetReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar** previous_results;
	gint previous_results_length1;
	gchar** terms;
	gint terms_length1;
};

static gint PamacSearchProvider_private_offset;
static gpointer pamac_search_provider_parent_class = NULL;

VALA_EXTERN GType pamac_search_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacSearchProvider, g_object_unref)
VALA_EXTERN guint pamac_search_provider_register_object (void* object,
                                             GDBusConnection* connection,
                                             const gchar* path,
                                             GError** error);
VALA_EXTERN PamacSearchProvider* pamac_search_provider_new (PamacDatabase* database);
VALA_EXTERN PamacSearchProvider* pamac_search_provider_construct (GType object_type,
                                                      PamacDatabase* database);
static GPtrArray* pamac_search_provider_normalize_terms (PamacSearchProvider* self,
                                                  gchar** terms,
                                                  gint terms_length1);
static void _g_free0_ (gpointer var);
static gchar** pamac_search_provider_search_pkgs (PamacSearchProvider* self,
                                           GPtrArray* normalized_terms,
                                           gint* result_length1);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void pamac_search_provider_get_initial_result_set_data_free (gpointer _data);
VALA_EXTERN void pamac_search_provider_get_initial_result_set (PamacSearchProvider* self,
                                                   gchar** terms,
                                                   gint terms_length1,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
VALA_EXTERN gchar** pamac_search_provider_get_initial_result_set_finish (PamacSearchProvider* self,
                                                             GAsyncResult* _res_,
                                                             gint* result_length1,
                                                             GError** error);
static gboolean pamac_search_provider_get_initial_result_set_co (PamacSearchProviderGetInitialResultSetData* _data_);
static void pamac_search_provider_get_subsearch_result_set_data_free (gpointer _data);
VALA_EXTERN void pamac_search_provider_get_subsearch_result_set (PamacSearchProvider* self,
                                                     gchar** previous_results,
                                                     gint previous_results_length1,
                                                     gchar** terms,
                                                     gint terms_length1,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
VALA_EXTERN gchar** pamac_search_provider_get_subsearch_result_set_finish (PamacSearchProvider* self,
                                                               GAsyncResult* _res_,
                                                               gint* result_length1,
                                                               GError** error);
static gboolean pamac_search_provider_get_subsearch_result_set_co (PamacSearchProviderGetSubsearchResultSetData* _data_);
VALA_EXTERN GHashTable** pamac_search_provider_get_result_metas (PamacSearchProvider* self,
                                                     gchar** results,
                                                     gint results_length1,
                                                     gint* result_length1,
                                                     GError** error);
static void _g_hash_table_unref0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static GVariant* _variant_new1 (const gchar* value);
static GVariant* _variant_new2 (const gchar* value);
static GVariant* _variant_new3 (const gchar* value);
static GHashTable** _vala_array_dup2 (GHashTable** self,
                               gssize length);
VALA_EXTERN void pamac_search_provider_activate_result (PamacSearchProvider* self,
                                            const gchar* _result_,
                                            gchar** terms,
                                            gint terms_length1,
                                            guint32 timestamp,
                                            GError** error);
VALA_EXTERN void pamac_search_provider_launch_search (PamacSearchProvider* self,
                                          gchar** terms,
                                          gint terms_length1,
                                          guint32 timestamp,
                                          GError** error);
static void g_cclosure_user_marshal_VOID__STRING_UINT (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__BOXED_INT_UINT (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void pamac_search_provider_finalize (GObject * obj);
static GType pamac_search_provider_get_type_once (void);
static void _dbus_pamac_search_provider_get_initial_result_set (PamacSearchProvider* self,
                                                         GVariant* _parameters_,
                                                         GDBusMethodInvocation* invocation);
static void _dbus_pamac_search_provider_get_initial_result_set_ready (GObject * source_object,
                                                               GAsyncResult * _res_,
                                                               gpointer _user_data_);
static void _dbus_pamac_search_provider_get_subsearch_result_set (PamacSearchProvider* self,
                                                           GVariant* _parameters_,
                                                           GDBusMethodInvocation* invocation);
static void _dbus_pamac_search_provider_get_subsearch_result_set_ready (GObject * source_object,
                                                                 GAsyncResult * _res_,
                                                                 gpointer _user_data_);
static void _dbus_pamac_search_provider_get_result_metas (PamacSearchProvider* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation);
static void _dbus_pamac_search_provider_activate_result (PamacSearchProvider* self,
                                                  GVariant* _parameters_,
                                                  GDBusMethodInvocation* invocation);
static void _dbus_pamac_search_provider_launch_search (PamacSearchProvider* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation);
static void pamac_search_provider_dbus_interface_method_call (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* method_name,
                                                       GVariant* parameters,
                                                       GDBusMethodInvocation* invocation,
                                                       gpointer user_data);
static GVariant* pamac_search_provider_dbus_interface_get_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GError** error,
                                                             gpointer user_data);
static gboolean pamac_search_provider_dbus_interface_set_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GVariant* value,
                                                            GError** error,
                                                            gpointer user_data);
static void _pamac_search_provider_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GDBusArgInfo _pamac_search_provider_dbus_arg_info_get_initial_result_set_terms = {-1, "terms", "as", NULL};
static const GDBusArgInfo _pamac_search_provider_dbus_arg_info_get_initial_result_set_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _pamac_search_provider_dbus_arg_info_get_initial_result_set_in[] = {&_pamac_search_provider_dbus_arg_info_get_initial_result_set_terms, NULL};
static const GDBusArgInfo * const _pamac_search_provider_dbus_arg_info_get_initial_result_set_out[] = {&_pamac_search_provider_dbus_arg_info_get_initial_result_set_result, NULL};
static const GDBusMethodInfo _pamac_search_provider_dbus_method_info_get_initial_result_set = {-1, "GetInitialResultSet", (GDBusArgInfo **) (&_pamac_search_provider_dbus_arg_info_get_initial_result_set_in), (GDBusArgInfo **) (&_pamac_search_provider_dbus_arg_info_get_initial_result_set_out), NULL};
static const GDBusArgInfo _pamac_search_provider_dbus_arg_info_get_subsearch_result_set_previous_results = {-1, "previous_results", "as", NULL};
static const GDBusArgInfo _pamac_search_provider_dbus_arg_info_get_subsearch_result_set_terms = {-1, "terms", "as", NULL};
static const GDBusArgInfo _pamac_search_provider_dbus_arg_info_get_subsearch_result_set_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _pamac_search_provider_dbus_arg_info_get_subsearch_result_set_in[] = {&_pamac_search_provider_dbus_arg_info_get_subsearch_result_set_previous_results, &_pamac_search_provider_dbus_arg_info_get_subsearch_result_set_terms, NULL};
static const GDBusArgInfo * const _pamac_search_provider_dbus_arg_info_get_subsearch_result_set_out[] = {&_pamac_search_provider_dbus_arg_info_get_subsearch_result_set_result, NULL};
static const GDBusMethodInfo _pamac_search_provider_dbus_method_info_get_subsearch_result_set = {-1, "GetSubsearchResultSet", (GDBusArgInfo **) (&_pamac_search_provider_dbus_arg_info_get_subsearch_result_set_in), (GDBusArgInfo **) (&_pamac_search_provider_dbus_arg_info_get_subsearch_result_set_out), NULL};
static const GDBusArgInfo _pamac_search_provider_dbus_arg_info_get_result_metas_results = {-1, "results", "as", NULL};
static const GDBusArgInfo _pamac_search_provider_dbus_arg_info_get_result_metas_result = {-1, "result", "aa{sv}", NULL};
static const GDBusArgInfo * const _pamac_search_provider_dbus_arg_info_get_result_metas_in[] = {&_pamac_search_provider_dbus_arg_info_get_result_metas_results, NULL};
static const GDBusArgInfo * const _pamac_search_provider_dbus_arg_info_get_result_metas_out[] = {&_pamac_search_provider_dbus_arg_info_get_result_metas_result, NULL};
static const GDBusMethodInfo _pamac_search_provider_dbus_method_info_get_result_metas = {-1, "GetResultMetas", (GDBusArgInfo **) (&_pamac_search_provider_dbus_arg_info_get_result_metas_in), (GDBusArgInfo **) (&_pamac_search_provider_dbus_arg_info_get_result_metas_out), NULL};
static const GDBusArgInfo _pamac_search_provider_dbus_arg_info_activate_result_result = {-1, "result", "s", NULL};
static const GDBusArgInfo _pamac_search_provider_dbus_arg_info_activate_result_terms = {-1, "terms", "as", NULL};
static const GDBusArgInfo _pamac_search_provider_dbus_arg_info_activate_result_timestamp = {-1, "timestamp", "u", NULL};
static const GDBusArgInfo * const _pamac_search_provider_dbus_arg_info_activate_result_in[] = {&_pamac_search_provider_dbus_arg_info_activate_result_result, &_pamac_search_provider_dbus_arg_info_activate_result_terms, &_pamac_search_provider_dbus_arg_info_activate_result_timestamp, NULL};
static const GDBusArgInfo * const _pamac_search_provider_dbus_arg_info_activate_result_out[] = {NULL};
static const GDBusMethodInfo _pamac_search_provider_dbus_method_info_activate_result = {-1, "ActivateResult", (GDBusArgInfo **) (&_pamac_search_provider_dbus_arg_info_activate_result_in), (GDBusArgInfo **) (&_pamac_search_provider_dbus_arg_info_activate_result_out), NULL};
static const GDBusArgInfo _pamac_search_provider_dbus_arg_info_launch_search_terms = {-1, "terms", "as", NULL};
static const GDBusArgInfo _pamac_search_provider_dbus_arg_info_launch_search_timestamp = {-1, "timestamp", "u", NULL};
static const GDBusArgInfo * const _pamac_search_provider_dbus_arg_info_launch_search_in[] = {&_pamac_search_provider_dbus_arg_info_launch_search_terms, &_pamac_search_provider_dbus_arg_info_launch_search_timestamp, NULL};
static const GDBusArgInfo * const _pamac_search_provider_dbus_arg_info_launch_search_out[] = {NULL};
static const GDBusMethodInfo _pamac_search_provider_dbus_method_info_launch_search = {-1, "LaunchSearch", (GDBusArgInfo **) (&_pamac_search_provider_dbus_arg_info_launch_search_in), (GDBusArgInfo **) (&_pamac_search_provider_dbus_arg_info_launch_search_out), NULL};
static const GDBusMethodInfo * const _pamac_search_provider_dbus_method_info[] = {&_pamac_search_provider_dbus_method_info_get_initial_result_set, &_pamac_search_provider_dbus_method_info_get_subsearch_result_set, &_pamac_search_provider_dbus_method_info_get_result_metas, &_pamac_search_provider_dbus_method_info_activate_result, &_pamac_search_provider_dbus_method_info_launch_search, NULL};
static const GDBusSignalInfo * const _pamac_search_provider_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _pamac_search_provider_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _pamac_search_provider_dbus_interface_info = {-1, "org.gnome.Shell.SearchProvider2", (GDBusMethodInfo **) (&_pamac_search_provider_dbus_method_info), (GDBusSignalInfo **) (&_pamac_search_provider_dbus_signal_info), (GDBusPropertyInfo **) (&_pamac_search_provider_dbus_property_info), NULL};
static const GDBusInterfaceVTable _pamac_search_provider_dbus_interface_vtable = {pamac_search_provider_dbus_interface_method_call, pamac_search_provider_dbus_interface_get_property, pamac_search_provider_dbus_interface_set_property};

static inline gpointer
pamac_search_provider_get_instance_private (PamacSearchProvider* self)
{
	return G_STRUCT_MEMBER_P (self, PamacSearchProvider_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

PamacSearchProvider*
pamac_search_provider_construct (GType object_type,
                                 PamacDatabase* database)
{
	PamacSearchProvider * self = NULL;
	PamacDatabase* _tmp0_;
	g_return_val_if_fail (database != NULL, NULL);
	self = (PamacSearchProvider*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (database);
	_g_object_unref0 (self->priv->database);
	self->priv->database = _tmp0_;
	return self;
}

PamacSearchProvider*
pamac_search_provider_new (PamacDatabase* database)
{
	return pamac_search_provider_construct (PAMAC_TYPE_SEARCH_PROVIDER, database);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static GPtrArray*
pamac_search_provider_normalize_terms (PamacSearchProvider* self,
                                       gchar** terms,
                                       gint terms_length1)
{
	GPtrArray* normalized_terms = NULL;
	GPtrArray* _tmp0_;
	GPtrArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	normalized_terms = _tmp0_;
	{
		gchar** t_collection = NULL;
		gint t_collection_length1 = 0;
		gint _t_collection_size_ = 0;
		gint t_it = 0;
		t_collection = terms;
		t_collection_length1 = terms_length1;
		for (t_it = 0; t_it < t_collection_length1; t_it = t_it + 1) {
			gchar* _tmp1_;
			gchar* t = NULL;
			_tmp1_ = g_strdup (t_collection[t_it]);
			t = _tmp1_;
			{
				GPtrArray* _tmp2_;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp2_ = normalized_terms;
				_tmp3_ = t;
				_tmp4_ = g_utf8_normalize (_tmp3_, (gssize) -1, G_NORMALIZE_DEFAULT);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_utf8_casefold (_tmp5_, (gssize) -1);
				g_ptr_array_add (_tmp2_, _tmp6_);
				_g_free0 (_tmp5_);
				_g_free0 (t);
			}
		}
	}
	result = normalized_terms;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
pamac_search_provider_search_pkgs (PamacSearchProvider* self,
                                   GPtrArray* normalized_terms,
                                   gint* result_length1)
{
	GPtrArray* pkgs = NULL;
	PamacDatabase* _tmp0_;
	GPtrArray* _tmp1_;
	GPtrArray* _result_ = NULL;
	GPtrArray* _tmp2_;
	GPtrArray* _tmp3_;
	GPtrArray* _tmp27_;
	gpointer* _tmp28_;
	gint _tmp28__length1;
	gchar** _tmp29_;
	gint _tmp29__length1;
	gchar** _tmp30_;
	gint _tmp30__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (normalized_terms != NULL, NULL);
	_tmp0_ = self->priv->database;
	_tmp1_ = pamac_database_search_uninstalled_apps (_tmp0_, normalized_terms);
	pkgs = _tmp1_;
	_tmp2_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	_result_ = _tmp2_;
	_tmp3_ = pkgs;
	{
		GPtrArray* pkg_collection = NULL;
		guint pkg_index = 0U;
		pkg_collection = _tmp3_;
		for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
			PamacPackage* pkg = NULL;
			pkg = g_ptr_array_index (pkg_collection, pkg_index);
			{
				GString* data_builder = NULL;
				PamacPackage* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				GString* _tmp7_;
				GString* _tmp8_;
				GString* _tmp9_;
				PamacPackage* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				GString* _tmp13_;
				GString* _tmp14_;
				PamacPackage* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				GString* _tmp18_;
				GString* _tmp19_;
				PamacPackage* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				GPtrArray* _tmp23_;
				GString* _tmp24_;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				_tmp4_ = pkg;
				_tmp5_ = pamac_package_get_app_id (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_string_new (_tmp6_);
				data_builder = _tmp7_;
				_tmp8_ = data_builder;
				g_string_append (_tmp8_, ";");
				_tmp9_ = data_builder;
				_tmp10_ = pkg;
				_tmp11_ = pamac_package_get_app_name (_tmp10_);
				_tmp12_ = _tmp11_;
				g_string_append (_tmp9_, _tmp12_);
				_tmp13_ = data_builder;
				g_string_append (_tmp13_, ";");
				_tmp14_ = data_builder;
				_tmp15_ = pkg;
				_tmp16_ = pamac_package_get_long_desc (_tmp15_);
				_tmp17_ = _tmp16_;
				g_string_append (_tmp14_, _tmp17_);
				_tmp18_ = data_builder;
				g_string_append (_tmp18_, ";");
				_tmp19_ = data_builder;
				_tmp20_ = pkg;
				_tmp21_ = pamac_package_get_icon (_tmp20_);
				_tmp22_ = _tmp21_;
				g_string_append (_tmp19_, _tmp22_);
				_tmp23_ = _result_;
				_tmp24_ = data_builder;
				_tmp25_ = _tmp24_->str;
				_tmp26_ = g_strdup (_tmp25_);
				g_ptr_array_add (_tmp23_, _tmp26_);
				_g_string_free0 (data_builder);
			}
		}
	}
	_tmp27_ = _result_;
	_tmp28_ = _tmp27_->pdata;
	_tmp28__length1 = _tmp27_->len;
	_tmp29_ = (_tmp28_ != NULL) ? _vala_array_dup1 (_tmp28_, _tmp28__length1) : _tmp28_;
	_tmp29__length1 = _tmp28__length1;
	_tmp30_ = _tmp29_;
	_tmp30__length1 = _tmp29__length1;
	if (result_length1) {
		*result_length1 = _tmp30__length1;
	}
	result = _tmp30_;
	_g_ptr_array_unref0 (_result_);
	_g_ptr_array_unref0 (pkgs);
	return result;
}

static void
pamac_search_provider_get_initial_result_set_data_free (gpointer _data)
{
	PamacSearchProviderGetInitialResultSetData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (PamacSearchProviderGetInitialResultSetData, _data_);
}

void
pamac_search_provider_get_initial_result_set (PamacSearchProvider* self,
                                              gchar** terms,
                                              gint terms_length1,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	PamacSearchProviderGetInitialResultSetData* _data_;
	PamacSearchProvider* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PamacSearchProviderGetInitialResultSetData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pamac_search_provider_get_initial_result_set_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->terms = terms;
	_data_->terms_length1 = terms_length1;
	pamac_search_provider_get_initial_result_set_co (_data_);
}

gchar**
pamac_search_provider_get_initial_result_set_finish (PamacSearchProvider* self,
                                                     GAsyncResult* _res_,
                                                     gint* result_length1,
                                                     GError** error)
{
	gchar** result;
	PamacSearchProviderGetInitialResultSetData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static gboolean
pamac_search_provider_get_initial_result_set_co (PamacSearchProviderGetInitialResultSetData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = pamac_search_provider_normalize_terms (_data_->self, _data_->terms, (gint) _data_->terms_length1);
	_data_->normalized_terms = _data_->_tmp0_;
	_data_->_tmp1_ = 0;
	_data_->_tmp2_ = pamac_search_provider_search_pkgs (_data_->self, _data_->normalized_terms, &_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp3__length1 = _data_->_tmp1_;
	_data_->result_length1 = _data_->_tmp3__length1;
	_data_->result = _data_->_tmp3_;
	_g_ptr_array_unref0 (_data_->normalized_terms);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
pamac_search_provider_get_subsearch_result_set_data_free (gpointer _data)
{
	PamacSearchProviderGetSubsearchResultSetData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (PamacSearchProviderGetSubsearchResultSetData, _data_);
}

void
pamac_search_provider_get_subsearch_result_set (PamacSearchProvider* self,
                                                gchar** previous_results,
                                                gint previous_results_length1,
                                                gchar** terms,
                                                gint terms_length1,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	PamacSearchProviderGetSubsearchResultSetData* _data_;
	PamacSearchProvider* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PamacSearchProviderGetSubsearchResultSetData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pamac_search_provider_get_subsearch_result_set_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->previous_results = previous_results;
	_data_->previous_results_length1 = previous_results_length1;
	_data_->terms = terms;
	_data_->terms_length1 = terms_length1;
	pamac_search_provider_get_subsearch_result_set_co (_data_);
}

gchar**
pamac_search_provider_get_subsearch_result_set_finish (PamacSearchProvider* self,
                                                       GAsyncResult* _res_,
                                                       gint* result_length1,
                                                       GError** error)
{
	gchar** result;
	PamacSearchProviderGetSubsearchResultSetData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static gboolean
pamac_search_provider_get_subsearch_result_set_co (PamacSearchProviderGetSubsearchResultSetData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = pamac_search_provider_normalize_terms (_data_->self, _data_->terms, (gint) _data_->terms_length1);
	_data_->normalized_terms = _data_->_tmp0_;
	_data_->_tmp1_ = 0;
	_data_->_tmp2_ = pamac_search_provider_search_pkgs (_data_->self, _data_->normalized_terms, &_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp3__length1 = _data_->_tmp1_;
	_data_->result_length1 = _data_->_tmp3__length1;
	_data_->result = _data_->_tmp3_;
	_g_ptr_array_unref0 (_data_->normalized_terms);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_g_hash_table_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL));
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static GVariant*
_variant_new1 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new2 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new3 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static GHashTable**
_vala_array_dup2 (GHashTable** self,
                  gssize length)
{
	if (length >= 0) {
		GHashTable** result;
		gssize i;
		result = g_new0 (GHashTable*, length + 1);
		for (i = 0; i < length; i++) {
			GHashTable* _tmp0_;
			_tmp0_ = _g_hash_table_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

GHashTable**
pamac_search_provider_get_result_metas (PamacSearchProvider* self,
                                        gchar** results,
                                        gint results_length1,
                                        gint* result_length1,
                                        GError** error)
{
	GPtrArray* _result_ = NULL;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp52_;
	gpointer* _tmp53_;
	gint _tmp53__length1;
	GHashTable** _tmp54_;
	gint _tmp54__length1;
	GHashTable** _tmp55_;
	gint _tmp55__length1;
	GError* _inner_error0_ = NULL;
	GHashTable** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_hash_table_unref0_);
	_result_ = _tmp0_;
	{
		gchar** str_collection = NULL;
		gint str_collection_length1 = 0;
		gint _str_collection_size_ = 0;
		gint str_it = 0;
		str_collection = results;
		str_collection_length1 = results_length1;
		for (str_it = 0; str_it < str_collection_length1; str_it = str_it + 1) {
			const gchar* str = NULL;
			str = str_collection[str_it];
			{
				GHashTable* meta = NULL;
				GHashFunc _tmp1_;
				GEqualFunc _tmp2_;
				GHashTable* _tmp3_;
				gchar** pkg_data = NULL;
				const gchar* _tmp4_;
				gchar** _tmp5_;
				gchar** _tmp6_;
				gint pkg_data_length1;
				gint _pkg_data_size_;
				GHashTable* _tmp7_;
				gchar* _tmp8_;
				gchar** _tmp9_;
				gint _tmp9__length1;
				const gchar* _tmp10_;
				GVariant* _tmp11_;
				GHashTable* _tmp12_;
				gchar* _tmp13_;
				gchar** _tmp14_;
				gint _tmp14__length1;
				const gchar* _tmp15_;
				GVariant* _tmp16_;
				GHashTable* _tmp17_;
				gchar* _tmp18_;
				gchar** _tmp19_;
				gint _tmp19__length1;
				const gchar* _tmp20_;
				GVariant* _tmp21_;
				GIcon* icon = NULL;
				gchar** _tmp22_;
				gint _tmp22__length1;
				const gchar* _tmp23_;
				GIcon* _tmp44_;
				GPtrArray* _tmp49_;
				GHashTable* _tmp50_;
				GHashTable* _tmp51_;
				_tmp1_ = g_str_hash;
				_tmp2_ = g_str_equal;
				_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_variant_unref0_);
				meta = _tmp3_;
				_tmp4_ = str;
				_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, ";", 4);
				pkg_data = _tmp6_;
				pkg_data_length1 = _vala_array_length (_tmp5_);
				_pkg_data_size_ = pkg_data_length1;
				_tmp7_ = meta;
				_tmp8_ = g_strdup ("id");
				_tmp9_ = pkg_data;
				_tmp9__length1 = pkg_data_length1;
				_tmp10_ = _tmp9_[0];
				_tmp11_ = _variant_new1 (_tmp10_);
				g_hash_table_insert (_tmp7_, _tmp8_, _tmp11_);
				_tmp12_ = meta;
				_tmp13_ = g_strdup ("name");
				_tmp14_ = pkg_data;
				_tmp14__length1 = pkg_data_length1;
				_tmp15_ = _tmp14_[1];
				_tmp16_ = _variant_new2 (_tmp15_);
				g_hash_table_insert (_tmp12_, _tmp13_, _tmp16_);
				_tmp17_ = meta;
				_tmp18_ = g_strdup ("description");
				_tmp19_ = pkg_data;
				_tmp19__length1 = pkg_data_length1;
				_tmp20_ = _tmp19_[2];
				_tmp21_ = _variant_new3 (_tmp20_);
				g_hash_table_insert (_tmp17_, _tmp18_, _tmp21_);
				icon = NULL;
				_tmp22_ = pkg_data;
				_tmp22__length1 = pkg_data_length1;
				_tmp23_ = _tmp22_[3];
				if (g_strcmp0 (_tmp23_, "") != 0) {
					{
						GdkPixbuf* _tmp24_ = NULL;
						gchar** _tmp25_;
						gint _tmp25__length1;
						const gchar* _tmp26_;
						GdkPixbuf* _tmp27_;
						GdkPixbuf* _tmp28_;
						_tmp25_ = pkg_data;
						_tmp25__length1 = pkg_data_length1;
						_tmp26_ = _tmp25_[3];
						_tmp27_ = gdk_pixbuf_new_from_file (_tmp26_, &_inner_error0_);
						_tmp24_ = _tmp27_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch0_g_error;
						}
						_tmp28_ = _tmp24_;
						_tmp24_ = NULL;
						_g_object_unref0 (icon);
						icon = (GIcon*) _tmp28_;
						_g_object_unref0 (_tmp24_);
					}
					goto __finally0;
					__catch0_g_error:
					{
						gchar* icon_path = NULL;
						gchar** _tmp29_;
						gint _tmp29__length1;
						const gchar* _tmp30_;
						gchar* _tmp31_;
						const gchar* _tmp32_;
						g_clear_error (&_inner_error0_);
						_tmp29_ = pkg_data;
						_tmp29__length1 = pkg_data_length1;
						_tmp30_ = _tmp29_[2];
						_tmp31_ = g_strdup (_tmp30_);
						icon_path = _tmp31_;
						_tmp32_ = icon_path;
						if (string_contains (_tmp32_, "extra")) {
							const gchar* _tmp33_;
							gchar* _tmp34_;
							_tmp33_ = icon_path;
							_tmp34_ = string_replace (_tmp33_, "extra", "community");
							_g_free0 (icon_path);
							icon_path = _tmp34_;
						} else {
							const gchar* _tmp35_;
							_tmp35_ = icon_path;
							if (string_contains (_tmp35_, "community")) {
								const gchar* _tmp36_;
								gchar* _tmp37_;
								_tmp36_ = icon_path;
								_tmp37_ = string_replace (_tmp36_, "community", "extra");
								_g_free0 (icon_path);
								icon_path = _tmp37_;
							}
						}
						{
							GdkPixbuf* _tmp38_ = NULL;
							const gchar* _tmp39_;
							GdkPixbuf* _tmp40_;
							GdkPixbuf* _tmp41_;
							_tmp39_ = icon_path;
							_tmp40_ = gdk_pixbuf_new_from_file (_tmp39_, &_inner_error0_);
							_tmp38_ = _tmp40_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch1_g_error;
							}
							_tmp41_ = _tmp38_;
							_tmp38_ = NULL;
							_g_object_unref0 (icon);
							icon = (GIcon*) _tmp41_;
							_g_object_unref0 (_tmp38_);
						}
						goto __finally1;
						__catch1_g_error:
						{
							GThemedIcon* _tmp42_;
							g_clear_error (&_inner_error0_);
							_tmp42_ = (GThemedIcon*) g_themed_icon_new ("package-x-generic");
							_g_object_unref0 (icon);
							icon = (GIcon*) _tmp42_;
						}
						__finally1:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (icon_path);
							_g_object_unref0 (icon);
							pkg_data = (_vala_array_free (pkg_data, pkg_data_length1, (GDestroyNotify) g_free), NULL);
							_g_hash_table_unref0 (meta);
							_g_ptr_array_unref0 (_result_);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
						_g_free0 (icon_path);
					}
					__finally0:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_object_unref0 (icon);
						pkg_data = (_vala_array_free (pkg_data, pkg_data_length1, (GDestroyNotify) g_free), NULL);
						_g_hash_table_unref0 (meta);
						_g_ptr_array_unref0 (_result_);
						return NULL;
					}
				} else {
					GThemedIcon* _tmp43_;
					_tmp43_ = (GThemedIcon*) g_themed_icon_new ("package-x-generic");
					_g_object_unref0 (icon);
					icon = (GIcon*) _tmp43_;
				}
				_tmp44_ = icon;
				if (_tmp44_ != NULL) {
					GHashTable* _tmp45_;
					gchar* _tmp46_;
					GIcon* _tmp47_;
					GVariant* _tmp48_;
					_tmp45_ = meta;
					_tmp46_ = g_strdup ("icon");
					_tmp47_ = icon;
					_tmp48_ = g_icon_serialize (_tmp47_);
					g_hash_table_insert (_tmp45_, _tmp46_, _tmp48_);
				}
				_tmp49_ = _result_;
				_tmp50_ = meta;
				_tmp51_ = _g_hash_table_ref0 (_tmp50_);
				g_ptr_array_add (_tmp49_, _tmp51_);
				_g_object_unref0 (icon);
				pkg_data = (_vala_array_free (pkg_data, pkg_data_length1, (GDestroyNotify) g_free), NULL);
				_g_hash_table_unref0 (meta);
			}
		}
	}
	_tmp52_ = _result_;
	_tmp53_ = _tmp52_->pdata;
	_tmp53__length1 = _tmp52_->len;
	_tmp54_ = (_tmp53_ != NULL) ? _vala_array_dup2 (_tmp53_, _tmp53__length1) : _tmp53_;
	_tmp54__length1 = _tmp53__length1;
	_tmp55_ = _tmp54_;
	_tmp55__length1 = _tmp54__length1;
	if (result_length1) {
		*result_length1 = _tmp55__length1;
	}
	result = _tmp55_;
	_g_ptr_array_unref0 (_result_);
	return result;
}

void
pamac_search_provider_activate_result (PamacSearchProvider* self,
                                       const gchar* _result_,
                                       gchar** terms,
                                       gint terms_length1,
                                       guint32 timestamp,
                                       GError** error)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (_result_ != NULL);
	g_signal_emit (self, pamac_search_provider_signals[PAMAC_SEARCH_PROVIDER_SHOW_DETAILS_SIGNAL], 0, _result_, timestamp);
}

void
pamac_search_provider_launch_search (PamacSearchProvider* self,
                                     gchar** terms,
                                     gint terms_length1,
                                     guint32 timestamp,
                                     GError** error)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, pamac_search_provider_signals[PAMAC_SEARCH_PROVIDER_SEARCH_FULL_SIGNAL], 0, terms, (gint) terms_length1, timestamp);
}

static void
g_cclosure_user_marshal_VOID__STRING_UINT (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_UINT) (gpointer data1, const char* arg_1, guint32 arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_uint (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__BOXED_INT_UINT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__BOXED_INT_UINT) (gpointer data1, gpointer arg_1, gint arg_2, guint32 arg_3, gpointer data2);
	register GMarshalFunc_VOID__BOXED_INT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED_INT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), g_value_get_int (param_values + 2), g_value_get_uint (param_values + 3), data2);
}

static void
pamac_search_provider_class_init (PamacSearchProviderClass * klass,
                                  gpointer klass_data)
{
	pamac_search_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PamacSearchProvider_private_offset);
	G_OBJECT_CLASS (klass)->finalize = pamac_search_provider_finalize;
	pamac_search_provider_signals[PAMAC_SEARCH_PROVIDER_SHOW_DETAILS_SIGNAL] = g_signal_new ("show-details", PAMAC_TYPE_SEARCH_PROVIDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_UINT, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_UINT);
	pamac_search_provider_signals[PAMAC_SEARCH_PROVIDER_SEARCH_FULL_SIGNAL] = g_signal_new ("search-full", PAMAC_TYPE_SEARCH_PROVIDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED_INT_UINT, G_TYPE_NONE, 3, G_TYPE_STRV, G_TYPE_INT, G_TYPE_UINT);
}

static void
pamac_search_provider_instance_init (PamacSearchProvider * self,
                                     gpointer klass)
{
	self->priv = pamac_search_provider_get_instance_private (self);
}

static void
pamac_search_provider_finalize (GObject * obj)
{
	PamacSearchProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_SEARCH_PROVIDER, PamacSearchProvider);
	_g_object_unref0 (self->priv->database);
	G_OBJECT_CLASS (pamac_search_provider_parent_class)->finalize (obj);
}

static GType
pamac_search_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PamacSearchProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pamac_search_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PamacSearchProvider), 0, (GInstanceInitFunc) pamac_search_provider_instance_init, NULL };
	GType pamac_search_provider_type_id;
	pamac_search_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "PamacSearchProvider", &g_define_type_info, 0);
	g_type_set_qdata (pamac_search_provider_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) pamac_search_provider_register_object);
	PamacSearchProvider_private_offset = g_type_add_instance_private (pamac_search_provider_type_id, sizeof (PamacSearchProviderPrivate));
	return pamac_search_provider_type_id;
}

GType
pamac_search_provider_get_type (void)
{
	static volatile gsize pamac_search_provider_type_id__once = 0;
	if (g_once_init_enter (&pamac_search_provider_type_id__once)) {
		GType pamac_search_provider_type_id;
		pamac_search_provider_type_id = pamac_search_provider_get_type_once ();
		g_once_init_leave (&pamac_search_provider_type_id__once, pamac_search_provider_type_id);
	}
	return pamac_search_provider_type_id__once;
}

static void
_dbus_pamac_search_provider_get_initial_result_set (PamacSearchProvider* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	PamacSearchProviderGetInitialResultSetReadyData* _ready_data;
	GVariant* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length;
	gint _tmp1__size;
	gint _tmp1__length1;
	GVariantIter _tmp2_;
	GVariant* _tmp3_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (PamacSearchProviderGetInitialResultSetReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp1_ = g_new (gchar*, 5);
	_tmp1__length = 0;
	_tmp1__size = 4;
	_tmp1__length1 = 0;
	g_variant_iter_init (&_tmp2_, _tmp0_);
	for (; (_tmp3_ = g_variant_iter_next_value (&_tmp2_)) != NULL; _tmp1__length1++) {
		if (_tmp1__size == _tmp1__length) {
			_tmp1__size = 2 * _tmp1__size;
			_tmp1_ = g_renew (gchar*, _tmp1_, _tmp1__size + 1);
		}
		_tmp1_[_tmp1__length++] = g_variant_dup_string (_tmp3_, NULL);
		g_variant_unref (_tmp3_);
	}
	_ready_data->terms_length1 = _tmp1__length1;
	_tmp1_[_tmp1__length] = NULL;
	_ready_data->terms = _tmp1_;
	g_variant_unref (_tmp0_);
	pamac_search_provider_get_initial_result_set (self, _ready_data->terms, _ready_data->terms_length1, (GAsyncReadyCallback) _dbus_pamac_search_provider_get_initial_result_set_ready, _ready_data);
	_error:
	;
}

static void
_dbus_pamac_search_provider_get_initial_result_set_ready (GObject * source_object,
                                                          GAsyncResult * _res_,
                                                          gpointer _user_data_)
{
	PamacSearchProviderGetInitialResultSetReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp4_;
	GVariantBuilder _tmp5_;
	gint _tmp6_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = pamac_search_provider_get_initial_result_set_finish ((PamacSearchProvider*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp4_ = result;
	g_variant_builder_init (&_tmp5_, G_VARIANT_TYPE ("as"));
	for (_tmp6_ = 0; _tmp6_ < result_length1; _tmp6_++) {
		g_variant_builder_add_value (&_tmp5_, g_variant_new_string (*_tmp4_));
		_tmp4_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp5_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_ready_data->terms = (_vala_array_free (_ready_data->terms, _ready_data->terms_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (PamacSearchProviderGetInitialResultSetReadyData, _ready_data);
}

static void
_dbus_pamac_search_provider_get_subsearch_result_set (PamacSearchProvider* self,
                                                      GVariant* _parameters_,
                                                      GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	PamacSearchProviderGetSubsearchResultSetReadyData* _ready_data;
	GVariant* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length;
	gint _tmp8__size;
	gint _tmp8__length1;
	GVariantIter _tmp9_;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length;
	gint _tmp12__size;
	gint _tmp12__length1;
	GVariantIter _tmp13_;
	GVariant* _tmp14_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (PamacSearchProviderGetSubsearchResultSetReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp8_ = g_new (gchar*, 5);
	_tmp8__length = 0;
	_tmp8__size = 4;
	_tmp8__length1 = 0;
	g_variant_iter_init (&_tmp9_, _tmp7_);
	for (; (_tmp10_ = g_variant_iter_next_value (&_tmp9_)) != NULL; _tmp8__length1++) {
		if (_tmp8__size == _tmp8__length) {
			_tmp8__size = 2 * _tmp8__size;
			_tmp8_ = g_renew (gchar*, _tmp8_, _tmp8__size + 1);
		}
		_tmp8_[_tmp8__length++] = g_variant_dup_string (_tmp10_, NULL);
		g_variant_unref (_tmp10_);
	}
	_ready_data->previous_results_length1 = _tmp8__length1;
	_tmp8_[_tmp8__length] = NULL;
	_ready_data->previous_results = _tmp8_;
	g_variant_unref (_tmp7_);
	_tmp11_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp12_ = g_new (gchar*, 5);
	_tmp12__length = 0;
	_tmp12__size = 4;
	_tmp12__length1 = 0;
	g_variant_iter_init (&_tmp13_, _tmp11_);
	for (; (_tmp14_ = g_variant_iter_next_value (&_tmp13_)) != NULL; _tmp12__length1++) {
		if (_tmp12__size == _tmp12__length) {
			_tmp12__size = 2 * _tmp12__size;
			_tmp12_ = g_renew (gchar*, _tmp12_, _tmp12__size + 1);
		}
		_tmp12_[_tmp12__length++] = g_variant_dup_string (_tmp14_, NULL);
		g_variant_unref (_tmp14_);
	}
	_ready_data->terms_length1 = _tmp12__length1;
	_tmp12_[_tmp12__length] = NULL;
	_ready_data->terms = _tmp12_;
	g_variant_unref (_tmp11_);
	pamac_search_provider_get_subsearch_result_set (self, _ready_data->previous_results, _ready_data->previous_results_length1, _ready_data->terms, _ready_data->terms_length1, (GAsyncReadyCallback) _dbus_pamac_search_provider_get_subsearch_result_set_ready, _ready_data);
	_error:
	;
}

static void
_dbus_pamac_search_provider_get_subsearch_result_set_ready (GObject * source_object,
                                                            GAsyncResult * _res_,
                                                            gpointer _user_data_)
{
	PamacSearchProviderGetSubsearchResultSetReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp15_;
	GVariantBuilder _tmp16_;
	gint _tmp17_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = pamac_search_provider_get_subsearch_result_set_finish ((PamacSearchProvider*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp15_ = result;
	g_variant_builder_init (&_tmp16_, G_VARIANT_TYPE ("as"));
	for (_tmp17_ = 0; _tmp17_ < result_length1; _tmp17_++) {
		g_variant_builder_add_value (&_tmp16_, g_variant_new_string (*_tmp15_));
		_tmp15_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp16_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_ready_data->previous_results = (_vala_array_free (_ready_data->previous_results, _ready_data->previous_results_length1, (GDestroyNotify) g_free), NULL);
	_ready_data->terms = (_vala_array_free (_ready_data->terms, _ready_data->terms_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (PamacSearchProviderGetSubsearchResultSetReadyData, _ready_data);
}

static void
_dbus_pamac_search_provider_get_result_metas (PamacSearchProvider* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** results = NULL;
	gint results_length1 = 0;
	GVariant* _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length;
	gint _tmp19__size;
	gint _tmp19__length1;
	GVariantIter _tmp20_;
	GVariant* _tmp21_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GHashTable** result;
	gint result_length1 = 0;
	GHashTable** _tmp22_;
	GVariantBuilder _tmp23_;
	gint _tmp24_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp18_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp19_ = g_new (gchar*, 5);
	_tmp19__length = 0;
	_tmp19__size = 4;
	_tmp19__length1 = 0;
	g_variant_iter_init (&_tmp20_, _tmp18_);
	for (; (_tmp21_ = g_variant_iter_next_value (&_tmp20_)) != NULL; _tmp19__length1++) {
		if (_tmp19__size == _tmp19__length) {
			_tmp19__size = 2 * _tmp19__size;
			_tmp19_ = g_renew (gchar*, _tmp19_, _tmp19__size + 1);
		}
		_tmp19_[_tmp19__length++] = g_variant_dup_string (_tmp21_, NULL);
		g_variant_unref (_tmp21_);
	}
	results_length1 = _tmp19__length1;
	_tmp19_[_tmp19__length] = NULL;
	results = _tmp19_;
	g_variant_unref (_tmp18_);
	result = pamac_search_provider_get_result_metas (self, results, results_length1, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp22_ = result;
	g_variant_builder_init (&_tmp23_, G_VARIANT_TYPE ("aa{sv}"));
	for (_tmp24_ = 0; _tmp24_ < result_length1; _tmp24_++) {
		GVariantBuilder _tmp25_;
		GHashTableIter _tmp26_;
		gpointer _tmp27_;
		gpointer _tmp28_;
		g_hash_table_iter_init (&_tmp26_, *_tmp22_);
		g_variant_builder_init (&_tmp25_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp26_, &_tmp27_, &_tmp28_)) {
			gchar* _key;
			GVariant* _value;
			_key = (gchar*) _tmp27_;
			_value = (GVariant*) _tmp28_;
			g_variant_builder_add (&_tmp25_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add_value (&_tmp23_, g_variant_builder_end (&_tmp25_));
		_tmp22_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp23_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	results = (_vala_array_free (results, results_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_pamac_search_provider_activate_result (PamacSearchProvider* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* _result_ = NULL;
	GVariant* _tmp29_;
	gchar** terms = NULL;
	gint terms_length1 = 0;
	GVariant* _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length;
	gint _tmp31__size;
	gint _tmp31__length1;
	GVariantIter _tmp32_;
	GVariant* _tmp33_;
	guint32 timestamp = 0U;
	GVariant* _tmp34_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp29_ = g_variant_iter_next_value (&_arguments_iter);
	_result_ = g_variant_dup_string (_tmp29_, NULL);
	g_variant_unref (_tmp29_);
	_tmp30_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp31_ = g_new (gchar*, 5);
	_tmp31__length = 0;
	_tmp31__size = 4;
	_tmp31__length1 = 0;
	g_variant_iter_init (&_tmp32_, _tmp30_);
	for (; (_tmp33_ = g_variant_iter_next_value (&_tmp32_)) != NULL; _tmp31__length1++) {
		if (_tmp31__size == _tmp31__length) {
			_tmp31__size = 2 * _tmp31__size;
			_tmp31_ = g_renew (gchar*, _tmp31_, _tmp31__size + 1);
		}
		_tmp31_[_tmp31__length++] = g_variant_dup_string (_tmp33_, NULL);
		g_variant_unref (_tmp33_);
	}
	terms_length1 = _tmp31__length1;
	_tmp31_[_tmp31__length] = NULL;
	terms = _tmp31_;
	g_variant_unref (_tmp30_);
	_tmp34_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp34_);
	g_variant_unref (_tmp34_);
	pamac_search_provider_activate_result (self, _result_, terms, terms_length1, timestamp, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_result_);
	terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_pamac_search_provider_launch_search (PamacSearchProvider* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** terms = NULL;
	gint terms_length1 = 0;
	GVariant* _tmp35_;
	gchar** _tmp36_;
	gint _tmp36__length;
	gint _tmp36__size;
	gint _tmp36__length1;
	GVariantIter _tmp37_;
	GVariant* _tmp38_;
	guint32 timestamp = 0U;
	GVariant* _tmp39_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp35_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp36_ = g_new (gchar*, 5);
	_tmp36__length = 0;
	_tmp36__size = 4;
	_tmp36__length1 = 0;
	g_variant_iter_init (&_tmp37_, _tmp35_);
	for (; (_tmp38_ = g_variant_iter_next_value (&_tmp37_)) != NULL; _tmp36__length1++) {
		if (_tmp36__size == _tmp36__length) {
			_tmp36__size = 2 * _tmp36__size;
			_tmp36_ = g_renew (gchar*, _tmp36_, _tmp36__size + 1);
		}
		_tmp36_[_tmp36__length++] = g_variant_dup_string (_tmp38_, NULL);
		g_variant_unref (_tmp38_);
	}
	terms_length1 = _tmp36__length1;
	_tmp36_[_tmp36__length] = NULL;
	terms = _tmp36_;
	g_variant_unref (_tmp35_);
	_tmp39_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp39_);
	g_variant_unref (_tmp39_);
	pamac_search_provider_launch_search (self, terms, terms_length1, timestamp, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
pamac_search_provider_dbus_interface_method_call (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* method_name,
                                                  GVariant* parameters,
                                                  GDBusMethodInvocation* invocation,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetInitialResultSet") == 0) {
		_dbus_pamac_search_provider_get_initial_result_set (object, parameters, invocation);
	} else if (strcmp (method_name, "GetSubsearchResultSet") == 0) {
		_dbus_pamac_search_provider_get_subsearch_result_set (object, parameters, invocation);
	} else if (strcmp (method_name, "GetResultMetas") == 0) {
		_dbus_pamac_search_provider_get_result_metas (object, parameters, invocation);
	} else if (strcmp (method_name, "ActivateResult") == 0) {
		_dbus_pamac_search_provider_activate_result (object, parameters, invocation);
	} else if (strcmp (method_name, "LaunchSearch") == 0) {
		_dbus_pamac_search_provider_launch_search (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
pamac_search_provider_dbus_interface_get_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
pamac_search_provider_dbus_interface_set_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GVariant* value,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
pamac_search_provider_register_object (gpointer object,
                                       GDBusConnection* connection,
                                       const gchar* path,
                                       GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_pamac_search_provider_dbus_interface_info), &_pamac_search_provider_dbus_interface_vtable, data, _pamac_search_provider_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_pamac_search_provider_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

