/* v8 ignore start */

import {Bytes, fixed_list, int8s, LVBytes, LVList, list, uint_t, uint8_t, uint16_t, uint24_t, uint32_t, uint64_t, WordList} from "./basic";
import {
    Bool,
    EmberApsOption,
    EmberBindingType,
    EmberConcentratorType,
    EmberConfigTxPowerMode,
    EmberCounterType,
    EmberCurrentSecurityBitmask,
    EmberDerivedKeyType,
    EmberDeviceUpdate,
    EmberEUI64,
    EmberEventUnits,
    EmberGpKeyType,
    EmberGpSecurityLevel,
    EmberIncomingMessageType,
    EmberInitialSecurityBitmask,
    EmberJoinDecision,
    EmberJoinMethod,
    EmberKeyStatus,
    EmberKeyStructBitmask,
    EmberKeyType,
    EmberLibraryStatus,
    EmberMacPassthroughType,
    EmberMulticastId,
    EmberNetworkInitBitmask,
    EmberNetworkStatus,
    EmberNodeId,
    EmberNodeType,
    EmberOutgoingMessageType,
    EmberPanId,
    EmberRf4ceApplicationCapabilities,
    EmberRf4ceNodeCapabilities,
    EmberRf4ceTxOption,
    EmberStackError,
    EmberStatus,
    EmberZDOCmd,
    EmberZdoConfigurationFlags,
    EmberZllKeyIndex,
    EmberZllState,
    EzspConfigId,
    EzspDecisionId,
    EzspEndpointFlags,
    EzspExtendedValueId,
    EzspMfgTokenId,
    EzspNetworkScanType,
    EzspPolicyId,
    EzspSourceRouteOverheadInformation,
    EzspStatus,
    EzspValueId,
    EzspZllNetworkOperation,
    NcpResetCode,
    SecureEzspRandomNumber,
    SecureEzspSecurityLevel,
    SecureEzspSecurityType,
    SecureEzspSessionId,
    SLStatus,
} from "./named";
import {
    EmberAesMmoHashContext,
    EmberApsFrame,
    EmberBindingTableEntry,
    EmberCertificate283k1Data,
    EmberCertificateData,
    EmberCurrentSecurityState,
    EmberGpAddress,
    EmberGpSinkListEntry,
    EmberInitialSecurityState,
    EmberKeyData,
    EmberKeyStruct,
    EmberMessageDigest,
    EmberMultiAddress,
    EmberMulticastTableEntry,
    EmberNeighbors,
    EmberNeighborTableEntry,
    EmberNetworkInitStruct,
    EmberNetworkParameters,
    EmberNodeDescriptor,
    EmberPrivateKey283k1Data,
    EmberPrivateKeyData,
    EmberPublicKey283k1Data,
    EmberPublicKeyData,
    EmberRf4ceApplicationInfo,
    EmberRf4cePairingTableEntry,
    EmberRf4ceVendorInfo,
    EmberRouteTableEntry,
    EmberRoutingTable,
    EmberRoutingTableEntry,
    EmberSecurityManagerContext,
    EmberSecurityManagerNetworkKeyInfo,
    EmberSignature283k1Data,
    EmberSignatureData,
    EmberSimpleDescriptor,
    EmberSmacData,
    EmberTokTypeStackZllData,
    EmberTokTypeStackZllSecurity,
    EmberZigbeeNetwork,
    EmberZllAddressAssignment,
    EmberZllDeviceInfoRecord,
    EmberZllInitialSecurityState,
    EmberZllNetwork,
    EmberZllSecurityAlgorithmData,
    EzspStruct,
} from "./struct";

export function deserialize(payload: any, schema: any[]): any[] {
    const result = [];
    let value;
    let data = payload;
    for (const type of schema) {
        [value, data] = type.deserialize(type, data);
        result.push(value);
    }
    return [result, data];
}

export function serialize(data: any[], schema: {serialize: (schema: any, item: any) => Buffer}[]): Buffer {
    return Buffer.concat(schema.map((s, idx) => s.serialize(s, data[idx])));
}

export {
    /* Basic Types */
    int8s,
    uint_t,
    uint8_t,
    uint16_t,
    uint24_t,
    uint32_t,
    uint64_t,
    LVBytes,
    list,
    LVList,
    fixed_list,
    WordList,
    Bytes,
    /* Named Types */
    NcpResetCode,
    EmberRf4ceTxOption,
    EmberRf4ceNodeCapabilities,
    EmberRf4ceApplicationCapabilities,
    EmberNodeId,
    EmberPanId,
    EmberMulticastId,
    EmberEUI64,
    EmberLibraryStatus,
    SecureEzspSecurityType,
    SecureEzspSecurityLevel,
    EmberGpSecurityLevel,
    EmberGpKeyType,
    SecureEzspRandomNumber,
    SecureEzspSessionId,
    Bool,
    EzspConfigId,
    EzspValueId,
    EzspExtendedValueId,
    EzspEndpointFlags,
    EmberConfigTxPowerMode,
    EzspPolicyId,
    EzspDecisionId,
    EzspMfgTokenId,
    EzspStatus,
    EmberStatus,
    SLStatus,
    EmberStackError,
    EmberEventUnits,
    EmberNodeType,
    EmberNetworkStatus,
    EmberIncomingMessageType,
    EmberOutgoingMessageType,
    EmberMacPassthroughType,
    EmberBindingType,
    EmberApsOption,
    EzspNetworkScanType,
    EmberJoinDecision,
    EmberInitialSecurityBitmask,
    EmberCurrentSecurityBitmask,
    EmberKeyType,
    EmberKeyStructBitmask,
    EmberDeviceUpdate,
    EmberKeyStatus,
    EmberCounterType,
    EmberJoinMethod,
    EmberZdoConfigurationFlags,
    EmberConcentratorType,
    EmberZllState,
    EmberZllKeyIndex,
    EzspZllNetworkOperation,
    EzspSourceRouteOverheadInformation,
    EmberNetworkInitBitmask,
    EmberZDOCmd,
    EmberDerivedKeyType,
    /* Structs */
    EzspStruct,
    EmberNetworkParameters,
    EmberZigbeeNetwork,
    EmberApsFrame,
    EmberBindingTableEntry,
    EmberMulticastTableEntry,
    EmberKeyData,
    EmberCertificateData,
    EmberPublicKeyData,
    EmberPrivateKeyData,
    EmberSmacData,
    EmberSignatureData,
    EmberCertificate283k1Data,
    EmberPublicKey283k1Data,
    EmberPrivateKey283k1Data,
    EmberSignature283k1Data,
    EmberMessageDigest,
    EmberAesMmoHashContext,
    EmberNeighborTableEntry,
    EmberRouteTableEntry,
    EmberInitialSecurityState,
    EmberCurrentSecurityState,
    EmberKeyStruct,
    EmberNetworkInitStruct,
    EmberZllSecurityAlgorithmData,
    EmberZllNetwork,
    EmberZllInitialSecurityState,
    EmberZllDeviceInfoRecord,
    EmberZllAddressAssignment,
    EmberTokTypeStackZllData,
    EmberTokTypeStackZllSecurity,
    EmberRf4ceVendorInfo,
    EmberRf4ceApplicationInfo,
    EmberRf4cePairingTableEntry,
    EmberGpAddress,
    EmberGpSinkListEntry,
    EmberNodeDescriptor,
    EmberSimpleDescriptor,
    EmberMultiAddress,
    EmberNeighbors,
    EmberRoutingTable,
    EmberRoutingTableEntry,
    EmberSecurityManagerContext,
    EmberSecurityManagerNetworkKeyInfo,
};
