/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java;

import javax.swing.Icon;
import org.graalvm.visualvm.heapviewer.java.InstanceNodeRenderer;
import org.graalvm.visualvm.heapviewer.java.LocalObjectNode;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.MultiRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;

public class LocalObjectNodeRenderer
extends MultiRenderer
implements HeapViewerRenderer {
    private final LabelRenderer lvRenderer = new LabelRenderer(){

        public String toString() {
            return this.getText() + " ";
        }
    };
    private final InstanceNodeRenderer instanceRenderer;
    private final ProfilerRenderer[] renderers;

    public LocalObjectNodeRenderer(Heap heap) {
        this.lvRenderer.setMargin(3, 3, 3, 1);
        this.instanceRenderer = new InstanceNodeRenderer(heap);
        this.renderers = new ProfilerRenderer[]{this.lvRenderer, this.instanceRenderer};
    }

    protected ProfilerRenderer[] valueRenderers() {
        return this.renderers;
    }

    public void setValue(Object value, int row) {
        this.lvRenderer.setText(((LocalObjectNode)((Object)value)).getLocalObjectName());
        this.instanceRenderer.setValue(value, row);
    }

    @Override
    public Icon getIcon() {
        return this.instanceRenderer.getIcon();
    }

    @Override
    public String getShortName() {
        String name = this.instanceRenderer.getShortName();
        int nameIdx = name.lastIndexOf(91);
        if (nameIdx != -1) {
            name = name.substring(0, nameIdx).trim();
        }
        return name;
    }
}

