/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.math.la;

import java.io.Serializable;
import java.util.Arrays;
import java.util.function.DoubleUnaryOperator;

public interface Tensor
extends Serializable {
    public static int shapeSum(int[] shape) {
        int sum = 1;
        for (int i = 0; i < shape.length; ++i) {
            sum *= shape[i];
        }
        return sum;
    }

    public static boolean shapeCheck(Tensor first, Tensor second) {
        if (first != null && second != null) {
            return Arrays.equals(first.getShape(), second.getShape());
        }
        return false;
    }

    public int[] getShape();

    public Tensor reshape(int[] var1);

    public Tensor copy();

    public void intersectAndAddInPlace(Tensor var1, DoubleUnaryOperator var2);

    default public void intersectAndAddInPlace(Tensor other) {
        this.intersectAndAddInPlace(other, DoubleUnaryOperator.identity());
    }

    public void hadamardProductInPlace(Tensor var1, DoubleUnaryOperator var2);

    default public void hadamardProductInPlace(Tensor other) {
        this.hadamardProductInPlace(other, DoubleUnaryOperator.identity());
    }

    public void foreachInPlace(DoubleUnaryOperator var1);

    default public void scaleInPlace(double coefficient) {
        this.foreachInPlace(d -> d * coefficient);
    }

    default public void scalarAddInPlace(double scalar) {
        this.foreachInPlace(d -> d + scalar);
    }

    public double twoNorm();
}

