/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.transform.transformations;

import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import java.util.Collections;
import java.util.Map;
import org.tribuo.transform.TransformStatistics;
import org.tribuo.transform.Transformation;
import org.tribuo.transform.TransformationProvenance;
import org.tribuo.transform.Transformer;

public class IDFTransformation
implements Transformation {
    private TransformationProvenance provenance;

    @Override
    public TransformStatistics createStats() {
        return new IDFStatistics();
    }

    public TransformationProvenance getProvenance() {
        if (this.provenance == null) {
            this.provenance = new IDFTransformationProvenance();
        }
        return this.provenance;
    }

    public static final class IDFTransformationProvenance
    implements TransformationProvenance {
        private static final long serialVersionUID = 1L;

        IDFTransformationProvenance() {
        }

        public IDFTransformationProvenance(Map<String, Provenance> map) {
        }

        public Map<String, Provenance> getConfiguredParameters() {
            return Collections.emptyMap();
        }

        public String getClassName() {
            return IDFTransformation.class.getName();
        }
    }

    private static class IDFTransformer
    implements Transformer {
        private static final long serialVersionUID = 1L;
        private final double df;
        private final double N;

        public IDFTransformer(int df, int N) {
            this.df = df;
            this.N = N;
        }

        @Override
        public double transform(double tf) {
            return Math.log(this.N / this.df) * (1.0 + Math.log(tf));
        }
    }

    private static class IDFStatistics
    implements TransformStatistics {
        private int df;
        private int sparseObservances;

        private IDFStatistics() {
        }

        @Override
        public void observeValue(double value) {
            ++this.df;
        }

        @Override
        @Deprecated
        public void observeSparse() {
            ++this.sparseObservances;
        }

        @Override
        public void observeSparse(int count) {
            this.sparseObservances = count;
        }

        @Override
        public Transformer generateTransformer() {
            return new IDFTransformer(this.df, this.df + this.sparseObservances);
        }
    }
}

