/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.net.URL;
import javajs.util.PT;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.openscience.jmol.app.jmolpanel.GuiMap;
import org.openscience.jmol.app.jmolpanel.JmolResourceHandler;

public class AboutDialog
extends JDialog
implements HyperlinkListener {
    private JmolViewer vwr;

    public AboutDialog(JFrame fr, JmolViewer vwr) throws IOException {
        super(fr, GT.$("About Jmol"), true);
        this.vwr = vwr;
        JScrollPane scroller = new JScrollPane(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(750, 650);
            }

            @Override
            public float getAlignmentX() {
                return 0.0f;
            }
        };
        JEditorPane html = new JEditorPane();
        html.setContentType("text/html");
        html.setText(PT.rep(GuiMap.getResourceString(this, this.getClass().getClassLoader().getResource(JmolResourceHandler.getStringX("About.aboutURL")).getPath()), "SPLASH", JmolResourceHandler.getImageURL("splash").toString()));
        html.setEditable(false);
        html.addHyperlinkListener(this);
        scroller.getViewport().add(html);
        JPanel htmlWrapper = new JPanel(new BorderLayout());
        htmlWrapper.setAlignmentX(0.0f);
        htmlWrapper.add((Component)scroller, "Center");
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        container.add((Component)htmlWrapper, "Center");
        this.getContentPane().add(container);
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension size = this.getSize();
        this.setLocation(screenSize.width / 2 - size.width / 2, screenSize.height / 2 - size.height / 2);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.linkActivated(e.getURL());
        }
    }

    protected void linkActivated(URL url) {
        this.vwr.showUrl(url.toString());
    }
}

