/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.EditorOnlyDisplayer;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public final class MoveWindowWithinModeAction
extends AbstractAction
implements PropertyChangeListener {
    private final boolean moveLeft;
    private final TopComponent tc;

    private MoveWindowWithinModeAction(boolean bl) {
        this(null, bl);
    }

    private MoveWindowWithinModeAction(TopComponent topComponent, boolean bl) {
        this.moveLeft = bl;
        this.tc = topComponent;
        if (null != topComponent) {
            this.putValue("Name", NbBundle.getMessage(MoveWindowWithinModeAction.class, (String)(bl ? "CTL_MoveWindowLeftContextAction" : "CTL_MoveWindowRightContextAction")));
            if (SwingUtilities.isEventDispatchThread()) {
                this.updateEnabled();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MoveWindowWithinModeAction.this.updateEnabled();
                    }
                });
            }
        } else {
            this.putValue("Name", NbBundle.getMessage(MoveWindowWithinModeAction.class, (String)(bl ? "CTL_MoveWindowLeftAction" : "CTL_MoveWindowRightAction")));
        }
    }

    public static Action createMoveLeft() {
        return new MoveWindowWithinModeAction(null, true);
    }

    public static Action createMoveRight() {
        return new MoveWindowWithinModeAction(null, false);
    }

    static Action createMoveLeft(TopComponent topComponent) {
        return new MoveWindowWithinModeAction(topComponent, true);
    }

    static Action createMoveRight(TopComponent topComponent) {
        return new MoveWindowWithinModeAction(topComponent, false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        TopComponent topComponent;
        if (EditorOnlyDisplayer.getInstance().isActive()) {
            return;
        }
        TopComponent topComponent2 = topComponent = null == this.tc ? TopComponent.getRegistry().getActivated() : this.tc;
        if (null == topComponent) {
            return;
        }
        ModeImpl modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent);
        if (null == modeImpl) {
            return;
        }
        int n = modeImpl.getTopComponentTabPosition(topComponent);
        n = this.moveLeft ? --n : ++n;
        if (n >= 0 && n < modeImpl.getOpenedTopComponents().size()) {
            modeImpl.addOpenedTopComponent(topComponent, n);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("activated".equals(propertyChangeEvent.getPropertyName())) {
            this.updateEnabled();
        }
    }

    private void updateEnabled() {
        if (null == this.tc) {
            return;
        }
        ModeImpl modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(this.tc);
        if (null == modeImpl) {
            return;
        }
        int n = modeImpl.getTopComponentTabPosition(this.tc);
        if (0 == n && this.moveLeft) {
            this.setEnabled(false);
            return;
        }
        if (n == modeImpl.getOpenedTopComponents().size() - 1 && !this.moveLeft) {
            this.setEnabled(false);
            return;
        }
        if (EditorOnlyDisplayer.getInstance().isActive()) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    @Override
    public void putValue(String string, Object object) {
        if ("AcceleratorKey".equals(string)) {
            ActionUtils.putSharedAccelerator(this.moveLeft ? "MoveWindowLeft" : "MoveWindowRight", object);
        } else {
            super.putValue(string, object);
        }
    }

    @Override
    public Object getValue(String string) {
        if ("AcceleratorKey".equals(string)) {
            return ActionUtils.getSharedAccelerator(this.moveLeft ? "MoveWindowLeft" : "MoveWindowRight");
        }
        return super.getValue(string);
    }
}

