/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.CodeSigner;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.TrustAnchor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import org.netbeans.Module;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.autoupdate.services.AutoupdateSettings;
import org.netbeans.modules.autoupdate.services.ExternalFile;
import org.netbeans.modules.autoupdate.services.FeatureUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.InstallManager;
import org.netbeans.modules.autoupdate.services.MessageMultiValidator;
import org.netbeans.modules.autoupdate.services.MessageValidator;
import org.netbeans.modules.autoupdate.services.ModuleUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.OperationContainerImpl;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateManagerImpl;
import org.netbeans.modules.autoupdate.services.UpdateUnitFactory;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.modules.autoupdate.updateprovider.AutoupdateInfoParser;
import org.netbeans.modules.autoupdate.updateprovider.ModuleItem;
import org.netbeans.modules.autoupdate.updateprovider.NetworkAccess;
import org.netbeans.modules.autoupdate.updateprovider.UpdateItemImpl;
import org.netbeans.spi.autoupdate.KeyStoreProvider;
import org.netbeans.spi.autoupdate.UpdateItem;
import org.netbeans.updater.UpdateTracking;
import org.netbeans.updater.UpdaterInternal;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.xml.sax.SAXException;

public class InstallSupportImpl {
    private final InstallSupport support;
    private boolean progressRunning = false;
    private static final Logger LOG = Logger.getLogger(InstallSupportImpl.class.getName());
    private Map<UpdateElementImpl, File> element2Clusters = null;
    private final Set<File> downloadedFiles = new HashSet<File>();
    private Boolean isGlobal;
    private boolean useUserdirAsFallback;
    private int wasDownloaded = 0;
    private Future<Boolean> runningTask;
    private final Object LOCK = new Object();
    private STEP currentStep = STEP.NOTSTARTED;
    private final Collection<UpdateElementImpl> trusted = new ArrayList<UpdateElementImpl>();
    private final Collection<UpdateElementImpl> signedVerified = new ArrayList<UpdateElementImpl>();
    private final Collection<UpdateElementImpl> signedUnverified = new ArrayList<UpdateElementImpl>();
    private final Collection<UpdateElementImpl> modified = new ArrayList<UpdateElementImpl>();
    private final Map<UpdateElement, Collection<Certificate>> certs = new HashMap<UpdateElement, Collection<Certificate>>();
    private List<? extends OperationContainer.OperationInfo> infos = null;
    private ExecutorService es = null;
    private Set<ModuleUpdateElementImpl> affectedModuleImpls = null;
    private Set<FeatureUpdateElementImpl> affectedFeatureImpls = null;

    public InstallSupportImpl(InstallSupport installSupport) {
        this.support = installSupport;
    }

    public boolean doDownload(final ProgressHandle progressHandle, final Boolean bl, final boolean bl2) throws OperationException {
        this.isGlobal = bl;
        this.useUserdirAsFallback = bl2;
        if (progressHandle != null) {
            progressHandle.start();
            progressHandle.progress(NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_Download_Estabilish"));
            this.progressRunning = false;
        }
        Callable<Boolean> callable = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                OperationContainer<InstallSupport> operationContainer = InstallSupportImpl.this.support.getContainer();
                assert (operationContainer.listInvalid().isEmpty()) : InstallSupportImpl.access$000(InstallSupportImpl.this) + ".listInvalid().isEmpty() but " + operationContainer.listInvalid() + " container: " + operationContainer;
                Object object = InstallSupportImpl.this.LOCK;
                synchronized (object) {
                    InstallSupportImpl.this.currentStep = STEP.DOWNLOAD;
                }
                InstallSupportImpl.this.infos = operationContainer.listAll();
                int n = 0;
                for (OperationContainer.OperationInfo operationInfo : InstallSupportImpl.this.infos) {
                    UpdateElement updateElement = operationInfo.getUpdateElement();
                    InstallManager.findTargetDirectory(updateElement.getUpdateUnit().getInstalled(), Trampoline.API.impl(updateElement), bl, bl2);
                    n += updateElement.getDownloadSize();
                }
                int n2 = 0;
                try {
                    long l = System.currentTimeMillis();
                    for (OperationContainer.OperationInfo operationInfo : InstallSupportImpl.this.infos) {
                        if (InstallSupportImpl.this.cancelled()) {
                            LOG.log(Level.INFO, "InstallSupport.doDownload was canceled");
                            Boolean bl3 = false;
                            return bl3;
                        }
                        int n3 = InstallSupportImpl.this.doDownload(operationInfo, progressHandle, n2, n, l);
                        if (n3 == -1) {
                            Boolean bl4 = false;
                            return bl4;
                        }
                        n2 += n3;
                    }
                    InstallSupportImpl.this.postDownload(l);
                }
                finally {
                    if (progressHandle != null) {
                        progressHandle.progress("");
                        progressHandle.finish();
                    }
                }
                assert (n == n2) : "Was downloaded " + n2 + ", planned was " + n;
                InstallSupportImpl.this.wasDownloaded = n2;
                return true;
            }
        };
        boolean bl3 = false;
        try {
            this.runningTask = this.getExecutionService().submit(callable);
            bl3 = this.runningTask.get();
        }
        catch (CancellationException cancellationException) {
            LOG.log(Level.FINE, "InstallSupport.doDownload was cancelled", cancellationException);
            return false;
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            if (!(executionException.getCause() instanceof OperationException)) {
                Exceptions.printStackTrace((Throwable)executionException);
            }
            throw (OperationException)executionException.getCause();
        }
        return bl3;
    }

    private void postDownload(long l) {
        for (File file : UpdateTracking.clusters(true)) {
            File file2 = new File(file, Utilities.RUNNING_DOWNLOAD_DIR + '_' + l);
            if (!file2.isDirectory()) continue;
            File file3 = new File(file, Utilities.DOWNLOAD_DIR);
            file3.mkdirs();
            for (String string : file2.list()) {
                boolean bl;
                File file4 = new File(file2, string);
                File file5 = new File(file3, string);
                if (file5.exists()) {
                    file5.delete();
                }
                if (bl = file4.renameTo(file5)) continue;
                LOG.log(Level.WARNING, "{0} didn''t move to {1}", new Object[]{file4, file5});
            }
            file2.delete();
        }
    }

    public boolean doValidate(InstallSupport.Validator validator, final ProgressHandle progressHandle) throws OperationException {
        assert (validator != null);
        Callable<Boolean> callable = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                OperationContainer<InstallSupport> operationContainer = InstallSupportImpl.this.LOCK;
                synchronized (operationContainer) {
                    assert (InstallSupportImpl.this.currentStep != STEP.FINISHED);
                    if (InstallSupportImpl.this.currentStep == STEP.CANCEL) {
                        return false;
                    }
                    InstallSupportImpl.this.currentStep = STEP.VALIDATION;
                }
                operationContainer = InstallSupportImpl.this.support.getContainer();
                assert (operationContainer.listInvalid().isEmpty()) : InstallSupportImpl.access$000(InstallSupportImpl.this) + ".listInvalid().isEmpty() but " + operationContainer.listInvalid() + "\ncontainer: " + operationContainer;
                if (progressHandle != null) {
                    progressHandle.start(InstallSupportImpl.this.wasDownloaded);
                }
                int n = 0;
                try {
                    for (OperationContainer.OperationInfo operationInfo : InstallSupportImpl.this.infos) {
                        boolean bl;
                        Object object;
                        if (InstallSupportImpl.this.cancelled()) {
                            object = false;
                            return object;
                        }
                        object = Trampoline.API.impl(operationInfo.getUpdateElement());
                        boolean bl2 = bl = ((UpdateElementImpl)object).getInstallInfo().getCustomInstaller() != null;
                        if (bl) {
                            assert (false) : "InstallSupportImpl cannot support CustomInstaller!";
                            continue;
                        }
                        n += InstallSupportImpl.this.doValidate(operationInfo, progressHandle, n);
                    }
                }
                finally {
                    if (progressHandle != null) {
                        progressHandle.progress("");
                        progressHandle.finish();
                    }
                }
                return true;
            }
        };
        boolean bl = false;
        try {
            this.runningTask = this.getExecutionService().submit(callable);
            bl = this.runningTask.get();
        }
        catch (CancellationException cancellationException) {
            LOG.log(Level.FINE, "InstallSupport.doValidate was cancelled", cancellationException);
            return false;
        }
        catch (InterruptedException interruptedException) {
            if (interruptedException.getCause() instanceof OperationException) {
                throw (OperationException)interruptedException.getCause();
            }
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof SecurityException) {
                throw new OperationException(OperationException.ERROR_TYPE.MODIFIED, executionException.getLocalizedMessage());
            }
            if (executionException.getCause() instanceof OperationException) {
                throw (OperationException)executionException.getCause();
            }
            Exceptions.printStackTrace((Throwable)executionException);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean doInstall(InstallSupport.Installer installer, final ProgressHandle progressHandle, final boolean bl) throws OperationException {
        assert (installer != null);
        Callable<Boolean> callable = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public Boolean call() throws Exception {
                Boolean bl3;
                boolean bl2;
                block49: {
                    Object object;
                    File file;
                    Object object2;
                    Iterator iterator = InstallSupportImpl.this.LOCK;
                    // MONITORENTER : iterator
                    assert (InstallSupportImpl.this.currentStep != STEP.FINISHED) : (Object)((Object)InstallSupportImpl.access$200(InstallSupportImpl.this)) + " != STEP.FINISHED";
                    if (InstallSupportImpl.this.currentStep == STEP.CANCEL) {
                        // MONITOREXIT : iterator
                        return false;
                    }
                    InstallSupportImpl.this.currentStep = STEP.INSTALLATION;
                    // MONITOREXIT : iterator
                    assert (InstallSupportImpl.this.support.getContainer().listInvalid().isEmpty()) : InstallSupportImpl.access$000(InstallSupportImpl.this) + ".listInvalid().isEmpty() but " + InstallSupportImpl.access$000(InstallSupportImpl.this).getContainer().listInvalid();
                    InstallSupportImpl.this.addTrustedCertificates();
                    InstallSupportImpl.this.affectedModuleImpls = new HashSet();
                    InstallSupportImpl.this.affectedFeatureImpls = new HashSet();
                    if (progressHandle != null) {
                        progressHandle.start();
                    }
                    block28: for (Object object3 : InstallSupportImpl.this.infos) {
                        object2 = Trampoline.API.impl(((OperationContainer.OperationInfo)object3).getUpdateElement());
                        switch (((UpdateElementImpl)object2).getType()) {
                            case KIT_MODULE: 
                            case MODULE: {
                                InstallSupportImpl.this.affectedModuleImpls.add((ModuleUpdateElementImpl)object2);
                                continue block28;
                            }
                            case STANDALONE_MODULE: 
                            case FEATURE: {
                                InstallSupportImpl.this.affectedFeatureImpls.add((FeatureUpdateElementImpl)object2);
                                InstallSupportImpl.this.affectedModuleImpls.addAll(((FeatureUpdateElementImpl)object2).getContainedModuleElements());
                                continue block28;
                            }
                        }
                        assert (false) : "Unsupported type " + object2;
                    }
                    bl2 = false;
                    object2 = new ArrayList();
                    for (Iterator iterator2 : InstallSupportImpl.this.affectedModuleImpls) {
                        Object object3;
                        Object object4 = InstallSupportImpl.this.LOCK;
                        // MONITORENTER : object4
                        if (InstallSupportImpl.this.currentStep == STEP.CANCEL) {
                            if (progressHandle != null) {
                                progressHandle.finish();
                            }
                            // MONITOREXIT : object4
                            return false;
                        }
                        // MONITOREXIT : object4
                        if (Utilities.isElementInstalled(((UpdateElementImpl)((Object)iterator2)).getUpdateElement())) continue;
                        object4 = ((UpdateElementImpl)((Object)iterator2)).getUpdateUnit().getInstalled();
                        object3 = InstallSupportImpl.this.getTargetCluster((UpdateElement)object4, (UpdateElementImpl)((Object)iterator2), InstallSupportImpl.this.isGlobal, InstallSupportImpl.this.useUserdirAsFallback);
                        URL uRL = ((ModuleUpdateElementImpl)((Object)iterator2)).getInstallInfo().getDistribution();
                        LOG.log(Level.FINE, "Source URL for " + ((ModuleUpdateElementImpl)((Object)iterator2)).getCodeName() + " is " + uRL);
                        file = InstallSupportImpl.getDestination((File)object3, ((ModuleUpdateElementImpl)((Object)iterator2)).getCodeName(), uRL, 0L);
                        assert (file != null) : "Destination file exists for " + iterator2 + " in " + object3;
                        object = new JarFile(file);
                        try {
                            for (JarEntry jarEntry : Collections.list(((JarFile)object).entries())) {
                                if (!"netbeans/modules/ext/updater.jar".equals(jarEntry.toString()) && !jarEntry.toString().matches("netbeans/modules/ext/locale/updater(_[a-zA-Z0-9]+)+")) continue;
                                LOG.log(Level.INFO, jarEntry.toString() + " is being installed from " + ((ModuleUpdateElementImpl)((Object)iterator2)).getCodeName());
                                object2.add(new UpdaterInfo(jarEntry, file, (File)object3));
                                bl2 = true;
                            }
                        }
                        finally {
                            ((ZipFile)object).close();
                        }
                        bl2 |= InstallSupportImpl.this.needsRestart(object4 != null, iterator2, file);
                    }
                    try {
                        Iterator iterator2;
                        Utilities.writeAdditionalInformation(InstallSupportImpl.this.getElement2Clusters());
                        for (int i = 0; i < object2.size(); ++i) {
                            iterator2 = (UpdaterInfo)object2.get(i);
                            try {
                                Utilities.writeUpdateOfUpdaterJar(((UpdaterInfo)((Object)iterator2)).getUpdaterJarEntry(), ((UpdaterInfo)((Object)iterator2)).getZipFileWithUpdater(), ((UpdaterInfo)((Object)iterator2)).getUpdaterTargetCluster());
                                continue;
                            }
                            catch (IOException iOException) {
                                LOG.log(Level.INFO, "Cannot open or close jar file {0}", ((UpdaterInfo)((Object)iterator2)).getZipFileWithUpdater());
                            }
                        }
                        if (bl2 && !bl) break block49;
                        final HashSet hashSet = InstallSupportImpl.this.LOCK;
                        // MONITORENTER : hashSet
                        if (InstallSupportImpl.this.currentStep == STEP.CANCEL) {
                            if (progressHandle != null) {
                                progressHandle.finish();
                            }
                            iterator2 = false;
                            // MONITOREXIT : hashSet
                            return iterator2;
                        }
                        // MONITOREXIT : hashSet
                        if (progressHandle != null) {
                            progressHandle.switchToDeterminate(InstallSupportImpl.this.affectedModuleImpls.size());
                        }
                        iterator2 = InstallSupportImpl.this.downloadedFiles;
                        // MONITORENTER : iterator2
                        hashSet = new HashSet(InstallSupportImpl.this.downloadedFiles);
                        // MONITOREXIT : iterator2
                        if (!hashSet.isEmpty()) {
                            try {
                                FileUtil.runAtomicAction((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            UpdaterInternal.update(hashSet, new RefreshModulesListener(progressHandle), NbBundle.getBranding());
                                        }
                                        catch (InterruptedException interruptedException) {
                                            LOG.log(Level.INFO, interruptedException.getMessage(), interruptedException);
                                        }
                                    }
                                });
                                for (Object object4 : InstallSupportImpl.this.affectedModuleImpls) {
                                    int n;
                                    file = Utilities.toModule(((ModuleUpdateElementImpl)object4).getCodeName(), ((ModuleUpdateElementImpl)object4).getSpecificationVersion());
                                    for (n = 0; n < 100 && file == null; ++n) {
                                        LOG.log(Level.FINE, "Waiting for {0}@{1} #{2}", new Object[]{((ModuleUpdateElementImpl)object4).getCodeName(), ((ModuleUpdateElementImpl)object4).getSpecificationVersion(), n});
                                        Thread.sleep(100L);
                                        file = Utilities.toModule(((ModuleUpdateElementImpl)object4).getCodeName(), ((ModuleUpdateElementImpl)object4).getSpecificationVersion());
                                    }
                                    if (n != 100) continue;
                                    LOG.log(Level.INFO, "Timeout waiting for loading module {0}@{1}", new Object[]{((ModuleUpdateElementImpl)object4).getCodeName(), ((ModuleUpdateElementImpl)object4).getSpecificationVersion()});
                                    InstallSupportImpl.this.afterInstall();
                                    object = InstallSupportImpl.this.downloadedFiles;
                                    // MONITORENTER : object
                                    InstallSupportImpl.this.downloadedFiles.clear();
                                    // MONITOREXIT : object
                                    throw new OperationException(OperationException.ERROR_TYPE.INSTALL, NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_TurnOnTimeout", (Object)((UpdateElementImpl)object4).getUpdateElement()));
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                LOG.log(Level.INFO, interruptedException.getMessage(), interruptedException);
                            }
                        }
                        InstallSupportImpl.this.afterInstall();
                        iterator2 = InstallSupportImpl.this.downloadedFiles;
                        // MONITORENTER : iterator2
                        InstallSupportImpl.this.downloadedFiles.clear();
                        // MONITOREXIT : iterator2
                    }
                    finally {
                        if (progressHandle != null) {
                            progressHandle.progress("");
                            progressHandle.finish();
                        }
                    }
                }
                if (bl2 && !bl) {
                    bl3 = Boolean.TRUE;
                    return bl3;
                }
                bl3 = Boolean.FALSE;
                return bl3;
            }
        };
        boolean bl2 = false;
        try {
            this.runningTask = this.getExecutionService().submit(callable);
            bl2 = this.runningTask.get();
        }
        catch (CancellationException cancellationException) {
            LOG.log(Level.FINE, "InstallSupport.doInstall was cancelled", cancellationException);
            Boolean bl3 = false;
            return bl3;
        }
        catch (InterruptedException interruptedException) {
            LOG.log(Level.INFO, interruptedException.getLocalizedMessage(), interruptedException);
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof OperationException) {
                throw (OperationException)executionException.getCause();
            }
            LOG.log(Level.INFO, executionException.getLocalizedMessage(), executionException);
        }
        finally {
            if (!bl2) {
                this.getElement2Clusters().clear();
            }
        }
        return bl2;
    }

    private void afterInstall() {
        UpdateElement updateElement;
        UpdateUnit updateUnit;
        if (this.affectedModuleImpls != null) {
            for (ModuleUpdateElementImpl updateElementImpl : this.affectedModuleImpls) {
                updateUnit = updateElementImpl.getUpdateUnit();
                updateElement = updateElementImpl.getUpdateElement();
                Trampoline.API.impl(updateUnit).updateInstalled(updateElement);
            }
            this.affectedModuleImpls = null;
        }
        if (this.affectedFeatureImpls != null) {
            for (FeatureUpdateElementImpl featureUpdateElementImpl : this.affectedFeatureImpls) {
                updateUnit = featureUpdateElementImpl.getUpdateUnit();
                updateElement = featureUpdateElementImpl.getUpdateElement();
                Trampoline.API.impl(updateUnit).updateInstalled(updateElement);
            }
            this.affectedFeatureImpls = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progressHandle) throws OperationException {
        Object object = this.LOCK;
        synchronized (object) {
            assert (this.currentStep != STEP.FINISHED);
            this.currentStep = STEP.RESTART;
        }
        Utilities.deleteAllDoLater();
        this.getElement2Clusters().clear();
        LifecycleManager.getDefault().exit();
        this.doRestartLater(restarter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRestartLater(OperationSupport.Restarter restarter) {
        if (this.affectedModuleImpls != null) {
            for (ModuleUpdateElementImpl moduleUpdateElementImpl : this.affectedModuleImpls) {
                UpdateUnitFactory.getDefault().scheduleForRestart(moduleUpdateElementImpl.getUpdateElement());
            }
        }
        Utilities.writeInstallLater(new HashMap<UpdateElementImpl, File>(this.getElement2Clusters()));
        this.getElement2Clusters().clear();
        Set<File> set = this.downloadedFiles;
        synchronized (set) {
            this.downloadedFiles.clear();
        }
    }

    public String getCertificate(InstallSupport.Installer installer, UpdateElement updateElement) {
        Collection<Certificate> collection = this.certs.get(updateElement);
        if (collection != null) {
            String string = "";
            for (Certificate certificate : collection) {
                string = string + certificate;
            }
            return string;
        }
        return null;
    }

    public boolean isTrusted(InstallSupport.Installer installer, UpdateElement updateElement) {
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        return this.checkUpdateElement(updateElementImpl, this.trusted);
    }

    public boolean isSignedVerified(InstallSupport.Installer installer, UpdateElement updateElement) {
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        return this.checkUpdateElement(updateElementImpl, this.signedVerified);
    }

    public boolean isSignedUnverified(InstallSupport.Installer installer, UpdateElement updateElement) {
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        return this.checkUpdateElement(updateElementImpl, this.signedUnverified);
    }

    public boolean isContentModified(InstallSupport.Installer installer, UpdateElement updateElement) {
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        return this.checkUpdateElement(updateElementImpl, this.modified);
    }

    private boolean checkUpdateElement(UpdateElementImpl updateElementImpl, Collection<UpdateElementImpl> collection) {
        boolean bl = false;
        switch (updateElementImpl.getType()) {
            case KIT_MODULE: 
            case MODULE: {
                bl = collection.contains(updateElementImpl);
                break;
            }
            case STANDALONE_MODULE: 
            case FEATURE: {
                FeatureUpdateElementImpl featureUpdateElementImpl = (FeatureUpdateElementImpl)updateElementImpl;
                Set<ModuleUpdateElementImpl> set = featureUpdateElementImpl.getContainedModuleElements();
                bl = !set.isEmpty();
                for (ModuleUpdateElementImpl moduleUpdateElementImpl : set) {
                    if (Utilities.isElementInstalled(moduleUpdateElementImpl.getUpdateElement())) continue;
                    bl &= collection.contains(moduleUpdateElementImpl);
                }
                break;
            }
            default: {
                assert (false) : "Unsupported type " + updateElementImpl;
                break;
            }
        }
        return bl;
    }

    private void addTrustedCertificates() {
        HashSet<UpdateElementImpl> hashSet = new HashSet<UpdateElementImpl>(this.signedVerified);
        hashSet.removeAll(this.trusted);
        if (hashSet.isEmpty()) {
            return;
        }
        HashSet<Certificate> hashSet2 = new HashSet<Certificate>();
        for (UpdateElementImpl updateElementImpl : hashSet) {
            hashSet2.addAll(this.certs.get(updateElementImpl.getUpdateElement()));
        }
        if (!hashSet2.isEmpty()) {
            Utilities.addCertificates(hashSet2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCancel() throws OperationException {
        Object object = this.LOCK;
        synchronized (object) {
            this.currentStep = STEP.CANCEL;
        }
        if (this.runningTask != null && !this.runningTask.isDone() && !this.runningTask.isCancelled()) {
            boolean bl = this.runningTask.cancel(true);
            assert (bl) : this.runningTask + " was cancelled.";
        }
        Set<File> set = this.downloadedFiles;
        synchronized (set) {
            for (File file : this.downloadedFiles) {
                if (file == null || !file.exists()) continue;
                file.delete();
                if (!file.getParentFile().isDirectory() || file.getParentFile().list() == null || file.getParentFile().list().length != 0) continue;
                file.getParentFile().delete();
            }
            this.downloadedFiles.clear();
        }
        Utilities.cleanUpdateOfUpdaterJar();
        if (this.affectedFeatureImpls != null) {
            this.affectedFeatureImpls = null;
        }
        if (this.affectedModuleImpls != null) {
            this.affectedModuleImpls = null;
        }
        this.getElement2Clusters().clear();
    }

    private int doDownload(OperationContainer.OperationInfo operationInfo, ProgressHandle progressHandle, int n, int n2, long l) throws OperationException {
        UpdateElement updateElement = operationInfo.getUpdateElement();
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        int n3 = 0;
        switch (updateElementImpl.getType()) {
            case KIT_MODULE: 
            case MODULE: {
                n3 += this.doDownload(updateElementImpl, progressHandle, n, n2, l);
                break;
            }
            case STANDALONE_MODULE: 
            case FEATURE: {
                FeatureUpdateElementImpl featureUpdateElementImpl = (FeatureUpdateElementImpl)updateElementImpl;
                Set<ModuleUpdateElementImpl> set = featureUpdateElementImpl.getContainedModuleElements();
                int n4 = n;
                for (ModuleUpdateElementImpl moduleUpdateElementImpl : set) {
                    if (Utilities.isElementInstalled(moduleUpdateElementImpl.getUpdateElement())) continue;
                    int n5 = this.doDownload(moduleUpdateElementImpl, progressHandle, n4, n2, l);
                    if (n5 == -1) {
                        return -1;
                    }
                    n4 += n5;
                    n3 += n5;
                }
                break;
            }
            default: {
                assert (false) : "Unsupported type " + updateElementImpl;
                break;
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doDownload(UpdateElementImpl updateElementImpl, ProgressHandle progressHandle, int n, int n2, long l) throws OperationException {
        if (this.cancelled()) {
            LOG.log(Level.INFO, "InstallSupport.doDownload was canceled, returns -1");
            return -1;
        }
        UpdateElement updateElement = updateElementImpl.getUpdateUnit().getInstalled();
        File file = this.getTargetCluster(updateElement, updateElementImpl, this.isGlobal, this.useUserdirAsFallback);
        assert (file != null) : "Target cluster for " + updateElementImpl + " must exist.";
        if (file == null) {
            file = InstallManager.getUserDir();
        }
        URL uRL = updateElementImpl.getInstallInfo().getDistribution();
        LOG.log(Level.FINE, "Source URL for " + updateElementImpl.getCodeName() + " is " + uRL);
        if (uRL == null) {
            String string = NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_NullSource", (Object)updateElementImpl.getCodeName());
            LOG.log(Level.INFO, string);
            throw new OperationException(OperationException.ERROR_TYPE.INSTALL, string);
        }
        File file2 = InstallSupportImpl.getDestination(file, updateElementImpl.getCodeName(), uRL, l);
        if (file2.exists()) {
            LOG.log(Level.FINE, "Target NBM file " + file2 + " of " + updateElementImpl.getUpdateElement() + " already downloaded.");
            return updateElementImpl.getDownloadSize();
        }
        try {
            String string = updateElementImpl.getDisplayName();
            File file3 = FileUtil.normalizeFile((File)InstallSupportImpl.getDestination(file, updateElementImpl.getCodeName(), uRL, 0L));
            File file4 = FileUtil.normalizeFile((File)InstallSupportImpl.getDestination(file, updateElementImpl.getCodeName(), uRL, l));
            Set<File> set = this.downloadedFiles;
            synchronized (set) {
                this.downloadedFiles.add(file3);
                this.downloadedFiles.add(file4);
            }
            int n3 = this.copy(uRL, file2, progressHandle, updateElementImpl.getDownloadSize(), n, n2, string);
            boolean bl = false;
            try (JarFile jarFile = new JarFile(file2);){
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    ExternalFile externalFile;
                    JarEntry jarEntry = enumeration.nextElement();
                    if (!jarEntry.getName().endsWith(".external")) continue;
                    Object object = jarFile.getInputStream(jarEntry);
                    Serializable serializable = null;
                    try {
                        externalFile = ExternalFile.fromStream(jarEntry.getName(), (InputStream)object);
                    }
                    catch (Throwable throwable) {
                        serializable = throwable;
                        throw throwable;
                    }
                    finally {
                        if (object != null) {
                            if (serializable != null) {
                                try {
                                    ((InputStream)object).close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)serializable).addSuppressed(throwable);
                                }
                            } else {
                                ((InputStream)object).close();
                            }
                        }
                    }
                    if (externalFile.getCrc32() == null) {
                        throw new IOException(jarEntry.getName() + " does not contain CRC: line!");
                    }
                    object = externalFile.getValidator();
                    serializable = new File(file2.getPath() + "." + Long.toHexString(externalFile.getCrc32()));
                    Object object2 = InstallSupportImpl.externalDownload(externalFile);
                    Set<File> set2 = null;
                    try (FileOutputStream throwable = new FileOutputStream((File)serializable);){
                        int n4;
                        byte[] byArray = new byte[4096];
                        while ((n4 = ((InputStream)object2).read(byArray)) != -1) {
                            ((MessageMultiValidator)object).update(byArray, 0, n4);
                            throwable.write(byArray, 0, n4);
                            if (!this.progressRunning || (n3 += n4) > updateElementImpl.getDownloadSize()) continue;
                            progressHandle.progress(n + n3);
                        }
                    }
                    catch (Throwable throwable2) {
                        set2 = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (object2 != null) {
                            if (set2 != null) {
                                try {
                                    ((InputStream)object2).close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)((Object)set2)).addSuppressed(throwable3);
                                }
                            } else {
                                ((InputStream)object2).close();
                            }
                        }
                    }
                    if (((MessageMultiValidator)object).isValid()) continue;
                    object2 = new ArrayList();
                    for (MessageValidator messageValidator : ((MessageMultiValidator)object).getValidators()) {
                        if (!messageValidator.isValid()) {
                            object2.add(messageValidator.getName());
                        }
                        LOG.log(Level.INFO, "Deleting file with invalid check {0}, expected {1}, got {2}: {3}", new Object[]{messageValidator.getName(), messageValidator.getExpectedValueAsString(), messageValidator.getRealValueAsString(), file3});
                    }
                    file2.delete();
                    set2 = this.downloadedFiles;
                    synchronized (set2) {
                        this.downloadedFiles.remove(file3);
                    }
                    ((File)serializable).delete();
                    throw new IOException("Failed checks " + object2.toString() + " for " + jarEntry.getName());
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                LOG.log(Level.INFO, fileNotFoundException.getMessage(), fileNotFoundException);
                bl = true;
                throw new OperationException(OperationException.ERROR_TYPE.INSTALL, fileNotFoundException.getLocalizedMessage());
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, iOException.getMessage(), iOException);
                bl = true;
                throw new OperationException(OperationException.ERROR_TYPE.PROXY, iOException.getLocalizedMessage());
            }
            finally {
                if (bl) {
                    file2.delete();
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            LOG.log(Level.INFO, unknownHostException.getMessage(), unknownHostException);
            throw new OperationException(OperationException.ERROR_TYPE.PROXY, uRL.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOG.log(Level.INFO, fileNotFoundException.getMessage(), fileNotFoundException);
            throw new OperationException(OperationException.ERROR_TYPE.INSTALL, fileNotFoundException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, iOException.getMessage(), iOException);
            throw new OperationException(OperationException.ERROR_TYPE.PROXY, uRL.toString());
        }
        return updateElementImpl.getDownloadSize();
    }

    private int doValidate(OperationContainer.OperationInfo operationInfo, ProgressHandle progressHandle, int n) throws OperationException {
        UpdateElement updateElement = operationInfo.getUpdateElement();
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        int n2 = 0;
        switch (updateElementImpl.getType()) {
            case KIT_MODULE: 
            case MODULE: {
                n2 = this.doValidate(updateElementImpl, progressHandle, n);
                break;
            }
            case STANDALONE_MODULE: 
            case FEATURE: {
                FeatureUpdateElementImpl featureUpdateElementImpl = (FeatureUpdateElementImpl)updateElementImpl;
                Set<ModuleUpdateElementImpl> set = featureUpdateElementImpl.getContainedModuleElements();
                int n3 = n;
                for (ModuleUpdateElementImpl moduleUpdateElementImpl : set) {
                    if (Utilities.isElementInstalled(moduleUpdateElementImpl.getUpdateElement())) continue;
                    int n4 = this.doValidate(moduleUpdateElementImpl, progressHandle, n3);
                    n3 += n4;
                    n2 += n4;
                }
                break;
            }
            default: {
                assert (false) : "Unsupported type " + updateElementImpl;
                break;
            }
        }
        return n2;
    }

    private int doValidate(UpdateElementImpl updateElementImpl, ProgressHandle progressHandle, int n) throws OperationException {
        UpdateElement updateElement = updateElementImpl.getUpdateUnit().getInstalled();
        File file = this.getTargetCluster(updateElement, updateElementImpl, this.isGlobal, this.useUserdirAsFallback);
        URL uRL = updateElementImpl.getInstallInfo().getDistribution();
        File file2 = InstallSupportImpl.getDestination(file, updateElementImpl.getCodeName(), uRL, 0L);
        if (!file2.exists()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Cannot find ").append(file2).append("\n");
            stringBuilder.append("Parent directory contains:").append(Arrays.toString(file2.getParentFile().list())).append("\n");
            for (File file3 : UpdateTracking.clusters(true)) {
                stringBuilder.append("Trying to find result in ").append(file3).append(" = ");
                File file4 = InstallSupportImpl.getDestination(file, updateElementImpl.getCodeName(), uRL, 0L);
                stringBuilder.append(file4).append(" exists ").append(file4.exists()).append("\n");
            }
            throw new OperationException(OperationException.ERROR_TYPE.INSTALL, stringBuilder.toString());
        }
        int n2 = this.verifyNbm(updateElementImpl.getUpdateElement(), file2, progressHandle, n);
        return n2;
    }

    public static File getDestination(File file, String string, URL uRL) {
        return InstallSupportImpl.getDestination(file, string, uRL, 0L);
    }

    private static File getDestination(File file, String string, URL uRL, long l) {
        LOG.log(Level.FINE, "Target cluster for " + string + " is " + file);
        File file2 = new File(file, 0L == l ? Utilities.DOWNLOAD_DIR : Utilities.RUNNING_DOWNLOAD_DIR + '_' + l);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        String string2 = string.replace('.', '-');
        String string3 = uRL.getFile().toLowerCase(Locale.US);
        String string4 = string3.endsWith(".nbm".toLowerCase(Locale.US)) ? ".nbm" : (string3.endsWith(".jar".toLowerCase(Locale.US)) ? ".jar" : "");
        File file3 = new File(file2, string2 + string4);
        LOG.log(Level.FINE, "Destination file for " + string + " is " + file3);
        return file3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cancelled() {
        InstallSupportImpl installSupportImpl = this;
        synchronized (installSupportImpl) {
            return STEP.CANCEL == this.currentStep;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copy(URL uRL, File file, ProgressHandle progressHandle, int n, int n2, int n3, String string) throws MalformedURLException, IOException {
        Object object;
        OpenConnectionListener openConnectionListener = new OpenConnectionListener(uRL);
        final NetworkAccess.Task task = NetworkAccess.createNetworkAccessTask(uRL, AutoupdateSettings.getOpenConnectionTimeout(), openConnectionListener, false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (!task.isFinished()) {
                    if (InstallSupportImpl.this.cancelled()) {
                        task.cancel();
                        break;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }).start();
        task.waitFinished();
        try {
            if (openConnectionListener.getException() != null) {
                throw openConnectionListener.getException();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOG.log(Level.INFO, fileNotFoundException.getMessage(), fileNotFoundException);
            throw new IOException(NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_Download_Unavailable", (Object)uRL));
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, iOException.getMessage(), iOException);
            throw new IOException(NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_Download_Unavailable", (Object)uRL));
        }
        catch (Exception exception) {
            LOG.log(Level.INFO, exception.getMessage(), exception);
            throw new IOException(NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_Download_Unavailable", (Object)uRL));
        }
        if (this.cancelled()) {
            LOG.log(Level.FINE, "Download of " + uRL + " was cancelled");
            throw new IOException("Download of " + uRL + " was cancelled");
        }
        InputStream inputStream = openConnectionListener.getInputStream();
        int n4 = openConnectionListener.getContentLength();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = null;
        LOG.log(Level.FINEST, "Copy " + uRL + " to " + file + "[" + n + "]");
        boolean bl = false;
        int n5 = 0;
        try {
            int n6;
            object = new byte[1024];
            int n7 = 0;
            while (!(bl = this.cancelled()) && (n6 = bufferedInputStream.read((byte[])object)) != -1) {
                if (bufferedOutputStream == null) {
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                }
                bufferedOutputStream.write((byte[])object, 0, n6);
                n5 += n6;
                n7 += n6;
                if (!this.progressRunning && progressHandle != null) {
                    progressHandle.switchToDeterminate(n3);
                    progressHandle.progress(string);
                    this.progressRunning = true;
                }
                if (n7 <= 1024) continue;
                if (progressHandle != null) {
                    assert (this.progressRunning);
                    progressHandle.switchToDeterminate(n3);
                    int n8 = n2 + (n5 < n ? n5 : n);
                    progressHandle.progress(string, n8 < n3 ? n8 : n3);
                }
                n7 = 0;
            }
            if (n != n5) {
                LOG.log(Level.FINEST, "Increment (" + n5 + ") of is not equal to estimatedSize (" + n + ").");
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "Writing content of URL " + uRL + " failed.", iOException);
        }
        finally {
            try {
                bufferedInputStream.close();
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.flush();
                }
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.close();
                }
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, iOException.getMessage(), iOException);
            }
        }
        if (n4 != -1 && n5 != n4) {
            if (bl) {
                LOG.log(Level.INFO, "Download of " + uRL + " was cancelled");
            } else {
                LOG.log(Level.INFO, "Content length was reported as " + n4 + " byte(s) but read " + n5 + " byte(s)");
            }
            if (bufferedOutputStream != null && file.exists()) {
                LOG.log(Level.INFO, "Deleting not fully downloaded file " + file);
                file.delete();
                object = FileUtil.normalizeFile((File)file);
                Set<File> set = this.downloadedFiles;
                synchronized (set) {
                    this.downloadedFiles.remove(object);
                }
            }
            if (bl) {
                throw new IOException("Download of " + uRL + " was cancelled");
            }
            throw new IOException("Server closed connection unexpectedly");
        }
        LOG.log(Level.FINE, "Destination " + file + " is successfully wrote. Size " + file.length());
        return n5;
    }

    private int verifyNbm(UpdateElement updateElement, File file, ProgressHandle progressHandle, int n) throws OperationException {
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        this.modified.remove(updateElementImpl);
        this.trusted.remove(updateElementImpl);
        this.signedVerified.remove(updateElementImpl);
        this.signedUnverified.remove(updateElementImpl);
        Object object = null;
        try {
            OperationContainer<InstallSupport> operationContainer;
            OperationContainerImpl operationContainerImpl;
            List<String> list;
            HashSet<Certificate> hashSet = new HashSet<Certificate>();
            HashSet<Certificate> hashSet2 = new HashSet<Certificate>();
            HashSet<TrustAnchor> hashSet3 = new HashSet<TrustAnchor>();
            HashSet<TrustAnchor> hashSet4 = new HashSet<TrustAnchor>();
            for (KeyStore list2 : Utilities.getKeyStore(KeyStoreProvider.TrustLevel.TRUST)) {
                hashSet.addAll(Utilities.getCertificates(list2));
            }
            for (KeyStore keyStore : Utilities.getKeyStore(KeyStoreProvider.TrustLevel.VALIDATE)) {
                hashSet2.addAll(Utilities.getCertificates(keyStore));
            }
            for (KeyStore keyStore : Utilities.getKeyStore(KeyStoreProvider.TrustLevel.TRUST_CA)) {
                hashSet3.addAll(Utilities.getTrustAnchor(keyStore));
            }
            for (KeyStore keyStore : Utilities.getKeyStore(KeyStoreProvider.TrustLevel.VALIDATE_CA)) {
                hashSet4.addAll(Utilities.getTrustAnchor(keyStore));
            }
            KeyStore keyStore = Utilities.loadKeyStore();
            if (keyStore != null) {
                hashSet.addAll(Utilities.getCertificates(keyStore));
            }
            n += updateElement.getDownloadSize();
            if (progressHandle != null) {
                progressHandle.progress(updateElement.getDisplayName(), n < this.wasDownloaded ? n : this.wasDownloaded);
            }
            MessageMultiValidator messageMultiValidator = MessageValidator.createFromMessageDigestValues(updateElementImpl.getMessageDigests());
            Object object2 = new byte[102400];
            Object object3 = new FileInputStream(file);
            Object object4 = null;
            try {
                int n2;
                while ((n2 = ((FileInputStream)object3).read((byte[])object2)) > 0) {
                    messageMultiValidator.update((byte[])object2, 0, n2);
                }
            }
            catch (Throwable throwable) {
                object4 = throwable;
                throw throwable;
            }
            finally {
                if (object3 != null) {
                    if (object4 != null) {
                        try {
                            ((FileInputStream)object3).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object4).addSuppressed(throwable);
                        }
                    } else {
                        ((FileInputStream)object3).close();
                    }
                }
            }
            if (!messageMultiValidator.isValid()) {
                object3 = messageMultiValidator.getValidators().iterator();
                while (object3.hasNext()) {
                    object4 = (MessageValidator)object3.next();
                    LOG.log(Level.INFO, "Failed to validate message digest {3} for ''{0}'' expected ''{1}'' got ''{2}''", new Object[]{file.getAbsolutePath(), object4.getExpectedValueAsString(), object4.getRealValueAsString(), object4.getName()});
                }
                object = "MODIFIED";
            } else if (!messageMultiValidator.getValidators().isEmpty() && updateElementImpl.isCatalogTrusted()) {
                object = "TRUSTED";
            }
            if (object == null) {
                try {
                    Collection<CodeSigner> collection = Utilities.getNbmCertificates(file);
                    if (collection == null) {
                        object = "N/A";
                    } else if (collection.isEmpty()) {
                        object = "UNSIGNED";
                    } else {
                        object2 = collection.iterator();
                        while (object2.hasNext()) {
                            CodeSigner codeSigner = (CodeSigner)object2.next();
                            object3 = Utilities.verifyCertificates(codeSigner, hashSet, hashSet3, hashSet2, hashSet4);
                            if (object != null && Utilities.VERIFICATION_RESULT_COMPARATOR.compare((String)object, (String)object3) <= 0) continue;
                            object = object3;
                            this.certs.put(updateElement, codeSigner.getSignerCertPath().getCertificates());
                        }
                    }
                }
                catch (SecurityException securityException) {
                    LOG.log(Level.INFO, "The content of the jar/nbm has been modified or certificate paths were inconsistent - " + securityException.getMessage(), securityException);
                    object = "MODIFIED";
                }
            }
            if (object != null) {
                switch (object) {
                    case "MODIFIED": {
                        this.modified.add(updateElementImpl);
                        break;
                    }
                    case "TRUSTED": 
                    case "N/A": {
                        this.trusted.add(updateElementImpl);
                        break;
                    }
                    case "SIGNATURE_VERIFIED": {
                        this.signedVerified.add(updateElementImpl);
                        break;
                    }
                    case "SIGNATURE_UNVERIFIED": {
                        this.signedUnverified.add(updateElementImpl);
                    }
                }
            }
            if (!((list = Utilities.getNbmPack200Entries(file)).isEmpty() || (object3 = (operationContainerImpl = Trampoline.API.impl(operationContainer = this.support.getContainer())).getUnpack200()) != null && ((File)object3).canExecute())) {
                object4 = new StringBuilder();
                for (String string : list) {
                    ((StringBuilder)object4).append("\n").append(string);
                }
                throw new OperationException(OperationException.ERROR_TYPE.MISSING_UNPACK200, NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_Validate_MissingUnpack200", (Object)file, (Object)((StringBuilder)object4).toString()));
            }
            this.updateFragmentStatus(updateElementImpl, file);
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, iOException.getMessage(), iOException);
            object = "BAD_DOWNLOAD";
            throw new OperationException(OperationException.ERROR_TYPE.INSTALL, NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_Validate_CorruptedNBM", (Object)file));
        }
        catch (KeyStoreException keyStoreException) {
            LOG.log(Level.INFO, keyStoreException.getMessage(), keyStoreException);
            object = "CORRUPTED";
            throw new OperationException(OperationException.ERROR_TYPE.INSTALL, NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_Validate_CorruptedNBM", (Object)file));
        }
        LOG.log(Level.FINE, "NBM " + file + " was verified as " + (String)object);
        return updateElement.getDownloadSize();
    }

    private void updateFragmentStatus(UpdateElementImpl updateElementImpl, File file) throws IOException {
        Object object;
        Object object2;
        UpdateItemImpl updateItemImpl = updateElementImpl.getInstallInfo().getUpdateItemImpl();
        if (!(updateItemImpl instanceof ModuleItem)) {
            return;
        }
        ModuleItem moduleItem = (ModuleItem)updateItemImpl;
        if (moduleItem.isFragment() && (object2 = Utilities.toModule((String)(object = moduleItem.getFragmentHost()))) != null && object2.isEnabled()) {
            updateItemImpl.setNeedsRestart(Boolean.TRUE);
        }
        try {
            object = AutoupdateInfoParser.getUpdateItems(file);
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException);
        }
        for (UpdateItem updateItem : object.values()) {
            String string;
            ModuleItem moduleItem2;
            UpdateItemImpl updateItemImpl2 = Trampoline.SPI.impl(updateItem);
            if (!(updateItemImpl2 instanceof ModuleItem) || !(moduleItem2 = (ModuleItem)updateItemImpl2).getCodeName().equals(updateElementImpl.getCodeName()) || (string = moduleItem2.getFragmentHost()) == null || updateItemImpl.isFragment()) continue;
            moduleItem.setFragmentHost(string);
            Module module = Utilities.toModule(string);
            if (module == null || !module.isEnabled()) continue;
            updateItemImpl.setNeedsRestart(Boolean.TRUE);
        }
    }

    private boolean needsRestart(boolean bl, UpdateElementImpl updateElementImpl, File file) {
        return InstallManager.needsRestart(bl, updateElementImpl, file);
    }

    private static String relativePath(File file, StringBuilder stringBuilder) {
        if (file == null) {
            return null;
        }
        if (file.getName().equals("config")) {
            return stringBuilder.toString();
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.insert(0, '/');
        }
        stringBuilder.insert(0, file.getName());
        return InstallSupportImpl.relativePath(file.getParentFile(), stringBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void touch(File file, long l) {
        long l2;
        int n = 0;
        while ((l2 = file.lastModified()) <= l) {
            if (!file.exists()) {
                LOG.log(Level.FINE, "File {0} does not exist anymore", file);
                break;
            }
            LOG.log(Level.FINE, "Need to change time for {0} with delta {1}", new Object[]{file, l - file.lastModified()});
            try {
                Class<InstallSupportImpl> clazz = InstallSupportImpl.class;
                // MONITORENTER : org.netbeans.modules.autoupdate.services.InstallSupportImpl.class
                InstallSupportImpl.class.wait(30L);
                // MONITOREXIT : clazz
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            file.setLastModified(System.currentTimeMillis() - 1000L);
            ++n;
        }
        LOG.log(Level.FINE, "Time stamp changed succcessfully {0}", file);
    }

    private File getTargetCluster(UpdateElement updateElement, UpdateElementImpl updateElementImpl, Boolean bl, boolean bl2) throws OperationException {
        File file = this.getElement2Clusters().get(updateElementImpl);
        if (file == null && (file = InstallManager.findTargetDirectory(updateElement, updateElementImpl, bl, bl2)) != null) {
            this.getElement2Clusters().put(updateElementImpl, file);
        }
        return file;
    }

    private Map<UpdateElementImpl, File> getElement2Clusters() {
        if (this.element2Clusters == null) {
            this.element2Clusters = new HashMap<UpdateElementImpl, File>();
        }
        return this.element2Clusters;
    }

    private ExecutorService getExecutionService() {
        if (this.es == null || this.es.isShutdown()) {
            this.es = Executors.newSingleThreadExecutor();
        }
        return this.es;
    }

    private static InputStream externalDownload(ExternalFile externalFile) throws IOException {
        IOException iOException = null;
        for (String string : externalFile.getUrls()) {
            LOG.log(Level.INFO, "Trying external URL: {0}", string);
            try {
                URLConnection uRLConnection = new URL(string).openConnection();
                uRLConnection.setConnectTimeout(AutoupdateSettings.getOpenConnectionTimeout());
                uRLConnection.setReadTimeout(AutoupdateSettings.getOpenConnectionTimeout());
                return uRLConnection.getInputStream();
            }
            catch (IOException iOException2) {
                LOG.log(Level.WARNING, "Cannot connect to {0}", string);
                LOG.log(Level.INFO, "Details", iOException2);
                if (!(iOException2 instanceof UnknownHostException) && !(iOException2 instanceof ConnectException) && !(iOException2 instanceof SocketTimeoutException)) continue;
                iOException = iOException2;
            }
        }
        if (iOException == null) {
            throw new FileNotFoundException("Cannot resolve external reference to " + externalFile.getUrls());
        }
        throw new IOException("resolving external reference to " + externalFile.getUrls());
    }

    private static class UpdaterInfo {
        private final JarEntry updaterJarEntry;
        private final File zipFileWithUpdater;
        private final File updaterTargetCluster;

        public UpdaterInfo(JarEntry jarEntry, File file, File file2) {
            this.updaterJarEntry = jarEntry;
            this.zipFileWithUpdater = file;
            this.updaterTargetCluster = file2;
        }

        public JarEntry getUpdaterJarEntry() {
            return this.updaterJarEntry;
        }

        public File getZipFileWithUpdater() {
            return this.zipFileWithUpdater;
        }

        public File getUpdaterTargetCluster() {
            return this.updaterTargetCluster;
        }
    }

    private static final class RefreshModulesListener
    implements PropertyChangeListener,
    Runnable {
        private final ProgressHandle handle;
        private int i;
        private PropertyChangeEvent ev;

        public RefreshModulesListener(ProgressHandle progressHandle) {
            this.handle = progressHandle;
            this.i = 0;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("RUNNING".equals(propertyChangeEvent.getPropertyName())) {
                if (this.handle != null) {
                    this.handle.progress(propertyChangeEvent.getNewValue() == null ? "" : propertyChangeEvent.getNewValue().toString(), this.i++);
                }
            } else if ("FINISHED".equals(propertyChangeEvent.getPropertyName())) {
                this.ev = propertyChangeEvent;
                FileUtil.runAtomicAction((Runnable)this);
            } else assert (false) : "Unknown property " + propertyChangeEvent.getPropertyName();
        }

        @Override
        public void run() {
            for (int i = 0; i < 10; ++i) {
                Map map = NbCollections.checkedMapByFilter((Map)((Map)this.ev.getNewValue()), File.class, Long.class, (boolean)true);
                long l = System.currentTimeMillis();
                for (Map.Entry entry : map.entrySet()) {
                    InstallSupportImpl.touch((File)entry.getKey(), Math.max((Long)entry.getValue(), l));
                }
                FileObject fileObject = FileUtil.getConfigFile((String)"Modules");
                if (fileObject != null) {
                    LOG.fine("Refreshing whole MFS");
                    fileObject.refresh();
                    try {
                        FileUtil.getConfigRoot().getFileSystem().refresh(true);
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                    }
                    LOG.fine("Done refreshing MFS");
                }
                boolean bl = true;
                for (File file : map.keySet()) {
                    String string = InstallSupportImpl.relativePath(file, new StringBuilder());
                    if (string == null) continue;
                    FileObject fileObject2 = FileUtil.getConfigFile((String)string);
                    if (fileObject2 == null) {
                        LOG.log(i < 5 ? Level.FINE : Level.WARNING, "Cannot find " + string);
                        bl = false;
                        continue;
                    }
                    LOG.fine("Refreshing " + fileObject2);
                    fileObject2.refresh();
                }
                if (!bl) continue;
                LOG.log(i < 5 ? Level.FINE : Level.INFO, "All was OK on " + i + " th iteration");
                break;
            }
            UpdateManagerImpl.getInstance().flushComputedInfo();
        }
    }

    private class OpenConnectionListener
    implements NetworkAccess.NetworkListener {
        private InputStream stream = null;
        int contentLength = -1;
        private URL source = null;
        private Exception ex = null;

        public OpenConnectionListener(URL uRL) {
            this.source = uRL;
        }

        public InputStream getInputStream() {
            return this.stream;
        }

        public int getContentLength() {
            return this.contentLength;
        }

        @Override
        public void streamOpened(InputStream inputStream, int n) {
            LOG.log(Level.FINEST, "Opened connection for " + this.source);
            this.stream = inputStream;
            this.contentLength = n;
        }

        @Override
        public void accessCanceled() {
            LOG.log(Level.INFO, "Opening connection for " + this.source + "was cancelled");
        }

        @Override
        public void accessTimeOut() {
            LOG.log(Level.INFO, "Opening connection for " + this.source + "was finised due to timeout");
        }

        @Override
        public void notifyException(Exception exception) {
            this.ex = exception;
        }

        public Exception getException() {
            return this.ex;
        }
    }

    private static enum STEP {
        NOTSTARTED,
        DOWNLOAD,
        VALIDATION,
        INSTALLATION,
        RESTART,
        FINISHED,
        CANCEL;

    }
}

