/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jmx;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.core.datasource.Storage;
import org.graalvm.visualvm.core.datasupport.Utils;
import org.graalvm.visualvm.jmx.EnvironmentProvider;

public abstract class CredentialsProvider
extends EnvironmentProvider {
    private static final String PROPERTY_USER = "prop_credentials_user";
    private static final String PROPERTY_PWORD = "prop_credentials_pword";
    private static Persistent PERSISTENT_PROVIDER;

    static synchronized Persistent persistent() {
        if (PERSISTENT_PROVIDER == null) {
            PERSISTENT_PROVIDER = new Persistent();
        }
        return PERSISTENT_PROVIDER;
    }

    @Override
    public String getId() {
        return CredentialsProvider.class.getName();
    }

    abstract String getUsername(Storage var1);

    abstract boolean hasPassword(Storage var1);

    abstract boolean isPersistent(Storage var1);

    private static Map<String, ?> createMap(String username, char[] pword) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        if (username != null && !username.isEmpty()) {
            map.put("jmx.remote.credentials", new String[]{username, pword == null ? null : new String(CredentialsProvider.decodePassword(pword))});
        } else if (pword != null) {
            Arrays.fill(pword, '\u0000');
        }
        return map;
    }

    private static char[] encodePassword(char[] pword) {
        return pword == null ? null : Utils.encodePassword((char[])pword);
    }

    private static char[] decodePassword(char[] pword) {
        return pword == null ? null : Utils.decodePassword((char[])pword);
    }

    public static class Persistent
    extends CredentialsProvider {
        @Override
        public Map<String, ?> getEnvironment(Application application, Storage storage) {
            String user = storage.getCustomProperty(CredentialsProvider.PROPERTY_USER);
            char[] pword = storage.getCustomProperty(CredentialsProvider.PROPERTY_PWORD) == null ? null : storage.getCustomProperty(CredentialsProvider.PROPERTY_PWORD).toCharArray();
            return CredentialsProvider.createMap(user, pword);
        }

        @Override
        public String getEnvironmentId(Storage storage) {
            String user;
            if (storage != null && (user = storage.getCustomProperty(CredentialsProvider.PROPERTY_USER)) != null) {
                return user;
            }
            return super.getEnvironmentId(storage);
        }

        @Override
        String getUsername(Storage storage) {
            return storage.getCustomProperty(CredentialsProvider.PROPERTY_USER);
        }

        @Override
        boolean hasPassword(Storage storage) {
            if (storage.getCustomProperty(CredentialsProvider.PROPERTY_PWORD) == null) {
                return false;
            }
            return !storage.getCustomProperty(CredentialsProvider.PROPERTY_PWORD).isEmpty();
        }

        @Override
        boolean isPersistent(Storage storage) {
            return this.getUsername(storage) != null || this.hasPassword(storage);
        }
    }

    public static class Custom
    extends CredentialsProvider {
        private final String user;
        private final char[] pword;
        private final boolean persistent;

        public Custom(String username, char[] password, boolean persistent) {
            this.user = username;
            this.pword = CredentialsProvider.encodePassword(password);
            this.persistent = persistent;
        }

        @Override
        public Map<String, ?> getEnvironment(Application application, Storage storage) {
            return CredentialsProvider.createMap(this.user, this.pword == null ? null : Arrays.copyOf(this.pword, this.pword.length));
        }

        @Override
        public String getEnvironmentId(Storage storage) {
            if (this.user != null) {
                return this.user;
            }
            return super.getEnvironmentId(storage);
        }

        @Override
        public void saveEnvironment(Storage storage) {
            if (!this.persistent) {
                return;
            }
            storage.setCustomProperty(CredentialsProvider.PROPERTY_USER, this.user);
            storage.setCustomProperty(CredentialsProvider.PROPERTY_PWORD, new String(this.pword));
        }

        @Override
        String getUsername(Storage storage) {
            return this.user;
        }

        @Override
        boolean hasPassword(Storage storage) {
            return this.pword != null && this.pword.length > 0;
        }

        @Override
        boolean isPersistent(Storage storage) {
            return this.persistent;
        }
    }
}

