/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.datasupport.Positionable;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.graalvm.visualvm.core.snapshot.SnapshotView;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.model.JFRModelFactory;
import org.graalvm.visualvm.jfr.view.JFRViewTab;
import org.graalvm.visualvm.jfr.view.JFRViewTabProvider;
import org.graalvm.visualvm.uisupport.ProfilerTabbedView;
import org.openide.util.NbBundle;

public class JFRView
extends SnapshotView {
    private static final Logger LOGGER = Logger.getLogger(JFRView.class.getName());
    private final List<JFRViewTab> tabViews = new ArrayList<JFRViewTab>();
    private JFRModel model;

    JFRView(JFRSnapshot jfrSnapshot, Collection<? extends JFRViewTabProvider> tabProviders) {
        this(jfrSnapshot, DataSourceDescriptorFactory.getDescriptor((DataSource)jfrSnapshot), tabProviders);
    }

    private JFRView(JFRSnapshot jfrSnapshot, DataSourceDescriptor descriptor, Collection<? extends JFRViewTabProvider> tabProviders) {
        super((Snapshot)jfrSnapshot, descriptor.getName(), descriptor.getIcon(), 0);
        for (JFRViewTabProvider jFRViewTabProvider : tabProviders) {
            this.tabViews.add(jFRViewTabProvider.createView(jfrSnapshot));
        }
        Collections.sort(this.tabViews, Positionable.COMPARATOR);
    }

    protected DataViewComponent createComponent() {
        JFRSnapshot jfrSnapshot = (JFRSnapshot)this.getDataSource();
        DataViewComponent dvc = new DataViewComponent(new MasterViewSupport(jfrSnapshot, this.tabViews).getMasterView(), new DataViewComponent.MasterViewConfiguration(true));
        return dvc;
    }

    protected void willBeAdded() {
        JFRSnapshot snapshot = (JFRSnapshot)this.getDataSource();
        this.model = JFRModelFactory.getJFRModelFor((DataSource)snapshot);
        if (this.model == null) {
            LOGGER.log(Level.SEVERE, "No JFR model for " + snapshot.getFile());
        }
        for (JFRViewTab tabView : this.tabViews) {
            tabView.setModel(this.model);
        }
    }

    protected void removed() {
        JFRModelFactory.cleanupModel__Workaround(this.model);
    }

    private static class MasterViewSupport
    extends JPanel {
        private ProfilerTabbedView views;

        MasterViewSupport(JFRSnapshot jfrSnapshot, List<JFRViewTab> tabViews) {
            this.initComponents(tabViews);
        }

        public DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView(NbBundle.getMessage(JFRView.class, (String)"LBL_JFR_Snapshot"), null, (JComponent)this);
        }

        private void initComponents(List<JFRViewTab> tabViews) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.views = ProfilerTabbedView.createBottom((boolean)true, (boolean)true, null);
            this.views.setShowsTabPopup(false);
            this.views.setFocusMaster((Component)this);
            this.add((Component)this.views.getComponent(), "Center");
            for (JFRViewTab tabView : tabViews) {
                this.views.addView(tabView.getName(), (Icon)new ImageIcon(tabView.getImage()), null, (JComponent)tabView.createComponent(), false);
            }
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.tweakUI();
        }

        private void tweakUI() {
            try {
                Container DisplayArea_ViewArea = this.getParent();
                Container DisplayArea = DisplayArea_ViewArea.getParent();
                Component DisplayArea_captionArea = DisplayArea.getComponent(0);
                if (DisplayArea_captionArea instanceof JPanel) {
                    DisplayArea_captionArea.setVisible(false);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to tweak UI for JFRView", e);
            }
        }
    }
}

