# This file has been autogenerated by the pywayland scanner

# Copyright 2014 © Stephen "Lyude" Chandler Paul
# Copyright 2015-2016 © Red Hat, Inc.
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice (including the
# next paragraph) shall be included in all copies or substantial
# portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from .zwp_tablet_pad_v2 import ZwpTabletPadV2
from .zwp_tablet_tool_v2 import ZwpTabletToolV2
from .zwp_tablet_v2 import ZwpTabletV2


class ZwpTabletSeatV2(Interface):
    """Controller object for graphic tablet devices of a seat

    An object that provides access to the graphics tablets available on this
    seat. After binding to this interface, the compositor sends a set of
    wp_tablet_seat.tablet_added and wp_tablet_seat.tool_added events.
    """

    name = "zwp_tablet_seat_v2"
    version = 1


class ZwpTabletSeatV2Proxy(Proxy[ZwpTabletSeatV2]):
    interface = ZwpTabletSeatV2

    @ZwpTabletSeatV2.request()
    def destroy(self) -> None:
        """Release the memory for the tablet seat object

        Destroy the wp_tablet_seat object. Objects created from this object are
        unaffected and should be destroyed separately.
        """
        self._marshal(0)
        self._destroy()


class ZwpTabletSeatV2Resource(Resource):
    interface = ZwpTabletSeatV2

    @ZwpTabletSeatV2.event(
        Argument(ArgumentType.NewId, interface=ZwpTabletV2),
    )
    def tablet_added(self, id: ZwpTabletV2) -> None:
        """New device notification

        This event is sent whenever a new tablet becomes available on this
        seat. This event only provides the object id of the tablet, any static
        information about the tablet (device name, vid/pid, etc.) is sent
        through the wp_tablet interface.

        :param id:
            the newly added graphics tablet
        :type id:
            :class:`~pywayland.protocol.tablet_unstable_v2.ZwpTabletV2`
        """
        self._post_event(0, id)

    @ZwpTabletSeatV2.event(
        Argument(ArgumentType.NewId, interface=ZwpTabletToolV2),
    )
    def tool_added(self, id: ZwpTabletToolV2) -> None:
        """A new tool has been used with a tablet

        This event is sent whenever a tool that has not previously been used
        with a tablet comes into use. This event only provides the object id of
        the tool; any static information about the tool (capabilities, type,
        etc.) is sent through the wp_tablet_tool interface.

        :param id:
            the newly added tablet tool
        :type id:
            :class:`~pywayland.protocol.tablet_unstable_v2.ZwpTabletToolV2`
        """
        self._post_event(1, id)

    @ZwpTabletSeatV2.event(
        Argument(ArgumentType.NewId, interface=ZwpTabletPadV2),
    )
    def pad_added(self, id: ZwpTabletPadV2) -> None:
        """New pad notification

        This event is sent whenever a new pad is known to the system.
        Typically, pads are physically attached to tablets and a pad_added
        event is sent immediately after the wp_tablet_seat.tablet_added.
        However, some standalone pad devices logically attach to tablets at
        runtime, and the client must wait for wp_tablet_pad.enter to know the
        tablet a pad is attached to.

        This event only provides the object id of the pad. All further features
        (buttons, strips, rings) are sent through the wp_tablet_pad interface.

        :param id:
            the newly added pad
        :type id:
            :class:`~pywayland.protocol.tablet_unstable_v2.ZwpTabletPadV2`
        """
        self._post_event(2, id)


class ZwpTabletSeatV2Global(Global):
    interface = ZwpTabletSeatV2


ZwpTabletSeatV2._gen_c()
ZwpTabletSeatV2.proxy_class = ZwpTabletSeatV2Proxy
ZwpTabletSeatV2.resource_class = ZwpTabletSeatV2Resource
ZwpTabletSeatV2.global_class = ZwpTabletSeatV2Global
