from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.Geom import *
from OCC.Core.gp import *
from OCC.Core.TopoDS import *
from OCC.Core.Prs3d import *
from OCC.Core.Quantity import *
from OCC.Core.Aspect import *
from OCC.Core.Bnd import *
from OCC.Core.AIS import *
from OCC.Core.TCollection import *
from OCC.Core.SelectMgr import *
from OCC.Core.PrsMgr import *
from OCC.Core.DsgPrs import *
from OCC.Core.TColStd import *


class PrsDim_DimensionSelectionMode(IntEnum):
    PrsDim_DimensionSelectionMode_All: int = ...
    PrsDim_DimensionSelectionMode_Line: int = ...
    PrsDim_DimensionSelectionMode_Text: int = ...

PrsDim_DimensionSelectionMode_All = PrsDim_DimensionSelectionMode.PrsDim_DimensionSelectionMode_All
PrsDim_DimensionSelectionMode_Line = PrsDim_DimensionSelectionMode.PrsDim_DimensionSelectionMode_Line
PrsDim_DimensionSelectionMode_Text = PrsDim_DimensionSelectionMode.PrsDim_DimensionSelectionMode_Text

class PrsDim_DisplaySpecialSymbol(IntEnum):
    PrsDim_DisplaySpecialSymbol_No: int = ...
    PrsDim_DisplaySpecialSymbol_Before: int = ...
    PrsDim_DisplaySpecialSymbol_After: int = ...

PrsDim_DisplaySpecialSymbol_No = PrsDim_DisplaySpecialSymbol.PrsDim_DisplaySpecialSymbol_No
PrsDim_DisplaySpecialSymbol_Before = PrsDim_DisplaySpecialSymbol.PrsDim_DisplaySpecialSymbol_Before
PrsDim_DisplaySpecialSymbol_After = PrsDim_DisplaySpecialSymbol.PrsDim_DisplaySpecialSymbol_After

class PrsDim_KindOfDimension(IntEnum):
    PrsDim_KOD_NONE: int = ...
    PrsDim_KOD_LENGTH: int = ...
    PrsDim_KOD_PLANEANGLE: int = ...
    PrsDim_KOD_SOLIDANGLE: int = ...
    PrsDim_KOD_AREA: int = ...
    PrsDim_KOD_VOLUME: int = ...
    PrsDim_KOD_MASS: int = ...
    PrsDim_KOD_TIME: int = ...
    PrsDim_KOD_RADIUS: int = ...
    PrsDim_KOD_DIAMETER: int = ...
    PrsDim_KOD_CHAMF2D: int = ...
    PrsDim_KOD_CHAMF3D: int = ...
    PrsDim_KOD_OFFSET: int = ...
    PrsDim_KOD_ELLIPSERADIUS: int = ...

PrsDim_KOD_NONE = PrsDim_KindOfDimension.PrsDim_KOD_NONE
PrsDim_KOD_LENGTH = PrsDim_KindOfDimension.PrsDim_KOD_LENGTH
PrsDim_KOD_PLANEANGLE = PrsDim_KindOfDimension.PrsDim_KOD_PLANEANGLE
PrsDim_KOD_SOLIDANGLE = PrsDim_KindOfDimension.PrsDim_KOD_SOLIDANGLE
PrsDim_KOD_AREA = PrsDim_KindOfDimension.PrsDim_KOD_AREA
PrsDim_KOD_VOLUME = PrsDim_KindOfDimension.PrsDim_KOD_VOLUME
PrsDim_KOD_MASS = PrsDim_KindOfDimension.PrsDim_KOD_MASS
PrsDim_KOD_TIME = PrsDim_KindOfDimension.PrsDim_KOD_TIME
PrsDim_KOD_RADIUS = PrsDim_KindOfDimension.PrsDim_KOD_RADIUS
PrsDim_KOD_DIAMETER = PrsDim_KindOfDimension.PrsDim_KOD_DIAMETER
PrsDim_KOD_CHAMF2D = PrsDim_KindOfDimension.PrsDim_KOD_CHAMF2D
PrsDim_KOD_CHAMF3D = PrsDim_KindOfDimension.PrsDim_KOD_CHAMF3D
PrsDim_KOD_OFFSET = PrsDim_KindOfDimension.PrsDim_KOD_OFFSET
PrsDim_KOD_ELLIPSERADIUS = PrsDim_KindOfDimension.PrsDim_KOD_ELLIPSERADIUS

class PrsDim_KindOfRelation(IntEnum):
    PrsDim_KOR_NONE: int = ...
    PrsDim_KOR_CONCENTRIC: int = ...
    PrsDim_KOR_EQUALDISTANCE: int = ...
    PrsDim_KOR_EQUALRADIUS: int = ...
    PrsDim_KOR_FIX: int = ...
    PrsDim_KOR_IDENTIC: int = ...
    PrsDim_KOR_OFFSET: int = ...
    PrsDim_KOR_PARALLEL: int = ...
    PrsDim_KOR_PERPENDICULAR: int = ...
    PrsDim_KOR_TANGENT: int = ...
    PrsDim_KOR_SYMMETRIC: int = ...

PrsDim_KOR_NONE = PrsDim_KindOfRelation.PrsDim_KOR_NONE
PrsDim_KOR_CONCENTRIC = PrsDim_KindOfRelation.PrsDim_KOR_CONCENTRIC
PrsDim_KOR_EQUALDISTANCE = PrsDim_KindOfRelation.PrsDim_KOR_EQUALDISTANCE
PrsDim_KOR_EQUALRADIUS = PrsDim_KindOfRelation.PrsDim_KOR_EQUALRADIUS
PrsDim_KOR_FIX = PrsDim_KindOfRelation.PrsDim_KOR_FIX
PrsDim_KOR_IDENTIC = PrsDim_KindOfRelation.PrsDim_KOR_IDENTIC
PrsDim_KOR_OFFSET = PrsDim_KindOfRelation.PrsDim_KOR_OFFSET
PrsDim_KOR_PARALLEL = PrsDim_KindOfRelation.PrsDim_KOR_PARALLEL
PrsDim_KOR_PERPENDICULAR = PrsDim_KindOfRelation.PrsDim_KOR_PERPENDICULAR
PrsDim_KOR_TANGENT = PrsDim_KindOfRelation.PrsDim_KOR_TANGENT
PrsDim_KOR_SYMMETRIC = PrsDim_KindOfRelation.PrsDim_KOR_SYMMETRIC

class PrsDim_KindOfSurface(IntEnum):
    PrsDim_KOS_Plane: int = ...
    PrsDim_KOS_Cylinder: int = ...
    PrsDim_KOS_Cone: int = ...
    PrsDim_KOS_Sphere: int = ...
    PrsDim_KOS_Torus: int = ...
    PrsDim_KOS_Revolution: int = ...
    PrsDim_KOS_Extrusion: int = ...
    PrsDim_KOS_OtherSurface: int = ...

PrsDim_KOS_Plane = PrsDim_KindOfSurface.PrsDim_KOS_Plane
PrsDim_KOS_Cylinder = PrsDim_KindOfSurface.PrsDim_KOS_Cylinder
PrsDim_KOS_Cone = PrsDim_KindOfSurface.PrsDim_KOS_Cone
PrsDim_KOS_Sphere = PrsDim_KindOfSurface.PrsDim_KOS_Sphere
PrsDim_KOS_Torus = PrsDim_KindOfSurface.PrsDim_KOS_Torus
PrsDim_KOS_Revolution = PrsDim_KindOfSurface.PrsDim_KOS_Revolution
PrsDim_KOS_Extrusion = PrsDim_KindOfSurface.PrsDim_KOS_Extrusion
PrsDim_KOS_OtherSurface = PrsDim_KindOfSurface.PrsDim_KOS_OtherSurface

class PrsDim_TypeOfAngle(IntEnum):
    PrsDim_TypeOfAngle_Interior: int = ...
    PrsDim_TypeOfAngle_Exterior: int = ...

PrsDim_TypeOfAngle_Interior = PrsDim_TypeOfAngle.PrsDim_TypeOfAngle_Interior
PrsDim_TypeOfAngle_Exterior = PrsDim_TypeOfAngle.PrsDim_TypeOfAngle_Exterior

class PrsDim_TypeOfAngleArrowVisibility(IntEnum):
    PrsDim_TypeOfAngleArrowVisibility_Both: int = ...
    PrsDim_TypeOfAngleArrowVisibility_First: int = ...
    PrsDim_TypeOfAngleArrowVisibility_Second: int = ...
    PrsDim_TypeOfAngleArrowVisibility_None: int = ...

PrsDim_TypeOfAngleArrowVisibility_Both = PrsDim_TypeOfAngleArrowVisibility.PrsDim_TypeOfAngleArrowVisibility_Both
PrsDim_TypeOfAngleArrowVisibility_First = PrsDim_TypeOfAngleArrowVisibility.PrsDim_TypeOfAngleArrowVisibility_First
PrsDim_TypeOfAngleArrowVisibility_Second = PrsDim_TypeOfAngleArrowVisibility.PrsDim_TypeOfAngleArrowVisibility_Second
PrsDim_TypeOfAngleArrowVisibility_None = PrsDim_TypeOfAngleArrowVisibility.PrsDim_TypeOfAngleArrowVisibility_None

class PrsDim_TypeOfDist(IntEnum):
    PrsDim_TypeOfDist_Unknown: int = ...
    PrsDim_TypeOfDist_Horizontal: int = ...
    PrsDim_TypeOfDist_Vertical: int = ...

PrsDim_TypeOfDist_Unknown = PrsDim_TypeOfDist.PrsDim_TypeOfDist_Unknown
PrsDim_TypeOfDist_Horizontal = PrsDim_TypeOfDist.PrsDim_TypeOfDist_Horizontal
PrsDim_TypeOfDist_Vertical = PrsDim_TypeOfDist.PrsDim_TypeOfDist_Vertical

class prsdim:
    @staticmethod
    def ComputeGeomCurve(aCurve: Geom_Curve, first1: float, last1: float, FirstPnt1: gp_Pnt, LastPnt1: gp_Pnt, aPlane: Geom_Plane) -> Tuple[bool, bool]: ...
    @overload
    @staticmethod
    def ComputeGeometry(theEdge: TopoDS_Edge, theCurve: Geom_Curve, theFirstPnt: gp_Pnt, theLastPnt: gp_Pnt) -> bool: ...
    @overload
    @staticmethod
    def ComputeGeometry(theEdge: TopoDS_Edge, theCurve: Geom_Curve, theFirstPnt: gp_Pnt, theLastPnt: gp_Pnt) -> Tuple[bool, bool]: ...
    @overload
    @staticmethod
    def ComputeGeometry(theEdge: TopoDS_Edge, theCurve: Geom_Curve, theFirstPnt: gp_Pnt, theLastPnt: gp_Pnt, theExtCurve: Geom_Curve, thePlane: Geom_Plane) -> Tuple[bool, bool, bool]: ...
    @overload
    @staticmethod
    def ComputeGeometry(theFirstEdge: TopoDS_Edge, theSecondEdge: TopoDS_Edge, theFirstCurve: Geom_Curve, theSecondCurve: Geom_Curve, theFirstPnt1: gp_Pnt, theLastPnt1: gp_Pnt, theFirstPnt2: gp_Pnt, theLastPnt2: gp_Pnt, thePlane: Geom_Plane) -> bool: ...
    @overload
    @staticmethod
    def ComputeGeometry(theFirstEdge: TopoDS_Edge, theSecondEdge: TopoDS_Edge, theFirstCurve: Geom_Curve, theSecondCurve: Geom_Curve, theFirstPnt1: gp_Pnt, theLastPnt1: gp_Pnt, theFirstPnt2: gp_Pnt, theLastPnt2: gp_Pnt) -> Tuple[bool, bool, bool]: ...
    @overload
    @staticmethod
    def ComputeGeometry(theFirstEdge: TopoDS_Edge, theSecondEdge: TopoDS_Edge, theFirstCurve: Geom_Curve, theSecondCurve: Geom_Curve, theFirstPnt1: gp_Pnt, theLastPnt1: gp_Pnt, theFirstPnt2: gp_Pnt, theLastPnt2: gp_Pnt, theExtCurve: Geom_Curve, thePlane: Geom_Plane) -> Tuple[bool, int, bool, bool]: ...
    @overload
    @staticmethod
    def ComputeGeometry(aVertex: TopoDS_Vertex, point: gp_Pnt, aPlane: Geom_Plane) -> Tuple[bool, bool]: ...
    @staticmethod
    def ComputeProjEdgePresentation(aPres: Prs3d_Presentation, aDrawer: Prs3d_Drawer, anEdge: TopoDS_Edge, ProjCurve: Geom_Curve, FirstP: gp_Pnt, LastP: gp_Pnt, aColor: Optional[Quantity_NameOfColor] = Quantity_NOC_PURPLE, aWidth: Optional[float] = 2, aProjTOL: Optional[Aspect_TypeOfLine] = Aspect_TOL_DASH, aCallTOL: Optional[Aspect_TypeOfLine] = Aspect_TOL_DOT) -> None: ...
    @staticmethod
    def ComputeProjVertexPresentation(aPres: Prs3d_Presentation, aDrawer: Prs3d_Drawer, aVertex: TopoDS_Vertex, ProjPoint: gp_Pnt, aColor: Optional[Quantity_NameOfColor] = Quantity_NOC_PURPLE, aWidth: Optional[float] = 2, aProjTOM: Optional[Aspect_TypeOfMarker] = Aspect_TOM_PLUS, aCallTOL: Optional[Aspect_TypeOfLine] = Aspect_TOL_DOT) -> None: ...
    @staticmethod
    def DistanceFromApex(elips: gp_Elips, Apex: gp_Pnt, par: float) -> float: ...
    @staticmethod
    def Farest(aShape: TopoDS_Shape, aPoint: gp_Pnt) -> gp_Pnt: ...
    @staticmethod
    def GetPlaneFromFace(aFace: TopoDS_Face, aPlane: gp_Pln, aSurf: Geom_Surface) -> Tuple[bool, PrsDim_KindOfSurface, float]: ...
    @staticmethod
    def InDomain(aFirstPar: float, aLastPar: float, anAttachPar: float) -> bool: ...
    @staticmethod
    def InitAngleBetweenCurvilinearFaces(theFirstFace: TopoDS_Face, theSecondFace: TopoDS_Face, theFirstSurfType: PrsDim_KindOfSurface, theSecondSurfType: PrsDim_KindOfSurface, theCenter: gp_Pnt, theFirstAttach: gp_Pnt, theSecondAttach: gp_Pnt, theIsFirstPointSet: Optional[bool] = False) -> bool: ...
    @staticmethod
    def InitAngleBetweenPlanarFaces(theFirstFace: TopoDS_Face, theSecondFace: TopoDS_Face, theCenter: gp_Pnt, theFirstAttach: gp_Pnt, theSecondAttach: gp_Pnt, theIsFirstPointSet: Optional[bool] = False) -> bool: ...
    @staticmethod
    def InitFaceLength(aFace: TopoDS_Face, aPlane: gp_Pln, aSurface: Geom_Surface) -> Tuple[PrsDim_KindOfSurface, float]: ...
    @staticmethod
    def InitLengthBetweenCurvilinearFaces(theFirstFace: TopoDS_Face, theSecondFace: TopoDS_Face, theFirstSurf: Geom_Surface, theSecondSurf: Geom_Surface, theFirstAttach: gp_Pnt, theSecondAttach: gp_Pnt, theDirOnPlane: gp_Dir) -> None: ...
    @overload
    @staticmethod
    def Nearest(aShape: TopoDS_Shape, aPoint: gp_Pnt) -> gp_Pnt: ...
    @overload
    @staticmethod
    def Nearest(theLine: gp_Lin, thePoint: gp_Pnt) -> gp_Pnt: ...
    @overload
    @staticmethod
    def Nearest(theCurve: Geom_Curve, thePoint: gp_Pnt, theFirstPoint: gp_Pnt, theLastPoint: gp_Pnt, theNearestPoint: gp_Pnt) -> bool: ...
    @staticmethod
    def NearestApex(elips: gp_Elips, pApex: gp_Pnt, nApex: gp_Pnt, fpara: float, lpara: float) -> Tuple[gp_Pnt, bool]: ...
    @staticmethod
    def ProjectPointOnLine(aPoint: gp_Pnt, aLine: gp_Lin) -> gp_Pnt: ...
    @staticmethod
    def ProjectPointOnPlane(aPoint: gp_Pnt, aPlane: gp_Pln) -> gp_Pnt: ...
    @staticmethod
    def TranslatePointToBound(aPoint: gp_Pnt, aDir: gp_Dir, aBndBox: Bnd_Box) -> gp_Pnt: ...

class PrsDim_Dimension(AIS_InteractiveObject):
    def AcceptDisplayMode(self, theMode: int) -> bool: ...
    def DimensionAspect(self) -> Prs3d_DimensionAspect: ...
    def DisplaySpecialSymbol(self) -> PrsDim_DisplaySpecialSymbol: ...
    def GetCustomValue(self) -> str: ...
    def GetDisplayUnits(self) -> str: ...
    def GetFlyout(self) -> float: ...
    def GetGeometryType(self) -> int: ...
    def GetModelUnits(self) -> str: ...
    def GetPlane(self) -> gp_Pln: ...
    def GetTextPosition(self) -> gp_Pnt: ...
    def GetValue(self) -> float: ...
    def IsTextPositionCustom(self) -> bool: ...
    def IsValid(self) -> bool: ...
    def KindOfDimension(self) -> PrsDim_KindOfDimension: ...
    def SelToleranceForText2d(self) -> float: ...
    def SetComputedValue(self) -> None: ...
    def SetCustomPlane(self, thePlane: gp_Pln) -> None: ...
    @overload
    def SetCustomValue(self, theValue: float) -> None: ...
    @overload
    def SetCustomValue(self, theValue: str) -> None: ...
    def SetDimensionAspect(self, theDimensionAspect: Prs3d_DimensionAspect) -> None: ...
    def SetDisplaySpecialSymbol(self, theDisplaySpecSymbol: PrsDim_DisplaySpecialSymbol) -> None: ...
    def SetFlyout(self, theFlyout: float) -> None: ...
    def SetSelToleranceForText2d(self, theTol: float) -> None: ...
    def SetSpecialSymbol(self, theSpecialSymbol: Standard_ExtCharacter) -> None: ...
    def SpecialSymbol(self) -> Standard_ExtCharacter: ...
    def Type(self) -> AIS_KindOfInteractive: ...
    def UnsetCustomPlane(self) -> None: ...
    def UnsetFixedTextPosition(self) -> None: ...

class PrsDim_DimensionOwner(SelectMgr_EntityOwner):
    def __init__(self, theSelObject: SelectMgr_SelectableObject, theSelMode: PrsDim_DimensionSelectionMode, thePriority: Optional[int] = 0) -> None: ...
    def HilightWithColor(self, thePM: PrsMgr_PresentationManager, theStyle: Prs3d_Drawer, theMode: int) -> None: ...
    def IsHilighted(self, thePM: PrsMgr_PresentationManager, theMode: Optional[int] = 0) -> bool: ...
    def SelectionMode(self) -> PrsDim_DimensionSelectionMode: ...
    def Unhilight(self, thePM: PrsMgr_PresentationManager, theMode: Optional[int] = 0) -> None: ...

class PrsDim_Relation(AIS_InteractiveObject):
    def AcceptDisplayMode(self, theMode: int) -> bool: ...
    def ArrowSize(self) -> float: ...
    def AutomaticPosition(self) -> bool: ...
    def ExtShape(self) -> int: ...
    def FirstShape(self) -> TopoDS_Shape: ...
    def IsMovable(self) -> bool: ...
    def KindOfDimension(self) -> PrsDim_KindOfDimension: ...
    def Plane(self) -> Geom_Plane: ...
    def Position(self) -> gp_Pnt: ...
    def SecondShape(self) -> TopoDS_Shape: ...
    def SetArrowSize(self, theArrowSize: float) -> None: ...
    def SetAutomaticPosition(self, theStatus: bool) -> None: ...
    def SetBndBox(self, theXmin: float, theYmin: float, theZmin: float, theXmax: float, theYmax: float, theZmax: float) -> None: ...
    def SetColor(self, theColor: Quantity_Color) -> None: ...
    def SetExtShape(self, theIndex: int) -> None: ...
    def SetFirstShape(self, aFShape: TopoDS_Shape) -> None: ...
    def SetPlane(self, thePlane: Geom_Plane) -> None: ...
    def SetPosition(self, thePosition: gp_Pnt) -> None: ...
    def SetSecondShape(self, aSShape: TopoDS_Shape) -> None: ...
    def SetSymbolPrs(self, theSymbolPrs: DsgPrs_ArrowSide) -> None: ...
    def SetText(self, theText: str) -> None: ...
    def SetValue(self, theVal: float) -> None: ...
    def SymbolPrs(self) -> DsgPrs_ArrowSide: ...
    def Text(self) -> str: ...
    def Type(self) -> AIS_KindOfInteractive: ...
    def UnsetBndBox(self) -> None: ...
    def UnsetColor(self) -> None: ...
    def Value(self) -> float: ...

class PrsDim_AngleDimension(PrsDim_Dimension):
    @overload
    def __init__(self, theFirstEdge: TopoDS_Edge, theSecondEdge: TopoDS_Edge) -> None: ...
    @overload
    def __init__(self, theFirstPoint: gp_Pnt, theSecondPoint: gp_Pnt, theThirdPoint: gp_Pnt) -> None: ...
    @overload
    def __init__(self, theFirstVertex: TopoDS_Vertex, theSecondVertex: TopoDS_Vertex, theThirdVertex: TopoDS_Vertex) -> None: ...
    @overload
    def __init__(self, theCone: TopoDS_Face) -> None: ...
    @overload
    def __init__(self, theFirstFace: TopoDS_Face, theSecondFace: TopoDS_Face) -> None: ...
    @overload
    def __init__(self, theFirstFace: TopoDS_Face, theSecondFace: TopoDS_Face, thePoint: gp_Pnt) -> None: ...
    def CenterPoint(self) -> gp_Pnt: ...
    def FirstPoint(self) -> gp_Pnt: ...
    def FirstShape(self) -> TopoDS_Shape: ...
    def GetArrowsVisibility(self) -> PrsDim_TypeOfAngleArrowVisibility: ...
    def GetDisplayUnits(self) -> str: ...
    def GetModelUnits(self) -> str: ...
    def GetTextPosition(self) -> gp_Pnt: ...
    def GetType(self) -> PrsDim_TypeOfAngle: ...
    def SecondPoint(self) -> gp_Pnt: ...
    def SecondShape(self) -> TopoDS_Shape: ...
    def SetArrowsVisibility(self, theType: PrsDim_TypeOfAngleArrowVisibility) -> None: ...
    def SetDisplayUnits(self, theUnits: str) -> None: ...
    @overload
    def SetMeasuredGeometry(self, theFirstEdge: TopoDS_Edge, theSecondEdge: TopoDS_Edge) -> None: ...
    @overload
    def SetMeasuredGeometry(self, theFirstPoint: gp_Pnt, theSecondPoint: gp_Pnt, theThridPoint: gp_Pnt) -> None: ...
    @overload
    def SetMeasuredGeometry(self, theFirstVertex: TopoDS_Vertex, theSecondVertex: TopoDS_Vertex, theThirdVertex: TopoDS_Vertex) -> None: ...
    @overload
    def SetMeasuredGeometry(self, theCone: TopoDS_Face) -> None: ...
    @overload
    def SetMeasuredGeometry(self, theFirstFace: TopoDS_Face, theSecondFace: TopoDS_Face) -> None: ...
    @overload
    def SetMeasuredGeometry(self, theFirstFace: TopoDS_Face, theSecondFace: TopoDS_Face, thePoint: gp_Pnt) -> None: ...
    def SetModelUnits(self, theUnits: str) -> None: ...
    def SetTextPosition(self, theTextPos: gp_Pnt) -> None: ...
    def SetType(self, theType: PrsDim_TypeOfAngle) -> None: ...
    def ThirdShape(self) -> TopoDS_Shape: ...

class PrsDim_Chamf2dDimension(PrsDim_Relation):
    @overload
    def __init__(self, aFShape: TopoDS_Shape, aPlane: Geom_Plane, aVal: float, aText: str) -> None: ...
    @overload
    def __init__(self, aFShape: TopoDS_Shape, aPlane: Geom_Plane, aVal: float, aText: str, aPosition: gp_Pnt, aSymbolPrs: DsgPrs_ArrowSide, anArrowSize: Optional[float] = 0.0) -> None: ...
    def IsMovable(self) -> bool: ...
    def KindOfDimension(self) -> PrsDim_KindOfDimension: ...

class PrsDim_Chamf3dDimension(PrsDim_Relation):
    @overload
    def __init__(self, aFShape: TopoDS_Shape, aVal: float, aText: str) -> None: ...
    @overload
    def __init__(self, aFShape: TopoDS_Shape, aVal: float, aText: str, aPosition: gp_Pnt, aSymbolPrs: DsgPrs_ArrowSide, anArrowSize: Optional[float] = 0.0) -> None: ...
    def IsMovable(self) -> bool: ...
    def KindOfDimension(self) -> PrsDim_KindOfDimension: ...

class PrsDim_ConcentricRelation(PrsDim_Relation):
    def __init__(self, aFShape: TopoDS_Shape, aSShape: TopoDS_Shape, aPlane: Geom_Plane) -> None: ...

class PrsDim_DiameterDimension(PrsDim_Dimension):
    @overload
    def __init__(self, theCircle: gp_Circ) -> None: ...
    @overload
    def __init__(self, theCircle: gp_Circ, thePlane: gp_Pln) -> None: ...
    @overload
    def __init__(self, theShape: TopoDS_Shape) -> None: ...
    @overload
    def __init__(self, theShape: TopoDS_Shape, thePlane: gp_Pln) -> None: ...
    def AnchorPoint(self) -> gp_Pnt: ...
    def Circle(self) -> gp_Circ: ...
    def GetDisplayUnits(self) -> str: ...
    def GetModelUnits(self) -> str: ...
    def GetTextPosition(self) -> gp_Pnt: ...
    def SetDisplayUnits(self, theUnits: str) -> None: ...
    @overload
    def SetMeasuredGeometry(self, theCircle: gp_Circ) -> None: ...
    @overload
    def SetMeasuredGeometry(self, theShape: TopoDS_Shape) -> None: ...
    def SetModelUnits(self, theUnits: str) -> None: ...
    def SetTextPosition(self, theTextPos: gp_Pnt) -> None: ...
    def Shape(self) -> TopoDS_Shape: ...

class PrsDim_EllipseRadiusDimension(PrsDim_Relation):
    def ComputeGeometry(self) -> None: ...
    def IsMovable(self) -> bool: ...
    def KindOfDimension(self) -> PrsDim_KindOfDimension: ...

class PrsDim_EqualDistanceRelation(PrsDim_Relation):
    def __init__(self, aShape1: TopoDS_Shape, aShape2: TopoDS_Shape, aShape3: TopoDS_Shape, aShape4: TopoDS_Shape, aPlane: Geom_Plane) -> None: ...
    @staticmethod
    def ComputeOneEdgeOneVertexLength(aPresentation: Prs3d_Presentation, aDrawer: Prs3d_Drawer, ArrowSize: float, FirstShape: TopoDS_Shape, SecondShape: TopoDS_Shape, Plane: Geom_Plane, AutomaticPos: bool, IsSetBndBox: bool, BndBox: Bnd_Box, Position: gp_Pnt, FirstAttach: gp_Pnt, SecondAttach: gp_Pnt, FirstExtreme: gp_Pnt, SecondExtreme: gp_Pnt) -> DsgPrs_ArrowSide: ...
    @staticmethod
    def ComputeTwoEdgesLength(aPresentation: Prs3d_Presentation, aDrawer: Prs3d_Drawer, ArrowSize: float, FirstEdge: TopoDS_Edge, SecondEdge: TopoDS_Edge, Plane: Geom_Plane, AutomaticPos: bool, IsSetBndBox: bool, BndBox: Bnd_Box, Position: gp_Pnt, FirstAttach: gp_Pnt, SecondAttach: gp_Pnt, FirstExtreme: gp_Pnt, SecondExtreme: gp_Pnt) -> DsgPrs_ArrowSide: ...
    @staticmethod
    def ComputeTwoVerticesLength(aPresentation: Prs3d_Presentation, aDrawer: Prs3d_Drawer, ArrowSize: float, FirstVertex: TopoDS_Vertex, SecondVertex: TopoDS_Vertex, Plane: Geom_Plane, AutomaticPos: bool, IsSetBndBox: bool, BndBox: Bnd_Box, TypeDist: PrsDim_TypeOfDist, Position: gp_Pnt, FirstAttach: gp_Pnt, SecondAttach: gp_Pnt, FirstExtreme: gp_Pnt, SecondExtreme: gp_Pnt) -> DsgPrs_ArrowSide: ...
    def SetShape3(self, aShape: TopoDS_Shape) -> None: ...
    def SetShape4(self, aShape: TopoDS_Shape) -> None: ...
    def Shape3(self) -> TopoDS_Shape: ...
    def Shape4(self) -> TopoDS_Shape: ...

class PrsDim_EqualRadiusRelation(PrsDim_Relation):
    def __init__(self, aFirstEdge: TopoDS_Edge, aSecondEdge: TopoDS_Edge, aPlane: Geom_Plane) -> None: ...

class PrsDim_FixRelation(PrsDim_Relation):
    @overload
    def __init__(self, aShape: TopoDS_Shape, aPlane: Geom_Plane, aWire: TopoDS_Wire) -> None: ...
    @overload
    def __init__(self, aShape: TopoDS_Shape, aPlane: Geom_Plane, aWire: TopoDS_Wire, aPosition: gp_Pnt, anArrowSize: Optional[float] = 0.01) -> None: ...
    @overload
    def __init__(self, aShape: TopoDS_Shape, aPlane: Geom_Plane) -> None: ...
    @overload
    def __init__(self, aShape: TopoDS_Shape, aPlane: Geom_Plane, aPosition: gp_Pnt, anArrowSize: Optional[float] = 0.01) -> None: ...
    def IsMovable(self) -> bool: ...
    def SetWire(self, aWire: TopoDS_Wire) -> None: ...
    def Wire(self) -> TopoDS_Wire: ...

class PrsDim_IdenticRelation(PrsDim_Relation):
    def __init__(self, FirstShape: TopoDS_Shape, SecondShape: TopoDS_Shape, aPlane: Geom_Plane) -> None: ...
    def AddUser(self, theUser: Standard_Transient) -> None: ...
    def ClearUsers(self) -> None: ...
    def HasUsers(self) -> bool: ...
    def IsMovable(self) -> bool: ...
    def Users(self) -> TColStd_ListOfTransient: ...

class PrsDim_LengthDimension(PrsDim_Dimension):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theFace: TopoDS_Face, theEdge: TopoDS_Edge) -> None: ...
    @overload
    def __init__(self, theFirstFace: TopoDS_Face, theSecondFace: TopoDS_Face) -> None: ...
    @overload
    def __init__(self, theFirstPoint: gp_Pnt, theSecondPoint: gp_Pnt, thePlane: gp_Pln) -> None: ...
    @overload
    def __init__(self, theFirstShape: TopoDS_Shape, theSecondShape: TopoDS_Shape, thePlane: gp_Pln) -> None: ...
    @overload
    def __init__(self, theEdge: TopoDS_Edge, thePlane: gp_Pln) -> None: ...
    def FirstPoint(self) -> gp_Pnt: ...
    def FirstShape(self) -> TopoDS_Shape: ...
    def GetDisplayUnits(self) -> str: ...
    def GetModelUnits(self) -> str: ...
    def GetTextPosition(self) -> gp_Pnt: ...
    def SecondPoint(self) -> gp_Pnt: ...
    def SecondShape(self) -> TopoDS_Shape: ...
    def SetDirection(self, theDirection: gp_Dir, theUseDirection: Optional[bool] = True) -> None: ...
    def SetDisplayUnits(self, theUnits: str) -> None: ...
    @overload
    def SetMeasuredGeometry(self, theFirstPoint: gp_Pnt, theSecondPoint: gp_Pnt, thePlane: gp_Pln) -> None: ...
    @overload
    def SetMeasuredGeometry(self, theEdge: TopoDS_Edge, thePlane: gp_Pln) -> None: ...
    @overload
    def SetMeasuredGeometry(self, theFirstFace: TopoDS_Face, theSecondFace: TopoDS_Face) -> None: ...
    @overload
    def SetMeasuredGeometry(self, theFace: TopoDS_Face, theEdge: TopoDS_Edge) -> None: ...
    def SetMeasuredShapes(self, theFirstShape: TopoDS_Shape, theSecondShape: TopoDS_Shape) -> None: ...
    def SetModelUnits(self, theUnits: str) -> None: ...
    def SetTextPosition(self, theTextPos: gp_Pnt) -> None: ...

class PrsDim_MidPointRelation(PrsDim_Relation):
    def __init__(self, aSymmTool: TopoDS_Shape, FirstShape: TopoDS_Shape, SecondShape: TopoDS_Shape, aPlane: Geom_Plane) -> None: ...
    def GetTool(self) -> TopoDS_Shape: ...
    def IsMovable(self) -> bool: ...
    def SetTool(self, aMidPointTool: TopoDS_Shape) -> None: ...

class PrsDim_OffsetDimension(PrsDim_Relation):
    def __init__(self, FistShape: TopoDS_Shape, SecondShape: TopoDS_Shape, aVal: float, aText: str) -> None: ...
    def IsMovable(self) -> bool: ...
    def KindOfDimension(self) -> PrsDim_KindOfDimension: ...
    def SetRelativePos(self, aTrsf: gp_Trsf) -> None: ...

class PrsDim_ParallelRelation(PrsDim_Relation):
    @overload
    def __init__(self, aFShape: TopoDS_Shape, aSShape: TopoDS_Shape, aPlane: Geom_Plane) -> None: ...
    @overload
    def __init__(self, aFShape: TopoDS_Shape, aSShape: TopoDS_Shape, aPlane: Geom_Plane, aPosition: gp_Pnt, aSymbolPrs: DsgPrs_ArrowSide, anArrowSize: Optional[float] = 0.01) -> None: ...
    def IsMovable(self) -> bool: ...

class PrsDim_PerpendicularRelation(PrsDim_Relation):
    @overload
    def __init__(self, aFShape: TopoDS_Shape, aSShape: TopoDS_Shape, aPlane: Geom_Plane) -> None: ...
    @overload
    def __init__(self, aFShape: TopoDS_Shape, aSShape: TopoDS_Shape) -> None: ...

class PrsDim_RadiusDimension(PrsDim_Dimension):
    @overload
    def __init__(self, theCircle: gp_Circ) -> None: ...
    @overload
    def __init__(self, theCircle: gp_Circ, theAnchorPoint: gp_Pnt) -> None: ...
    @overload
    def __init__(self, theShape: TopoDS_Shape) -> None: ...
    def AnchorPoint(self) -> gp_Pnt: ...
    def Circle(self) -> gp_Circ: ...
    def GetDisplayUnits(self) -> str: ...
    def GetModelUnits(self) -> str: ...
    def GetTextPosition(self) -> gp_Pnt: ...
    def SetDisplayUnits(self, theUnits: str) -> None: ...
    @overload
    def SetMeasuredGeometry(self, theCircle: gp_Circ) -> None: ...
    @overload
    def SetMeasuredGeometry(self, theCircle: gp_Circ, theAnchorPoint: gp_Pnt, theHasAnchor: Optional[bool] = True) -> None: ...
    @overload
    def SetMeasuredGeometry(self, theShape: TopoDS_Shape) -> None: ...
    @overload
    def SetMeasuredGeometry(self, theShape: TopoDS_Shape, theAnchorPoint: gp_Pnt, theHasAnchor: Optional[bool] = True) -> None: ...
    def SetModelUnits(self, theUnits: str) -> None: ...
    def SetTextPosition(self, theTextPos: gp_Pnt) -> None: ...
    def Shape(self) -> TopoDS_Shape: ...

class PrsDim_SymmetricRelation(PrsDim_Relation):
    def __init__(self, aSymmTool: TopoDS_Shape, FirstShape: TopoDS_Shape, SecondShape: TopoDS_Shape, aPlane: Geom_Plane) -> None: ...
    def GetTool(self) -> TopoDS_Shape: ...
    def IsMovable(self) -> bool: ...
    def SetTool(self, aSymmetricTool: TopoDS_Shape) -> None: ...

class PrsDim_TangentRelation(PrsDim_Relation):
    def __init__(self, aFShape: TopoDS_Shape, aSShape: TopoDS_Shape, aPlane: Geom_Plane, anExternRef: Optional[int] = 0) -> None: ...
    def ExternRef(self) -> int: ...
    def SetExternRef(self, aRef: int) -> None: ...

class PrsDim_MaxRadiusDimension(PrsDim_EllipseRadiusDimension):
    @overload
    def __init__(self, aShape: TopoDS_Shape, aVal: float, aText: str) -> None: ...
    @overload
    def __init__(self, aShape: TopoDS_Shape, aVal: float, aText: str, aPosition: gp_Pnt, aSymbolPrs: DsgPrs_ArrowSide, anArrowSize: Optional[float] = 0.0) -> None: ...

class PrsDim_MinRadiusDimension(PrsDim_EllipseRadiusDimension):
    @overload
    def __init__(self, aShape: TopoDS_Shape, aVal: float, aText: str) -> None: ...
    @overload
    def __init__(self, aShape: TopoDS_Shape, aVal: float, aText: str, aPosition: gp_Pnt, aSymbolPrs: DsgPrs_ArrowSide, anArrowSize: Optional[float] = 0.0) -> None: ...

# harray1 classes
# harray2 classes
# hsequence classes

