# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
BRepLib module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_breplib.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _BRepLib
else:
    import _BRepLib

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _BRepLib.delete_SwigPyIterator

    def value(self):
        return _BRepLib.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _BRepLib.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _BRepLib.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _BRepLib.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _BRepLib.SwigPyIterator_equal(self, x)

    def copy(self):
        return _BRepLib.SwigPyIterator_copy(self)

    def next(self):
        return _BRepLib.SwigPyIterator_next(self)

    def __next__(self):
        return _BRepLib.SwigPyIterator___next__(self)

    def previous(self):
        return _BRepLib.SwigPyIterator_previous(self)

    def advance(self, n):
        return _BRepLib.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _BRepLib.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _BRepLib.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _BRepLib.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _BRepLib.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _BRepLib.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _BRepLib.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _BRepLib:
_BRepLib.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _BRepLib.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.TopoDS
import OCC.Core.Message
import OCC.Core.OSD
import OCC.Core.TopAbs
import OCC.Core.TopLoc
import OCC.Core.GeomAbs
import OCC.Core.Geom2d
import OCC.Core.TColgp
import OCC.Core.TopTools
import OCC.Core.Adaptor3d
import OCC.Core.Geom
import OCC.Core.Adaptor2d
import OCC.Core.math
import OCC.Core.BRepTools
import OCC.Core.Bnd
import OCC.Core.BVH
import OCC.Core.BRep
import OCC.Core.Poly
import OCC.Core.TShort

from enum import IntEnum
from OCC.Core.Exception import *

BRepLib_EdgeDone = _BRepLib.BRepLib_EdgeDone
BRepLib_PointProjectionFailed = _BRepLib.BRepLib_PointProjectionFailed
BRepLib_ParameterOutOfRange = _BRepLib.BRepLib_ParameterOutOfRange
BRepLib_DifferentPointsOnClosedCurve = _BRepLib.BRepLib_DifferentPointsOnClosedCurve
BRepLib_PointWithInfiniteParameter = _BRepLib.BRepLib_PointWithInfiniteParameter
BRepLib_DifferentsPointAndParameter = _BRepLib.BRepLib_DifferentsPointAndParameter
BRepLib_LineThroughIdenticPoints = _BRepLib.BRepLib_LineThroughIdenticPoints
BRepLib_FaceDone = _BRepLib.BRepLib_FaceDone
BRepLib_NoFace = _BRepLib.BRepLib_NoFace
BRepLib_NotPlanar = _BRepLib.BRepLib_NotPlanar
BRepLib_CurveProjectionFailed = _BRepLib.BRepLib_CurveProjectionFailed
BRepLib_ParametersOutOfRange = _BRepLib.BRepLib_ParametersOutOfRange
BRepLib_Preserved = _BRepLib.BRepLib_Preserved
BRepLib_Deleted = _BRepLib.BRepLib_Deleted
BRepLib_Trimmed = _BRepLib.BRepLib_Trimmed
BRepLib_Merged = _BRepLib.BRepLib_Merged
BRepLib_BoundaryModified = _BRepLib.BRepLib_BoundaryModified
BRepLib_ShellDone = _BRepLib.BRepLib_ShellDone
BRepLib_EmptyShell = _BRepLib.BRepLib_EmptyShell
BRepLib_DisconnectedShell = _BRepLib.BRepLib_DisconnectedShell
BRepLib_ShellParametersOutOfRange = _BRepLib.BRepLib_ShellParametersOutOfRange
BRepLib_WireDone = _BRepLib.BRepLib_WireDone
BRepLib_EmptyWire = _BRepLib.BRepLib_EmptyWire
BRepLib_DisconnectedWire = _BRepLib.BRepLib_DisconnectedWire
BRepLib_NonManifoldWire = _BRepLib.BRepLib_NonManifoldWire


class BRepLib_EdgeError(IntEnum):
	BRepLib_EdgeDone = 0
	BRepLib_PointProjectionFailed = 1
	BRepLib_ParameterOutOfRange = 2
	BRepLib_DifferentPointsOnClosedCurve = 3
	BRepLib_PointWithInfiniteParameter = 4
	BRepLib_DifferentsPointAndParameter = 5
	BRepLib_LineThroughIdenticPoints = 6
BRepLib_EdgeDone = BRepLib_EdgeError.BRepLib_EdgeDone
BRepLib_PointProjectionFailed = BRepLib_EdgeError.BRepLib_PointProjectionFailed
BRepLib_ParameterOutOfRange = BRepLib_EdgeError.BRepLib_ParameterOutOfRange
BRepLib_DifferentPointsOnClosedCurve = BRepLib_EdgeError.BRepLib_DifferentPointsOnClosedCurve
BRepLib_PointWithInfiniteParameter = BRepLib_EdgeError.BRepLib_PointWithInfiniteParameter
BRepLib_DifferentsPointAndParameter = BRepLib_EdgeError.BRepLib_DifferentsPointAndParameter
BRepLib_LineThroughIdenticPoints = BRepLib_EdgeError.BRepLib_LineThroughIdenticPoints

class BRepLib_FaceError(IntEnum):
	BRepLib_FaceDone = 0
	BRepLib_NoFace = 1
	BRepLib_NotPlanar = 2
	BRepLib_CurveProjectionFailed = 3
	BRepLib_ParametersOutOfRange = 4
BRepLib_FaceDone = BRepLib_FaceError.BRepLib_FaceDone
BRepLib_NoFace = BRepLib_FaceError.BRepLib_NoFace
BRepLib_NotPlanar = BRepLib_FaceError.BRepLib_NotPlanar
BRepLib_CurveProjectionFailed = BRepLib_FaceError.BRepLib_CurveProjectionFailed
BRepLib_ParametersOutOfRange = BRepLib_FaceError.BRepLib_ParametersOutOfRange

class BRepLib_ShapeModification(IntEnum):
	BRepLib_Preserved = 0
	BRepLib_Deleted = 1
	BRepLib_Trimmed = 2
	BRepLib_Merged = 3
	BRepLib_BoundaryModified = 4
BRepLib_Preserved = BRepLib_ShapeModification.BRepLib_Preserved
BRepLib_Deleted = BRepLib_ShapeModification.BRepLib_Deleted
BRepLib_Trimmed = BRepLib_ShapeModification.BRepLib_Trimmed
BRepLib_Merged = BRepLib_ShapeModification.BRepLib_Merged
BRepLib_BoundaryModified = BRepLib_ShapeModification.BRepLib_BoundaryModified

class BRepLib_ShellError(IntEnum):
	BRepLib_ShellDone = 0
	BRepLib_EmptyShell = 1
	BRepLib_DisconnectedShell = 2
	BRepLib_ShellParametersOutOfRange = 3
BRepLib_ShellDone = BRepLib_ShellError.BRepLib_ShellDone
BRepLib_EmptyShell = BRepLib_ShellError.BRepLib_EmptyShell
BRepLib_DisconnectedShell = BRepLib_ShellError.BRepLib_DisconnectedShell
BRepLib_ShellParametersOutOfRange = BRepLib_ShellError.BRepLib_ShellParametersOutOfRange

class BRepLib_WireError(IntEnum):
	BRepLib_WireDone = 0
	BRepLib_EmptyWire = 1
	BRepLib_DisconnectedWire = 2
	BRepLib_NonManifoldWire = 3
BRepLib_WireDone = BRepLib_WireError.BRepLib_WireDone
BRepLib_EmptyWire = BRepLib_WireError.BRepLib_EmptyWire
BRepLib_DisconnectedWire = BRepLib_WireError.BRepLib_DisconnectedWire
BRepLib_NonManifoldWire = BRepLib_WireError.BRepLib_NonManifoldWire

class breplib(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def BoundingVertex(*args):
        r"""

        Parameters
        ----------
        theLV: NCollection_List<TopoDS_Shape>
        theNewCenter: gp_Pnt

        Return
        -------
        theNewTol: float

        Description
        -----------
        Calculates the bounding sphere around the set of vertexes from the thelv list. returns the center (thenewcenter) and the radius (thenewtol) of this sphere. this can be used to construct the new vertex which covers the given set of other vertices.

        """
        return _BRepLib.breplib_BoundingVertex(*args)

    @staticmethod
    def BuildCurve3d(*args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge
        Tolerance: float (optional, default to 1.0e-5)
        Continuity: GeomAbs_Shape (optional, default to GeomAbs_C1)
        MaxDegree: int (optional, default to 14)
        MaxSegment: int (optional, default to 0)

        Return
        -------
        bool

        Description
        -----------
        Computes the 3d curve for the edge <e> if it does not exist. returns true if the curve was computed or existed. returns false if there is no planar pcurve or the computation failed. <maxsegment> >= 30 in approximation.

        """
        return _BRepLib.breplib_BuildCurve3d(*args)

    @staticmethod
    def BuildCurves3d(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        Tolerance: float
        Continuity: GeomAbs_Shape (optional, default to GeomAbs_C1)
        MaxDegree: int (optional, default to 14)
        MaxSegment: int (optional, default to 0)

        Return
        -------
        bool

        Description
        -----------
        Computes the 3d curves for all the edges of <s> return false if one of the computation failed. <maxsegment> >= 30 in approximation.

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        Computes the 3d curves for all the edges of <s> return false if one of the computation failed.

        """
        return _BRepLib.breplib_BuildCurves3d(*args)

    @staticmethod
    def BuildPCurveForEdgeOnPlane(*args):
        r"""

        Parameters
        ----------
        theE: TopoDS_Edge
        theF: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Builds pcurve of edge on face if the surface is plane, and updates the edge.

        Parameters
        ----------
        theE: TopoDS_Edge
        theF: TopoDS_Face
        aC2D: Geom2d_Curve

        Return
        -------
        bToUpdate: bool

        Description
        -----------
        Builds pcurve of edge on face if the surface is plane, but does not update the edge. the output are the pcurve and the flag telling that pcurve was built.

        """
        return _BRepLib.breplib_BuildPCurveForEdgeOnPlane(*args)

    @staticmethod
    def CheckSameRange(*args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge
        Confusion: float (optional, default to 1.0e-12)

        Return
        -------
        bool

        Description
        -----------
        Checks if the edge is same range ignoring the same range flag of the edge confusion argument is to compare real numbers idenpendently of any model space tolerance.

        """
        return _BRepLib.breplib_CheckSameRange(*args)

    @staticmethod
    def ContinuityOfFaces(*args):
        r"""

        Parameters
        ----------
        theEdge: TopoDS_Edge
        theFace1: TopoDS_Face
        theFace2: TopoDS_Face
        theAngleTol: float

        Return
        -------
        GeomAbs_Shape

        Description
        -----------
        Returns the order of continuity between two faces connected by an edge.

        """
        return _BRepLib.breplib_ContinuityOfFaces(*args)

    @staticmethod
    def EncodeRegularity(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        TolAng: float (optional, default to 1.0e-10)

        Return
        -------
        None

        Description
        -----------
        Encodes the regularity of edges on a shape. warning: <tolang> is an angular tolerance, expressed in rad. warning: if the edges's regularity are coded before, nothing is done.

        Parameters
        ----------
        S: TopoDS_Shape
        LE: TopTools_ListOfShape
        TolAng: float (optional, default to 1.0e-10)

        Return
        -------
        None

        Description
        -----------
        Encodes the regularity of edges in list <le> on the shape <s> warning: <tolang> is an angular tolerance, expressed in rad. warning: if the edges's regularity are coded before, nothing is done.

        Parameters
        ----------
        E: TopoDS_Edge
        F1: TopoDS_Face
        F2: TopoDS_Face
        TolAng: float (optional, default to 1.0e-10)

        Return
        -------
        None

        Description
        -----------
        Encodes the regularity between <f1> and <f2> by <e> warning: <tolang> is an angular tolerance, expressed in rad. warning: if the edge's regularity is coded before, nothing is done.

        """
        return _BRepLib.breplib_EncodeRegularity(*args)

    @staticmethod
    def EnsureNormalConsistency(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        theAngTol: float (optional, default to 0.001)
        ForceComputeNormals: bool (optional, default to Standard_False)

        Return
        -------
        bool

        Description
        -----------
        Corrects the normals in poly_triangulation of faces, in such way that normals at nodes lying along smooth edges have the same value on both adjacent triangulations. returns true if any correction is done.

        """
        return _BRepLib.breplib_EnsureNormalConsistency(*args)

    @staticmethod
    def ExtendFace(*args):
        r"""

        Parameters
        ----------
        theF: TopoDS_Face
        theExtVal: float
        theExtUMin: bool
        theExtUMax: bool
        theExtVMin: bool
        theExtVMax: bool
        theFExtended: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Enlarges the face on the given value. @param thef [in] the face to extend @param theextval [in] the extension value @param theextumin [in] defines whether to extend the face in umin direction @param theextumax [in] defines whether to extend the face in umax direction @param theextvmin [in] defines whether to extend the face in vmin direction @param theextvmax [in] defines whether to extend the face in vmax direction @param thefextended [in] the extended face.

        """
        return _BRepLib.breplib_ExtendFace(*args)

    @staticmethod
    def FindValidRange(*args):
        r"""

        Parameters
        ----------
        theCurve: Adaptor3d_Curve
        theTolE: float
        theParV1: float
        thePntV1: gp_Pnt
        theTolV1: float
        theParV2: float
        thePntV2: gp_Pnt
        theTolV2: float

        Return
        -------
        theFirst: float
        theLast: float

        Description
        -----------
        For an edge defined by 3d curve and tolerance and vertices defined by points, parameters on curve and tolerances, finds a range of curve between vertices not covered by vertices tolerances. returns false if there is no such range. otherwise, sets thefirst and thelast as its bounds.

        Parameters
        ----------
        theEdge: TopoDS_Edge

        Return
        -------
        theFirst: float
        theLast: float

        Description
        -----------
        Finds a range of 3d curve of the edge not covered by vertices tolerances. returns false if there is no such range. otherwise, sets thefirst and thelast as its bounds.

        """
        return _BRepLib.breplib_FindValidRange(*args)

    @staticmethod
    def OrientClosedSolid(*args):
        r"""

        Parameters
        ----------
        solid: TopoDS_Solid

        Return
        -------
        bool

        Description
        -----------
        Orients the solid forward and the shell with the orientation to have matter in the solid. returns false if the solid is unorientable (open or incoherent).

        """
        return _BRepLib.breplib_OrientClosedSolid(*args)

    @staticmethod
    def Plane(*args):
        r"""

        Parameters
        ----------
        P: Geom_Plane

        Return
        -------
        None

        Description
        -----------
        Sets the current plane to p.
        Return
        -------
        opencascade::handle<Geom_Plane>

        Description
        -----------
        Returns the current plane.

        """
        return _BRepLib.breplib_Plane(*args)

    @staticmethod
    def Precision(*args):
        r"""

        Parameters
        ----------
        P: float

        Return
        -------
        None

        Description
        -----------
        Computes the max distance between edge and its 2d representation on the face. sets the default precision. the current precision is returned.
        Return
        -------
        float

        Description
        -----------
        Returns the default precision.

        """
        return _BRepLib.breplib_Precision(*args)

    @staticmethod
    def ReverseSortFaces(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        LF: TopTools_ListOfShape

        Return
        -------
        None

        Description
        -----------
        Sorts in lf the faces of s on the reverse complexity of their surfaces (other,torus,sphere,cone,cylinder,plane).

        """
        return _BRepLib.breplib_ReverseSortFaces(*args)

    @staticmethod
    def SameParameter(*args):
        r"""

        Parameters
        ----------
        theEdge: TopoDS_Edge
        Tolerance: float (optional, default to 1.0e-5)

        Return
        -------
        None

        Description
        -----------
        Computes new 2d curve(s) for the edge <theedge> to have the same parameter as the 3d curve. the algorithm is not done if the flag sameparameter was true on the edge.

        Parameters
        ----------
        theEdge: TopoDS_Edge
        theTolerance: float
        IsUseOldEdge: bool

        Return
        -------
        theNewTol: float

        Description
        -----------
        Computes new 2d curve(s) for the edge <theedge> to have the same parameter as the 3d curve. the algorithm is not done if the flag sameparameter was true on the edge. thenewtol is a new tolerance of vertices of the input edge (not applied inside the algorithm, but pre-computed). if isuseoldedge is true then the input edge will be modified, otherwise the new copy of input edge will be created. returns the new edge as a result, can be ignored if isuseoldedge is true.

        Parameters
        ----------
        S: TopoDS_Shape
        Tolerance: float (optional, default to 1.0e-5)
        forced: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Computes new 2d curve(s) for all the edges of <s> to have the same parameter as the 3d curve. the algorithm is not done if the flag sameparameter was true on an edge.

        Parameters
        ----------
        S: TopoDS_Shape
        theReshaper: BRepTools_ReShape
        Tolerance: float (optional, default to 1.0e-5)
        forced: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Computes new 2d curve(s) for all the edges of <s> to have the same parameter as the 3d curve. the algorithm is not done if the flag sameparameter was true on an edge. thereshaper is used to record the modifications of input shape <s> to prevent any modifications on the shape itself. thus the input shape (and its subshapes) will not be modified, instead the reshaper will contain a modified empty-copies of original subshapes as substitutions.

        """
        return _BRepLib.breplib_SameParameter(*args)

    @staticmethod
    def SameRange(*args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge
        Tolerance: float (optional, default to 1.0e-5)

        Return
        -------
        None

        Description
        -----------
        Will make all the curve representation have the same range domain for the parameters. this will ignore the same range flag value to proceed. if there is a 3d curve there it will the range of that curve. if not the first curve representation encountered in the list will give its range to the all the other curves.

        """
        return _BRepLib.breplib_SameRange(*args)

    @staticmethod
    def SortFaces(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        LF: TopTools_ListOfShape

        Return
        -------
        None

        Description
        -----------
        Sorts in lf the faces of s on the complexity of their surfaces (plane,cylinder,cone,sphere,torus,other).

        """
        return _BRepLib.breplib_SortFaces(*args)

    @staticmethod
    def UpdateDeflection(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Updates value of deflection in poly_triangulation of faces by the maximum deviation measured on existing triangulation.

        """
        return _BRepLib.breplib_UpdateDeflection(*args)

    @staticmethod
    def UpdateEdgeTol(*args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge
        MinToleranceRequest: float
        MaxToleranceToCheck: float

        Return
        -------
        bool

        Description
        -----------
        Checks if the edge has a tolerance smaller than -- -- -- -- maxtolerancetocheck if so it will compute the radius of -- the cylindrical pipe surface that mintolerancerequest is the minimum tolerance before it is useful to start testing. usually it should be around 10e-5 contains all -- the curve representation of the edge returns true if the edge tolerance had to be updated.

        """
        return _BRepLib.breplib_UpdateEdgeTol(*args)

    @staticmethod
    def UpdateEdgeTolerance(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        MinToleranceRequest: float
        MaxToleranceToCheck: float

        Return
        -------
        bool

        Description
        -----------
        -- checks all the edges of the shape whose -- -- -- tolerance is smaller than maxtolerancetocheck -- returns true if at least one edge was updated -- mintolerancerequest is the minimum tolerance before -- it -- is useful to start testing. usually it should be around -- 10e-5-- //! warning :the method is very slow as it checks all. use only in interfaces or processing assimilate batch.

        """
        return _BRepLib.breplib_UpdateEdgeTolerance(*args)

    @staticmethod
    def UpdateInnerTolerances(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Checks tolerances of edges (including inner points) and vertices of a shape and updates them to satisfy 'sameparameter' condition.

        """
        return _BRepLib.breplib_UpdateInnerTolerances(*args)

    @staticmethod
    def UpdateTolerances(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        verifyFaceTolerance: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Replaces tolerance of face edge vertex by the tolerance max of their connected handling shapes. it is not necessary to use this call after sameparameter. (called in).

        Parameters
        ----------
        S: TopoDS_Shape
        theReshaper: BRepTools_ReShape
        verifyFaceTolerance: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Replaces tolerance of face edge vertex by the tolerance max of their connected handling shapes. it is not necessary to use this call after sameparameter. (called in) thereshaper is used to record the modifications of input shape <s> to prevent any modifications on the shape itself. thus the input shape (and its subshapes) will not be modified, instead the reshaper will contain a modified empty-copies of original subshapes as substitutions.

        """
        return _BRepLib.breplib_UpdateTolerances(*args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def BuildPCurveForEdgesOnPlane(self):
    	pass


    def __init__(self):
        _BRepLib.breplib_swiginit(self, _BRepLib.new_breplib())
    __swig_destroy__ = _BRepLib.delete_breplib

# Register breplib in _BRepLib:
_BRepLib.breplib_swigregister(breplib)
class BRepLib_CheckCurveOnSurface(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Default constructor.

        Parameters
        ----------
        theEdge: TopoDS_Edge
        theFace: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Constructor.

        """
        _BRepLib.BRepLib_CheckCurveOnSurface_swiginit(self, _BRepLib.new_BRepLib_CheckCurveOnSurface(*args))

    def ErrorStatus(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns error status the possible values are: 0 - ok; 1 - null curve or surface or 2d curve; 2 - invalid parametric range; 3 - error in calculations.

        """
        return _BRepLib.BRepLib_CheckCurveOnSurface_ErrorStatus(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        theEdge: TopoDS_Edge
        theFace: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Sets the data for the algorithm.

        """
        return _BRepLib.BRepLib_CheckCurveOnSurface_Init(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the max distance has been found.

        """
        return _BRepLib.BRepLib_CheckCurveOnSurface_IsDone(self, *args)

    def IsParallel(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if parallel flag is set.

        """
        return _BRepLib.BRepLib_CheckCurveOnSurface_IsParallel(self, *args)

    def MaxDistance(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns max distance.

        """
        return _BRepLib.BRepLib_CheckCurveOnSurface_MaxDistance(self, *args)

    def MaxParameter(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns parameter in which the distance is maximal.

        """
        return _BRepLib.BRepLib_CheckCurveOnSurface_MaxParameter(self, *args)

    def Perform(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Performs the calculation if myisparallel == standard_true then computation will be performed in parallel.

        """
        return _BRepLib.BRepLib_CheckCurveOnSurface_Perform(self, *args)

    def SetParallel(self, *args):
        r"""

        Parameters
        ----------
        theIsParallel: bool

        Return
        -------
        None

        Description
        -----------
        Sets parallel flag.

        """
        return _BRepLib.BRepLib_CheckCurveOnSurface_SetParallel(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_CheckCurveOnSurface

# Register BRepLib_CheckCurveOnSurface in _BRepLib:
_BRepLib.BRepLib_CheckCurveOnSurface_swigregister(BRepLib_CheckCurveOnSurface)
class BRepLib_Command(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Check(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Raises notdone if done is false.

        """
        return _BRepLib.BRepLib_Command_Check(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _BRepLib.BRepLib_Command_IsDone(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_Command

# Register BRepLib_Command in _BRepLib:
_BRepLib.BRepLib_Command_swigregister(BRepLib_Command)
class BRepLib_FindSurface(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: TopoDS_Shape
        Tol: float (optional, default to -1)
        OnlyPlane: bool (optional, default to Standard_False)
        OnlyClosed: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Computes the surface from the edges of <s> with the given tolerance. if <onlyplane> is true, the computed surface will be a plane. if it is not possible to find a plane, the flag notdone will be set. if <onlyclosed> is true, then s should be a wire and the existing surface, on which wire s is not closed in 2d, will be ignored.

        """
        _BRepLib.BRepLib_FindSurface_swiginit(self, _BRepLib.new_BRepLib_FindSurface(*args))

    def Existed(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _BRepLib.BRepLib_FindSurface_Existed(self, *args)

    def Found(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _BRepLib.BRepLib_FindSurface_Found(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        Tol: float (optional, default to -1)
        OnlyPlane: bool (optional, default to Standard_False)
        OnlyClosed: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Computes the surface from the edges of <s> with the given tolerance. if <onlyplane> is true, the computed surface will be a plane. if it is not possible to find a plane, the flag notdone will be set. if <onlyclosed> is true, then s should be a wire and the existing surface, on which wire s is not closed in 2d, will be ignored.

        """
        return _BRepLib.BRepLib_FindSurface_Init(self, *args)

    def Location(self, *args):
        r"""
        Return
        -------
        TopLoc_Location

        Description
        -----------
        No available documentation.

        """
        return _BRepLib.BRepLib_FindSurface_Location(self, *args)

    def Surface(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom_Surface>

        Description
        -----------
        No available documentation.

        """
        return _BRepLib.BRepLib_FindSurface_Surface(self, *args)

    def Tolerance(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _BRepLib.BRepLib_FindSurface_Tolerance(self, *args)

    def ToleranceReached(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _BRepLib.BRepLib_FindSurface_ToleranceReached(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_FindSurface

# Register BRepLib_FindSurface in _BRepLib:
_BRepLib.BRepLib_FindSurface_swigregister(BRepLib_FindSurface)
class BRepLib_FuseEdges(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape
        PerformNow: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Initialise members and build construction of map of ancestors.

        """
        _BRepLib.BRepLib_FuseEdges_swiginit(self, _BRepLib.new_BRepLib_FuseEdges(*args))

    def AvoidEdges(self, *args):
        r"""

        Parameters
        ----------
        theMapEdg: TopTools_IndexedMapOfShape

        Return
        -------
        None

        Description
        -----------
        Set edges to avoid being fused.

        """
        return _BRepLib.BRepLib_FuseEdges_AvoidEdges(self, *args)

    def Edges(self, *args):
        r"""

        Parameters
        ----------
        theMapLstEdg: TopTools_DataMapOfIntegerListOfShape

        Return
        -------
        None

        Description
        -----------
        Returns all the list of edges to be fused each list of the map represent a set of connex edges that can be fused.

        """
        return _BRepLib.BRepLib_FuseEdges_Edges(self, *args)

    def Faces(self, *args):
        r"""

        Parameters
        ----------
        theMapFac: TopTools_DataMapOfShapeShape

        Return
        -------
        None

        Description
        -----------
        Returns the map of modified faces.

        """
        return _BRepLib.BRepLib_FuseEdges_Faces(self, *args)

    def NbVertices(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of vertices candidate to be removed.

        """
        return _BRepLib.BRepLib_FuseEdges_NbVertices(self, *args)

    def Perform(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Using map of list of connex edges, fuse each list to one edge and then update myshape.

        """
        return _BRepLib.BRepLib_FuseEdges_Perform(self, *args)

    def ResultEdges(self, *args):
        r"""

        Parameters
        ----------
        theMapEdg: TopTools_DataMapOfIntegerShape

        Return
        -------
        None

        Description
        -----------
        Returns all the fused edges. each integer entry in the map corresponds to the integer in the datamapofintegerlistofshape we get in method edges. that is to say, to the list of edges in themaplstedg(i) corresponds the resulting edge themapedge(i).

        """
        return _BRepLib.BRepLib_FuseEdges_ResultEdges(self, *args)

    def SetConcatBSpl(self, *args):
        r"""

        Parameters
        ----------
        theConcatBSpl: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Set mode to enable concatenation g1 bspline edges in one end modified by ifv 19.04.07.

        """
        return _BRepLib.BRepLib_FuseEdges_SetConcatBSpl(self, *args)

    def Shape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns myshape modified with the list of internal edges removed from it.

        """
        return _BRepLib.BRepLib_FuseEdges_Shape(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_FuseEdges

# Register BRepLib_FuseEdges in _BRepLib:
_BRepLib.BRepLib_FuseEdges_swigregister(BRepLib_FuseEdges)
class BRepLib_PointCloudShape(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def GeneratePointsByDensity(self, *args):
        r"""

        Parameters
        ----------
        theDensity: float (optional, default to 0.0)

        Return
        -------
        bool

        Description
        -----------
        Computes points with specified density for initial shape. if parameter density is equal to 0 then density will be computed automatically by criterion: - 10 points per minimal unreduced face area. //! note: this function should not be called from concurrent threads without external lock.

        """
        return _BRepLib.BRepLib_PointCloudShape_GeneratePointsByDensity(self, *args)

    def GeneratePointsByTriangulation(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Get points from triangulation existing in the shape.

        """
        return _BRepLib.BRepLib_PointCloudShape_GeneratePointsByTriangulation(self, *args)

    def GetDistance(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns value of the distance to define deflection of points from shape along normal to shape; 0.0 by default.

        """
        return _BRepLib.BRepLib_PointCloudShape_GetDistance(self, *args)

    def NbPointsByDensity(self, *args):
        r"""

        Parameters
        ----------
        theDensity: float (optional, default to 0.0)

        Return
        -------
        int

        Description
        -----------
        Returns size of the point cloud for specified density.

        """
        return _BRepLib.BRepLib_PointCloudShape_NbPointsByDensity(self, *args)

    def NbPointsByTriangulation(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns size of the point cloud for using triangulation.

        """
        return _BRepLib.BRepLib_PointCloudShape_NbPointsByTriangulation(self, *args)

    def SetDistance(self, *args):
        r"""

        Parameters
        ----------
        theDist: float

        Return
        -------
        None

        Description
        -----------
        Sets value of the distance to define deflection of points from shape along normal to shape. negative values of thedist parameter are ignored.

        """
        return _BRepLib.BRepLib_PointCloudShape_SetDistance(self, *args)

    def SetShape(self, *args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Set shape.

        """
        return _BRepLib.BRepLib_PointCloudShape_SetShape(self, *args)

    def SetTolerance(self, *args):
        r"""

        Parameters
        ----------
        theTol: float

        Return
        -------
        None

        Description
        -----------
        Set tolerance.

        """
        return _BRepLib.BRepLib_PointCloudShape_SetTolerance(self, *args)

    def Shape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Return loaded shape.

        """
        return _BRepLib.BRepLib_PointCloudShape_Shape(self, *args)

    def Tolerance(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Return tolerance.

        """
        return _BRepLib.BRepLib_PointCloudShape_Tolerance(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_PointCloudShape

# Register BRepLib_PointCloudShape in _BRepLib:
_BRepLib.BRepLib_PointCloudShape_swigregister(BRepLib_PointCloudShape)
class BRepLib_ToolTriangulatedShape(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def ComputeNormals(*args):
        r"""

        Parameters
        ----------
        theFace: TopoDS_Face
        theTris: Poly_Triangulation

        Return
        -------
        None

        Description
        -----------
        Computes nodal normals for poly_triangulation structure using uv coordinates and surface. does nothing if triangulation already defines normals. @param[in] theface the face @param[in] thetris the definition of a face triangulation.

        Parameters
        ----------
        theFace: TopoDS_Face
        theTris: Poly_Triangulation
        thePolyConnect: Poly_Connect

        Return
        -------
        None

        Description
        -----------
        Computes nodal normals for poly_triangulation structure using uv coordinates and surface. does nothing if triangulation already defines normals. @param[in] theface the face @param[in] thetris the definition of a face triangulation @param[in,out] thepolyconnect optional, initialized tool for exploring triangulation.

        """
        return _BRepLib.BRepLib_ToolTriangulatedShape_ComputeNormals(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _BRepLib.BRepLib_ToolTriangulatedShape_swiginit(self, _BRepLib.new_BRepLib_ToolTriangulatedShape())
    __swig_destroy__ = _BRepLib.delete_BRepLib_ToolTriangulatedShape

# Register BRepLib_ToolTriangulatedShape in _BRepLib:
_BRepLib.BRepLib_ToolTriangulatedShape_swigregister(BRepLib_ToolTriangulatedShape)
class BRepLib_ValidateEdge(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theReferenceCurve: Adaptor3d_Curve
        theOtherCurve: Adaptor3d_CurveOnSurface
        theSameParameter: bool

        Return
        -------
        None

        Description
        -----------
        Initialization constructor.

        """
        _BRepLib.BRepLib_ValidateEdge_swiginit(self, _BRepLib.new_BRepLib_ValidateEdge(*args))

    def CheckTolerance(self, *args):
        r"""

        Parameters
        ----------
        theToleranceToCheck: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if computed distance is less than <thetolerancetocheck>.

        """
        return _BRepLib.BRepLib_ValidateEdge_CheckTolerance(self, *args)

    def GetMaxDistance(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns max distance.

        """
        return _BRepLib.BRepLib_ValidateEdge_GetMaxDistance(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the distance has been found for all points.

        """
        return _BRepLib.BRepLib_ValidateEdge_IsDone(self, *args)

    def IsExactMethod(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if exact method selected.

        """
        return _BRepLib.BRepLib_ValidateEdge_IsExactMethod(self, *args)

    def IsParallel(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if parallel flag is set.

        """
        return _BRepLib.BRepLib_ValidateEdge_IsParallel(self, *args)

    def Process(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Computes the max distance for the 3d curve <myreferencecurve> and curve on surface <myothercurve>. if the setexitiftoleranceexceeded() function was called before <mycalculateddistance> contains first greater than setexitiftoleranceexceeded() parameter value. in case using exact method always computes real max distance.

        """
        return _BRepLib.BRepLib_ValidateEdge_Process(self, *args)

    def SetControlPointsNumber(self, *args):
        r"""

        Parameters
        ----------
        theControlPointsNumber: int

        Return
        -------
        None

        Description
        -----------
        Set control points number (if you need a value other than 22).

        """
        return _BRepLib.BRepLib_ValidateEdge_SetControlPointsNumber(self, *args)

    def SetExactMethod(self, *args):
        r"""

        Parameters
        ----------
        theIsExact: bool

        Return
        -------
        None

        Description
        -----------
        Sets method to calculate distance: calculating in finite number of points (if theisexact is false, faster, but possible not correct result) or exact calculating by using breplib_checkcurveonsurface class (if theisexact is true, slowly, but more correctly). exact method is used only when edge is sameparameter. default method is calculating in finite number of points.

        """
        return _BRepLib.BRepLib_ValidateEdge_SetExactMethod(self, *args)

    def SetParallel(self, *args):
        r"""

        Parameters
        ----------
        theIsMultiThread: bool

        Return
        -------
        None

        Description
        -----------
        Sets parallel flag.

        """
        return _BRepLib.BRepLib_ValidateEdge_SetParallel(self, *args)

    def UpdateTolerance(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        theToleranceToUpdate: float

        Description
        -----------
        Increase <thetolerancetoupdate> if max distance is greater than <thetolerancetoupdate>.

        """
        return _BRepLib.BRepLib_ValidateEdge_UpdateTolerance(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def SetExitIfToleranceExceeded(self):
    	pass

    __swig_destroy__ = _BRepLib.delete_BRepLib_ValidateEdge

# Register BRepLib_ValidateEdge in _BRepLib:
_BRepLib.BRepLib_ValidateEdge_swigregister(BRepLib_ValidateEdge)
class BRepLib_MakeShape(BRepLib_Command):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Build(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        This is called by shape(). it does nothing but may be redefined.

        """
        return _BRepLib.BRepLib_MakeShape_Build(self, *args)

    def DescendantFaces(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the list of generated faces.

        """
        return _BRepLib.BRepLib_MakeShape_DescendantFaces(self, *args)

    def FaceStatus(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        BRepLib_ShapeModification

        Description
        -----------
        Returns the status of the face after the shape creation.

        """
        return _BRepLib.BRepLib_MakeShape_FaceStatus(self, *args)

    def FacesFromEdges(self, *args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge

        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns a list of the created faces from the edge <e>.

        """
        return _BRepLib.BRepLib_MakeShape_FacesFromEdges(self, *args)

    def HasDescendants(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        bool

        Description
        -----------
        Returns true if the face generates new topology.

        """
        return _BRepLib.BRepLib_MakeShape_HasDescendants(self, *args)

    def NbSurfaces(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of surfaces after the shape creation.

        """
        return _BRepLib.BRepLib_MakeShape_NbSurfaces(self, *args)

    def NewFaces(self, *args):
        r"""

        Parameters
        ----------
        I: int

        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Return the faces created for surface i.

        """
        return _BRepLib.BRepLib_MakeShape_NewFaces(self, *args)

    def Shape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        No available documentation.

        """
        return _BRepLib.BRepLib_MakeShape_Shape(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_MakeShape

# Register BRepLib_MakeShape in _BRepLib:
_BRepLib.BRepLib_MakeShape_swigregister(BRepLib_MakeShape)
class BRepLib_MakeEdge(BRepLib_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Lin

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Lin
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Lin
        P1: gp_Pnt
        P2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Lin
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Circ

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Circ
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Circ
        P1: gp_Pnt
        P2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Circ
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Elips

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Elips
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Elips
        P1: gp_Pnt
        P2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Elips
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Hypr

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Hypr
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Hypr
        P1: gp_Pnt
        P2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Hypr
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Parab

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Parab
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Parab
        P1: gp_Pnt
        P2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Parab
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: Geom_Curve

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: Geom_Curve
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: Geom_Curve
        P1: gp_Pnt
        P2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: Geom_Curve
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: Geom_Curve
        P1: gp_Pnt
        P2: gp_Pnt
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: Geom_Curve
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: Geom2d_Curve
        S: Geom_Surface

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: Geom2d_Curve
        S: Geom_Surface
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: Geom2d_Curve
        S: Geom_Surface
        P1: gp_Pnt
        P2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: Geom2d_Curve
        S: Geom_Surface
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: Geom2d_Curve
        S: Geom_Surface
        P1: gp_Pnt
        P2: gp_Pnt
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: Geom2d_Curve
        S: Geom_Surface
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BRepLib.BRepLib_MakeEdge_swiginit(self, _BRepLib.new_BRepLib_MakeEdge(*args))

    def Edge(self, *args):
        r"""
        Return
        -------
        TopoDS_Edge

        Description
        -----------
        No available documentation.

        """
        return _BRepLib.BRepLib_MakeEdge_Edge(self, *args)

    def Error(self, *args):
        r"""
        Return
        -------
        BRepLib_EdgeError

        Description
        -----------
        Returns the error description when notdone.

        """
        return _BRepLib.BRepLib_MakeEdge_Error(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        C: Geom_Curve

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: Geom_Curve
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: Geom_Curve
        P1: gp_Pnt
        P2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: Geom_Curve
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: Geom_Curve
        P1: gp_Pnt
        P2: gp_Pnt
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: Geom_Curve
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: Geom2d_Curve
        S: Geom_Surface

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: Geom2d_Curve
        S: Geom_Surface
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: Geom2d_Curve
        S: Geom_Surface
        P1: gp_Pnt
        P2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: Geom2d_Curve
        S: Geom_Surface
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: Geom2d_Curve
        S: Geom_Surface
        P1: gp_Pnt
        P2: gp_Pnt
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: Geom2d_Curve
        S: Geom_Surface
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepLib.BRepLib_MakeEdge_Init(self, *args)

    def Vertex1(self, *args):
        r"""
        Return
        -------
        TopoDS_Vertex

        Description
        -----------
        Returns the first vertex of the edge. may be null.

        """
        return _BRepLib.BRepLib_MakeEdge_Vertex1(self, *args)

    def Vertex2(self, *args):
        r"""
        Return
        -------
        TopoDS_Vertex

        Description
        -----------
        Returns the second vertex of the edge. may be null.

        """
        return _BRepLib.BRepLib_MakeEdge_Vertex2(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_MakeEdge

# Register BRepLib_MakeEdge in _BRepLib:
_BRepLib.BRepLib_MakeEdge_swigregister(BRepLib_MakeEdge)
class BRepLib_MakeEdge2d(BRepLib_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Lin2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Lin2d
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Lin2d
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Lin2d
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Circ2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Circ2d
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Circ2d
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Circ2d
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Elips2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Elips2d
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Elips2d
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Elips2d
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Hypr2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Hypr2d
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Hypr2d
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Hypr2d
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Parab2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Parab2d
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Parab2d
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Parab2d
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: Geom2d_Curve

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: Geom2d_Curve
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: Geom2d_Curve
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: Geom2d_Curve
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: Geom2d_Curve
        P1: gp_Pnt2d
        P2: gp_Pnt2d
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: Geom2d_Curve
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BRepLib.BRepLib_MakeEdge2d_swiginit(self, _BRepLib.new_BRepLib_MakeEdge2d(*args))

    def Edge(self, *args):
        r"""
        Return
        -------
        TopoDS_Edge

        Description
        -----------
        No available documentation.

        """
        return _BRepLib.BRepLib_MakeEdge2d_Edge(self, *args)

    def Error(self, *args):
        r"""
        Return
        -------
        BRepLib_EdgeError

        Description
        -----------
        Returns the error description when notdone.

        """
        return _BRepLib.BRepLib_MakeEdge2d_Error(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        C: Geom2d_Curve

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: Geom2d_Curve
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: Geom2d_Curve
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: Geom2d_Curve
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: Geom2d_Curve
        P1: gp_Pnt2d
        P2: gp_Pnt2d
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: Geom2d_Curve
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex
        p1: float
        p2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepLib.BRepLib_MakeEdge2d_Init(self, *args)

    def Vertex1(self, *args):
        r"""
        Return
        -------
        TopoDS_Vertex

        Description
        -----------
        Returns the first vertex of the edge. may be null.

        """
        return _BRepLib.BRepLib_MakeEdge2d_Vertex1(self, *args)

    def Vertex2(self, *args):
        r"""
        Return
        -------
        TopoDS_Vertex

        Description
        -----------
        Returns the second vertex of the edge. may be null.

        """
        return _BRepLib.BRepLib_MakeEdge2d_Vertex2(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_MakeEdge2d

# Register BRepLib_MakeEdge2d in _BRepLib:
_BRepLib.BRepLib_MakeEdge2d_swigregister(BRepLib_MakeEdge2d)
class BRepLib_MakeFace(BRepLib_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Not done.

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Load a face. useful to add wires.

        Parameters
        ----------
        P: gp_Pln

        Return
        -------
        None

        Description
        -----------
        Make a face from a plane.

        Parameters
        ----------
        C: gp_Cylinder

        Return
        -------
        None

        Description
        -----------
        Make a face from a cylinder.

        Parameters
        ----------
        C: gp_Cone

        Return
        -------
        None

        Description
        -----------
        Make a face from a cone.

        Parameters
        ----------
        S: gp_Sphere

        Return
        -------
        None

        Description
        -----------
        Make a face from a sphere.

        Parameters
        ----------
        C: gp_Torus

        Return
        -------
        None

        Description
        -----------
        Make a face from a torus.

        Parameters
        ----------
        S: Geom_Surface
        TolDegen: float

        Return
        -------
        None

        Description
        -----------
        Make a face from a surface. accepts tolerance value (toldegen) for resolution of degenerated edges.

        Parameters
        ----------
        P: gp_Pln
        UMin: float
        UMax: float
        VMin: float
        VMax: float

        Return
        -------
        None

        Description
        -----------
        Make a face from a plane.

        Parameters
        ----------
        C: gp_Cylinder
        UMin: float
        UMax: float
        VMin: float
        VMax: float

        Return
        -------
        None

        Description
        -----------
        Make a face from a cylinder.

        Parameters
        ----------
        C: gp_Cone
        UMin: float
        UMax: float
        VMin: float
        VMax: float

        Return
        -------
        None

        Description
        -----------
        Make a face from a cone.

        Parameters
        ----------
        S: gp_Sphere
        UMin: float
        UMax: float
        VMin: float
        VMax: float

        Return
        -------
        None

        Description
        -----------
        Make a face from a sphere.

        Parameters
        ----------
        C: gp_Torus
        UMin: float
        UMax: float
        VMin: float
        VMax: float

        Return
        -------
        None

        Description
        -----------
        Make a face from a torus.

        Parameters
        ----------
        S: Geom_Surface
        UMin: float
        UMax: float
        VMin: float
        VMax: float
        TolDegen: float

        Return
        -------
        None

        Description
        -----------
        Make a face from a surface. accepts min & max parameters to construct the face's bounds. also accepts tolerance value (toldegen) for resolution of degenerated edges.

        Parameters
        ----------
        W: TopoDS_Wire
        OnlyPlane: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Find a surface from the wire and make a face. if <onlyplane> is true, the computed surface will be a plane. if it is not possible to find a plane, the flag notdone will be set.

        Parameters
        ----------
        P: gp_Pln
        W: TopoDS_Wire
        Inside: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Make a face from a plane and a wire.

        Parameters
        ----------
        C: gp_Cylinder
        W: TopoDS_Wire
        Inside: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Make a face from a cylinder and a wire.

        Parameters
        ----------
        C: gp_Cone
        W: TopoDS_Wire
        Inside: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Make a face from a cone and a wire.

        Parameters
        ----------
        S: gp_Sphere
        W: TopoDS_Wire
        Inside: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Make a face from a sphere and a wire.

        Parameters
        ----------
        C: gp_Torus
        W: TopoDS_Wire
        Inside: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Make a face from a torus and a wire.

        Parameters
        ----------
        S: Geom_Surface
        W: TopoDS_Wire
        Inside: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Make a face from a surface and a wire.

        Parameters
        ----------
        F: TopoDS_Face
        W: TopoDS_Wire

        Return
        -------
        None

        Description
        -----------
        Adds the wire <w> in the face <f>.

        """
        _BRepLib.BRepLib_MakeFace_swiginit(self, _BRepLib.new_BRepLib_MakeFace(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        W: TopoDS_Wire

        Return
        -------
        None

        Description
        -----------
        Adds the wire <w> in the current face.

        """
        return _BRepLib.BRepLib_MakeFace_Add(self, *args)

    def Error(self, *args):
        r"""
        Return
        -------
        BRepLib_FaceError

        Description
        -----------
        No available documentation.

        """
        return _BRepLib.BRepLib_MakeFace_Error(self, *args)

    def Face(self, *args):
        r"""
        Return
        -------
        TopoDS_Face

        Description
        -----------
        Returns the new face.

        """
        return _BRepLib.BRepLib_MakeFace_Face(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Load the face.

        Parameters
        ----------
        S: Geom_Surface
        Bound: bool
        TolDegen: float

        Return
        -------
        None

        Description
        -----------
        Creates the face from the surface. if bound is true a wire is made from the natural bounds. accepts tolerance value (toldegen) for resolution of degenerated edges.

        Parameters
        ----------
        S: Geom_Surface
        UMin: float
        UMax: float
        VMin: float
        VMax: float
        TolDegen: float

        Return
        -------
        None

        Description
        -----------
        Creates the face from the surface and the min-max values. accepts tolerance value (toldegen) for resolution of degenerated edges.

        """
        return _BRepLib.BRepLib_MakeFace_Init(self, *args)

    @staticmethod
    def IsDegenerated(*args):
        r"""

        Parameters
        ----------
        theCurve: Geom_Curve
        theMaxTol: float

        Return
        -------
        theActTol: float

        Description
        -----------
        Checks the specified curve is degenerated according to specified tolerance. returns <theacttol> less than <themaxtol>, which shows actual tolerance to decide the curve is degenerated. warning: for internal use of breplib_makeface and breplib_makeshell.

        """
        return _BRepLib.BRepLib_MakeFace_IsDegenerated(*args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_MakeFace

# Register BRepLib_MakeFace in _BRepLib:
_BRepLib.BRepLib_MakeFace_swigregister(BRepLib_MakeFace)
class BRepLib_MakePolygon(BRepLib_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an empty makepolygon.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt
        P3: gp_Pnt
        Close: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt
        P3: gp_Pnt
        P4: gp_Pnt
        Close: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex
        V3: TopoDS_Vertex
        Close: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex
        V3: TopoDS_Vertex
        V4: TopoDS_Vertex
        Close: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BRepLib.BRepLib_MakePolygon_swiginit(self, _BRepLib.new_BRepLib_MakePolygon(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        P: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        V: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepLib.BRepLib_MakePolygon_Add(self, *args)

    def Added(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the last vertex or point was successfully added.

        """
        return _BRepLib.BRepLib_MakePolygon_Added(self, *args)

    def Close(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepLib.BRepLib_MakePolygon_Close(self, *args)

    def Edge(self, *args):
        r"""
        Return
        -------
        TopoDS_Edge

        Description
        -----------
        Returns the last edge added to the polygon.

        """
        return _BRepLib.BRepLib_MakePolygon_Edge(self, *args)

    def FirstVertex(self, *args):
        r"""
        Return
        -------
        TopoDS_Vertex

        Description
        -----------
        No available documentation.

        """
        return _BRepLib.BRepLib_MakePolygon_FirstVertex(self, *args)

    def LastVertex(self, *args):
        r"""
        Return
        -------
        TopoDS_Vertex

        Description
        -----------
        No available documentation.

        """
        return _BRepLib.BRepLib_MakePolygon_LastVertex(self, *args)

    def Wire(self, *args):
        r"""
        Return
        -------
        TopoDS_Wire

        Description
        -----------
        No available documentation.

        """
        return _BRepLib.BRepLib_MakePolygon_Wire(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_MakePolygon

# Register BRepLib_MakePolygon in _BRepLib:
_BRepLib.BRepLib_MakePolygon_swigregister(BRepLib_MakePolygon)
class BRepLib_MakeShell(BRepLib_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Not done.

        Parameters
        ----------
        S: Geom_Surface
        Segment: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: Geom_Surface
        UMin: float
        UMax: float
        VMin: float
        VMax: float
        Segment: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BRepLib.BRepLib_MakeShell_swiginit(self, _BRepLib.new_BRepLib_MakeShell(*args))

    def Error(self, *args):
        r"""
        Return
        -------
        BRepLib_ShellError

        Description
        -----------
        No available documentation.

        """
        return _BRepLib.BRepLib_MakeShell_Error(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        S: Geom_Surface
        UMin: float
        UMax: float
        VMin: float
        VMax: float
        Segment: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Creates the shell from the surface and the min-max values.

        """
        return _BRepLib.BRepLib_MakeShell_Init(self, *args)

    def Shell(self, *args):
        r"""
        Return
        -------
        TopoDS_Shell

        Description
        -----------
        Returns the new shell.

        """
        return _BRepLib.BRepLib_MakeShell_Shell(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_MakeShell

# Register BRepLib_MakeShell in _BRepLib:
_BRepLib.BRepLib_MakeShell_swigregister(BRepLib_MakeShell)
class BRepLib_MakeSolid(BRepLib_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Solid covers whole space.

        Parameters
        ----------
        S: TopoDS_CompSolid

        Return
        -------
        None

        Description
        -----------
        Make a solid from a compsolid.

        Parameters
        ----------
        S: TopoDS_Shell

        Return
        -------
        None

        Description
        -----------
        Make a solid from a shell.

        Parameters
        ----------
        S1: TopoDS_Shell
        S2: TopoDS_Shell

        Return
        -------
        None

        Description
        -----------
        Make a solid from two shells.

        Parameters
        ----------
        S1: TopoDS_Shell
        S2: TopoDS_Shell
        S3: TopoDS_Shell

        Return
        -------
        None

        Description
        -----------
        Make a solid from three shells.

        Parameters
        ----------
        So: TopoDS_Solid

        Return
        -------
        None

        Description
        -----------
        Make a solid from a solid. useful for adding later.

        Parameters
        ----------
        So: TopoDS_Solid
        S: TopoDS_Shell

        Return
        -------
        None

        Description
        -----------
        Add a shell to a solid.

        """
        _BRepLib.BRepLib_MakeSolid_swiginit(self, _BRepLib.new_BRepLib_MakeSolid(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shell

        Return
        -------
        None

        Description
        -----------
        Add the shell to the current solid.

        """
        return _BRepLib.BRepLib_MakeSolid_Add(self, *args)

    def Solid(self, *args):
        r"""
        Return
        -------
        TopoDS_Solid

        Description
        -----------
        Returns the new solid.

        """
        return _BRepLib.BRepLib_MakeSolid_Solid(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_MakeSolid

# Register BRepLib_MakeSolid in _BRepLib:
_BRepLib.BRepLib_MakeSolid_swigregister(BRepLib_MakeSolid)
class BRepLib_MakeVertex(BRepLib_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        P: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BRepLib.BRepLib_MakeVertex_swiginit(self, _BRepLib.new_BRepLib_MakeVertex(*args))

    def Vertex(self, *args):
        r"""
        Return
        -------
        TopoDS_Vertex

        Description
        -----------
        No available documentation.

        """
        return _BRepLib.BRepLib_MakeVertex_Vertex(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_MakeVertex

# Register BRepLib_MakeVertex in _BRepLib:
_BRepLib.BRepLib_MakeVertex_swigregister(BRepLib_MakeVertex)
class BRepLib_MakeWire(BRepLib_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Notdone makewire.

        Parameters
        ----------
        E: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        Make a wire from an edge.

        Parameters
        ----------
        E1: TopoDS_Edge
        E2: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        Make a wire from two edges.

        Parameters
        ----------
        E1: TopoDS_Edge
        E2: TopoDS_Edge
        E3: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        Make a wire from three edges.

        Parameters
        ----------
        E1: TopoDS_Edge
        E2: TopoDS_Edge
        E3: TopoDS_Edge
        E4: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        Make a wire from four edges.

        Parameters
        ----------
        W: TopoDS_Wire

        Return
        -------
        None

        Description
        -----------
        Make a wire from a wire. useful for adding later.

        Parameters
        ----------
        W: TopoDS_Wire
        E: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        Add an edge to a wire.

        """
        _BRepLib.BRepLib_MakeWire_swiginit(self, _BRepLib.new_BRepLib_MakeWire(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        Add the edge <e> to the current wire.

        Parameters
        ----------
        W: TopoDS_Wire

        Return
        -------
        None

        Description
        -----------
        Add the edges of <w> to the current wire.

        Parameters
        ----------
        L: TopTools_ListOfShape

        Return
        -------
        None

        Description
        -----------
        Add the edges of <l> to the current wire. the edges are not to be consecutive. but they are to be all connected geometrically or topologically.

        """
        return _BRepLib.BRepLib_MakeWire_Add(self, *args)

    def Edge(self, *args):
        r"""
        Return
        -------
        TopoDS_Edge

        Description
        -----------
        Returns the last edge added to the wire.

        """
        return _BRepLib.BRepLib_MakeWire_Edge(self, *args)

    def Error(self, *args):
        r"""
        Return
        -------
        BRepLib_WireError

        Description
        -----------
        No available documentation.

        """
        return _BRepLib.BRepLib_MakeWire_Error(self, *args)

    def Vertex(self, *args):
        r"""
        Return
        -------
        TopoDS_Vertex

        Description
        -----------
        Returns the last connecting vertex.

        """
        return _BRepLib.BRepLib_MakeWire_Vertex(self, *args)

    def Wire(self, *args):
        r"""
        Return
        -------
        TopoDS_Wire

        Description
        -----------
        Returns the new wire.

        """
        return _BRepLib.BRepLib_MakeWire_Wire(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_MakeWire

# Register BRepLib_MakeWire in _BRepLib:
_BRepLib.BRepLib_MakeWire_swigregister(BRepLib_MakeWire)



@deprecated
def breplib_BoundingVertex(*args):
	return breplib.BoundingVertex(*args)

@deprecated
def breplib_BuildCurve3d(*args):
	return breplib.BuildCurve3d(*args)

@deprecated
def breplib_BuildCurves3d(*args):
	return breplib.BuildCurves3d(*args)

@deprecated
def breplib_BuildCurves3d(*args):
	return breplib.BuildCurves3d(*args)

@deprecated
def breplib_BuildPCurveForEdgeOnPlane(*args):
	return breplib.BuildPCurveForEdgeOnPlane(*args)

@deprecated
def breplib_BuildPCurveForEdgeOnPlane(*args):
	return breplib.BuildPCurveForEdgeOnPlane(*args)

@deprecated
def breplib_CheckSameRange(*args):
	return breplib.CheckSameRange(*args)

@deprecated
def breplib_ContinuityOfFaces(*args):
	return breplib.ContinuityOfFaces(*args)

@deprecated
def breplib_EncodeRegularity(*args):
	return breplib.EncodeRegularity(*args)

@deprecated
def breplib_EncodeRegularity(*args):
	return breplib.EncodeRegularity(*args)

@deprecated
def breplib_EncodeRegularity(*args):
	return breplib.EncodeRegularity(*args)

@deprecated
def breplib_EnsureNormalConsistency(*args):
	return breplib.EnsureNormalConsistency(*args)

@deprecated
def breplib_ExtendFace(*args):
	return breplib.ExtendFace(*args)

@deprecated
def breplib_FindValidRange(*args):
	return breplib.FindValidRange(*args)

@deprecated
def breplib_FindValidRange(*args):
	return breplib.FindValidRange(*args)

@deprecated
def breplib_OrientClosedSolid(*args):
	return breplib.OrientClosedSolid(*args)

@deprecated
def breplib_Plane(*args):
	return breplib.Plane(*args)

@deprecated
def breplib_Plane(*args):
	return breplib.Plane(*args)

@deprecated
def breplib_Precision(*args):
	return breplib.Precision(*args)

@deprecated
def breplib_Precision(*args):
	return breplib.Precision(*args)

@deprecated
def breplib_ReverseSortFaces(*args):
	return breplib.ReverseSortFaces(*args)

@deprecated
def breplib_SameParameter(*args):
	return breplib.SameParameter(*args)

@deprecated
def breplib_SameParameter(*args):
	return breplib.SameParameter(*args)

@deprecated
def breplib_SameParameter(*args):
	return breplib.SameParameter(*args)

@deprecated
def breplib_SameParameter(*args):
	return breplib.SameParameter(*args)

@deprecated
def breplib_SameRange(*args):
	return breplib.SameRange(*args)

@deprecated
def breplib_SortFaces(*args):
	return breplib.SortFaces(*args)

@deprecated
def breplib_UpdateDeflection(*args):
	return breplib.UpdateDeflection(*args)

@deprecated
def breplib_UpdateEdgeTol(*args):
	return breplib.UpdateEdgeTol(*args)

@deprecated
def breplib_UpdateEdgeTolerance(*args):
	return breplib.UpdateEdgeTolerance(*args)

@deprecated
def breplib_UpdateInnerTolerances(*args):
	return breplib.UpdateInnerTolerances(*args)

@deprecated
def breplib_UpdateTolerances(*args):
	return breplib.UpdateTolerances(*args)

@deprecated
def breplib_UpdateTolerances(*args):
	return breplib.UpdateTolerances(*args)

@deprecated
def BRepLib_ToolTriangulatedShape_ComputeNormals(*args):
	return BRepLib_ToolTriangulatedShape.ComputeNormals(*args)

@deprecated
def BRepLib_ToolTriangulatedShape_ComputeNormals(*args):
	return BRepLib_ToolTriangulatedShape.ComputeNormals(*args)

@deprecated
def BRepLib_MakeFace_IsDegenerated(*args):
	return BRepLib_MakeFace.IsDegenerated(*args)



