/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.model;

import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.BadCiphertextException;
import com.amazonaws.encryptionsdk.exception.ParseException;
import com.amazonaws.encryptionsdk.internal.PrimitivesParser;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public final class CipherFrameHeaders {
    private int sequenceNumber_ = 0;
    private byte[] nonce_;
    private int frameContentLength_ = -1;
    private short nonceLength_ = 0;
    private boolean includeFrameSize_;
    private boolean isComplete_;
    private boolean isFinalFrame_;

    public CipherFrameHeaders() {
    }

    public CipherFrameHeaders(int sequenceNumber, byte[] nonce, int frameContentLen, boolean isFinal) {
        this.sequenceNumber_ = sequenceNumber;
        if (nonce == null) {
            throw new AwsCryptoException("Nonce cannot be null.");
        }
        if (nonce.length > 255) {
            throw new AwsCryptoException("Nonce length is greater than the maximum value of an unsigned byte.");
        }
        this.nonce_ = (byte[])nonce.clone();
        this.isFinalFrame_ = isFinal;
        this.frameContentLength_ = frameContentLen;
    }

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(outBytes);
            if (this.isFinalFrame_) {
                dataStream.writeInt(-1);
            }
            dataStream.writeInt(this.sequenceNumber_);
            dataStream.write(this.nonce_);
            if (this.includeFrameSize_ || this.isFinalFrame_) {
                dataStream.writeInt(this.frameContentLength_);
            }
            dataStream.close();
            return outBytes.toByteArray();
        }
        catch (IOException e) {
            throw new AwsCryptoException("Failed to serialize cipher frame headers", e);
        }
    }

    private int parseSequenceNumber(byte[] b, int off) throws ParseException {
        this.sequenceNumber_ = PrimitivesParser.parseInt(b, off);
        return 4;
    }

    private int parseNonce(byte[] b, int off) throws ParseException {
        int bytesToParseLen = b.length - off;
        if (bytesToParseLen >= this.nonceLength_) {
            this.nonce_ = Arrays.copyOfRange(b, off, off + this.nonceLength_);
            return this.nonceLength_;
        }
        throw new ParseException("Not enough bytes to parse nonce");
    }

    private int parseFrameContentLength(byte[] b, int off) throws ParseException {
        this.frameContentLength_ = PrimitivesParser.parseInt(b, off);
        if (this.frameContentLength_ < 0) {
            throw new BadCiphertextException("Invalid frame length in ciphertext");
        }
        return 4;
    }

    public int deserialize(byte[] b, int off) {
        if (b == null) {
            return 0;
        }
        int parsedBytes = 0;
        try {
            if (this.sequenceNumber_ == 0) {
                parsedBytes += this.parseSequenceNumber(b, off + parsedBytes);
            }
            if (this.sequenceNumber_ == -1 && !this.isFinalFrame_) {
                parsedBytes += this.parseSequenceNumber(b, off + parsedBytes);
                this.isFinalFrame_ = true;
            }
            if (this.nonceLength_ > 0 && this.nonce_ == null) {
                parsedBytes += this.parseNonce(b, off + parsedBytes);
            }
            if ((this.includeFrameSize_ || this.isFinalFrame_) && this.frameContentLength_ < 0) {
                parsedBytes += this.parseFrameContentLength(b, off + parsedBytes);
            }
            this.isComplete_ = true;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return parsedBytes;
    }

    public boolean isFinalFrame() {
        return this.isFinalFrame_;
    }

    public boolean isComplete() {
        return this.isComplete_;
    }

    public byte[] getNonce() {
        return this.nonce_ != null ? (byte[])this.nonce_.clone() : null;
    }

    public int getFrameContentLength() {
        return this.frameContentLength_;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber_;
    }

    public void setNonceLength(short nonceLength) {
        this.nonceLength_ = nonceLength;
    }

    public void includeFrameSize(boolean value) {
        this.includeFrameSize_ = true;
    }
}

