/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.monitor;

import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.monitor.ResourceMonitor;
import org.opensearch.sql.opensearch.monitor.OpenSearchMemoryHealthy;

public class OpenSearchResourceMonitor
extends ResourceMonitor {
    @Generated
    private static final Logger log = LogManager.getLogger(OpenSearchResourceMonitor.class);
    private final Settings settings;
    private final Retry retry;
    private final OpenSearchMemoryHealthy memoryMonitor;

    public OpenSearchResourceMonitor(Settings settings, OpenSearchMemoryHealthy memoryMonitor) {
        this.settings = settings;
        RetryConfig config = RetryConfig.custom().maxAttempts(3).intervalFunction(IntervalFunction.ofExponentialRandomBackoff((long)1000L)).retryExceptions(new Class[]{OpenSearchMemoryHealthy.MemoryUsageExceedException.class}).ignoreExceptions(new Class[]{OpenSearchMemoryHealthy.MemoryUsageExceedFastFailureException.class}).build();
        this.retry = Retry.of((String)"mem", (RetryConfig)config);
        this.memoryMonitor = memoryMonitor;
    }

    public boolean isHealthy() {
        try {
            ByteSizeValue limit = (ByteSizeValue)this.settings.getSettingValue(Settings.Key.QUERY_MEMORY_LIMIT);
            Supplier booleanSupplier = Retry.decorateSupplier((Retry)this.retry, () -> this.memoryMonitor.isMemoryHealthy(limit.getBytes()));
            return (Boolean)booleanSupplier.get();
        }
        catch (Exception e) {
            return false;
        }
    }
}

