/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.store.rca.admissioncontrol;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Field;
import org.opensearch.performanceanalyzer.commons.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.grpc.FlowUnitMessage;
import org.opensearch.performanceanalyzer.rca.configs.AdmissionControlRcaConfig;
import org.opensearch.performanceanalyzer.rca.framework.api.Metric;
import org.opensearch.performanceanalyzer.rca.framework.api.Rca;
import org.opensearch.performanceanalyzer.rca.framework.api.Resources;
import org.opensearch.performanceanalyzer.rca.framework.api.contexts.ResourceContext;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.MetricFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.persist.SQLParsingUtil;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotNodeSummary;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;
import org.opensearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import org.opensearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;
import org.opensearch.performanceanalyzer.rca.store.rca.admissioncontrol.heap.AdmissionControlByHeap;
import org.opensearch.performanceanalyzer.rca.store.rca.admissioncontrol.heap.AdmissionControlByHeapFactory;
import org.opensearch.performanceanalyzer.rca.store.rca.admissioncontrol.model.HeapMetric;
import org.opensearch.performanceanalyzer.util.range.Range;
import org.opensearch.performanceanalyzer.util.range.RangeConfiguration;
import org.opensearch.performanceanalyzer.util.range.RequestSizeHeapRangeConfiguration;

public class AdmissionControlRca
extends Rca<ResourceFlowUnit<HotNodeSummary>> {
    private static final Logger LOG = LogManager.getLogger(AdmissionControlRca.class);
    private static final double BYTES_TO_GIGABYTES = Math.pow(1024.0, 3.0);
    public static final String GLOBAL_JVMMP = "Global_JVMMP";
    public static final String REQUEST_SIZE = "Request_Size";
    private final Metric heapUsedValue;
    private final Metric heapMaxValue;
    private final RangeConfiguration requestSizeHeapRange;
    private final int rcaPeriod;
    private int counter = 0;

    public <M extends Metric> AdmissionControlRca(int rcaPeriodInSeconds, M heapUsedValue, M heapMaxValue) {
        super(rcaPeriodInSeconds);
        this.rcaPeriod = rcaPeriodInSeconds;
        this.heapUsedValue = heapUsedValue;
        this.heapMaxValue = heapMaxValue;
        this.requestSizeHeapRange = new RequestSizeHeapRangeConfiguration();
    }

    private <M extends Metric> double getMetric(M metric, Field<String> field, String fieldName) {
        double response = 0.0;
        for (MetricFlowUnit flowUnit : metric.getFlowUnits()) {
            double metricResponse;
            if (flowUnit.isEmpty() || Double.isNaN(metricResponse = SQLParsingUtil.readDataFromSqlResult(flowUnit.getData(), field, fieldName, "max")) || !(metricResponse > 0.0)) continue;
            response = metricResponse;
        }
        return response;
    }

    private HeapMetric getHeapMetric() {
        double usedHeapInGb = this.getMetric(this.heapUsedValue, (Field<String>)AllMetrics.HeapDimension.MEM_TYPE.getField(), AllMetrics.GCType.HEAP.toString()) / BYTES_TO_GIGABYTES;
        double maxHeapInGb = this.getMetric(this.heapMaxValue, (Field<String>)AllMetrics.HeapDimension.MEM_TYPE.getField(), AllMetrics.GCType.HEAP.toString()) / BYTES_TO_GIGABYTES;
        return new HeapMetric(usedHeapInGb, maxHeapInGb);
    }

    @Override
    public void readRcaConf(RcaConf conf) {
        AdmissionControlRcaConfig rcaConfig = conf.getAdmissionControlRcaConfig();
        AdmissionControlRcaConfig.ControllerConfig requestSizeConfig = rcaConfig.getRequestSizeControllerConfig();
        List<Range> requestSizeHeapRangeConfiguration = requestSizeConfig.getHeapRangeConfiguration();
        if (requestSizeHeapRangeConfiguration != null && requestSizeHeapRangeConfiguration.size() > 0) {
            this.requestSizeHeapRange.setRangeConfiguration(requestSizeHeapRangeConfiguration);
        }
    }

    @Override
    public ResourceFlowUnit<HotNodeSummary> operate() {
        long currentTimeMillis = System.currentTimeMillis();
        ++this.counter;
        if (this.counter < this.rcaPeriod) {
            return new ResourceFlowUnit<HotNodeSummary>(currentTimeMillis);
        }
        this.counter = 0;
        InstanceDetails instanceDetails = this.getInstanceDetails();
        HotNodeSummary nodeSummary = new HotNodeSummary(instanceDetails.getInstanceId(), instanceDetails.getInstanceIp());
        HeapMetric heapMetric = this.getHeapMetric();
        if (!heapMetric.hasValues()) {
            return new ResourceFlowUnit<HotNodeSummary>(currentTimeMillis, new ResourceContext(Resources.State.HEALTHY), nodeSummary, !instanceDetails.getIsClusterManager());
        }
        AdmissionControlByHeap admissionControlByHeap = AdmissionControlByHeapFactory.getByMaxHeap(heapMetric.getMaxHeap());
        admissionControlByHeap.init(instanceDetails, this.requestSizeHeapRange);
        return admissionControlByHeap.generateFlowUnits(heapMetric);
    }

    public RangeConfiguration getRequestSizeHeapRange() {
        return this.requestSizeHeapRange;
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
        List<FlowUnitMessage> flowUnitMessages = args.getWireHopper().readFromWire(args.getNode());
        ArrayList flowUnitList = new ArrayList();
        LOG.debug("rca: Executing fromWire: {}", (Object)this.getClass().getSimpleName());
        for (FlowUnitMessage flowUnitMessage : flowUnitMessages) {
            flowUnitList.add(ResourceFlowUnit.buildFlowUnitFromWrapper(flowUnitMessage));
        }
        this.setFlowUnits(flowUnitList);
    }
}

