/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.net;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.CertificateUtils;
import org.opensearch.performanceanalyzer.commons.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.grpc.InterNodeRpcServiceGrpc;
import org.opensearch.performanceanalyzer.rca.framework.util.InstanceDetails;

public class GRPCConnectionManager {
    private static final Logger LOG = LogManager.getLogger(GRPCConnectionManager.class);
    private static final int MAX_RETRY_ATTEMPTS = 2;
    private final int port;
    private File certFile;
    private File pkeyFile;
    private File trustedCasFile;
    private ConcurrentMap<InstanceDetails.Id, AtomicReference<ManagedChannel>> perHostChannelMap = new ConcurrentHashMap<InstanceDetails.Id, AtomicReference<ManagedChannel>>();
    private ConcurrentMap<InstanceDetails.Id, AtomicReference<InterNodeRpcServiceGrpc.InterNodeRpcServiceStub>> perHostClientStubMap = new ConcurrentHashMap<InstanceDetails.Id, AtomicReference<InterNodeRpcServiceGrpc.InterNodeRpcServiceStub>>();
    private final boolean shouldUseHttps;

    public GRPCConnectionManager(boolean shouldUseHttps) {
        this.shouldUseHttps = shouldUseHttps;
        this.port = 0;
        if (shouldUseHttps) {
            this.certFile = CertificateUtils.getClientCertificateFile();
            this.pkeyFile = CertificateUtils.getClientPrivateKeyFile();
            this.trustedCasFile = CertificateUtils.getClientTrustedCasFile();
        }
    }

    public GRPCConnectionManager(boolean shouldUseHttps, int port) {
        this.shouldUseHttps = shouldUseHttps;
        this.port = port;
        if (shouldUseHttps) {
            this.certFile = CertificateUtils.getClientCertificateFile();
            this.pkeyFile = CertificateUtils.getClientPrivateKeyFile();
            this.trustedCasFile = CertificateUtils.getClientTrustedCasFile();
        }
    }

    @VisibleForTesting
    public ConcurrentMap<InstanceDetails.Id, AtomicReference<ManagedChannel>> getPerHostChannelMap() {
        return this.perHostChannelMap;
    }

    @VisibleForTesting
    public ConcurrentMap<InstanceDetails.Id, AtomicReference<InterNodeRpcServiceGrpc.InterNodeRpcServiceStub>> getPerHostClientStubMap() {
        return this.perHostClientStubMap;
    }

    public InterNodeRpcServiceGrpc.InterNodeRpcServiceStub getClientStubForHost(InstanceDetails remoteHost) {
        AtomicReference stubAtomicReference = (AtomicReference)this.perHostClientStubMap.get(remoteHost.getInstanceId());
        if (stubAtomicReference != null) {
            return (InterNodeRpcServiceGrpc.InterNodeRpcServiceStub)((Object)stubAtomicReference.get());
        }
        return this.addOrUpdateClientStubForHost(remoteHost);
    }

    private synchronized InterNodeRpcServiceGrpc.InterNodeRpcServiceStub addOrUpdateClientStubForHost(InstanceDetails remoteHost) {
        InterNodeRpcServiceGrpc.InterNodeRpcServiceStub stub = this.buildStubForHost(remoteHost);
        this.perHostClientStubMap.computeIfAbsent(remoteHost.getInstanceId(), s -> new AtomicReference());
        ((AtomicReference)this.perHostClientStubMap.get(remoteHost.getInstanceId())).set(stub);
        return stub;
    }

    public void shutdown() {
        this.removeAllStubs();
        this.terminateAllConnections();
    }

    private ManagedChannel getChannelForHost(InstanceDetails remoteHost) {
        AtomicReference managedChannelAtomicReference = (AtomicReference)this.perHostChannelMap.get(remoteHost.getInstanceId());
        if (managedChannelAtomicReference != null) {
            return (ManagedChannel)managedChannelAtomicReference.get();
        }
        return this.addOrUpdateChannelForHost(remoteHost);
    }

    private synchronized ManagedChannel addOrUpdateChannelForHost(InstanceDetails remoteHost) {
        ManagedChannel channel = this.buildChannelForHost(remoteHost);
        this.perHostChannelMap.computeIfAbsent(remoteHost.getInstanceId(), s -> new AtomicReference());
        ((AtomicReference)this.perHostChannelMap.get(remoteHost.getInstanceId())).set(channel);
        return channel;
    }

    private ManagedChannel buildChannelForHost(InstanceDetails remoteHost) {
        return this.shouldUseHttps ? this.buildSecureChannel(remoteHost) : this.buildInsecureChannel(remoteHost);
    }

    private int getPortFromHost(InstanceDetails remoteHost) {
        int port;
        int n = port = this.port != 0 ? this.port : remoteHost.getGrpcPort();
        if (port == -1) {
            throw new IllegalArgumentException("Invalid port for grpc: " + port);
        }
        return port;
    }

    private ManagedChannel buildInsecureChannel(InstanceDetails remoteHost) {
        return ManagedChannelBuilder.forAddress((String)remoteHost.getInstanceIp().toString(), (int)this.getPortFromHost(remoteHost)).usePlaintext().enableRetry().maxRetryAttempts(2).build();
    }

    private ManagedChannel buildSecureChannel(InstanceDetails remoteHost) {
        try {
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient().keyManager(this.certFile, this.pkeyFile);
            if (this.trustedCasFile != null) {
                sslContextBuilder.trustManager(this.trustedCasFile);
            }
            return ((NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)remoteHost.getInstanceIp().toString(), (int)this.getPortFromHost(remoteHost)).sslContext(sslContextBuilder.build()).enableRetry()).maxRetryAttempts(2)).build();
        }
        catch (SSLException e) {
            LOG.error("Unable to build an SSL gRPC client.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private InterNodeRpcServiceGrpc.InterNodeRpcServiceStub buildStubForHost(InstanceDetails remoteHost) {
        return InterNodeRpcServiceGrpc.newStub((Channel)this.getChannelForHost(remoteHost));
    }

    private void removeAllStubs() {
        for (Map.Entry entry : this.perHostClientStubMap.entrySet()) {
            LOG.debug("Removing client stub for host: {}", entry.getKey());
            this.perHostClientStubMap.remove(entry.getKey());
        }
    }

    private void terminateAllConnections() {
        for (Map.Entry entry : this.perHostChannelMap.entrySet()) {
            LOG.debug("shutting down connection to host: {}", entry.getKey());
            ManagedChannel channel = (ManagedChannel)((AtomicReference)entry.getValue()).get();
            channel.shutdownNow();
            try {
                if (!channel.awaitTermination(1L, TimeUnit.MINUTES)) {
                    StatsCollector.instance().logException(StatExceptionCode.GRPC_CHANNEL_CLOSURE_ERROR);
                    LOG.warn("Unable to close channel gracefully for host: {}", entry.getKey());
                }
            }
            catch (InterruptedException e) {
                LOG.warn("Channel interrupted while shutting down", (Throwable)e);
                channel.shutdownNow();
                Thread.currentThread().interrupt();
            }
            this.perHostChannelMap.remove(entry.getKey());
        }
    }

    public void terminateConnection(InstanceDetails.Id remoteHost) {
        this.perHostClientStubMap.remove(remoteHost);
        this.perHostChannelMap.remove(remoteHost);
    }
}

