/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.commons.stats.eval.impl.vals;

import java.util.Objects;
import org.opensearch.performanceanalyzer.commons.stats.eval.Statistics;
import org.opensearch.performanceanalyzer.commons.stats.eval.impl.vals.AggregateValue;
import org.opensearch.performanceanalyzer.commons.stats.format.Formatter;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;

public class NamedAggregateValue
extends AggregateValue {
    private String name;

    public NamedAggregateValue(Number value, Statistics type, String name) {
        super(value, type);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void format(Formatter formatter, MeasurementSet measurementSet, Statistics stats) {
        formatter.formatNamedAggregatedValue(measurementSet, this.getAggregationType(), this.getName(), this.getValue());
    }

    public void update(Number value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedAggregateValue that = (NamedAggregateValue)o;
        return Objects.equals(this.name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name);
    }

    @Override
    public String toString() {
        return "NamedAggregateValue{name='" + this.name + "', aggr='" + this.getAggregationType() + "', value=" + this.value + "}";
    }
}

