/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayPrefixListReferencesRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayPrefixListReferencesResponse;
import software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReference;

public class GetTransitGatewayPrefixListReferencesPublisher
implements SdkPublisher<GetTransitGatewayPrefixListReferencesResponse> {
    private final Ec2AsyncClient client;
    private final GetTransitGatewayPrefixListReferencesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetTransitGatewayPrefixListReferencesPublisher(Ec2AsyncClient client, GetTransitGatewayPrefixListReferencesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetTransitGatewayPrefixListReferencesPublisher(Ec2AsyncClient client, GetTransitGatewayPrefixListReferencesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetTransitGatewayPrefixListReferencesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetTransitGatewayPrefixListReferencesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TransitGatewayPrefixListReference> transitGatewayPrefixListReferences() {
        Function<GetTransitGatewayPrefixListReferencesResponse, Iterator> getIterator = response -> {
            if (response != null && response.transitGatewayPrefixListReferences() != null) {
                return response.transitGatewayPrefixListReferences().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetTransitGatewayPrefixListReferencesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetTransitGatewayPrefixListReferencesResponseFetcher
    implements AsyncPageFetcher<GetTransitGatewayPrefixListReferencesResponse> {
        private GetTransitGatewayPrefixListReferencesResponseFetcher() {
        }

        public boolean hasNextPage(GetTransitGatewayPrefixListReferencesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetTransitGatewayPrefixListReferencesResponse> nextPage(GetTransitGatewayPrefixListReferencesResponse previousPage) {
            if (previousPage == null) {
                return GetTransitGatewayPrefixListReferencesPublisher.this.client.getTransitGatewayPrefixListReferences(GetTransitGatewayPrefixListReferencesPublisher.this.firstRequest);
            }
            return GetTransitGatewayPrefixListReferencesPublisher.this.client.getTransitGatewayPrefixListReferences((GetTransitGatewayPrefixListReferencesRequest)((Object)GetTransitGatewayPrefixListReferencesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

